/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.silk.base.AbstractHistogramElement;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.RangeMerger;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.text.SASFormat;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Vector;

public class HistElement
extends AbstractHistogramElement {
    protected SILKNumber frequencyRole = null;
    protected SILKNumber statTypeRole = null;
    protected int numberOfXBins = 10;
    protected int numberOfYBins = 10;
    protected int boundary = 0;
    protected static SILKNumber statName_Frequency = new SILKNumber(0, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Frequency.txt", (String)"Frequency"), "Frequency");
    protected static SILKNumber statName_Percent = new SILKNumber(1, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Percent.txt", (String)"Percent"), "Percent");
    protected int statType = 12;
    protected long totalCount = 0L;
    protected int totalMissingCount = 0;
    protected boolean binToDataRange = false;
    protected static final int[] supportedHistProps = new int[]{803, 805, 806, 810, 811, 807, 819, 836, 824, 826, 827, 828, 832, 834, 833, 835, 24, 25, 23, 433, 426, 434, 441, 19055, 19054};

    public HistElement() {
        this.rampName = "ThreeColorRamp";
        this.xBoundary = this.yBoundary = this.boundary;
        this.numberOfBins_X = this.numberOfXBins;
        this.numberOfBins_Y = this.numberOfYBins;
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 1);
        this.addBuildRole(this.xRole);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1);
        this.roles.setRoleType((Object)this.yRole, 1);
        this.addBuildRole(this.yRole);
        this.frequencyRole = this.role.getRoleObject("ROLE_FREQUENCY");
        this.roles.newRole((Object)this.frequencyRole, "Frequency", 1);
        this.roles.setRoleType((Object)this.frequencyRole, 1);
        this.addBuildRole(this.frequencyRole);
        this.statTypeRole = this.role.getRoleObject("ROLE_STATISTIC_TYPE");
        this.setSupportedProperties(supportedHistProps);
        this.userSetProperties.appendProperties(supportedHistProps);
        this.addChartTabInfo("com.sas.graphics.silk.ui.HistElementPanel", ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"HistogramElement.Histogram.txt", (String)"Histogram"));
    }

    @Override
    protected double computePercentage(double val) {
        double value = val;
        if (this.statType == 11) {
            long nobs = this.missingBinOn ? this.totalCount : this.totalCount - (long)this.totalMissingCount;
            value = nobs > 0L ? 100.0 * value / (double)nobs : 0.0;
        }
        return value;
    }

    @Override
    public Object getVariable(Object role) {
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            return this.getStatisticType();
        }
        return super.getVariable(role);
    }

    @Override
    public Object getAllVariables(Object role) {
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            return new Object[]{this.getStatisticType()};
        }
        return super.getAllVariables(role);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            if (this.getStatisticType().toString().equalsIgnoreCase(variableId.toString()) || this.getStatisticType().getEnglishName().equalsIgnoreCase(variableId.toString())) {
                return true;
            }
            this.setStatisticType(variableId.toString());
            this.currentLegend = this.getStatisticType();
            this.fireBuildEvents();
            this.fireLayerListenerChanged(7);
            this.fireLayerListenerChanged(3);
            return true;
        }
        return super.setRole(variableId, role);
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            if (this.getStatisticType().getEnglishName().equalsIgnoreCase(variableId.toString()) || this.getStatisticType().toString().equalsIgnoreCase(variableId.toString())) {
                return true;
            }
            this.setStatisticType(variableId.toString());
            this.currentLegend = this.getStatisticType();
            this.fireBuildEvents();
            this.fireLayerListenerChanged(7);
            this.fireLayerListenerChanged(3);
            return true;
        }
        return super.addRole(variableId, role);
    }

    @Override
    protected SILKNumber getLegendName() {
        return this.getStatisticType();
    }

    @Override
    protected String getLegendDisplayName() {
        return this.getStatisticType().toString();
    }

    public SILKNumber getStatisticType() {
        switch (this.statType) {
            default: {
                return statName_Frequency;
            }
            case 11: 
        }
        return statName_Percent;
    }

    public void setStatisticType(String type) {
        if (type == null) {
            return;
        }
        this.statType = "PERCENT".equalsIgnoreCase(type) || statName_Percent.toString().equalsIgnoreCase(type) || statName_Percent.getEnglishName().equalsIgnoreCase(type) ? 11 : 12;
    }

    @Override
    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 38: {
                Object obj = this.roles.getVariable((Object)this.statTypeRole);
                if (obj == null) break;
                this.setStatisticType(obj.toString());
            }
        }
    }

    @Override
    protected void removeRole(RoleEvent e) {
    }

    @Override
    protected boolean buildBiVariateBins() {
        if (this.filter == null || this.xDataRange == null || this.yDataRange == null) {
            return false;
        }
        ContinuousRange cxr = (ContinuousRange)this.xDataRange;
        ContinuousRange cyr = (ContinuousRange)this.yDataRange;
        if (!this.isVertical()) {
            cxr = (ContinuousRange)this.yDataRange;
            cyr = (ContinuousRange)this.xDataRange;
        }
        if (Double.isNaN(cxr.getMin()) || Double.isNaN(cxr.getMax()) || Double.isNaN(cyr.getMin()) || Double.isNaN(cyr.getMax())) {
            this.rebuildRequired = true;
            return false;
        }
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Object yVar = this.roles.getVariable((Object)this.yRole, 0);
        if (xVar == null || yVar == null) {
            return false;
        }
        int xVarIndex = this.filter.getVariableIndex(xVar);
        int yVarIndex = this.filter.getVariableIndex(yVar);
        if (xVarIndex < 0 || yVarIndex < 0) {
            return false;
        }
        if (this.binToDataRange) {
            ContinuousRange cr = this.getDataRange(xVar);
            if (cr != null) {
                cxr = cr;
            }
            if ((cr = this.getDataRange(yVar)) != null) {
                cyr = cr;
            }
        }
        this.numberOfBins_X = this.xBinNames != null ? this.xBinNames.length - 1 : this.numberOfXBins;
        this.numberOfBins_Y = this.yBinNames != null ? this.yBinNames.length - 1 : this.numberOfYBins;
        if (this.filter.getNumberObservations(-1) < 1) {
            return false;
        }
        double[] temp = new double[2];
        this.xBins = this.createBins(cxr, this.numberOfBins_X, this.xBinNames, this.xBins, temp);
        this.xBinStart = temp[0];
        this.xBinEnd = temp[1];
        this.yBins = this.createBins(cyr, this.numberOfBins_Y, this.yBinNames, this.yBins, temp);
        this.yBinStart = temp[0];
        this.yBinEnd = temp[1];
        this.bivariateBinValues = new double[this.xBins.size()][this.yBins.size()];
        this.missingXBinValues = new double[this.yBins.size()];
        this.missingYBinValues = new double[this.xBins.size()];
        this.missingValues = 0.0;
        Object frequencyVar = this.roles.getVariable((Object)this.frequencyRole, 0);
        int frequencyVarIndex = this.filter.getVariableIndex(frequencyVar);
        this.totalCount = 0L;
        this.totalMissingCount = 0;
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            double xValue = this.filter.getNumericValue(xVarIndex, (long)i);
            int xBin = this.getBinIndex(this.xBins, this.xBinStart, this.xBinEnd, xValue, this.boundary, this.xBinNames == null);
            double yValue = this.filter.getNumericValue(yVarIndex, (long)i);
            int yBin = this.getBinIndex(this.yBins, this.yBinStart, this.yBinEnd, yValue, this.boundary, this.yBinNames == null);
            int count = this.getFrequencyCount(i, frequencyVarIndex);
            this.totalCount += (long)count;
            if (-3 == xBin || -3 == yBin) {
                this.totalMissingCount += count;
                if (-3 == xBin && -3 == yBin) {
                    this.missingValues += (double)count;
                    continue;
                }
                if (-3 == xBin && yBin >= 0) {
                    int n = yBin;
                    this.missingXBinValues[n] = this.missingXBinValues[n] + (double)count;
                    continue;
                }
                if (-3 != yBin || xBin < 0) continue;
                int n = xBin;
                this.missingYBinValues[n] = this.missingYBinValues[n] + (double)count;
                continue;
            }
            if (xBin < 0 || yBin < 0) continue;
            double[] dArray = this.bivariateBinValues[xBin];
            int n = yBin;
            dArray[n] = dArray[n] + (double)count;
        }
        return true;
    }

    @Override
    protected boolean buildUniVariateBins() {
        if (this.filter == null) {
            return false;
        }
        if (this.isVertical() && this.xDataRange == null) {
            return false;
        }
        if (!this.isVertical() && this.yDataRange == null) {
            return false;
        }
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return false;
        }
        int xVarIndex = this.filter.getVariableIndex(xVar);
        if (xVarIndex < 0) {
            return false;
        }
        ContinuousRange cr = null;
        if (this.binToDataRange) {
            ContinuousRange cr2 = this.getDataRange(xVar);
            if (cr2 != null) {
                cr = cr2;
            }
        } else {
            cr = this.isVertical() ? (ContinuousRange)this.xDataRange : (ContinuousRange)this.yDataRange;
        }
        if (Double.isNaN(cr.getMin()) || Double.isNaN(cr.getMax())) {
            this.rebuildRequired = true;
            return false;
        }
        this.numberOfBins_X = this.xBinNames != null ? this.xBinNames.length - 1 : this.numberOfXBins;
        double[] temp = new double[2];
        this.xBins = this.createBins(cr, this.numberOfBins_X, this.xBinNames, this.xBins, temp);
        this.xBinStart = temp[0];
        this.xBinEnd = temp[1];
        if (this.filter.getNumberObservations(-1) < 1) {
            return false;
        }
        int xBin = -3;
        this.univariateBinValues = new double[this.xBins.size()];
        this.missingValues = 0.0;
        Object frequencyVar = this.roles.getVariable((Object)this.frequencyRole, 0);
        int frequencyVarIndex = this.filter.getVariableIndex(frequencyVar);
        this.totalCount = 0L;
        this.totalMissingCount = 0;
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            double xValue = this.filter.getNumericValue(xVarIndex, (long)i);
            xBin = this.getBinIndex(this.xBins, this.xBinStart, this.xBinEnd, xValue, this.boundary, this.xBinNames == null);
            int count = this.getFrequencyCount(i, frequencyVarIndex);
            this.totalCount += (long)count;
            if (-3 == xBin) {
                this.missingValues += (double)count;
                this.totalMissingCount += count;
                continue;
            }
            if (xBin < 0) continue;
            int n = xBin;
            this.univariateBinValues[n] = this.univariateBinValues[n] + (double)count;
            ((AbstractHistogramElement.Bin)this.xBins.get(new Integer(xBin))).setCount((int)this.univariateBinValues[xBin]);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getBinIndex(LinkedHashMap bins, double binStart, double binEnd, double value, int boundary, boolean equalSpacedBins) {
        if (Double.isNaN(value)) {
            return -3;
        }
        if (bins == null || bins.size() < 1) {
            return -1;
        }
        if (value < binStart) {
            return -1;
        }
        if (value > binEnd) {
            return -2;
        }
        if (equalSpacedBins) {
            int startIndex;
            AbstractHistogramElement.Bin b = (AbstractHistogramElement.Bin)bins.get(new Integer(0));
            if (!(b.getMax() - b.getMin() > 0.0)) return 0;
            for (int i = startIndex = (int)((value - binStart) / (b.getMax() - b.getMin()) - 1.0); i < bins.size(); ++i) {
                b = (AbstractHistogramElement.Bin)bins.get(new Integer(i));
                if (b == null || !b.contains(value, boundary)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < bins.size(); ++i) {
                AbstractHistogramElement.Bin b = (AbstractHistogramElement.Bin)bins.get(new Integer(i));
                if (!b.contains(value, boundary)) continue;
                return i;
            }
        }
        if (!(value <= binEnd)) return -2;
        return bins.size() - 1;
    }

    protected int getFrequencyCount(int obs, int frequencyVarIndex) {
        int count = 1;
        if (this.filter != null && frequencyVarIndex >= 0) {
            count = (int)this.filter.getNumericValue(frequencyVarIndex, (long)obs);
        }
        if (count < 0) {
            count = 0;
        }
        return count;
    }

    protected LinkedHashMap createBins(ContinuousRange dataRange, int numBins, double[] binNames, LinkedHashMap bins, double[] binMinMax) {
        if (bins == null) {
            bins = new LinkedHashMap<Integer, AbstractHistogramElement.Bin>();
        } else {
            bins.clear();
        }
        binMinMax[0] = 0.0;
        binMinMax[1] = 0.0;
        if (binNames != null) {
            for (int i = 1; i < binNames.length; ++i) {
                double binMin = binNames[i - 1];
                double binMax = binNames[i];
                AbstractHistogramElement.Bin b = new AbstractHistogramElement.Bin();
                b.setMin(binMin);
                b.setMax(binMax);
                b.setCount(0.0);
                b.setIndex(i - 1);
                bins.put(new Integer(i - 1), b);
            }
            binMinMax[0] = binNames[0];
            binMinMax[1] = binNames[binNames.length - 1];
        } else {
            double min = dataRange.getMin();
            double max = dataRange.getMax();
            double step = (max - min) / (double)numBins;
            for (int i = 0; i < numBins; ++i) {
                double binMin = min + (double)i * step;
                double binMax = min + (double)(i + 1) * step;
                AbstractHistogramElement.Bin b = new AbstractHistogramElement.Bin();
                b.setMin(binMin);
                b.setMax(binMax);
                b.setCount(0.0);
                b.setIndex(i);
                bins.put(new Integer(i), b);
            }
            binMinMax[0] = min;
            binMinMax[1] = max;
        }
        return bins;
    }

    @Override
    protected boolean hasRangeChanged(byte dim) {
        if (this.isVertical() ? this.binToDataRange && (1 == dim || this.bivariate && 2 == dim) : this.binToDataRange && (2 == dim || this.bivariate && 1 == dim)) {
            return false;
        }
        return super.hasRangeChanged(dim);
    }

    protected ContinuousRange getDataRange(Object var) {
        if (var == null || this.infoFilter == null) {
            return null;
        }
        double min = 0.0;
        double max = 0.0;
        Object o = this.infoFilter.getMinimumValue(var);
        if (o instanceof Number) {
            min = ((Number)o).doubleValue();
        }
        if ((o = this.infoFilter.getMaximumValue(var)) instanceof Number) {
            max = ((Number)o).doubleValue();
        }
        return new ContinuousRange(min, max);
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (which == null || this.filter == null) {
            return null;
        }
        Object role = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        DataRange range = null;
        while (rolesEnum.hasMoreElements()) {
            role = rolesEnum.nextElement();
            if (role == null) continue;
            if (this.rebuildRequired) {
                this.build(Boolean.TRUE);
            }
            if (!this.bivariate && role != null && RoleInterface.ROLE_Y.equals(role)) {
                if (this.univariateBinValues == null) continue;
                double min = 0.0;
                double max = 0.0;
                for (int i = 0; i < this.univariateBinValues.length; ++i) {
                    max = Math.max(this.univariateBinValues[i], max);
                }
                if (this.missingBinOn) {
                    max = Math.max(this.missingValues, max);
                }
                max = this.computePercentage(max);
                ContinuousRange cr = new ContinuousRange(min, max);
                range = RangeMerger.mergeRange(range, (DataRange)cr);
                continue;
            }
            if (role == null || !RoleInterface.ROLE_X.equals(role) || this.xBinNames == null || Double.isNaN(this.xBinStart) || Double.isNaN(this.xBinEnd)) continue;
            range = RangeMerger.mergeRange(range, (DataRange)new ContinuousRange(this.xBinStart, this.xBinEnd));
        }
        if (range != null) {
            return range;
        }
        return super.getPreferredRange(which);
    }

    @Override
    protected LinkedHashMap buildBinSelectionCountMap(SelectionIterator selections) {
        LinkedHashMap<Integer, Serializable> binSelectionCount;
        block7: {
            int frequencyVarIndex;
            block6: {
                binSelectionCount = new LinkedHashMap<Integer, Serializable>();
                if (selections == null || !selections.hasMoreSelections()) {
                    return binSelectionCount;
                }
                Object frequencyVar = this.roles.getVariable((Object)this.frequencyRole, 0);
                frequencyVarIndex = this.filter.getVariableIndex(frequencyVar);
                if (!this.bivariate || this.bivariateBinValues == null) break block6;
                int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
                int yVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yRole, 0));
                while (selections.hasMoreSelections()) {
                    LinkedHashMap bsc2;
                    int index = selections.nextSelectedIndex();
                    double xValue = this.filter.getNumericValue(xVarIndex, (long)index);
                    int xBinIndex = this.getBinIndex(this.xBins, this.xBinStart, this.xBinEnd, xValue, this.boundary, this.xBinNames == null);
                    Integer xBinId = new Integer(xBinIndex);
                    double yValue = this.filter.getNumericValue(yVarIndex, (long)index);
                    int yBinIndex = this.getBinIndex(this.yBins, this.yBinStart, this.yBinEnd, yValue, this.boundary, this.yBinNames == null);
                    Integer yBinId = new Integer(yBinIndex);
                    int count = this.getFrequencyCount(index, frequencyVarIndex);
                    if (!binSelectionCount.containsKey(xBinId)) {
                        binSelectionCount.put(xBinId, new LinkedHashMap());
                    }
                    if ((bsc2 = (LinkedHashMap)binSelectionCount.get(xBinId)).containsKey(yBinId)) {
                        int selectedCount = ((Number)bsc2.get(yBinId)).intValue() + count;
                        bsc2.put(yBinId, new Integer(selectedCount));
                        continue;
                    }
                    bsc2.put(yBinId, new Integer(count));
                }
                break block7;
            }
            if (this.univariateBinValues == null) break block7;
            int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
            while (selections.hasMoreSelections()) {
                int index = selections.nextSelectedIndex();
                double value = this.filter.getNumericValue(xVarIndex, (long)index);
                int binIndex = this.getBinIndex(this.xBins, this.xBinStart, this.xBinEnd, value, this.boundary, this.xBinNames == null);
                int count = this.getFrequencyCount(index, frequencyVarIndex);
                Integer binId = new Integer(binIndex);
                if (binSelectionCount.containsKey(binId)) {
                    int selectedCount = ((Number)binSelectionCount.get(binId)).intValue() + count;
                    binSelectionCount.put(binId, new Integer(selectedCount));
                    continue;
                }
                binSelectionCount.put(binId, new Integer(count));
            }
        }
        return binSelectionCount;
    }

    @Override
    protected String getStatTipValue(double value) {
        StringBuffer sb = new StringBuffer();
        SASFormat nf = null;
        if (this.statType == 11) {
            sb.append(this.userComputedResponseLabel == null ? statName_Percent.toString() : this.userComputedResponseLabel);
            value = this.computePercentage(value) / 100.0;
            nf = SASFormat.getInstance((String)"Percent8.2");
        } else {
            sb.append(this.userComputedResponseLabel == null ? statName_Frequency.toString() : this.userComputedResponseLabel);
            nf = SASFormat.getInstance((String)"Best8.0");
        }
        sb.append(" \t= \t");
        sb.append(nf.format((Object)new Double(value)));
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 19054: {
                if (this.isVertical()) {
                    if (this.bivariate) {
                        rc = super.getPropertyValue(id);
                        break;
                    }
                    if (this.statType == 11) {
                        rc = this.defaults.defaultNumericFormat;
                        break;
                    }
                    rc = SASFormat.getInstance((String)"F2.0");
                    break;
                }
                rc = this.getFormat((Object)this.xRole);
                break;
            }
            case 19052: {
                if (this.isVertical()) {
                    if (this.bivariate) {
                        rc = super.getPropertyValue(id);
                        break;
                    }
                    if (this.userComputedResponseLabel != null) {
                        rc = this.userComputedResponseLabel;
                        break;
                    }
                    if (this.statType == 11) {
                        rc = statName_Percent;
                        break;
                    }
                    rc = statName_Frequency;
                    break;
                }
                rc = this.getVariableDescription((Object)this.xRole);
                break;
            }
            case 19055: {
                if (this.isVertical()) {
                    rc = super.getPropertyValue(id);
                    break;
                }
                if (this.bivariate) {
                    rc = this.getFormat((Object)this.yRole);
                    break;
                }
                if (this.statType == 11) {
                    rc = this.defaults.defaultNumericFormat;
                    break;
                }
                rc = SASFormat.getInstance((String)"F2.0");
                break;
            }
            case 19053: {
                if (this.isVertical()) {
                    rc = super.getPropertyValue(id);
                    break;
                }
                if (this.bivariate) {
                    rc = this.getVariableDescription((Object)this.yRole);
                    break;
                }
                if (this.userComputedResponseLabel != null) {
                    rc = this.userComputedResponseLabel;
                    break;
                }
                if (this.statType == 11) {
                    rc = statName_Percent;
                    break;
                }
                rc = statName_Frequency;
                break;
            }
            case 828: {
                rc = Boolean.TRUE;
                break;
            }
            case 805: {
                rc = new Integer(this.getNumberOfXBins());
                break;
            }
            case 806: {
                rc = new Integer(this.getNumberOfYBins());
                break;
            }
            case 832: {
                rc = new Integer(this.boundary);
                break;
            }
            case 835: {
                rc = this.isBinnedToDataRange() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 19078: {
                if (this.roles.getVariable((Object)this.xRole, 0) != null) {
                    rc = Boolean.TRUE;
                    break;
                }
                rc = Boolean.FALSE;
                break;
            }
            case 19079: {
                Vector<Integer> v = new Vector<Integer>();
                Object xVar = this.roles.getVariable((Object)this.xRole, 0);
                if (xVar == null) {
                    v.addElement(new Integer(2));
                }
                if (v.size() <= 0) break;
                int[] errIds = new int[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    errIds[i] = ((Number)v.elementAt(i)).intValue();
                }
                rc = errIds;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 805: {
                if (!(value instanceof Number)) break;
                this.setNumberOfXBins(((Number)value).intValue());
                break;
            }
            case 806: {
                if (!(value instanceof Number)) break;
                this.setNumberOfYBins(((Number)value).intValue());
                break;
            }
            case 832: {
                if (value instanceof Number) {
                    this.setBoundary(((Number)value).intValue());
                    break;
                }
                if (value == null) break;
                this.setBoundary(value.toString());
                break;
            }
            case 835: {
                if (!(value instanceof Boolean)) break;
                this.setBinToDataRange((Boolean)value);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.statTypeRole = null;
        this.frequencyRole = null;
        this.currentLegend = null;
    }

    public int getNumberOfXBins() {
        return this.numberOfXBins;
    }

    public void setNumberOfXBins(int numberOfXBins) {
        this.numberOfXBins = numberOfXBins;
        this.userSetProperties.set(805);
        this.rebuildRequired = true;
        this.fireLayerListenerChanged(7);
    }

    public int getNumberOfYBins() {
        return this.numberOfYBins;
    }

    public void setNumberOfYBins(int numberOfYBins) {
        this.numberOfYBins = numberOfYBins;
        this.userSetProperties.set(806);
        this.rebuildRequired = true;
        this.fireLayerListenerChanged(7);
    }

    public int getBinningInclusive() {
        return this.getBoundary();
    }

    public boolean setBinningInclusive(int binningInclusive) {
        return this.setBoundary(binningInclusive);
    }

    public boolean setBoundary(int boundary) {
        switch (boundary) {
            case 0: 
            case 1: {
                this.yBoundary = this.boundary = boundary;
                this.xBoundary = this.boundary;
                this.userSetProperties.set(832);
                this.rebuildRequired = true;
                this.build(Boolean.TRUE);
                return true;
            }
        }
        return false;
    }

    public int getBoundary() {
        return this.boundary;
    }

    protected void setBoundary(String bi) {
        if (bi == null) {
            return;
        }
        int b = this.boundary;
        if ("Upper".equalsIgnoreCase(bi)) {
            b = 0;
        } else if ("Lower".equalsIgnoreCase(bi)) {
            b = 1;
        } else {
            return;
        }
        this.setBoundary(b);
    }

    public boolean isBinnedToDataRange() {
        return this.binToDataRange;
    }

    public void setBinToDataRange(boolean binToDataRange) {
        this.binToDataRange = binToDataRange;
        this.userSetProperties.set(835);
        this.rebuildRequired = true;
    }
}

