/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.CustomBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.data.GTKDataFilterVariableInterface;
import com.sas.graphics.data.GTKNumericDataFilterVariable;
import com.sas.graphics.data.GTKStringDataFilterVariable;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.silk.base.AbstractHeatmapElement;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.SelectResult;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;

public class HeatmapParmElement
extends AbstractHeatmapElement
implements IOBSInterface {
    public static int[] supportedHeatmapParmElementProperties = new int[]{333636, 333643, 333644, 333650, 333651, 333654, 333655, 333657, 333658, 333659, 333660, 24, 25, 23, 433, 426, 434, 441};
    private boolean drSetX = false;
    private boolean drSetY = false;

    public HeatmapParmElement() {
        this.initRoles();
        this.roles.newRole((Object)this.groupRole, "Group", 1, null, 100);
        this.roles.setRoleType((Object)this.groupRole, 0);
        this.roles.setDiscrete((Object)this.groupRole, true);
        this.roles.newRole((Object)this.groupIndexRole, "Group Index", 1);
        this.roles.setRoleType((Object)this.groupIndexRole, 1);
        this.initHeatmapObject();
        this.initUIPanel();
        this.setSupportedProperties(supportedHeatmapParmElementProperties);
        this.userSetProperties.appendProperties(supportedHeatmapParmElementProperties);
    }

    protected void initUIPanel() {
        this.addChartTabInfo("com.sas.graphics.silk.ui.HeatmapParmPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"HeatmapParmElement.HeatmapParm.txt", (String)"HeatmapParm"));
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
                break;
            }
            case 5: {
                this.sortRole(e);
            }
        }
        if ((this.xRole.equals(e.role) || this.yRole.equals(e.role)) && e.type != 5) {
            this.fireLayerListenerChanged(8);
        }
    }

    protected void setRole(RoleEvent e) {
        SILKNumber currentRole;
        Variable currentVariable;
        if (this.filter == null) {
            return;
        }
        switch (e.role) {
            case 24: {
                currentVariable = this.xGTKVariable;
                currentRole = this.xRole;
                break;
            }
            case 25: {
                currentVariable = this.yGTKVariable;
                currentRole = this.yRole;
                break;
            }
            case 2: {
                if (this.roles.getVariable((Object)this.groupRole, 0) != null) {
                    this.roles.removeRole(this.roles.getVariable((Object)this.groupRole, 0), (Object)this.groupRole);
                }
                this.clearColorRamp();
                currentVariable = this.colorGTKVariable;
                currentRole = this.colorRole;
                break;
            }
            case 6: {
                if (this.roles.getVariable((Object)this.colorRole, 0) != null) {
                    this.roles.removeRole(this.roles.getVariable((Object)this.colorRole, 0), (Object)this.colorRole);
                }
                currentVariable = this.groupGTKVariable;
                currentRole = this.groupRole;
                break;
            }
            case 7: {
                currentVariable = this.groupIndexGTKVariable;
                currentRole = this.groupIndexRole;
                break;
            }
            default: {
                return;
            }
        }
        if (this.filter.isNumericVariable(this.filter.getVariableIndex(this.roles.getVariable((Object)currentRole, 0)))) {
            currentVariable = new GTKNumericDataFilterVariable();
            if (this.xRole.equals((Object)currentRole) || this.yRole.equals((Object)currentRole)) {
                this.updateSortableRoles(currentRole, 2);
            }
        } else {
            currentVariable = new GTKStringDataFilterVariable();
            if (this.xRole.equals((Object)currentRole) || this.yRole.equals((Object)currentRole)) {
                this.updateSortableRoles(currentRole, 1);
            }
        }
        currentVariable.disconnect();
        ((GTKDataFilterVariableInterface)currentVariable).connectFrom(this.filter, this.roles.getVariable((Object)currentRole, 0));
        this.rebuildRequired = true;
        this.heatmap.setReconnectRequired(true);
        switch (e.role) {
            case 24: {
                this.xGTKVariable = currentVariable;
                this.heatmap.setXVariable(currentVariable);
                break;
            }
            case 25: {
                this.yGTKVariable = currentVariable;
                this.heatmap.setYVariable(currentVariable);
                break;
            }
            case 2: {
                this.colorGTKVariable = currentVariable;
                this.heatmap.setColorVariable(currentVariable);
                this.buildColorMap();
                this.lce.setAction(4);
                this.lce.setBuildData(this.colorRole.toString());
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 6: {
                this.groupGTKVariable = currentVariable;
                this.heatmap.setColorVariable(currentVariable);
            }
            case 7: {
                this.groupIndexMap = null;
                this.lce.setAction(4);
                this.lce.setBuildData(this.groupRole.toString());
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void removeRole(RoleEvent e) {
        if (this.filter == null) {
            return;
        }
        switch (e.role) {
            case 24: {
                this.xGTKVariable.disconnect();
                this.heatmap.setXVariable(null);
                this.rebuildRequired = true;
                break;
            }
            case 25: {
                this.yGTKVariable.disconnect();
                this.heatmap.setYVariable(null);
                this.rebuildRequired = true;
                break;
            }
            case 2: {
                this.colorGTKVariable.disconnect();
                this.heatmap.setColorVariable(null);
                this.clearColorRamp();
                this.rebuildRequired = true;
                this.currentLegend = null;
                break;
            }
            case 6: {
                this.groupGTKVariable.disconnect();
                this.heatmap.setColorVariable(null);
            }
            case 7: {
                this.groupIndexMap = null;
                this.groupValueIndexMap.clear();
                this.rebuildRequired = true;
                this.currentLegend = null;
            }
        }
        this.heatmap.setReconnectRequired(true);
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            this.heatmap.setSelected(null);
            return;
        }
        int[] selectedObservations = new int[this.selections.cardinality()];
        int i = 0;
        while (this.selections.hasMoreSelections()) {
            selectedObservations[i++] = this.selections.nextSelectedIndex();
        }
        this.heatmap.setSelected(selectedObservations);
        this.heatmap.getChannel().setSingleBufferGraphics(g);
        this.heatmap.drawSelected();
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        Rectangle selectArea = new Rectangle(screenX, screenY, 1, 1);
        Vector obs = this.heatmap.getSelected(selectArea);
        if (obs != null && obs.size() > 0) {
            return this.getTipText((int)this.getObservationIndex(obs.elementAt(0)));
        }
        return null;
    }

    protected Object[] fetchUniqueValues(int varIndex, boolean useSubset) {
        Object[] uniqueValues = null;
        if (varIndex >= 0 && this.infoFilter != null) {
            uniqueValues = this.infoFilter.getUniqueValues(this.filter.getVariableId(varIndex), useSubset);
        }
        return uniqueValues;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        if (!(selectRegion instanceof Rectangle) || this.filter == null) {
            return false;
        }
        Rectangle selectArea = (Rectangle)selectRegion;
        Vector obs = this.heatmap.getSelected(selectArea);
        this.filter.setSelected((Object)obs, select, (IOBSInterface)this);
        return true;
    }

    @Override
    protected DataRange getDataRange(byte dimension, boolean globalRange) {
        ContinuousRange rc = null;
        if (dimension == 4) {
            DataFilterReadInterface dfri = this.filters.getDataFilter(this.roles.getDataID(RoleInterface.ROLE_COLOR));
            Object colorVar = this.roles.getVariable(RoleInterface.ROLE_COLOR, 0);
            if (dfri == null || colorVar == null) {
                return null;
            }
            int colorVarIndex = dfri.getVariableIndex(colorVar);
            if (colorVarIndex < 0) {
                return null;
            }
            double colorMin = Double.NaN;
            double colorMax = Double.NaN;
            Object o = ((DataFilterInfoInterface)dfri).getMinimumValue(dfri.getVariableId(colorVarIndex), !globalRange);
            if (o instanceof Number) {
                colorMin = ((Number)o).doubleValue();
            }
            if ((o = ((DataFilterInfoInterface)dfri).getMaximumValue(dfri.getVariableId(colorVarIndex), !globalRange)) instanceof Number) {
                colorMax = ((Number)o).doubleValue();
            }
            rc = new ContinuousRange(colorMin, colorMax);
            return rc;
        }
        return super.getDataRange(dimension, globalRange);
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 333657: {
                return this.getXValues();
            }
            case 333658: {
                return this.getYValues();
            }
            case 19070: {
                if (!this.heatmap.isXBinAxis()) break;
                rc = this.heatmap.getTickmarkValuesForDimension((byte)1);
                break;
            }
            case 19071: {
                if (!this.heatmap.isYBinAxis()) break;
                rc = this.heatmap.getTickmarkValuesForDimension((byte)2);
                break;
            }
            case 19078: {
                if (this.roles.getVariable((Object)this.xRole, 0) != null && this.roles.getVariable((Object)this.yRole, 0) != null && (this.roles.getVariable((Object)this.colorRole, 0) != null || this.roles.getVariable((Object)this.groupRole, 0) != null)) {
                    rc = Boolean.TRUE;
                    break;
                }
                rc = Boolean.FALSE;
                break;
            }
            case 19079: {
                Vector<Integer> v = new Vector<Integer>();
                if (this.roles.getVariable((Object)this.xRole, 0) == null) {
                    v.addElement(new Integer(2));
                }
                if (this.roles.getVariable((Object)this.yRole, 0) == null) {
                    v.addElement(new Integer(3));
                }
                if (this.roles.getVariable((Object)this.colorRole, 0) == null && this.roles.getVariable((Object)this.groupRole, 0) == null) {
                    v.addElement(new Integer(5));
                }
                if (v.size() <= 0) break;
                int[] errIds = new int[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    errIds[i] = ((Number)v.elementAt(i)).intValue();
                }
                rc = errIds;
            }
        }
        return rc != null ? rc : super.getPropertyValue(id);
    }

    @Override
    protected Object getLegendTitle(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.groupRole, 0));
        }
        if (this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.colorRole, 0));
        }
        return null;
    }

    @Override
    protected boolean isContinuousLegend(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return false;
        }
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return false;
        }
        return this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName());
    }

    @Override
    protected Object getLegendEntries(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.filter == null) {
            return null;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        Object[] allGroupValues = this.fetchUniqueValues(groupVarIndex, false);
        Object[] subsetGroupValues = this.fetchUniqueValues(groupVarIndex, true);
        Object colorVar = this.roles.getVariable((Object)this.colorRole, 0);
        int colorVarIndex = this.filter.getVariableIndex(colorVar);
        boolean statGraphCompat = SILKGlobal.isFlagSet(4);
        if (this.groupRole != null && (this.groupRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName()))) {
            if (groupVar == null) {
                return null;
            }
            if (allGroupValues == null || subsetGroupValues == null) {
                return null;
            }
            this.buildGroupMap();
            if (this.groupColorMap == null || this.groupColorMap.size() == 0) {
                return null;
            }
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
            Iterator it = this.groupColorMap.keySet().iterator();
            while (it != null && it.hasNext()) {
                Object group;
                Object formattedGroup = group = it.next();
                Object obsIndex = this.groupValueIndexMap.get(group);
                if (obsIndex instanceof Number) {
                    formattedGroup = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)((Number)obsIndex).intValue(), null);
                }
                MarkerAttrib msi = new MarkerAttrib(true, (Color)this.groupColorMap.get(group));
                msi.setShape(new Integer(19));
                msi.setFilled(true);
                msi.setOutline(this.heatmap.showOutline());
                msi.setOutline(this.heatmap.getOutlineAttrs().getColor());
                LegendEntry le = new LegendEntry(formattedGroup, msi, null);
                legendEntries.add(le);
            }
            return legendEntries;
        }
        if (this.colorRole != null && (this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) && colorVarIndex >= 0) {
            if (this.colorMapper == null) {
                this.initColorRamp();
            }
            if (this.colorMapper == null) {
                return null;
            }
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
            ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4, false);
            Color c = this.colorMapper.getColor(r.getMin());
            double cv = r.getMin();
            MarkerAttrib msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            c = this.colorMapper.getNeutralColor();
            if (c != null && r.contains((DataPoint)new ContinuousPoint(this.colorMapper.getNeutralValue()))) {
                cv = this.colorMapper.getNeutralValue();
                msi = new MarkerAttrib(true, c);
                legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            }
            c = this.colorMapper.getColor(r.getMax());
            cv = r.getMax();
            msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            return legendEntries;
        }
        return null;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 333657: {
                if (value instanceof Number) {
                    this.setXValues(((Number)value).intValue());
                    break;
                }
                if (!(value instanceof String)) break;
                int valueType = this.getValueType(value.toString());
                switch (valueType) {
                    case 333661: 
                    case 333662: 
                    case 333663: {
                        this.setXValues(valueType);
                    }
                }
                break;
            }
            case 333658: {
                if (value instanceof Number) {
                    this.setYValues(((Number)value).intValue());
                    break;
                }
                if (!(value instanceof String)) break;
                int valueType = this.getValueType(value.toString());
                switch (valueType) {
                    case 333661: 
                    case 333662: 
                    case 333663: {
                        this.setYValues(valueType);
                    }
                }
                break;
            }
            default: {
                super.applyChange(key, value);
                return;
            }
        }
        this.userSetProperties.set(key);
    }

    private int getValueType(String values) {
        if ("Midpoints".equalsIgnoreCase(values)) {
            return 333661;
        }
        if ("Leftpoints".equalsIgnoreCase(values)) {
            return 333662;
        }
        if ("Rightpoints".equalsIgnoreCase(values)) {
            return 333663;
        }
        return -1;
    }

    public long getObservationIndex(Object o) {
        if (o == null) {
            return -1L;
        }
        return ((SelectResult)o).getValueIndex();
    }

    public FillAttrs getFillAttrs() {
        return this.heatmap.getFillAttrs();
    }

    public LineAttrs getOutlineAttrs() {
        return this.heatmap.getOutlineAttrs();
    }

    public int getXValues() {
        return this.heatmap.getXValues();
    }

    public int getYValues() {
        return this.heatmap.getYValues();
    }

    public void setXValues(int values) {
        this.heatmap.setXValues(values);
        this.rebuildRequired = true;
        this.heatmap.setReconnectRequired(true);
        this.fireLayerListenerChanged(5);
        this.fireLayerListenerChanged(8);
        this.fireLayerListenerChanged(5);
    }

    public void setYValues(int values) {
        this.heatmap.setYValues(values);
        this.rebuildRequired = true;
        this.heatmap.setReconnectRequired(true);
        this.fireLayerListenerChanged(5);
        this.fireLayerListenerChanged(8);
        this.fireLayerListenerChanged(5);
    }

    public void setDisplayMode(String display) {
        this.heatmap.setDisplayMode(display);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.clearColorRamp();
        this.xRole = null;
        this.yRole = null;
        this.colorRole = null;
        this.groupRole = null;
        this.groupIndexRole = null;
        this.xGTKVariable = null;
        this.yGTKVariable = null;
        this.colorGTKVariable = null;
        this.groupGTKVariable = null;
        this.groupIndexGTKVariable = null;
        this.heatmap = null;
    }

    @Override
    protected DataRange adjustRange(DataRange range, int values, boolean binAxis, boolean endLabels, double step, double[] boundaries) {
        if (range == null || !(range instanceof ContinuousRange)) {
            return range;
        }
        ContinuousRange adjustedRange = null;
        double min = ((ContinuousRange)range).getMin();
        double max = ((ContinuousRange)range).getMax();
        if (boundaries != null && boundaries.length > 1) {
            if (binAxis) {
                CustomBinnedRange cbr = new CustomBinnedRange(boundaries);
                cbr.setEndLabels(endLabels);
                adjustedRange = cbr;
            } else {
                adjustedRange = new ContinuousRange(boundaries[0], boundaries[boundaries.length - 1]);
            }
        } else {
            switch (values) {
                default: {
                    min -= step / 2.0;
                    max += step / 2.0;
                    break;
                }
                case 333662: {
                    max += step;
                    break;
                }
                case 333663: {
                    min -= step;
                }
            }
            adjustedRange = new ContinuousRange(min, max);
        }
        return adjustedRange;
    }

    protected String getTipText(int obs) {
        if (obs < 0 || obs > this.filter.getNumberObservations(-1)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Object dataVariable = this.roles.getVariable((Object)this.xRole, 0);
        if (dataVariable != null) {
            sb.append("\n");
            sb.append(dataVariable);
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(dataVariable, obs));
        }
        if ((dataVariable = this.roles.getVariable((Object)this.yRole, 0)) != null) {
            sb.append("\n");
            sb.append(dataVariable);
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(dataVariable, obs));
        }
        if ((dataVariable = this.roles.getVariable((Object)this.colorRole, 0)) != null) {
            sb.append("\n");
            sb.append(dataVariable);
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(dataVariable, obs));
        }
        if ((dataVariable = this.roles.getVariable((Object)this.groupRole, 0)) != null) {
            sb.append("\n");
            sb.append(dataVariable);
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(dataVariable, obs));
        }
        return sb.toString();
    }

    @Override
    protected boolean isContinuousColorMapping() {
        return this.isRoleSet((Object)this.colorRole);
    }

    @Override
    protected void processSubset() {
        super.processSubset();
        this.heatmap.setXVariable(this.xGTKVariable);
        this.heatmap.setYVariable(this.yGTKVariable);
        this.fireLayerListenerChanged(8);
    }

    @Override
    public void setDataRange(byte dim, int index, DataRange range) {
        super.setDataRange(dim, index, range);
        if (dim == 1) {
            this.drSetX = true;
            this.useDataRangeX = true;
        } else if (dim == 2) {
            this.drSetY = true;
            this.useDataRangeY = true;
        }
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        if (dim == 1 && !this.drSetX) {
            this.useDataRangeX = false;
        } else if (dim == 2 && !this.drSetY) {
            this.useDataRangeY = false;
        }
        if (dim == 1) {
            this.drSetX = false;
        } else if (dim == 2) {
            this.drSetY = false;
        }
    }
}

