/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.common.heatmap.HeatmapBinningUtility;
import com.sas.graphics.data.GTKNumericDataFilterVariable;
import com.sas.graphics.data.GTKStringDataFilterVariable;
import com.sas.graphics.silk.base.AbstractHeatmapElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.Bin;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Vector;

public class HeatmapElement
extends AbstractHeatmapElement {
    public static int[] supportedHeatmapElementProperties = new int[]{333636, 333643, 333644, 333650, 333651, 333654, 333655, 333664, 333665, 333652, 333653, 333659, 333660, 24, 25, 23, 433, 426, 434, 441};
    private boolean rebuildBinsRequired = false;
    private boolean forceBuild = false;
    private boolean isBuildingBins = false;
    HeatmapBinningUtility hbu = new HeatmapBinningUtility();
    protected static ResourceBundle rbUI = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected static SILKNumber statName_Frequency = new SILKNumber(0, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Frequency.txt", (String)"Frequency"), "Frequency");
    private boolean drSetX = false;
    private boolean drSetY = false;

    public HeatmapElement() {
        this.initRoles();
        this.initHeatmapObject();
        this.initUIPanel();
        this.setSupportedProperties(supportedHeatmapElementProperties);
        this.userSetProperties.appendProperties(supportedHeatmapElementProperties);
    }

    protected void initUIPanel() {
        this.addChartTabInfo("com.sas.graphics.silk.ui.HeatmapPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"HeatmapElement.Heatmap.txt", (String)"Heatmap"));
    }

    @Override
    public void roleChanged(RoleEvent e) {
        if (e.type != 5 && (this.xRole.equals(e.role) || this.yRole.equals(e.role) || this.colorRole.equals(e.role))) {
            this.rebuildBinsRequired = true;
            this.forceBuild = true;
            if (this.xRole.equals(e.role)) {
                this.xDataRange = null;
                if (e.type == 1) {
                    if (this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0))) {
                        this.updateSortableRoles(this.xRole, 2);
                    } else {
                        this.updateSortableRoles(this.xRole, 1);
                    }
                }
            } else if (this.yRole.equals(e.role)) {
                this.yDataRange = null;
                if (e.type == 1) {
                    if (this.filter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0))) {
                        this.updateSortableRoles(this.yRole, 2);
                    } else {
                        this.updateSortableRoles(this.yRole, 1);
                    }
                }
            }
            this.colorGTKVariable = null;
            if (this.colorRole.equals(e.role)) {
                this.buildBins();
            }
        } else if (e.type == 5) {
            this.rebuildBinsRequired = true;
            this.forceBuild = true;
            if (this.xRole.equals(e.role)) {
                this.xDataRange = null;
            } else if (this.yRole.equals(e.role)) {
                this.yDataRange = null;
            }
            this.fireLayerListenerChanged(5);
        }
        super.roleChanged(e);
    }

    private void buildBins() {
        boolean yDiscrete;
        if (!this.rebuildBinsRequired || this.isBuildingBins) {
            return;
        }
        if (this.roles.getVariable((Object)this.xRole, 0) == null || this.roles.getVariable((Object)this.yRole, 0) == null) {
            return;
        }
        if (this.xDataRange == null || this.yDataRange == null) {
            return;
        }
        if (this.filter == null) {
            return;
        }
        DataRange xdr = this.getRange((byte)1, this.xRole, this.hbu.isXBinToDataRange());
        DataRange ydr = this.getRange((byte)2, this.yRole, this.hbu.isYBinToDataRange());
        boolean xDiscrete = !this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0));
        boolean bl = yDiscrete = !this.filter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0));
        if (xdr == null || ydr == null) {
            return;
        }
        if (!this.forceBuild && xdr.equals((Object)this.hbu.getXRange()) && ydr.equals((Object)this.hbu.getYRange())) {
            return;
        }
        this.isBuildingBins = true;
        this.hbu.setXVariable(this.getGTKVariable(this.roles.getVariable((Object)this.xRole, 0)));
        this.hbu.setYVariable(this.getGTKVariable(this.roles.getVariable((Object)this.yRole, 0)));
        this.hbu.setColorVariable(this.getGTKVariable(this.roles.getVariable((Object)this.colorRole, 0)));
        this.hbu.computeBins(xdr, ydr, xDiscrete, yDiscrete);
        this.xGTKVariable = this.hbu.getXBinVariable();
        this.yGTKVariable = this.hbu.getYBinVariable();
        this.colorGTKVariable = this.hbu.getColorVariable() != null ? this.hbu.getBinColorVariable() : this.hbu.getBinCountVariable();
        this.heatmap.setXVariable(this.xGTKVariable);
        if (this.hbu.getXBinBoundaries() == null && this.xGTKVariable instanceof NumericVariable) {
            this.heatmap.setXStep(this.hbu.getXBinSize());
        }
        this.heatmap.setYVariable(this.yGTKVariable);
        if (this.hbu.getYBinBoundaries() == null && this.yGTKVariable instanceof NumericVariable) {
            this.heatmap.setYStep(this.hbu.getYBinSize());
        }
        this.heatmap.setColorVariable(this.colorGTKVariable);
        this.rebuildRequired = true;
        this.heatmap.setReconnectRequired(true);
        this.fireLayerListenerChanged(8);
        if (xDiscrete || yDiscrete) {
            this.fireLayerListenerChanged(5);
        }
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
        this.initColorRamp();
        this.fireLayerListenerChanged(4);
        this.forceBuild = false;
        this.rebuildBinsRequired = false;
        this.isBuildingBins = false;
    }

    private DataRange getRange(byte dimension, SILKNumber role, boolean binToDataRange) {
        boolean mismatchedRange;
        DataRange dr = this.getDataRange(dimension);
        boolean numericVar = this.filter.isNumericVariable(this.roles.getVariable((Object)role, 0));
        boolean bl = mismatchedRange = !(dr instanceof ContinuousRange && numericVar || dr instanceof DiscreteRange && !numericVar);
        if (dr == null || binToDataRange || mismatchedRange) {
            Object var = this.roles.getVariable((Object)role, 0);
            if (this.infoFilter != null) {
                if (this.filter.isNumericVariable(var)) {
                    Object min = this.infoFilter.getMinimumValue(var);
                    Object max = this.infoFilter.getMaximumValue(var);
                    double m1 = Double.NaN;
                    if (min instanceof Number) {
                        m1 = ((Number)min).doubleValue();
                    }
                    double m2 = Double.NaN;
                    if (max instanceof Number) {
                        m2 = ((Number)max).doubleValue();
                    }
                    dr = new ContinuousRange(m1, m2);
                } else {
                    Object[] uv = this.infoFilter.getUniqueValues(var, true);
                    dr = new DiscreteRange(uv);
                }
            }
        }
        return dr;
    }

    private Variable getGTKVariable(Object varName) {
        if (varName == null) {
            return null;
        }
        if (this.filter.isNumericVariable(varName)) {
            GTKNumericDataFilterVariable var = new GTKNumericDataFilterVariable();
            var.connectFrom(this.filter, varName);
            return var;
        }
        GTKStringDataFilterVariable var = new GTKStringDataFilterVariable();
        var.connectFrom(this.filter, varName);
        return var;
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (which == null || this.filter == null) {
            return null;
        }
        Object role = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        Object range = null;
        while (rolesEnum.hasMoreElements()) {
            role = rolesEnum.nextElement();
            if (role == null || !RoleInterface.ROLE_COLOR.equals(role) || !this.rebuildRequired) continue;
            this.buildBins();
            return super.getPreferredRange(which);
        }
        return super.getPreferredRange(which);
    }

    @Override
    protected DataRange adjustRange(DataRange range, int values, boolean binAxis, boolean endLabels, double step, double[] boundaries) {
        return range;
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 19078: {
                if (this.roles.getVariable((Object)this.xRole, 0) != null && this.roles.getVariable((Object)this.yRole, 0) != null) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 19079: {
                Vector<Integer> v = new Vector<Integer>();
                if (this.roles.getVariable((Object)this.xRole, 0) == null) {
                    v.addElement(new Integer(2));
                }
                if (this.roles.getVariable((Object)this.yRole, 0) == null) {
                    v.addElement(new Integer(3));
                }
                if (v.size() > 0) {
                    int[] errIds = new int[v.size()];
                    for (int i = 0; i < v.size(); ++i) {
                        errIds[i] = ((Number)v.elementAt(i)).intValue();
                    }
                    return errIds;
                }
                return null;
            }
            case 434: {
                if (this.currentLegend == null) {
                    rc = null;
                }
                if (!this.colorRole.toString().equalsIgnoreCase(this.currentLegend.toString()) && !this.colorRole.getEnglishName().equalsIgnoreCase(this.colorRole.getEnglishName())) break;
                rc = this.roles.getVariable((Object)this.colorRole, 0);
                break;
            }
            case 24: 
            case 25: {
                Vector<SILKNumber> legNames = new Vector<SILKNumber>();
                if (this.isLegendValid(this.colorRole)) {
                    legNames.add(this.colorRole);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 333652: {
                rc = this.hbu.isXBinToDataRange();
                break;
            }
            case 333653: {
                rc = this.hbu.isYBinToDataRange();
                break;
            }
            case 333664: {
                rc = this.hbu.getXNumberOfBins();
                break;
            }
            case 333665: {
                rc = this.hbu.getYNumberOfBins();
                break;
            }
            case 19070: {
                if (!this.heatmap.isXBinAxis()) break;
                rc = this.hbu.getTickmarkValuesForDimension((byte)1, this.heatmap.isXEndLabels());
                break;
            }
            case 19071: {
                if (!this.heatmap.isYBinAxis()) break;
                rc = this.hbu.getTickmarkValuesForDimension((byte)2, this.heatmap.isYEndLabels());
                break;
            }
            case 53: {
                rc = this.rampName;
                break;
            }
        }
        if (rc != null) {
            return rc;
        }
        return super.getPropertyValue(id);
    }

    @Override
    protected Object getLegendEntries(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.filter == null) {
            return null;
        }
        if (this.rebuildBinsRequired) {
            this.buildBins();
            if (!this.rebuildBinsRequired) {
                this.initColorRamp();
            }
        }
        if (this.colorRole != null && (this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName()))) {
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
            ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4, false);
            if (r == null) {
                return null;
            }
            if (this.colorMapper == null) {
                this.initColorRamp();
            }
            if (this.colorMapper == null) {
                return null;
            }
            Color c = this.colorMapper.getColor(r.getMin());
            double cv = r.getMin();
            MarkerAttrib msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            c = this.colorMapper.getNeutralColor();
            if (c != null && r.contains((DataPoint)new ContinuousPoint(this.colorMapper.getNeutralValue()))) {
                cv = this.colorMapper.getNeutralValue();
                msi = new MarkerAttrib(true, c);
                legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            }
            c = this.colorMapper.getColor(r.getMax());
            cv = r.getMax();
            msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            return legendEntries;
        }
        return null;
    }

    @Override
    protected void drawChart(Graphics g) {
        if (this.roles.getVariable((Object)this.xRole, 0) == null || this.roles.getVariable((Object)this.yRole, 0) == null) {
            return;
        }
        if (this.rebuildBinsRequired) {
            this.buildBins();
        }
        super.drawChart(g);
    }

    @Override
    protected DataRange getDataRange(byte dimension, boolean globalRange) {
        if (dimension == 4) {
            if (this.colorGTKVariable != null) {
                NumericVariable nv = (NumericVariable)this.colorGTKVariable;
                double min = nv.getMin();
                double max = nv.getMax();
                if (!this.isRoleSet((Object)this.colorRole)) {
                    min = 0.0;
                }
                if (this.colorGTKVariable.getUniqueValueCount() == 0) {
                    min = Double.NaN;
                    max = Double.NaN;
                } else if (this.colorGTKVariable.getUniqueValueCount() == 1 && this.colorGTKVariable instanceof NumericVectorVariable) {
                    NumericVectorVariable nvv = (NumericVectorVariable)this.colorGTKVariable;
                    try {
                        int idx = nvv.getFirstOccurringValueIndex(0);
                        double d = nvv.value.getValue(idx);
                    }
                    catch (MissingValueException e) {
                        min = Double.NaN;
                        max = Double.NaN;
                    }
                }
                return new ContinuousRange(min, max);
            }
            return null;
        }
        return super.getDataRange(dimension, globalRange);
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        this.rebuildBinsRequired = true;
        super.dataFilterChanged(evt);
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        Rectangle selectArea = (Rectangle)selectRegion;
        Vector obs = this.heatmap.getSelected(selectArea);
        Object xdr = null;
        Object ydr = null;
        Object xStringPipe = null;
        Object yStringPipe = null;
        Object xcr = null;
        Object ycr = null;
        Object[] bin2D = null;
        Bin xbin = null;
        Bin ybin = null;
        LinkedHashMap<Integer, Integer> selectedIndices = new LinkedHashMap<Integer, Integer>();
        for (int i = obs.size() - 1; i >= 0; --i) {
            bin2D = this.hbu.getBinCorrespondingToSelectResult((SelectResult)obs.elementAt(i));
            if (bin2D == null) continue;
            xbin = (Bin)bin2D[0];
            ybin = (Bin)bin2D[1];
            if (xbin == null || ybin == null) continue;
            int[] obsIndices = this.hbu.getObservationIndices(xbin.getIndex(), ybin.getIndex());
            this.appendIndices(selectedIndices, obsIndices);
        }
        if (selectedIndices.size() > 0) {
            int[] selectedObs = new int[selectedIndices.size()];
            Iterator it = selectedIndices.keySet().iterator();
            int count = 0;
            while (it.hasNext()) {
                selectedObs[count++] = (Integer)it.next();
            }
            this.filter.setSelected((Object)selectedObs, true);
        }
        return true;
    }

    private void appendIndices(LinkedHashMap<Integer, Integer> selectedIndices, int[] obsIndices) {
        if (selectedIndices == null || obsIndices == null) {
            return;
        }
        for (int i = 0; i < obsIndices.length; ++i) {
            if (selectedIndices.containsKey(obsIndices[i])) continue;
            selectedIndices.put(obsIndices[i], obsIndices[i]);
        }
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            this.heatmap.setSelected(null);
            return;
        }
        Vector<Integer> selBins = new Vector<Integer>();
        while (this.selections.hasMoreSelections()) {
            int obsIndex = this.selections.nextSelectedIndex();
            int xBinIndex = this.hbu.getXBinIndex(obsIndex);
            int yBinIndex = this.hbu.getYBinIndex(obsIndex);
            if (xBinIndex < 0 || yBinIndex < 0) continue;
            selBins.add(this.hbu.getBinVariableIndex(xBinIndex, yBinIndex));
        }
        if (selBins.size() > 0) {
            int[] selectedBins = new int[selBins.size()];
            for (int i = 0; i < selectedBins.length; ++i) {
                selectedBins[i] = (Integer)selBins.elementAt(i);
            }
            this.heatmap.setSelected(selectedBins);
            this.heatmap.getChannel().setSingleBufferGraphics(g);
            this.heatmap.drawSelected();
        }
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 333664: {
                if (!(value instanceof Number)) break;
                this.hbu.setXNumberOfBins(((Number)value).intValue());
                this.userSetProperties.set(key);
                this.forceBuild = true;
                this.rebuildBinsRequired = true;
                break;
            }
            case 333665: {
                if (!(value instanceof Number)) break;
                this.hbu.setYNumberOfBins(((Number)value).intValue());
                this.userSetProperties.set(key);
                this.forceBuild = true;
                this.rebuildBinsRequired = true;
                break;
            }
            case 333652: {
                if (!(value instanceof Boolean)) break;
                this.hbu.setXBinToDataRange(((Boolean)value).booleanValue());
                this.userSetProperties.set(key);
                this.forceBuild = true;
                this.rebuildBinsRequired = true;
                break;
            }
            case 333653: {
                if (!(value instanceof Boolean)) break;
                this.hbu.setYBinToDataRange(((Boolean)value).booleanValue());
                this.userSetProperties.set(key);
                this.forceBuild = true;
                this.rebuildBinsRequired = true;
                break;
            }
        }
        super.applyChange(key, value);
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        Rectangle selectArea = new Rectangle(screenX, screenY, 1, 1);
        Vector obs = this.heatmap.getSelected(selectArea);
        Object xdr = null;
        Object ydr = null;
        Object xStringPipe = null;
        Object yStringPipe = null;
        Object xcr = null;
        Object ycr = null;
        Object[] bin2D = null;
        Object bin = null;
        DataRange[] ranges = new DataRange[2];
        LinkedHashMap selectedIndices = new LinkedHashMap();
        for (int i = obs.size() - 1; i >= 0; --i) {
            bin2D = this.hbu.getBinCorrespondingToSelectResult((SelectResult)obs.elementAt(i));
            if (bin2D == null) continue;
            String tt = this.getTipText((Bin)bin2D[0], (Bin)bin2D[1]);
            return tt;
        }
        return null;
    }

    private String getTipText(Bin xBin, Bin yBin) {
        if (xBin == null || yBin == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Message binMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapElement.BinRange.fmt.txt", (String)"{0}= [{1}, {2}]"));
        Object dataVariable = this.roles.getVariable((Object)this.xRole, 0);
        Object desc = this.filter.getVariableDescription(dataVariable);
        if (dataVariable != null) {
            if (this.filter.isNumericVariable(dataVariable)) {
                sb.append(binMessage.toString(new Object[]{desc, this.getFormattedValue(dataVariable, new Double(xBin.getMin())), this.getFormattedValue(dataVariable, new Double(xBin.getMax()))}));
            } else {
                sb.append(desc);
                sb.append(" \t=\t ");
                sb.append(xBin.getDiscreteValue());
            }
        }
        dataVariable = this.roles.getVariable((Object)this.yRole, 0);
        desc = this.filter.getVariableDescription(dataVariable);
        if (dataVariable != null) {
            sb.append("\n");
            if (this.filter.isNumericVariable(dataVariable)) {
                sb.append(binMessage.toString(new Object[]{desc, this.getFormattedValue(dataVariable, new Double(yBin.getMin())), this.getFormattedValue(dataVariable, new Double(yBin.getMax()))}));
            } else {
                sb.append("\n");
                sb.append(desc);
                sb.append(" \t=\t ");
                sb.append(yBin.getDiscreteValue());
            }
        }
        if ((dataVariable = this.roles.getVariable((Object)this.colorRole, 0)) != null) {
            desc = this.filter.getVariableDescription(dataVariable);
            sb.append("\n");
            sb.append(desc);
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(dataVariable, this.hbu.getBinColorValue(xBin.getIndex(), yBin.getIndex())));
        } else {
            sb.append("\n");
            sb.append(statName_Frequency.toString().trim());
            sb.append(" \t=\t ");
            SASFormat nf = SASFormat.getInstance((String)"Best8.0");
            sb.append(nf.format((Object)this.hbu.getBinCount(xBin.getIndex(), yBin.getIndex())));
        }
        return sb.toString().replaceAll("\\[", "\t \t\\[");
    }

    @Override
    protected Object getLegendTitle(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.colorRole, 0));
        }
        return null;
    }

    @Override
    protected boolean isContinuousLegend(SILKNumber currentLegend) {
        return true;
    }

    @Override
    public void setDataRange(byte dim, int index, DataRange range) {
        super.setDataRange(dim, index, range);
        if (!(dim != 1 && dim != 2 || this.hbu.isXBinToDataRange() && this.hbu.isYBinToDataRange())) {
            this.rebuildBinsRequired = true;
            if (dim == 1) {
                this.drSetX = true;
                this.useDataRangeX = true;
            } else if (dim == 2) {
                this.drSetY = true;
                this.useDataRangeY = true;
            }
            if (this.isRoleSet((Object)this.xRole) && this.isRoleSet((Object)this.yRole) && this.xDataRange != null && this.yDataRange != null) {
                this.buildBins();
            }
        }
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        if (dim == 1 && !this.drSetX || dim == 2 && !this.drSetY) {
            this.rebuildBinsRequired = true;
            if (dim == 1) {
                this.useDataRangeX = false;
            } else if (dim == 2) {
                this.useDataRangeY = false;
            }
            if (this.isRoleSet((Object)this.xRole) && this.isRoleSet((Object)this.yRole)) {
                this.buildBins();
            }
        }
        if (dim == 1) {
            this.drSetX = false;
        } else if (dim == 2) {
            this.drSetY = false;
        }
    }

    @Override
    public double[] getXBoundaries() {
        return this.hbu.getXBinBoundaries();
    }

    @Override
    public void setXBoundaries(double[] boundaries) {
        this.hbu.setXBinBoundaries(boundaries);
        super.setXBoundaries(boundaries);
    }

    @Override
    public double[] getYBoundaries() {
        return this.hbu.getYBinBoundaries();
    }

    @Override
    public void setYBoundaries(double[] boundaries) {
        this.hbu.setYBinBoundaries(boundaries);
        super.setYBoundaries(boundaries);
    }

    @Override
    protected boolean isContinuousColorMapping() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.hbu != null) {
            this.hbu.dispose();
        }
    }
}

