/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.Extract;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;

public class DendrogramElement
extends BaseElement {
    protected SILKNumber nameRole;
    protected SILKNumber parentRole;
    protected SILKNumber heightRole;
    protected CharacterVariableMapper nameCharMapper;
    protected CharacterVariableMapper parentCharMapper;
    private Color defaultLineColor;
    private Color selectedLineColor;
    private double[] nodeScreenCoords;
    private double[] parentScreenCoords;
    protected HashMap parentNameToLeafAxisPositionMap;
    protected int numberOfObs;
    protected boolean needToBuildMetaData;
    private int orientationAxis;
    private final int ORIENTATION_HORIZONTAL = -42;
    private final int ORIENTATION_VERTICAL = -41;
    protected ResourceBundle rb;
    protected GlobalDefaults silkDefaults;
    public static int[] supportedProperties = new int[0];

    public DendrogramElement() {
        this.defaultLineColor = this.style.getLineStyleElement("GraphDataStyleDefault").getLineColor();
        this.selectedLineColor = this.style.getLineStyleElement("Selection").getLineColor();
        this.numberOfObs = -1;
        this.ORIENTATION_HORIZONTAL = -42;
        this.ORIENTATION_VERTICAL = -41;
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.dendrogram.dendrogram_NLS");
        this.silkDefaults = new GlobalDefaults();
        this.nameRole = this.role.getRoleObject("ROLE_NAME");
        this.roles.newRole((Object)this.nameRole, "Name", 1);
        this.roles.setRoleType((Object)this.nameRole, 0);
        this.parentRole = this.role.getRoleObject("ROLE_PARENT");
        this.roles.newRole((Object)this.parentRole, "Parent", 1);
        this.roles.setRoleType((Object)this.parentRole, 0);
        this.heightRole = this.role.getRoleObject("ROLE_HEIGHT");
        this.roles.newRole((Object)this.heightRole, "Height", 1);
        this.roles.setRoleType((Object)this.heightRole, 0);
        this.setSupportedProperties(supportedProperties);
        this.userSetProperties.appendProperties(supportedProperties);
        this.addChartTabInfo("com.sas.graphics.silk.ui.DendrogramElementPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.silk_NLS", (String)"DendrogramElement.txt.key", (String)"Dendrogram"));
        this.parentNameToLeafAxisPositionMap = new HashMap();
        this.needToBuildMetaData = true;
        this.nodeScreenCoords = new double[3];
        this.parentScreenCoords = new double[3];
        this.orientationAxis = -42;
    }

    protected void setOrientationAxis(int direction) {
        switch (direction) {
            case -42: {
                this.orientationAxis = -42;
                break;
            }
            case -41: {
                this.orientationAxis = -41;
            }
        }
    }

    public boolean isOrientationAxisVertical() {
        return this.orientationAxis == -41;
    }

    protected boolean assert_metaDataIsBuilt() {
        int possibleRootNodeNumber;
        if (!this.needToBuildMetaData || this.filter == null) {
            return false;
        }
        int parentVariableIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.parentRole, 0));
        int nameVariableIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.nameRole, 0));
        int heightVariableIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.heightRole, 0));
        if (parentVariableIndex < 0 || nameVariableIndex < 0 || heightVariableIndex < 0) {
            return false;
        }
        int[] indices = new int[]{nameVariableIndex, parentVariableIndex, heightVariableIndex};
        this.numberOfObs = this.filter.getNumberObservations(-1);
        if (this.nameCharMapper == null) {
            this.nameCharMapper = new CharacterVariableMapper();
        } else {
            this.nameCharMapper.removeAllValues();
        }
        Object parentOfPossibleRoot = null;
        for (possibleRootNodeNumber = 0; possibleRootNodeNumber < this.numberOfObs && !this.filter.isMissing(parentVariableIndex, parentOfPossibleRoot = this.filter.getValue(parentVariableIndex, (long)possibleRootNodeNumber)); ++possibleRootNodeNumber) {
            parentOfPossibleRoot = null;
        }
        if (parentOfPossibleRoot == null) {
            return false;
        }
        double targetNodeLeafAxisPosition = this.calculatePositionOnLeafAxis(possibleRootNodeNumber, indices);
        double targetNodeHight = this.filter.getNumericValue(indices[2], (long)possibleRootNodeNumber);
        this.parentNameToLeafAxisPositionMap.put(this.filter.getValue(nameVariableIndex, (long)possibleRootNodeNumber), new double[]{targetNodeHight, targetNodeLeafAxisPosition});
        this.needToBuildMetaData = false;
        return true;
    }

    protected double calculatePositionOnLeafAxis(int targetNodeObsNumber, int[] indices) {
        Object targetNodeName = this.filter.getValue(indices[0], (long)targetNodeObsNumber);
        boolean targetNodeHasChildren = false;
        double childPositionMin = Double.MAX_VALUE;
        double childPositionMax = Double.MIN_VALUE;
        double thisChildPosition = 0.0;
        Object currentParent = null;
        for (int currentNodeObsNumber = this.numberOfObs - 1; currentNodeObsNumber >= 0; --currentNodeObsNumber) {
            currentParent = this.filter.getValue(indices[1], (long)currentNodeObsNumber);
            if (!currentParent.toString().equalsIgnoreCase(targetNodeName.toString())) continue;
            thisChildPosition = this.calculatePositionOnLeafAxis(currentNodeObsNumber, indices);
            childPositionMin = Math.min(childPositionMin, thisChildPosition);
            childPositionMax = Math.max(childPositionMax, thisChildPosition);
            targetNodeHasChildren = true;
        }
        if (targetNodeHasChildren) {
            double targetNodeLeafAxisPosition = (childPositionMin + childPositionMax) / 2.0;
            double targetNodeHeight = this.filter.getNumericValue(indices[2], (long)targetNodeObsNumber);
            this.parentNameToLeafAxisPositionMap.put(targetNodeName, new double[]{targetNodeHeight, targetNodeLeafAxisPosition});
            System.out.println("(cluster,heightCoord,leafCoord)=( " + targetNodeName.toString() + " , " + targetNodeHeight + " , " + targetNodeLeafAxisPosition + " )");
            return targetNodeLeafAxisPosition;
        }
        this.nameCharMapper.addValue(targetNodeName);
        return this.nameCharMapper.getIndex(targetNodeName);
    }

    protected void connectToParent(Graphics2D g, int nodeObsNumber, int parentVariableIndex, int nameVariableIndex, int heightVariableIndex) {
    }

    @Override
    protected void drawChart(Graphics g) {
        if (this.filter == null) {
            return;
        }
        int nameVariableIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.nameRole, 0));
        int parentVariableIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.parentRole, 0));
        int heightVariableIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.heightRole, 0));
        if (nameVariableIndex < 0 || parentVariableIndex < 0 || heightVariableIndex < 0) {
            return;
        }
        Object nodeName = null;
        int leafListIndex = -1;
        double[] nodePosition = new double[2];
        double[] parentPosition = new double[2];
        int maxValue = (int)Math.pow(2.0, 15.0) - 100;
        int minValue = -maxValue;
        for (int i = this.numberOfObs - 1; i >= 0; --i) {
            int parentL;
            int parentH;
            int nodeL;
            int nodeH;
            if (!this.filter.isGraphed((long)i)) continue;
            nodeName = this.filter.getValue(nameVariableIndex, (long)i);
            leafListIndex = this.nameCharMapper.getIndex(nodeName);
            if (leafListIndex >= 0) {
                nodePosition[1] = leafListIndex;
                nodePosition[0] = this.filter.getNumericValue(heightVariableIndex, (long)i);
            } else {
                nodePosition = (double[])this.parentNameToLeafAxisPositionMap.get(nodeName);
            }
            parentPosition = (double[])this.parentNameToLeafAxisPositionMap.get(this.filter.getValue(parentVariableIndex, (long)i));
            if (nodePosition == null || parentPosition == null || Double.isNaN(nodePosition[0]) || Double.isNaN(nodePosition[1]) || Double.isNaN(parentPosition[0]) || Double.isNaN(parentPosition[1])) continue;
            g.setColor(this.defaultLineColor);
            if (this.isOrientationAxisVertical()) {
                this.nodeScreenCoords = this.transformObject.project(nodePosition[1], nodePosition[0], 0.0, this.nodeScreenCoords);
                this.parentScreenCoords = this.transformObject.project(parentPosition[1], parentPosition[0], 0.0, this.parentScreenCoords);
                nodeH = (int)Math.max((double)minValue, Math.min((double)maxValue, this.nodeScreenCoords[0]));
                nodeL = (int)Math.max((double)minValue, Math.min((double)maxValue, this.nodeScreenCoords[1]));
                parentH = (int)Math.max((double)minValue, Math.min((double)maxValue, this.parentScreenCoords[0]));
                parentL = (int)Math.max((double)minValue, Math.min((double)maxValue, this.parentScreenCoords[1]));
                g.drawLine(nodeH, nodeL, nodeH, parentL);
                g.drawLine(nodeH, parentL, parentH, parentL);
                continue;
            }
            this.nodeScreenCoords = this.transformObject.project(nodePosition[0], nodePosition[1], 0.0, this.nodeScreenCoords);
            this.parentScreenCoords = this.transformObject.project(parentPosition[0], parentPosition[1], 0.0, this.parentScreenCoords);
            nodeH = (int)Math.max((double)minValue, Math.min((double)maxValue, this.nodeScreenCoords[0]));
            nodeL = (int)Math.max((double)minValue, Math.min((double)maxValue, this.nodeScreenCoords[1]));
            parentH = (int)Math.max((double)minValue, Math.min((double)maxValue, this.parentScreenCoords[0]));
            parentL = (int)Math.max((double)minValue, Math.min((double)maxValue, this.parentScreenCoords[1]));
            g.drawLine(nodeH, nodeL, parentH, nodeL);
            g.drawLine(parentH, nodeL, parentH, parentL);
        }
    }

    @Override
    protected void drawSelected(Graphics g) {
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        return null;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        return false;
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (this.filter == null || this.nameCharMapper == null || which == null) {
            return null;
        }
        Enumeration e = Extract.elements((Object)which);
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            if (!this.nameRole.equals(element)) continue;
            return new DiscreteRange(this.nameCharMapper.getValues());
        }
        return super.getPreferredRange(which);
    }

    @Override
    public Object getPropertyValue(int id) {
        switch (id) {
            case 19087: {
                if (this.isOrientationAxisVertical()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case 19088: {
                if (this.isOrientationAxisVertical()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 19064: {
                if (this.isOrientationAxisVertical()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case 19065: {
                if (this.isOrientationAxisVertical()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 19057: {
                if (!this.isOrientationAxisVertical()) {
                    return new Object[]{RoleInterface.ROLE_HEIGHT};
                }
                return new Object[]{RoleInterface.ROLE_NAME};
            }
            case 19056: {
                if (!this.isOrientationAxisVertical()) {
                    return new Object[]{RoleInterface.ROLE_NAME};
                }
                return new Object[]{RoleInterface.ROLE_HEIGHT};
            }
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        this.needToBuildMetaData = true;
        this.assert_metaDataIsBuilt();
    }
}

