/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.silk.base.AbstractBaseElementCellProvider;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementContainer;
import com.sas.graphics.silk.base.DensityPlotElement;
import com.sas.graphics.silk.base.LinePlotElement;
import com.sas.graphics.silk.base.ScatterElement;
import com.sas.graphics.silk.base.TextElement;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import java.awt.Color;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class DefaultMatrixCellProvider
extends AbstractBaseElementCellProvider
implements RoleListenerInterface {
    public static final int SERIES = 1;
    public static final int LINE = 1;
    public static final int SCATTER = 2;
    public static final int DENSITY_PLOT = 3;
    private SILKNumber MATRIX_ROLE = null;
    private int componentType;
    private Vector matrixVars = null;
    private boolean rebuildRequired = false;
    private boolean building = false;
    private BaseElementContainer[][] elements = null;
    private Roles r = Roles.getInstance(null);
    private Border border = null;

    public DefaultMatrixCellProvider() {
        this(2);
    }

    public DefaultMatrixCellProvider(int componentType) {
        this.MATRIX_ROLE = this.r.getRoleObject("ROLE_MATRIX_VAR");
        this.roles.newRole((Object)this.MATRIX_ROLE, "MatrixVar", 99);
        this.roles.setRoleType((Object)this.MATRIX_ROLE, 1);
        this.roles.addRoleListener(this);
        this.setComponentType(componentType);
        this.matrixVars = new Vector();
        this.border = new LineBorder(Color.gray, 1);
    }

    public void setComponentType(int componentType) {
        switch (componentType) {
            case 1: 
            case 2: 
            case 3: {
                this.componentType = componentType;
            }
        }
    }

    private void build() {
        int i;
        if (!this.rebuildRequired) {
            return;
        }
        if (this.building) {
            return;
        }
        if (this.filter == null) {
            return;
        }
        this.building = true;
        this.matrixVars.removeAllElements();
        Object o = this.roles.getVariable((Object)this.MATRIX_ROLE);
        int type = Extract.getSourceType((Object)o);
        int n = Extract.getNumberItems((Object)o, (int)type);
        for (i = 0; i < n; ++i) {
            Object var = Extract.getObject((Object)o, (int)i, (int)type);
            if (var == null || this.filter.getVariableIndex(var) < 0) continue;
            this.matrixVars.add(var);
        }
        this.elements = new BaseElementContainer[this.matrixVars.size()][this.matrixVars.size()];
        for (i = 0; i < this.matrixVars.size(); ++i) {
            for (int j = 0; j < this.matrixVars.size(); ++j) {
                if (i == j) {
                    TextElement te = new TextElement(this.matrixVars.elementAt(i).toString());
                    te.setOuterMargin(new Insets(0, 0, 0, 0));
                    te.setId(this.matrixVars.elementAt(i).toString());
                    this.elements[i][j] = new BaseElementContainer(te);
                } else {
                    this.elements[i][j] = this.createElement(this.matrixVars.elementAt(j), this.matrixVars.elementAt(i));
                }
                this.elements[i][j].setBorder(this.border);
            }
        }
        this.building = false;
        this.rebuildRequired = false;
    }

    private BaseElementContainer createElement(Object xVar, Object yVar) {
        BaseElement be = null;
        switch (this.componentType) {
            case 1: {
                be = new LinePlotElement();
                break;
            }
            case 2: {
                be = new ScatterElement();
                break;
            }
            case 3: {
                be = new DensityPlotElement();
            }
        }
        be.setDataSource(this.dataSource);
        be.setRole(xVar, ROLE_X);
        be.setRole(yVar, ROLE_Y);
        be.setId(xVar.toString() + ":" + yVar.toString());
        be.setAxesVisible(false);
        be.setOuterMargin(new Insets(0, 0, 0, 0));
        BaseElementContainer bec = new BaseElementContainer(be);
        return bec;
    }

    @Override
    public Object getColumnAxis(int col, boolean primary) {
        return null;
    }

    @Override
    public Object getRowAxis(int row, boolean primary) {
        return null;
    }

    @Override
    public Object getCellElement(int column, int row) {
        if (row < 0 || row >= this.matrixVars.size() || column < 0 || column >= this.matrixVars.size()) {
            return null;
        }
        return this.elements[row][column];
    }

    @Override
    public int getNumberColumns() {
        if (this.rebuildRequired) {
            this.build();
        }
        return this.matrixVars.size();
    }

    @Override
    public int getNumberRows() {
        if (this.rebuildRequired) {
            this.build();
        }
        return this.matrixVars.size();
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        switch (e.role) {
            case 39: {
                this.rebuildRequired = true;
                this.build();
            }
        }
    }
}

