/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.FilterDataVariable;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.BrushListener;
import com.sas.graphics.silk.interfaces.ContourInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.util.Brush;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.ods.data.BaseData;
import com.sas.graphics.util.ods.data.DataVariableInterface;
import com.sas.graphics.util.ods.data.GriddedChartData;
import com.sas.graphics.util.ods.visual.ColorRamp;
import com.sas.graphics.util.ods.visual.IVIZColor;
import com.sas.graphics.util.ods.visual.jxd.JxdContours;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class ContourElement
extends BaseElement
implements ContourInterface,
BrushListener {
    GriddedChartData gridData = null;
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    protected SILKNumber responseRole = null;
    protected FilterDataVariable xFilterVar = null;
    protected FilterDataVariable yFilterVar = null;
    protected FilterDataVariable responseFilterVar = null;
    protected Channel channel = null;
    protected JxdContours contour = null;
    protected boolean lineLabelsOn = true;
    protected ContinuousRange selectionRange = null;
    protected double selectionStartValue = Double.NaN;
    protected boolean isSelecting = false;
    protected boolean localSelection = false;
    protected int numLevels = 6;
    protected boolean autoCalcLevels = true;
    protected double minLevel = Double.NaN;
    protected double maxLevel = Double.NaN;
    protected String[] contourStyleList;
    protected SILKNumber[] orientationList;
    protected String currentLegend = null;
    protected int interpXCount = -20;
    protected int interpYCount = -20;
    public static final int[] supportedContourProperties = new int[]{24, 25, 23, 39, 433, 426, 434, 441, 10404, 10403, 10401, 10406, 10407, 10408, 10409, 10410};

    public ContourElement() {
        Roles r = Roles.getInstance(null);
        this.xRole = r.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 1);
        this.yRole = r.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1);
        this.roles.setRoleType((Object)this.yRole, 1);
        this.responseRole = r.getRoleObject("ROLE_RESPONSE");
        this.roles.newRole((Object)this.responseRole, "Response", 1);
        this.roles.setRoleType((Object)this.responseRole, 1);
        this.selectionRange = new ContinuousRange(Double.NaN, Double.NaN);
        this.setSupportedProperties(supportedContourProperties);
        this.userSetProperties.appendProperties(supportedContourProperties);
        this.contourStyleList = new String[3];
        this.contourStyleList[0] = ResourceLoader.getResourceString((Object)this.rb, (String)"ContourElement.Area.txt", (String)"Area");
        this.contourStyleList[1] = ResourceLoader.getResourceString((Object)this.rb, (String)"ContourElement.Block.txt", (String)"Block");
        this.contourStyleList[2] = ResourceLoader.getResourceString((Object)this.rb, (String)"ContourElement.Lines.txt", (String)"Lines");
        this.orientationList = new SILKNumber[2];
        this.orientationList[0] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"ContourElement.Horizontal.txt", (String)"Horizontal"), "Horizontal");
        this.orientationList[1] = new SILKNumber(1, ResourceLoader.getResourceString((Object)this.rb, (String)"ContourElement.Tangent.txt", (String)"Tangent"), "Tangent");
        this.rampName = "ThreeColorRamp";
        this.channel = new Channel((Component)new Container(), 2);
        this.initContour();
        this.addChartTabInfo("com.sas.graphics.silk.ui.ContourPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"ContourElement.Contour.txt", (String)"Contour"));
    }

    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                Object xVar = this.roles.getVariable((Object)this.xRole, 0);
                this.xFilterVar = new FilterDataVariable(this.filter, xVar);
                break;
            }
            case 25: {
                Object yVar = this.roles.getVariable((Object)this.yRole, 0);
                this.yFilterVar = new FilterDataVariable(this.filter, yVar);
                break;
            }
            case 17: {
                Object responseVar = this.roles.getVariable((Object)this.responseRole, 0);
                this.responseFilterVar = new FilterDataVariable(this.filter, responseVar);
                break;
            }
            default: {
                return;
            }
        }
        this.initGriddedData();
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                this.xFilterVar = null;
                break;
            }
            case 25: {
                this.yFilterVar = null;
                break;
            }
            case 17: {
                this.responseFilterVar = null;
                break;
            }
            default: {
                return;
            }
        }
        this.gridData = null;
    }

    protected boolean initGriddedData() {
        if (this.xFilterVar == null || this.yFilterVar == null || this.responseFilterVar == null) {
            this.gridData = null;
            return false;
        }
        BaseData data = new BaseData(null);
        data.AddVariable((DataVariableInterface)this.xFilterVar);
        data.AddVariable((DataVariableInterface)this.yFilterVar);
        data.AddVariable((DataVariableInterface)this.responseFilterVar);
        this.gridData = new GriddedChartData();
        this.gridData.SetDataSource((Object)data);
        int numObs = this.filter.getNumberObservations(-1);
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Object yVar = this.roles.getVariable((Object)this.yRole, 0);
        Object[] xUniques = ((DataFilterInfoInterface)this.filter).getUniqueValues(xVar, true);
        Object[] yUniques = ((DataFilterInfoInterface)this.filter).getUniqueValues(yVar, true);
        if (xUniques != null && yUniques != null && xUniques.length * yUniques.length > numObs) {
            this.gridData.setInterpolationScheme(1);
            this.gridData.setInterpolationCounts(this.interpXCount, this.interpYCount);
        } else {
            this.gridData.setInterpolationScheme(2);
        }
        boolean success = this.gridData.BuildGriddedData((Object)this.xFilterVar, (Object)this.yFilterVar, (Object)this.responseFilterVar);
        if (success) {
            this.contour.SetDataSourceObject((Object)this.gridData);
            this.contour.Build(null);
        } else {
            this.gridData = null;
            this.contour.SetDataSourceObject(null);
        }
        this.generateContourLevels();
        return success;
    }

    protected boolean generateContourLevels() {
        if (this.contour != null) {
            boolean rc = this.contour.GenerateLevels(this.numLevels, this.minLevel, this.maxLevel, this.autoCalcLevels);
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
            this.resetColorRamp();
            return rc;
        }
        return false;
    }

    protected void initContour() {
        this.contour = new JxdContours((Object)this.channel);
        this.contour.Create();
        this.applyStyleElement();
        this.channel.glDisable(3);
        this.contour.setLabelStyle(1);
        this.contour.setContourAlgorithm(0);
        this.setContourStyle(0);
    }

    protected void setViewport() {
        if (this.channel != null && !this.bounds.isEmpty()) {
            this.channel.glViewport(this.bounds.x + this.innerMargin.left, this.bounds.y + this.innerMargin.top, this.bounds.width - this.innerMargin.left - this.innerMargin.right, this.bounds.height - this.innerMargin.top - this.innerMargin.bottom);
        }
    }

    protected void setProjection() {
        if (this.channel != null) {
            DataRange xrange = this.getDataRange((byte)1);
            DataRange yrange = this.getDataRange((byte)2);
            if (xrange == null || yrange == null || !(xrange instanceof ContinuousRange) || !(yrange instanceof ContinuousRange)) {
                return;
            }
            boolean reverseX = this.getTransformObject().isReverse(0);
            double xMin = reverseX ? ((ContinuousRange)xrange).getMax() : ((ContinuousRange)xrange).getMin();
            double xMax = reverseX ? ((ContinuousRange)xrange).getMin() : ((ContinuousRange)xrange).getMax();
            boolean reverseY = this.getTransformObject().isReverse(1);
            double yMin = reverseY ? ((ContinuousRange)yrange).getMax() : ((ContinuousRange)yrange).getMin();
            double yMax = reverseY ? ((ContinuousRange)yrange).getMin() : ((ContinuousRange)yrange).getMax();
            this.channel.glOrtho(xMin, xMax, yMin, yMax, -1.0, 1.0);
        }
    }

    protected void setView() {
        if (this.channel != null) {
            this.channel.glLoadIdentity();
            this.channel.gluLookAt(0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0);
        }
    }

    private boolean isSelection() {
        return !Double.isNaN(this.selectionRange.getMin()) && !Double.isNaN(this.selectionRange.getMax());
    }

    private void resetSelectionRange() {
        this.selectionRange.setMin(Double.NaN);
        this.selectionRange.setMax(Double.NaN);
    }

    protected void startSelection(int x, int y) {
        if (this.contour == null) {
            return;
        }
        this.isSelecting = true;
        this.resetSelectionRange();
        Double value = this.contour.GetValueAtLocation(x, y);
        this.selectionStartValue = value != null ? value : Double.NaN;
    }

    protected void dragSelection(int x, int y) {
        if (this.contour == null || Double.isNaN(this.selectionStartValue)) {
            return;
        }
        Double value = this.contour.GetValueAtLocation(x, y);
        if (value == null || Double.isNaN(value)) {
            return;
        }
        if (value < this.selectionStartValue) {
            this.selectionRange.setMin(value.doubleValue());
            this.selectionRange.setMax(this.selectionStartValue);
        } else {
            this.selectionRange.setMin(this.selectionStartValue);
            this.selectionRange.setMax(value.doubleValue());
        }
    }

    protected void endSelection() {
        this.selectionStartValue = Double.NaN;
        this.isSelecting = false;
    }

    protected void startDragSelectionEdge(int x, int y) {
        double maxDelta;
        if (this.contour == null || !this.isSelection()) {
            return;
        }
        Double value = this.contour.GetValueAtLocation(x, y);
        if (value == null || Double.isNaN(value)) {
            return;
        }
        double minDelta = Math.abs(value - this.selectionRange.getMin());
        this.selectionStartValue = minDelta < (maxDelta = Math.abs(value - this.selectionRange.getMax())) ? this.selectionRange.getMax() : this.selectionRange.getMin();
    }

    protected void doSelection() {
        this.localSelection = true;
        this.filter.unselectAll();
        if (this.isSelection()) {
            Object responseVar = this.roles.getVariable((Object)this.responseRole, 0);
            if (responseVar == null) {
                return;
            }
            String[] var = new String[]{responseVar.toString()};
            DataRange[] range = new DataRange[]{this.selectionRange};
            this.filter.setSelected(var, range, true);
        }
        this.localSelection = false;
        this.fireLayerListenerChanged(2);
    }

    protected void updateSelectionRange() {
        int rVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.responseRole, 0));
        if (rVarIndex < 0) {
            return;
        }
        if (!this.selections.hasMoreSelections()) {
            this.resetSelectionRange();
            return;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        while (this.selections.hasMoreSelections()) {
            int index = this.selections.nextSelectedIndex();
            double rValue = this.filter.getNumericValue(rVarIndex, (long)index);
            if (rValue < min) {
                min = rValue;
            }
            if (!(rValue > max)) continue;
            max = rValue;
        }
        this.selectionRange.setMin(min);
        this.selectionRange.setMax(max);
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
            }
        }
    }

    @Override
    protected void drawChart(Graphics g) {
        if (this.contour == null || this.gridData == null) {
            return;
        }
        this.channel.setSingleBufferGraphics(g);
        this.setProjection();
        this.setView();
        this.contour.Draw(null, false);
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.contour == null || this.gridData == null || !this.isSelection() || !this.isSelectable()) {
            return;
        }
        this.channel.setSingleBufferGraphics(g);
        this.setProjection();
        this.setView();
        int polyMode = this.channel.getPolygonMode();
        this.channel.glPolygonMode(7);
        int lineWidth = this.contour.getLineWidth();
        this.contour.setLineWidth(2);
        int linestyle = this.contour.getLineStyle();
        this.contour.setLineStyle(1);
        this.channel.lineCapStyle(1);
        Color selectionColor = this.style.getFillStyleElement("Selection").getFillColor();
        this.contour.SetHighlightColor(selectionColor);
        this.contour.setHighlightAreaValues(this.selectionRange.getMin(), this.selectionRange.getMax());
        this.contour.drawHighlightArea(true);
        this.channel.glPolygonMode(polyMode);
        this.channel.lineCapStyle(0);
        this.contour.setLineWidth(lineWidth);
        this.contour.setLineStyle(linestyle);
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.type == 2 && !this.localSelection) {
            this.updateSelectionRange();
        }
        super.dataFilterChanged(evt);
        if (evt.type == 3 || evt.type == 1) {
            this.initGriddedData();
        }
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        return false;
    }

    @Override
    public void brush(Brush source, int mouseAction, MouseEvent e) {
        if (e == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int[] point = source.boundToChartArea(x, y);
        x = point[0];
        y = point[1];
        switch (mouseAction) {
            case 1: {
                if (this.isSelection() && this.isOverSelectionEdge(x, y)) {
                    this.startDragSelectionEdge(x, y);
                    break;
                }
                this.startSelection(x, y);
                break;
            }
            case 2: {
                this.endSelection();
                break;
            }
            case 3: {
                this.dragSelection(x, y);
            }
        }
        this.doSelection();
        source.setDefaultBrushListenerEnabled(false);
    }

    @Override
    public void drawViewport(Brush source, int mouseAction, MouseEvent e) {
        source.setDefaultBrushListenerEnabled(true);
    }

    @Override
    public void select(Brush source, int mouseAction, MouseEvent e) {
        if (e == null || e.isPopupTrigger()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int[] point = source.boundToChartArea(x, y);
        x = point[0];
        y = point[1];
        switch (mouseAction) {
            case 1: {
                this.startSelection(x, y);
                break;
            }
            case 2: {
                this.endSelection();
                break;
            }
            case 3: {
                this.dragSelection(x, y);
            }
        }
        this.doSelection();
        source.setDefaultBrushListenerEnabled(false);
    }

    private boolean isOverSelectionEdge(int x, int y) {
        if (this.contour == null || !this.isSelection()) {
            return false;
        }
        Double topLeft = this.contour.GetValueAtLocation(x - 2, y - 2);
        Double topRight = this.contour.GetValueAtLocation(x + 2, y - 2);
        Double bottomLeft = this.contour.GetValueAtLocation(x - 2, y + 2);
        Double bottomRight = this.contour.GetValueAtLocation(x + 2, y + 2);
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        if (topLeft != null && !topLeft.isNaN()) {
            if (topLeft > max) {
                max = topLeft;
            }
            if (topLeft < min) {
                min = topLeft;
            }
        }
        if (topRight != null && !topRight.isNaN()) {
            if (topRight > max) {
                max = topRight;
            }
            if (topRight < min) {
                min = topRight;
            }
        }
        if (bottomLeft != null && !bottomLeft.isNaN()) {
            if (bottomLeft > max) {
                max = bottomLeft;
            }
            if (bottomLeft < min) {
                min = bottomLeft;
            }
        }
        if (bottomRight != null && !bottomRight.isNaN()) {
            if (bottomRight > max) {
                max = bottomRight;
            }
            if (bottomRight < min) {
                min = bottomRight;
            }
        }
        double selectionMin = this.selectionRange.getMin();
        double selectionMax = this.selectionRange.getMax();
        if (selectionMin >= min && selectionMin <= max) {
            return true;
        }
        return selectionMax >= min && selectionMax <= max;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        if (this.contour == null || this.isSelecting) {
            return null;
        }
        double[] values = new double[]{screenX, screenY, 0.0};
        this.channel.gluUnProject(values, values);
        Double contourValue = this.contour.GetValueAtLocation(values[0], values[1], values[2]);
        if (contourValue == null || Double.isNaN(contourValue)) {
            return null;
        }
        values[2] = contourValue;
        StringBuffer sb = new StringBuffer();
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        sb.append(this.filter.getVariableDescription(xVar));
        sb.append(" \t= \t ");
        sb.append(this.getFormattedValue(xVar, new Double(values[0])));
        sb.append("\n");
        Object yVar = this.roles.getVariable((Object)this.yRole, 0);
        sb.append(this.filter.getVariableDescription(yVar));
        sb.append(" \t= \t ");
        sb.append(this.getFormattedValue(yVar, new Double(values[1])));
        sb.append("\n");
        Object rVar = this.roles.getVariable((Object)this.responseRole, 0);
        sb.append(this.filter.getVariableDescription(rVar));
        sb.append(" \t= \t ");
        sb.append(this.getFormattedValue(rVar, new Double(values[2])));
        return sb.toString();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        if (this.channel != null && !this.bounds.isEmpty()) {
            this.channel.glViewport(this.bounds.x + this.innerMargin.left, this.bounds.y + this.innerMargin.top, this.bounds.width - this.innerMargin.left - this.innerMargin.right, this.bounds.height - this.innerMargin.top - this.innerMargin.bottom);
        }
    }

    @Override
    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (rc) {
            this.applyStyleElement();
        }
        return rc;
    }

    public void applyStyleElement() {
        if (this.contour == null || this.style == null) {
            return;
        }
        Color defaultColor = this.style.getLineStyleElement("GraphDataStyleDefault").getLineColor();
        this.contour.setLineOverlayColor(defaultColor);
        switch (this.contour.GetStyle()) {
            case 2: {
                Color lineColor = this.style.getLineStyleElement(this.fillAttrs.getReference()).getLineColor();
                Color[] lineColors = new Color[]{lineColor, lineColor};
                IVIZColor contrastRamp = this.contour.GetColorRamp();
                if (contrastRamp == null) {
                    contrastRamp = new ColorRamp((Object)lineColors, null);
                } else {
                    contrastRamp.SetColors((Object)lineColors, null);
                }
                this.contour.SetColorRamp(contrastRamp);
                break;
            }
            case 0: 
            case 1: {
                this.resetColorRamp();
            }
        }
    }

    @Override
    public boolean setContourStyle(int style) {
        int oldStyle = this.contour.GetStyle();
        String styleString = this.contour.GetStyle(style);
        if (styleString == null || styleString.equalsIgnoreCase("surface")) {
            return false;
        }
        if (oldStyle == style) {
            return true;
        }
        this.contour.SetStyle(styleString);
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 4, null, 4));
        if (style == 2) {
            this.contour.setContourAlgorithm(1);
        } else if (oldStyle == 2) {
            this.contour.setContourAlgorithm(0);
        }
        this.applyStyleElement();
        this.userSetProperties.set(10401);
        return true;
    }

    @Override
    public int getContourStyle() {
        return this.contour.GetStyle();
    }

    @Override
    public boolean setLineLabelsOn(boolean labelsOn) {
        if (labelsOn == this.lineLabelsOn) {
            return true;
        }
        this.lineLabelsOn = labelsOn;
        if (this.lineLabelsOn) {
            this.contour.setLabelStyle(1);
        } else {
            this.contour.setLabelStyle(0);
        }
        if (this.contour.GetStyle() == 2) {
            this.contour.setContourAlgorithm(1);
        } else {
            this.contour.setContourAlgorithm(0);
        }
        this.userSetProperties.set(10403);
        return true;
    }

    @Override
    public boolean areLineLabelsOn() {
        return this.lineLabelsOn;
    }

    @Override
    public boolean setLineLabelOrientation(int orientation) {
        this.userSetProperties.set(10404);
        return this.contour.setLabelOrientation(orientation);
    }

    @Override
    public int getLineLabelOrientation() {
        return this.contour.getLabelOrientation();
    }

    @Override
    public boolean setNumLevels(int nLevels) {
        if (nLevels == this.numLevels) {
            return true;
        }
        this.numLevels = nLevels;
        this.userSetProperties.set(10406);
        boolean rc = this.generateContourLevels();
        return rc;
    }

    @Override
    public int getNumLevels() {
        return this.numLevels;
    }

    @Override
    public boolean setMinLevel(double min) {
        if (min == this.minLevel) {
            return true;
        }
        this.minLevel = min;
        this.userSetProperties.set(10407);
        return this.generateContourLevels();
    }

    @Override
    public double getMinLevel() {
        if (this.contour == null) {
            return Double.NaN;
        }
        double[] levels = this.contour.GetLevels();
        if (levels == null || levels.length < 1) {
            return Double.NaN;
        }
        return levels[0];
    }

    @Override
    public boolean setMaxLevel(double max) {
        if (max == this.maxLevel) {
            return true;
        }
        this.maxLevel = max;
        this.userSetProperties.set(10408);
        return this.generateContourLevels();
    }

    @Override
    public double getMaxLevel() {
        if (this.contour == null) {
            return Double.NaN;
        }
        double[] levels = this.contour.GetLevels();
        if (levels == null || levels.length < 1) {
            return Double.NaN;
        }
        return levels[levels.length - 1];
    }

    @Override
    public boolean setAutoCalculateLevels(boolean autoCalc) {
        if (autoCalc == this.autoCalcLevels) {
            return true;
        }
        this.autoCalcLevels = autoCalc;
        this.userSetProperties.set(10409);
        return this.generateContourLevels();
    }

    @Override
    public boolean getAutoCalculateLevels() {
        return this.autoCalcLevels;
    }

    @Override
    public boolean setShowContourLines(boolean showLines) {
        if (this.contour == null) {
            return false;
        }
        boolean oldVal = this.contour.getShowLineOverlay();
        if (showLines == oldVal) {
            return true;
        }
        this.userSetProperties.set(10410);
        this.contour.setShowLineOverlay(showLines);
        return true;
    }

    @Override
    public boolean getShowContourLines() {
        if (this.contour == null) {
            return false;
        }
        return this.contour.getShowLineOverlay();
    }

    protected boolean setContourStyle(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Integer) {
            return this.setContourStyle((Integer)value);
        }
        if (value instanceof String) {
            String stringVal = (String)value;
            for (int i = 0; i < this.contourStyleList.length; ++i) {
                if (!stringVal.equalsIgnoreCase(this.contourStyleList[i])) continue;
                return this.setContourStyle(i);
            }
            return false;
        }
        return false;
    }

    protected String getContourStyleString() {
        int style = this.getContourStyle();
        if (style >= 0 && style < this.contourStyleList.length) {
            return this.contourStyleList[this.getContourStyle()];
        }
        return null;
    }

    protected void setLineLabelOrientation(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            this.setLineLabelOrientation(((Number)value).intValue());
        } else if (value instanceof String) {
            if (((String)value).equalsIgnoreCase("HORIZONTAL")) {
                this.setLineLabelOrientation(0);
            } else if (((String)value).equalsIgnoreCase("TANGENT")) {
                this.setLineLabelOrientation(1);
            }
        }
    }

    protected String getLineLabelOrientationString() {
        switch (this.getLineLabelOrientation()) {
            case 0: {
                return "horizontal";
            }
            case 1: {
                return "tangent";
            }
        }
        return "horizontal";
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (!this.responseRole.toString().equalsIgnoreCase(this.currentLegend)) break;
                rc = this.roles.getVariable((Object)this.responseRole, 0);
                break;
            }
            case 24: 
            case 25: {
                rc = this.responseRole;
                break;
            }
            case 39: {
                rc = new Boolean(this.getContourStyle() == 2);
                break;
            }
            case 433: {
                rc = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 426: {
                rc = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                rc = new Boolean(this.isContinuousLegend(this.currentLegend));
                break;
            }
            case 10401: {
                rc = this.getContourStyleString();
                break;
            }
            case 10402: {
                rc = this.contourStyleList;
                break;
            }
            case 10403: {
                rc = new Boolean(this.areLineLabelsOn());
                break;
            }
            case 10404: {
                rc = this.getLineLabelOrientationString();
                break;
            }
            case 10405: {
                rc = this.orientationList;
                break;
            }
            case 10406: {
                rc = new Integer(this.numLevels);
                break;
            }
            case 10407: {
                rc = new Double(this.getMinLevel());
                break;
            }
            case 10408: {
                rc = new Double(this.getMaxLevel());
                break;
            }
            case 10409: {
                rc = new Boolean(this.autoCalcLevels);
                break;
            }
            case 10410: {
                rc = new Boolean(this.getShowContourLines());
                break;
            }
            case 53: {
                if (this.contour.GetStyle() != 2) {
                    rc = this.rampName;
                    break;
                }
                rc = null;
                break;
            }
            case 19082: 
            case 19083: {
                rc = Boolean.FALSE;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 10401: {
                this.setContourStyle(value);
                break;
            }
            case 10403: {
                if (!(value instanceof Boolean)) break;
                this.setLineLabelsOn((Boolean)value);
                break;
            }
            case 10404: {
                this.setLineLabelOrientation(value);
                break;
            }
            case 10406: {
                if (!(value instanceof Integer)) break;
                this.setNumLevels((Integer)value);
                break;
            }
            case 10407: {
                if (!(value instanceof Double)) break;
                this.setMinLevel((Double)value);
                break;
            }
            case 10408: {
                if (!(value instanceof Double)) break;
                this.setMaxLevel((Double)value);
                break;
            }
            case 10409: {
                if (!(value instanceof Boolean)) break;
                this.setAutoCalculateLevels((Boolean)value);
                break;
            }
            case 10410: {
                if (!(value instanceof Boolean)) break;
                this.setShowContourLines((Boolean)value);
                break;
            }
            case 53: {
                if (value == null) break;
                this.rampName = value.toString();
                if (this.colorMapper != null) {
                    this.colorMapper.unRegister(this);
                }
                this.colorMapper = null;
                this.userSetProperties.set(53);
                this.initColorRamp();
                this.applyStyleElement();
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                String leg;
                if (value == null || !(leg = value.toString()).equalsIgnoreCase(this.responseRole.toString())) break;
                this.currentLegend = leg;
                return true;
            }
        }
        return rc;
    }

    @Override
    public BrushListener getBrushListener() {
        if (this.isSelectable()) {
            return this;
        }
        return super.getBrushListener();
    }

    protected Object getLegendEntries(String currentLegend) {
        if (currentLegend == null || this.contour == null) {
            return null;
        }
        if (this.responseRole.toString().equalsIgnoreCase(currentLegend)) {
            Object rv = null;
            switch (this.contour.GetStyle()) {
                case 1: {
                    rv = this.getContinuousLegendEntries();
                    break;
                }
                case 0: {
                    rv = this.getContinuousLegendEntries();
                    break;
                }
            }
            return rv;
        }
        return null;
    }

    protected Object getContinuousLegendEntries() {
        if (this.colorMapper == null) {
            this.initColorRamp();
        }
        if (this.colorMapper == null) {
            return null;
        }
        Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
        ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4);
        if (r == null) {
            return null;
        }
        Color c = this.colorMapper.getColor(r.getMin());
        double cv = r.getMin();
        MarkerAttrib msi = new MarkerAttrib(true, c);
        legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
        c = this.colorMapper.getNeutralColor();
        if (c != null && r.contains((DataPoint)new ContinuousPoint(this.colorMapper.getNeutralValue()))) {
            cv = this.colorMapper.getNeutralValue();
            msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
        }
        c = this.colorMapper.getColor(r.getMax());
        cv = r.getMax();
        msi = new MarkerAttrib(true, c);
        legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
        return legendEntries;
    }

    protected Object getContinuousBlockLegendEntries() {
        IVIZColor ramp = this.contour.GetColorRamp();
        if (ramp == null) {
            return null;
        }
        int numLevels = this.contour.GetNumberLevels();
        double min = this.contour.GetColorMin();
        double max = this.contour.GetColorMax();
        Color[] colors = this.contour.GetLevelColors();
        if (colors == null || colors.length != numLevels) {
            return null;
        }
        Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(numLevels * 2);
        double stride = (max - min) / (double)numLevels;
        for (int i = 0; i < numLevels; ++i) {
            MarkerAttrib ms = new MarkerAttrib(true, colors[i]);
            legendEntries.add(new LegendEntry(new Double(min + stride * (double)i), ms, null));
            legendEntries.add(new LegendEntry(new Double(min + stride * (double)(i + 1)), ms, null));
        }
        return legendEntries;
    }

    protected Object getDiscreteLegendEntries() {
        IVIZColor ramp = this.contour.GetColorRamp();
        if (ramp == null) {
            return null;
        }
        String[] levels = this.contour.GetLevelLabels();
        Color[] colors = this.contour.GetLevelColors();
        if (levels == null || colors == null || levels.length < 1 || colors.length != levels.length) {
            return null;
        }
        Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(levels.length);
        for (int i = 0; i < levels.length; ++i) {
            MarkerAttrib ms = new MarkerAttrib(true, colors[i]);
            legendEntries.add(new LegendEntry(levels[i], ms, null));
        }
        return legendEntries;
    }

    protected Object getLegendTitle(String currentLegend) {
        if (currentLegend == null || this.filter == null) {
            return null;
        }
        if (this.responseRole.toString().equalsIgnoreCase(currentLegend)) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.responseRole, 0));
        }
        return null;
    }

    protected boolean isContinuousLegend(String currentLegend) {
        if (currentLegend == null || this.contour == null) {
            return false;
        }
        return this.responseRole.toString().equalsIgnoreCase(currentLegend);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        DataRange rc = null;
        if (dimension == 4) {
            if (this.getContourStyle() == 2) {
                return null;
            }
            if (this.gridData == null) {
                return null;
            }
            double colorMin = this.getColorMin();
            double colorMax = this.getColorMax();
            rc = new ContinuousRange(colorMin, colorMax);
        } else {
            rc = super.getOutputRange(dimension);
        }
        return rc;
    }

    private void resetColorRamp() {
        if (this.contour != null && this.contour.GetStyle() == 2) {
            return;
        }
        this.initColorRamp();
        if (this.colorMapper != null) {
            Color neutralColor = this.colorMapper.getNeutralColor();
            double min = this.colorMapper.getMinValue();
            double neutral = this.colorMapper.getNeutralValue();
            double max = this.colorMapper.getMaxValue();
            Color[] colors = null;
            double[] breaks = null;
            if (neutralColor != null) {
                colors = new Color[]{this.colorMapper.getMinColor(), this.colorMapper.getNeutralColor(), this.colorMapper.getMaxColor()};
                breaks = new double[]{0.0, (neutral - min) / (max - min), 1.0};
            } else {
                colors = new Color[]{this.colorMapper.getMinColor(), this.colorMapper.getMaxColor()};
            }
            ColorRamp colorRamp = new ColorRamp((Object)colors, breaks);
            this.contour.SetColorRamp((IVIZColor)colorRamp);
            this.contour.SetColorMin(min);
            this.contour.SetColorMax(max);
        }
    }

    private double getColorMin() {
        if (this.getContourStyle() == 0) {
            return this.getMinLevel();
        }
        return this.gridData.GetResponseMin(0);
    }

    private double getColorMax() {
        if (this.getContourStyle() == 0) {
            return this.getMaxLevel();
        }
        return this.gridData.GetResponseMax(0);
    }

    @Override
    public boolean build(Object buildData) {
        this.resetColorRamp();
        return super.build(buildData);
    }
}

