/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.common.bubble.BubbleObject;
import com.sas.graphics.data.GTKDataFilterSelectionVariable;
import com.sas.graphics.data.GTKNumericDataFilterVariable;
import com.sas.graphics.data.GTKStringDataFilterVariable;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.SelectEntry;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToNumberMap;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class BubbleElement
extends BaseElement {
    private SILKNumber xRole = null;
    private SILKNumber yRole = null;
    private SILKNumber sizeRole = null;
    private SILKNumber groupRole = null;
    private SILKNumber colorRole = null;
    private SILKNumber labelRole = null;
    private SILKNumber groupIndexRole = null;
    private Variable xVar;
    private Variable yVar;
    private NumericVariable sizeVar;
    private Variable colorVar;
    private Variable labelVar;
    private BubbleObject bubble = null;
    private CharacterVariableMapper xCharMapper = null;
    private CharacterVariableMapper yCharMapper = null;
    private static final int ADD_SORTABLE_ROLE = 1;
    private static final int REMOVE_SORTABLE_ROLE = 2;
    private HashMap groupIndexMap = null;
    private Vector sortableRoles = null;
    private SILKNumber currentLegend = null;
    private boolean rebuildRequired = false;
    private boolean numericX = true;
    private boolean numericY = true;
    private int[] sortableDirections = new int[]{1, 0, -1};
    private VariableProcessor vp = null;
    protected GTKDataFilterSelectionVariable selectionVariable;
    private static final int[] supportedBubbleProperties = new int[]{22001, 22002, 22003, 22004, 22005};
    private boolean antiAliasOn = true;
    private static final int ANTIALIAS_THRESHOLD = 500;

    public BubbleElement() {
        this.sortableRoles = new Vector();
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 0);
        this.roles.setSortsSupported((Object)this.xRole, this.sortableDirections);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1);
        this.roles.setRoleType((Object)this.yRole, 0);
        this.roles.setSortsSupported((Object)this.yRole, this.sortableDirections);
        this.sizeRole = this.role.getRoleObject("ROLE_SIZE");
        this.roles.newRole((Object)this.sizeRole, "Size", 1);
        this.roles.setRoleType((Object)this.sizeRole, 1);
        this.groupRole = this.role.getRoleObject("ROLE_GROUP");
        this.roles.newRole((Object)this.groupRole, "Group", 1, null, 100);
        this.roles.setRoleType((Object)this.groupRole, 0);
        this.groupIndexRole = this.role.getRoleObject("ROLE_GROUP_INDEX");
        this.roles.newRole((Object)this.groupIndexRole, "Group Index", 1);
        this.roles.setRoleType((Object)this.groupIndexRole, 1);
        this.colorRole = this.role.getRoleObject("ROLE_COLOR");
        this.roles.newRole((Object)this.colorRole, "Color", 1);
        this.roles.setRoleType((Object)this.colorRole, 1);
        this.labelRole = this.role.getRoleObject("ROLE_LABEL");
        this.roles.newRole((Object)this.labelRole, "Data Label", 1);
        this.roles.setRoleType((Object)this.labelRole, 0);
        this.bubble = new BubbleObject();
        this.bubble.setChannel(new Channel((Component)new Container(), 2));
        this.setSupportedProperties(supportedBubbleProperties);
        this.userSetProperties.appendProperties(supportedBubbleProperties);
        this.selectionVariable = new GTKDataFilterSelectionVariable();
        this.addChartTabInfo("com.sas.graphics.silk.ui.BubblePanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BubbleElement.Bubble.txt", (String)"Bubble"));
    }

    @Override
    protected void drawChart(Graphics g) {
        if (this.filter == null || this.filter.getNumberObservations(-1) <= 0) {
            return;
        }
        this.setViewport();
        this.setProjection();
        if (this.rebuildRequired) {
            this.build();
        }
        if (this.antiAliasOn && this.filter.getNumberObservations(-1) < 500 && g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.bubble.getChannel().setSingleBufferGraphics(g);
        this.bubble.draw();
    }

    protected void setViewport() {
        Channel ch = this.bubble.getChannel();
        if (ch != null && !this.bounds.isEmpty()) {
            ch.glViewport(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
    }

    protected void setProjection() {
        Channel ch = this.bubble.getChannel();
        if (ch != null) {
            double t;
            DataRange xrange = this.getOutputRange((byte)1);
            DataRange yrange = this.getOutputRange((byte)2);
            if (xrange == null || yrange == null) {
                return;
            }
            double left = 0.0;
            double right = this.bounds.width;
            double bottom = this.bounds.height;
            double top = 0.0;
            if (xrange instanceof DiscreteRange) {
                left = this.bounds.x;
                right = this.bounds.x + this.bounds.width;
            }
            if (yrange instanceof DiscreteRange) {
                bottom = this.bounds.y + this.bounds.height;
                top = this.bounds.y;
            }
            if (this.transformObject.isReverse(this.getXAxisMapping())) {
                t = left;
                left = right;
                right = t;
            }
            if (this.transformObject.isReverse(this.getYAxisMapping())) {
                t = bottom;
                bottom = top;
                top = t;
            }
            ch.glOrtho(left, right, bottom, top, -1.0, -1.0);
        }
    }

    @Override
    public void roleChanged(RoleEvent e) {
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
                break;
            }
            case 5: {
                this.sortRole(e);
            }
        }
        this.connectData();
        this.rebuildRequired = true;
        super.roleChanged(e);
        if (this.sizeRole.equals(e.role) && !this.bubble.isRelativeScale()) {
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        }
    }

    private void connectData() {
        GTKNumericDataFilterVariable cvar;
        GTKNumericDataFilterVariable yvar;
        GTKNumericDataFilterVariable xvar;
        if (this.filter == null || this.roles.getVariable((Object)this.xRole, 0) == null || this.roles.getVariable((Object)this.yRole, 0) == null || this.roles.getVariable((Object)this.sizeRole, 0) == null) {
            return;
        }
        if (this.numericX) {
            xvar = new GTKNumericDataFilterVariable();
            xvar.connectFrom(this.filter, this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0)));
            this.xVar = xvar;
        } else {
            xvar = new GTKStringDataFilterVariable();
            xvar.connectFrom(this.filter, this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0)));
            this.xVar = xvar;
        }
        if (this.numericY) {
            yvar = new GTKNumericDataFilterVariable();
            yvar.connectFrom(this.filter, this.filter.getVariableIndex(this.roles.getVariable((Object)this.yRole, 0)));
            this.yVar = yvar;
        } else {
            yvar = new GTKStringDataFilterVariable();
            yvar.connectFrom(this.filter, this.filter.getVariableIndex(this.roles.getVariable((Object)this.yRole, 0)));
            this.yVar = yvar;
        }
        if (this.roles.getVariable((Object)this.colorRole, 0) != null) {
            cvar = new GTKNumericDataFilterVariable();
            cvar.connectFrom(this.filter, this.filter.getVariableIndex(this.roles.getVariable((Object)this.colorRole, 0)));
            this.colorVar = cvar;
        } else if (this.roles.getVariable((Object)this.groupRole, 0) != null) {
            cvar = new GTKStringDataFilterVariable();
            cvar.connectFrom(this.filter, this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)));
            this.colorVar = cvar;
        } else {
            this.colorVar = null;
        }
        if (this.roles.getVariable((Object)this.labelRole, 0) != null) {
            GTKStringDataFilterVariable lvar = new GTKStringDataFilterVariable();
            lvar.connectFrom(this.filter, this.filter.getVariableIndex(this.roles.getVariable((Object)this.labelRole, 0)));
            this.labelVar = lvar;
        } else {
            this.labelVar = null;
        }
        GTKNumericDataFilterVariable svar = new GTKNumericDataFilterVariable();
        svar.connectFrom(this.filter, this.filter.getVariableIndex(this.roles.getVariable((Object)this.sizeRole, 0)));
        this.sizeVar = svar;
        this.vp = null;
        if (this.sizeVar != null) {
            this.vp = new VariableProcessor();
            this.vp.addVariable((Variable)this.sizeVar);
            this.vp.addVariable(this.xVar);
            this.vp.addVariable(this.yVar);
            if (this.colorVar != null) {
                this.vp.addVariable(this.colorVar);
            }
            if (this.labelVar != null) {
                this.vp.addVariable(this.labelVar);
            }
            this.vp.addVariable((Variable)this.selectionVariable);
            this.vp.setSort((Variable)this.sizeVar, 2);
        }
        this.vp.getIndicesPriorToProcessing(0);
        this.bubble.setXVar(this.xVar);
        this.bubble.setYVar(this.yVar);
        this.bubble.setSizeVar(this.sizeVar);
        if (this.infoFilter != null) {
            Object o = this.infoFilter.getMinimumValue(this.roles.getVariable((Object)this.sizeRole, 0));
            if (o instanceof Number) {
                this.bubble.setSizeMin(((Number)o).doubleValue());
            }
            if ((o = this.infoFilter.getMaximumValue(this.roles.getVariable((Object)this.sizeRole, 0))) instanceof Number) {
                this.bubble.setSizeMax(((Number)o).doubleValue());
            }
        }
        if (this.colorVar != null) {
            this.bubble.setColorVar(this.colorVar);
        }
        if (this.labelVar != null) {
            this.bubble.setDataLabelVar(this.labelVar);
        }
    }

    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                if (this.filter == null) break;
                if (this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0))) {
                    if (this.xCharMapper != null) {
                        this.xCharMapper.removeAllValues();
                    }
                    this.xCharMapper = null;
                    this.numericX = true;
                    this.updateSortableRoles(this.xRole, 2);
                    break;
                }
                if (this.xCharMapper == null) {
                    this.xCharMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable((Object)this.xRole, 0));
                } else {
                    this.xCharMapper.setVariable(this.roles.getVariable((Object)this.xRole, 0));
                }
                this.numericX = false;
                this.updateSortableRoles(this.xRole, 1);
                break;
            }
            case 25: {
                if (this.filter == null) break;
                if (this.filter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0))) {
                    if (this.yCharMapper != null) {
                        this.yCharMapper.removeAllValues();
                    }
                    this.yCharMapper = null;
                    this.numericY = true;
                    this.updateSortableRoles(this.yRole, 2);
                    break;
                }
                if (this.yCharMapper == null) {
                    this.yCharMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable((Object)this.yRole, 0));
                } else {
                    this.yCharMapper.setVariable(this.roles.getVariable((Object)this.yRole, 0));
                }
                this.numericY = false;
                this.updateSortableRoles(this.yRole, 1);
                break;
            }
            case 6: {
                this.groupIndexMap = null;
                this.lce.setAction(4);
                this.lce.setBuildData(this.groupRole.toString());
                this.fireLayerListenerChanged(this.lce);
                this.lce.setBuildData(null);
                if (this.roles.getVariable((Object)this.colorRole, 0) != null) {
                    this.roles.removeRole(this.roles.getVariable((Object)this.colorRole, 0), (Object)this.colorRole);
                }
                this.lce.setAction(1);
                break;
            }
            case 7: {
                this.groupIndexMap = null;
                break;
            }
            case 2: {
                this.initColorRamp();
                if (this.roles.getVariable((Object)this.groupRole, 0) != null) {
                    this.roles.removeRole(this.roles.getVariable((Object)this.groupRole, 0), (Object)this.groupRole);
                }
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
                this.lce.setAction(4);
                this.lce.setBuildData(this.colorRole.toString());
                this.fireLayerListenerChanged(this.lce);
                this.lce.setBuildData(null);
                this.lce.setAction(1);
                break;
            }
        }
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                this.bubble.setXVar(null);
                break;
            }
            case 25: {
                this.bubble.setYVar(null);
                break;
            }
            case 19: {
                this.bubble.setSizeVar(null);
                break;
            }
            case 8: {
                this.bubble.setDataLabelVar(null);
                this.fireMarginChanged(new MarginChangeEvent((Object)this));
                break;
            }
            case 2: {
                this.clearColorRamp();
                break;
            }
            case 6: 
            case 7: {
                this.groupIndexMap = null;
                this.currentLegend = null;
            }
        }
    }

    protected void sortRole(RoleEvent e) {
        int sortOrder = 0;
        Object o = null;
        switch (e.role) {
            case 24: {
                o = this.roles.getSortOrder((Object)this.xRole);
                if (!(o instanceof Number)) break;
                sortOrder = ((Number)o).intValue();
                if (this.xCharMapper != null && this.xCharMapper.getSort() == sortOrder) {
                    return;
                }
                this.setSortOrderToCharMapper(this.xRole, this.xCharMapper, sortOrder);
                break;
            }
            case 25: {
                o = this.roles.getSortOrder((Object)this.yRole);
                if (!(o instanceof Number)) break;
                sortOrder = ((Number)o).intValue();
                if (this.yCharMapper != null && this.yCharMapper.getSort() == sortOrder) {
                    return;
                }
                this.setSortOrderToCharMapper(this.yRole, this.yCharMapper, sortOrder);
            }
        }
        this.fireLayerListenerChanged(7);
        this.fireLayerListenerChanged(3);
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections() || this.bubble == null) {
            return;
        }
        if (this.antiAliasOn && this.filter.getNumberObservations(-1) < 500 && g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.bubble.getChannel().setSingleBufferGraphics(g);
        this.bubble.drawSelections();
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        Stack nameStack = new Stack();
        Channel channel = this.bubble.getChannel();
        channel.glRenderMode(1);
        channel.gluPickMatrix(screenX, screenY, 3, 3);
        nameStack.removeAllElements();
        channel.glSelectBuffer(nameStack);
        channel.glPushMatrix();
        this.bubble.select();
        channel.glPopMatrix();
        channel.glRenderMode(0);
        if (nameStack.size() > 1) {
            SelectEntry se = (SelectEntry)nameStack.get(1);
            int index = se.getValueIndex();
            String s = this.filter.getVariableDescription(this.roles.getVariable((Object)this.xRole, 0)) + "\t=\t" + Variable.getValue((Variable)this.xVar, (int)index, (boolean)true).toString() + "\n" + this.filter.getVariableDescription(this.roles.getVariable((Object)this.yRole, 0)) + "\t=\t" + Variable.getValue((Variable)this.yVar, (int)index, (boolean)true).toString() + "\n" + this.filter.getVariableDescription(this.roles.getVariable((Object)this.sizeRole, 0)) + "\t=\t" + Variable.getValue((Variable)this.sizeVar, (int)index, (boolean)true).toString();
            return s;
        }
        return null;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        Rectangle region = new Rectangle((Rectangle)selectRegion);
        Stack nameStack = new Stack();
        Channel channel = this.bubble.getChannel();
        channel.glRenderMode(1);
        channel.gluPickMatrix(region.x, region.y, region.width, region.height);
        nameStack.removeAllElements();
        channel.glSelectBuffer(nameStack);
        channel.glPushMatrix();
        this.bubble.select();
        channel.glPopMatrix();
        channel.glRenderMode(0);
        if (nameStack.size() > 0) {
            Vector selectedIndices = new Vector();
            for (int i = 0; i < nameStack.size(); ++i) {
                Object o = nameStack.get(i);
                if (!(o instanceof SelectEntry)) continue;
                SelectEntry se = (SelectEntry)o;
                int index = this.vp.getIndexWithoutWhereProcessing(se.getValueIndex());
                List l = this.vp.getIndicesPriorToProcessing(se.getValueIndex());
                Object idx = l.get(0);
                if (selectedIndices.contains(idx)) continue;
                selectedIndices.add(idx);
            }
            if (selectedIndices.size() > 0) {
                int[] sel = new int[selectedIndices.size()];
                for (int i = 0; i < sel.length; ++i) {
                    sel[i] = ((Number)selectedIndices.get(i)).intValue();
                }
                this.filter.setSelected((Object)sel, select);
            }
            return true;
        }
        return false;
    }

    protected void updateSortableRoles(SILKNumber role, int action) {
        if (role == null || this.sortableRoles == null) {
            return;
        }
        switch (action) {
            case 1: {
                if (this.sortableRoles.contains((Object)role)) {
                    return;
                }
                this.sortableRoles.add(role);
                break;
            }
            case 2: {
                this.sortableRoles.remove((Object)role);
            }
        }
        Object[][] sortRoles = null;
        if (this.sortableRoles.size() > 0) {
            sortRoles = new Object[this.sortableRoles.size()][];
            for (int i = 0; i < this.sortableRoles.size(); ++i) {
                sortRoles[i] = new Object[]{this.sortableRoles.elementAt(i)};
            }
        }
        this.roles.setSupportedSortRoles(sortRoles);
    }

    protected int getGroupIndex(Object value) {
        if (this.groupIndexMap == null) {
            Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
            if (groupVar == null) {
                return -1;
            }
            this.buildGroupIndexMap();
        }
        if (this.groupIndexMap == null || value == null) {
            return -1;
        }
        Object o = this.groupIndexMap.get(value);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return -1;
    }

    protected void buildGroupIndexMap() {
        if (this.filter == null || this.roles == null) {
            return;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        Object groupIndexVar = this.roles.getVariable((Object)this.groupIndexRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        int groupIndexVarIndex = this.filter.getVariableIndex(groupIndexVar);
        if (groupVarIndex < 0 || groupVar == null) {
            return;
        }
        if (this.groupIndexMap == null) {
            this.groupIndexMap = new HashMap();
        } else {
            this.groupIndexMap.clear();
        }
        Object[] allGroupValues = this.fetchUniqueValues(groupVarIndex, false);
        if (allGroupValues == null) {
            return;
        }
        if (groupIndexVarIndex >= 0) {
            for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                double gi;
                String group = this.filter.getFormattedValue(groupVar, (long)i, null);
                if (!this.groupIndexMap.containsKey(group) && (gi = this.filter.getNumericValue(groupIndexVarIndex, (long)i)) >= 0.0) {
                    this.groupIndexMap.put(group, new Double(gi));
                }
                if (this.groupIndexMap.size() != allGroupValues.length) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < allGroupValues.length; ++i) {
                this.groupIndexMap.put(allGroupValues[i], new Integer(i));
            }
        }
    }

    protected Object[] fetchUniqueValues(int varIndex, boolean useSubset) {
        Object[] uniqueValues = null;
        if (varIndex >= 0 && this.infoFilter != null) {
            uniqueValues = this.infoFilter.getUniqueValues(this.filter.getVariableId(varIndex), useSubset);
        }
        return uniqueValues;
    }

    protected void setSortOrderToCharMapper(SILKNumber role, CharacterVariableMapper charMapper, int sortOrder) {
        if (this.filter == null) {
            return;
        }
        if (this.filter.isNumericVariable(this.roles.getVariable((Object)role, 0))) {
            return;
        }
        if (charMapper == null) {
            return;
        }
        charMapper.setSort(sortOrder);
    }

    private void build() {
        ContinuousRangeToColorMap cMap;
        int i;
        double[] proj;
        StringToNumberMap map;
        StringVectorVariable svv;
        String[] sv;
        ContinuousRangeToNumericMap map2;
        if (this.bubble == null) {
            return;
        }
        DataRange xrange = this.getOutputRange((byte)1);
        DataRange yrange = this.getOutputRange((byte)2);
        StringToNumberMap xMap = null;
        StringToNumberMap yMap = null;
        if (this.numericX) {
            map2 = new ContinuousRangeToNumericMap();
            map2.setInputMin(((ContinuousRange)xrange).getMin());
            map2.setInputMax(((ContinuousRange)xrange).getMax());
            map2.setOutputMin((double)this.innerMargin.left);
            map2.setOutputMax((double)(this.bounds.width - this.innerMargin.right));
            xMap = map2;
        } else {
            sv = new String[this.xCharMapper.getNumberValues()];
            for (int i2 = 0; i2 < this.xCharMapper.getNumberValues(); ++i2) {
                sv[i2] = this.xCharMapper.getValue(i2).toString();
            }
            svv = new StringVectorVariable();
            svv.connectFrom(sv);
            map = new StringToNumberMap();
            if (this.xCharMapper.getNumberValues() > 1) {
                proj = new double[3];
                for (i = 0; i < this.xCharMapper.getNumberValues(); ++i) {
                    proj = this.transformObject.project(i, 0.0, 0.0, proj);
                    map.add(this.xCharMapper.getValue(i).toString(), (Number)proj[0]);
                }
                map.addStringPipe(svv.value);
            }
            xMap = map;
        }
        if (this.numericY) {
            map2 = new ContinuousRangeToNumericMap();
            map2.setInputMin(((ContinuousRange)yrange).getMin());
            map2.setInputMax(((ContinuousRange)yrange).getMax());
            map2.setOutputMin((double)(this.bounds.height - this.innerMargin.bottom));
            map2.setOutputMax((double)this.innerMargin.top);
            yMap = map2;
        } else {
            sv = new String[this.yCharMapper.getNumberValues()];
            for (int i3 = 0; i3 < this.yCharMapper.getNumberValues(); ++i3) {
                sv[i3] = this.yCharMapper.getValue(i3).toString();
            }
            svv = new StringVectorVariable();
            svv.connectFrom(sv);
            map = new StringToNumberMap();
            if (this.yCharMapper.getNumberValues() > 1) {
                proj = new double[3];
                for (i = 0; i < this.yCharMapper.getNumberValues(); ++i) {
                    proj = this.transformObject.project(0.0, i, 0.0, proj);
                    map.add(this.yCharMapper.getValue(i).toString(), (Number)proj[1]);
                }
                map.addStringPipe(svv.value);
            }
            yMap = map;
        }
        ContinuousRangeToColorMap fillColorMap = null;
        Object lineColorMap = null;
        if (this.isRoleSet((Object)this.colorRole)) {
            cMap = new ContinuousRangeToColorMap();
            ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4, false);
            cMap.setInputMin(r.getMin());
            cMap.setInputMax(r.getMax());
            double neutralValue = r.getMin() + (r.getMin() + r.getMax()) / 2.0;
            cMap.setColorSpectrumColors(new Color[]{this.colorMapper.getColor(r.getMin()), this.colorMapper.getColor(neutralValue), this.colorMapper.getColor(r.getMax())});
            cMap.setColorSpectrumValues(new double[]{r.getMin(), neutralValue, r.getMax()});
            fillColorMap = cMap;
            lineColorMap = this.bubble.isFilled() ? null : fillColorMap;
        } else if (this.isRoleSet((Object)this.groupRole)) {
            cMap = null;
            StringToColorMap cMap2 = null;
            Object[] groupValues = this.fetchUniqueValues(this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)), true);
            if (groupValues != null) {
                cMap = new StringToColorMap();
                cMap2 = new StringToColorMap();
                for (int i4 = 0; i4 < groupValues.length; ++i4) {
                    int gi = this.getGroupIndex(groupValues[i4]);
                    if (gi < 0) continue;
                    DataStyleElement dse = this.style.getDataStyleElement(gi);
                    cMap.add(groupValues[i4].toString(), dse.getFillColor());
                    cMap2.add(groupValues[i4].toString(), dse.getLineColor());
                }
            }
            fillColorMap = cMap;
            lineColorMap = cMap2;
        }
        ContinuousRangeToColorMap dataLabelColorMap = fillColorMap != null ? fillColorMap : lineColorMap;
        this.bubble.connectNetwork((NumericMap)xMap, (NumericMap)yMap, fillColorMap, lineColorMap, dataLabelColorMap, null, null, null, null);
        this.rebuildRequired = false;
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.rebuildRequired = true;
    }

    @Override
    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (!this.isRoleSet((Object)this.groupRole) && !this.isRoleSet((Object)this.colorRole) && this.bubble != null) {
            this.bubble.getFillAttrs().setColor(this.style.getDataStyleElement("GraphDataStyleDefault").getFillColor());
            this.bubble.getOutlineAttrs().setColor(this.style.getDataStyleElement("Outlines").getLineColor());
            this.bubble.getDataLabelAttrs().setColor(this.style.getTextStyleElement("ValueText").getTextColor());
        }
        if (this.isRoleSet((Object)this.colorRole)) {
            this.initColorRamp();
        }
        return rc;
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (which == null || this.filter == null) {
            return null;
        }
        Object role = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        if (!this.bubble.isRelativeScale()) {
            Object range = null;
            while (rolesEnum.hasMoreElements()) {
                byte dim;
                role = rolesEnum.nextElement();
                if (role == null || !this.xRole.equals(role) && !this.yRole.equals(role)) continue;
                DataRange r = super.getPreferredRange(which);
                byte by = dim = this.xRole.equals(role) ? (byte)1 : 2;
                if (!(r instanceof ContinuousRange)) continue;
                return this.bubble.adjustRange(r, dim);
            }
        }
        return super.getPreferredRange(which);
    }

    @Override
    public Insets getPreferredInnerMargin() {
        return this.bubble.getPreferredInnerMargin();
    }

    protected Object getLegendEntries(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.filter == null) {
            return null;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        Object[] allGroupValues = this.fetchUniqueValues(groupVarIndex, false);
        Object[] subsetGroupValues = this.fetchUniqueValues(groupVarIndex, true);
        Object colorVar = this.roles.getVariable((Object)this.colorRole, 0);
        int colorVarIndex = this.filter.getVariableIndex(colorVar);
        boolean statGraphCompat = SILKGlobal.isFlagSet(4);
        if (this.groupRole != null && (this.groupRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName()))) {
            if (groupVar == null) {
                return null;
            }
            if (allGroupValues == null || subsetGroupValues == null) {
                return null;
            }
            this.buildGroupIndexMap();
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(subsetGroupValues.length);
            for (int i = 0; i < subsetGroupValues.length; ++i) {
                int mrkrShape = this.bubble.isFilled() ? 16 : 0;
                Color color = this.bubble.getFillAttrs().getColor();
                Color outlineColor = this.bubble.getOutlineAttrs().getColor();
                int groupIndex = -1;
                Object o = null;
                if (subsetGroupValues[i] != null) {
                    o = this.groupIndexMap.get(subsetGroupValues[i]);
                }
                if (o != null) {
                    groupIndex = ((Number)o).intValue();
                }
                if (groupIndex >= 0) {
                    String groupValue = subsetGroupValues[i].toString();
                    DataStyleElement dse = SILKUtilities.getStyleElement(groupValue, groupIndex, 2, this.style, this.markerAttrs, this.markerAttrs.getOverrides(false)).getAsDataStyle();
                    color = dse.getFillColor();
                    outlineColor = dse.getLineColor();
                    if (statGraphCompat) {
                        mrkrShape = dse.getMarkerSymbol();
                    }
                } else {
                    color = this.style.getDataStyleElement("Missing").getFillColor();
                    outlineColor = this.style.getDataStyleElement("Missing").getLineColor();
                }
                MarkerAttrib ms = new MarkerAttrib(true, color);
                ms.setShape(new Integer(mrkrShape));
                ms.setFilled(this.bubble.isFilled());
                ms.setOutline(this.bubble.isOutlined());
                ms.setOutline(outlineColor);
                legendEntries.add(new LegendEntry(subsetGroupValues[i], ms, null));
            }
            return legendEntries;
        }
        if (this.colorRole != null && (this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) && colorVarIndex >= 0) {
            if (this.colorMapper == null) {
                this.initColorRamp();
            }
            if (this.colorMapper == null) {
                return null;
            }
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
            ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4, false);
            Color c = this.colorMapper.getColor(r.getMin());
            double cv = r.getMin();
            MarkerAttrib msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            c = this.colorMapper.getNeutralColor();
            if (c != null && r.contains((DataPoint)new ContinuousPoint(this.colorMapper.getNeutralValue()))) {
                cv = this.colorMapper.getNeutralValue();
                msi = new MarkerAttrib(true, c);
                legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            }
            c = this.colorMapper.getColor(r.getMax());
            cv = r.getMax();
            msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            return legendEntries;
        }
        return null;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                String leg;
                if (value == null || !(leg = value.toString()).equalsIgnoreCase(this.groupRole.toString()) && !leg.equalsIgnoreCase(this.groupRole.getEnglishName()) && !leg.equalsIgnoreCase(this.colorRole.getEnglishName()) && !leg.equalsIgnoreCase(this.colorRole.toString())) break;
                if (value instanceof SILKNumber) {
                    this.currentLegend = (SILKNumber)((Object)value);
                }
                return true;
            }
        }
        return rc;
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (this.currentLegend == null) {
                    rc = null;
                    break;
                }
                if (this.groupRole.toString().equalsIgnoreCase(this.currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(this.currentLegend.getEnglishName())) {
                    rc = this.roles.getVariable((Object)this.groupRole, 0);
                    break;
                }
                if (!this.colorRole.toString().equalsIgnoreCase(this.currentLegend.toString()) && !this.colorRole.getEnglishName().equalsIgnoreCase(this.colorRole.getEnglishName())) break;
                rc = this.roles.getVariable((Object)this.colorRole, 0);
                break;
            }
            case 433: {
                rc = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 426: {
                rc = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                rc = new Boolean(this.isContinuousLegend(this.currentLegend));
                break;
            }
            case 24: 
            case 25: {
                Vector<SILKNumber> legNames = new Vector<SILKNumber>();
                if (this.isLegendValid(this.groupRole)) {
                    legNames.add(this.groupRole);
                }
                if (this.isLegendValid(this.colorRole)) {
                    legNames.add(this.colorRole);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 22001: {
                rc = this.bubble.getMinBubbleSize();
                break;
            }
            case 22002: {
                rc = this.bubble.getMaxBubbleSize();
                break;
            }
            case 22003: {
                rc = this.bubble.isFilled();
                break;
            }
            case 22004: {
                rc = this.bubble.isOutlined();
                break;
            }
            case 22005: {
                rc = this.bubble.isRelativeScale();
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 22001: {
                if (!(value instanceof Number)) break;
                this.bubble.setMinBubbleSize(((Number)value).doubleValue());
                this.userSetProperties.set(22001);
                break;
            }
            case 22002: {
                if (!(value instanceof Number)) break;
                this.bubble.setMaxBubbleSize(((Number)value).doubleValue());
                this.userSetProperties.set(22002);
                break;
            }
            case 22003: {
                if (!(value instanceof Boolean)) break;
                this.bubble.setFilled(((Boolean)value).booleanValue());
                this.userSetProperties.set(22003);
                break;
            }
            case 22004: {
                if (!(value instanceof Boolean)) break;
                this.bubble.setOutlined(((Boolean)value).booleanValue());
                this.userSetProperties.set(22004);
                break;
            }
            case 22005: {
                if (!(value instanceof Boolean)) break;
                this.bubble.setRelativeScale(((Boolean)value).booleanValue());
                this.userSetProperties.set(22005);
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    private boolean isLegendValid(SILKNumber role) {
        if (role == null) {
            return false;
        }
        Object o = null;
        o = this.getLegendEntries(role);
        return o != null && o instanceof Vector && ((Vector)o).size() > 0;
    }

    private boolean isContinuousLegend(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return false;
        }
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return false;
        }
        return this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName());
    }

    protected Object getLegendTitle(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.groupRole, 0));
        }
        if (this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.colorRole, 0));
        }
        return null;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 1: 
            case 3: {
                this.groupIndexMap = null;
            }
        }
        this.connectData();
        this.rebuildRequired = true;
        super.dataFilterChanged(evt);
    }

    @Override
    public void dispose() {
        if (this.sortableRoles != null) {
            this.sortableRoles.clear();
        }
        this.sortableRoles = null;
        if (this.xCharMapper != null) {
            this.xCharMapper.dispose();
            this.xCharMapper = null;
        }
        if (this.yCharMapper != null) {
            this.yCharMapper.dispose();
            this.yCharMapper = null;
        }
        super.dispose();
        this.xRole = null;
        this.yRole = null;
        this.groupRole = null;
        this.groupIndexRole = null;
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        boolean rc = super.setDataSource(source, id);
        if (rc) {
            this.selectionVariable.connectFrom(this.filter);
            this.bubble.setSelectionVar((NumericVariable)this.selectionVariable);
        }
        return rc;
    }
}

