/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.SILKXYComponent;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.LayerChangedEvent;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.info.OverlayRoleAssigner;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.LayerListenerInterface;
import com.sas.graphics.silk.interfaces.LegendEntryInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.OverlayPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.graphwizard.SILKWizardEntry;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisComponent;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.Brush;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.SILKChartFlavor;
import com.sas.graphics.silk.util.SILKErrorUtilities;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.tools.wizard.WizardEntry;
import com.sas.graphics.util.DynamicIntArray;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.RangeSlider;
import com.sas.graphics.util.labeling.Graph;
import com.sas.graphics.util.labeling.Node;
import com.sas.text.SASFormat;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public class BaseElementComponent
extends SILKXYComponent
implements LayerListenerInterface,
DropTargetListener {
    private static final long serialVersionUID = -1285116202813747550L;
    protected Vector charts = new Vector();
    protected Vector chartLayerList = new Vector();
    protected Hashtable chartHashTable = new Hashtable();
    private Image backBuffer = null;
    private Image buffer2 = null;
    private boolean buffer2Valid = false;
    private boolean backBufferValid = false;
    protected Brush brush = null;
    protected BaseElement primary = null;
    protected LegendObjectJ2D overlayLegend = null;
    protected boolean createOverlayLegend = true;
    protected Vector userLegends = null;
    protected DropTarget dropTarget = null;
    protected boolean cycleAttrs = false;
    private SILKNumber overlayLegendId = new SILKNumber(10000, "Overlay Legend");

    public BaseElementComponent() {
        this.increaseBuildDepth();
        if (!GraphicsEnvironment.isHeadless()) {
            this.dropTarget = new DropTarget(this, this);
        }
        this.setStyle(SILKGlobal.getInstance().getPropertyValue(29));
        this.initializeMenu(null);
        if (this.silkAnno == null) {
            MenuUtilities.removeMenuItem(this.menu, "ACTION_MODE_ANNOTATE");
        }
        this.actions.put("GRAPH_PROPERTIES", Boolean.TRUE);
        this.actions.put("DATA_OPTIONS", Boolean.TRUE);
        this.actions.put("ACTION_MENU", Boolean.TRUE);
        this.actions.put("COPY", Boolean.TRUE);
        this.brush = new Brush(this);
        this.brush.setSelectInChartSpace(false);
        this.brush.setSelectOnDrilldown(this.selectOnDrilldown);
        this.brush.setPolygonFillColor(this.style.getDataStyleElement("Selection").getLineColor());
        this.decreaseBuildDepth();
    }

    public BaseElementComponent(BaseElement element) {
        this();
        this.setChart(element);
    }

    private String generateUniqueChartId(Object chart) {
        int num = 0;
        String id = "Chart";
        SILKChartInfo info = SILKChartInfo.getInstance(chart);
        if (info != null) {
            id = info.getDisplayName();
        }
        String baseName = id;
        while (this.getChart(id) != null) {
            id = baseName + " " + ++num;
        }
        return id;
    }

    public void setChart(BaseElement element) {
        this.addChart(element, true);
    }

    public void addChart(BaseElement element) {
        this.addChart(element, false);
    }

    private void addChart(BaseElement element, boolean makePrimary) {
        Vector<BaseElement> v = new Vector<BaseElement>();
        v.addElement(element);
        this.addCharts(v);
        if (makePrimary) {
            this.setPrimary(element);
        }
    }

    public void addCharts(Collection chartList) {
        if (chartList == null) {
            return;
        }
        Iterator it = chartList.iterator();
        if (it == null) {
            return;
        }
        long t1 = System.currentTimeMillis();
        long tinit = 0L;
        long tid = 0L;
        while (it.hasNext()) {
            BaseElement chart;
            Object o = it.next();
            if (!(o instanceof BaseElement) || this.chartHashTable.containsKey(chart = (BaseElement)o)) continue;
            this.chartHashTable.put(chart, chart);
            long ta = System.currentTimeMillis();
            if (chart.getId() == null) {
                chart.setId(this.generateUniqueChartId(chart));
            }
            long tb = System.currentTimeMillis();
            tid += tb - ta;
            chart.setActionMode(this.getActionMode());
            chart.setStyle(this.style);
            chart.addMarginListener(this);
            chart.addRangeChangeListener(this);
            chart.addViewportListener(this);
            chart.setComponentSize(this.compWidth, this.compHeight);
            if (chart.getBrushListener() != null) {
                this.brush.addBrushListener(chart.getBrushListener());
            }
            this.roles = chart.getRoleManager();
            this.dataFilter = chart.getFilter();
            this.brush.addFilter(this.dataFilter);
            if (this.roles != null) {
                this.roles.addRoleListener(this);
            }
            chart.setBounds(this.dataRegion);
            chart.addLayerListener(this);
            if (this.dataDlg != null) {
                this.dataDlg.addChart(chart);
            }
            if (this.charts.size() == 0) {
                this.primary = chart;
                this.initializeMenu(null, this.isPopupRebuildRequired(this.primary));
            }
            this.charts.addElement(chart);
            this.chartLayerList.addElement(chart);
            ta = System.currentTimeMillis();
            this.initAxesFromSource(chart, false);
            tb = System.currentTimeMillis();
            tinit += tb - ta;
        }
        long t2 = System.currentTimeMillis();
        this.doCycleAttrs();
        long t3 = System.currentTimeMillis();
        this.setInternalRange((byte)1, 0, this.getAxisRange(0));
        this.setInternalRange((byte)2, 0, this.getAxisRange(1));
        this.setInternalRange((byte)1, 1, this.getAxisRange(3));
        this.setInternalRange((byte)2, 1, this.getAxisRange(4));
        long t4 = System.currentTimeMillis();
        this.resetViewport();
        long t5 = System.currentTimeMillis();
        this.checkAxes();
        long t6 = System.currentTimeMillis();
        this.layoutChart();
        long t7 = System.currentTimeMillis();
        this.manageChartTabs(null);
        long t8 = System.currentTimeMillis();
        this.buildAndDraw(Boolean.TRUE, null, null);
        long t9 = System.currentTimeMillis();
    }

    private boolean isPopupRebuildRequired(BaseElement element) {
        if (element == null) {
            return false;
        }
        boolean rebuildPopup = false;
        Object cpm = element.getPropertyValue(19089);
        if (cpm instanceof Boolean) {
            rebuildPopup = (Boolean)cpm;
        }
        return rebuildPopup;
    }

    public void removeChart(BaseElement element) {
        Vector<BaseElement> v = new Vector<BaseElement>();
        v.addElement(element);
        this.removeCharts(v);
    }

    public void removeCharts(Collection chartList) {
        if (chartList == null) {
            return;
        }
        Iterator it = chartList.iterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            BaseElement chart;
            Object o = it.next();
            if (!(o instanceof BaseElement) || !this.chartHashTable.containsKey(chart = (BaseElement)o)) continue;
            this.chartHashTable.remove(chart);
            this.charts.remove(chart);
            this.chartLayerList.remove(chart);
            this.doCycleAttrs();
            if (this.primary == chart) {
                this.primary = null;
            }
            if (!this.charts.isEmpty()) {
                this.primary = (BaseElement)this.charts.elementAt(0);
            }
            if (this.dataDlg != null) {
                this.dataDlg.removeChart(chart);
            }
            if (chart.getBrushListener() != null) {
                this.brush.removeBrushListener(chart.getBrushListener());
            }
            this.initAxesFromSource(this.primary);
            this.resetViewport();
            this.checkAxes();
            this.layoutChart();
            this.manageChartTabs(null);
            this.initializeMenu(null, this.isPopupRebuildRequired(this.primary));
            this.buildAndDraw(Boolean.TRUE, null, null);
        }
    }

    private void doCycleAttrs() {
        if (!this.cycleAttrs) {
            return;
        }
        if (this.chartLayerList == null || this.chartLayerList.size() == 0) {
            return;
        }
        for (int i = 0; i < this.chartLayerList.size(); ++i) {
            BaseElement be = (BaseElement)this.chartLayerList.get(i);
            be.setOverlayIndex(i, this.chartLayerList.size());
        }
    }

    public void removeAllCharts() {
        this.chartHashTable.clear();
        this.charts.removeAllElements();
        this.chartLayerList.removeAllElements();
        this.brush.removeAllBrushListeners();
        this.primary = null;
        this.initializeMenu(null);
        this.resetViewport();
        this.layoutChart();
    }

    @Override
    protected int getMinDiscreteTickCount(int axis) {
        if (this.primary == null) {
            return -1;
        }
        int rc = -1;
        Object prop = null;
        switch (axis) {
            case 0: 
            case 3: {
                prop = this.primary.getPropertyValue(19067);
                break;
            }
            case 1: 
            case 4: {
                prop = this.primary.getPropertyValue(19066);
            }
        }
        if (prop instanceof Number) {
            rc = ((Number)prop).intValue();
        }
        return rc;
    }

    protected BaseElement[] getXAxisCharts() {
        Vector<BaseElement> rc = new Vector<BaseElement>();
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getXAxisMapping() != 0) continue;
            rc.addElement(chart);
        }
        if (rc.size() == 0) {
            return null;
        }
        Object[] be = new BaseElement[rc.size()];
        rc.copyInto(be);
        return be;
    }

    protected BaseElement[] getX2AxisCharts() {
        Vector<BaseElement> rc = new Vector<BaseElement>();
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getXAxisMapping() != 3) continue;
            rc.addElement(chart);
        }
        if (rc.size() == 0) {
            return null;
        }
        Object[] be = new BaseElement[rc.size()];
        rc.copyInto(be);
        return be;
    }

    protected BaseElement[] getYAxisCharts() {
        Vector<BaseElement> rc = new Vector<BaseElement>();
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getYAxisMapping() != 1) continue;
            rc.addElement(chart);
        }
        if (rc.size() == 0) {
            return null;
        }
        Object[] be = new BaseElement[rc.size()];
        rc.copyInto(be);
        return be;
    }

    protected BaseElement[] getY2AxisCharts() {
        Vector<BaseElement> rc = new Vector<BaseElement>();
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getYAxisMapping() != 4) continue;
            rc.addElement(chart);
        }
        if (rc.size() == 0) {
            return null;
        }
        if (rc.size() == 0) {
            return null;
        }
        Object[] be = new BaseElement[rc.size()];
        rc.copyInto(be);
        return be;
    }

    @Override
    protected DataRange getAxisRange(int axis) {
        if (this.charts == null) {
            return null;
        }
        BaseElement[] elements = null;
        int roleProperty = -1;
        byte dim = 1;
        switch (axis) {
            case 0: {
                elements = this.getXAxisCharts();
                roleProperty = 19057;
                dim = 1;
                break;
            }
            case 3: {
                elements = this.getX2AxisCharts();
                roleProperty = 19057;
                dim = 1;
                break;
            }
            case 1: {
                elements = this.getYAxisCharts();
                roleProperty = 19056;
                dim = 2;
                break;
            }
            case 4: {
                elements = this.getY2AxisCharts();
                roleProperty = 19056;
                dim = 2;
            }
        }
        if (elements == null) {
            return null;
        }
        DataRange defaultRange = null;
        for (int i = 0; i < elements.length; ++i) {
            Object roles = elements[i].getPropertyValue(roleProperty);
            DataRange chartRange = elements[i].getPreferredRange(roles);
            if (chartRange == null) continue;
            int dataRangeType = elements[i].getDataRangeType(dim);
            if (dataRangeType == 2) {
                return chartRange;
            }
            defaultRange = BaseElementComponent.mergeRange(defaultRange, chartRange);
        }
        return defaultRange;
    }

    @Override
    protected DataRange getRange(Object which) {
        if (which == null) {
            return null;
        }
        DataRange defaultRange = null;
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            DataRange chartRange = chart.getPreferredRange(which);
            if (chartRange == null) continue;
            int dataRangeType = 1;
            if (which.equals("X") || which.equals(RoleInterface.ROLE_X)) {
                dataRangeType = chart.getDataRangeType((byte)1);
            } else if (which.equals("Y") || which.equals(RoleInterface.ROLE_Y)) {
                dataRangeType = chart.getDataRangeType((byte)2);
            }
            if (dataRangeType == 2) {
                return chartRange;
            }
            defaultRange = BaseElementComponent.mergeRange(defaultRange, chartRange);
        }
        return defaultRange;
    }

    protected void buildBackBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer() || this.getBuildDepth() > 0) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = SILKUtilities.createCompatibleImage((int)this.compWidth, (int)this.compHeight, (int)3);
        } else {
            SILKUtilities.clearImage((Image)this.backBuffer);
        }
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        this.drawChart(g);
    }

    protected void buildSelectionBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer()) {
            return;
        }
        if (this.buffer2 == null) {
            this.buffer2 = SILKUtilities.createCompatibleImage((int)this.compWidth, (int)this.compHeight, (int)3);
        } else {
            SILKUtilities.clearImage((Image)this.buffer2);
        }
        Graphics2D g = (Graphics2D)this.buffer2.getGraphics();
        if (this.backBuffer != null) {
            g.drawImage(this.backBuffer, 0, 0, null);
        } else {
            this.drawChart(g);
        }
        this.drawSelections(g);
        this.buffer2Valid = true;
    }

    @Override
    public void drawSelections(Graphics g) {
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            g.setClip(this.clipRect);
            chart.draw(g, true);
            g.setClip(null);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        for (int i = 0; i < this.charts.size(); ++i) {
            ((BaseElement)this.charts.elementAt(i)).setBounds(this.dataRegion);
        }
        this.layoutChart();
        this.initAxesFromSource(this.primary);
        this.buildAndDraw(Boolean.TRUE, null, null);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        long t1 = System.currentTimeMillis();
        super.paintComponent(g);
        if (this.getBuildDepth() == 0 && this.legendUpdateRequired()) {
            this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
            this.graphLayout.setDataRegion(this.dataRegion);
            this.invalidateBackBuffer();
        }
        Graphics2D g2 = (Graphics2D)g;
        boolean chartUsingSelectionBuffer = true;
        for (int i = 0; i < this.charts.size(); ++i) {
            if (((BaseElement)this.charts.elementAt(i)).isUsingSelectionBuffer()) continue;
            chartUsingSelectionBuffer = false;
        }
        if (this.isUsingBackBuffer()) {
            if (this.backBuffer == null || !this.backBufferValid) {
                this.buildBackBuffer();
            }
            if (!chartUsingSelectionBuffer) {
                g.drawImage(this.backBuffer, 0, 0, null);
            }
        } else {
            this.drawChart(g2);
        }
        long start = System.currentTimeMillis();
        if (this.isUsingBackBuffer() && chartUsingSelectionBuffer) {
            if (this.buffer2 == null || !this.buffer2Valid) {
                this.buildSelectionBuffer();
            }
            g.drawImage(this.buffer2, 0, 0, null);
        } else {
            this.drawSelections(g);
        }
        long end = System.currentTimeMillis();
        if (this.isTakingDiagnostics(2)) {
            this.getDiagnosticsEvent().getTable().put(new Integer(2), new Long(end - start));
            this.fireDiagnosticsEvent(2);
        }
        this.drawAxisZoomPanIndicators(g);
        this.drawReferenceRanges(g);
        this.brush.draw(g2);
        this.graphLayout.drawHighlight(g);
        this.warningIcon.draw(g);
        if (this.silkAnno != null) {
            this.silkAnno.draw(g2);
        }
        long t2 = System.currentTimeMillis();
    }

    public void drawChart(Graphics g) {
        long start = System.currentTimeMillis();
        if (this.background != null && g instanceof Graphics2D) {
            this.background.drawBackground((Graphics2D)g, this, new Rectangle(0, 0, this.compWidth, this.compHeight));
        }
        if (g instanceof Graphics2D) {
            this.drawWall((Graphics2D)g);
        }
        this.drawAxes(g);
        this.drawReferenceLines(g);
        this.graphLayout.draw(g);
        boolean errorsOnAllCharts = this.charts.size() > 0;
        Graph dataLabels = new Graph(this.dataRegion);
        g.setClip(this.clipRect);
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement be = (BaseElement)this.charts.elementAt(i);
            be.setDataLabelObject(dataLabels);
            be.draw(g, false);
            Object o = be.getPropertyValue(19078);
            if (o instanceof Boolean) {
                errorsOnAllCharts &= (Boolean)o == false;
                continue;
            }
            errorsOnAllCharts = false;
        }
        this.drawDataLabels(g, dataLabels);
        g.setClip(null);
        this.drawErrorMessages(g, errorsOnAllCharts);
        this.backBufferValid = true;
        long end = System.currentTimeMillis();
        if (this.isTakingDiagnostics(1)) {
            this.getDiagnosticsEvent().getTable().put(new Integer(1), new Long(end - start));
            this.fireDiagnosticsEvent(1);
        }
    }

    protected BaseElement getElementForDataLabelId(int id) {
        for (int i = 0; i < this.charts.size(); ++i) {
            if (((BaseElement)this.charts.elementAt(i)).getDataLabelId() != id) continue;
            return (BaseElement)this.charts.elementAt(i);
        }
        return null;
    }

    protected void drawDataLabels(Graphics g, Graph dataLabels) {
        if (dataLabels.isFreeOfObstacles()) {
            dataLabels.setHMaxShift(20);
            dataLabels.setVMaxShift(4);
            dataLabels.setVDistanceWeight(2.0);
        } else {
            dataLabels.setHMaxShift(20);
            dataLabels.setVMaxShift(6);
            dataLabels.setVDistanceWeight(2.0);
        }
        dataLabels.buildConflictGraph();
        dataLabels.placeLabels();
        block10: for (int i = 0; i < dataLabels.getNumNodes(); ++i) {
            Node n = dataLabels.getNode(i);
            BaseElement element = this.getElementForDataLabelId(n.index);
            if (n.text == null || element == null) continue;
            TextStyleElement ts = element.getDataLabelStyle().getAsTextStyle();
            g.setColor(ts.getTextColor());
            g.setFont(ts.getFont());
            switch (n.getLabelPosition()) {
                default: {
                    continue block10;
                }
                case 0: {
                    g.drawString(n.text, n.x + n.dx, n.y + n.dy + -n.textDescent);
                    continue block10;
                }
                case 1: {
                    g.drawString(n.text, n.x + n.dx - n.textWidth, n.y + n.dy - n.textDescent);
                    continue block10;
                }
                case 2: {
                    g.drawString(n.text, n.x + n.dx, n.y + n.dy + n.textHeight - n.textDescent);
                    continue block10;
                }
                case 3: {
                    g.drawString(n.text, n.x + n.dx - n.textWidth, n.y + n.dy + n.textHeight - n.textDescent);
                    continue block10;
                }
                case 4: {
                    g.drawString(n.text, n.x + n.dx, n.y + n.dy + n.textHeight / 2 - n.textDescent);
                    continue block10;
                }
                case 5: {
                    g.drawString(n.text, n.x + n.dx - n.textWidth / 2, n.y + n.dy - n.textDescent);
                    continue block10;
                }
                case 6: {
                    g.drawString(n.text, n.x + n.dx - n.textWidth, n.y + n.dy + n.textHeight / 2 - n.textDescent);
                    continue block10;
                }
                case 7: {
                    g.drawString(n.text, n.x + n.dx - n.textWidth / 2, n.y + n.dy + n.textHeight - n.textDescent);
                }
            }
        }
    }

    protected void drawErrorMessages(Graphics g, boolean errorsOnAllCharts) {
        int xStart;
        int offsetFromWall = 10;
        int gapBetweenTextLines = 4;
        int gapBetweenIconAndText = 10;
        int gapBetweenChartErrors = 10;
        int x = xStart = this.dataRegion.x + offsetFromWall;
        int y = this.dataRegion.y + offsetFromWall;
        String errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"BaseElementComponent.ErrorMessage.fmt.txt", (String)"{0} : {1}");
        TextStyleElement dtse = this.style.getTextStyleElement("DataText");
        TextStyleElement titleSE = this.style.getTextStyleElement("TitleText");
        Font titleFont = titleSE.getFont();
        Font idFont = titleFont.deriveFont((float)SILKUtilities.adjustFontSize(titleFont.getSize()));
        Font dataTextFont = dtse.getFont();
        Font errMsgFont = dataTextFont.deriveFont((float)SILKUtilities.adjustFontSize(dataTextFont.getSize()));
        g.setColor(dtse.getTextColor());
        if (errorsOnAllCharts) {
            g.setFont(idFont);
            g.drawString(SILKErrorUtilities.ERRORS_TITLE, x, y += g.getFontMetrics().getHeight());
            y += g.getFontMetrics().getHeight() + gapBetweenTextLines;
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement be = (BaseElement)this.charts.elementAt(i);
            int[] errorIds = null;
            Object o = be.getPropertyValue(19079);
            errorIds = o instanceof int[] ? (int[])o : Extract.getIntegers((Object)o, null);
            if (errorIds != null) {
                String id;
                String string = id = be.getId() == null ? null : be.getId().toString();
                if (errorsOnAllCharts) {
                    Icon icon;
                    g.setFont(idFont);
                    SILKChartInfo chartInfo = SILKChartInfo.getInstance(be);
                    if (chartInfo != null && (icon = chartInfo.getIcon()) != null) {
                        int ht = g.getFontMetrics().getAscent();
                        icon.paintIcon(this, g, x, y -= ht);
                        x += icon.getIconWidth() + gapBetweenIconAndText;
                        y += ht;
                    }
                    g.drawString(id, x, y);
                    y += g.getFontMetrics().getHeight() + gapBetweenTextLines;
                }
                g.setFont(errMsgFont);
                for (int j = 0; j < errorIds.length; ++j) {
                    String error = SILKErrorUtilities.getErrorText(errorIds[j]);
                    if (errorsOnAllCharts) {
                        g.drawString(error, x, y);
                        y += g.getFontMetrics().getHeight() + gapBetweenTextLines;
                    }
                    System.err.println(MessageFormat.format(errorMessage, id, error));
                }
            }
            gapBetweenChartErrors += 10;
            x = xStart;
        }
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        boolean rc = super.applyWhereClause(clause, clearPrevious);
        for (int i = 0; i < this.charts.size(); ++i) {
            rc &= ((BaseElement)this.charts.elementAt(i)).applyWhereClause(clause, clearPrevious);
        }
        this.setInternalRange((byte)1, 0, this.getAxisRange(0));
        this.setInternalRange((byte)2, 0, this.getAxisRange(1));
        this.setInternalRange((byte)1, 1, this.getAxisRange(3));
        this.setInternalRange((byte)2, 1, this.getAxisRange(4));
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        return rc;
    }

    @Override
    public String getWhereClause() {
        if (this.primary == null) {
            return null;
        }
        return this.primary.getWhereClause();
    }

    @Override
    public boolean setActionMode(int mode) {
        boolean rc = super.setActionMode(mode);
        this.brush.setActionMode(this.actionMode);
        for (int i = 0; i < this.charts.size(); ++i) {
            rc &= ((BaseElement)this.charts.elementAt(i)).setActionMode(mode);
        }
        if (this.silkAnno != null) {
            this.silkAnno.setActionMode(this.actionMode);
        }
        return rc;
    }

    @Override
    protected void doResize(int compWidthIn, int compHeightIn) {
        int i;
        if (compHeightIn == this.compHeight && compWidthIn == this.compWidth) {
            return;
        }
        super.doResize(compWidthIn, compHeightIn);
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.buffer2 != null) {
            this.buffer2.flush();
        }
        this.buffer2 = null;
        if (this.charts == null) {
            return;
        }
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        for (i = 0; i < this.charts.size(); ++i) {
            ((BaseElement)this.charts.elementAt(i)).setInnerMargin(this.innerMargin);
        }
        this.dataRegion.x = this.outerMargin.left;
        this.dataRegion.y = this.outerMargin.top;
        this.dataRegion.width = this.compWidth - this.outerMargin.right - this.outerMargin.left;
        this.dataRegion.height = this.compHeight - this.outerMargin.top - this.outerMargin.bottom;
        this.graphLayout.setDataRegion(this.dataRegion);
        this.clipRect = new Rectangle(this.dataRegion.x, this.dataRegion.y, this.dataRegion.width, this.dataRegion.height);
        for (i = 0; i < this.charts.size(); ++i) {
            ((BaseElement)this.charts.elementAt(i)).setBounds(this.dataRegion);
            ((BaseElement)this.charts.elementAt(i)).setComponentSize(this.compWidth, this.compHeight);
            if (this.silkAnno == null) continue;
            this.silkAnno.setDataBoundingBox(this.dataRegion, ((BaseElement)this.charts.elementAt(i)).getId().toString());
            this.silkAnno.setTransform(((BaseElement)this.charts.elementAt(i)).getTransformObject(), ((BaseElement)this.charts.elementAt(i)).getId().toString());
        }
        this.brush.invalidateBrush();
        this.brush.setChartArea(this.dataRegion);
        this.setupTransforms();
        this.applyDeferredViewports();
    }

    @Override
    public void marginChanged(MarginChangeEvent e) {
        this.increaseBuildDepth();
        if (!this.inMarginChanged || e.getSource() != this) {
            super.marginChanged(e);
        }
        if (this.charts != null) {
            int i;
            for (i = 0; i < this.charts.size(); ++i) {
                ((BaseElement)this.charts.elementAt(i)).setInnerMargin(this.innerMargin);
            }
            if (this.propogateMarginEvents) {
                for (i = 0; i < this.charts.size(); ++i) {
                    ((BaseElement)this.charts.elementAt(i)).setBounds(this.dataRegion);
                }
            }
        }
        this.decreaseBuildDepth();
    }

    @Override
    public String getToolTipText(MouseEvent me) {
        return this.getTipText(me.getX(), me.getY());
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        if (id != null && this.charts.size() > 1) {
            BaseElement chart = (BaseElement)this.getChart(id);
            if (chart == null) {
                return null;
            }
            return chart.getSupportedRoles(id, discrete);
        }
        if (this.roles != null) {
            return this.roles.getSupportedRoles(id, discrete);
        }
        return null;
    }

    @Override
    public void invalidateBackBuffer() {
        if (this.holdBuild > 0) {
            return;
        }
        this.backBufferValid = false;
        this.buffer2Valid = false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        if (id == null || dialogIn == null) {
            return false;
        }
        if (id.equals("Properties") && dialogIn instanceof GraphPropertiesDialog) {
            boolean graph = false;
            boolean chart = false;
            boolean legend = false;
            boolean axes = false;
            boolean titles = false;
            switch (category) {
                case 0: {
                    graph = true;
                    break;
                }
                case 1: {
                    chart = true;
                    break;
                }
                case 3: {
                    legend = true;
                    break;
                }
                case 2: {
                    axes = true;
                    break;
                }
                case 4: {
                    titles = true;
                    break;
                }
                case 999: {
                    titles = true;
                    axes = true;
                    legend = true;
                    chart = true;
                    graph = true;
                }
            }
            if (graph) {
                super.addTabs(id, dialogIn, 0, listener);
            }
            if (chart) {
                if (this.propertiesDialog == null) {
                    this.createPropertyDialog(listener);
                }
                this.manageChartTabs(listener == null ? null : listener);
            }
            if (axes) {
                super.addTabs(id, dialogIn, 2, listener);
            }
            if (legend) {
                super.addTabs(id, dialogIn, 3, listener);
            }
            if (titles) {
                super.addTabs(id, dialogIn, 4, listener);
            }
        }
        return false;
    }

    private void manageChartTabs(Object listener) {
        if (this.propertiesDialog == null) {
            return;
        }
        GraphPropertiesDialog.PropertiesTreeNode node = this.propertiesDialog.getRootNode("Chart", true);
        if (this.charts.size() == 1) {
            TabPanelInterface tab = ((BaseElement)this.charts.elementAt(0)).getChartTab(listener);
            node.setPanel((Component)((Object)tab));
            node.setDisplayName(((BaseElement)this.charts.elementAt(0)).getId().toString());
            node.removeAllChildren();
        } else {
            node.setPanel(new OverlayPanel(this));
            node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"BaseElementComponent.ChartLayers.txt", (String)"Chart Layers"));
            Enumeration<TreeNode> e = node.children();
            Hashtable<Object, GraphPropertiesDialog.PropertiesTreeNode> h = new Hashtable<Object, GraphPropertiesDialog.PropertiesTreeNode>();
            while (e.hasMoreElements()) {
                GraphPropertiesDialog.PropertiesTreeNode node1 = (GraphPropertiesDialog.PropertiesTreeNode)e.nextElement();
                h.put(node1.getName(), node1);
            }
            node.removeAllChildren();
            for (int i = 0; i < this.charts.size(); ++i) {
                BaseElement element = (BaseElement)this.charts.elementAt(i);
                GraphPropertiesDialog.PropertiesTreeNode node1 = (GraphPropertiesDialog.PropertiesTreeNode)h.get(element);
                if (node1 == null) {
                    node1 = node.createChild(element);
                } else {
                    node.add(node1);
                }
                node1.setDisplayName(element.getId().toString());
                node1.setPanel((Component)((Object)element.getChartTab(listener)));
            }
            this.propertiesDialog.refreshTree();
        }
    }

    @Override
    public void layerChanged(LayerChangedEvent lce) {
        if (lce == null) {
            return;
        }
        if (lce.getAction() == 3) {
            this.buildAndDraw(Boolean.TRUE, null, null);
        } else if (lce.getAction() == 5) {
            this.resetViewport();
        } else if (lce.getAction() == 4) {
            this.buildLegends();
        } else if (lce.getAction() == 9) {
            if (lce.getSource() instanceof BaseElement) {
                this.brush.addFilter(((BaseElement)lce.getSource()).getFilter());
            }
            this.buildAndDraw(Boolean.TRUE, null, null);
        } else if (lce.getAction() == 6 && this.legends != null) {
            if (!this.createLegends) {
                return;
            }
            Object legend = lce.getBuildData();
            if (legend == null) {
                return;
            }
            LegendObjectJ2D leg = (LegendObjectJ2D)this.legends.get(legend);
            if (leg != null) {
                for (int i = 0; i < this.charts.size(); ++i) {
                    BaseElement chart = (BaseElement)this.charts.elementAt(i);
                    Object oldCurrentLegend = chart.getPropertyValue(23);
                    chart.setPropertyValue(23, legend);
                    Object title = chart.getPropertyValue(426);
                    if (title != null) {
                        leg.setTitle(title.toString());
                    }
                    chart.setPropertyValue(23, oldCurrentLegend);
                }
            }
        } else if (lce.getAction() == 2) {
            this.buffer2Valid = false;
            this.repaint();
        } else if (lce.getAction() == 1) {
            this.invalidateBackBuffer();
            this.repaint();
        } else if (lce.getAction() == 7) {
            this.initAxesFromSource((BaseElement)lce.getSource());
            this.checkAxes();
            this.layoutChart();
            this.invalidateBackBuffer();
            this.repaint();
        } else if (lce.getAction() == 10) {
            this.initAxesFromSource((BaseElement)lce.getSource());
            this.checkAxes();
            this.buildAndDraw(Boolean.TRUE, null, null);
        } else if (lce.getAction() == 8) {
            this.initAxisFixedTicks((BaseElement)lce.getSource());
            this.invalidateTransforms("ALL");
            this.layoutChart();
            this.repaint();
        }
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        this.increaseBuildDepth();
        boolean rc = true;
        for (int i = 0; i < this.charts.size(); ++i) {
            rc &= ((BaseElement)this.charts.elementAt(i)).setDataSource(source, id);
        }
        this.decreaseBuildDepth();
        return rc;
    }

    @Override
    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    @Override
    public DataFilterReadInterface getFilter() {
        if (this.charts.size() == 1) {
            return ((BaseElement)this.charts.elementAt(0)).getFilter();
        }
        return null;
    }

    @Override
    protected void setInternalRange(byte dim, int index, DataRange range) {
        super.setInternalRange(dim, index, range);
        DataRange r = this.getOutputRange(dim, index);
        AxisZoomPanHandler zph = null;
        switch (dim) {
            case 1: {
                if (index == 0) {
                    zph = this.xAxisZoomHandler;
                    break;
                }
                zph = this.x2AxisZoomHandler;
                break;
            }
            case 2: {
                zph = index == 0 ? this.yAxisZoomHandler : this.y2AxisZoomHandler;
            }
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (!this.axisMappingsMatch(dim, index, chart)) continue;
            if (zph == null || !zph.hasViewport()) {
                chart.setDataRange(dim, index, this.computeAxisRange(range, dim, index));
            }
            chart.setRange(dim, index, r);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean axisMappingsMatch(byte dim, int index, BaseElement chart) {
        boolean rc;
        block14: {
            rc = false;
            switch (dim) {
                case 1: {
                    switch (index) {
                        case 0: {
                            if (chart.getXAxisMapping() != 0) break;
                            rc = true;
                            return rc;
                        }
                        case 1: {
                            if (chart.getXAxisMapping() != 3) break;
                            rc = true;
                        }
                    }
                    return rc;
                }
                case 2: {
                    switch (index) {
                        case 0: {
                            if (chart.getYAxisMapping() != 1) return rc;
                            rc = true;
                            break block14;
                        }
                        case 1: {
                            if (chart.getYAxisMapping() != 4) return rc;
                            rc = true;
                        }
                    }
                }
            }
        }
        return rc;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (!this.mouseInLegend(me.getPoint())) {
            super.mousePressed(me);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        int flags = me.getModifiers();
        AxisComponent ac = this.getAxisForPoint(me.getPoint());
        if (!(me.getSource() instanceof RangeSlider) && !this.mouseInLegend(me.getPoint()) && ac == null && this.menu != null && (flags & 4) != 0 && this.allowPopup) {
            int x = me.getX();
            int y = me.getY();
            this.menu.show(this, x, y);
            me.consume();
        } else if (!this.mouseInLegend(me.getPoint())) {
            super.mouseReleased(me);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (!this.mouseInLegend(me.getPoint())) {
            super.mouseClicked(me);
        }
    }

    protected boolean mouseInLegend(Point p) {
        if (this.legends == null) {
            return false;
        }
        Enumeration e = this.legends.elements();
        while (e.hasMoreElements()) {
            if (!((LegendObjectJ2D)e.nextElement()).isPointInLegend(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void buildDataDialog() {
        if (this.dataDlg != null) {
            return;
        }
        this.createDataDialog(this);
        for (int i = 0; i < this.charts.size(); ++i) {
            this.dataDlg.addChart((RoleInterface)this.charts.elementAt(i));
        }
    }

    @Override
    protected void buildPropertiesDialog(Object listner) {
        if (this.propertiesDialog == null) {
            this.createPropertyDialog(listner);
            this.propertiesDialog.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"BaseElementComponent.Properties.txt", (String)"Properties"));
        }
        this.addTabs("Properties", this.propertiesDialog, 999, listner == this ? null : listner);
    }

    @Override
    public boolean setStyle(Object newStyle) {
        Enumeration<Object> legs;
        boolean rc = super.setStyle(newStyle);
        if (this.brush != null) {
            this.brush.setPolygonFillColor(this.style.getDataStyleElement("Selection").getLineColor());
        }
        if (this.legends != null) {
            legs = this.legends.elements();
            while (legs.hasMoreElements()) {
                LegendObjectJ2D l = (LegendObjectJ2D)legs.nextElement();
                l.applyStyle(this.style);
            }
        }
        if (this.userLegends != null) {
            legs = this.userLegends.elements();
            while (legs.hasMoreElements()) {
                Object obj = legs.nextElement();
                if (!(obj instanceof LegendObjectJ2D)) continue;
                LegendObjectJ2D l = (LegendObjectJ2D)obj;
                l.applyStyle(this.style);
            }
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            rc &= ((BaseElement)this.charts.elementAt(i)).setStyle(this.style);
        }
        if (this.silkAnno != null) {
            this.silkAnno.setStyle(this.style);
        }
        this.buildAndDraw(new Boolean(true), null, null);
        return rc;
    }

    @Override
    public boolean build(Object buildData) {
        if (this.holdBuild > 0) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        if (buildData instanceof Boolean && ((Boolean)buildData).booleanValue()) {
            this.invalidateBackBuffer();
        }
        boolean rc = super.build(buildData);
        this.buildLegends();
        if (this.propertiesDialog != null) {
            this.propertiesDialog.updateLegendPanels(this, this);
        }
        this.layoutChart();
        this.buffer2Valid = false;
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        this.computeInnerOuterMargin();
        if (this.charts == null) {
            return true;
        }
        if (this.primary != null) {
            Object o = this.primary.getPropertyValue(269);
            if (o != null && o instanceof Boolean) {
                this.shouldAutocalculateXAxis = (Boolean)o;
            }
            if ((o = this.primary.getPropertyValue(270)) != null && o instanceof Boolean) {
                this.shouldAutocalculateYAxis = (Boolean)o;
            }
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            this.setTransformOnChart(chart);
            chart.setInnerMargin(this.innerMargin);
            this.dataRegion.x = this.outerMargin.left;
            this.dataRegion.y = this.outerMargin.top;
            this.dataRegion.width = this.compWidth - this.outerMargin.right - this.outerMargin.left;
            this.dataRegion.height = this.compHeight - this.outerMargin.top - this.outerMargin.bottom;
            chart.setBounds(this.dataRegion);
            this.graphLayout.setDataRegion(this.dataRegion);
            this.brush.setChartArea(this.dataRegion);
            if (this.silkAnno == null) continue;
            this.silkAnno.setDataBoundingBox(this.dataRegion, "");
            this.silkAnno.setTransform(chart.getTransformObject(), "");
        }
        this.setupTransforms();
        long endTime = System.currentTimeMillis();
        if (this.isTakingDiagnostics(0)) {
            this.getDiagnosticsEvent().getTable().put(new Integer(0), new Long(endTime - startTime));
            this.fireDiagnosticsEvent(0);
        }
        return rc;
    }

    protected void setTransformOnChart(BaseElement chart) {
        if (chart == null) {
            return;
        }
        int xAxisMapping = chart.getXAxisMapping();
        int yAxisMapping = chart.getYAxisMapping();
        String whichX = null;
        String whichY = null;
        if (xAxisMapping == 0) {
            whichX = "X";
        } else if (xAxisMapping == 3) {
            whichX = "X2";
        }
        if (yAxisMapping == 1) {
            whichY = "Y";
        } else if (yAxisMapping == 4) {
            whichY = "Y2";
        }
        chart.setTransformObject(this.getTransform(whichX, whichY));
    }

    protected boolean supportsInsideLegends() {
        if (this.charts == null || this.charts.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            Object obj = chart.getPropertyValue(39);
            if (!(obj instanceof Boolean) || ((Boolean)obj).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected void buildLegends() {
        int i;
        if (!this.createLegends || this.charts == null || this.charts.size() == 0) {
            return;
        }
        Hashtable<Object, LegendObjectJ2D> newLegends = new Hashtable<Object, LegendObjectJ2D>();
        LegendInterface[] legs = this.graphLayout.getLegends();
        if (legs != null) {
            for (int i2 = 0; i2 < legs.length; ++i2) {
                if (legs[i2] instanceof LegendObjectJ2D) {
                    this.removeMouseListener((LegendObjectJ2D)legs[i2]);
                    this.removeMouseMotionListener((LegendObjectJ2D)legs[i2]);
                }
                this.graphLayout.removeLegend(legs[i2]);
            }
        }
        Vector<Object> overlayEntries = new Vector<Object>();
        boolean supportsInside = this.supportsInsideLegends();
        if (!SILKGlobal.isFlagSet(4)) {
            for (i = 0; i < this.charts.size(); ++i) {
                Object legendNames;
                BaseElement chart = (BaseElement)this.charts.elementAt(i);
                Object overlayEntry = chart.getPropertyValue(444);
                if (overlayEntry != null && overlayEntry instanceof LegendEntry) {
                    overlayEntries.addElement(overlayEntry);
                }
                if ((legendNames = chart.getPropertyValue(24)) == null) continue;
                Object oldCurrentLegend = chart.getPropertyValue(23);
                if (this.currentLegend == null && oldCurrentLegend instanceof SILKNumber) {
                    this.currentLegend = (SILKNumber)((Object)oldCurrentLegend);
                }
                Enumeration e = Extract.elements((Object)legendNames);
                while (e.hasMoreElements()) {
                    Object variable;
                    Object name = e.nextElement();
                    chart.setPropertyValue(23, name);
                    Object entries = chart.getPropertyValue(433);
                    if (entries == null) continue;
                    Enumeration legendEntries = Extract.elements((Object)entries);
                    int numEntries = Extract.getNumberItems((Object)entries, (int)Extract.getSourceType((Object)entries));
                    boolean continuousLegend = false;
                    Object o = chart.getPropertyValue(441);
                    if (o instanceof Boolean) {
                        continuousLegend = (Boolean)o;
                    }
                    LegendEntryInterface[] arr = new LegendEntryInterface[numEntries];
                    int num = 0;
                    while (legendEntries.hasMoreElements()) {
                        Object le = legendEntries.nextElement();
                        if (!(le instanceof LegendEntryInterface)) continue;
                        arr[num++] = (LegendEntryInterface)le;
                    }
                    LegendObjectJ2D legend = null;
                    if (this.legends != null && this.legends.containsKey(name)) {
                        legend = (LegendObjectJ2D)this.legends.get(name);
                    } else {
                        legend = new LegendObjectJ2D();
                        legend.applyStyle(this.style);
                        Object vis = chart.getPropertyValue(420);
                        if (vis != null && vis instanceof Boolean) {
                            legend.setVisible((Boolean)vis);
                        } else {
                            legend.setVisible(true);
                        }
                    }
                    Object title = chart.getPropertyValue(426);
                    Text titleText = (Text)legend.getTitle();
                    if (title != null && !titleText.hasUserSetValue(9015)) {
                        legend.setTitle(title.toString());
                        titleText.setCurrentValueAsDefault(9015);
                    }
                    newLegends.put(name, legend);
                    legend.setValues(arr, continuousLegend);
                    if (this.getParent() != null) {
                        this.addMouseListener(legend);
                        this.addMouseMotionListener(legend);
                    }
                    if ((variable = chart.getPropertyValue(434)) != null) {
                        legend.setData(chart.getFilter(), variable.toString());
                        legend.getLabel().setFormat(chart.getFilter().getFormat(variable, SASFormat.class));
                    } else {
                        legend.setData(null, null);
                    }
                    legend.setPropertyValue(39, new Boolean(supportsInside));
                    legend.applyPropertyChanges();
                    this.graphLayout.addLegend(legend);
                }
                this.legends = newLegends;
                chart.setPropertyValue(23, oldCurrentLegend);
            }
        }
        if (!SILKGlobal.isFlagSet(4) && overlayEntries.size() > 1 && this.createOverlayLegend) {
            if (this.overlayLegend == null) {
                this.overlayLegend = new LegendObjectJ2D();
                this.overlayLegend.applyStyle(this.style);
                this.overlayLegend.setVisible(true);
            }
            newLegends.put((Object)this.overlayLegendId, this.overlayLegend);
            Object[] arr = new LegendEntry[overlayEntries.size()];
            overlayEntries.copyInto(arr);
            this.overlayLegend.setValues((LegendEntryInterface[])arr, false);
            this.overlayLegend.setPropertyValue(39, new Boolean(supportsInside));
            this.overlayLegend.applyPropertyChanges();
            this.graphLayout.addLegend(this.overlayLegend);
            if (this.currentLegend == null) {
                this.currentLegend = this.overlayLegendId;
            }
            if (this.legends == null) {
                this.legends = newLegends;
            }
        }
        if (this.userLegends != null) {
            for (i = 0; i < this.userLegends.size(); ++i) {
                Object o = this.userLegends.elementAt(i);
                if (!(o instanceof LegendInterface)) continue;
                this.graphLayout.addLegend((LegendInterface)o);
                if (!(o instanceof LegendObjectJ2D)) continue;
                this.addMouseListener((LegendObjectJ2D)o);
                this.addMouseMotionListener((LegendObjectJ2D)o);
            }
        }
    }

    public boolean addUserLegend(LegendInterface legend) {
        if (legend == null) {
            return false;
        }
        if (this.userLegends == null) {
            this.userLegends = new Vector();
        }
        if (!this.userLegends.contains(legend)) {
            this.userLegends.addElement(legend);
        }
        if (legend instanceof LegendObjectJ2D) {
            ((LegendObjectJ2D)legend).applyStyle(this.style);
        }
        return true;
    }

    @Override
    public Object getChart(Object id) {
        if (this.charts == null || this.charts.size() == 0) {
            return null;
        }
        if (id == null) {
            return this.charts.elementAt(0);
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            if (!id.equals(((BaseElement)this.charts.elementAt(i)).getId())) continue;
            return this.charts.elementAt(i);
        }
        return null;
    }

    public BaseElement[] getCharts() {
        Object[] rc = new BaseElement[this.charts.size()];
        this.charts.copyInto(rc);
        return rc;
    }

    public BaseElement getPrimary() {
        return this.primary;
    }

    public void setPrimary(String id) {
        BaseElement chart = (BaseElement)this.getChart(id);
        this.setPrimary(chart);
    }

    public void setPrimary(BaseElement chart) {
        if (chart != null) {
            this.primary = chart;
            this.initializeMenu(null, this.isPopupRebuildRequired(this.primary));
            this.buildAndDraw(Boolean.TRUE, null, null);
        }
    }

    public void setChartOrder(String[] ids) {
        BaseElement chart;
        int i;
        if (ids == null) {
            return;
        }
        Vector<BaseElement> newList = new Vector<BaseElement>();
        for (i = 0; i < ids.length; ++i) {
            chart = (BaseElement)this.getChart(ids[i]);
            if (chart == null) continue;
            newList.addElement(chart);
        }
        for (i = 0; i < this.charts.size(); ++i) {
            chart = (BaseElement)this.charts.elementAt(i);
            if (newList.contains(chart)) continue;
            newList.addElement(chart);
        }
        this.charts.removeAllElements();
        this.charts = newList;
        this.manageChartTabs(null);
    }

    @Override
    public boolean isPropertySupported(int id) {
        PropertyInterface leg;
        LegendInterface li = this.getCurrentLegendObject();
        PropertyInterface propertyInterface = leg = li instanceof PropertyInterface ? (PropertyInterface)li : null;
        if (leg != null && leg.isPropertySupported(id)) {
            return true;
        }
        boolean rc = false;
        switch (id) {
            case 39: {
                rc = true;
                break;
            }
            default: {
                rc = super.isPropertySupported(id);
            }
        }
        return rc;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        PropertyInterface legend;
        LegendInterface li = this.getCurrentLegendObject();
        PropertyInterface propertyInterface = legend = li instanceof PropertyInterface ? (PropertyInterface)li : null;
        if (legend != null && legend.isPropertySupported(id)) {
            legend.setPropertyValue(id, value);
        } else if (this.charts != null) {
            for (int i = 0; i < this.charts.size(); ++i) {
                BaseElement chart = (BaseElement)this.charts.elementAt(i);
                if (!chart.isPropertySupported(id)) continue;
                chart.setPropertyValue(id, value);
            }
        }
        return super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(int id) {
        PropertyInterface legend;
        Object rc = null;
        LegendInterface li = this.getCurrentLegendObject();
        PropertyInterface propertyInterface = legend = li instanceof PropertyInterface ? (PropertyInterface)li : null;
        if (legend != null && legend.isPropertySupported(id)) {
            rc = legend.getPropertyValue(id);
        } else if (this.charts != null) {
            if (id == 24 || id == 25) {
                Vector<String> allLegs = new Vector<String>();
                if (this.overlayLegend != null && this.legends != null && this.legends.containsValue(this.overlayLegend)) {
                    if (id == 25) {
                        allLegs.addElement(ResourceLoader.getResourceString((Object)this.rb, (String)"BaseElementComponent.Charts.txt", (String)"Charts"));
                    } else {
                        allLegs.addElement("Overlay Legend");
                    }
                }
                for (int i = 0; i < this.charts.size(); ++i) {
                    BaseElement chart = (BaseElement)this.charts.elementAt(i);
                    Object obj = chart.getPropertyValue(id);
                    if (obj == null) continue;
                    Enumeration e = Extract.elements((Object)obj);
                    while (e.hasMoreElements()) {
                        allLegs.addElement((String)e.nextElement());
                    }
                }
                Object[] arr = new Object[allLegs.size()];
                allLegs.copyInto(arr);
                return arr;
            }
            boolean found = false;
            for (int i = 0; i < this.charts.size(); ++i) {
                BaseElement chart = (BaseElement)this.charts.elementAt(i);
                if (chart == null || !chart.isPropertySupported(id)) continue;
                rc = chart.getPropertyValue(id);
                found = true;
                break;
            }
            if (!found) {
                switch (id) {
                    case 39: {
                        rc = Boolean.TRUE;
                        break;
                    }
                    case 65: {
                        int i;
                        DynamicIntArray arr = new DynamicIntArray();
                        int[] ia = this.userSetProperties.getSupportedProperties();
                        for (i = 0; i < ia.length; ++i) {
                            arr.add(ia[i]);
                        }
                        for (i = 0; i < this.charts.size(); ++i) {
                            Object obj = ((BaseElement)this.charts.elementAt(i)).getPropertyValue(65);
                            if (!(obj instanceof int[])) continue;
                            ia = (int[])obj;
                            for (int j = 0; j < ia.length; ++j) {
                                arr.add(ia[j]);
                            }
                        }
                        rc = arr.getElements();
                        break;
                    }
                    default: {
                        rc = super.getPropertyValue(id);
                    }
                }
            }
        }
        return rc;
    }

    @Override
    public boolean hasUserSetValue(int id) {
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (!chart.isPropertySupported(id)) continue;
            return chart.hasUserSetValue(id);
        }
        return super.hasUserSetValue(id);
    }

    @Override
    public int[] getPendingChanges(Object source) {
        int i;
        int[] pendingList = super.getPendingChanges(source);
        Vector<Integer> v = new Vector<Integer>();
        if (pendingList != null && pendingList.length > 0) {
            for (i = 0; i < pendingList.length; ++i) {
                v.add(new Integer(pendingList[i]));
            }
        }
        if (this.legends != null) {
            Enumeration e = this.legends.elements();
            while (e.hasMoreElements()) {
                LegendObjectJ2D legend = (LegendObjectJ2D)e.nextElement();
                this.addPendingChanges(legend, source, v);
            }
        }
        if (this.charts != null) {
            for (i = 0; i < this.charts.size(); ++i) {
                this.addPendingChanges((BaseElement)this.charts.elementAt(i), source, v);
            }
        }
        int[] pending = null;
        if (v.size() > 0) {
            pending = new int[v.size()];
            for (int i2 = 0; i2 < v.size(); ++i2) {
                pending[i2] = ((Number)v.elementAt(i2)).intValue();
            }
        }
        return pending;
    }

    @Override
    public boolean applyPropertyChanges(Object source) {
        boolean apply;
        int[] pendingChanges = this.getPendingChanges();
        if (pendingChanges == null && !this.legendUpdateRequired()) {
            return true;
        }
        if (pendingChanges != null) {
            this.buildAfterApplyProperties |= pendingChanges.length > 0;
        }
        boolean fireMarginEvent = false;
        boolean rc = true;
        if (this.legends != null) {
            Enumeration e = this.legends.elements();
            while (e.hasMoreElements()) {
                LegendObjectJ2D legend = (LegendObjectJ2D)e.nextElement();
                fireMarginEvent |= legend.getNumberPendingProperties() > 0;
                fireMarginEvent |= legend.isUpdateRequired();
                rc = legend.applyPropertyChanges(source) || rc;
                this.buildAfterApplyProperties |= rc;
            }
        }
        if (this.charts != null) {
            for (int i = 0; i < this.charts.size(); ++i) {
                rc = ((BaseElement)this.charts.elementAt(i)).applyPropertyChanges(source) || rc;
            }
        }
        boolean bl = apply = super.applyPropertyChanges(source) || rc;
        if (fireMarginEvent && apply) {
            this.fireMarginChanged(new MarginChangeEvent((Object)this));
            this.invalidateBackBuffer();
            this.layoutChart();
        }
        return apply;
    }

    @Override
    public int[] getPendingChanges() {
        int[] p1 = super.getPendingChanges();
        DynamicIntArray dia = new DynamicIntArray(p1);
        if (this.legends != null) {
            Enumeration e = this.legends.elements();
            while (e.hasMoreElements()) {
                LegendObjectJ2D legend = (LegendObjectJ2D)e.nextElement();
                dia.add(legend.getPendingChanges());
            }
        }
        if (this.charts != null) {
            for (int i = 0; i < this.charts.size(); ++i) {
                dia.add(((BaseElement)this.charts.elementAt(i)).getPendingChanges());
            }
        }
        if (dia.getNumberElements() == 0) {
            return null;
        }
        return dia.getValidElements();
    }

    @Override
    public void cancelPropertyChanges(Object source) {
        if (this.legends != null) {
            Enumeration e = this.legends.elements();
            while (e.hasMoreElements()) {
                LegendObjectJ2D legend = (LegendObjectJ2D)e.nextElement();
                legend.cancelPropertyChanges(source);
            }
        }
        if (this.charts != null) {
            for (int i = 0; i < this.charts.size(); ++i) {
                ((BaseElement)this.charts.elementAt(i)).cancelPropertyChanges(source);
            }
        }
        super.cancelPropertyChanges(source);
    }

    @Override
    public void dispose() {
        if (this.chartLayerList != null) {
            this.chartLayerList.removeAllElements();
        }
        if (this.charts != null) {
            Enumeration e = this.charts.elements();
            while (e.hasMoreElements()) {
                BaseElement elem = (BaseElement)e.nextElement();
                elem.removeMarginListener(this);
                elem.removeRangeChangeListener(this);
                elem.removeViewportListener(this);
                if (elem.getBrushListener() != null) {
                    this.brush.removeBrushListener(elem.getBrushListener());
                }
                this.roles = elem.getRoleManager();
                if (this.roles != null) {
                    this.roles.removeRoleListener(this);
                }
                this.dataFilter = elem.getFilter();
                this.brush.removeFilter(this.dataFilter);
                elem.removeLayerListener(this);
                elem.dispose();
                this.charts.remove(elem);
            }
            this.charts = null;
        }
        if (this.chartHashTable != null) {
            this.chartHashTable.clear();
        }
        this.chartHashTable = null;
        if (this.legends != null) {
            this.legends.clear();
        }
        this.legends = null;
        if (this.dataDlg != null) {
            this.dataDlg.removeAllCharts();
        }
        this.menu = null;
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.buffer2 != null) {
            this.buffer2.flush();
        }
        this.buffer2 = null;
        this.brush.dispose();
        if (this.dropTarget != null) {
            this.dropTarget.removeDropTargetListener(this);
            this.dropTarget.setComponent(null);
            this.dropTarget.setActive(false);
            this.dropTarget = null;
        }
        super.dispose();
    }

    @Override
    public Insets getPreferredChartInnerMargin() {
        if (this.charts == null || this.charts.size() == 0) {
            return null;
        }
        Insets insets = new Insets(0, 0, 0, 0);
        for (int i = 0; i < this.charts.size(); ++i) {
            Insets sets = ((BaseElement)this.charts.elementAt(i)).getPreferredInnerMargin();
            if (sets == null) continue;
            if (sets.left > insets.left) {
                insets.left = sets.left;
            }
            if (sets.right > insets.right) {
                insets.right = sets.right;
            }
            if (sets.top > insets.top) {
                insets.top = sets.top;
            }
            if (sets.bottom <= insets.bottom) continue;
            insets.bottom = sets.bottom;
        }
        return insets;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.menu;
    }

    @Override
    public void drawLayer(Graphics g) {
        super.drawLayer(g);
        for (int i = 0; i < this.charts.size(); ++i) {
            ((BaseElement)this.charts.elementAt(i)).drawLayer(g);
        }
    }

    @Override
    public void drawLayerSelections(Graphics g) {
        this.drawSelections(g);
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        boolean rc = true;
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (!chart.isSelectable()) continue;
            rc &= chart.selectInLayer(select, selectRegion, event);
        }
        return rc;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        String rc = null;
        if (this.dataRegion.contains(screenX, screenY)) {
            for (int i = this.charts.size() - 1; i >= 0; --i) {
                BaseElement chart = (BaseElement)this.charts.elementAt(i);
                rc = chart.getTipText(screenX, screenY);
                if (rc == null || rc.length() <= 0) continue;
                this.tooltip.setTooltipTextType(0);
                break;
            }
        }
        if (rc == null && this.dataRegion.contains(screenX, screenY)) {
            rc = this.getReferenceLineTipText(screenX, screenY);
            this.tooltip.setTooltipTextType(1);
        }
        if ((rc == null || rc.length() == 0) && this.warningIcon.isMouseOverIcon(screenX, screenY)) {
            rc = this.warningIcon.getTooltipText();
            this.tooltip.setTooltipTextType(1);
        }
        return rc;
    }

    @Override
    protected Hashtable getDrilldownInfo(int screenX, int screenY) {
        BaseElement chart;
        Hashtable rc = null;
        for (int i = this.charts.size() - 1; i >= 0 && (rc = (chart = (BaseElement)this.charts.elementAt(i)).getDrilldownInfo(screenX, screenY)) == null; --i) {
        }
        return rc;
    }

    @Override
    public TabPanelInterface getChartTab() {
        if (this.charts.size() == 1) {
            return ((BaseElement)this.charts.elementAt(0)).getChartTab();
        }
        return null;
    }

    @Override
    public int getDataRangeType(byte dimension) {
        int rc = 0;
        for (int i = 0; i < this.charts.size(); ++i) {
            if (((BaseElement)this.charts.elementAt(i)).getDataRangeType(dimension) <= rc) continue;
            rc = ((BaseElement)this.charts.elementAt(i)).getDataRangeType(dimension);
        }
        return rc;
    }

    @Override
    public boolean setActionEnabled(String action, boolean enable) {
        for (int i = 0; i < this.charts.size(); ++i) {
            ((BaseElement)this.charts.elementAt(i)).setActionEnabled(action, enable);
        }
        if (action != null && !enable && ("GRAPH_PROPERTIES".equalsIgnoreCase(action) || "DATA_OPTIONS".equalsIgnoreCase(action) || "ACTION_MENU".equalsIgnoreCase(action) || "COPY".equalsIgnoreCase(action))) {
            this.actions.put(action, Boolean.FALSE);
            MenuUtilities.removeMenuItem(this.menu, action);
            return true;
        }
        return super.setActionEnabled(action, enable);
    }

    @Override
    public boolean isActionEnabled(String action) {
        if (this.primary != null) {
            return this.primary.isActionEnabled(action);
        }
        return false;
    }

    @Override
    public Object[] getDataIds() {
        if (this.charts == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getDataIds() == null) {
                Object chartId = ((BaseElement)this.charts.elementAt(i)).getId();
                if (chartId == null) {
                    chartId = "Chart" + i;
                }
                v.addElement(chartId);
                continue;
            }
            Object[] ids = chart.getDataIds();
            for (int j = 0; j < ids.length; ++j) {
                v.addElement(ids[j]);
            }
        }
        return v.toArray();
    }

    @Override
    public Object getDataSource(Object id) {
        if (this.charts == null) {
            return null;
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getDataSource(id) == null) continue;
            return chart.getDataSource(id);
        }
        BaseElement be = (BaseElement)this.getChart(id);
        if (be == null || be.getDataSource() == null) {
            return super.getDataSource(id);
        }
        return be.getDataSource();
    }

    @Override
    public Object getRole(Object variableId) {
        BaseElement chart;
        if (variableId == null) {
            return null;
        }
        String var = variableId.toString();
        if (RoleManager.isTwoLevelName(var) && (chart = (BaseElement)this.getChart(RoleManager.getDataIdFromTwoLevelName(var))) != null) {
            return chart.getRole(RoleManager.getVariableIdFromTwoLevelName(var));
        }
        return super.getRole(variableId);
    }

    @Override
    protected Object[] getXAxisRoles() {
        Vector rc = new Vector();
        for (int i = 0; i < this.charts.size(); ++i) {
            Enumeration e;
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getXAxisMapping() != 0 || (e = Extract.elements((Object)chart.getPropertyValue(19057))) == null) continue;
            while (e.hasMoreElements()) {
                rc.addElement(e.nextElement());
            }
        }
        return rc.toArray();
    }

    @Override
    protected Object[] getYAxisRoles() {
        Vector rc = new Vector();
        for (int i = 0; i < this.charts.size(); ++i) {
            Enumeration e;
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getYAxisMapping() != 1 || (e = Extract.elements((Object)chart.getPropertyValue(19056))) == null) continue;
            while (e.hasMoreElements()) {
                rc.addElement(e.nextElement());
            }
        }
        return rc.toArray();
    }

    @Override
    protected Object[] getX2AxisRoles() {
        Vector rc = new Vector();
        for (int i = 0; i < this.charts.size(); ++i) {
            Enumeration e;
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getXAxisMapping() == 0 || (e = Extract.elements((Object)chart.getPropertyValue(19057))) == null) continue;
            while (e.hasMoreElements()) {
                rc.addElement(e.nextElement());
            }
        }
        return rc.toArray();
    }

    @Override
    protected Object[] getY2AxisRoles() {
        Vector rc = new Vector();
        for (int i = 0; i < this.charts.size(); ++i) {
            Enumeration e;
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getYAxisMapping() == 1 || (e = Extract.elements((Object)chart.getPropertyValue(19056))) == null) continue;
            while (e.hasMoreElements()) {
                rc.addElement(e.nextElement());
            }
        }
        return rc.toArray();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable tr = dropTargetDropEvent.getTransferable();
            if (tr.isDataFlavorSupported(SILKChartFlavor.silkChartFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                WizardEntry entry = (WizardEntry)tr.getTransferData(SILKChartFlavor.silkChartFlavor);
                if (entry instanceof SILKWizardEntry) {
                    SILKWizardEntry swe = (SILKWizardEntry)entry;
                    BaseElement be = swe.getBaseElement();
                    if (be != null) {
                        swe.getChartInfo().assignDataSource(be, entry.getDataSource());
                        swe.getChartInfo().doXMLInit(be);
                        OverlayRoleAssigner assigner = new OverlayRoleAssigner(FilterFactory.getDataSourceFilter((Object)entry.getDataSource()), swe.getChartInfo(), this);
                        assigner.doRoleAssignments(be);
                        this.addChart(be);
                    }
                    swe.reset();
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException io) {
            io.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private void initAxesFromSource(BaseElement source) {
        this.initAxesFromSource(source, true);
    }

    private void initAxesFromSource(BaseElement source, boolean updateRange) {
        TextAttrib text;
        BaseElement chart;
        int i;
        if (source == null) {
            return;
        }
        AxisInterface axis = null;
        byte dimension = 0;
        int primaryAxis = 0;
        String axisLabel = null;
        Object axisFormat = null;
        Object[] axisFixedTicks = null;
        boolean panEnabled = true;
        boolean zoomMinEnabled = true;
        boolean zoomMaxEnabled = true;
        boolean gridlinesVisible = !SILKGlobal.isFlagSet(4);
        int minDiscreteTickCount = -1;
        AxisComponent axisComponent = null;
        BaseElement axisPrimary = null;
        boolean logEnabled = true;
        this.increaseBuildDepth();
        if (source.getXAxisMapping() == 3) {
            axisComponent = this.getAxisComponent("X2");
            axis = this.getAxis("X2");
            primaryAxis = 1;
            if (this.primary.getXAxisMapping() == 0) {
                for (i = 0; i < this.charts.size(); ++i) {
                    chart = (BaseElement)this.charts.elementAt(i);
                    if (chart.getXAxisMapping() != 3) continue;
                    axisPrimary = chart;
                    break;
                }
            }
        } else if (source.getXAxisMapping() == 0) {
            axisComponent = this.getAxisComponent("X");
            axis = this.getAxis("X");
            primaryAxis = 0;
            if (this.primary.getXAxisMapping() == 3) {
                for (i = 0; i < this.charts.size(); ++i) {
                    chart = (BaseElement)this.charts.elementAt(i);
                    if (chart.getXAxisMapping() != 0) continue;
                    axisPrimary = chart;
                    break;
                }
            }
        }
        Object obj = null;
        if (axis != null && axisComponent != null) {
            Boolean b;
            if (axisPrimary == null) {
                axisPrimary = this.primary;
            }
            dimension = 1;
            obj = axisPrimary.getPropertyValue(19053);
            axisLabel = obj != null ? obj.toString() : "";
            for (int i2 = 0; i2 < this.charts.size(); ++i2) {
                if (source.getXAxisMapping() != ((BaseElement)this.charts.elementAt(i2)).getXAxisMapping()) continue;
                obj = ((BaseElement)this.charts.elementAt(i2)).getPropertyValue(19053);
                if (obj != null && !axisLabel.equalsIgnoreCase(obj.toString())) {
                    axisLabel = "";
                }
                if ((obj = ((BaseElement)this.charts.elementAt(i2)).getPropertyValue(19083)) == null || !(obj instanceof Boolean)) continue;
                logEnabled &= ((Boolean)obj).booleanValue();
            }
            ((Axes)axis).setLogTransformEnabled(logEnabled);
            axisFormat = axisPrimary.getPropertyValue(19055);
            obj = axisPrimary.getPropertyValue(19058);
            if (obj != null && obj instanceof Boolean) {
                panEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19062)) != null && obj instanceof Boolean) {
                zoomMaxEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19060)) != null && obj instanceof Boolean) {
                zoomMinEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19064)) != null && obj instanceof Boolean) {
                gridlinesVisible = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19067)) != null && obj instanceof Number) {
                minDiscreteTickCount = ((Number)obj).intValue();
            }
            if ((obj = axisPrimary.getPropertyValue(19070)) != null && obj instanceof Object[]) {
                axisFixedTicks = (Object[])obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19069)) != null && obj instanceof Boolean) {
                if (axisPrimary.getXAxisMapping() == 0) {
                    ((Axes)this.getAxis("X")).setVisible(false);
                } else if (axisPrimary.getXAxisMapping() == 3) {
                    ((Axes)this.getAxis("X2")).setVisible(false);
                }
            }
            if (axisComponent != null) {
                axisComponent.setMinDiscreteTickCount(minDiscreteTickCount);
            }
            if (axis != null) {
                LineStyleInterface li = axis.getGridLines();
                boolean changeGridlines = true;
                if (li instanceof PropertyInterface && ((PropertyInterface)li).hasUserSetValue(9501)) {
                    changeGridlines = false;
                }
                if (changeGridlines) {
                    axis.setGridLines(new Boolean(gridlinesVisible));
                    if (li instanceof LineAttrib) {
                        ((LineAttrib)li).setCurrentValueAsDefault(9501);
                    }
                }
                if (axisLabel != null && !(text = (TextAttrib)axis.getLabel()).hasUserSetValue(9015)) {
                    axis.setLabel(axisLabel);
                    text.setCurrentValueAsDefault(9015);
                }
                if (axisFormat != null) {
                    text = (TextAttrib)axis.getValues();
                    if (!text.hasUserSetValue(9008)) {
                        axis.setValues(axisFormat);
                        text.setCurrentValueAsDefault(9008);
                    }
                } else {
                    text = (TextAttrib)axis.getValues();
                    if (!text.hasUserSetValue(9008)) {
                        ((Axes)axis).setFormat((SASFormat)axisFormat, true);
                        text.setCurrentValueAsDefault(9008);
                    }
                }
                if (axisComponent != null) {
                    axisComponent.setFixedTickValues(axisFixedTicks, false);
                }
                DataRange range = this.getAxisRange(primaryAxis == 0 ? 0 : 3);
                if (updateRange) {
                    this.setInternalRange(dimension, primaryAxis, range);
                    this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, dimension));
                }
            }
            if (this.actions.containsKey("AXIS_PAN") && !(b = (Boolean)this.actions.get("AXIS_PAN")).booleanValue()) {
                panEnabled = false;
            }
            if (this.actions.containsKey("AXIS_ZOOM") && !(b = (Boolean)this.actions.get("AXIS_ZOOM")).booleanValue()) {
                zoomMaxEnabled = false;
                zoomMinEnabled = false;
            }
            boolean isDiscreteAxis = ((Axes)axisComponent.getInternalAxis()).isDiscrete();
            if (primaryAxis == 0) {
                this.xAxisZoomHandler.setZoomPanEnabled(panEnabled, zoomMinEnabled, zoomMaxEnabled);
                if (isDiscreteAxis) {
                    this.xAxisZoomHandler.setMinimumViewportRange(1.1);
                } else {
                    this.xAxisZoomHandler.setMinimumViewportRange(0.001);
                }
            } else {
                this.x2AxisZoomHandler.setZoomPanEnabled(panEnabled, zoomMinEnabled, zoomMaxEnabled);
                if (isDiscreteAxis) {
                    this.x2AxisZoomHandler.setMinimumViewportRange(1.1);
                } else {
                    this.x2AxisZoomHandler.setMinimumViewportRange(0.001);
                }
            }
        }
        gridlinesVisible = !SILKGlobal.isFlagSet(4);
        minDiscreteTickCount = -1;
        axisPrimary = null;
        axisFixedTicks = null;
        axisComponent = null;
        axis = null;
        logEnabled = true;
        if (source.getYAxisMapping() == 4) {
            axisComponent = this.getAxisComponent("Y2");
            axis = this.getAxis("Y2");
            primaryAxis = 1;
            if (this.primary.getYAxisMapping() == 1) {
                for (int i3 = 0; i3 < this.charts.size(); ++i3) {
                    BaseElement chart2 = (BaseElement)this.charts.elementAt(i3);
                    if (chart2.getYAxisMapping() != 4) continue;
                    axisPrimary = chart2;
                    break;
                }
            }
        } else if (source.getYAxisMapping() == 1) {
            axisComponent = this.getAxisComponent("Y");
            axis = this.getAxis("Y");
            primaryAxis = 0;
            if (this.primary.getYAxisMapping() == 4) {
                for (int i4 = 0; i4 < this.charts.size(); ++i4) {
                    BaseElement chart3 = (BaseElement)this.charts.elementAt(i4);
                    if (chart3.getYAxisMapping() != 1) continue;
                    axisPrimary = chart3;
                    break;
                }
            }
        }
        if (axis != null && axisComponent != null) {
            if (axisPrimary == null) {
                axisPrimary = this.primary;
            }
            dimension = 2;
            obj = axisPrimary.getPropertyValue(19052);
            axisLabel = obj != null ? obj.toString() : "";
            for (int i5 = 0; i5 < this.charts.size(); ++i5) {
                if (source.getYAxisMapping() != ((BaseElement)this.charts.elementAt(i5)).getYAxisMapping()) continue;
                obj = ((BaseElement)this.charts.elementAt(i5)).getPropertyValue(19052);
                if (obj != null && !axisLabel.equalsIgnoreCase(obj.toString())) {
                    axisLabel = "";
                }
                if ((obj = ((BaseElement)this.charts.elementAt(i5)).getPropertyValue(19082)) == null || !(obj instanceof Boolean)) continue;
                logEnabled &= ((Boolean)obj).booleanValue();
            }
            ((Axes)axis).setLogTransformEnabled(logEnabled);
            axisFormat = axisPrimary.getPropertyValue(19054);
            obj = axisPrimary.getPropertyValue(19059);
            if (obj != null && obj instanceof Boolean) {
                panEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19063)) != null && obj instanceof Boolean) {
                zoomMaxEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19061)) != null && obj instanceof Boolean) {
                zoomMinEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19065)) != null && obj instanceof Boolean) {
                gridlinesVisible = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19066)) != null && obj instanceof Number) {
                minDiscreteTickCount = ((Number)obj).intValue();
            }
            if ((obj = axisPrimary.getPropertyValue(19071)) != null && obj instanceof Object[]) {
                axisFixedTicks = (Object[])obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19068)) != null && obj instanceof Boolean) {
                if (axisPrimary.getYAxisMapping() == 1) {
                    ((Axes)this.getAxis("Y")).setVisible(false);
                } else if (axisPrimary.getYAxisMapping() == 4) {
                    ((Axes)this.getAxis("Y2")).setVisible(false);
                }
            }
            if (axisComponent != null) {
                axisComponent.setMinDiscreteTickCount(minDiscreteTickCount);
            }
            if (axis != null) {
                LineStyleInterface li = axis.getGridLines();
                boolean changeGridlines = true;
                if (li instanceof PropertyInterface && ((PropertyInterface)li).hasUserSetValue(9501)) {
                    changeGridlines = false;
                }
                if (changeGridlines) {
                    axis.setGridLines(new Boolean(gridlinesVisible));
                    if (li instanceof LineAttrib) {
                        ((LineAttrib)li).setCurrentValueAsDefault(9501);
                    }
                }
                if (axisLabel != null && !(text = (TextAttrib)axis.getLabel()).hasUserSetValue(9015)) {
                    axis.setLabel(axisLabel);
                    text.setCurrentValueAsDefault(9015);
                }
                if (axisFormat != null) {
                    text = (TextAttrib)axis.getValues();
                    if (!text.hasUserSetValue(9008)) {
                        axis.setValues(axisFormat);
                        text.setCurrentValueAsDefault(9008);
                    }
                } else {
                    text = (TextAttrib)axis.getValues();
                    if (!text.hasUserSetValue(9008)) {
                        ((Axes)axis).setFormat((SASFormat)axisFormat, true);
                        text.setCurrentValueAsDefault(9008);
                    }
                }
                if (axisComponent != null) {
                    axisComponent.setFixedTickValues(axisFixedTicks, false);
                }
                if (updateRange) {
                    this.setInternalRange(dimension, primaryAxis, this.getAxisRange(primaryAxis == 0 ? 1 : 4));
                    this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, dimension));
                }
            }
            boolean isDiscreteAxis = ((Axes)axisComponent.getInternalAxis()).isDiscrete();
            if (primaryAxis == 0) {
                this.yAxisZoomHandler.setZoomPanEnabled(panEnabled, zoomMinEnabled, zoomMaxEnabled);
                if (isDiscreteAxis) {
                    this.yAxisZoomHandler.setMinimumViewportRange(1.1);
                } else {
                    this.yAxisZoomHandler.setMinimumViewportRange(0.001);
                }
            } else {
                this.y2AxisZoomHandler.setZoomPanEnabled(panEnabled, zoomMinEnabled, zoomMaxEnabled);
                if (isDiscreteAxis) {
                    this.y2AxisZoomHandler.setMinimumViewportRange(1.1);
                } else {
                    this.y2AxisZoomHandler.setMinimumViewportRange(0.001);
                }
            }
        }
        this.decreaseBuildDepth();
    }

    protected void initAxisFixedTicks(BaseElement source) {
        Object obj;
        BaseElement chart;
        int i;
        AxisInterface axis = null;
        Object[] axisFixedTicks = null;
        AxisComponent axisComponent = null;
        BaseElement axisPrimary = null;
        this.increaseBuildDepth();
        if (source.getXAxisMapping() == 3) {
            axisComponent = this.getAxisComponent("X2");
            axis = this.getAxis("X2");
            if (this.primary.getXAxisMapping() == 0) {
                for (i = 0; i < this.charts.size(); ++i) {
                    chart = (BaseElement)this.charts.elementAt(i);
                    if (chart.getXAxisMapping() != 3) continue;
                    axisPrimary = chart;
                    break;
                }
            }
        } else {
            axisComponent = this.getAxisComponent("X");
            axis = this.getAxis("X");
            if (this.primary.getXAxisMapping() == 3) {
                for (i = 0; i < this.charts.size(); ++i) {
                    chart = (BaseElement)this.charts.elementAt(i);
                    if (chart.getXAxisMapping() != 0) continue;
                    axisPrimary = chart;
                    break;
                }
            }
        }
        if (axisPrimary == null) {
            axisPrimary = this.primary;
        }
        if ((obj = axisPrimary.getPropertyValue(19070)) != null && obj instanceof Object[]) {
            axisFixedTicks = (Object[])obj;
        }
        if (axis != null && axisComponent != null) {
            axisComponent.setFixedTickValues(axisFixedTicks, true);
        }
        axisFixedTicks = null;
        if (source.getYAxisMapping() == 4) {
            axisComponent = this.getAxisComponent("Y2");
            axis = this.getAxis("Y2");
            if (this.primary.getYAxisMapping() == 1) {
                for (int i2 = 0; i2 < this.charts.size(); ++i2) {
                    BaseElement chart2 = (BaseElement)this.charts.elementAt(i2);
                    if (chart2.getYAxisMapping() != 4) continue;
                    axisPrimary = chart2;
                    break;
                }
            }
        } else {
            axisComponent = this.getAxisComponent("Y");
            axis = this.getAxis("Y");
            if (this.primary.getYAxisMapping() == 4) {
                for (int i3 = 0; i3 < this.charts.size(); ++i3) {
                    BaseElement chart3 = (BaseElement)this.charts.elementAt(i3);
                    if (chart3.getYAxisMapping() != 1) continue;
                    axisPrimary = chart3;
                    break;
                }
            }
        }
        if (axisPrimary == null) {
            axisPrimary = this.primary;
        }
        if ((obj = axisPrimary.getPropertyValue(19071)) != null && obj instanceof Object[]) {
            axisFixedTicks = (Object[])obj;
        }
        if (axis != null && axisComponent != null) {
            axisComponent.setFixedTickValues(axisFixedTicks, true);
        }
        this.decreaseBuildDepth();
    }

    protected void checkAxes() {
        boolean hasX = false;
        boolean hasY = false;
        boolean hasX2 = false;
        boolean hasY2 = false;
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.getXAxisMapping() == 0) {
                hasX = true;
            } else if (chart.getXAxisMapping() == 3) {
                hasX2 = true;
            }
            if (chart.getYAxisMapping() == 1) {
                hasY = true;
                continue;
            }
            if (chart.getYAxisMapping() != 4) continue;
            hasY2 = true;
        }
        if (!hasX) {
            this.removeAxis(0);
        }
        if (!hasY) {
            this.removeAxis(1);
        }
        if (!hasX2) {
            this.removeAxis(3);
        }
        if (!hasY2) {
            this.removeAxis(4);
        }
    }

    @Override
    public void roleChanged(RoleEvent thisEvent) {
        this.increaseBuildDepth();
        if (thisEvent.type != 5 && thisEvent.type != 4) {
            this.resetTransformTypes(thisEvent);
            if (this.isAxisRole(new Integer(thisEvent.role), "ANY")) {
                BaseElement source = null;
                for (int i = 0; i < this.charts.size(); ++i) {
                    BaseElement chart = (BaseElement)this.charts.elementAt(i);
                    if (chart.getRoleManager() != thisEvent.source) continue;
                    source = chart;
                }
                boolean x = true;
                boolean y = true;
                boolean x2 = true;
                boolean y2 = true;
                if (this.isAxisRole(new Integer(thisEvent.role), "X") && this.getAxis("X") != null) {
                    ((Axes)this.getAxis("X")).setFormat(null);
                    ((Axes)this.getAxis("X")).setUserMinMax(Double.NaN, Double.NaN);
                    ((Axes)this.getAxis("X")).clearTickValueList();
                    x = false;
                } else if (this.isAxisRole(new Integer(thisEvent.role), "Y") && this.getAxis("Y") != null) {
                    ((Axes)this.getAxis("Y")).setFormat(null);
                    ((Axes)this.getAxis("Y")).setUserMinMax(Double.NaN, Double.NaN);
                    ((Axes)this.getAxis("Y")).clearTickValueList();
                    y = false;
                } else if (this.isAxisRole(new Integer(thisEvent.role), "X2") && this.getAxis("X2") != null) {
                    ((Axes)this.getAxis("X2")).setFormat(null);
                    ((Axes)this.getAxis("X2")).setUserMinMax(Double.NaN, Double.NaN);
                    ((Axes)this.getAxis("X2")).clearTickValueList();
                    x2 = false;
                } else if (this.isAxisRole(new Integer(thisEvent.role), "Y2") && this.getAxis("Y2") != null) {
                    ((Axes)this.getAxis("Y2")).setFormat(null);
                    ((Axes)this.getAxis("Y2")).setUserMinMax(Double.NaN, Double.NaN);
                    ((Axes)this.getAxis("Y2")).clearTickValueList();
                    y2 = false;
                }
                this.resetViewport(x, y, x2, y2);
                TextStyleInterface text = null;
                if (this.isAxisRole(new Integer(thisEvent.role), "X") && this.getAxis("X") != null) {
                    text = this.getAxis("X").getLabel();
                } else if (this.isAxisRole(new Integer(thisEvent.role), "Y") && this.getAxis("Y") != null) {
                    text = this.getAxis("Y").getLabel();
                } else if (this.isAxisRole(new Integer(thisEvent.role), "X2") && this.getAxis("X2") != null) {
                    text = this.getAxis("X2").getLabel();
                } else if (this.isAxisRole(new Integer(thisEvent.role), "Y2") && this.getAxis("Y2") != null) {
                    text = this.getAxis("Y2").getLabel();
                }
                if (text instanceof TextAttrib) {
                    ((TextAttrib)text).setCurrentValueAsDefault(9015);
                }
                this.initAxesFromSource(source);
                this.checkAxes();
            }
        }
        super.roleChanged(thisEvent);
        this.decreaseBuildDepth();
    }

    @Override
    public void viewportChanged(ViewportEvent evt) {
        if (evt.source instanceof BaseElement && (this.dataRegion.width < 0 || this.dataRegion.height < 0)) {
            BaseElement element = (BaseElement)evt.source;
            if (this.deferredViewports == null) {
                this.deferredViewports = new Hashtable();
            }
            if (!Double.isNaN(evt.xMin) && !Double.isNaN(evt.xMax)) {
                if (element.getXAxisMapping() == 3 && this.x2AxisZoomHandler != null) {
                    this.deferredViewports.put(new Integer(5), new double[]{evt.xMin, evt.xMax});
                } else if (this.xAxisZoomHandler != null) {
                    this.deferredViewports.put(new Integer(1), new double[]{evt.xMin, evt.xMax});
                }
            }
            if (!Double.isNaN(evt.yMin) && !Double.isNaN(evt.yMax)) {
                if (element.getYAxisMapping() == 4 && this.y2AxisZoomHandler != null) {
                    this.deferredViewports.put(new Integer(6), new double[]{evt.yMin, evt.yMax});
                } else if (this.yAxisZoomHandler != null) {
                    this.deferredViewports.put(new Integer(2), new double[]{evt.yMin, evt.yMax});
                }
            }
            return;
        }
        if (evt.source instanceof BaseElement) {
            BaseElement element = (BaseElement)evt.source;
            if (!Double.isNaN(evt.xMin) && !Double.isNaN(evt.xMax)) {
                if (element.getXAxisMapping() == 3 && this.x2AxisZoomHandler != null) {
                    this.x2AxisZoomHandler.setViewport(evt.xMin, evt.xMax);
                } else if (this.xAxisZoomHandler != null) {
                    this.xAxisZoomHandler.setViewport(evt.xMin, evt.xMax);
                }
            }
            if (!Double.isNaN(evt.yMin) && !Double.isNaN(evt.yMax)) {
                if (element.getYAxisMapping() == 4 && this.y2AxisZoomHandler != null) {
                    this.y2AxisZoomHandler.setViewport(evt.yMin, evt.yMax);
                } else if (this.yAxisZoomHandler != null) {
                    this.yAxisZoomHandler.setViewport(evt.yMin, evt.yMax);
                }
            }
            this.buildAndDraw(Boolean.TRUE, null, null);
        } else {
            super.viewportChanged(evt);
        }
    }

    @Override
    public boolean createDataDialog(Object listener) {
        if (this.dataDlg != null) {
            return true;
        }
        Window parent = null;
        if (listener != null && listener instanceof Component) {
            parent = SwingUtilities.getWindowAncestor(this);
        }
        if (parent == null || parent instanceof Frame) {
            this.dataDlg = new DataOptionsDialog((Frame)parent);
        } else if (parent instanceof Dialog) {
            this.dataDlg = new DataOptionsDialog((Dialog)parent);
        }
        return true;
    }

    @Override
    protected String getMenuXMLPath() {
        if (this.primary != null && this.primary.getMenuXML() != null) {
            return this.primary.getMenuXML();
        }
        return super.getMenuXMLPath();
    }

    @Override
    protected int[] drawGridLines(AxisInterface axis, Graphics g, int whichAxis) {
        int[] rc = super.drawGridLines(axis, g, whichAxis);
        int id = -1;
        switch (whichAxis) {
            case 0: {
                id = 19074;
                break;
            }
            case 3: {
                id = 19076;
                break;
            }
            case 1: {
                id = 19075;
                break;
            }
            case 4: {
                id = 19077;
            }
        }
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            chart.setPropertyValue(id, rc);
        }
        return rc;
    }

    public boolean isCycleAttrs() {
        return this.cycleAttrs;
    }

    public void setCycleAttrs(boolean cycleAttrs) {
        this.cycleAttrs = cycleAttrs;
        this.doCycleAttrs();
    }

    public void setCreateOverlayLegend(boolean createOverlayLegend) {
        this.createOverlayLegend = createOverlayLegend;
    }

    public TransformInterface getTransform(BaseElement element) {
        if (element == null) {
            return null;
        }
        Integer x = new Integer(element.getXAxisMapping());
        Integer y = new Integer(element.getYAxisMapping());
        return this.getTransform(x, y);
    }

    @Override
    public boolean setViewport(int type, int dimension, double min, double max) {
        if (this.brush != null) {
            this.brush.invalidateBrush();
        }
        return super.setViewport(type, dimension, min, max);
    }

    @Override
    public void setSelectOnDrilldown(boolean selectOnDrilldown) {
        super.setSelectOnDrilldown(selectOnDrilldown);
        if (this.brush != null) {
            this.brush.setSelectOnDrilldown(selectOnDrilldown);
        }
    }
}

