/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.UniqueValueInterface;
import com.sas.graphics.silk.base.AbstractBarElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.CollectionSorter;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.RangeMerger;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.DefaultStatistics;
import com.sas.graphics.util.RangeInfoModel;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

public class BarNonParmElement
extends AbstractBarElement {
    public static final int[] supportedBarElementProperties = new int[]{818, 830, 831, 832, 833, 834, 835};
    protected static ResourceBundle rbUI = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected static SILKNumber statName_Frequency = new SILKNumber(0, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Frequency.txt", (String)"Frequency"), "Frequency");
    protected static SILKNumber statName_Percent = new SILKNumber(1, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Percent.txt", (String)"Percent"), "Percent");
    protected static SILKNumber statName_Sum = new SILKNumber(2, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Sum.txt", (String)"Sum"), "Sum");
    protected static SILKNumber statName_Mean = new SILKNumber(3, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Mean.txt", (String)"Mean"), "Mean");
    protected SILKNumber frequencyRole = null;
    protected SILKNumber statTypeRole = null;
    protected double respMin = Double.NaN;
    protected double respMax = Double.NaN;
    public static final int PERCENT_THRESHOLD = 0;
    public static final int MAX_BAR_THRESHOLD = 1;
    public static final int RESPONSE_THRESHOLD = 2;
    private int otherThresholdType = 0;
    private int maxBarThresholdValue;
    private double percentThresholdValue;
    private double responseThresholdValue;
    private double otherPosLabelPosition;
    private double otherNegLabelPosition;
    private boolean otherBarCalculated = false;
    private boolean disableOtherBar = false;

    public BarNonParmElement() {
        this.setChartType(3);
        this.frequencyRole = this.role.getRoleObject("ROLE_FREQUENCY");
        this.roles.newRole((Object)this.frequencyRole, "Frequency", 1);
        this.roles.setRoleType((Object)this.frequencyRole, 1);
        this.statTypeRole = this.role.getRoleObject("ROLE_STATISTIC_TYPE");
        this.setSupportedProperties(supportedBarElementProperties);
        this.userSetProperties.appendProperties(supportedBarElementProperties);
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (role == null || variableId == null) {
            return false;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            int currStatType = DefaultStatistics.getStatisticIndex((Object)variableId);
            if (currStatType == this.statType) {
                return true;
            }
            this.setStatistic(variableId);
            this.persistSortOrder();
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            this.fireLayerListenerChanged(7);
            this.fireLayerListenerChanged(3);
            return true;
        }
        return super.addRole(variableId, role);
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        boolean b = super.applyWhereClause(clause, clearPrevious);
        this.findStatusOfStatOnAxis();
        if (this.showOtherBar) {
            this.calculateOhterBar();
        }
        this.fireLayerListenerChanged(7);
        return b;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 3: {
                this.clearResponseRange();
            }
        }
        super.dataFilterChanged(evt);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public Object getAllVariables(Object role) {
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            return this.getStatistic();
        }
        return super.getAllVariables(role);
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (which == null) {
            return null;
        }
        Object role = null;
        if (Extract.getNumberItems((Object)which, (int)Extract.getSourceType((Object)which)) > 0) {
            role = Extract.getObject((Object)which, (int)0, (int)Extract.getSourceType((Object)which));
        }
        if (role == null) {
            return null;
        }
        if (this.tuple != null && (role != null && role.equals("Response") || role.equals(RoleInterface.ROLE_RESPONSE))) {
            double max = 0.0;
            double min = 0.0;
            if (Double.isNaN(this.respMin) || Double.isNaN(this.respMax)) {
                Object[] summaryVarVals;
                Object[] tupleArray = this.tuple.toArray();
                LinkedHashMap<Integer, Double> respList = new LinkedHashMap<Integer, Double>();
                if (this.allowMultiResponse && this.numberOfResponse > 1) {
                    Object[] respValuesArray;
                    Object[] objectArray = respValuesArray = this.responseLink != null ? this.responseLink.values().toArray() : null;
                    if (respValuesArray == null) {
                        for (int i = 0; i < tupleArray.length; ++i) {
                            double val;
                            Object valObj;
                            summaryVarVals = (Object[])tupleArray[i];
                            int catValue = this.categoryMapper.getIndex(((Object[])tupleArray[i])[0]);
                            double respval = this.getResponseValues(this.summaryVars, null, this.frequencyVar, summaryVarVals, this.statType);
                            double d = respval = this.isAbsolute() ? Math.abs(respval) : respval;
                            if (Double.isNaN(respval)) continue;
                            max = Math.max(max, respval);
                            min = Math.min(min, respval);
                            if (this.errorLowList != null && (valObj = this.errorLowList.get(new Integer(catValue))) != null && !Double.isNaN(val = ((Number)valObj).doubleValue())) {
                                min = Math.min(min, respval - val);
                            }
                            if (this.errorHighList == null || (valObj = this.errorHighList.get(new Integer(catValue))) == null || Double.isNaN(val = ((Number)valObj).doubleValue())) continue;
                            max = Math.max(max, respval + val);
                        }
                    } else {
                        for (int i = 0; i < tupleArray.length; ++i) {
                            summaryVarVals = (Object[])tupleArray[i];
                            int catValue = this.categoryMapper.getIndex(((Object[])tupleArray[i])[0]);
                            for (int j = 0; j < respValuesArray.length; ++j) {
                                double val;
                                Object valObj;
                                this.respVar = respValuesArray[j];
                                double respval = this.getResponseValues(this.summaryVars, this.respVar, this.frequencyVar, summaryVarVals, this.statType);
                                double d = respval = this.isAbsolute() ? Math.abs(respval) : respval;
                                if (Double.isNaN(respval)) continue;
                                if (this.errorLowList != null && (valObj = this.errorLowList.get(new Integer(catValue))) != null && !Double.isNaN(val = ((Number)valObj).doubleValue())) {
                                    min = Math.min(min, respval - val);
                                }
                                if (this.errorHighList != null && (valObj = this.errorHighList.get(new Integer(catValue))) != null && !Double.isNaN(val = ((Number)valObj).doubleValue())) {
                                    max = Math.max(max, respval + val);
                                }
                                max = Math.max(max, respval);
                                min = Math.min(min, respval);
                            }
                        }
                    }
                } else {
                    int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
                    for (int i = 0; i < tupleArray.length; ++i) {
                        double val;
                        Object valObj;
                        summaryVarVals = (Object[])tupleArray[i];
                        int catValue = this.categoryMapper.getIndex(((Object[])tupleArray[i])[0]);
                        double respval = this.getResponseValues(this.summaryVars, this.respVar, this.frequencyVar, summaryVarVals, this.statType);
                        double d = respval = this.isAbsolute() ? Math.abs(respval) : respval;
                        if (Double.isNaN(respval)) continue;
                        if (grpVarIndex > -1 && this.groupDisplayType == 0) {
                            double val2;
                            int catKey;
                            Object tmpVal;
                            if (respval >= 0.0) {
                                double dVal = 0.0;
                                dVal = respval;
                                tmpVal = null;
                                catKey = catValue + 1;
                                if (respList.containsKey(new Integer(catKey)) && (tmpVal = respList.get(new Integer(catKey))) != null) {
                                    val2 = ((Number)tmpVal).doubleValue();
                                    dVal += val2;
                                }
                                respList.put(new Integer(catKey), new Double(dVal));
                                respval = dVal;
                            } else {
                                double dVal = 0.0;
                                dVal = respval;
                                tmpVal = null;
                                catKey = catValue + 1;
                                if (respList.containsKey(new Integer(catKey = -catKey)) && (tmpVal = respList.get(new Integer(catKey))) != null) {
                                    val2 = ((Number)tmpVal).doubleValue();
                                    dVal += val2;
                                }
                                respList.put(new Integer(catKey), new Double(dVal));
                                respval = dVal;
                            }
                        }
                        if (this.errorLowList != null && (valObj = this.errorLowList.get(new Integer(catValue))) != null && !Double.isNaN(val = ((Number)valObj).doubleValue())) {
                            min = Math.min(min, respval - val);
                        }
                        if (this.errorHighList != null && (valObj = this.errorHighList.get(new Integer(catValue))) != null && !Double.isNaN(val = ((Number)valObj).doubleValue())) {
                            max = Math.max(max, respval + val);
                        }
                        max = Math.max(max, respval);
                        min = Math.min(min, respval);
                    }
                }
                this.respMax = max;
            } else {
                min = this.respMin;
                max = this.respMax;
            }
            boolean bl = this.negResp = min < 0.0;
            if (this.showOtherBar) {
                max = Math.max(max, this.otherPosRespValue);
                min = Math.min(min, this.otherNegRespValue);
            }
            ContinuousRange cr = new ContinuousRange(min, max);
            return cr;
        }
        if (this.tuple != null && (role != null && role.equals("Category") || role.equals(RoleInterface.ROLE_CATEGORY)) && (this.responseSortType == RoleInterface.ROLE_SORT_ASCENDING || this.responseSortType == RoleInterface.ROLE_SORT_DESCENDING)) {
            return new DiscreteRange(this.categoryMapper.getValues());
        }
        DataRange dr = this.showOtherBar && this.otherCatList != null ? this.getPreferredRangeForOther(which) : super.getPreferredRange(which);
        return dr;
    }

    public DataRange getPreferredRangeForOther(Object which) {
        if (this.filter == null) {
            return null;
        }
        OrdinalRange rc = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        while (rolesEnum.hasMoreElements()) {
            Object role = rolesEnum.nextElement();
            Object vars = this.roles.getAllVariables(role);
            DataFilterReadInterface dfri = this.filters.getDataFilter(this.roles.getDataID(role));
            if (dfri == null) {
                dfri = this.filter;
            }
            Enumeration e = Extract.elements((Object)vars);
            while (e.hasMoreElements()) {
                int i;
                Object var = e.nextElement();
                int varIndex = dfri.getVariableIndex(var);
                if (dfri.isNumericVariable(var) && this.roles.isDiscrete(role)) {
                    RangeInfoModel rangeInfoModel = (RangeInfoModel)dfri.getAdapter(RangeInfoModel.class);
                    if (rangeInfoModel != null) {
                        rangeInfoModel.invalidate();
                        OrdinalRange or = rc = rangeInfoModel.getOrdinalRange(var, this.isMissingDiscreteIncluded());
                        Vector values = or.getValues();
                        if (this.otherCatList.size() <= 0) continue;
                        values.removeAll(this.otherCatList);
                        values.add(this.OTHER_CATEGORY);
                        ArrayList keys = new ArrayList();
                        Map map = or.getMap();
                        Iterator iter = map.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry entry;
                            Map.Entry e1 = entry = iter.next();
                            Object keyObj = e1.getKey();
                            Object valObj = e1.getValue();
                            if (!this.otherCatList.contains(valObj)) continue;
                            keys.add(keyObj);
                        }
                        for (i = 0; i < keys.size(); ++i) {
                            map.remove(keys.get(i));
                        }
                        map.put(Double.MAX_VALUE, this.OTHER_CATEGORY);
                        or.setValuePosition(this.OTHER_CATEGORY, 2);
                        continue;
                    }
                    LinkedHashMap<Object, Object> unformatted = new LinkedHashMap<Object, Object>();
                    for (int i2 = 0; i2 < dfri.getNumberObservations(-1); ++i2) {
                        String f;
                        Object d = dfri.getValue(varIndex, (long)i2);
                        if (!this.isMissingDiscreteIncluded() && dfri.isMissing(varIndex, d) || unformatted.containsKey(f = dfri.getFormattedValue(var, (long)i2, null)) || this.otherCatList.contains(String.valueOf(f))) continue;
                        unformatted.put(f, d);
                    }
                    if (this.otherCatList != null && this.otherCatList.size() > 0) {
                        unformatted.put(Double.MAX_VALUE, this.OTHER_CATEGORY);
                    }
                    Object[] fvalues = unformatted.values().toArray();
                    Object[] uvalues = unformatted.keySet().toArray();
                    OrdinalRange or = new OrdinalRange(uvalues, fvalues);
                    or.setValuePosition(this.OTHER_CATEGORY, 2);
                    rc = RangeMerger.mergeRange((DataRange)rc, (DataRange)or);
                    continue;
                }
                DiscreteRange dr = null;
                Object[] list = null;
                if (dfri.getAdapter(UniqueValueInterface.class) != null) {
                    UniqueValueInterface uvi = (UniqueValueInterface)dfri.getAdapter(UniqueValueInterface.class);
                    list = uvi.getUniqueValues(var, true, Integer.MAX_VALUE, this.isMissingDiscreteIncluded());
                    if (list != null) {
                        Object[] temp = list;
                        for (int i3 = 0; i3 < list.length; ++i3) {
                            if (!this.otherCatList.contains(list[i3])) continue;
                            temp[i3] = null;
                        }
                        list = temp;
                    }
                } else {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    for (int i4 = 0; i4 < dfri.getNumberObservations(-1); ++i4) {
                        String value = dfri.getFormattedValue(var, (long)i4, null);
                        if (map.containsKey(value) || this.otherCatList.contains(value)) continue;
                        map.put(value, value);
                    }
                    list = map.keySet().toArray();
                }
                if (list == null) continue;
                ArrayList<Object> otherList = new ArrayList<Object>();
                for (int i5 = 0; i5 < list.length; ++i5) {
                    if (list[i5] == null) continue;
                    otherList.add(list[i5]);
                }
                Object o = this.roles.getSortOrder(role);
                Object[] array = otherList.toArray();
                Object[] otherArray = new Object[array.length + 1];
                if (o instanceof Number) {
                    array = this.sortList(array, ((Number)o).intValue());
                    for (i = 0; i < array.length; ++i) {
                        otherArray[i] = array[i];
                    }
                    if (this.otherCatList.size() > 0 && list.length > 0) {
                        otherArray[array.length] = this.OTHER_CATEGORY;
                    }
                }
                dr = new DiscreteRange(otherArray);
                dr.setValuePosition(this.OTHER_CATEGORY, 2);
                if (o instanceof Number) {
                    dr.setSort(((Number)o).intValue());
                }
                rc = RangeMerger.mergeRange((DataRange)rc, (DataRange)dr);
            }
        }
        return rc;
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc;
        block34: {
            block33: {
                if (this.pendingProperties.isPending(id)) {
                    return this.pendingProperties.getValueById(id);
                }
                rc = null;
                if (this.getOrientation() != 0) break block33;
                switch (id) {
                    case 19054: {
                        if (this.roles.getVariable((Object)this.responseRole, 0) == null) {
                            if (this.statType == 11) {
                                rc = this.defaults.defaultNumericFormat;
                                break;
                            }
                            rc = SASFormat.getInstance((String)"F2.0");
                            break;
                        }
                        Object var = this.roles.getVariable((Object)this.responseRole, 0);
                        if (var != null && this.filter != null) {
                            rc = this.filter.getFormat(var, SASFormat.class);
                            break;
                        }
                        break block34;
                    }
                    case 19056: {
                        rc = new Object[]{RoleInterface.ROLE_RESPONSE};
                        break;
                    }
                    case 19057: {
                        rc = new Object[]{RoleInterface.ROLE_CATEGORY};
                        break;
                    }
                    case 19052: {
                        rc = this.setResponseAxesLabels();
                        break;
                    }
                    case 19061: {
                        rc = Boolean.FALSE;
                        break;
                    }
                    case 19059: {
                        rc = Boolean.FALSE;
                        break;
                    }
                    default: {
                        rc = super.getPropertyValue(id);
                        break;
                    }
                }
                break block34;
            }
            if (this.getOrientation() == 1) {
                switch (id) {
                    case 19055: {
                        if (this.roles.getVariable((Object)this.responseRole, 0) == null) {
                            if (this.statType == 11) {
                                rc = this.defaults.defaultNumericFormat;
                                break;
                            }
                            rc = SASFormat.getInstance((String)"F2.0");
                            break;
                        }
                        Object var = this.roles.getVariable((Object)this.responseRole, 0);
                        if (var == null || this.filter == null) break;
                        rc = this.filter.getFormat(var, SASFormat.class);
                        break;
                    }
                    case 19056: {
                        rc = new Object[]{RoleInterface.ROLE_CATEGORY};
                        break;
                    }
                    case 19057: {
                        rc = new Object[]{RoleInterface.ROLE_RESPONSE};
                        break;
                    }
                    case 19053: {
                        rc = this.setResponseAxesLabels();
                        break;
                    }
                    case 19065: {
                        rc = Boolean.FALSE;
                        break;
                    }
                    case 19064: {
                        rc = Boolean.TRUE;
                        break;
                    }
                    case 19060: {
                        rc = Boolean.FALSE;
                        break;
                    }
                    case 19058: {
                        rc = Boolean.FALSE;
                        break;
                    }
                    default: {
                        rc = super.getPropertyValue(id);
                    }
                }
            }
        }
        switch (id) {
            case 818: {
                rc = new Integer(this.responseStatDisplay);
                break;
            }
            case 830: {
                rc = this.showOtherBar;
                break;
            }
            case 831: {
                rc = this.getOtherThresholdType();
                break;
            }
            case 832: {
                rc = this.getMaxBarThresholdValue();
                break;
            }
            case 833: {
                rc = this.getPercentThresholdValue();
                break;
            }
            case 835: {
                rc = this.disableOtherBar;
            }
        }
        return rc;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        switch (id) {
            case 832: {
                if (!(value instanceof Number)) break;
                this.setMaxBarThresholdValue((Integer)value);
                break;
            }
            case 833: {
                if (!(value instanceof Number)) break;
                this.setPercentThresholdValue((Double)value);
                break;
            }
            case 830: {
                if (!(value instanceof Boolean)) break;
                this.showOtherBar = (Boolean)value;
                break;
            }
            case 834: {
                if (!(value instanceof Number)) break;
                this.responseThresholdValue = (Double)value;
                break;
            }
            case 831: {
                if (!(value instanceof Number)) break;
                this.setOtherThresholdType(((Number)value).intValue());
                break;
            }
            case 835: {
                if (!(value instanceof Boolean)) break;
                this.disableOtherBar = (Boolean)value;
                break;
            }
        }
        return super.setPropertyValue(id, value);
    }

    public int getResponseStatDisplay() {
        return this.responseStatDisplay;
    }

    @Override
    public void getSortedCategories() {
        Object[] catArray = this.categoryList.keySet().toArray();
        ArrayList responseValsList = new ArrayList();
        this.buildResponseValuesList(catArray, responseValsList);
        switch (this.sortOrder) {
            case 1: {
                this.sortCategoriesOnResponse(catArray, responseValsList, -1);
                break;
            }
            default: {
                this.sortCategoriesOnResponse(catArray, responseValsList, 1);
            }
        }
    }

    public Object getStatistic() {
        SILKNumber rc = null;
        Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
        switch (this.statType) {
            case 1: {
                rc = statName_Sum;
                break;
            }
            case 2: {
                rc = statName_Mean;
                break;
            }
            case 11: {
                rc = statName_Percent;
                break;
            }
            case 12: {
                rc = statName_Frequency;
                break;
            }
            default: {
                rc = respVar == null ? statName_Frequency : statName_Sum;
            }
        }
        return rc;
    }

    @Override
    protected String getToolTiptext(Object obj, int catValue, int j, double respValue, Object grpValue) {
        String str;
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rbBar, (String)"Bar.Probe.fmt.txt", (String)"{0} : {1}"));
        Object catVar = this.roles.getVariable((Object)this.categoryRole, 0);
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        String xstr = probeMessage.toString(this.filter.getVariableDescription(catVar), obj);
        Object format = this.filter.getFormat(this.roles.getVariable((Object)this.responseRole, j), SASFormat.class);
        Object yVar = this.roles.getVariable((Object)this.responseRole, j);
        if (yVar == null) {
            if (this.statType == 11) {
                yVar = statName_Percent;
                format = SASFormat.getInstance((String)"Percent8.2");
                respValue /= 100.0;
            } else {
                yVar = statName_Frequency;
                format = SASFormat.getInstance((String)"Best8.0");
            }
        } else {
            yVar = this.filter.getVariableDescription(yVar);
            if (this.showStatOnAxis) {
                String suffixStr = this.statType == 1 ? statName_Sum.toString() : statName_Mean.toString();
                yVar = yVar.toString() + "(" + suffixStr + ")";
            }
            format = this.filter.getFormat(this.roles.getVariable((Object)this.responseRole, 0), SASFormat.class);
        }
        String yValStr = this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, j), (Object)new Double(respValue), format);
        String ystr = "\n" + probeMessage.toString((Object)(this.userComputedResponseLabel == null ? yVar.toString() : this.userComputedResponseLabel), (Object)yValStr);
        if (grpVarIndex > -1) {
            Object grpVar = this.roles.getVariable((Object)this.groupRole, 0);
            String grpstr = "\n" + probeMessage.toString(this.filter.getVariableDescription(grpVar), grpValue);
            str = xstr + ystr + grpstr;
        } else {
            str = xstr + ystr;
        }
        int tipIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.tipRole, 0));
        if (tipIndex > -1) {
            String tipstr = null;
            String catObj = null;
            String grpObj = null;
            boolean found = false;
            boolean groupMatch = true;
            for (int k = 0; k < this.filter.getNumberObservations(-1) && !found; ++k) {
                catObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.categoryRole, 0), (long)k, null);
                groupMatch = true;
                if (grpVarIndex > -1) {
                    grpObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)k, null);
                    groupMatch = grpObj.equals(grpValue);
                }
                if (!catObj.equals(obj) || !groupMatch) continue;
                found = true;
                format = this.filter.getFormat(this.roles.getVariable((Object)this.tipRole, 0), SASFormat.class);
                String tipValStr = this.filter.getFormattedValue(this.roles.getVariable((Object)this.tipRole, 0), this.filter.getValue(tipIndex, (long)k), format);
                tipstr = "\n" + probeMessage.toString(this.filter.getVariableDescription(this.roles.getVariable((Object)this.tipRole, 0)), (Object)tipValStr);
                str = str + tipstr;
            }
        }
        str = str.replaceAll("=", "\t=\t");
        str = str.replaceAll("\\[", "\t \t\\[");
        return str;
    }

    @Override
    public Object getVariable(Object role) {
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            return this.getStatistic();
        }
        return super.getVariable(role);
    }

    public double negativeBarSelectionFrequency(Object[] summaryVars, Object object, Object frequencyVar1, Object[] summaryVarVals, int i) {
        double freq = 0.0;
        freq = this.defaultStatistics.getSummaryStatistic(summaryVars, object, frequencyVar1, summaryVarVals, i);
        freq = this.isAbsolute() ? Math.abs(freq) : freq;
        return freq;
    }

    public double negativeBarSelectionSum(Object[] summaryVars, Object object, Object frequencyVar1, Object[] summaryVarVals, int statType) {
        double sum = 0.0;
        sum = this.defaultStatistics.getSummaryStatistic(summaryVars, object, frequencyVar1, summaryVarVals, statType);
        sum = this.isAbsolute() ? Math.abs(sum) : sum;
        return sum;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        switch (e.role) {
            case 1: 
            case 17: 
            case 70: {
                this.clearResponseRange();
                Object o = this.roles.getVariable((Object)this.categoryRole, 0);
                if (!this.showOtherBar || o == null) break;
                this.otherPosRespValue = 0.0;
                this.otherNegRespValue = 0.0;
                this.calculateOhterBar();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 38: {
                this.clearResponseRange();
                this.setOtherBarEnabled();
            }
        }
        super.roleChanged(e);
    }

    @Override
    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
        this.respMin = Double.NaN;
        this.respMax = Double.NaN;
        this.fireLayerListenerChanged(5);
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        this.fireLayerListenerChanged(7);
        this.fireLayerListenerChanged(3);
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        if (this.defaultStatistics != null) {
            this.defaultStatistics.clearAllStatistics();
            this.defaultStatistics = null;
        }
        return super.setDataSource(source, id);
    }

    public void setResponseStatDisplay(int responseStatDisplay) {
        this.responseStatDisplay = responseStatDisplay;
        this.findStatusOfStatOnAxis();
        this.userSetProperties.set(818);
        this.fireLayerListenerChanged(7);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (role == null || variableId == null) {
            return false;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            int currStatType = DefaultStatistics.getStatisticIndex((Object)variableId);
            if (currStatType == this.statType) {
                return true;
            }
            this.setStatistic(variableId);
            this.persistSortOrder();
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            this.fireLayerListenerChanged(7);
            this.fireLayerListenerChanged(3);
            return true;
        }
        return super.setRole(variableId, role);
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 818: {
                if (!(value instanceof Number)) break;
                this.setResponseStatDisplay(((Number)value).intValue());
                this.userSetProperties.set(818);
                break;
            }
            case 830: {
                if (!(value instanceof Boolean)) break;
                this.setShowOtherBar((Boolean)value);
                if (!this.showOtherBar) {
                    this.otherCatList.clear();
                    this.otherPosCatList.clear();
                    this.otherNegCatList.clear();
                    this.setRoleCategoryEnum();
                    this.createCategoryList();
                    int respVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.responseRole, 0));
                    if (respVarIndex > -1) {
                        this.setRoleResponseEnum();
                    }
                    this.buildRenderingData();
                    RangeInfoModel rangeInfoModel = (RangeInfoModel)this.filter.getAdapter(RangeInfoModel.class);
                    rangeInfoModel.invalidate();
                    this.fireLayerListenerChanged(7);
                    break;
                }
                this.calculateOhterBar();
                break;
            }
            case 831: {
                if (!(value instanceof Number)) break;
                this.setOtherThresholdType(((Number)value).intValue());
                break;
            }
            case 832: {
                if (!this.showOtherBar || this.otherThresholdType != 1) break;
                this.calculateOhterBar();
                this.fireLayerListenerChanged(7);
                break;
            }
            case 833: {
                if (!this.showOtherBar || this.otherThresholdType != 0) break;
                this.calculateOhterBar();
                this.fireLayerListenerChanged(7);
                break;
            }
            case 834: {
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    private void calculateOhterBar() {
        if (!this.showOtherBar) {
            return;
        }
        this.otherCatList.clear();
        this.otherPosCatList.clear();
        this.otherNegCatList.clear();
        this.otherPosRespValue = 0.0;
        this.otherNegRespValue = 0.0;
        this.setRoleCategoryEnum();
        this.createCategoryList();
        int respVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.responseRole, 0));
        if (respVarIndex > -1) {
            this.setRoleResponseEnum();
        }
        this.buildRenderingData();
        switch (this.otherThresholdType) {
            case 0: {
                this.calculatePercentThreshold();
                break;
            }
            case 1: {
                this.calculateMaxBarThreshold();
                break;
            }
        }
    }

    private void calculateMaxBarThreshold() {
        Object[] catArray = this.categoryMapper.getValues();
        LinkedHashMap responseToCatMap = new LinkedHashMap();
        double resp = 0.0;
        ArrayList<Double> respList = new ArrayList<Double>();
        this.otherPosRespValue = 0.0;
        this.otherNegRespValue = 0.0;
        for (int i = 0; i < catArray.length; ++i) {
            ArrayList responseList = (ArrayList)this.renderingData.get(catArray[i]);
            if (responseList == null) continue;
            Object[] respArray = (Object[])responseList.get(0);
            Double val = (Double)respArray[0];
            if (Double.isNaN(val)) {
                val = 0.0;
            }
            if (val != null) {
                resp = val;
            }
            double d = resp = this.isAbsolute() ? Math.abs(resp) : resp;
            if (!respList.contains(resp)) {
                respList.add(resp);
            }
            if (responseToCatMap.containsKey(resp)) {
                ArrayList categories = (ArrayList)responseToCatMap.get(resp);
                categories.add(catArray[i]);
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(catArray[i]);
            responseToCatMap.put(resp, list);
        }
        Collections.sort(respList);
        int maxBars = this.numberOfBars;
        for (int i = 0; i < respList.size() && this.numberOfBars != this.maxBarThresholdValue && maxBars > this.maxBarThresholdValue - 1; ++i) {
            Double response = (Double)respList.get(i);
            ArrayList cats = (ArrayList)responseToCatMap.get(response);
            for (int j = 0; j < cats.size(); ++j) {
                this.otherCatList.add(cats.get(j));
                if (response > 0.0) {
                    this.otherPosCatList.add(cats.get(j));
                    this.otherPosRespValue += response.doubleValue();
                } else {
                    this.otherNegCatList.add(cats.get(j));
                    this.otherNegRespValue += response.doubleValue();
                }
                --maxBars;
            }
        }
        if (this.otherCatList.size() > 0) {
            Object[] values = this.categoryMapper.getValues();
            this.categoryMapper.removeAllValues();
            for (int i = 0; i < values.length; ++i) {
                if (this.otherCatList.contains(values[i])) continue;
                this.categoryMapper.addValue(values[i]);
            }
            this.categoryMapper.addValue(this.OTHER_CATEGORY);
            this.createCategoryList();
            this.numberOfBars = this.categoryMapper.getNumberValues();
            this.displayBarEnd = this.maxBarThresholdValue;
            LinkedHashMap<Integer, Object> grpList = new LinkedHashMap<Integer, Object>();
            grpList.put(new Integer(0), null);
            this.categoryList.put(this.OTHER_CATEGORY, grpList);
            if (this.isCurrentSortTypeOnCategory()) {
                this.setCategorySortOrder();
            } else {
                this.setResponseSortOrder();
            }
        }
        this.fireLayerListenerChanged(7);
        this.fireLayerListenerChanged(5);
    }

    private void calculatePercentThreshold() {
        Object[] catArray = this.categoryMapper.getValues();
        LinkedHashMap<Object, Double> catToResponseMap = new LinkedHashMap<Object, Double>();
        double resp = 0.0;
        ArrayList respList = new ArrayList();
        this.otherPosRespValue = 0.0;
        this.otherNegRespValue = 0.0;
        double totalResponse = 0.0;
        if (catArray == null) {
            return;
        }
        for (int i = 0; i < catArray.length; ++i) {
            ArrayList responseList = (ArrayList)this.renderingData.get(catArray[i]);
            if (responseList == null) continue;
            Object[] respArray = (Object[])responseList.get(0);
            Double val = (Double)respArray[0];
            if (Double.isNaN(val)) {
                val = 0.0;
            }
            if (val != null) {
                resp = val;
            }
            totalResponse += Math.abs(resp);
            catToResponseMap.put(catArray[i], resp);
        }
        int respVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.responseRole, 0));
        if (respVarIndex == -1 && this.getStatistic().equals((Object)statName_Percent)) {
            Set keySet = catToResponseMap.keySet();
            for (Object catValue : keySet) {
                Double percent = (Double)catToResponseMap.get(catValue);
                if (!(percent < this.percentThresholdValue * 100.0)) continue;
                this.otherCatList.add(catValue);
                this.otherPosCatList.add(catValue);
                this.otherPosRespValue += percent.doubleValue();
            }
        } else {
            LinkedHashMap<Object, Double> catToPercentMap = new LinkedHashMap<Object, Double>();
            for (int i = 0; i < catArray.length; ++i) {
                ArrayList responseList = (ArrayList)this.renderingData.get(catArray[i]);
                if (responseList == null) continue;
                Object[] respArray = (Object[])responseList.get(0);
                Double val = (Double)respArray[0];
                if (Double.isNaN(val)) {
                    val = 0.0;
                }
                if (val != null) {
                    resp = val;
                }
                double percent = this.isAbsolute() ? Math.abs(resp) / totalResponse * 100.0 : resp / totalResponse * 100.0;
                catToPercentMap.put(catArray[i], percent);
            }
            Set keySet = catToPercentMap.keySet();
            for (Object catValue : keySet) {
                Double percent = (Double)catToPercentMap.get(catValue);
                if (!(percent < this.percentThresholdValue * 100.0)) continue;
                this.otherCatList.add(catValue);
                Double respVal = (Double)catToResponseMap.get(catValue);
                if (respVal > 0.0) {
                    this.otherPosRespValue += respVal.doubleValue();
                    this.otherPosCatList.add(catValue);
                    continue;
                }
                this.otherNegRespValue += respVal.doubleValue();
                this.otherNegCatList.add(catValue);
            }
        }
        if (this.otherCatList.size() > 0) {
            Object[] values = this.categoryMapper.getValues();
            this.categoryMapper.removeAllValues();
            for (int i = 0; i < values.length; ++i) {
                if (this.otherCatList.contains(values[i])) continue;
                this.categoryMapper.addValue(values[i]);
            }
            this.categoryMapper.addValue(this.OTHER_CATEGORY);
            this.createCategoryList();
            this.numberOfBars = this.categoryMapper.getNumberValues();
            this.setDisplayBarRange(1, this.numberOfBars);
            LinkedHashMap<Integer, Object> grpList = new LinkedHashMap<Integer, Object>();
            grpList.put(new Integer(0), null);
            this.categoryList.put(this.OTHER_CATEGORY, grpList);
            if (this.isCurrentSortTypeOnCategory()) {
                this.setCategorySortOrder();
            } else {
                this.setResponseSortOrder();
            }
        }
        this.fireLayerListenerChanged(7);
        this.fireLayerListenerChanged(5);
    }

    @Override
    protected Object[] getUniqueCategoryValues(boolean useSubset) {
        Object[] uniqueCatVals = null;
        UniqueValueInterface uvi = null;
        Object o = this.filter.getAdapter(UniqueValueInterface.class);
        if (o instanceof UniqueValueInterface) {
            uvi = (UniqueValueInterface)o;
        }
        uniqueCatVals = uvi != null ? uvi.getUniqueValues(this.roles.getVariable((Object)this.categoryRole, 0), useSubset, Integer.MAX_VALUE, this.isMissingDiscreteIncluded()) : ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.categoryRole, 0), useSubset);
        if (this.showOtherBar) {
            Object[] catVals = uniqueCatVals;
            for (int i = 0; i < uniqueCatVals.length; ++i) {
                if (!this.otherCatList.contains(uniqueCatVals[i])) continue;
                catVals[i] = null;
            }
            uniqueCatVals = catVals;
        }
        return uniqueCatVals;
    }

    @Override
    protected void buildResponseValuesList(Object[] catArray, ArrayList responseValsList) {
        Object[] summaryVarVals = new Object[2];
        for (int i = 0; i < catArray.length; ++i) {
            summaryVarVals[0] = catArray[i];
            double respValue = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, this.frequencyVar, summaryVarVals, this.statType);
            double d = respValue = this.isAbsoluteSort() ? Math.abs(respValue) : respValue;
            if (Double.isNaN(respValue)) {
                respValue = this.showOtherBar ? (this.responseSortType == RoleInterface.ROLE_SORT_ASCENDING ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : Double.NEGATIVE_INFINITY;
            }
            responseValsList.add(new Double(respValue));
        }
    }

    protected void clearResponseRange() {
        this.respMin = Double.NaN;
        this.respMax = Double.NaN;
    }

    @Override
    protected void drawLabels(Graphics g) {
        if (this.labelList != null && this.labelList.size() > 0) {
            double[] projectValues = new double[3];
            double barWidth = this.fullBarWidth;
            if (this.categoryMapper != null) {
                boolean v1 = false;
                boolean v2 = true;
                if (this.categoryMapper.getNumberValues() == 1) {
                    v2 = v1;
                }
                barWidth = this.isVerticalBar ? (double)this.getScreenSpacing((byte)1, (double)v1, (double)v2) : (double)this.getScreenSpacing((byte)2, (double)v1, (double)v2);
            }
            int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
            if (this.allowMultiResponse && grpVarIndex == -1 && this.numberOfResponse > 1) {
                barWidth /= (double)(this.numberOfResponse + 1);
            }
            Object[] keyArray = this.labelList.keySet().toArray();
            Object[] valArray = this.labelList.values().toArray();
            FontRenderContext frc = new FontRenderContext(null, true, true);
            double catKey = 0.0;
            float yPos = 0.0f;
            float xPos = 0.0f;
            TextStyleElement tse = this.style.getTextStyleElement("ValueText");
            for (int i = 0; i < keyArray.length; ++i) {
                TextLayout txtStr;
                catKey = ((Number)keyArray[i]).doubleValue();
                double respLableVal = ((double[])valArray[i])[0];
                double temp = ((double[])valArray[i])[1];
                double negRespLabelVal = 0.0;
                if (temp < 0.0) {
                    negRespLabelVal = temp;
                }
                if (this.isVerticalBar) {
                    projectValues = this.transformObject.project(0.0, respLableVal, 0.0, projectValues);
                    projectValues[0] = catKey;
                } else {
                    projectValues = this.transformObject.project(respLableVal, 0.0, 0.0, projectValues);
                    projectValues[1] = catKey;
                }
                g.setColor(tse.getTextColor());
                String label = this.getFormattedLabel(respLableVal);
                if (label != null && respLableVal != 0.0) {
                    label = label.trim();
                    txtStr = new TextLayout(label, this.barLabelFont, frc);
                    if (this.isVerticalBar) {
                        yPos = this.transformObject.isReverse(1) ? (respLableVal < 0.0 ? (float)projectValues[1] - 2.0f : (float)projectValues[1] + txtStr.getAscent()) : (respLableVal < 0.0 ? (float)projectValues[1] + txtStr.getAscent() : (float)projectValues[1] - 2.0f);
                        txtStr.draw((Graphics2D)g, (float)projectValues[0] - (float)((int)(txtStr.getVisibleAdvance() / 2.0f)), yPos);
                    } else {
                        xPos = this.transformObject.isReverse(0) ? (respLableVal < 0.0 ? (float)(projectValues[0] + 2.0) : (float)(projectValues[0] - (double)txtStr.getVisibleAdvance())) : (respLableVal < 0.0 ? (float)(projectValues[0] - (double)txtStr.getVisibleAdvance()) : (float)(projectValues[0] + 2.0));
                        txtStr.draw((Graphics2D)g, xPos, (float)projectValues[1] + (float)((int)(txtStr.getBounds().getHeight() / 2.0)));
                    }
                }
                if (grpVarIndex <= -1 || this.groupDisplayType != 0 || !(negRespLabelVal < 0.0)) continue;
                if (this.isVerticalBar) {
                    projectValues = this.transformObject.project(0.0, negRespLabelVal, 0.0, projectValues);
                    projectValues[0] = catKey;
                } else {
                    projectValues = this.transformObject.project(negRespLabelVal, 0.0, 0.0, projectValues);
                    projectValues[1] = catKey;
                }
                g.setColor(tse.getTextColor());
                label = this.getFormattedLabel(negRespLabelVal);
                if (label == null) continue;
                label = label.trim();
                txtStr = new TextLayout(label, this.barLabelFont, frc);
                if (this.isVerticalBar) {
                    yPos = this.transformObject.isReverse(1) ? (negRespLabelVal < 0.0 ? (float)projectValues[1] - 2.0f : (float)projectValues[1] + txtStr.getAscent()) : (negRespLabelVal < 0.0 ? (float)projectValues[1] + txtStr.getAscent() : (float)projectValues[1] - 2.0f);
                    txtStr.draw((Graphics2D)g, (float)projectValues[0] - (float)((int)(txtStr.getVisibleAdvance() / 2.0f)), yPos);
                    continue;
                }
                xPos = this.transformObject.isReverse(0) ? (negRespLabelVal < 0.0 ? (float)(projectValues[0] + 2.0) : (float)(projectValues[0] - (double)txtStr.getVisibleAdvance())) : (negRespLabelVal < 0.0 ? (float)(projectValues[0] - (double)txtStr.getVisibleAdvance()) : (float)(projectValues[0] + 2.0));
                txtStr.draw((Graphics2D)g, xPos, (float)projectValues[1] + (float)((int)(txtStr.getBounds().getHeight() / 2.0)));
            }
        }
        if (this.showOtherBar) {
            if (this.otherPosRespValue > 0.0) {
                this.drawOtherBarLabel(g, this.otherPosRespValue, this.otherPosLabelPosition);
            }
            if (this.otherNegRespValue < 0.0) {
                this.drawOtherBarLabel(g, this.otherNegRespValue, this.otherNegLabelPosition);
            }
        }
    }

    protected void drawOtherBarLabel(Graphics g, double OtherLabel, double position) {
        FontRenderContext frc = new FontRenderContext(null, true, true);
        float yPos = 0.0f;
        float xPos = 0.0f;
        TextStyleElement tse = this.style.getTextStyleElement("ValueText");
        double[] projectValues = new double[3];
        if (this.isVerticalBar) {
            projectValues = this.transformObject.project(0.0, OtherLabel, 0.0, projectValues);
            projectValues[0] = position;
        } else {
            projectValues = this.transformObject.project(OtherLabel, 0.0, 0.0, projectValues);
            projectValues[1] = position;
        }
        g.setColor(tse.getTextColor());
        String label = this.getFormattedLabel(OtherLabel);
        if (label != null) {
            label = label.trim();
            TextLayout txtStr = new TextLayout(label, this.barLabelFont, frc);
            if (this.isVerticalBar) {
                yPos = this.transformObject.isReverse(1) ? (OtherLabel < 0.0 ? (float)projectValues[1] - 2.0f : (float)projectValues[1] + txtStr.getAscent()) : (OtherLabel < 0.0 ? (float)projectValues[1] + txtStr.getAscent() : (float)projectValues[1] - 2.0f);
                txtStr.draw((Graphics2D)g, (float)projectValues[0] - (float)((int)(txtStr.getVisibleAdvance() / 2.0f)), yPos);
            } else {
                xPos = this.transformObject.isReverse(0) ? (OtherLabel < 0.0 ? (float)(projectValues[0] + 2.0) : (float)(projectValues[0] - (double)txtStr.getVisibleAdvance())) : (OtherLabel < 0.0 ? (float)(projectValues[0] - (double)txtStr.getVisibleAdvance()) : (float)(projectValues[0] + 2.0));
                txtStr.draw((Graphics2D)g, xPos, (float)projectValues[1] + (float)((int)(txtStr.getBounds().getHeight() / 2.0)));
            }
        }
    }

    @Override
    protected void buildSelectionData(LinkedHashMap selectionList) {
        String catObj = null;
        Object grpObj = null;
        LinkedHashMap<String, Double> grpList = new LinkedHashMap<String, Double>();
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        Object[] summaryVarVals = grpVarIndex > -1 ? new Object[2] : new Object[1];
        while (this.selections.hasMoreSelections()) {
            double freqStat;
            double freqVal;
            double freqStat2;
            int index = this.selections.nextSelectedIndex();
            catObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.categoryRole, 0), (long)index, null);
            summaryVarVals[0] = catObj;
            if (grpVarIndex > -1) {
                summaryVarVals[1] = grpObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)index, null);
            } else {
                grpObj = "grp";
            }
            if (this.allowMultiResponse && this.numberOfResponse > 1) {
                int j;
                double[] val = new double[this.numberOfResponse];
                if (this.frequencyVar != null) {
                    double freqVal2 = (int)this.filter.getNumericValue(this.roles.getVariable((Object)this.frequencyRole, 0), (long)index);
                    if (Double.isNaN(freqVal2) || freqVal2 <= 0.0) continue;
                    for (int j2 = 0; j2 < this.numberOfResponse; ++j2) {
                        Object respVariable = this.roles.getVariable((Object)this.responseRole, j2);
                        double respVal = this.filter.getNumericValue(respVariable, (long)index);
                        if (Double.isNaN(respVal)) continue;
                        double freqStat3 = (int)this.defaultStatistics.getSummaryStatistic(this.summaryVars, null, this.frequencyVar, summaryVarVals, 12);
                        val[j2] = this.defaultStatistics.getSummaryStatistic(this.summaryVars, respVariable, this.frequencyVar, summaryVarVals, this.statType);
                        val[j2] = this.isAbsolute() ? Math.abs(val[j2]) : val[j2];
                        val[j2] = val[j2] * (freqVal2 / freqStat3);
                    }
                } else {
                    for (int j3 = 0; j3 < this.numberOfResponse; ++j3) {
                        Object respVariable = this.roles.getVariable((Object)this.responseRole, j3);
                        val[j3] = this.filter.getNumericValue(respVariable, (long)index);
                        val[j3] = this.defaultStatistics.getSummaryStatistic(this.summaryVars, respVariable, null, summaryVarVals, this.statType);
                        double freqStat4 = (int)this.defaultStatistics.getSummaryStatistic(this.summaryVars, null, null, summaryVarVals, 12);
                        val[j3] = this.isAbsolute() ? Math.abs(val[j3]) : val[j3];
                        val[j3] = val[j3] / freqStat4;
                    }
                }
                if (selectionList.containsKey(catObj)) {
                    grpList = (LinkedHashMap<String, Double>)selectionList.get(catObj);
                    if (grpList != null) {
                        for (j = 0; j < this.numberOfResponse; ++j) {
                            grpObj = new Integer(j);
                            if (Double.isNaN(val[j])) continue;
                            if (grpList.containsKey(grpObj)) {
                                double tempVal = ((Number)grpList.get(grpObj)).doubleValue();
                                grpList.put((String)grpObj, new Double(tempVal += val[j]));
                                continue;
                            }
                            grpList.put((String)grpObj, new Double(val[j]));
                        }
                    } else {
                        grpList = new LinkedHashMap();
                        for (j = 0; j < this.numberOfResponse; ++j) {
                            grpObj = new Integer(j);
                            if (Double.isNaN(val[j])) continue;
                            grpList.put((String)grpObj, new Double(val[j]));
                        }
                    }
                } else {
                    grpList = new LinkedHashMap<String, Double>();
                    for (j = 0; j < this.numberOfResponse; ++j) {
                        grpObj = new Integer(j);
                        if (Double.isNaN(val[j])) continue;
                        grpList.put((String)grpObj, new Double(val[j]));
                    }
                }
                selectionList.put(catObj, grpList);
                continue;
            }
            double val = 0.0;
            if (this.respVar == null && this.frequencyVar == null) {
                val = 1.0;
                if (this.statType == 11) {
                    freqStat2 = this.defaultStatistics.getSummaryStatistic(this.summaryVars, null, null, summaryVarVals, 12);
                    val = this.defaultStatistics.getSummaryStatistic(this.summaryVars, null, this.frequencyVar, summaryVarVals, this.statType);
                    val /= freqStat2;
                }
            } else if (this.frequencyVar != null && this.respVar != null) {
                freqVal = (int)this.filter.getNumericValue(this.roles.getVariable((Object)this.frequencyRole, 0), (long)index);
                if (Double.isNaN(freqVal) || freqVal <= 0.0) continue;
                freqStat = (int)this.defaultStatistics.getSummaryStatistic(this.summaryVars, null, this.frequencyVar, summaryVarVals, 12);
                val = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, this.frequencyVar, summaryVarVals, this.statType);
                val = this.isAbsolute() ? Math.abs(val) : val;
                val *= freqVal / freqStat;
            } else if (this.frequencyVar == null && this.respVar != null) {
                val = this.filter.getNumericValue(this.roles.getVariable((Object)this.responseRole, 0), (long)index);
                val = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, null, summaryVarVals, this.statType);
                freqStat2 = (int)this.defaultStatistics.getSummaryStatistic(this.summaryVars, null, null, summaryVarVals, 12);
                val = this.isAbsolute() ? Math.abs(val) : val;
                val /= freqStat2;
            } else if (this.frequencyVar != null && this.respVar == null) {
                freqVal = (int)this.filter.getNumericValue(this.roles.getVariable((Object)this.frequencyRole, 0), (long)index);
                if (Double.isNaN(freqVal) || freqVal <= 0.0) continue;
                if (this.statType == 12) {
                    val = freqVal;
                } else if (this.statType == 11) {
                    freqStat = (int)this.defaultStatistics.getSummaryStatistic(this.summaryVars, null, this.frequencyVar, summaryVarVals, 12);
                    val = this.defaultStatistics.getSummaryStatistic(this.summaryVars, null, this.frequencyVar, summaryVarVals, this.statType);
                    val *= freqVal / freqStat;
                }
                double d = val = this.isAbsolute() ? Math.abs(val) : val;
            }
            if (selectionList.containsKey(catObj)) {
                grpList = (LinkedHashMap<String, Double>)selectionList.get(catObj);
                if (grpList != null) {
                    if (grpList.containsKey(grpObj)) {
                        double tempVal = ((Number)grpList.get(grpObj)).doubleValue();
                        grpList.put((String)grpObj, new Double(tempVal += val));
                    } else {
                        grpList.put((String)grpObj, new Double(val));
                    }
                } else {
                    grpList = new LinkedHashMap<String, Double>();
                    grpList.put((String)grpObj, new Double(val));
                }
            } else {
                grpList = new LinkedHashMap();
                grpList.put((String)grpObj, new Double(val));
            }
            selectionList.put(catObj, grpList);
        }
    }

    @Override
    protected String getFormattedLabel(Object object) {
        if (object != null) {
            Object format = null;
            double value = ((Number)object).doubleValue();
            if (this.statType == 11) {
                format = SASFormat.getInstance((String)"Percent8.2");
                value /= 100.0;
            } else {
                format = this.statType == 12 ? SASFormat.getInstance((String)"Best8.0") : this.filter.getFormat(this.roles.getVariable((Object)this.responseRole, 0), SASFormat.class);
            }
            if (this.statType == 11) {
                String percentString = this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, 0), (Object)new Double(value), format).trim();
                int length = percentString.length();
                String temp = percentString.substring(0, length - 1);
                return temp;
            }
            return this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, 0), (Object)new Double(value), format);
        }
        return null;
    }

    @Override
    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                this.categoryMapper = null;
                this.displayBarEnd = 0;
                this.displayBarStart = 0;
                this.colorIndexList = null;
                break;
            }
            case 1: {
                this.colorIndexList = null;
                break;
            }
            case 70: {
                this.frequencyVar = null;
                this.respVars = (Object[])this.roles.getVariable((Object)this.responseRole);
                if (this.respVars != null) {
                    this.persistSortOrder();
                    break;
                }
                this.setCategorySortOrder();
                break;
            }
            case 6: {
                this.groupMapper = null;
                this.allowMultiResponse = true;
                this.setClusterWidthFactor(1.0);
                this.widthFactor = 0.85;
                break;
            }
            case 17: {
                this.respVar = null;
                this.respVars = null;
                this.numberOfResponse = 1;
                this.respVars = (Object[])this.roles.getVariable((Object)this.responseRole);
                if (this.respVars != null) {
                    this.numberOfResponse = this.respVars.length;
                    if (this.responseLink != null) {
                        this.responseLink.clear();
                    }
                    if (this.responseLink == null) {
                        this.responseLink = new LinkedHashMap();
                    }
                    for (int i = 0; i < this.numberOfResponse; ++i) {
                        this.responseLink.put(new Integer(i), this.respVars[i]);
                    }
                    this.respVar = this.respVars != null ? this.respVars[0] : null;
                } else {
                    this.responseLink = null;
                    this.statType = 12;
                    if (this.showOtherBar) {
                        this.calculateOhterBar();
                    }
                }
                if (this.numberOfResponse > 1) {
                    this.allowMultiResponse = true;
                    this.roles.deleteRole((Object)this.groupRole);
                    this.roles.deleteRole((Object)this.colorIndexRole);
                    this.roles.deleteRole((Object)this.errorLowRole);
                    this.roles.deleteRole((Object)this.errorHighRole);
                } else {
                    this.roles.newRole((Object)this.groupRole, "Group", 1);
                    this.roles.setRoleType((Object)this.groupRole, 0);
                    this.roles.setDiscrete((Object)this.groupRole, true);
                    this.roles.newRole((Object)this.colorIndexRole, "Color index", 1);
                    this.roles.setRoleType((Object)this.colorIndexRole, 1);
                    this.roles.newRole((Object)this.errorLowRole, "Error low", 1);
                    this.roles.setRoleType((Object)this.errorLowRole, 1);
                    this.roles.newRole((Object)this.errorHighRole, "Error high", 1);
                    this.roles.setRoleType((Object)this.errorHighRole, 1);
                }
                this.persistSortOrder();
                break;
            }
        }
    }

    protected Object setResponseAxesLabels() {
        Object rc = null;
        if (this.userShowRespStatOnAxis) {
            this.showStatOnAxis = this.userShowRespStatOnAxis;
        }
        if (this.filter != null) {
            Object rVar = null;
            if (this.allowMultiResponse && this.numberOfResponse > 1) {
                rVar = this.getStatistic();
            } else {
                rVar = this.roles.getVariable((Object)this.responseRole, 0);
                if ((rVar = this.filter.getVariableDescription(rVar)) != null && this.showStatOnAxis) {
                    String suffixStr = this.statType == 1 ? statName_Sum.toString() : statName_Mean.toString();
                    rVar = rVar.toString() + " (" + suffixStr + ")";
                }
                if (rVar == null) {
                    rVar = this.userComputedResponseLabel != null ? this.userComputedResponseLabel : (this.statType == 11 ? statName_Percent : statName_Frequency);
                }
            }
            rc = rVar;
        }
        return rc;
    }

    @Override
    protected void setRole(RoleEvent e) {
        super.setRole(e);
        switch (e.role) {
            case 38: {
                Object obj = this.roles.getVariable((Object)this.statTypeRole);
                this.setStatistic(obj);
                this.persistSortOrder();
                break;
            }
            case 70: {
                this.frequencyVar = this.roles.getVariable((Object)this.frequencyRole, 0);
                this.persistSortOrder();
            }
        }
    }

    protected void setStatistic(Object type) {
        if (type == null) {
            return;
        }
        int currStatType = DefaultStatistics.getStatisticIndex((Object)type);
        if (currStatType == this.statType) {
            return;
        }
        this.statType = currStatType;
        switch (this.statType) {
            case 11: 
            case 12: {
                if (this.respVar == null) break;
                this.statType = 1;
                break;
            }
            case 1: 
            case 2: {
                if (this.respVar != null) break;
                this.statType = 12;
                break;
            }
            default: {
                this.statType = this.respVar == null ? 12 : 1;
            }
        }
        this.clearResponseRange();
        if (this.showOtherBar) {
            this.calculateOhterBar();
        }
    }

    @Override
    protected void sortCategoriesOnResponse(Object[] catArray, ArrayList unsortedResponseArrayList, int cOrder) {
        int i;
        Collection c = CollectionSorter.getValues(unsortedResponseArrayList.subList(0, unsortedResponseArrayList.size()), cOrder);
        Object[] sortedResponsesArray = c.toArray();
        this.categoryMapper.removeAllValues();
        int size = sortedResponsesArray.length;
        ArrayList<Integer> fakeStringIndexList = new ArrayList<Integer>();
        for (i = 0; i < size; ++i) {
            for (int k = 0; k < unsortedResponseArrayList.size(); ++k) {
                if (!sortedResponsesArray[i].equals(unsortedResponseArrayList.get(k))) continue;
                if (SILKUtilities.isFakeString((String)catArray[k])) {
                    fakeStringIndexList.add(k);
                    continue;
                }
                this.categoryMapper.addValue(catArray[k]);
            }
        }
        for (i = 0; i < fakeStringIndexList.size(); ++i) {
            int index = (Integer)fakeStringIndexList.get(i);
            this.categoryMapper.addValue(catArray[index]);
        }
    }

    @Override
    protected void BuildData(Object[] summaryVarVals) {
        Object[] catArray = this.categoryList.keySet().toArray();
        Object[] grpArray = this.categoryList.values().toArray();
        Object[] respValuesArray = this.responseLink != null ? this.responseLink.values().toArray() : null;
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        for (int i = 0; i < catArray.length; ++i) {
            Object[] temp;
            double respValue;
            ArrayList<Object[]> responses;
            int j;
            summaryVarVals[0] = catArray[i];
            Object[] grpKeyArray = ((Map)grpArray[i]).keySet().toArray();
            Object[] grpValuesArray = ((Map)grpArray[i]).values().toArray();
            if (this.allowMultiResponse && this.numberOfResponse > 1) {
                this.renderingData = new LinkedHashMap();
                for (j = 0; j < this.numberOfResponse; ++j) {
                    responses = new ArrayList();
                    this.respVar = respValuesArray[j];
                    respValue = this.getResponseValues(this.summaryVars, this.respVar, this.frequencyVar, summaryVarVals, this.statType);
                    temp = new Object[2];
                    temp[1] = Boolean.TRUE;
                    temp[0] = respValue;
                    responses.add(temp);
                    this.renderingData.put(this.respVar, responses);
                }
                this.renderingMRData.put(catArray[i], this.renderingData);
                continue;
            }
            if (grpVarIndex > -1) {
                this.renderingData = new LinkedHashMap();
            }
            for (j = 0; j < grpKeyArray.length; ++j) {
                responses = new ArrayList<Object[]>();
                if (grpVarIndex > -1) {
                    summaryVarVals[1] = grpValuesArray[j];
                }
                respValue = this.getResponseValues(this.summaryVars, this.respVar, this.frequencyVar, summaryVarVals, this.statType);
                temp = new Object[2];
                temp[1] = Boolean.TRUE;
                temp[0] = respValue;
                responses.add(temp);
                if (grpVarIndex > -1) {
                    this.renderingData.put(grpValuesArray[j], responses);
                    continue;
                }
                this.renderingData.put(catArray[i], responses);
            }
            this.renderingGroupedData.put(catArray[i], this.renderingData);
        }
    }

    @Override
    protected void drawBars(Graphics g) {
        int respIndex = 0;
        double respValue = 0.0;
        Color[] fillColors = this.style.getDataFillColors();
        Object[] catArray = this.categoryList.keySet().toArray();
        for (int i = 0; i < catArray.length; ++i) {
            int catIndx;
            ArrayList responseList = (ArrayList)this.renderingData.get(catArray[i]);
            if (responseList == null) continue;
            int barCenter = this.categoryMapper.getIndex(catArray[i]);
            this.adjust_neg = 0.0;
            this.adjust_pos = 0.0;
            Object[] respArray = (Object[])responseList.get(0);
            Double val = (Double)respArray[0];
            if (val == 0.0 || Double.isNaN(val)) continue;
            if (val != null) {
                respValue = val;
            }
            this.isGraphed = (Boolean)respArray[1];
            this.checkNegativeValues(respValue);
            respValue = this.isAbsolute() ? Math.abs(respValue) : respValue;
            String catValueStr = this.roles.getVariable((Object)this.categoryRole, 0).toString();
            DataStyleElement dse = SILKUtilities.getStyleElement(catValueStr, -1, 2, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false)).getAsDataStyle();
            Color clr = dse.getFillColor();
            if (this.colorIndexList != null) {
                Object clrObj = null;
                catIndx = ((Number)this.uniqueCatList.get(catArray[i])).intValue();
                clrObj = this.colorIndexList.get(new Integer(catIndx));
                if (clrObj != null) {
                    int clrVal = ((Number)clrObj).intValue();
                    dse = SILKUtilities.getStyleElement(catValueStr, clrVal, 2, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false)).getAsDataStyle();
                    clr = dse.getFillColor();
                } else {
                    clr = this.style.getFillStyleElement("Missing").getFillColor();
                }
            } else if (this.colorBy != null) {
                if (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign")) {
                    clr = this.isNegative() ? fillColors[1] : fillColors[0];
                } else {
                    catValueStr = catArray[i].toString();
                    Object catVal = this.uniqueCatList.get(catArray[i]);
                    if (catVal != null) {
                        catIndx = ((Number)catVal).intValue();
                        dse = SILKUtilities.getStyleElement(catValueStr, catIndx, 1, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false)).getAsDataStyle();
                        clr = dse.getFillColor();
                    }
                }
            }
            this.renderBars(g, clr, i, 0, 0, barCenter, respValue, respIndex, 0);
        }
        if (this.showOtherBar) {
            this.adjust_neg = 0.0;
            this.adjust_pos = 0.0;
            FillStyleElement se = this.style.getFillStyleElement("Other");
            Color otherBarClr = se.getFillColor();
            this.renderBars(g, otherBarClr, 0, 0, 0, this.categoryMapper.getIndex(this.OTHER_CATEGORY), this.otherPosRespValue, respIndex, 1);
            if (this.otherNegRespValue < 0.0) {
                this.renderBars(g, otherBarClr, 0, 0, 0, this.categoryMapper.getIndex(this.OTHER_CATEGORY), this.otherNegRespValue, respIndex, 2);
            }
        }
    }

    @Override
    protected void renderBars(Graphics g, Color clr, int i, int j, int numberOfCluster, int barCenter, double respValue, int respIndex, int otherBarType) {
        double[] projectValues = new double[3];
        double[] projectValues_1 = new double[3];
        Object[] catArray = this.categoryList.keySet().toArray();
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        Color bclr = ColorUtilities.brighter(clr, 0.2);
        Color clr1 = clr;
        Color clr2 = bclr;
        if (this.isVerticalBar) {
            if (respValue >= 0.0) {
                if (this.transformObject.isReverse(1)) {
                    clr1 = clr;
                    clr2 = bclr;
                } else {
                    clr1 = bclr;
                    clr2 = clr;
                }
            } else if (this.transformObject.isReverse(1)) {
                clr1 = bclr;
                clr2 = clr;
            } else {
                clr1 = clr;
                clr2 = bclr;
            }
        } else if (respValue >= 0.0) {
            if (this.transformObject.isReverse(0)) {
                clr2 = clr;
            }
        } else if (this.transformObject.isReverse(0)) {
            clr1 = clr;
            clr2 = bclr;
        } else {
            clr1 = bclr;
            clr2 = clr;
        }
        this.getProjectedBar(barCenter, respValue, this.adjust_pos, this.adjust_neg, projectValues, projectValues_1);
        if (grpVarIndex > -1 && this.groupDisplayType == 1) {
            if (this.isVerticalBar) {
                projectValues[0] = projectValues[0] - ((double)numberOfCluster / 2.0 - (double)j) * this.respWidth;
                projectValues[0] = projectValues[0] + this.respWidth / 2.0;
            } else {
                projectValues[1] = projectValues[1] - ((double)numberOfCluster / 2.0 - (double)j) * this.respWidth;
                projectValues[1] = projectValues[1] + this.respWidth / 2.0;
            }
            this.adjust_neg = 0.0;
            this.adjust_pos = 0.0;
        } else {
            if (this.isVerticalBar) {
                projectValues[0] = projectValues[0] - ((double)this.numberOfResponse / 2.0 - (double)respIndex) * this.respWidth;
                projectValues[0] = projectValues[0] + this.respWidth / 2.0;
            } else {
                projectValues[1] = projectValues[1] - ((double)this.numberOfResponse / 2.0 - (double)respIndex) * this.respWidth;
                projectValues[1] = projectValues[1] + this.respWidth / 2.0;
            }
            if (respValue >= 0.0) {
                this.adjust_pos += respValue;
            } else {
                this.adjust_neg += respValue;
            }
        }
        g.setColor(Color.cyan);
        if (this.barWidth > 3.0) {
            if (this.gradientDisable || !this.gradient) {
                g.setColor(clr);
            } else {
                GradientPaint gp = this.isVerticalBar ? new GradientPaint((float)projectValues[0], (float)projectValues[1], clr1, (float)projectValues[0], (float)projectValues_1[1], clr2) : new GradientPaint((float)projectValues[0], (float)projectValues[1], clr1, (float)projectValues_1[0], (float)projectValues[1], clr2);
                ((Graphics2D)g).setPaint(gp);
            }
            if (this.isVerticalBar) {
                g.fillRect((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
            } else {
                g.fillRect((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
            }
            if (this.outlineOn) {
                g.setColor(this.outlineClr);
                if (this.isVerticalBar) {
                    g.drawRect((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                } else {
                    g.drawRect((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                }
            }
        } else {
            g.setColor(clr);
            Stroke oldStroke = ((Graphics2D)g).getStroke();
            ((Graphics2D)g).setStroke(new BasicStroke((int)this.barWidth));
            if (this.isVerticalBar) {
                g.drawLine((int)projectValues[0], (int)projectValues[1], (int)projectValues[0], (int)projectValues_1[1]);
            } else {
                g.drawLine((int)projectValues[0], (int)projectValues[1], (int)projectValues_1[0], (int)projectValues[1]);
            }
            ((Graphics2D)g).setStroke(oldStroke);
        }
        if (grpVarIndex == -1) {
            this.drawErrorHighLow(g, projectValues, projectValues_1, respValue, barCenter);
        }
        if (this.showLabels) {
            if (otherBarType == 1) {
                this.otherPosLabelPosition = this.isVerticalBar ? projectValues[0] : projectValues[1];
            } else if (otherBarType == 2) {
                this.otherNegLabelPosition = this.isVerticalBar ? projectValues[0] : projectValues[1];
            } else if (this.isVerticalBar) {
                this.populateLabels(respValue, projectValues[0]);
            } else {
                this.populateLabels(respValue, projectValues[1]);
            }
        }
    }

    private void findStatusOfStatOnAxis() {
        if (this.getResponseStatDisplay() == 0) {
            int observations = this.filter.getNumberObservations(-1);
            SILKNumber categoryRole = this.role.getRoleObject("ROLE_CATEGORY");
            Object o = this.roles.getVariable((Object)categoryRole, 0);
            if (o == null) {
                return;
            }
            CharacterVariableMapper categoryMapper = new CharacterVariableMapper(this.filter, o);
            int numberOfBars = categoryMapper.getNumberValues();
            this.showStatOnAxis = this.userShowRespStatOnAxis ? this.userShowRespStatOnAxis : observations != numberOfBars;
        } else {
            this.showStatOnAxis = false;
        }
    }

    private Collection getCollection(Collection collection) {
        int order = this.sortOrder;
        Collection c = null;
        if (this.sortOrder == 0) {
            order = 1;
        } else if (this.sortOrder == 1) {
            order = -1;
        }
        c = CollectionSorter.getValues(collection, order);
        return c;
    }

    public int getOtherThresholdType() {
        return this.otherThresholdType;
    }

    public void setOtherThresholdType(int otherThresholdType) {
        this.otherThresholdType = otherThresholdType;
        this.userSetProperties.set(831);
    }

    public boolean isShowOtherBar() {
        return this.showOtherBar;
    }

    public void setShowOtherBar(boolean showOtherBar) {
        this.showOtherBar = showOtherBar;
        this.userSetProperties.set(830);
    }

    public int getMaxBarThresholdValue() {
        return this.maxBarThresholdValue;
    }

    public void setMaxBarThresholdValue(int maxBarThresholdValue) {
        this.maxBarThresholdValue = maxBarThresholdValue;
        this.userSetProperties.set(832);
        this.userSetProperties.clear(833);
    }

    public double getPercentThresholdValue() {
        return this.percentThresholdValue;
    }

    public void setPercentThresholdValue(double percentThresholdValue) {
        this.percentThresholdValue = percentThresholdValue;
        this.userSetProperties.set(833);
        this.userSetProperties.clear(832);
    }
}

