/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.data.sort.SortContextFactory;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.HTMLColors;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import java.util.Stack;

public class BandElement
extends BaseElement {
    protected SILKNumber xRole = null;
    protected SILKNumber upperRole = null;
    protected SILKNumber lowerRole = null;
    protected SortContext sort = null;
    protected CharacterVariableMapper xCharMapper = null;
    protected double[] projectValues = new double[3];
    LineAttrib outlineAttrib = null;
    protected double upperConstant = Double.NaN;
    protected boolean useUpperConstant = false;
    protected double lowerConstant = Double.NaN;
    protected boolean useLowerConstant = false;
    protected boolean extendBand = false;
    private String lowerLimitLabel;
    private String upperLimitLabel;
    public static final int[] supportedBandProperties = new int[]{2156, 2154, 2155, 2157, 2153, 2150, 2151, 2152, 2158, 2159};

    public BandElement() {
        Roles r = Roles.getInstance(null);
        this.xRole = r.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 0);
        this.upperRole = r.getRoleObject("ROLE_UPPER_BAND");
        this.roles.newRole((Object)this.upperRole, "Upper Band", 1);
        this.roles.setRoleType((Object)this.upperRole, 1);
        this.lowerRole = r.getRoleObject("ROLE_LOWER_BAND");
        this.roles.newRole((Object)this.lowerRole, "Lower Band", 1);
        this.roles.setRoleType((Object)this.lowerRole, 1);
        this.dataTransparency = SILKGlobal.isFlagSet(4) ? 1.0 : 0.5;
        this.outlineAttrib = new LineAttrib();
        this.outlineAttrib.setVisible(false);
        this.setSupportedProperties(supportedBandProperties);
        this.userSetProperties.appendProperties(supportedBandProperties);
        this.addChartTabInfo("com.sas.graphics.silk.ui.BandPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BandElement.Band.txt", (String)"Band"));
        this.lowerLimitLabel = ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BandElement.lowerLimit.label.txt", (String)"Limit Lower");
        this.upperLimitLabel = ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BandElement.upperLimit.label.txt", (String)"Limit Upper");
    }

    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                if (this.filter == null) break;
                if (this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0))) {
                    if (this.xCharMapper != null) {
                        this.xCharMapper.removeAllValues();
                    }
                    this.xCharMapper = null;
                    break;
                }
                if (this.xCharMapper == null) {
                    this.xCharMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable((Object)this.xRole, 0));
                    break;
                }
                this.xCharMapper.setVariable(this.roles.getVariable((Object)this.xRole, 0));
            }
        }
    }

    @Override
    protected void drawChart(Graphics g) {
        Object aaHint = null;
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            aaHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            oldStroke = ((Graphics2D)g).getStroke();
        }
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        int lowerVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.lowerRole, 0));
        int upperVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.upperRole, 0));
        if (xVarIndex < 0) {
            return;
        }
        int maxValue = (int)Math.pow(2.0, 15.0) - 100;
        int minValue = -maxValue;
        GeneralPath upperPath = new GeneralPath();
        GeneralPath lowerPath = new GeneralPath();
        double lastX = 0.0;
        double lastUpper = 0.0;
        double lastLower = 0.0;
        double x = 0.0;
        double upper = 0.0;
        double lower = 0.0;
        boolean xIsNum = this.filter.isNumericVariable(xVarIndex);
        Stack<double[]> lowerPointStack = new Stack<double[]>();
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        boolean moveTo = true;
        for (int j = 0; j < this.filter.getNumberObservations(-1); ++j) {
            double xValue = Double.NaN;
            xValue = xIsNum ? this.filter.getNumericValue(xVarIndex, (long)j, this.sort) : (double)this.xCharMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)j, null));
            if (Double.isNaN(xValue) || this.filter.isMissing(xVarIndex, this.filter.getValue(xVarIndex, (long)j)) || this.filter.isMissing(upperVarIndex, this.filter.getValue(upperVarIndex, (long)j)) || this.filter.isMissing(lowerVarIndex, this.filter.getValue(lowerVarIndex, (long)j))) continue;
            double lowerValue = Double.NaN;
            lowerValue = xIsNum ? this.filter.getNumericValue(lowerVarIndex, (long)j, this.sort) : this.filter.getNumericValue(lowerVarIndex, (long)j);
            double upperValue = Double.NaN;
            upperValue = xIsNum ? this.filter.getNumericValue(upperVarIndex, (long)j, this.sort) : this.filter.getNumericValue(upperVarIndex, (long)j);
            lastX = x;
            lastUpper = upper;
            lastLower = lower;
            this.projectValues = this.transformObject.project(xValue, upperValue, 0.0, this.projectValues);
            x = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            upper = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
            this.projectValues = this.transformObject.project(xValue, lowerValue, 0.0, this.projectValues);
            lower = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
            if (Double.isNaN(x)) continue;
            double x0 = lastX;
            double upper0 = lastUpper;
            double lower0 = lastLower;
            double x1 = x;
            double upper1 = upper;
            double lower1 = lower;
            if (Double.isNaN(x0) || Double.isNaN(upper0) || Double.isNaN(lower0)) {
                if (upperPath.getCurrentPoint() == null || lowerPath.getCurrentPoint() == null) continue;
                x0 = upperPath.getCurrentPoint().getX();
                upper0 = upperPath.getCurrentPoint().getY();
                lower0 = lowerPath.getCurrentPoint().getY();
            }
            if (!moveTo) {
                upperPath.lineTo((float)x1, (float)upper1);
                lowerPath.lineTo((float)x1, (float)lower1);
                lowerPointStack.push(new double[]{x1, lower1});
                continue;
            }
            upperPath.moveTo((float)x1, (float)upper1);
            lowerPath.moveTo((float)x1, (float)lower1);
            lowerPointStack.push(new double[]{x1, lower1});
            moveTo = false;
        }
        double yMin = Double.MAX_VALUE;
        double yMax = Double.MIN_VALUE;
        if (this.yOutputRange instanceof ContinuousRange) {
            yMin = ((ContinuousRange)this.yOutputRange).getMin();
            yMax = ((ContinuousRange)this.yOutputRange).getMax();
        }
        DataStyleElement dse = SILKUtilities.getStyleElement(null, -1, 2, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false)).getAsDataStyle();
        Color c = dse.getFillColor();
        int trans = (int)(this.dataTransparency * 255.0);
        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), trans);
        GeneralPath p = new GeneralPath();
        GeneralPath upperConstantPath = null;
        GeneralPath lowerConstantPath = null;
        if (this.transformObject.isReverse(0)) {
            double temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (!moveTo && !this.useUpperConstant && upperVarIndex >= 0) {
            p.append(upperPath.getPathIterator(null), true);
        } else if (!Double.isNaN(this.upperConstant)) {
            this.projectValues = this.transformObject.project(Double.NaN, this.upperConstant, Double.NaN, this.projectValues);
            if (this.extendBand) {
                p.moveTo(0.0f, (float)this.projectValues[1]);
                p.lineTo(this.bounds.width + this.bounds.x, (float)this.projectValues[1]);
            } else {
                p.moveTo((float)minX, (float)this.projectValues[1]);
                p.lineTo((float)maxX, (float)this.projectValues[1]);
            }
            upperConstantPath = new GeneralPath();
            upperConstantPath.moveTo((float)minX, (float)this.projectValues[1]);
            upperConstantPath.lineTo((float)maxX, (float)this.projectValues[1]);
        } else {
            this.projectValues = this.transformObject.project(Double.NaN, yMax, Double.NaN, this.projectValues);
            p.moveTo((float)minX, (float)this.projectValues[1]);
            p.lineTo((float)maxX, (float)this.projectValues[1]);
        }
        if (!this.useLowerConstant && lowerVarIndex >= 0) {
            Point2D currentPoint = lowerPath.getCurrentPoint();
            if (currentPoint != null) {
                p.lineTo((float)currentPoint.getX(), (float)currentPoint.getY());
            }
            while (!lowerPointStack.isEmpty()) {
                double[] d = (double[])lowerPointStack.pop();
                p.lineTo((float)d[0], (float)d[1]);
            }
        } else if (!Double.isNaN(this.lowerConstant)) {
            lowerConstantPath = new GeneralPath();
            this.projectValues = this.transformObject.project(Double.NaN, this.lowerConstant, Double.NaN, this.projectValues);
            if (this.extendBand) {
                p.lineTo(this.bounds.width + this.bounds.x, (float)this.projectValues[1]);
                p.lineTo(0.0f, (float)this.projectValues[1]);
            } else {
                p.lineTo((float)maxX, (float)this.projectValues[1]);
                p.lineTo((float)minX, (float)this.projectValues[1]);
            }
            lowerConstantPath.moveTo((float)maxX, (float)this.projectValues[1]);
            lowerConstantPath.lineTo((float)minX, (float)this.projectValues[1]);
        } else {
            this.projectValues = this.transformObject.project(Double.NaN, yMin, Double.NaN, this.projectValues);
            p.lineTo((float)maxX, (float)this.projectValues[1]);
            p.lineTo((float)minX, (float)this.projectValues[1]);
        }
        p.closePath();
        g.setColor(c);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).fill(p);
        }
        if (!this.useUpperConstant) {
            this.drawLine(g, upperPath, this.outlineAttrib);
        } else if (upperConstantPath != null) {
            this.drawLine(g, upperConstantPath, this.outlineAttrib);
        }
        if (!this.useLowerConstant) {
            this.drawLine(g, lowerPath, this.outlineAttrib);
        } else if (lowerConstantPath != null) {
            this.drawLine(g, lowerConstantPath, this.outlineAttrib);
        }
        upperPath.reset();
        lowerPath.reset();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)g).setStroke(oldStroke);
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        }
    }

    private void drawLine(Graphics g, GeneralPath line, LineAttrib lineAttrib) {
        if (lineAttrib == null || !lineAttrib.isVisible()) {
            return;
        }
        g.setColor(lineAttrib.getColor());
        if (lineAttrib.getPattern() > 1 && g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lineAttrib.getPattern(), (int)lineAttrib.getWidth()));
        } else if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(new BasicStroke(lineAttrib.getWidth(), 1, 1));
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).draw(line);
        }
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
            }
        }
        if (this.filter != null) {
            this.sort = SortContextFactory.getSortContext((Object)this.filter.getSource(), (String[])new String[]{this.roles.getVariable((Object)this.xRole, 0) + ""}, (int)1);
        }
    }

    protected void removeRole(RoleEvent e) {
    }

    @Override
    protected void drawSelected(Graphics g) {
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        return false;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        Object upperValue;
        Object lowerValue;
        int tipIdx = -1;
        tipIdx = this.getTipObservationIndex(screenX, screenY);
        if (tipIdx == -1) {
            return null;
        }
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        int lowerVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.lowerRole, 0));
        int upperVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.upperRole, 0));
        boolean xIsNum = this.filter.isNumericVariable(xVarIndex);
        StringBuffer sb = new StringBuffer();
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        sb.append(this.filter.getVariableDescription(xVar));
        sb.append(" \t= \t ");
        String xValue = this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)tipIdx, (Object)this.sort);
        sb.append((Object)xValue);
        sb.append("\n");
        if (this.useLowerConstant && !Double.isNaN(this.lowerConstant)) {
            sb.append(this.lowerLimitLabel);
            sb.append(" \t= \t ");
            lowerValue = this.lowerConstant;
        } else {
            Object lowerVar = this.roles.getVariable((Object)this.lowerRole, 0);
            sb.append(this.filter.getVariableDescription(lowerVar));
            sb.append(" \t= \t ");
            lowerValue = this.filter.getFormattedValue(this.filter.getVariableId(lowerVarIndex), (long)tipIdx, (Object)this.sort);
        }
        sb.append(lowerValue);
        sb.append("\n");
        if (this.useUpperConstant && !Double.isNaN(this.upperConstant)) {
            sb.append(this.upperLimitLabel);
            sb.append(" \t= \t ");
            upperValue = this.upperConstant;
        } else {
            Object upperVar = this.roles.getVariable((Object)this.upperRole, 0);
            sb.append(this.filter.getVariableDescription(upperVar));
            sb.append(" \t= \t ");
            upperValue = this.filter.getFormattedValue(this.filter.getVariableId(upperVarIndex), (long)tipIdx, (Object)this.sort);
        }
        sb.append(upperValue);
        return sb.toString();
    }

    private int getTipObservationIndex(int screenX, int screenY) {
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        int lowerVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.lowerRole, 0));
        int upperVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.upperRole, 0));
        boolean xIsNum = this.filter.isNumericVariable(xVarIndex);
        if (xVarIndex < 0) {
            return -1;
        }
        boolean initializedFromData = false;
        int maxValue = (int)Math.pow(2.0, 15.0) - 100;
        int minValue = -maxValue;
        double lastX = 0.0;
        double lastUpper = 0.0;
        double lastLower = 0.0;
        double x = 0.0;
        double upper = 0.0;
        double lower = 0.0;
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        for (int j = 0; j < this.filter.getNumberObservations(-1); ++j) {
            double xValue = Double.NaN;
            xValue = xIsNum ? this.filter.getNumericValue(xVarIndex, (long)j, this.sort) : (double)this.xCharMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)j, null));
            if (Double.isNaN(xValue) || this.filter.isMissing(xVarIndex, this.filter.getValue(xVarIndex, (long)j)) || this.filter.isMissing(upperVarIndex, this.filter.getValue(upperVarIndex, (long)j)) || this.filter.isMissing(lowerVarIndex, this.filter.getValue(lowerVarIndex, (long)j))) continue;
            double lowerValue = Double.NaN;
            lowerValue = xIsNum ? this.filter.getNumericValue(lowerVarIndex, (long)j, this.sort) : this.filter.getNumericValue(lowerVarIndex, (long)j);
            double upperValue = Double.NaN;
            upperValue = xIsNum ? this.filter.getNumericValue(upperVarIndex, (long)j, this.sort) : this.filter.getNumericValue(upperVarIndex, (long)j);
            lastX = x;
            lastUpper = upper;
            lastLower = lower;
            this.projectValues = this.transformObject.project(xValue, upperValue, 0.0, this.projectValues);
            x = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            upper = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
            this.projectValues = this.transformObject.project(xValue, lowerValue, 0.0, this.projectValues);
            lower = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
            if (!initializedFromData) {
                lastX = x;
                lastUpper = upper;
                lastLower = lower;
                initializedFromData = true;
            }
            if (Double.isNaN(x) || j <= 0) continue;
            int[] xPoints = new int[]{(int)lastX, (int)lastX, (int)x, (int)x};
            if (this.useUpperConstant && !Double.isNaN(this.upperConstant)) {
                this.projectValues = this.transformObject.project(Double.NaN, this.upperConstant, Double.NaN, this.projectValues);
                lastUpper = upper = this.projectValues[1];
            }
            if (this.useLowerConstant && !Double.isNaN(this.lowerConstant)) {
                this.projectValues = this.transformObject.project(Double.NaN, this.lowerConstant, Double.NaN, this.projectValues);
                lastLower = lower = this.projectValues[1];
            }
            int[] yPoints = new int[]{(int)lastLower, (int)lastUpper, (int)upper, (int)lower};
            Polygon poly = new Polygon();
            poly.npoints = 4;
            poly.xpoints = xPoints;
            poly.ypoints = yPoints;
            if (!poly.contains(screenX, screenY)) continue;
            double prev = (double)screenX - lastX;
            double next = x - (double)screenX;
            int idx = prev < next ? j - 1 : j;
            return idx;
        }
        return -1;
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        DataRange rc = super.getPreferredRange(which);
        boolean hasBandRole = false;
        Enumeration en = Extract.elements((Object)which);
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (RoleInterface.ROLE_UPPER_BAND.equals(o)) {
                hasBandRole = true;
                continue;
            }
            if (!RoleInterface.ROLE_LOWER_BAND.equals(o)) continue;
            hasBandRole = true;
        }
        if (rc == null && hasBandRole) {
            rc = new ContinuousRange();
        }
        if (rc instanceof ContinuousRange) {
            ContinuousRange range = (ContinuousRange)rc;
            Enumeration e = Extract.elements((Object)which);
            while (e.hasMoreElements()) {
                Object role = e.nextElement();
                if (RoleInterface.ROLE_UPPER_BAND.equals(role) && this.useUpperConstant) {
                    range.setMax(Math.max(this.upperConstant, range.getMax()));
                    continue;
                }
                if (!RoleInterface.ROLE_LOWER_BAND.equals(role) || !this.useLowerConstant) continue;
                range.setMin(Math.min(this.lowerConstant, range.getMin()));
            }
        }
        return rc;
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pendingProperties != null && this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object[] rc = null;
        switch (id) {
            case 444: {
                rc = this.getOverlayLegendEntry();
                break;
            }
            case 2155: {
                rc = this.roles.getVariable((Object)this.lowerRole, 0);
                break;
            }
            case 2151: {
                rc = this.roles.getVariable((Object)this.upperRole, 0);
                break;
            }
            case 2154: {
                rc = new Boolean(this.isUseLowerConstant());
                break;
            }
            case 2150: {
                rc = new Boolean(this.isUseUpperConstant());
                break;
            }
            case 2156: {
                rc = new Double(this.getLowerConstant());
                break;
            }
            case 2153: {
                rc = new Double(this.getUpperConstant());
                break;
            }
            case 2152: {
                rc = this.yOutputRange;
                break;
            }
            case 2157: {
                rc = new Double(this.dataTransparency);
                break;
            }
            case 2158: {
                rc = new Boolean(this.outlineAttrib.isVisible());
                break;
            }
            case 19056: {
                rc = new Object[]{RoleInterface.ROLE_UPPER_BAND, RoleInterface.ROLE_LOWER_BAND};
                break;
            }
            case 2159: {
                rc = this.outlineAttrib;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 2154: {
                if (!(value instanceof Boolean)) break;
                this.setUseLowerConstant((Boolean)value);
                break;
            }
            case 2150: {
                if (!(value instanceof Boolean)) break;
                this.setUseUpperConstant((Boolean)value);
                break;
            }
            case 2157: {
                if (!(value instanceof Number)) break;
                this.setTransparency(((Number)value).doubleValue());
                break;
            }
            case 2156: {
                if (!(value instanceof Number)) break;
                this.setLowerConstant(((Number)value).doubleValue());
                break;
            }
            case 2153: {
                if (!(value instanceof Number)) break;
                this.setUpperConstant(((Number)value).doubleValue());
                break;
            }
            case 2158: {
                if (!(value instanceof Boolean)) break;
                this.outlineAttrib.setVisible((Boolean)value);
                this.userSetProperties.set(2158);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    public void setUpperConstant(double d) {
        this.upperConstant = d;
        this.userSetProperties.set(2153);
    }

    public double getUpperConstant() {
        if (Double.isNaN(this.upperConstant) && this.yOutputRange != null && this.yOutputRange instanceof ContinuousRange) {
            this.upperConstant = ((ContinuousRange)this.yOutputRange).getMax();
        }
        return this.upperConstant;
    }

    public void setLowerConstant(double d) {
        this.lowerConstant = d;
        this.userSetProperties.set(2156);
    }

    public double getLowerConstant() {
        if (Double.isNaN(this.lowerConstant) && this.yOutputRange != null && this.yOutputRange instanceof ContinuousRange) {
            this.lowerConstant = ((ContinuousRange)this.yOutputRange).getMin();
        }
        return this.lowerConstant;
    }

    public boolean isUseLowerConstant() {
        return this.useLowerConstant;
    }

    public void setUseLowerConstant(boolean useLowerConstant) {
        this.useLowerConstant = useLowerConstant;
        this.userSetProperties.set(2154);
        this.userSetProperties.set(2156);
    }

    public boolean isUseUpperConstant() {
        return this.useUpperConstant;
    }

    public void setUseUpperConstant(boolean useUpperConstant) {
        this.useUpperConstant = useUpperConstant;
        this.userSetProperties.set(2150);
        this.userSetProperties.set(2153);
    }

    public double getTransparency() {
        return this.dataTransparency;
    }

    public void setTransparency(double transparency) {
        this.dataTransparency = Math.max(0.0, Math.min(1.0, transparency));
        this.userSetProperties.set(2157);
    }

    public void setBandColor(Color c) {
        this.fillAttrs.getOverrides(true).setAttribute("color", HTMLColors.getColorString((Color)c));
    }

    protected LegendEntry getOverlayLegendEntry() {
        Object id = this.getId();
        if (this.overlayLegendLabel != null) {
            id = this.overlayLegendLabel;
        }
        DataStyleElement dse = SILKUtilities.getStyleElement(null, -1, 2, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false)).getAsDataStyle();
        Color c = dse.getFillColor();
        MarkerAttrib marker = null;
        marker = new MarkerAttrib();
        marker.setColor(c);
        marker.setOutline(Color.black);
        marker.setOutline(Boolean.TRUE);
        marker.setShape(19);
        LegendEntry entry = new LegendEntry(id, marker, null);
        return entry;
    }

    public boolean isBandExtended() {
        return this.extendBand;
    }

    public void setExtendBand(boolean extendBand) {
        this.extendBand = extendBand;
    }

    @Override
    public void dispose() {
        if (this.xCharMapper != null) {
            this.xCharMapper.dispose();
            this.xCharMapper = null;
        }
        super.dispose();
    }
}

