/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.FillPattern;
import com.sas.graphics.util.HTMLColors;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

public abstract class AbstractHistogramElement
extends BaseElement {
    protected static final int MAX_SCREEN_POS = (int)Math.pow(2.0, 15.0) - 100;
    protected static final int MIN_SCREEN_POS = -MAX_SCREEN_POS;
    protected static final int BELOW_FIRST_BIN = -1;
    protected static final int ABOVE_LAST_BIN = -2;
    protected static final int MISSING_BIN = -3;
    protected static final Object BELOW_FIRST_BIN_ID = "BELOW_FIRST_BIN_ID";
    protected static final Object ABOVE_LAST_BIN_ID = "ABOVE_LAST_BIN_ID";
    protected static final Object MISSING_ID = "MISSING";
    protected int MISSING_BIN_WIDTH = 0;
    protected int MISSING_BIN_HEIGHT = 0;
    protected static final int MISSING_BIN_MARGIN = 10;
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    protected ResourceBundle rbHist = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.histogram.silk_histogram_NLS");
    protected ResourceBundle resourceBundle = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.base.silk_base_NLS");
    protected static ResourceBundle rbUI = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected int numberOfBins_X = 0;
    protected int numberOfBins_Y = 0;
    protected boolean rebuildRequired = false;
    protected double[][] bivariateBinValues = null;
    protected double[] univariateBinValues = null;
    protected double missingValues = 0.0;
    protected double[] missingXBinValues = null;
    protected double[] missingYBinValues = null;
    protected LinkedHashMap xBins = null;
    protected LinkedHashMap yBins = null;
    protected double xBinStart = Double.NaN;
    protected double xBinEnd = Double.NaN;
    protected double xBinWidth = Double.NaN;
    protected double yBinStart = Double.NaN;
    protected double yBinEnd = Double.NaN;
    protected double yBinWidth = Double.NaN;
    protected double[] xBinNames = null;
    protected double[] yBinNames = null;
    protected boolean bivariate = false;
    protected boolean missingBinOn = false;
    protected boolean binAxis = true;
    protected boolean endLabelsOn = true;
    protected boolean outlinesOn = true;
    protected boolean gradientOn = true;
    private double xErr = 0.0;
    private double yErr = 0.0;
    protected DrawWorker drawWorker = new DrawWorker();
    protected SelectWorker selectWorker = new SelectWorker();
    protected SelectMissingWorker selectMissingWorker = new SelectMissingWorker();
    protected TipTextWorker tipTextWorker = new TipTextWorker();
    protected DrillDownWorker drillDownWorker = new DrillDownWorker();
    protected int xBoundary = 1;
    protected int yBoundary = 1;
    protected Rectangle pickArea = null;
    protected Bin dummyBin = new Bin();
    protected SILKNumber currentLegend = null;
    private Vector buildRoles = new Vector();
    protected boolean buildSuccess = false;
    protected boolean overlayDrawMode = false;
    protected static final float DEFAULT_OPACITY = 0.25f;
    protected float opacity = 0.25f;
    protected boolean createOverlayLegendEntry = true;
    private int orientation = 1;
    private boolean building = false;
    protected static final int RANGE_ERROR_FACTOR = 100000;
    protected static final int BIN_WIDTH_ERROR_FACTOR = 100;

    protected abstract String getStatTipValue(double var1);

    protected abstract double computePercentage(double var1);

    protected abstract void setRole(RoleEvent var1);

    protected abstract void removeRole(RoleEvent var1);

    protected abstract boolean buildBiVariateBins();

    protected abstract boolean buildUniVariateBins();

    protected abstract SILKNumber getLegendName();

    protected abstract String getLegendDisplayName();

    protected abstract LinkedHashMap buildBinSelectionCountMap(SelectionIterator var1);

    protected String getAdditionalTipText(Bin xBin, Bin yBin, double value) {
        return null;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 2: {
                break;
            }
            default: {
                this.resetChart();
            }
        }
        super.dataFilterChanged(evt);
    }

    @Override
    public void roleChanged(RoleEvent e) {
        if (this.isBuildRole(e)) {
            this.resetChart();
            this.rebuildRequired = true;
        }
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
            }
        }
        this.checkHistogramType();
        this.currentLegend = this.bivariate ? this.getLegendName() : null;
        if (this.rebuildRequired) {
            this.build(Boolean.TRUE);
        }
        if (this.isBuildRole(e)) {
            this.fireLayerListenerChanged(7);
        }
    }

    protected void addBuildRole(SILKNumber role) {
        if (role != null && !this.buildRoles.contains((Object)role)) {
            this.buildRoles.add(role);
        }
    }

    protected void removeBuildRole(SILKNumber role) {
        if (role != null) {
            this.buildRoles.remove((Object)role);
        }
    }

    protected boolean isBuildRole(RoleEvent e) {
        for (int i = 0; i < this.buildRoles.size(); ++i) {
            int r = ((SILKNumber)((Object)this.buildRoles.get(i))).intValue();
            if (r != e.role) continue;
            return true;
        }
        return false;
    }

    protected void checkHistogramType() {
        this.bivariate = false;
        if (this.filter == null) {
            return;
        }
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Object yVar = this.roles.getVariable((Object)this.yRole, 0);
        if (xVar == null) {
            return;
        }
        int xVarIndex = this.filter.getVariableIndex(xVar);
        int yVarIndex = this.filter.getVariableIndex(yVar);
        if (xVarIndex < 0) {
            return;
        }
        if (yVarIndex >= 0) {
            this.bivariate = true;
        }
    }

    @Override
    public boolean build(Object buildData) {
        if (this.filter == null) {
            return false;
        }
        if (!this.rebuildRequired) {
            return true;
        }
        if (this.building) {
            return true;
        }
        this.building = true;
        super.build(buildData);
        this.buildSuccess = this.buildBins();
        if (this.buildSuccess) {
            this.rebuildRequired = false;
            this.computeErrorThresholds();
            if (this.isVertical()) {
                ContinuousRange cr;
                if (this.xDataRange != null && !Double.isNaN(this.xBinStart) && !Double.isNaN(this.xBinEnd) && (this.xBinStart < (cr = (ContinuousRange)this.xDataRange).getMin() || this.xBinEnd > cr.getMax())) {
                    this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                }
                if (this.bivariate) {
                    this.initColorRamp();
                    this.fireBuildEvents();
                } else {
                    this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
                }
            } else {
                ContinuousRange cr;
                if (this.yDataRange != null && !Double.isNaN(this.xBinStart) && !Double.isNaN(this.xBinEnd) && (this.xBinStart < (cr = (ContinuousRange)this.yDataRange).getMin() || this.xBinEnd > cr.getMax())) {
                    this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
                }
                if (this.bivariate) {
                    this.initColorRamp();
                    this.fireBuildEvents();
                } else {
                    this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                }
            }
            this.fireLayerListenerChanged(8);
            this.fireLayerListenerChanged(3);
        }
        this.building = false;
        return this.buildSuccess;
    }

    protected void computeErrorThresholds() {
        if (!Double.isNaN(this.xBinWidth)) {
            this.xErr = this.xBinWidth / 100.0;
        } else if (this.xDataRange != null) {
            ContinuousRange xcr = (ContinuousRange)this.xDataRange;
            this.xErr = (xcr.getMax() - xcr.getMin()) / 100000.0;
        } else {
            this.xErr = 0.0;
        }
        if (this.bivariate && !Double.isNaN(this.yBinWidth)) {
            this.yErr = this.yBinWidth / 100.0;
        } else if (this.yDataRange != null) {
            ContinuousRange ycr = (ContinuousRange)this.yDataRange;
            this.yErr = (ycr.getMax() - ycr.getMin()) / 100000.0;
        } else {
            this.yErr = 0.0;
        }
    }

    protected boolean buildBins() {
        if (this.filter == null) {
            return false;
        }
        if (this.bivariate) {
            this.clearUniVariateBins();
            return this.buildBiVariateBins();
        }
        this.clearBiVariateBins();
        return this.buildUniVariateBins();
    }

    protected void clearUniVariateBins() {
        this.univariateBinValues = null;
        this.missingValues = 0.0;
        this.xBinStart = Double.NaN;
        this.xBinEnd = Double.NaN;
        if (this.xBins != null) {
            this.xBins.clear();
        }
    }

    protected void clearBiVariateBins() {
        this.bivariateBinValues = null;
        this.missingXBinValues = null;
        this.missingYBinValues = null;
        this.missingValues = 0.0;
        this.xBinStart = Double.NaN;
        this.xBinEnd = Double.NaN;
        if (this.xBins != null) {
            this.xBins.clear();
        }
        this.yBinStart = Double.NaN;
        this.yBinEnd = Double.NaN;
        if (this.yBins != null) {
            this.yBins.clear();
        }
    }

    public double[] getXBinNames() {
        return this.xBinNames;
    }

    public void setXBinNames(double[] binNames) {
        if (this.validateBinNames(binNames)) {
            this.xBinNames = binNames;
            this.setBinAxis(true, false);
            this.userSetProperties.clear(826);
            this.setEndLabelsOn(true, false);
            this.userSetProperties.clear(827);
            this.userSetProperties.set(824);
            this.rebuildRequired = true;
            this.build(Boolean.TRUE);
            this.fireLayerListenerChanged(7);
            this.fireLayerListenerChanged(3);
        }
    }

    public void clearBinNames() {
        this.setXBinNames(null);
    }

    protected boolean validateBinNames(double[] binNames) {
        if (binNames == null) {
            return true;
        }
        if (binNames.length < 2) {
            return false;
        }
        for (int i = 0; i < binNames.length - 1; ++i) {
            if (!(binNames[i] >= binNames[i + 1])) continue;
            return false;
        }
        return true;
    }

    protected void fireBuildEvents() {
        if (this.bivariate) {
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
            this.lce.setAction(6);
            this.lce.setBuildData((Object)this.getLegendName());
            this.fireLayerListenerChanged(this.lce);
            this.lce.setBuildData(null);
        }
    }

    protected void drawBinTops(Graphics g, Color binTopColor) {
        if (this.xBins == null || this.xBins.size() == 0) {
            return;
        }
        if (this.bivariate) {
            return;
        }
        if (!this.areOutlinesOn()) {
            return;
        }
        double[] pt1 = new double[3];
        double[] pt2 = new double[3];
        GeneralPath binTops = new GeneralPath();
        Rectangle r = new Rectangle();
        pt1 = this.transformObject.project(0.0, 0.0, 0.0, pt1);
        float baseLineValue = (float)pt1[1];
        g.setColor(binTopColor);
        if (this.univariateBinValues == null) {
            return;
        }
        boolean firstMove = true;
        int i = this.transformObject.isReverse(0) ? this.xBins.size() - 1 : 0;
        int iterStep = this.xBins.size();
        int y = (int)baseLineValue;
        Rectangle prevRect = new Rectangle();
        while (iterStep > 0) {
            Integer binId = new Integer(i);
            Bin b = (Bin)this.xBins.get(binId);
            if (b == null) continue;
            double count = this.univariateBinValues[i];
            if (this.isValidCount(count)) {
                r = this.getBinScreenRectangle(b, null, pt1, pt2, r);
                int n = y = this.transformObject.isReverse(1) ? r.y + r.height : r.y;
                if (firstMove) {
                    binTops.moveTo(r.x, y);
                    firstMove = false;
                } else {
                    if (prevRect.x + prevRect.width != r.x) {
                        binTops.lineTo(prevRect.x + prevRect.width, baseLineValue);
                        binTops.lineTo(r.x, baseLineValue);
                    }
                    binTops.lineTo(r.x, y);
                }
                binTops.lineTo(r.x + r.width, y);
                prevRect.setRect(r.x, r.y, r.width, r.height);
            } else if (!firstMove) {
                binTops.lineTo(r.x + r.width, baseLineValue);
            }
            i = this.transformObject.isReverse(0) ? --i : ++i;
            --iterStep;
        }
        if (g instanceof Graphics2D) {
            Stroke s = ((Graphics2D)g).getStroke();
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            ((Graphics2D)g).draw(binTops);
            if (s != null) {
                ((Graphics2D)g).setStroke(s);
            }
        }
    }

    protected void drawBin(Graphics g, Color fillColor, Color fillColor2, Color lineColor, Stroke lineStroke, Rectangle r, double value, Bin xBin, Bin yBin) {
        Paint oldPaint = null;
        Graphics2D g2 = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
        }
        Color c = fillColor;
        if (this.bivariate) {
            value = this.computePercentage(value);
            c = this.getMappedColor(value);
        }
        if (this.bivariate || !this.gradientOn || g2 == null) {
            g.setColor(c);
            oldPaint = null;
        } else {
            oldPaint = g2.getPaint();
            Color c1 = fillColor;
            Color c2 = fillColor2;
            if (!this.isVertical()) {
                c1 = fillColor2;
                c2 = fillColor;
            }
            g2.setPaint(new GradientPaint(r.x, r.y, c2, r.x + r.width, r.y + r.height, c1));
        }
        g.fillRect(r.x, r.y, r.width, r.height);
        if (oldPaint != null) {
            g2.setPaint(oldPaint);
        }
        if (this.areOutlinesOn()) {
            g.setColor(lineColor);
            Stroke s = null;
            if (g2 != null && lineStroke != null) {
                s = g2.getStroke();
                g2.setStroke(lineStroke);
            }
            g.drawRect(r.x, r.y, r.width, r.height);
            if (g2 != null && s != null) {
                g2.setStroke(s);
            }
        }
    }

    @Override
    protected void drawChart(Graphics g) {
        if (this.rebuildRequired) {
            if (this.isVertical()) {
                if (this.xDataRange == null || this.bivariate && this.yDataRange == null) {
                    this.fireLayerListenerChanged(7);
                }
            } else if (this.yDataRange == null || this.bivariate && this.xDataRange == null) {
                this.fireLayerListenerChanged(7);
            }
            this.build(Boolean.TRUE);
        }
        if (!this.buildSuccess) {
            return;
        }
        StyleElement localOverrides = this.fillAttrs.getOverrides(false);
        StyleElement se = SILKUtilities.getStyleElement(null, -1, 1, this.style, this.fillAttrs, localOverrides);
        Color fillColor = se.getAsDataStyle().getFillColor();
        Color fillColor2 = this.getGradientColor(fillColor);
        if (localOverrides != null) {
            float fillColOpacity = (float)(1.0 - localOverrides.getAsFillStyle().getFillTransparency());
            fillColor = this.getTransparentColor(fillColor, fillColOpacity);
            fillColor2 = this.getTransparentColor(fillColor2, fillColOpacity);
        }
        Color lineColor = this.getOutlineColor();
        if (this.overlayDrawMode) {
            fillColor = this.getTransparentColor(fillColor, this.opacity);
            fillColor2 = this.getTransparentColor(fillColor2, this.opacity);
            lineColor = this.getTransparentColor(se.getAsDataStyle().getLineColor(), this.opacity);
        }
        this.drawWorker.init(g, fillColor, fillColor2, lineColor, this.getOutlineStroke());
        this.doTheWork(this.drawWorker);
        if (this.overlayDrawMode) {
            this.drawBinTops(g, se.getAsDataStyle().getLineColor());
        }
        if (!this.bivariate) {
            this.drawBaseLine(g);
        }
    }

    protected Color getGradientColor(Color color) {
        return ColorUtilities.brighter(color, 0.2);
    }

    protected Color getTransparentColor(Color color, float opacity) {
        int alpha = (int)(opacity * 255.0f);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    @Override
    protected void drawInnerMarginArea(Graphics g) {
        if (!this.missingBinOn || !this.buildSuccess) {
            return;
        }
        this.drawMissingAreaBoundary(g);
        DataStyleElement missingElement = this.style.getDataStyleElement("Missing");
        Color fillColor = missingElement.getFillColor();
        Color fillColor2 = this.getGradientColor(fillColor);
        Color lineColor = this.style.getLineStyleElement("Outlines").getLineColor();
        this.drawWorker.init(g, fillColor, fillColor2, lineColor, null);
        this.doTheWorkForMissingBins(this.drawWorker);
        if (!this.bivariate) {
            this.drawBaseLine(g);
        }
    }

    protected void drawMissingAreaBoundary(Graphics g) {
        double[] pt1 = new double[3];
        Color lineColor = this.style.getDataStyleElement("AxisLines").getLineColor();
        g.setColor(lineColor);
        Graphics2D g2 = null;
        Stroke s = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
        }
        if (g2 != null) {
            s = g2.getStroke();
            g2.setStroke(SASLinePatterns.getStroke((int)34, (int)1));
        }
        if (this.xDataRange == null || this.yDataRange == null) {
            return;
        }
        pt1 = this.transformObject.project(((ContinuousRange)this.xDataRange).getMin(), ((ContinuousRange)this.yDataRange).getMin(), 0.0, pt1);
        if (this.bivariate) {
            int y2;
            int y;
            int y1;
            int x1;
            int x;
            int x2;
            if (this.isSingleValue((ContinuousRange)this.xDataRange)) {
                if (this.transformObject.isReverse(0)) {
                    x = x2 = this.bounds.x + this.bounds.width - 10 - this.MISSING_BIN_WIDTH - 5;
                    x1 = this.bounds.x;
                } else {
                    x = x1 = this.bounds.x + 10 + this.MISSING_BIN_WIDTH + 5;
                    x2 = this.bounds.x + this.bounds.width;
                }
            } else if (this.transformObject.isReverse(0)) {
                x = x2 = (int)pt1[0] + 5;
                x1 = this.bounds.x;
            } else {
                x = x1 = (int)pt1[0] - 5;
                x2 = this.bounds.x + this.bounds.width;
            }
            if (this.isSingleValue((ContinuousRange)this.yDataRange)) {
                if (this.transformObject.isReverse(1)) {
                    y = y1 = this.bounds.y + 10 + this.MISSING_BIN_HEIGHT + 5;
                    y2 = this.bounds.y + this.bounds.height;
                } else {
                    y1 = this.bounds.y;
                    y = y2 = this.bounds.y + this.bounds.height - 10 - this.MISSING_BIN_HEIGHT - 5;
                }
            } else if (this.transformObject.isReverse(1)) {
                y = y1 = (int)pt1[1] - 5;
                y2 = this.bounds.y + this.bounds.height;
            } else {
                y1 = this.bounds.y;
                y = y2 = (int)pt1[1] + 5;
            }
            x = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, x));
            y = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, y));
            x1 = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, x1));
            y1 = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, y1));
            x2 = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, x2));
            y2 = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, y2));
            g.drawLine(x1, y, x2, y);
            g.drawLine(x, y1, x, y2);
        } else if (this.isVertical()) {
            int x1 = this.isSingleValue((ContinuousRange)this.xDataRange) ? (this.transformObject.isReverse(0) ? this.bounds.x + this.bounds.width - 10 - this.MISSING_BIN_WIDTH : this.bounds.x + 10 + this.MISSING_BIN_WIDTH + 5) : (this.transformObject.isReverse(0) ? (int)pt1[0] + 5 : (int)pt1[0] - 5);
            x1 = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, x1));
            g.drawLine(x1, this.bounds.y, x1, this.bounds.y + this.bounds.height);
        } else {
            int y1 = this.isSingleValue((ContinuousRange)this.yDataRange) ? (this.transformObject.isReverse(1) ? this.bounds.y + 10 + this.MISSING_BIN_HEIGHT + 5 : this.bounds.y + this.bounds.height - 10 - this.MISSING_BIN_HEIGHT - 5) : (this.transformObject.isReverse(1) ? (int)pt1[1] - 5 : (int)pt1[1] + 5);
            y1 = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, y1));
            g.drawLine(this.bounds.x, y1, this.bounds.x + this.bounds.width, y1);
        }
        if (g2 != null) {
            g2.setStroke(s);
        }
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            return;
        }
        double[] pt1 = new double[3];
        double[] pt2 = new double[3];
        Color selectionColor = this.style.getFillStyleElement("Selection").getFillColor();
        TexturePaint tp = null;
        FillPattern fillPattern = new FillPattern();
        tp = fillPattern.getHatch45(selectionColor);
        Paint prevPaint = null;
        Graphics2D g2 = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            prevPaint = g2.getPaint();
        }
        Integer missingBinId = new Integer(-3);
        Rectangle r = new Rectangle();
        LinkedHashMap binSelectionCount = this.buildBinSelectionCountMap(this.selections);
        if (this.bivariate) {
            Set s = binSelectionCount.keySet();
            Iterator it = s.iterator();
            while (it != null && it.hasNext()) {
                Object xBinId = it.next();
                LinkedHashMap bsc2 = (LinkedHashMap)binSelectionCount.get(xBinId);
                Bin xBin = (Bin)this.xBins.get(xBinId);
                if (xBin == null && !missingBinId.equals(xBinId)) continue;
                Set s2 = bsc2.keySet();
                Iterator it2 = s2.iterator();
                while (it2 != null && it2.hasNext()) {
                    Object yBinId = it2.next();
                    Bin yBin = (Bin)this.yBins.get(yBinId);
                    if (yBin == null && !missingBinId.equals(yBinId)) continue;
                    double count = 0.0;
                    if (missingBinId.equals(xBinId) || missingBinId.equals(yBinId)) {
                        if (!this.missingBinOn) continue;
                        r = this.getMissingBinScreenRectangle(xBin, yBin, pt1, pt2, r);
                        if (xBin == null && yBin == null) {
                            count = this.missingValues;
                        } else if (xBin == null && yBin != null) {
                            count = this.missingXBinValues[yBin.getIndex()];
                        } else if (xBin != null && yBin == null) {
                            count = this.missingYBinValues[xBin.getIndex()];
                        }
                    } else {
                        r = this.getBinScreenRectangle(xBin, yBin, pt1, pt2, r);
                        count = this.bivariateBinValues[xBin.getIndex()][yBin.getIndex()];
                    }
                    if (!this.isValidCount(count)) continue;
                    double selectionCount = ((Number)bsc2.get(yBinId)).doubleValue();
                    double ratio = selectionCount / count;
                    double yStart = (double)r.y + (1.0 - ratio) * (double)r.height;
                    double yHeight = ratio * (double)r.height;
                    if (g2 == null) {
                        g.setColor(selectionColor);
                    } else {
                        g2.setPaint(tp);
                    }
                    g.fillRect(r.x, (int)yStart, r.width, (int)yHeight);
                    g.setColor(selectionColor);
                    g.drawRect(r.x, (int)yStart, r.width, (int)yHeight);
                }
            }
        } else {
            Bin b = new Bin();
            Set s = binSelectionCount.keySet();
            Iterator it = s.iterator();
            while (it != null && it.hasNext()) {
                Object binId = it.next();
                double selectionCount = ((Number)binSelectionCount.get(binId)).doubleValue();
                if (missingBinId.equals(binId)) {
                    if (!(this.missingValues > 0.0) || !this.missingBinOn) continue;
                    r = this.getMissingBinScreenRectangle(null, null, pt1, pt2, r);
                    int ht = (int)(selectionCount / this.missingValues * (double)r.height);
                    r.y += r.height - ht;
                    r.height = ht;
                } else {
                    Bin xBin = (Bin)this.xBins.get(binId);
                    if (xBin == null) continue;
                    b.setMin(xBin.getMin());
                    b.setMax(xBin.getMax());
                    b.setCount(selectionCount);
                    r = this.getBinScreenRectangle(b, null, pt1, pt2, r);
                }
                if (g2 == null) {
                    g.setColor(selectionColor);
                } else {
                    g2.setPaint(tp);
                }
                g.fillRect(r.x, r.y, r.width, r.height);
                g.setColor(selectionColor);
                g.drawRect(r.x, r.y, r.width, r.height);
            }
            this.drawBaseLine(g);
        }
        if (g2 != null) {
            g2.setPaint(prevPaint);
        }
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        Rectangle selectArea = null;
        if (this.roles.getVariable((Object)this.xRole, 0) == null) {
            return false;
        }
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        DataRange[] ranges = null;
        String[] vars = null;
        ContinuousRange xcr = null;
        ContinuousRange ycr = null;
        xcr = new ContinuousRange(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        if (this.bivariate) {
            vars = new String[]{this.roles.getVariable((Object)this.xRole, 0).toString(), this.roles.getVariable((Object)this.yRole, 0).toString()};
            ranges = new DataRange[2];
            ycr = new ContinuousRange(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
            ranges[0] = xcr;
            ranges[1] = ycr;
        } else {
            vars = new String[]{this.roles.getVariable((Object)this.xRole, 0).toString()};
            ranges = new DataRange[]{xcr};
        }
        boolean extSel = this.isExtendedSelectMode(event);
        this.selectWorker.setExtendedSelect(extSel);
        this.selectWorker.init(selectArea, vars, ranges, xcr, ycr, select, this.xBoundary, this.yBoundary);
        this.doTheWork(this.selectWorker);
        this.selectMissingInLayer(select, selectArea, extSel);
        return false;
    }

    protected void selectMissingInLayer(boolean select, Rectangle selectArea, boolean extSel) {
        if (!this.missingBinOn) {
            return;
        }
        if (this.roles.getVariable((Object)this.xRole, 0) == null) {
            return;
        }
        String[] vars = null;
        DataRange[] ranges = null;
        String xnan = this.getFormattedValue(this.roles.getVariable((Object)this.xRole, 0), new Double(Double.NaN));
        DiscreteRange xdr = new DiscreteRange(new Object[]{xnan});
        DiscreteRange ydr = null;
        if (this.bivariate) {
            vars = new String[]{this.roles.getVariable((Object)this.xRole, 0).toString(), this.roles.getVariable((Object)this.yRole, 0).toString()};
            ranges = new DataRange[2];
            String ynan = this.getFormattedValue(this.roles.getVariable((Object)this.yRole, 0), new Double(Double.NaN)).toString();
            ydr = new DiscreteRange(new Object[]{ynan});
        } else {
            vars = new String[]{this.roles.getVariable((Object)this.xRole, 0).toString()};
            ranges = new DataRange[1];
        }
        this.selectMissingWorker.setExtendedSelect(extSel);
        this.selectMissingWorker.init(selectArea, vars, ranges, xdr, ydr, select, this.xBoundary, this.yBoundary);
        this.doTheWorkForMissingBins(this.selectMissingWorker);
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        if (this.pickArea == null) {
            this.pickArea = new Rectangle();
        }
        this.pickArea.x = screenX - 1;
        this.pickArea.y = screenY - 1;
        this.pickArea.width = 3;
        this.pickArea.height = 3;
        this.tipTextWorker.init(this.pickArea);
        Object o = this.doTheWork(this.tipTextWorker);
        if (o != null) {
            return o.toString();
        }
        o = this.doTheWorkForMissingBins(this.tipTextWorker);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    @Override
    protected Hashtable getDrilldownInfo(int screenX, int screenY) {
        if (this.pickArea == null) {
            this.pickArea = new Rectangle();
        }
        this.pickArea.x = screenX - 1;
        this.pickArea.y = screenY - 1;
        this.pickArea.width = 3;
        this.pickArea.height = 3;
        this.drillDownWorker.init(this.pickArea);
        Object o = this.doTheWork(this.drillDownWorker);
        if (o instanceof Hashtable) {
            return (Hashtable)o;
        }
        o = this.doTheWorkForMissingBins(this.drillDownWorker);
        if (o instanceof Hashtable) {
            return (Hashtable)o;
        }
        return null;
    }

    protected boolean isValidCount(double count) {
        return count > 0.0 && !Double.isNaN(count);
    }

    protected Object doTheWork(Worker worker) {
        double[] pt1 = new double[3];
        double[] pt2 = new double[3];
        if (this.xBins == null || this.xBins.size() == 0) {
            return null;
        }
        Rectangle r = new Rectangle();
        if (this.bivariate) {
            if (this.bivariateBinValues == null) {
                return null;
            }
            for (int i = 0; i < this.xBins.size(); ++i) {
                Integer xBinId = new Integer(i);
                Bin xBin = (Bin)this.xBins.get(xBinId);
                if (xBin == null) continue;
                for (int j = 0; j < this.yBins.size(); ++j) {
                    Integer yBinId = new Integer(j);
                    Bin yBin = (Bin)this.yBins.get(yBinId);
                    if (yBin == null || !this.isValidCount(this.bivariateBinValues[i][j])) continue;
                    r = this.getBinScreenRectangle(xBin, yBin, pt1, pt2, r);
                    worker.doWorkInLoop(r, this.bivariateBinValues[i][j], xBin, yBin);
                    if (!worker.isWorkDone()) continue;
                    return worker.getResult();
                }
            }
            worker.doWorkAtLoopEnd();
        } else {
            if (this.univariateBinValues == null) {
                return null;
            }
            for (int i = 0; i < this.xBins.size(); ++i) {
                double count;
                Integer binId = new Integer(i);
                Bin b = (Bin)this.xBins.get(binId);
                if (b == null || !this.isValidCount(count = this.univariateBinValues[i])) continue;
                r = this.getBinScreenRectangle(b, null, pt1, pt2, r);
                worker.doWorkInLoop(r, count, b, null);
                if (!worker.isWorkDone()) continue;
                return worker.getResult();
            }
            worker.doWorkAtLoopEnd();
            if (worker.isWorkDone()) {
                return worker.getResult();
            }
        }
        return null;
    }

    protected Object doTheWorkForMissingBins(Worker worker) {
        if (!this.missingBinOn) {
            return null;
        }
        double[] pt1 = new double[3];
        double[] pt2 = new double[3];
        Rectangle r = new Rectangle();
        if (this.bivariate) {
            int i;
            r = this.getMissingBinScreenRectangle(null, null, pt1, pt2, r);
            if (this.missingValues > 0.0) {
                worker.doWorkInLoop(r, this.missingValues, null, null);
                if (worker.isWorkDone()) {
                    return worker.getResult();
                }
            }
            if (this.missingXBinValues != null) {
                for (i = 0; i < this.missingXBinValues.length; ++i) {
                    Integer yBinId = new Integer(i);
                    Bin yBin = (Bin)this.yBins.get(yBinId);
                    if (!(this.missingXBinValues[i] > 0.0) || yBin == null) continue;
                    r = this.getMissingBinScreenRectangle(null, yBin, pt1, pt2, r);
                    worker.doWorkInLoop(r, this.missingXBinValues[i], null, yBin);
                    if (!worker.isWorkDone()) continue;
                    return worker.getResult();
                }
            }
            if (this.missingYBinValues != null) {
                for (i = 0; i < this.missingYBinValues.length; ++i) {
                    Integer xBinId = new Integer(i);
                    Bin xBin = (Bin)this.xBins.get(xBinId);
                    if (!(this.missingYBinValues[i] > 0.0) || xBin == null) continue;
                    r = this.getMissingBinScreenRectangle(xBin, null, pt1, pt2, r);
                    worker.doWorkInLoop(r, this.missingYBinValues[i], xBin, null);
                    if (!worker.isWorkDone()) continue;
                    return worker.getResult();
                }
            }
            worker.doWorkAtLoopEnd();
            if (worker.isWorkDone()) {
                return worker.getResult();
            }
        } else if (this.missingValues > 0.0) {
            r = this.getMissingBinScreenRectangle(null, null, pt1, pt2, r);
            worker.doWorkInLoop(r, this.missingValues, null, null);
            if (worker.isWorkDone()) {
                return worker.getResult();
            }
            worker.doWorkAtLoopEnd();
            if (worker.isWorkDone()) {
                return worker.getResult();
            }
        }
        return null;
    }

    protected void drawBaseLine(Graphics g) {
        Color lineColor = this.style.getLineStyleElement("AxisLines").getLineColor();
        double[] pt1 = new double[3];
        pt1 = this.transformObject.project(0.0, 0.0, 0.0, pt1);
        g.setColor(lineColor);
        if (this.isVertical()) {
            g.drawLine(this.bounds.x, (int)pt1[1], this.bounds.x + this.bounds.width, (int)pt1[1]);
        } else {
            g.drawLine((int)pt1[0], this.bounds.y, (int)pt1[0], this.bounds.y + this.bounds.height);
        }
    }

    protected Rectangle getBinScreenRectangle(Bin xBin, Bin yBin, double[] pt1, double[] pt2, Rectangle r) {
        int yMid;
        int ySize;
        int xMid;
        int xSize;
        if (this.bivariate) {
            Bin yAxisBin;
            Bin xAxisBin;
            if (this.isVertical()) {
                xAxisBin = xBin;
                yAxisBin = yBin;
            } else {
                xAxisBin = yBin;
                yAxisBin = xBin;
            }
            pt1 = this.transformObject.project(xAxisBin.getMin(), yAxisBin.getMax(), 0.0, pt1);
            pt2 = this.transformObject.project(xAxisBin.getMax(), yAxisBin.getMin(), 0.0, pt2);
            xSize = this.getScreenSpacing((byte)1, xAxisBin.getMin(), xAxisBin.getMax());
            xMid = (int)((pt1[0] + pt2[0]) / 2.0);
            ySize = this.getScreenSpacing((byte)2, yAxisBin.getMin(), yAxisBin.getMax());
            yMid = (int)((pt1[1] + pt2[1]) / 2.0);
        } else {
            if (!this.isValidCount(xBin.getCount())) {
                r.width = 0;
                r.height = 0;
                return r;
            }
            double resp = this.computePercentage(xBin.getCount());
            if (this.isVertical()) {
                pt1 = this.transformObject.project(xBin.getMin(), resp, 0.0, pt1);
                pt2 = this.transformObject.project(xBin.getMax(), 0.0, 0.0, pt2);
                xSize = this.getScreenSpacing((byte)1, xBin.getMin(), xBin.getMax());
                ySize = (int)Math.abs(pt2[1] - pt1[1]);
            } else {
                pt1 = this.transformObject.project(0.0, xBin.getMax(), 0.0, pt1);
                pt2 = this.transformObject.project(resp, xBin.getMin(), 0.0, pt2);
                xSize = (int)Math.abs(pt2[0] - pt1[0]);
                ySize = this.getScreenSpacing((byte)2, xBin.getMin(), xBin.getMax());
            }
            xMid = (int)((pt1[0] + pt2[0]) / 2.0);
            yMid = (int)((pt1[1] + pt2[1]) / 2.0);
        }
        if (r == null) {
            r = new Rectangle();
        }
        if (pt1[0] == pt2[0]) {
            r.x = xMid - xSize / 2;
            r.width = xSize;
        } else {
            r.x = (int)Math.min(pt1[0], pt2[0]);
            r.width = this.transformObject.isReverse(0) ? (int)Math.abs(pt1[0] - (double)((int)pt2[0])) : (int)Math.abs(pt2[0] - (double)((int)pt1[0]));
        }
        if (pt1[1] == pt2[1]) {
            r.y = yMid - ySize / 2;
            r.height = ySize;
        } else {
            r.y = (int)Math.min(pt1[1], pt2[1]);
            r.height = this.transformObject.isReverse(1) ? (int)Math.abs(pt1[1] - (double)((int)pt2[1])) : (int)Math.abs(pt2[1] - (double)((int)pt1[1]));
        }
        return r;
    }

    protected Rectangle getMissingBinScreenRectangle(Bin xBin, Bin yBin, double[] pt1, double[] pt2, Rectangle r) {
        if (r == null) {
            r = new Rectangle();
        }
        if (this.xDataRange == null || this.yDataRange == null) {
            return r;
        }
        if (this.bivariate) {
            pt1 = this.transformObject.project(((ContinuousRange)this.xDataRange).getMin(), ((ContinuousRange)this.yDataRange).getMin(), 0.0, pt1);
            int x = this.isSingleValue((ContinuousRange)this.xDataRange) ? (this.transformObject.isReverse(0) ? this.bounds.x + this.bounds.width - 10 - this.MISSING_BIN_WIDTH : this.bounds.x + 10) : (this.transformObject.isReverse(0) ? (int)pt1[0] + 10 : (int)pt1[0] - 10 - this.MISSING_BIN_WIDTH);
            int y = this.isSingleValue((ContinuousRange)this.yDataRange) ? (this.transformObject.isReverse(1) ? this.bounds.y + 10 : this.bounds.y + this.bounds.height - 10 - this.MISSING_BIN_HEIGHT) : (this.transformObject.isReverse(1) ? (int)pt1[1] - 10 - this.MISSING_BIN_HEIGHT : (int)pt1[1] + 10);
            int width = this.MISSING_BIN_WIDTH;
            int height = this.MISSING_BIN_HEIGHT;
            if (xBin == null && yBin == null) {
                r.x = x;
                r.y = y;
                r.width = width;
                r.height = height;
            } else if (xBin == null && yBin != null) {
                r = this.getBinScreenRectangle(this.dummyBin, yBin, pt1, pt2, r);
                if (this.isVertical()) {
                    r.x = x;
                    r.width = width;
                } else {
                    r.y = y;
                    r.height = height;
                }
            } else if (xBin != null && yBin == null) {
                r = this.getBinScreenRectangle(xBin, this.dummyBin, pt1, pt2, r);
                if (this.isVertical()) {
                    r.y = y;
                    r.height = height;
                } else {
                    r.x = x;
                    r.width = width;
                }
            }
        } else {
            if (Double.isNaN(this.missingValues)) {
                return r;
            }
            double mv = this.computePercentage(this.missingValues);
            Bin firstXBin = (Bin)this.xBins.get(new Integer(0));
            if (firstXBin != null) {
                if (this.isVertical()) {
                    pt1 = this.transformObject.project(firstXBin.getMin(), mv, 0.0, pt1);
                    pt2 = this.transformObject.project(((ContinuousRange)this.xDataRange).getMin(), 0.0, 0.0, pt2);
                    r.x = this.isSingleValue((ContinuousRange)this.xDataRange) ? (this.transformObject.isReverse(0) ? this.bounds.x + this.bounds.width - 10 - this.MISSING_BIN_WIDTH : this.bounds.x + 10) : (this.transformObject.isReverse(0) ? (int)pt2[0] + 10 : (int)pt2[0] - this.MISSING_BIN_WIDTH - 10);
                    r.y = this.transformObject.isReverse(1) ? (int)pt2[1] : (int)pt1[1];
                    r.width = this.MISSING_BIN_WIDTH;
                    r.height = (int)Math.abs(pt2[1] - (double)((int)pt1[1]));
                } else {
                    pt1 = this.transformObject.project(mv, firstXBin.getMin(), 0.0, pt1);
                    pt2 = this.transformObject.project(0.0, ((ContinuousRange)this.yDataRange).getMin(), 0.0, pt2);
                    r.y = this.isSingleValue((ContinuousRange)this.yDataRange) ? (this.transformObject.isReverse(1) ? this.bounds.y + 10 : this.bounds.y + this.bounds.height - 10 - this.MISSING_BIN_HEIGHT) : (this.transformObject.isReverse(1) ? (int)pt2[1] - this.MISSING_BIN_HEIGHT - 10 : (int)pt2[1] + 10);
                    r.x = this.transformObject.isReverse(0) ? (int)pt1[0] : (int)pt2[0];
                    r.width = (int)Math.abs(pt2[0] - (double)((int)pt1[0]));
                    r.height = this.MISSING_BIN_HEIGHT;
                }
            }
        }
        return r;
    }

    @Override
    public void setDataRange(byte dim, int index, DataRange range) {
        super.setDataRange(dim, index, range);
        boolean buildCalled = false;
        if (this.hasRangeChanged(dim)) {
            this.rebuildRequired = true;
            this.build(Boolean.TRUE);
            buildCalled = true;
        }
        if (!buildCalled) {
            boolean fireEvent = false;
            if (this.isVertical()) {
                if (1 == dim || this.bivariate && 2 == dim) {
                    fireEvent = true;
                }
            } else if (2 == dim || this.bivariate && 1 == dim) {
                fireEvent = true;
            }
            if (fireEvent) {
                this.fireLayerListenerChanged(8);
            }
        }
        if (dim == 1 || dim == 2) {
            this.computeErrorThresholds();
        }
    }

    protected boolean hasRangeChanged(byte dim) {
        return this.isVertical() ? (dim == 1 ? !this.verifyBinExtents(this.xBinStart, this.xBinEnd, (ContinuousRange)this.xDataRange, this.xBinNames) : dim == 2 && this.bivariate && !this.verifyBinExtents(this.yBinStart, this.yBinEnd, (ContinuousRange)this.yDataRange, this.yBinNames)) : (dim == 1 && this.bivariate ? !this.verifyBinExtents(this.yBinStart, this.yBinEnd, (ContinuousRange)this.xDataRange, this.yBinNames) : dim == 2 && !this.verifyBinExtents(this.xBinStart, this.xBinEnd, (ContinuousRange)this.yDataRange, this.yBinNames));
    }

    protected boolean verifyBinExtents(double binStart, double binEnd, ContinuousRange dataRange, double[] binNames) {
        if (dataRange == null) {
            return false;
        }
        return !(binNames != null ? binStart != binNames[0] || binEnd != binNames[binNames.length - 1] : binStart != dataRange.getMin() || binEnd != dataRange.getMax());
    }

    protected String getTipText(Bin xBin, Bin yBin, double value) {
        if (this.filter == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Message binMessage = new Message(ResourceLoader.getResourceString((Object)this.rbHist, (String)"Histogram.BinRange.fmt.txt", (String)"{0} = [{1}, {2}]"));
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Object desc = this.filter.getVariableDescription(xVar);
        if (xBin != null) {
            sb.append(binMessage.toString(new Object[]{desc, this.getFormattedValue(xVar, new Double(xBin.getMin())), this.getFormattedValue(xVar, new Double(xBin.getMax()))}));
        } else {
            sb.append(desc);
            sb.append(" \t= \t");
            sb.append(this.getFormattedValue(xVar, new Double(Double.NaN)));
        }
        sb.append(" \n");
        if (this.bivariate) {
            Object yVar = this.roles.getVariable((Object)this.yRole, 0);
            desc = this.filter.getVariableDescription(yVar);
            if (yBin != null) {
                sb.append(binMessage.toString(new Object[]{desc, this.getFormattedValue(yVar, new Double(yBin.getMin())), this.getFormattedValue(yVar, new Double(yBin.getMax()))}));
            } else {
                sb.append(desc);
                sb.append(" \t= \t");
                sb.append(this.getFormattedValue(yVar, new Double(Double.NaN)));
            }
            sb.append("\n");
        }
        sb.append(this.getStatTipValue(value));
        String other = this.getAdditionalTipText(xBin, yBin, value);
        if (other != null) {
            sb.append(other);
        }
        return sb.toString().replaceAll("\\[", "\t \t\\[");
    }

    protected boolean isSingleValue(ContinuousRange range) {
        if (range.getMin() == range.getMax()) {
            return true;
        }
        return Double.isNaN(range.getMin()) || Double.isNaN(range.getMax());
    }

    @Override
    protected int getScreenSpacing(byte dimension, double v1, double v2) {
        int size = super.getScreenSpacing(dimension, v1, v2);
        if (this.missingBinOn) {
            if (v1 == v2) {
                size /= 2;
            }
            size -= 20;
        }
        return size;
    }

    protected void dataSelection(DvrDataFilterEvent e) {
        this.fireLayerListenerChanged(2);
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                if (!(value instanceof SILKNumber)) break;
                this.currentLegend = (SILKNumber)((Object)value);
                return true;
            }
        }
        return rc;
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 19061: {
                rc = this.bivariate || !this.isVertical() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 19059: {
                rc = this.bivariate || !this.isVertical() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 19060: {
                rc = this.bivariate || this.isVertical() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 19058: {
                rc = this.bivariate || this.isVertical() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 19057: {
                rc = new Object[]{this.isVertical() ? RoleInterface.ROLE_X : RoleInterface.ROLE_Y};
                break;
            }
            case 19056: {
                rc = new Object[]{this.isVertical() ? RoleInterface.ROLE_Y : RoleInterface.ROLE_X};
                break;
            }
            case 19070: {
                this.checkBuildState();
                if (!this.binAxis) break;
                if (this.isVertical()) {
                    rc = this.getTicks(this.xBins, this.numberOfBins_X, this.xBinStart, this.xBinEnd, this.xBinWidth, this.xBinNames, (ContinuousRange)this.xDataRange);
                    break;
                }
                if (this.isVertical() || !this.bivariate) break;
                rc = this.getTicks(this.yBins, this.numberOfBins_Y, this.yBinStart, this.yBinEnd, this.yBinWidth, this.yBinNames, (ContinuousRange)this.xDataRange);
                break;
            }
            case 19071: {
                this.checkBuildState();
                if (!this.binAxis) break;
                if (!this.isVertical()) {
                    rc = this.getTicks(this.xBins, this.numberOfBins_X, this.xBinStart, this.xBinEnd, this.xBinWidth, this.xBinNames, (ContinuousRange)this.yDataRange);
                    break;
                }
                if (!this.isVertical() || !this.bivariate) break;
                rc = this.getTicks(this.yBins, this.numberOfBins_Y, this.yBinStart, this.yBinEnd, this.yBinWidth, this.yBinNames, (ContinuousRange)this.yDataRange);
                break;
            }
            case 19065: {
                if (this.bivariate || !this.isVertical() || SILKGlobal.isFlagSet(4)) {
                    rc = Boolean.FALSE;
                    break;
                }
                rc = Boolean.TRUE;
                break;
            }
            case 19064: {
                if (this.bivariate || this.isVertical() || SILKGlobal.isFlagSet(4)) {
                    rc = Boolean.FALSE;
                    break;
                }
                rc = Boolean.TRUE;
                break;
            }
            case 19083: {
                rc = this.bivariate || this.isVertical() ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case 19082: {
                rc = this.bivariate || !this.isVertical() ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case 834: {
                rc = Boolean.TRUE;
                break;
            }
            case 833: {
                rc = Boolean.TRUE;
                break;
            }
            case 807: {
                rc = this.isMissingBinOn() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 826: {
                rc = this.isBinAxis() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 827: {
                rc = this.areEndLabelsOn() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 810: {
                rc = this.xBinNames != null ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 811: {
                rc = this.yBinNames != null || !this.bivariate ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 824: {
                rc = this.xBinNames;
                break;
            }
            case 803: {
                rc = this.areOutlinesOn() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 819: {
                rc = this.isGradientOn() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 836: {
                rc = this.bivariate ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case 53: {
                rc = this.isRoleSet(RoleInterface.ROLE_Y) ? this.rampName : null;
                break;
            }
            case 434: {
                rc = null;
                break;
            }
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 24: 
            case 25: {
                rc = this.getLegendDisplayNames();
                break;
            }
            case 433: {
                rc = this.getLegendEntries();
                break;
            }
            case 444: {
                rc = this.getOverlayLegendEntry();
                break;
            }
            case 426: {
                rc = this.getLegendTitleText();
                break;
            }
            case 441: {
                rc = Boolean.TRUE;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 807: {
                if (!(value instanceof Boolean)) break;
                this.setMissingBinOn((Boolean)value);
                break;
            }
            case 826: {
                if (!(value instanceof Boolean)) break;
                this.setBinAxis((Boolean)value);
                break;
            }
            case 827: {
                if (!(value instanceof Boolean)) break;
                this.setEndLabelsOn((Boolean)value);
                break;
            }
            case 803: {
                if (!(value instanceof Boolean)) break;
                this.setOutlinesOn((Boolean)value);
                break;
            }
            case 819: {
                if (!(value instanceof Boolean)) break;
                this.setGradientOn((Boolean)value);
                break;
            }
            case 824: {
                if (!(value instanceof double[])) break;
                this.setXBinNames((double[])value);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public DataRange getDataRange(byte dimension, boolean globalRange) {
        if (4 == dimension && this.bivariateBinValues != null) {
            int i;
            double min = 0.0;
            double max = 0.0;
            for (i = 0; i < this.bivariateBinValues.length; ++i) {
                for (int j = 0; j < this.bivariateBinValues[i].length; ++j) {
                    if (!this.isValidCount(this.bivariateBinValues[i][j])) continue;
                    max = Math.max(this.bivariateBinValues[i][j], max);
                }
            }
            if (this.missingBinOn) {
                if (this.isValidCount(this.missingValues)) {
                    max = Math.max(this.missingValues, max);
                }
                if (this.missingXBinValues != null) {
                    for (i = 0; i < this.missingXBinValues.length; ++i) {
                        if (!this.isValidCount(this.missingXBinValues[i])) continue;
                        max = Math.max(this.missingXBinValues[i], max);
                    }
                }
                if (this.missingYBinValues != null) {
                    for (i = 0; i < this.missingYBinValues.length; ++i) {
                        if (!this.isValidCount(this.missingYBinValues[i])) continue;
                        max = Math.max(this.missingYBinValues[i], max);
                    }
                }
            }
            max = this.computePercentage(max);
            return new ContinuousRange(min, max);
        }
        return super.getDataRange(dimension, globalRange);
    }

    @Override
    protected void layoutChart() {
        super.layoutChart();
        this.checkInnerMargin();
    }

    protected void checkInnerMargin() {
        if (this.prefInnerMargin == null) {
            return;
        }
        int offsetLeft = 0;
        int offsetRight = 0;
        int offsetBottom = 0;
        int offsetTop = 0;
        boolean fireEvent = false;
        if (this.missingBinOn && this.buildSuccess) {
            if (this.isVertical()) {
                int xBins = this.numberOfBins_X != 0 ? this.numberOfBins_X : 10;
                int yBins = this.numberOfBins_Y != 0 ? this.numberOfBins_Y : 10;
                this.MISSING_BIN_WIDTH = (this.bounds.width - 20) / (xBins + 1);
                this.MISSING_BIN_HEIGHT = (this.bounds.height - 20) / (yBins + 1);
                if (this.transformObject != null && this.transformObject.isReverse(0)) {
                    offsetRight = this.MISSING_BIN_WIDTH + 20;
                } else {
                    offsetLeft = this.MISSING_BIN_WIDTH + 20;
                }
                if (this.bivariate) {
                    if (this.transformObject != null && this.transformObject.isReverse(1)) {
                        offsetTop = this.MISSING_BIN_HEIGHT + 20;
                    } else {
                        offsetBottom = this.MISSING_BIN_HEIGHT + 20;
                    }
                } else if (this.transformObject != null && this.transformObject.isReverse(1)) {
                    offsetBottom = 5;
                } else {
                    offsetTop = 5;
                }
            } else {
                this.MISSING_BIN_WIDTH = (this.bounds.width - 20) / (this.numberOfBins_Y + 1);
                this.MISSING_BIN_HEIGHT = (this.bounds.height - 20) / (this.numberOfBins_X + 1);
                if (this.transformObject != null && this.transformObject.isReverse(1)) {
                    offsetTop = this.MISSING_BIN_HEIGHT + 20;
                } else {
                    offsetBottom = this.MISSING_BIN_HEIGHT + 20;
                }
                if (this.bivariate) {
                    if (this.transformObject != null && this.transformObject.isReverse(0)) {
                        offsetRight = this.MISSING_BIN_WIDTH + 20;
                    } else {
                        offsetLeft = this.MISSING_BIN_WIDTH + 20;
                    }
                } else if (this.transformObject != null && this.transformObject.isReverse(0)) {
                    offsetLeft = 5;
                } else {
                    offsetRight = 5;
                }
            }
        }
        if (this.prefInnerMargin.top != offsetTop || this.prefInnerMargin.bottom != offsetBottom || this.prefInnerMargin.right != offsetRight || this.prefInnerMargin.left != offsetLeft) {
            fireEvent = true;
        }
        this.prefInnerMargin.top = offsetTop;
        this.prefInnerMargin.left = offsetLeft;
        this.prefInnerMargin.bottom = offsetBottom;
        this.prefInnerMargin.right = offsetRight;
        if (fireEvent) {
            this.fireMarginChanged(new MarginChangeEvent((Object)this));
        }
    }

    protected Object[] getTicks(LinkedHashMap bins, int nBins, double binStart, double binEnd, double binWidth, double[] binNames, ContinuousRange range) {
        if (bins == null || bins.size() < 1 || binStart == binEnd) {
            return null;
        }
        Object[] ticks = null;
        if (this.endLabelsOn) {
            ticks = new Object[nBins + 1];
            for (int i = 0; i < nBins; ++i) {
                Bin b = (Bin)bins.get(new Integer(i));
                ticks[i + 1] = new Double(b.getMax());
                if (i != 0) continue;
                ticks[i] = new Double(b.getMin());
            }
        } else {
            ticks = new Object[nBins];
            for (int i = 0; i < nBins; ++i) {
                Bin b = (Bin)bins.get(new Integer(i));
                double mid = (b.getMin() + b.getMax()) / 2.0;
                ticks[i] = new Double(mid);
            }
        }
        return ticks;
    }

    protected Object[] getLegendDisplayNames() {
        if (this.bivariate && this.currentLegend != null && this.currentLegend.getEnglishName().equalsIgnoreCase(this.getLegendName().getEnglishName())) {
            return new Object[]{this.currentLegend};
        }
        return null;
    }

    protected Object getLegendTitleText() {
        if (this.currentLegend != null && this.currentLegend.toString().equalsIgnoreCase(this.getLegendDisplayName())) {
            return this.currentLegend;
        }
        return null;
    }

    protected Vector getLegendEntries() {
        int yVarIndex;
        if (this.currentLegend != null && this.currentLegend.equals((Object)this.getLegendName()) && (yVarIndex = this.filter.getVariableIndex(this.roles.getVariable(this.yRole.toString(), 0))) >= 0) {
            if (this.colorMapper == null) {
                this.initColorRamp();
            }
            if (this.colorMapper == null) {
                return null;
            }
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
            ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4, false);
            if (r == null) {
                return null;
            }
            Color c = this.colorMapper.getColor(r.getMin());
            double cv = r.getMin();
            MarkerAttrib msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            c = this.colorMapper.getNeutralColor();
            if (c != null && r.contains((DataPoint)new ContinuousPoint(this.colorMapper.getNeutralValue()))) {
                cv = this.colorMapper.getNeutralValue();
                msi = new MarkerAttrib(true, c);
                legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            }
            c = this.colorMapper.getColor(r.getMax());
            cv = r.getMax();
            msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            return legendEntries;
        }
        return null;
    }

    @Override
    protected Color getMappedColor(double binValue) {
        if (this.filter == null || this.infoFilter == null) {
            return null;
        }
        if (this.colorMapper == null) {
            this.initColorRamp();
        }
        if (this.colorMapper != null) {
            return this.colorMapper.getColor(binValue);
        }
        return null;
    }

    public boolean isMissingBinOn() {
        return this.missingBinOn;
    }

    public void setMissingBinOn(boolean missingBinOn) {
        this.missingBinOn = missingBinOn;
        this.userSetProperties.set(807);
        if (this.bivariate) {
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
        } else {
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        }
    }

    public boolean areOutlinesOn() {
        return this.outlinesOn;
    }

    public void setOutlinesOn(boolean outlinesOn) {
        this.outlinesOn = outlinesOn;
        this.userSetProperties.set(803);
    }

    public boolean isGradientOn() {
        return this.gradientOn;
    }

    public void setGradientOn(boolean gradientOn) {
        this.gradientOn = gradientOn;
        this.userSetProperties.set(819);
    }

    public boolean isBinAxis() {
        return this.binAxis;
    }

    public void setBinAxis(boolean binAxis) {
        this.setBinAxis(binAxis, true);
    }

    protected void setBinAxis(boolean binAxis, boolean fireEvent) {
        this.binAxis = binAxis;
        this.userSetProperties.set(826);
        if (fireEvent) {
            this.fireLayerListenerChanged(7);
        }
    }

    public boolean areEndLabelsOn() {
        return this.endLabelsOn;
    }

    public void setEndLabelsOn(boolean endLabels) {
        this.setEndLabelsOn(endLabels, true);
    }

    protected void setEndLabelsOn(boolean endLabels, boolean fireEvent) {
        this.endLabelsOn = endLabels;
        this.userSetProperties.set(827);
        if (fireEvent) {
            this.fireLayerListenerChanged(7);
        }
    }

    protected boolean intersects(Rectangle r1, Rectangle r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r2.width > 0 && r2.height > 0) {
            return r1.intersects(r2);
        }
        if (r2.width == 0 && r2.height == 0) {
            return false;
        }
        if (r2.width == 0) {
            r2.width = 1;
            boolean rc = r1.intersects(r2);
            r2.width = 0;
            return rc;
        }
        if (r2.height == 0) {
            r2.height = 1;
            boolean rc = r1.intersects(r2);
            r2.height = 0;
            return rc;
        }
        return false;
    }

    protected void resetChart() {
        this.xDataRange = null;
        this.yDataRange = null;
        this.clearUniVariateBins();
        this.clearBiVariateBins();
        this.rebuildRequired = true;
    }

    public Color getBinColor() {
        StyleElement element = SILKUtilities.getStyleElement(null, -1, 1, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false));
        return element.getAsDataStyle().getFillColor();
    }

    public boolean setBinColor(Color color) {
        if (color == null) {
            return false;
        }
        StyleElement overrides = this.fillAttrs.getOverrides(true);
        overrides.setAttribute("lineColor", HTMLColors.getColorString((Color)this.getColor(color)));
        overrides.setAttribute("color", HTMLColors.getColorString((Color)this.getColor(color)));
        overrides.setAttribute("fillColor", HTMLColors.getColorString((Color)this.getColor(color)));
        if (this.overlayDrawMode) {
            this.fireLayerListenerChanged(4);
        }
        this.fireLayerListenerChanged(1);
        return true;
    }

    @Override
    public void setOverlayIndex(int overlayIndex, int numberLayers) {
        super.setOverlayIndex(overlayIndex, numberLayers);
        this.overlayDrawMode = this.isOverlaid();
        this.opacity = 0.25f / (float)this.getNumberOverlayLayers();
        if (!this.userSetProperties.get(826)) {
            this.binAxis = !this.overlayDrawMode;
        }
        this.lineAttrs.getOverrides(true).setAttribute("lineStyle", "1");
        this.lineAttrs.getOverrides(true).setAttribute("lineThickness", "1");
    }

    protected LegendEntry getOverlayLegendEntry() {
        if (!this.createOverlayLegendEntry) {
            return null;
        }
        StyleElement se = SILKUtilities.getStyleElement(null, -1, 1, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false));
        Color fillColor = se.getAsDataStyle().getFillColor();
        Color lineColor = se.getAsDataStyle().getLineColor();
        if (this.overlayDrawMode) {
            fillColor = this.getTransparentColor(fillColor, this.opacity);
        }
        Object id = this.getId();
        MarkerAttrib marker = new MarkerAttrib();
        marker.setColor(fillColor);
        marker.setOutline(lineColor);
        marker.setOutline(this.areOutlinesOn() ? Boolean.TRUE : Boolean.FALSE);
        marker.setShape(19);
        LegendEntry entry = new LegendEntry(id, marker, null);
        return entry;
    }

    protected void checkBuildState() {
        if (this.rebuildRequired) {
            this.build(Boolean.TRUE);
        }
    }

    public void setOverlayDrawMode(boolean overlayDrawMode) {
        this.overlayDrawMode = overlayDrawMode;
    }

    public void setCreateOverlayLegendEntry(boolean createOverlayLegendEntry) {
        this.createOverlayLegendEntry = createOverlayLegendEntry;
    }

    protected int getOrientation() {
        return this.orientation;
    }

    protected void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    protected boolean isVertical() {
        return this.getOrientation() == 1;
    }

    protected SASFormat getFormat(Object role) {
        if (role == null || this.filter == null) {
            return null;
        }
        Object var = this.roles.getVariable(role, 0);
        return (SASFormat)this.filter.getFormat(var, SASFormat.class);
    }

    protected String getVariableDescription(Object role) {
        if (role == null || this.filter == null) {
            return null;
        }
        Object var = this.roles.getVariable(role, 0);
        if (var == null) {
            return null;
        }
        Object desc = this.filter.getVariableDescription(var);
        if (desc == null) {
            return var.toString();
        }
        return desc.toString();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.drawWorker != null) {
            this.drawWorker.dispose();
        }
        this.drawWorker = null;
        if (this.selectWorker != null) {
            this.selectWorker.dispose();
        }
        this.selectWorker = null;
        if (this.tipTextWorker != null) {
            this.tipTextWorker.dispose();
        }
        this.tipTextWorker = null;
        if (this.selectMissingWorker != null) {
            this.selectMissingWorker.dispose();
        }
        this.selectMissingWorker = null;
        this.xRole = null;
        this.yRole = null;
        if (this.buildRoles != null) {
            this.buildRoles.clear();
        }
        this.buildRoles = null;
        this.dummyBin = null;
        this.rbHist = null;
        this.resourceBundle = null;
    }

    private class DrawWorker
    extends Worker {
        Graphics g;
        Graphics2D g2;
        Paint oldPaint;
        Color fillColor;
        Color lineColor;
        Color fillColor2;
        Stroke lineStroke;

        private DrawWorker() {
            this.g = null;
            this.g2 = null;
            this.oldPaint = null;
            this.fillColor = null;
            this.lineColor = null;
            this.fillColor2 = null;
            this.lineStroke = null;
        }

        public void init(Graphics g, Color fillColor, Color fillColor2, Color lineColor, Stroke lineStroke) {
            this.g = g;
            if (g instanceof Graphics2D) {
                this.g2 = (Graphics2D)g;
            }
            this.fillColor = fillColor;
            this.fillColor2 = fillColor2;
            this.lineColor = lineColor;
            this.lineStroke = lineStroke;
        }

        @Override
        public void doWorkInLoop(Rectangle r, double value, Bin xBin, Bin yBin) {
            int x2 = r.x + r.width;
            int y2 = r.y + r.height;
            r.x = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, r.x));
            r.y = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, r.y));
            x2 = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, x2));
            y2 = Math.max(MIN_SCREEN_POS, Math.min(MAX_SCREEN_POS, y2));
            r.width = x2 - r.x;
            r.height = y2 - r.y;
            AbstractHistogramElement.this.drawBin(this.g, this.fillColor, this.fillColor2, this.lineColor, this.lineStroke, r, value, xBin, yBin);
        }

        @Override
        public void doWorkAtLoopEnd() {
        }

        @Override
        public boolean isWorkDone() {
            return false;
        }

        @Override
        public Object getResult() {
            return null;
        }

        public void dispose() {
            this.g = null;
            this.g2 = null;
            this.oldPaint = null;
            this.fillColor = null;
            this.lineColor = null;
            this.fillColor2 = null;
        }
    }

    private class SelectWorker
    extends Worker {
        boolean doWorkAtLoopEnd;
        Rectangle selectArea;
        String[] vars;
        DataRange[] ranges;
        ContinuousRange xcr;
        ContinuousRange ycr;
        boolean select;
        int xBoundary;
        int yBoundary;
        boolean extendedSelect;

        private SelectWorker() {
            this.doWorkAtLoopEnd = false;
            this.selectArea = null;
            this.vars = null;
            this.ranges = null;
            this.xcr = null;
            this.ycr = null;
            this.extendedSelect = false;
        }

        public void init(Rectangle selectArea, String[] vars, DataRange[] ranges, ContinuousRange xcr, ContinuousRange ycr, boolean select, int xBoundary, int yBoundary) {
            this.doWorkAtLoopEnd = false;
            this.selectArea = selectArea;
            this.vars = vars;
            this.ranges = ranges;
            this.xcr = xcr;
            this.ycr = ycr;
            this.select = select;
            this.xBoundary = xBoundary;
            this.yBoundary = yBoundary;
        }

        @Override
        public void doWorkInLoop(Rectangle r, double value, Bin xBin, Bin yBin) {
            if (AbstractHistogramElement.this.intersects(this.selectArea, r) && AbstractHistogramElement.this.isValidCount(value)) {
                double xMinAdj = 0.0;
                double xMaxAdj = 0.0;
                double yMinAdj = 0.0;
                double yMaxAdj = 0.0;
                if (this.xBoundary == 1) {
                    xMinAdj = AbstractHistogramElement.this.xErr;
                } else {
                    xMaxAdj = AbstractHistogramElement.this.xErr;
                }
                if (this.yBoundary == 1) {
                    yMinAdj = AbstractHistogramElement.this.yErr;
                } else {
                    yMaxAdj = AbstractHistogramElement.this.yErr;
                }
                if (xBin != null && xBin.getIndex() == 0) {
                    xMinAdj = -xMinAdj;
                }
                if (xBin != null && xBin.getIndex() == AbstractHistogramElement.this.xBins.size() - 1) {
                    xMaxAdj = -xMaxAdj;
                }
                if (yBin != null && yBin.getIndex() == 0) {
                    yMinAdj = -yMinAdj;
                }
                if (yBin != null && yBin.getIndex() == AbstractHistogramElement.this.yBins.size() - 1) {
                    yMaxAdj = -yMaxAdj;
                }
                if (AbstractHistogramElement.this.bivariate) {
                    this.xcr.setMin(Math.min(xBin.getMin() + xMinAdj, this.xcr.getMin()));
                    this.xcr.setMax(Math.max(xBin.getMax() - xMaxAdj, this.xcr.getMax()));
                    this.ycr.setMin(Math.min(yBin.getMin() + yMinAdj, this.ycr.getMin()));
                    this.ycr.setMax(Math.max(yBin.getMax() - yMaxAdj, this.ycr.getMax()));
                    this.doWorkAtLoopEnd = true;
                } else if (AbstractHistogramElement.this.filter instanceof AbstractDataFilter && this.isExtendedSelect()) {
                    this.xcr.setMin(Math.min(xBin.getMin() + xMinAdj, this.xcr.getMin()));
                    this.xcr.setMax(Math.max(xBin.getMax() - xMaxAdj, this.xcr.getMax()));
                    this.doWorkAtLoopEnd = true;
                } else if (xBin != null) {
                    this.xcr.setMin(xBin.getMin() + xMinAdj);
                    this.xcr.setMax(xBin.getMax() - xMaxAdj);
                    AbstractHistogramElement.this.filter.setSelected(this.vars, this.ranges, this.select);
                }
            }
        }

        @Override
        public void doWorkAtLoopEnd() {
            if (this.doWorkAtLoopEnd) {
                if (AbstractHistogramElement.this.filter instanceof AbstractDataFilter && this.isExtendedSelect()) {
                    ((AbstractDataFilter)AbstractHistogramElement.this.filter).toggleSelected(this.vars, this.ranges, false);
                } else {
                    AbstractHistogramElement.this.filter.setSelected(this.vars, this.ranges, this.select);
                }
            }
        }

        @Override
        public boolean isWorkDone() {
            return false;
        }

        @Override
        public Object getResult() {
            return null;
        }

        public void dispose() {
            this.selectArea = null;
            this.vars = null;
            this.ranges = null;
            this.xcr = null;
            this.ycr = null;
        }

        public boolean isExtendedSelect() {
            return this.extendedSelect;
        }

        public void setExtendedSelect(boolean extendedSelect) {
            this.extendedSelect = extendedSelect;
        }
    }

    private class SelectMissingWorker
    extends Worker {
        Rectangle selectArea;
        String[] vars;
        DataRange[] ranges;
        DiscreteRange xMissing;
        DiscreteRange yMissing;
        ContinuousRange cr;
        boolean select;
        int xBoundary;
        int yBoundary;
        boolean extendedSelect;

        private SelectMissingWorker() {
            this.selectArea = null;
            this.vars = null;
            this.ranges = null;
            this.xMissing = null;
            this.yMissing = null;
            this.cr = new ContinuousRange();
            this.extendedSelect = false;
        }

        public void init(Rectangle r, String[] vars, DataRange[] ranges, DiscreteRange xdr, DiscreteRange ydr, boolean select, int xBoundary, int yBoundary) {
            this.selectArea = r;
            this.vars = vars;
            this.ranges = ranges;
            this.xMissing = xdr;
            this.yMissing = ydr;
            this.select = select;
            this.xBoundary = xBoundary;
            this.yBoundary = yBoundary;
        }

        @Override
        public void doWorkInLoop(Rectangle r, double value, Bin xBin, Bin yBin) {
            if (AbstractHistogramElement.this.intersects(this.selectArea, r) && AbstractHistogramElement.this.isValidCount(value)) {
                double xMinAdj = 0.0;
                double xMaxAdj = 0.0;
                double yMinAdj = 0.0;
                double yMaxAdj = 0.0;
                if (this.xBoundary == 1) {
                    xMinAdj = AbstractHistogramElement.this.xErr;
                } else {
                    xMaxAdj = AbstractHistogramElement.this.xErr;
                }
                if (this.yBoundary == 1) {
                    yMinAdj = AbstractHistogramElement.this.yErr;
                } else {
                    yMaxAdj = AbstractHistogramElement.this.yErr;
                }
                if (xBin != null && xBin.getIndex() == 0) {
                    xMinAdj = 0.0;
                } else if (xBin != null && xBin.getIndex() == AbstractHistogramElement.this.xBins.size() - 1) {
                    xMaxAdj = 0.0;
                }
                if (yBin != null && yBin.getIndex() == 0) {
                    yMinAdj = 0.0;
                } else if (yBin != null && yBin.getIndex() == AbstractHistogramElement.this.yBins.size() - 1) {
                    yMaxAdj = 0.0;
                }
                if (AbstractHistogramElement.this.bivariate) {
                    if (xBin == null && yBin == null) {
                        this.ranges[0] = this.xMissing;
                        this.ranges[1] = this.yMissing;
                    } else if (xBin == null && yBin != null) {
                        this.cr.setMin(yBin.getMin() + yMinAdj);
                        this.cr.setMax(yBin.getMax() - yMaxAdj);
                        this.ranges[0] = this.xMissing;
                        this.ranges[1] = this.cr;
                    } else if (xBin != null && yBin == null) {
                        this.cr.setMin(xBin.getMin() + xMinAdj);
                        this.cr.setMax(xBin.getMax() - xMaxAdj);
                        this.ranges[0] = this.cr;
                        this.ranges[1] = this.yMissing;
                    }
                } else {
                    this.ranges[0] = this.xMissing;
                }
                if (AbstractHistogramElement.this.filter instanceof AbstractDataFilter && this.isExtendedSelect()) {
                    ((AbstractDataFilter)AbstractHistogramElement.this.filter).toggleSelected(this.vars, this.ranges, false);
                } else {
                    AbstractHistogramElement.this.filter.setSelected(this.vars, this.ranges, this.select);
                }
            }
        }

        @Override
        public void doWorkAtLoopEnd() {
        }

        @Override
        public boolean isWorkDone() {
            return false;
        }

        @Override
        public Object getResult() {
            return null;
        }

        public void dispose() {
            this.selectArea = null;
            this.vars = null;
            this.ranges = null;
            this.xMissing = null;
            this.yMissing = null;
            this.cr = null;
        }

        public boolean isExtendedSelect() {
            return this.extendedSelect;
        }

        public void setExtendedSelect(boolean extendedSelect) {
            this.extendedSelect = extendedSelect;
        }
    }

    protected class TipTextWorker
    extends Worker {
        private boolean workDone;
        private Rectangle pickArea;
        private String tipText;
        private boolean multiTip;
        private StringBuffer sb;

        protected TipTextWorker() {
            this.workDone = false;
            this.pickArea = null;
            this.tipText = null;
            this.multiTip = false;
            this.sb = null;
        }

        public void init(Rectangle pickArea) {
            this.pickArea = pickArea;
            this.workDone = false;
            this.tipText = null;
        }

        @Override
        public void doWorkInLoop(Rectangle r, double value, Bin xBin, Bin yBin) {
            this.workDone = false;
            if (this.multiTip && this.sb == null) {
                this.sb = new StringBuffer();
            }
            if (AbstractHistogramElement.this.intersects(this.pickArea, r)) {
                this.tipText = AbstractHistogramElement.this.getTipText(xBin, yBin, value);
                if (this.multiTip) {
                    this.sb.append(this.tipText + "\n\n");
                } else {
                    this.workDone = true;
                }
            }
        }

        @Override
        public void doWorkAtLoopEnd() {
            if (this.multiTip) {
                this.tipText = this.sb.length() > 0 ? this.sb.toString().trim() : null;
                this.sb = null;
                this.workDone = true;
            }
        }

        @Override
        public boolean isWorkDone() {
            return this.workDone;
        }

        @Override
        public Object getResult() {
            return this.tipText;
        }

        public void setMultiTip(boolean multiTip) {
            this.multiTip = multiTip;
        }

        public void dispose() {
            this.pickArea = null;
            this.tipText = null;
            this.sb = null;
        }
    }

    protected class DrillDownWorker
    extends Worker {
        private boolean workDone;
        private Rectangle pickArea;
        private Hashtable drillDownInfo;

        protected DrillDownWorker() {
            this.workDone = false;
            this.pickArea = null;
            this.drillDownInfo = null;
        }

        public void init(Rectangle pickArea) {
            this.pickArea = pickArea;
            this.workDone = false;
            this.drillDownInfo = new Hashtable();
        }

        @Override
        public void doWorkInLoop(Rectangle r, double value, Bin xBin, Bin yBin) {
            this.workDone = false;
            if (AbstractHistogramElement.this.intersects(this.pickArea, r)) {
                if (xBin != null) {
                    this.drillDownInfo.put(DrilldownEvent.DRILLDOWN_KEY_X_BIN_START, xBin.getMin());
                    this.drillDownInfo.put(DrilldownEvent.DRILLDOWN_KEY_X_BIN_END, xBin.getMax());
                } else {
                    this.drillDownInfo.put(DrilldownEvent.DRILLDOWN_KEY_X_BIN_START, Double.NaN);
                }
                if (AbstractHistogramElement.this.bivariate) {
                    if (yBin != null) {
                        this.drillDownInfo.put(DrilldownEvent.DRILLDOWN_KEY_Y_BIN_START, yBin.getMin());
                        this.drillDownInfo.put(DrilldownEvent.DRILLDOWN_KEY_Y_BIN_END, yBin.getMax());
                    } else {
                        this.drillDownInfo.put(DrilldownEvent.DRILLDOWN_KEY_Y_BIN_START, Double.NaN);
                    }
                }
                this.workDone = true;
            }
        }

        @Override
        public void doWorkAtLoopEnd() {
        }

        @Override
        public boolean isWorkDone() {
            return this.workDone;
        }

        @Override
        public Object getResult() {
            return this.drillDownInfo;
        }

        public void dispose() {
            this.pickArea = null;
            this.drillDownInfo = null;
        }
    }

    protected class Bin {
        double min;
        double max;
        double count;
        int index;
        String group;
        int groupIndex;

        protected Bin() {
        }

        public double getCount() {
            return this.count;
        }

        public void setCount(double count) {
            this.count = count;
        }

        public double getMax() {
            return this.max;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public double getMin() {
            return this.min;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public boolean contains(double value, int binningInclusive) {
            if (this.getMax() == this.getMin() && value == this.getMax()) {
                return true;
            }
            return binningInclusive == 1 ? value <= this.max : binningInclusive == 0 && value < this.max;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Bin [min=");
            sb.append(this.min);
            sb.append(", max=");
            sb.append(this.max);
            sb.append(", count=");
            sb.append(this.count);
            if (this.group != null) {
                sb.append(", group=" + this.group);
                sb.append(", groupIndex=" + this.groupIndex);
            }
            sb.append("]");
            return sb.toString();
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public int getGroupIndex() {
            return this.groupIndex;
        }

        public void setGroupIndex(int groupIndex) {
            this.groupIndex = groupIndex;
        }
    }

    protected abstract class Worker {
        protected Worker() {
        }

        public abstract void doWorkInLoop(Rectangle var1, double var2, Bin var4, Bin var5);

        public abstract void doWorkAtLoopEnd();

        public abstract boolean isWorkDone();

        public abstract Object getResult();
    }
}

