/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.util.AxisDefaults;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.CollectionSorter;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.DefaultStatistics;
import com.sas.graphics.util.FontManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;

public abstract class AbstractBarParmElement
extends BaseElement {
    protected static final int VERTICAL_BAR = 0;
    protected static final int HORIZONTAL_BAR = 1;
    protected SILKNumber categoryRole = null;
    protected SILKNumber responseRole = null;
    protected SILKNumber groupRole = null;
    protected SILKNumber errorLowRole = null;
    protected SILKNumber errorHighRole = null;
    protected SILKNumber colorIndexRole = null;
    protected SILKNumber tipRole = null;
    protected static final int MAX_RESPONSES = 10;
    protected CharacterVariableMapper categoryMapper = null;
    protected CharacterVariableMapper groupMapper = null;
    protected ResourceBundle rbBar = null;
    protected Object responseSign = null;
    protected String currentLegend = null;
    protected double widthFactor;
    protected int numberOfBars;
    protected int displayBarStart;
    protected int displayBarEnd;
    protected Object colorBy = null;
    protected boolean outlineOn;
    protected Color outlineClr;
    protected Color transparencyColor = Color.gray;
    protected boolean isGraphed = false;
    protected boolean gradient = true;
    protected boolean gradientDisable = false;
    protected LinkedHashMap categoryList = null;
    protected DefaultStatistics defaultStatistics = null;
    protected Vector tuple = null;
    protected Object[] summaryVars;
    protected Object respVar;
    protected boolean showLabels = false;
    protected boolean showGraphedLabels = false;
    protected boolean negResp = false;
    protected double baseLineValue = 0.0;
    protected int numberOfResponse = 1;
    protected Object[] respVars = null;
    protected boolean allowMultiResponse = true;
    protected LinkedHashMap responseLink = null;
    protected LinkedHashMap errorLowList = null;
    protected LinkedHashMap errorHighList = null;
    protected LinkedHashMap colorIndexList = null;
    protected double fullBarWidth;
    protected boolean singleBar;
    protected Font barLabelFont = null;
    protected AxisDefaults axisDefaults;
    protected Object categorySortType = RoleInterface.ROLE_SORT_DATA;
    protected Object responseSortType = null;
    protected boolean styleElementSelectorEnabled = true;
    protected int xValueCount = 0;
    protected int actualXValueCount = 0;
    protected boolean userSetXValueCount = false;
    protected int responseStatDisplay = 0;
    protected boolean showStatOnAxis = true;
    public static final int AUTO = 0;
    public static final int OFF = 1;
    public static final int[] supportedBarElementProperties = new int[]{19081, 806, 815, 803, 813, 812, 816, 817, 807, 804, 810, 809, 802, 818, 24, 25, 23, 40, 42, 433, 426, 434, 441, 19055, 19054};
    protected boolean absolute = false;
    protected boolean absoluteSort = false;
    protected int sortOrder = 0;
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final String RESPONSE = "Response Sign";
    public static final String CATEGORY = "Category";
    protected boolean isNegative = false;
    boolean disableSortByResponse = false;

    public AbstractBarParmElement() {
        Roles role = Roles.getInstance(null);
        this.categoryRole = role.getRoleObject("ROLE_CATEGORY");
        this.roles.newRole((Object)this.categoryRole, CATEGORY, 1);
        this.roles.setRoleType((Object)this.categoryRole, 0);
        this.roles.setDiscrete((Object)this.categoryRole, true);
        this.roles.setSupportsDiscrete((Object)this.categoryRole, false);
        this.roles.setSortOrder((Object)this.categoryRole, RoleInterface.ROLE_SORT_DATA);
        this.responseRole = role.getRoleObject("ROLE_RESPONSE");
        this.roles.newRole((Object)this.responseRole, "Response", 10);
        this.roles.setRoleType((Object)this.responseRole, 1);
        this.groupRole = role.getRoleObject("ROLE_GROUP");
        this.roles.newRole((Object)this.groupRole, "Group", 1);
        this.roles.setRoleType((Object)this.groupRole, 0);
        this.roles.setDiscrete((Object)this.groupRole, true);
        this.errorLowRole = role.getRoleObject("ROLE_ERROR_LOW");
        this.roles.newRole((Object)this.errorLowRole, "Error low", 1);
        this.roles.setRoleType((Object)this.errorLowRole, 1);
        this.errorHighRole = role.getRoleObject("ROLE_ERROR_HIGH");
        this.roles.newRole((Object)this.errorHighRole, "Error high", 1);
        this.roles.setRoleType((Object)this.errorHighRole, 1);
        this.colorIndexRole = role.getRoleObject("ROLE_COLOR_INDEX");
        this.roles.newRole((Object)this.colorIndexRole, "Color index", 1);
        this.roles.setRoleType((Object)this.colorIndexRole, 1);
        this.tipRole = role.getRoleObject("ROLE_TIP");
        this.roles.newRole((Object)this.tipRole, "Tip", 1);
        this.roles.setRoleType((Object)this.tipRole, 0);
        this.rbBar = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.bar.silk_bar_NLS");
        this.responseSign = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rbBar, (String)"Bar.ResponseSign.txt", (String)RESPONSE), RESPONSE);
        this.widthFactor = 0.85;
        this.setSupportedProperties(supportedBarElementProperties);
        this.userSetProperties.appendProperties(supportedBarElementProperties);
        this.outlineClr = this.style.getLineStyleElement("Outlines").getLineColor();
        this.outlineOn = true;
        this.axisDefaults = new AxisDefaults();
        this.barLabelFont = FontManager.getFont((String)this.axisDefaults.valueFontName, (int)this.axisDefaults.valueFontType, (int)12);
    }

    protected abstract void drawBaseLine(Graphics var1);

    protected abstract int getOrientation();

    @Override
    public void roleChanged(RoleEvent e) {
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
                break;
            }
            case 5: {
                this.setSortOrder(e);
            }
        }
        this.setSortMetadata();
        this.createCategoryList();
        if (this.getOrientation() == 0) {
            if (e.type == 5 || this.isCurrentSortTypeOnCategory()) {
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
            }
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        } else {
            if (e.type == 5 || this.isCurrentSortTypeOnCategory()) {
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            }
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        }
        this.fireLayerListenerChanged(3);
    }

    private boolean isCurrentSortTypeOnCategory() {
        if (this.categorySortType != null) {
            return !this.categorySortType.equals(RoleInterface.ROLE_SORT_CUSTOM) || this.responseSortType == null;
        }
        return this.responseSortType == null;
    }

    protected void setSortMetadata() {
        this.roles.setSupportedSortRoles(this.buildSupportedSortableRoles());
        this.roles.setSortsSupported((Object)this.categoryRole, this.buildSupportedSortDirections((Object)this.categoryRole));
        this.roles.setSortsSupported((Object)this.responseRole, this.buildSupportedSortDirections((Object)this.responseRole));
    }

    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 1: 
            case 24: {
                this.setRoleCategoryEnum();
                break;
            }
            case 6: {
                this.setRoleGroupEnum();
                break;
            }
            case 17: {
                this.setRoleResponseEnum();
                break;
            }
        }
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                this.categoryMapper = null;
                this.displayBarEnd = 0;
                this.displayBarStart = 0;
                this.colorIndexList = null;
                break;
            }
            case 1: {
                this.colorIndexList = null;
                break;
            }
            case 6: {
                this.groupMapper = null;
                this.allowMultiResponse = true;
                break;
            }
            case 17: {
                this.respVar = null;
                this.respVars = null;
                this.numberOfResponse = 1;
                this.respVars = (Object[])this.roles.getVariable((Object)this.responseRole);
                if (this.respVars != null) {
                    this.numberOfResponse = this.respVars.length;
                    if (this.responseLink != null) {
                        this.responseLink.clear();
                    }
                    if (this.responseLink == null) {
                        this.responseLink = new LinkedHashMap();
                    }
                    for (int i = 0; i < this.numberOfResponse; ++i) {
                        this.responseLink.put(new Integer(i), this.respVars[i]);
                    }
                    this.respVar = this.respVars != null ? this.respVars[0] : null;
                } else {
                    this.responseLink = null;
                }
                if (this.numberOfResponse > 1) {
                    this.allowMultiResponse = true;
                    this.roles.deleteRole((Object)this.groupRole);
                    this.roles.deleteRole((Object)this.colorIndexRole);
                    this.roles.deleteRole((Object)this.errorLowRole);
                    this.roles.deleteRole((Object)this.errorHighRole);
                } else {
                    this.roles.newRole((Object)this.groupRole, "Group", 1);
                    this.roles.setRoleType((Object)this.groupRole, 0);
                    this.roles.setDiscrete((Object)this.groupRole, true);
                    this.roles.newRole((Object)this.colorIndexRole, "Color index", 1);
                    this.roles.setRoleType((Object)this.colorIndexRole, 1);
                    this.roles.newRole((Object)this.errorLowRole, "Error low", 1);
                    this.roles.setRoleType((Object)this.errorLowRole, 1);
                    this.roles.newRole((Object)this.errorHighRole, "Error high", 1);
                    this.roles.setRoleType((Object)this.errorHighRole, 1);
                }
                this.persistSortOrder();
                break;
            }
        }
    }

    private void setRoleCategoryEnum() {
        if (this.filter != null) {
            Object o = this.roles.getVariable((Object)this.categoryRole, 0);
            int observations = this.filter.getNumberObservations(-1);
            if (this.filter.isNumericVariable(o)) {
                this.responseSortType = RoleInterface.ROLE_SORT_NONE;
            } else {
                this.categorySortType = RoleInterface.ROLE_SORT_DATA;
            }
            if (this.categoryMapper == null) {
                this.categoryMapper = new CharacterVariableMapper(this.filter, o);
            } else {
                this.categoryMapper.setVariable(o);
            }
            this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
            this.displayBarStart = 1;
            this.displayBarEnd = this.numberOfBars = this.categoryMapper.getNumberValues();
            if (this.responseStatDisplay == 0) {
                boolean bl = this.showStatOnAxis = observations != this.numberOfBars;
            }
            if (this.roles.getVariable((Object)this.colorIndexRole, 0) != null) {
                this.lce.setAction(6);
                this.lce.setBuildData(this.categoryRole.toString());
                this.fireLayerListenerChanged(this.lce);
            }
        }
    }

    public void setRoleResponseEnum() {
        this.respVars = (Object[])this.roles.getVariable((Object)this.responseRole);
        int n = this.numberOfResponse = this.respVars != null ? this.respVars.length : 1;
        if (this.numberOfResponse > 1) {
            this.allowMultiResponse = true;
            this.roles.deleteRole((Object)this.groupRole);
            this.roles.deleteRole((Object)this.colorIndexRole);
            this.roles.deleteRole((Object)this.errorLowRole);
            this.roles.deleteRole((Object)this.errorHighRole);
        } else {
            this.roles.newRole((Object)this.groupRole, "Group", 1);
            this.roles.newRole((Object)this.colorIndexRole, "Color index", 1);
            this.roles.newRole((Object)this.errorLowRole, "Error low", 1);
            this.roles.newRole((Object)this.errorHighRole, "Error high", 1);
        }
        if (this.responseLink != null) {
            this.responseLink.clear();
        }
        if (this.responseLink == null) {
            this.responseLink = new LinkedHashMap();
        }
        for (int i = 0; i < this.numberOfResponse; ++i) {
            this.responseLink.put(new Integer(i), this.respVars[i]);
        }
        Object object = this.respVar = this.respVars != null ? this.respVars[0] : null;
        if (this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase(RESPONSE)) && this.roles.getVariable((Object)this.colorIndexRole, 0) != null) {
            this.lce.setAction(6);
            this.lce.setBuildData(this.responseSign.toString());
            this.fireLayerListenerChanged(this.lce);
        }
        this.persistSortOrder();
    }

    private void setRoleGroupEnum() {
        if (this.filter != null) {
            if (this.groupMapper == null) {
                this.groupMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable((Object)this.groupRole, 0));
            } else {
                this.groupMapper.setVariable(this.roles.getVariable((Object)this.groupRole, 0));
            }
            this.allowMultiResponse = false;
            this.responseSortType = RoleInterface.ROLE_SORT_DATA;
            this.lce.setAction(6);
            this.lce.setBuildData(this.groupRole.toString());
            this.fireLayerListenerChanged(this.lce);
        }
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (which == null) {
            return null;
        }
        Object role = null;
        if (Extract.getNumberItems((Object)which, (int)Extract.getSourceType((Object)which)) > 0) {
            role = Extract.getObject((Object)which, (int)0, (int)Extract.getSourceType((Object)which));
        }
        if (role == null) {
            return null;
        }
        if (this.tuple != null && (role != null && role.equals("Response") || role.equals(RoleInterface.ROLE_RESPONSE)) && this.respVars != null) {
            Object[] respValuesArray;
            double max = 0.0;
            double min = 0.0;
            double respValue = 0.0;
            Object[] objectArray = respValuesArray = this.responseLink != null ? this.responseLink.values().toArray() : null;
            if (respValuesArray == null) {
                return null;
            }
            int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.categoryRole, 0));
            int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
            if (grpVarIndex > -1) {
                Object[] tupleArray = this.tuple.toArray();
                LinkedHashMap<Integer, Double> respList = new LinkedHashMap<Integer, Double>();
                for (int i = 0; i < tupleArray.length; ++i) {
                    Object[] summaryVarVals = (Object[])tupleArray[i];
                    int catValue = this.categoryMapper.getIndex(((Object[])tupleArray[i])[0]);
                    double respval = this.getResponseValues(this.summaryVars, this.respVar, null, summaryVarVals, 1);
                    if (Double.isNaN(respval)) continue;
                    if (grpVarIndex > -1) {
                        double val;
                        int catKey;
                        Object tmpVal;
                        double dVal;
                        if (respval >= 0.0) {
                            dVal = 0.0;
                            dVal = respval;
                            tmpVal = null;
                            catKey = catValue + 1;
                            if (respList.containsKey(new Integer(catKey)) && (tmpVal = respList.get(new Integer(catKey))) != null) {
                                val = ((Number)tmpVal).doubleValue();
                                dVal += val;
                            }
                            respList.put(new Integer(catKey), new Double(dVal));
                            respval = dVal;
                        } else {
                            dVal = 0.0;
                            dVal = respval;
                            tmpVal = null;
                            catKey = catValue + 1;
                            if (respList.containsKey(new Integer(catKey = -catKey)) && (tmpVal = respList.get(new Integer(catKey))) != null) {
                                val = ((Number)tmpVal).doubleValue();
                                dVal += val;
                            }
                            respList.put(new Integer(catKey), new Double(dVal));
                            respval = dVal;
                        }
                    }
                    max = Math.max(max, respval);
                    min = Math.min(min, respval);
                }
            } else {
                for (int i = 0; i < respValuesArray.length; ++i) {
                    int respIndex = this.filter.getVariableIndex(respValuesArray[i]);
                    for (int j = 0; j < this.filter.getNumberObservations(-1); ++j) {
                        double val;
                        Object valObj;
                        int catValue = this.categoryMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)j, null));
                        respValue = this.filter.getNumericValue(respIndex, (long)j);
                        if (Double.isNaN(respValue)) continue;
                        if (this.errorLowList != null && (valObj = this.errorLowList.get(new Integer(catValue))) != null && !Double.isNaN(val = ((Number)valObj).doubleValue())) {
                            min = Math.min(min, respValue - val);
                        }
                        if (this.errorHighList != null && (valObj = this.errorHighList.get(new Integer(catValue))) != null && !Double.isNaN(val = ((Number)valObj).doubleValue())) {
                            max = Math.max(max, respValue + val);
                        }
                        max = Math.max(max, respValue);
                        min = Math.min(min, respValue);
                    }
                }
            }
            this.negResp = min < 0.0;
            ContinuousRange cr = new ContinuousRange(min, max);
            ContinuousRange dr = new ContinuousRange((DataRange)cr);
            return dr;
        }
        if (this.tuple != null && (role != null && role.equals(CATEGORY) || role.equals(RoleInterface.ROLE_CATEGORY)) && (this.responseSortType == RoleInterface.ROLE_SORT_ASCENDING || this.responseSortType == RoleInterface.ROLE_SORT_DESCENDING)) {
            return new DiscreteRange(this.categoryMapper.getValues());
        }
        return super.getPreferredRange(which);
    }

    protected LinkedHashMap getCategoryList() {
        if (this.filter == null) {
            return null;
        }
        return this.categoryList;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 3: {
                this.persistSortOrder();
                this.createCategoryList();
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            }
        }
        super.dataFilterChanged(evt);
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        if (id == 815) {
            this.styleElementSelectorEnabled = value == null;
        }
        return super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 806: {
                rc = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1 || this.allowMultiResponse && this.numberOfResponse > 1 || this.colorIndexList != null ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 815: {
                rc = this.colorBy;
                break;
            }
            case 803: {
                rc = new Boolean(this.outlineOn);
                break;
            }
            case 813: {
                rc = new Boolean(this.gradientDisable);
                break;
            }
            case 812: {
                rc = new Boolean(this.gradient);
                break;
            }
            case 816: {
                rc = new Boolean(this.showLabels);
                break;
            }
            case 817: {
                rc = new Boolean(this.showGraphedLabels);
                break;
            }
            case 807: {
                rc = new Integer(-1);
                break;
            }
            case 804: {
                rc = new Double(this.widthFactor);
                break;
            }
            case 810: {
                rc = new Integer(this.numberOfBars);
                break;
            }
            case 809: {
                rc = this.getDisplayBarRange();
                break;
            }
            case 802: {
                rc = this.outlineClr;
                break;
            }
            case 818: {
                rc = new Integer(this.responseStatDisplay);
                break;
            }
            case 23: {
                this.currentLegend = null;
                if (this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1) {
                    String string = this.currentLegend = this.groupRole != null ? this.groupRole.toString() : null;
                }
                if (this.currentLegend == null && this.allowMultiResponse && this.numberOfResponse > 1) {
                    this.currentLegend = this.responseRole.toString();
                }
                if (this.currentLegend == null && this.colorIndexList != null) {
                    this.currentLegend = this.categoryRole.toString();
                }
                if (this.currentLegend == null && this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase(RESPONSE))) {
                    this.currentLegend = this.responseSign.toString();
                }
                if (this.currentLegend == null && this.colorBy != null && !this.colorBy.equals(this.responseSign) && !this.colorBy.toString().equalsIgnoreCase(RESPONSE)) {
                    this.currentLegend = this.categoryRole.toString();
                }
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (this.groupRole == null || !this.groupRole.toString().equalsIgnoreCase(this.currentLegend)) break;
                rc = this.roles.getVariable((Object)this.groupRole, 0);
                break;
            }
            case 24: 
            case 25: {
                if (this.filter == null) break;
                Vector<Object> legNames = new Vector<Object>();
                int grpIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
                if (grpIndex > -1) {
                    legNames.add((Object)this.groupRole);
                } else if (this.allowMultiResponse && this.numberOfResponse > 1) {
                    legNames.add((Object)this.responseRole);
                } else if (this.colorIndexList != null) {
                    legNames.add((Object)this.categoryRole);
                } else if (grpIndex == -1 && this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase(RESPONSE))) {
                    legNames.add(this.responseSign);
                } else if (grpIndex == -1 && this.colorBy != null && !this.colorBy.equals(this.responseSign) && !this.colorBy.toString().equalsIgnoreCase(RESPONSE)) {
                    legNames.add((Object)this.categoryRole);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 433: {
                Object[] catVals;
                int groupIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
                Color color = null;
                if (groupIndex > -1 && this.categoryList != null) {
                    Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
                    if (this.colorIndexList != null) {
                        Object[] groupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false);
                        for (int i = 0; i < groupVals.length; ++i) {
                            Integer grpObj = new Integer(this.groupMapper.getIndex(groupVals[i]));
                            Object clrObj = this.colorIndexList.get(grpObj);
                            if (clrObj != null) {
                                int clrVal = ((Number)clrObj).intValue();
                                DataStyleElement dse = SILKUtilities.getStyleElement(groupVals[i].toString(), clrVal, 2, this.style, this.fillAttrs.getReference(), null).getAsDataStyle();
                                color = dse.getFillColor();
                            } else {
                                color = this.style.getFillStyleElement("Missing").getFillColor();
                            }
                            int grpVal = this.groupMapper.getIndex(groupVals[i]);
                            if (grpVal <= -1) continue;
                            MarkerAttrib ms = new MarkerAttrib(true, color);
                            ms.setOutline(new Boolean(this.outlineOn));
                            ms.setOutline(this.outlineClr);
                            legendEntries.add(new LegendEntry(groupVals[i], ms, null));
                        }
                    } else {
                        Object[] groupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false);
                        for (int i = 0; i < groupVals.length; ++i) {
                            int grpVal = i;
                            String attrValueStr = groupVals[i].toString();
                            DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, grpVal, 2, this.style, this.fillAttrs.getReference(), null).getAsDataStyle();
                            color = dse.getFillColor();
                            grpVal = this.groupMapper.getIndex(groupVals[i]);
                            if (grpVal <= -1) continue;
                            MarkerAttrib ms = new MarkerAttrib(true, color);
                            ms.setOutline(new Boolean(this.outlineOn));
                            ms.setOutline(this.outlineClr);
                            legendEntries.add(new LegendEntry(groupVals[i], ms, null));
                        }
                    }
                    rc = legendEntries;
                    break;
                }
                if (this.allowMultiResponse && this.numberOfResponse > 1) {
                    Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(this.numberOfResponse);
                    for (int i = 0; i < this.numberOfResponse; ++i) {
                        Object var = this.roles.getVariable((Object)this.responseRole, i);
                        var = this.filter.getVariableDescription(var);
                        String attrValueStr = var.toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i, 1, this.style, this.fillAttrs.getReference(), null).getAsDataStyle();
                        color = dse.getFillColor();
                        MarkerAttrib ms = new MarkerAttrib(true, color);
                        ms.setOutline(new Boolean(this.outlineOn));
                        ms.setOutline(this.outlineClr);
                        legendEntries.add(new LegendEntry(var, ms, null));
                    }
                    rc = legendEntries;
                    break;
                }
                if (this.colorIndexList != null) {
                    LinkedHashMap<Object, Integer> uniqueCatList = new LinkedHashMap<Object, Integer>();
                    Object[] catVals2 = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.categoryRole, 0), false);
                    for (int i = 0; i < catVals2.length; ++i) {
                        uniqueCatList.put(catVals2[i], new Integer(i));
                    }
                    catVals2 = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.categoryRole, 0), true);
                    Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(catVals2.length);
                    for (int i = 0; i < catVals2.length; ++i) {
                        int catIndx = ((Number)uniqueCatList.get(catVals2[i])).intValue();
                        Integer catObj = new Integer(catIndx);
                        Object clrObj = this.colorIndexList.get(catObj);
                        if (clrObj != null) {
                            int clrVal = ((Number)clrObj).intValue();
                            DataStyleElement dse = SILKUtilities.getStyleElement(catVals2[i].toString(), clrVal, 2, this.style, this.fillAttrs.getReference(), null).getAsDataStyle();
                            color = dse.getFillColor();
                        } else {
                            color = this.style.getFillStyleElement("Missing").getFillColor();
                        }
                        int catIndex = this.categoryMapper.getIndex(catVals2[i]);
                        if (catIndex <= -1) continue;
                        MarkerAttrib ms = new MarkerAttrib(true, color);
                        ms.setOutline(new Boolean(this.outlineOn));
                        ms.setOutline(this.outlineClr);
                        legendEntries.add(new LegendEntry(catVals2[i], ms, null));
                    }
                    rc = legendEntries;
                    break;
                }
                if (groupIndex == -1 && this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase(RESPONSE))) {
                    Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(2);
                    Color[] fillColors = this.style.getDataFillColors();
                    color = fillColors[1];
                    MarkerAttrib ms = new MarkerAttrib(true, color);
                    ms.setOutline(new Boolean(this.outlineOn));
                    ms.setOutline(this.outlineClr);
                    legendEntries.add(new LegendEntry("-", ms, null));
                    color = fillColors[0];
                    ms = new MarkerAttrib(true, color);
                    ms.setOutline(new Boolean(this.outlineOn));
                    ms.setOutline(this.outlineClr);
                    legendEntries.add(new LegendEntry("+", ms, null));
                    rc = legendEntries;
                    break;
                }
                if (groupIndex != -1 || this.colorBy == null || this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase(RESPONSE) || (catVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.categoryRole, 0), false)) == null || catVals.length <= 0) break;
                Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(catVals.length);
                for (int i = 0; i < catVals.length; ++i) {
                    int catVal = this.categoryMapper.getIndex(catVals[i]);
                    if (catVal < 0) continue;
                    catVal = i;
                    String attrValueStr = catVals[i].toString();
                    DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, catVal, 2, this.style, this.fillAttrs.getReference(), null).getAsDataStyle();
                    color = dse.getFillColor();
                    MarkerAttrib ms = new MarkerAttrib(true, color);
                    ms.setOutline(new Boolean(this.outlineOn));
                    ms.setOutline(this.outlineClr);
                    legendEntries.add(new LegendEntry(catVals[i], ms, null));
                }
                rc = legendEntries;
                break;
            }
            case 426: {
                Object catVar;
                Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
                if (this.filter != null && groupVar != null) {
                    rc = this.filter.getVariableDescription(groupVar);
                }
                if (rc == null) {
                    rc = groupVar;
                }
                if (rc == null && this.colorIndexList != null) {
                    catVar = this.roles.getVariable((Object)this.categoryRole, 0);
                    if (this.filter != null && catVar != null) {
                        rc = this.filter.getVariableDescription(catVar);
                    }
                    if (rc == null) {
                        rc = catVar;
                    }
                }
                if (rc != null) break;
                if (this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase(RESPONSE))) {
                    rc = this.responseSign.toString();
                    break;
                }
                if (this.colorBy == null || this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase(RESPONSE)) break;
                catVar = this.roles.getVariable((Object)this.categoryRole, 0);
                if (this.filter != null && catVar != null) {
                    rc = this.filter.getVariableDescription(catVar);
                }
                if (rc != null) break;
                rc = catVar;
                break;
            }
            case 420: {
                rc = new Boolean(!this.categoryRole.equals(this.currentLegend));
                break;
            }
            case 441: {
                rc = Boolean.FALSE;
                break;
            }
            case 19057: {
                rc = new Object[]{RoleInterface.ROLE_CATEGORY};
                break;
            }
            case 19056: {
                rc = new Object[]{RoleInterface.ROLE_RESPONSE};
                break;
            }
            case 19064: {
                rc = Boolean.FALSE;
                break;
            }
            case 19053: {
                rc = this.setCategoryAxisLabels();
                break;
            }
            case 19052: {
                rc = this.setCategoryAxisLabels();
                break;
            }
            case 19067: {
                if (this.userSetXValueCount) {
                    rc = new Integer(this.getXValueCount());
                    break;
                }
                rc = null;
                break;
            }
            case 42: {
                rc = new Double(this.actualXValueCount);
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    private Object setCategoryAxisLabels() {
        Object rc = null;
        if (this.tuple != null) {
            Object catVar = this.roles.getVariable((Object)this.categoryRole, 0);
            if (this.filter != null && catVar != null) {
                rc = this.filter.getVariableDescription(catVar);
            }
            if (rc == null) {
                rc = catVar;
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 19081: {
                if (!(value instanceof Boolean)) break;
                this.disableSortByResponse = (Boolean)value;
                this.setSortMetadata();
                break;
            }
            case 809: {
                if (!(value instanceof int[])) break;
                int[] range = (int[])value;
                this.setDisplayBarRange(range[0], range[1]);
                break;
            }
            case 815: {
                this.setColorBy(value);
                break;
            }
            case 803: {
                if (!(value instanceof Boolean)) break;
                this.outlineOn = (Boolean)value;
                this.userSetProperties.set(803);
                break;
            }
            case 818: {
                if (!(value instanceof Number)) break;
                this.setResponseStatDisplay(((Number)value).intValue());
                this.userSetProperties.set(818);
                break;
            }
            case 802: {
                if (!(value instanceof Color)) break;
                this.outlineClr = (Color)value;
                break;
            }
            case 812: {
                if (!(value instanceof Boolean)) break;
                this.setGradientOn((Boolean)value);
                break;
            }
            case 804: {
                if (!(value instanceof Number)) break;
                this.setWidthFactor(((Number)value).doubleValue());
                break;
            }
            case 816: {
                if (!(value instanceof Boolean)) break;
                this.setShowLabel((Boolean)value);
                break;
            }
            case 817: {
                if (!(value instanceof Boolean)) break;
                this.setShowGraphedLabel((Boolean)value);
                break;
            }
            case 40: {
                if (!(value instanceof Number)) break;
                this.setXValueCount(((Number)value).intValue());
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    public void setNumberDisplayBars(int n) {
        if (n < 1) {
            return;
        }
        this.setDisplayBarRange(1, n);
    }

    public int getNumberDisplayBars() {
        return this.displayBarEnd + 1 - this.displayBarStart;
    }

    public int[] getDisplayBarRange() {
        return new int[]{this.displayBarStart, this.displayBarEnd};
    }

    public abstract void setDisplayBarRange(int var1, int var2);

    public void setColorBy(Object role) {
        if (role == null) {
            this.colorBy = null;
        }
        if (role instanceof String && (((String)role).equalsIgnoreCase(this.responseSign.toString()) || ((String)role).equalsIgnoreCase(RESPONSE))) {
            this.colorBy = role;
        } else if (role instanceof String && (((String)role).equalsIgnoreCase(this.categoryRole.toString()) || ((String)role).equalsIgnoreCase(CATEGORY))) {
            this.colorBy = role;
        } else if (role instanceof SILKNumber) {
            this.colorBy = (SILKNumber)((Object)role);
        }
        this.userSetProperties.set(815);
        this.fireLayerListenerChanged(1);
    }

    public void setGradientOn(boolean onOff) {
        if (this.gradient == onOff) {
            return;
        }
        this.gradient = onOff;
        this.userSetProperties.set(812);
        this.fireLayerListenerChanged(1);
    }

    public double getWidthFactor() {
        return this.widthFactor;
    }

    public void setWidthFactor(double fac) {
        if (fac <= 0.0 || fac > 1.0) {
            return;
        }
        this.widthFactor = fac;
        this.userSetProperties.set(804);
        this.fireLayerListenerChanged(1);
    }

    protected void createCategoryList() {
        int grpVarIndex;
        if (this.filter == null) {
            return;
        }
        int catVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.categoryRole, 0));
        int respVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.responseRole, 0));
        if (catVarIndex < 0 || respVarIndex < 0) {
            this.categoryList = null;
            return;
        }
        if (this.defaultStatistics == null) {
            this.defaultStatistics = new DefaultStatistics((Object)this.filter);
        }
        if (this.defaultStatistics == null) {
            this.categoryList = null;
        }
        this.summaryVars = (grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0))) > -1 ? new Object[]{this.roles.getVariable((Object)this.categoryRole, 0), this.roles.getVariable((Object)this.groupRole, 0)} : new Object[]{this.roles.getVariable((Object)this.categoryRole, 0)};
        this.tuple = this.defaultStatistics.getSummaryVarsTuples(this.summaryVars, this.respVar);
        if (this.tuple == null) {
            this.categoryList = null;
            return;
        }
        this.buildGroupListPerCategory();
    }

    protected void buildGroupListPerCategory() {
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        LinkedHashMap<Object, Map<Integer, Object>> catList = new LinkedHashMap<Object, Map<Integer, Object>>();
        Map<Integer, Object> grpList = new LinkedHashMap<Integer, Object>();
        for (int i = 0; i < this.tuple.size(); ++i) {
            Object[] val = (Object[])this.tuple.elementAt(i);
            Integer grpKeyObj = new Integer(0);
            Object grpValueObj = null;
            if (grpVarIndex > -1) {
                grpKeyObj = new Integer(this.groupMapper.getIndex(val[1]));
                grpValueObj = val[1];
            }
            if (catList.containsKey(val[0])) {
                grpList = (Map)catList.get(val[0]);
                if (grpList != null) {
                    grpList.put(grpKeyObj, grpValueObj);
                    grpList = new TreeMap(grpList);
                } else {
                    grpList = new LinkedHashMap();
                    grpList.put(grpKeyObj, grpValueObj);
                }
            } else {
                grpList = new LinkedHashMap();
                grpList.put(grpKeyObj, grpValueObj);
            }
            catList.put(val[0], grpList);
        }
        this.buildErrorLists();
        this.colorIndexList = null;
        int colorIndexVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.colorIndexRole, 0));
        if (colorIndexVarIndex > -1) {
            if (grpVarIndex > -1) {
                this.colorIndexList = new LinkedHashMap();
                for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                    Object grpObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)i, null);
                    grpObj = new Integer(this.groupMapper.getIndex(grpObj));
                    double colorIndexVal = this.filter.getNumericValue(this.roles.getVariable((Object)this.colorIndexRole, 0), (long)i);
                    if (grpObj == null || Double.isNaN(colorIndexVal) || !(colorIndexVal >= 0.0) || this.colorIndexList.containsKey(grpObj)) continue;
                    this.colorIndexList.put(grpObj, new Integer((int)colorIndexVal));
                }
            } else if (this.numberOfResponse == 1) {
                int i;
                this.colorIndexList = new LinkedHashMap();
                LinkedHashMap<Object, Integer> uniqueCatList = new LinkedHashMap<Object, Integer>();
                Object[] uniqueCatVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.categoryRole, 0), false);
                for (i = 0; i < uniqueCatVals.length; ++i) {
                    uniqueCatList.put(uniqueCatVals[i], new Integer(i));
                }
                for (i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                    Object catObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.categoryRole, 0), (long)i, null);
                    int catIndx = ((Number)uniqueCatList.get(catObj)).intValue();
                    catObj = new Integer(catIndx);
                    double colorIndexVal = this.filter.getNumericValue(this.roles.getVariable((Object)this.colorIndexRole, 0), (long)i);
                    if (catObj == null || Double.isNaN(colorIndexVal) || !(colorIndexVal >= 0.0) || this.colorIndexList.containsKey(catObj)) continue;
                    this.colorIndexList.put(catObj, new Integer((int)colorIndexVal));
                }
            }
        }
        this.categoryList = catList;
        this.singleBar = this.categoryList.keySet().toArray().length == 1;
        this.actualXValueCount = this.categoryList.keySet().toArray().length;
        if (!this.userSetXValueCount) {
            this.xValueCount = this.actualXValueCount;
        }
    }

    protected void buildErrorLists() {
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        int errorLowVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.errorLowRole, 0));
        int errorHighVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.errorHighRole, 0));
        this.errorLowList = null;
        this.errorHighList = null;
        if (grpVarIndex == -1 && this.numberOfResponse <= 1) {
            if (errorLowVarIndex > -1) {
                this.errorLowList = new LinkedHashMap();
            }
            if (errorHighVarIndex > -1) {
                this.errorHighList = new LinkedHashMap();
            }
            if (errorLowVarIndex > -1 || errorHighVarIndex > -1) {
                for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                    String catObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.categoryRole, 0), (long)i, null);
                    int catVal = this.categoryMapper.getIndex(catObj);
                    if (errorLowVarIndex > -1) {
                        double errorLowVal = this.filter.getNumericValue(this.roles.getVariable((Object)this.errorLowRole, 0), (long)i);
                        if (catObj != null && !Double.isNaN(errorLowVal) && errorLowVal > 0.0) {
                            this.errorLowList.put(new Integer(catVal), new Double(errorLowVal));
                        }
                    }
                    if (errorHighVarIndex <= -1) continue;
                    double errorHighVal = this.filter.getNumericValue(this.roles.getVariable((Object)this.errorHighRole, 0), (long)i);
                    if (catObj == null || Double.isNaN(errorHighVal) || !(errorHighVal > 0.0)) continue;
                    this.errorHighList.put(new Integer(catVal), new Double(errorHighVal));
                }
            }
        }
    }

    public void setShowLabel(boolean flag) {
        this.userSetProperties.set(816);
        this.showLabels = flag;
        this.fireLayerListenerChanged(1);
    }

    public void setShowGraphedLabel(boolean flag) {
        this.userSetProperties.set(817);
        this.showGraphedLabels = flag;
        this.fireLayerListenerChanged(1);
    }

    @Override
    public void dispose() {
        this.categoryRole = null;
        this.responseRole = null;
        this.groupRole = null;
        this.categoryMapper = null;
        this.groupMapper = null;
        this.rbBar = null;
        this.responseSign = null;
        this.colorBy = null;
        this.defaultStatistics = null;
        this.tuple = null;
        this.categoryList = null;
        this.errorLowList = null;
        this.errorHighList = null;
        this.colorIndexList = null;
        this.barLabelFont = null;
        this.axisDefaults = null;
        super.dispose();
    }

    protected abstract void getProjectedBar(double var1, double var3, double var5, double var7, int var9, double[] var10, double[] var11);

    protected void setDefaultBarLabelFont() {
        int size = 0;
        size = (int)(0.5 * Math.sqrt(this.bounds.height) * this.axisDefaults.fontSizeAdjust);
        size = Math.max(this.axisDefaults.minAdjustedValueFontSize, Math.min(this.axisDefaults.maxAdjustedValueFontSize, size));
        this.barLabelFont = FontManager.getFont((String)this.axisDefaults.valueFontName, (int)this.axisDefaults.valueFontType, (int)size);
    }

    @Override
    public Object getVariable(Object role) {
        return super.getVariable(role);
    }

    @Override
    public Object getAllVariables(Object role) {
        return super.getAllVariables(role);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (role == null || variableId == null) {
            return false;
        }
        return super.setRole(variableId, role);
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (role == null || variableId == null) {
            return false;
        }
        return super.addRole(variableId, role);
    }

    public Object[][] buildSupportedSortableRoles() {
        if (this.filter == null) {
            return null;
        }
        boolean cat = false;
        boolean resp = false;
        if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.categoryRole, 0))) {
            cat = true;
        }
        if (!(this.disableSortByResponse || this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1 || this.allowMultiResponse && this.numberOfResponse > 1)) {
            resp = true;
        }
        if (cat && resp) {
            return new Object[][]{{this.categoryRole, this.responseRole}};
        }
        if (cat) {
            return new Object[][]{{this.categoryRole}};
        }
        if (resp) {
            return new Object[][]{{this.responseRole}};
        }
        return null;
    }

    public int[] buildSupportedSortDirections(Object role) {
        if (role == null || this.filter == null) {
            return null;
        }
        if (role instanceof Number && ((Number)role).intValue() == 1) {
            return new int[]{1, -1, 0};
        }
        if (role instanceof Number && ((Number)role).intValue() == 17) {
            if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.categoryRole, 0))) {
                return new int[]{1, -1};
            }
            return new int[]{-2, 1, -1};
        }
        return null;
    }

    protected void setCategorySortOrder() {
        this.categorySortType = this.roles.getSortOrder((Object)this.categoryRole);
        this.responseSortType = null;
        if (this.categoryMapper != null && this.categorySortType instanceof Number) {
            this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
        }
    }

    protected void setResponseSortOrder() {
        if (this.categoryMapper == null) {
            return;
        }
        if (this.responseSortType == RoleInterface.ROLE_SORT_NONE) {
            if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.categoryRole, 0))) {
                this.categorySortType = new Integer(0);
            }
            this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
            return;
        }
        if (this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1 || this.allowMultiResponse && this.numberOfResponse > 1) {
            this.responseSortType = null;
            if (this.categorySortType == null) {
                this.categorySortType = new Integer(-3);
            }
            this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
        } else {
            this.categorySortType = new Integer(-3);
            this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
            Object[] catArray = this.categoryMapper.getValues();
            ArrayList responseValsList = new ArrayList();
            this.buildResponseValuesList(catArray, responseValsList);
            int cOrder = -1;
            if (this.responseSortType == RoleInterface.ROLE_SORT_ASCENDING) {
                cOrder = 1;
            } else if (this.responseSortType == RoleInterface.ROLE_SORT_DESCENDING) {
                cOrder = -1;
            }
            this.sortCategoriesOnResponse(catArray, responseValsList, cOrder);
        }
    }

    protected void persistSortOrder() {
        if (this.responseSortType != null) {
            this.setResponseSortOrder();
        } else {
            this.setCategorySortOrder();
        }
    }

    protected void setSortOrder(RoleEvent re) {
        if (this.filter == null || this.categoryMapper == null) {
            return;
        }
        int roleInt = re.role;
        if (roleInt == 1) {
            if (this.categorySortType != null && this.categorySortType.equals(this.roles.getSortOrder((Object)this.categoryRole))) {
                return;
            }
            this.setCategorySortOrder();
        } else if (roleInt == 17) {
            if (this.categoryList == null || this.defaultStatistics == null) {
                return;
            }
            Object order = this.roles.getSortOrder((Object)this.responseRole);
            if (this.responseSortType != null && this.responseSortType.equals(order)) {
                return;
            }
            if (RoleInterface.ROLE_SORT_DATA.equals(order)) {
                return;
            }
            this.responseSortType = order;
            this.setResponseSortOrder();
        }
    }

    protected void sortCategoriesOnResponse(Object[] catArray, ArrayList unsortedResponseArrayList, int cOrder) {
        Object catObject = this.roles.getVariable((Object)this.categoryRole, 0);
        int xVarIndex = this.filter.getVariableIndex(catObject);
        LinkedHashMap<String, Integer> mapCatToObsIndex = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            String catObj = this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)i, null);
            mapCatToObsIndex.put(catObj, new Integer(i));
        }
        Object[] unSortedCatIndexArray = mapCatToObsIndex.values().toArray();
        int nCat = unSortedCatIndexArray.length;
        ArrayList<Double> unSortedTopResArray = new ArrayList<Double>();
        Object respObject = this.roles.getVariable((Object)this.responseRole, 0);
        for (int catIdxItr = 0; catIdxItr < nCat; ++catIdxItr) {
            int obsIdx = ((Number)unSortedCatIndexArray[catIdxItr]).intValue();
            double respValue = this.filter.getNumericValue(respObject, (long)obsIdx);
            if (Double.isNaN(respValue)) {
                respValue = Double.NEGATIVE_INFINITY;
            }
            unSortedTopResArray.add(new Double(respValue));
        }
        Collection c = CollectionSorter.getValues(unSortedTopResArray.subList(0, unSortedTopResArray.size()), cOrder);
        Object[] sortedTopRespArray = c.toArray();
        this.categoryMapper.removeAllValues();
        int sortedSize = sortedTopRespArray.length;
        int unsortedSize = unSortedTopResArray.size();
        for (int sortedItr = 0; sortedItr < sortedSize; ++sortedItr) {
            for (int unsortedItr = 0; unsortedItr < unsortedSize; ++unsortedItr) {
                if (!sortedTopRespArray[sortedItr].equals(unSortedTopResArray.get(unsortedItr))) continue;
                int obsIdx = ((Number)unSortedCatIndexArray[unsortedItr]).intValue();
                String catObj = this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)obsIdx, null);
                this.categoryMapper.addValue(catObj);
            }
        }
    }

    protected void buildResponseValuesList(Object[] catArray, ArrayList responseValsList) {
        Object respObject = this.roles.getVariable((Object)this.responseRole, 0);
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            double respValue = this.filter.getNumericValue(respObject, (long)i);
            if (Double.isNaN(respValue)) {
                respValue = Double.NEGATIVE_INFINITY;
            }
            responseValsList.add(new Double(respValue));
        }
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        if (this instanceof AbstractBarParmElement && (dim == 1 || dim == 2) && (range instanceof DiscreteRange || range instanceof OrdinalRange) && this.categoryMapper != null) {
            DiscreteRange dr = (DiscreteRange)range;
            Vector values = dr.getValues();
            int size = values.size();
            boolean rebuild = false;
            if (size != this.categoryMapper.getNumberValues()) {
                rebuild = true;
            }
            this.categoryMapper.removeAllValues();
            for (int catIndex = 0; catIndex < size; ++catIndex) {
                this.categoryMapper.addValue(values.elementAt(catIndex));
            }
            this.buildErrorLists();
            if (rebuild) {
                this.prefInnerMargin.left = 0;
                this.prefInnerMargin.right = 0;
                if (this.categoryList != null) {
                    this.actualXValueCount = this.categoryList.keySet().toArray().length;
                    if (!this.userSetXValueCount) {
                        this.xValueCount = this.actualXValueCount;
                    }
                }
                this.layoutChart();
            }
        }
    }

    public int getXValueCount() {
        return Math.max(this.actualXValueCount, this.xValueCount);
    }

    public void setXValueCount(int count) {
        this.userSetXValueCount = count >= 1;
        this.xValueCount = count;
        this.fireLayerListenerChanged(7);
    }

    public int getXActualValueCount() {
        return this.actualXValueCount;
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return this.allowMultiResponse;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsoluteSort(boolean absoluteSort) {
        this.absoluteSort = absoluteSort;
    }

    public void setAbsoluteSort(boolean absoluteSort, int sortOrder) {
        this.absoluteSort = absoluteSort;
        this.sortOrder = sortOrder;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public boolean isAbsoluteSort() {
        return this.absoluteSort;
    }

    protected boolean checkNegative(double responseValue) {
        return responseValue < 0.0;
    }

    protected boolean isNegative() {
        return this.isNegative;
    }

    public void checkNegativeValues(double value) {
        this.isNegative = value < 0.0;
    }

    protected void populateLabels(double respValue_l, double projection, LinkedHashMap labelList) {
        int grpVarIndex;
        double allRespVal = 0.0;
        double graphedVal = 0.0;
        double[] respVals = new double[2];
        allRespVal = respValue_l;
        if (!this.isGraphed) {
            graphedVal = respValue_l;
        }
        if ((grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0))) > -1) {
            double[] tempVal = null;
            double catKey = projection;
            if (labelList.containsKey(new Double(catKey)) && (tempVal = (double[])labelList.get(new Double(catKey))) != null) {
                double val = tempVal[0];
                allRespVal += val;
                graphedVal += tempVal[1];
            }
        }
        respVals[0] = allRespVal;
        respVals[1] = graphedVal;
        labelList.put(new Double(projection), respVals);
    }

    protected Object[] getCatValues() {
        if (this.categoryMapper != null) {
            Object[] obj = this.categoryMapper.getValues();
            return obj;
        }
        return null;
    }

    protected AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    protected boolean isGraphed(int i) {
        return this.filter.isGraphed((long)i);
    }

    public void setGraphTransparency(double a) {
        int alpha = 0;
        alpha = a < 0.0 ? 0 : (a > 1.0 ? 255 : (int)(255.0 * a));
        this.transparencyColor = new Color(this.transparencyColor.getRed(), this.transparencyColor.getGreen(), this.transparencyColor.getBlue(), alpha);
    }

    public void setGraphTransparencyColor(Color c) {
        this.transparencyColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.transparencyColor.getAlpha());
    }

    protected void drawOutline(Graphics g, int x, int y, int width, int height, boolean isGraphed) {
        Color outlineColor = this.getOutlineColor();
        if (!isGraphed) {
            outlineColor = new Color(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), (int)((1.0 - this.croppedTransparency) * 255.0));
        }
        g.setColor(outlineColor);
        Graphics2D g2 = null;
        Stroke s = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
        }
        if (g2 != null) {
            s = g2.getStroke();
            g2.setStroke(this.getOutlineStroke());
        }
        g.drawRect(x, y, width, height);
        if (g2 != null) {
            g2.setStroke(s);
        }
    }

    protected Color adjustForFillTransparency(Color c, StyleElement localOverrides) {
        Color c2 = c;
        if (localOverrides != null) {
            int alpha = (int)(255.0 - 255.0 * localOverrides.getAsFillStyle().getFillTransparency());
            c2 = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        return c2;
    }

    public int getResponseStatDisplay() {
        return this.responseStatDisplay;
    }

    public void setResponseStatDisplay(int responseStatDisplay) {
        this.responseStatDisplay = responseStatDisplay;
        this.findStatusOfStatOnAxis();
        this.userSetProperties.set(818);
        this.fireLayerListenerChanged(7);
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        boolean b = super.applyWhereClause(clause, clearPrevious);
        this.findStatusOfStatOnAxis();
        this.fireLayerListenerChanged(7);
        return b;
    }

    private void findStatusOfStatOnAxis() {
        if (this.getResponseStatDisplay() == 0) {
            int observations = this.filter.getNumberObservations(-1);
            SILKNumber categoryRole = this.role.getRoleObject("ROLE_CATEGORY");
            Object o = this.roles.getVariable((Object)categoryRole, 0);
            CharacterVariableMapper categoryMapper = new CharacterVariableMapper(this.filter, o);
            int numberOfBars = categoryMapper.getNumberValues();
            this.showStatOnAxis = observations != numberOfBars;
        } else {
            this.showStatOnAxis = false;
        }
    }

    protected double getResponseValues(Object[] summaryVars, Object respVar1, Object frequencyVar1, Object[] summaryVarVals1, int statType1) {
        double responseValue = 0.0;
        responseValue = this.defaultStatistics.getSummaryStatistic(summaryVars, respVar1, frequencyVar1, summaryVarVals1, statType1);
        this.isNegative = this.checkNegative(responseValue);
        responseValue = this.isAbsolute() ? Math.abs(responseValue) : responseValue;
        return responseValue;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] supportedRoles = super.getSupportedRoles(id, discrete);
        List<Object> supportedRoleList = Arrays.asList(supportedRoles);
        ArrayList<Object> modifiedList = new ArrayList<Object>(supportedRoleList);
        Object groupVar = this.roles.getVariable(RoleInterface.ROLE_GROUP);
        if (groupVar != null) {
            modifiedList.remove((Object)this.role.getRoleObject("ROLE_ERROR_HIGH"));
            modifiedList.remove((Object)this.role.getRoleObject("ROLE_ERROR_LOW"));
        }
        Object errorLowVar = this.roles.getVariable(RoleInterface.ROLE_ERROR_LOW);
        Object errorHighVar = this.roles.getVariable(RoleInterface.ROLE_ERROR_HIGH);
        if (errorLowVar != null || errorHighVar != null) {
            SILKNumber groupRole = this.role.getRoleObject("ROLE_GROUP");
            modifiedList.remove((Object)groupRole);
        }
        return modifiedList.toArray(new Object[0]);
    }

    protected int getGroupObsIndex(String catVal, String grpVal) {
        int catIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.categoryRole, 0));
        int grpIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            String catValue = this.filter.getFormattedValue(this.filter.getVariableId(catIndex), (long)i, null);
            String grpValue = this.filter.getFormattedValue(this.filter.getVariableId(grpIndex), (long)i, null);
            if (!catValue.equals(catVal) || !grpValue.equals(grpVal)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected TabPanelInterface loadPanel(Object className, Object listener) {
        if (className == null) {
            return null;
        }
        Class tabClass = this.loadClass(className.toString());
        if (tabClass == null) {
            return null;
        }
        AbstractBarParmElement pi = this;
        if (listener instanceof PropertyInterface) {
            pi = (PropertyInterface)listener;
        }
        try {
            Constructor tabClassCons = tabClass.getConstructor(PropertyInterface.class);
            Object o = tabClassCons.newInstance(pi);
            if (o instanceof TabPanelInterface) {
                TabPanelInterface tpi = (TabPanelInterface)o;
                tpi.addPropertyListener(pi);
                return tpi;
            }
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

