/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.bar;

import com.sas.graphics.silk.bar.BarModel;
import com.sas.graphics.silk.data.JavaDataFilter;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.util.SILKNumber;
import java.util.LinkedHashMap;
import java.util.Vector;

public class AreaBarModel
extends BarModel {
    public static final int ROLE_WIDTH = 9;
    public static final int NUM_ROLES = 10;
    public static final int ROLE_MULTI_RESPONSE = 10;
    protected Vector barWidthValues;
    protected double totalWidthScale = 0.0;
    protected static final SILKNumber WIDTH_ROLE_NAME = ROLES.getRoleObject("ROLE_WIDTH");

    public AreaBarModel(DataFilterReadInterface data) {
        super(data);
        this.variables = new Object[10];
    }

    public AreaBarModel() {
        this(null);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        if (role instanceof Number && ((Number)role).intValue() == 6 || role instanceof String && (((String)role).equalsIgnoreCase("Group") || ((String)role).equalsIgnoreCase(GROUP_ROLE_NAME.toString()))) {
            return false;
        }
        if (role instanceof Number && ((Number)role).intValue() == 67 || role instanceof String && (((String)role).equalsIgnoreCase("Width") || ((String)role).equalsIgnoreCase(WIDTH_ROLE_NAME.toString()))) {
            if (variableId == null) {
                return false;
            }
            if (variableId != null && !this.dataIn.verifyVariable(variableId)) {
                return false;
            }
            if (!this.dataIn.isNumericVariable(variableId)) {
                return false;
            }
            this.variables[9] = this.dataIn.getExactVariableId(variableId);
            this.sortType = 0;
            this.responseSortType = 0;
            this.reSum = true;
            this.userMax = Double.NaN;
            this.userMin = Double.NaN;
            this.userSetCategories = false;
            this.userSetGroups = false;
            return true;
        }
        return super.setRole(variableId, role);
    }

    @Override
    public Object getRole(Object variableId) {
        if (this.variables[9] != null && this.variables[9].equals(variableId)) {
            return WIDTH_ROLE_NAME;
        }
        return super.getRole(variableId);
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        if (role instanceof Number && ((Number)role).intValue() == 67 || role instanceof String && (((String)role).equalsIgnoreCase("Width") || ((String)role).equalsIgnoreCase(WIDTH_ROLE_NAME.toString()))) {
            if (this.variables[9] == null || !((String)this.variables[9]).equalsIgnoreCase((String)variableId)) {
                return false;
            }
            this.variables[9] = null;
            this.reSum = true;
            this.userMax = Double.NaN;
            this.userMin = Double.NaN;
            this.userSetCategories = false;
            this.userSetGroups = false;
            return true;
        }
        return super.removeRole(variableId, role);
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        if (this.getVariableInModel("Width") != null) {
            return null;
        }
        return super.getSupportedSortableRoles();
    }

    @Override
    protected Object getVariableInModel(Object role) {
        if (role == null) {
            return null;
        }
        if (((String)role).equalsIgnoreCase("Width")) {
            return this.getVariableInModel(9);
        }
        return super.getVariableInModel(role);
    }

    @Override
    public Object getVariable(Object role) {
        if (role == null) {
            return null;
        }
        if (role instanceof Number && ((Number)role).intValue() == 67 || role instanceof String && (((String)role).equalsIgnoreCase("Width") || ((String)role).equalsIgnoreCase(WIDTH_ROLE_NAME.toString()))) {
            return this.variables[9];
        }
        return super.getVariable(role);
    }

    @Override
    protected boolean doSummarization() {
        int i;
        int i2;
        int tmp;
        if (!this.reSum) {
            return true;
        }
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        if (this.variables[0] == null) {
            return false;
        }
        this.outOfMemory = false;
        this.freeMemory();
        if (!this.userSetCategories) {
            this.categoryNames = this.getUniqueNames(this.variables[0]);
        }
        this.variables[2] = null;
        this.groupNames = null;
        this.actualXValueCount = this.getNumberCategories();
        if (this.isMultiResponses()) {
            this.actualXValueCount = this.getNumberResponses() * this.getNumberCategories() + (this.getNumberCategories() - 1);
        } else if (this.groupNames != null) {
            int groups = this.getNumberGroups();
            this.actualXValueCount = this.getNumberCategories() * groups + (groups - 1);
        }
        if (this.isMultiResponses()) {
            return this.summarizeMultiResponses();
        }
        if (this.variables[3] != null) {
            this.subgroupNames = new Vector(this.getUniqueNames(this.variables[3]).keySet());
        }
        if (this.variables[5] != null) {
            tmp = this.categoryNames.size() * (this.variables[2] != null ? this.groupNames.size() : 1) * (this.variables[3] != null ? this.subgroupNames.size() : 1);
            this.tipNames = new Vector();
            for (i2 = 0; i2 < tmp; ++i2) {
                this.tipNames.addElement(null);
            }
        }
        if (this.variables[9] != null) {
            tmp = this.categoryNames.size() * (this.variables[2] != null ? this.groupNames.size() : 1) * (this.variables[3] != null ? this.subgroupNames.size() : 1);
            this.barWidthValues = new Vector();
            for (i2 = 0; i2 < tmp; ++i2) {
                this.barWidthValues.addElement(null);
            }
        }
        if (this.variables[4] != null) {
            this.colorIndexNames = new Vector(this.getUniqueNamesUnformatted(this.variables[4]).keySet());
            for (int i3 = 0; i3 < this.colorIndexNames.size(); ++i3) {
                if (this.colorIndexNames.elementAt(i3).equals(this.missingSymbol)) {
                    this.colorIndexNames.setElementAt(new Double(0.0), i3);
                    continue;
                }
                if (!(this.colorIndexNames.elementAt(i3) instanceof Number) || ((Number)this.colorIndexNames.elementAt(i3)).intValue() >= 0) continue;
                this.colorIndexNames.setElementAt(new Double(Math.abs(((Number)this.colorIndexNames.elementAt(i3)).intValue())), i3);
            }
        }
        if (this.variables[6] != null && this.subgroupNames != null) {
            this.errorHighNames = new Vector(this.getUniqueNames(this.variables[6]).keySet());
        }
        if (this.variables[7] != null && this.subgroupNames != null) {
            this.errorLowNames = new Vector(this.getUniqueNames(this.variables[7]).keySet());
        }
        int way = -1;
        int obs = 0;
        Object varId = this.variables[0];
        if (this.variables[2] == null && this.variables[3] == null) {
            obs = this.categoryNames.size();
            way = 0;
        } else if (this.variables[2] != null && this.variables[3] == null) {
            obs = this.categoryNames.size() * this.groupNames.size();
            way = 1;
        } else if (this.variables[2] == null && this.variables[3] != null) {
            obs = this.categoryNames.size() * this.subgroupNames.size();
            way = 1;
            varId = this.variables[3];
        } else if (this.variables[2] != null && this.variables[3] != null) {
            obs = this.categoryNames.size() * this.subgroupNames.size() * this.groupNames.size();
            way = 2;
            varId = this.variables[3];
        }
        Object[] uniqueValuesArray = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(varId, false, this.MAX_OBS_IN_MODEL);
        if (uniqueValuesArray != null) {
            this.uniqueValueList = new LinkedHashMap();
            for (int j = 0; j < uniqueValuesArray.length; ++j) {
                this.uniqueValueList.put(uniqueValuesArray[j], new Integer(j));
            }
        } else {
            this.uniqueValueList = null;
        }
        if (obs > this.MAX_OBS_IN_MODEL) {
            this.outOfMemory = true;
            this.reSum = false;
            return false;
        }
        int numColumns = 0;
        for (int i4 = 0; i4 < this.variables.length; ++i4) {
            if (this.variables[i4] == null) continue;
            ++numColumns;
        }
        int widthCol = 0;
        if (this.variables[9] != null) {
            widthCol = 1;
        }
        Object[] columnNames = new Object[numColumns + metaNames.length + widthCol];
        this.dataOut = new JavaDataFilter();
        numColumns = 0;
        for (i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == null) continue;
            this.dataOut.defineVariable(this.getVariableInModel(i), (Object)"", null);
            columnNames[numColumns] = this.getVariableInModel(i);
            ++numColumns;
        }
        for (i = 0; i < metaNames.length; ++i) {
            this.dataOut.defineVariable((Object)metaNames[i], (Object)"", null);
            columnNames[numColumns] = metaNames[i];
            ++numColumns;
        }
        if (this.variables[9] != null) {
            this.dataOut.defineVariable((Object)"BarWidth", (Object)"", null);
            columnNames[numColumns] = "BarWidth";
            ++numColumns;
        }
        for (i = 0; i < obs; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                this.dataOut.setValue(columnNames[j], -1L, null);
            }
        }
        this.selectedValues = new double[obs];
        for (i = 0; i < obs; ++i) {
            this.selectedValues[i] = 0.0;
        }
        switch (way) {
            case 0: {
                this.summarizeByCategory();
                break;
            }
            case 1: {
                this.summarizeByGroup();
                break;
            }
            case 2: {
                this.summarizeByGroupAndSubgroup();
            }
        }
        String fmt = null;
        if (this.variables[1] != null && (fmt = (String)this.dataIn.getFormat(this.variables[1], String.class)) != null && !fmt.equals("")) {
            this.dataOut.setFormat(this.getVariableInModel(1), (Object)fmt);
        }
        if (this.variables[9] != null && (fmt = (String)this.dataIn.getFormat(this.variables[9], String.class)) != null && !fmt.equals("")) {
            this.dataOut.setFormat(this.getVariableInModel(9), (Object)fmt);
        }
        this.reSum = false;
        if (this.reMapping) {
            this.createSortMapping();
        }
        return true;
    }

    @Override
    protected boolean summarizeByCategory() {
        int obs = this.categoryNames.size();
        double[] sum = new double[obs];
        double[] freq = new double[obs];
        Vector[] obsNo = new Vector[obs];
        boolean[] missing = new boolean[obs];
        boolean dropObs = false;
        int[] colorIndexs = new int[obs];
        double[] errorHighs = new double[obs];
        double[] errorLows = new double[obs];
        for (int i = 0; i < obs; ++i) {
            obsNo[i] = new Vector();
            sum[i] = 0.0;
            freq[i] = 0.0;
            missing[i] = true;
            errorHighs[i] = 0.0;
            errorLows[i] = 0.0;
        }
        int xId = this.dataIn.getVariableIndex(this.variables[0]);
        int fId = this.dataIn.getVariableIndex(this.variables[8]);
        int cId = this.dataIn.getVariableIndex(this.variables[4]);
        int tId = this.dataIn.getVariableIndex(this.variables[5]);
        Object tip = null;
        int wId = this.dataIn.getVariableIndex(this.variables[9]);
        Object barWidth = null;
        int eHId = this.dataIn.getVariableIndex(this.variables[6]);
        Object errorH = null;
        int eLId = this.dataIn.getVariableIndex(this.variables[7]);
        Object errorL = null;
        int statId = this.dataIn.getVariableIndex(this.variables[1]);
        Object x = null;
        Object s = null;
        Object clr = null;
        int index = -1;
        long rows = this.dataIn.getNumberObservations(-1);
        this.summarized = false;
        this.totalWidthScale = 0.0;
        LinkedHashMap<Integer, Object> names = new LinkedHashMap<Integer, Object>();
        if (wId == -1) {
            this.responseVals = new LinkedHashMap();
            this.responseVals.clear();
            this.responseValsABS = new LinkedHashMap();
            this.responseValsABS.clear();
        } else {
            this.responseVals = null;
            this.responseValsABS = null;
        }
        this.totalFreqVal = 0.0;
        for (long i = 0L; i < rows; ++i) {
            boolean addIn = true;
            dropObs = false;
            x = this.dataIn.getValue(xId, i);
            index = this.getNameIndex(xId, this.categoryNames, x);
            obsNo[index].addElement(new Integer((int)i));
            this.obsMapping[(int)i] = index;
            if (fId >= 0 && (Double.isNaN(((Number)(s = this.dataIn.getValue(fId, i))).doubleValue()) || ((Number)s).doubleValue() < 0.0)) {
                dropObs = true;
            }
            if (dropObs) continue;
            if (statId >= 0 && Double.isNaN(((Number)(s = this.dataIn.getValue(statId, i))).doubleValue())) {
                dropObs = true;
            }
            if (dropObs) continue;
            if (wId >= 0 && Double.isNaN(((Number)(barWidth = this.dataIn.getValue(wId, i))).doubleValue())) {
                dropObs = true;
            }
            if (dropObs) continue;
            if (cId >= 0) {
                clr = this.dataIn.getValue(cId, i);
                colorIndexs[index] = !this.dataIn.isMissing(cId, clr) ? (int)((Number)clr).doubleValue() : 0;
            }
            if (tId > -1) {
                tip = this.dataIn.getValue(tId, i);
                this.tipNames.setElementAt(tip, index);
            }
            int freqVal = 1;
            if (fId >= 0) {
                s = this.dataIn.getValue(fId, i);
                if (!this.dataIn.isMissing(fId, s) && ((Number)s).intValue() >= 0) {
                    freqVal = ((Number)s).intValue();
                    missing[index] = false;
                } else {
                    freqVal = 0;
                }
            }
            if (statId >= 0 && !this.isDiscrete("Y") && this.dataIn.isNumericVariable(statId)) {
                s = this.dataIn.getValue(statId, i);
                if (!this.dataIn.isMissing(statId, s)) {
                    int n = index;
                    sum[n] = sum[n] + ((Number)s).doubleValue() * (double)freqVal;
                    missing[index] = false;
                } else {
                    addIn = false;
                }
            }
            if (addIn) {
                int n = index;
                freq[n] = freq[n] + (double)freqVal;
                this.totalFreqVal += (double)freqVal;
                if (!this.summarized && freq[index] > 1.0) {
                    this.summarized = true;
                }
                if (this.dataIn.isSelected(i)) {
                    this.obsSelected[(int)i] = true;
                    int n2 = index;
                    this.selectedValues[n2] = this.selectedValues[n2] + (double)freqVal;
                }
            }
            if (wId > -1 && (barWidth = this.dataIn.getValue(wId, i)) != null && barWidth instanceof Number) {
                if (!Double.isNaN(((Number)barWidth).doubleValue())) {
                    if (statId == -1 || statId >= 0 && !missing[index]) {
                        if (!names.containsKey(new Integer(index))) {
                            names.put(new Integer(index), barWidth);
                            this.barWidthValues.setElementAt(barWidth, index);
                        } else if (names.containsKey(new Integer(index))) {
                            Object obj = names.get(new Integer(index));
                            double val = ((Number)obj).doubleValue();
                            val = Double.isNaN(val) ? ((Number)barWidth).doubleValue() : (val += ((Number)barWidth).doubleValue());
                            this.barWidthValues.setElementAt(new Double(val), index);
                            names.put(new Integer(index), new Double(val));
                        }
                    } else if (!names.containsKey(new Integer(index))) {
                        names.put(new Integer(index), new Double(0.0));
                        this.barWidthValues.setElementAt(barWidth, index);
                    }
                } else if (!names.containsKey(new Integer(index))) {
                    names.put(new Integer(index), new Double(Double.NaN));
                    this.barWidthValues.setElementAt(barWidth, index);
                }
            }
            if (eHId >= 0) {
                errorH = this.dataIn.getValue(eHId, i);
                errorHighs[index] = ((Number)errorH).doubleValue();
            }
            if (eLId < 0) continue;
            errorL = this.dataIn.getValue(eLId, i);
            errorLows[index] = ((Number)errorL).doubleValue();
        }
        Object catName = this.getVariableInModel(0);
        Object respName = this.getVariableInModel(1);
        Object tName = this.getVariableInModel(5);
        Object wName = this.getVariableInModel(9);
        Object cName = this.getVariableInModel(4);
        Object eHName = this.getVariableInModel(6);
        Object eLName = this.getVariableInModel(7);
        Object[] catArray = this.categoryNames.keySet().toArray();
        Object[] widthArray = null;
        if (this.barWidthValues != null) {
            widthArray = this.barWidthValues.toArray();
        }
        for (int i = 0; i < obs; ++i) {
            int size = obsNo[i].size();
            int[] obsArray = new int[size];
            for (int j = 0; j < size; ++j) {
                obsArray[j] = (Integer)obsNo[i].elementAt(j);
            }
            this.dataOut.setValue(catName, (long)i, catArray[i]);
            this.dataOut.setValue((Object)"Frequency", (long)i, (Object)new Double(freq[i]));
            this.dataOut.setValue((Object)"Observations", (long)i, (Object)obsArray);
            double resp = freq[i];
            if (this.statType == 4) {
                resp = freq[i] * 100.0 / this.getTotalFreqVal();
            }
            if (wId > -1) {
                this.dataOut.setValue(wName, (long)i, this.barWidthValues.elementAt(i));
                double fullBarWidth = 0.0;
                if (widthArray[i] != null) {
                    if (!Double.isNaN(((Number)widthArray[i]).doubleValue()) && (statId == -1 || statId >= 0 && !missing[i])) {
                        fullBarWidth = ((Number)widthArray[i]).doubleValue();
                        fullBarWidth = Math.max(0.0, fullBarWidth);
                        this.dataOut.setValue((Object)"BarWidth", (long)i, (Object)new Double(fullBarWidth));
                        this.totalWidthScale += fullBarWidth;
                    } else {
                        this.dataOut.setValue((Object)"BarWidth", (long)i, (Object)new Double(Double.NaN));
                    }
                    if (Double.isNaN(((Number)widthArray[i]).doubleValue()) || ((Number)widthArray[i]).doubleValue() < 0.0) continue;
                }
            }
            if (tId > -1) {
                this.dataOut.setValue(tName, (long)i, this.tipNames.elementAt(i));
            }
            if (cId >= 0) {
                this.dataOut.setValue(cName, (long)i, (Object)new Integer(Math.abs(colorIndexs[i])));
            }
            if (statId >= 0 && !missing[i]) {
                this.dataOut.setValue(respName, (long)i, (Object)new Double(sum[i]));
                resp = this.statType == 2 ? (freq[i] != 0.0 ? sum[i] / freq[i] : 0.0) : sum[i];
            }
            if (eHId > -1) {
                this.dataOut.setValue(eHName, (long)i, (Object)new Double(errorHighs[i]));
            }
            if (eLId > -1) {
                this.dataOut.setValue(eLName, (long)i, (Object)new Double(errorLows[i]));
            }
            if (wId != -1) continue;
            this.responseVals.put(new Integer(i), new Double(resp));
            this.responseValsABS.put(new Integer(i), new Double(Math.abs(resp)));
        }
        return true;
    }

    @Override
    protected boolean summarizeByGroup() {
        int byIndex = this.variables[2] == null ? 3 : 2;
        Object byVar = this.variables[3];
        Vector byNames = this.subgroupNames;
        int obs = this.categoryNames.size() * byNames.size();
        double[] sum = new double[obs];
        double[] freq = new double[obs];
        Vector[] obsNo = new Vector[obs];
        boolean[] missing = new boolean[obs];
        boolean dropObs = false;
        int[] colorIndexs = new int[obs];
        double[] errorHighs = new double[obs];
        double[] errorLows = new double[obs];
        int wId = this.dataIn.getVariableIndex(this.variables[9]);
        Object barWidth = null;
        this.totalWidthScale = 0.0;
        LinkedHashMap<Integer, Object> names = new LinkedHashMap<Integer, Object>();
        for (int i = 0; i < obs; ++i) {
            obsNo[i] = new Vector();
            sum[i] = 0.0;
            freq[i] = 0.0;
            missing[i] = true;
            colorIndexs[i] = -1;
            errorHighs[i] = 0.0;
            errorLows[i] = 0.0;
        }
        int xId = this.dataIn.getVariableIndex(this.variables[0]);
        int fId = this.dataIn.getVariableIndex(this.variables[8]);
        int gId = this.dataIn.getVariableIndex(byVar);
        int cId = byIndex == 3 ? this.dataIn.getVariableIndex(this.variables[4]) : -1;
        int statId = this.dataIn.getVariableIndex(this.variables[1]);
        int tId = this.dataIn.getVariableIndex(this.variables[5]);
        int eHId = this.dataIn.getVariableIndex(this.variables[6]);
        Object errorH = null;
        int eLId = this.dataIn.getVariableIndex(this.variables[7]);
        Object errorL = null;
        Object tip = null;
        Object x = null;
        Object g = null;
        Object s = null;
        Object clr = null;
        long rows = this.dataIn.getNumberObservations(-1);
        int namesPerGroup = this.categoryNames.size();
        int index = -1;
        this.summarized = false;
        this.responseVals = null;
        this.totalFreqVal = 0.0;
        for (long i = 0L; i < rows; ++i) {
            boolean addIn = true;
            dropObs = false;
            x = this.dataIn.getValue(xId, i);
            g = this.dataIn.getValue(gId, i);
            int xIdx = this.getNameIndex(xId, this.categoryNames, x);
            int gIdx = this.getNameIndex(gId, byNames, g);
            index = xIdx + gIdx * namesPerGroup;
            obsNo[index].addElement(new Integer((int)i));
            this.obsMapping[(int)i] = index;
            if (fId >= 0 && (Double.isNaN(((Number)(s = this.dataIn.getValue(fId, i))).doubleValue()) || ((Number)s).doubleValue() < 0.0)) {
                dropObs = true;
            }
            if (dropObs) continue;
            if (statId >= 0 && Double.isNaN(((Number)(s = this.dataIn.getValue(statId, i))).doubleValue())) {
                dropObs = true;
            }
            if (dropObs) continue;
            if (wId >= 0 && Double.isNaN(((Number)(barWidth = this.dataIn.getValue(wId, i))).doubleValue())) {
                dropObs = true;
            }
            if (dropObs) continue;
            if (cId >= 0) {
                clr = this.dataIn.getValue(cId, i);
                colorIndexs[index] = !this.dataIn.isMissing(cId, clr) ? (int)((Number)clr).doubleValue() : 0;
            }
            if (tId > -1) {
                tip = this.dataIn.getValue(tId, i);
                this.tipNames.setElementAt(tip, index);
            }
            int freqVal = 1;
            if (fId >= 0) {
                s = this.dataIn.getValue(fId, i);
                freqVal = !this.dataIn.isMissing(fId, s) && ((Number)s).intValue() >= 0 ? ((Number)s).intValue() : 0;
            }
            if (statId >= 0 && !this.isDiscrete("Y") && this.dataIn.isNumericVariable(statId)) {
                s = this.dataIn.getValue(statId, i);
                if (!this.dataIn.isMissing(statId, s)) {
                    int n = index;
                    sum[n] = sum[n] + ((Number)s).doubleValue() * (double)freqVal;
                    missing[index] = false;
                } else {
                    addIn = false;
                }
            }
            if (addIn) {
                int n = index;
                freq[n] = freq[n] + (double)freqVal;
                this.totalFreqVal += (double)freqVal;
                if (!this.summarized && freq[index] > 1.0) {
                    this.summarized = true;
                }
                if (this.dataIn.isSelected(i)) {
                    this.obsSelected[(int)i] = true;
                    int n2 = index;
                    this.selectedValues[n2] = this.selectedValues[n2] + (double)freqVal;
                }
            }
            if (wId > -1 && (barWidth = this.dataIn.getValue(wId, i)) != null && barWidth instanceof Number) {
                if (!Double.isNaN(((Number)barWidth).doubleValue())) {
                    if (statId == -1 || statId >= 0 && !missing[index]) {
                        if (!names.containsKey(new Integer(xIdx))) {
                            names.put(new Integer(xIdx), barWidth);
                            this.barWidthValues.setElementAt(barWidth, xIdx);
                        } else if (names.containsKey(new Integer(xIdx))) {
                            Object obj = names.get(new Integer(xIdx));
                            double val = ((Number)obj).doubleValue() + ((Number)barWidth).doubleValue();
                            this.barWidthValues.setElementAt(new Double(val), xIdx);
                            names.put(new Integer(xIdx), new Double(val));
                        }
                    } else if (!names.containsKey(new Integer(xIdx))) {
                        names.put(new Integer(xIdx), new Double(0.0));
                        this.barWidthValues.setElementAt(barWidth, xIdx);
                    }
                } else if (!names.containsKey(new Integer(xIdx))) {
                    names.put(new Integer(xIdx), new Double(Double.NaN));
                    this.barWidthValues.setElementAt(barWidth, xIdx);
                }
            }
            if (eHId >= 0) {
                errorH = this.dataIn.getValue(eHId, i);
                errorHighs[index] = ((Number)errorH).doubleValue();
            }
            if (eLId < 0) continue;
            errorL = this.dataIn.getValue(eLId, i);
            errorLows[index] = ((Number)errorL).doubleValue();
        }
        Object catName = this.getVariableInModel(0);
        Object respName = this.getVariableInModel(1);
        Object gName = this.getVariableInModel(byIndex);
        Object cName = this.getVariableInModel(4);
        Object tName = this.getVariableInModel(5);
        Object eHName = this.getVariableInModel(6);
        Object eLName = this.getVariableInModel(7);
        Object[] catArray = this.categoryNames.keySet().toArray();
        Object wName = this.getVariableInModel(9);
        Object[] widthArray = null;
        if (this.barWidthValues != null) {
            widthArray = this.barWidthValues.toArray();
        }
        int num = byNames.size();
        for (int i = 0; i < num; ++i) {
            for (int j = 0; j < namesPerGroup; ++j) {
                index = j + i * namesPerGroup;
                int size = obsNo[index].size();
                int[] obsArray = new int[size];
                for (int k = 0; k < size; ++k) {
                    obsArray[k] = (Integer)obsNo[index].elementAt(k);
                }
                this.dataOut.setValue(catName, (long)index, catArray[j]);
                this.dataOut.setValue(gName, (long)index, byNames.elementAt(i));
                this.dataOut.setValue((Object)"Frequency", (long)index, (Object)new Double(freq[index]));
                this.dataOut.setValue((Object)"Observations", (long)index, (Object)obsArray);
                if (wId > -1) {
                    this.dataOut.setValue(wName, (long)index, this.barWidthValues.elementAt(j));
                    double fullBarWidth = 0.0;
                    if (widthArray[j] != null) {
                        if (!Double.isNaN(((Number)widthArray[j]).doubleValue())) {
                            fullBarWidth = ((Number)widthArray[j]).doubleValue();
                            fullBarWidth = Math.max(0.0, fullBarWidth);
                            this.dataOut.setValue((Object)"BarWidth", (long)index, (Object)new Double(fullBarWidth));
                            if (index < namesPerGroup) {
                                this.totalWidthScale += fullBarWidth;
                            }
                        } else {
                            this.dataOut.setValue((Object)"BarWidth", (long)index, (Object)new Double(Double.NaN));
                        }
                        if (Double.isNaN(((Number)widthArray[j]).doubleValue()) || ((Number)widthArray[j]).doubleValue() < 0.0) continue;
                    }
                }
                if (tId > -1) {
                    this.dataOut.setValue(tName, (long)index, this.tipNames.elementAt(index));
                }
                if (cId >= 0 && colorIndexs[index] != -1) {
                    this.dataOut.setValue(cName, (long)index, (Object)new Integer(Math.abs(colorIndexs[index])));
                }
                if (eHId > -1) {
                    this.dataOut.setValue(eHName, (long)index, (Object)new Double(errorHighs[index]));
                }
                if (eLId > -1) {
                    this.dataOut.setValue(eLName, (long)index, (Object)new Double(errorLows[index]));
                }
                if (statId < 0 || missing[index]) continue;
                this.dataOut.setValue(respName, (long)index, (Object)new Double(sum[index]));
            }
        }
        return true;
    }

    protected double getTotalBarWidthScale() {
        return this.totalWidthScale;
    }
}

