/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.bar;

import com.sas.graphics.silk.bar.AreaBarModel;
import com.sas.graphics.silk.bar.BarChart;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.FontManager;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;

public class AreaBar
extends BarChart {
    protected boolean widthAxis;
    protected boolean showInnerLabelsOn = true;

    public AreaBar(Object dataObject) {
        super(dataObject);
        this.scaleFactor = 1.0;
        this.widthAxis = false;
        if (this.globalDefaults.areaBarAxisRole.equalsIgnoreCase("Width")) {
            this.widthAxis = true;
        }
    }

    public AreaBar() {
        this(null);
    }

    @Override
    public boolean setDataSource(Object source) {
        if (source == null || !(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.dataIn = (DataFilterReadInterface)source;
        if (this.barModel == null) {
            this.barModel = new AreaBarModel();
        }
        if (this.barModel != null) {
            this.barModel.setDataSource(this.dataIn);
            this.dataOut = null;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return true;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        ArrayList<SILKNumber> supportedRoleList = new ArrayList<SILKNumber>();
        if (discrete) {
            supportedRoleList.add(this.roles.getRoleObject("ROLE_CATEGORY"));
            supportedRoleList.add(this.roles.getRoleObject("ROLE_FREQUENCY"));
            supportedRoleList.add(this.roles.getRoleObject("ROLE_RESPONSE"));
            supportedRoleList.add(this.roles.getRoleObject("ROLE_WIDTH"));
            if (this.getVariable(RoleInterface.ROLE_ERROR_LOW) == null && this.getVariable(RoleInterface.ROLE_ERROR_HIGH) == null) {
                supportedRoleList.add(this.roles.getRoleObject("ROLE_SUBGROUP"));
            }
            supportedRoleList.add(this.roles.getRoleObject("ROLE_COLOR_INDEX"));
            supportedRoleList.add(this.roles.getRoleObject("ROLE_TIP"));
            if (this.getVariable(RoleInterface.ROLE_SUBGROUP) == null) {
                supportedRoleList.add(this.roles.getRoleObject("ROLE_ERROR_HIGH"));
                supportedRoleList.add(this.roles.getRoleObject("ROLE_ERROR_LOW"));
            }
        } else {
            supportedRoleList.add(this.roles.getRoleObject("ROLE_FREQUENCY"));
            supportedRoleList.add(this.roles.getRoleObject("ROLE_RESPONSE"));
            supportedRoleList.add(this.roles.getRoleObject("ROLE_WIDTH"));
            supportedRoleList.add(this.roles.getRoleObject("ROLE_COLOR_INDEX"));
            supportedRoleList.add(this.roles.getRoleObject("ROLE_ERROR_HIGH"));
            supportedRoleList.add(this.roles.getRoleObject("ROLE_ERROR_LOW"));
        }
        return supportedRoleList.toArray(new Object[0]);
    }

    @Override
    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 811: {
                return this.isWidth();
            }
            case 819: {
                return true;
            }
        }
        return super.isPropertySupported(idx);
    }

    @Override
    public Object getPropertyValue(int idx) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            return this.propertyValue.elementAt(i);
        }
        switch (idx) {
            case 811: {
                if (this.widthAxis) {
                    return RoleInterface.ROLE_WIDTH;
                }
                return RoleInterface.ROLE_CATEGORY;
            }
            case 819: {
                return new Boolean(this.showInnerLabelsOn);
            }
        }
        return super.getPropertyValue(idx);
    }

    @Override
    public boolean applyPropertyChanges() {
        if (this.propertyIndex.size() <= 0) {
            return false;
        }
        block4: for (int i = 0; i < this.propertyIndex.size(); ++i) {
            int idx = (Integer)this.propertyIndex.elementAt(i);
            Object value = this.propertyValue.elementAt(i);
            switch (idx) {
                case 811: {
                    if (value == null || !(value instanceof Number)) continue block4;
                    this.setAxisRole((Number)value);
                    continue block4;
                }
                case 819: {
                    if (!(value instanceof Boolean)) continue block4;
                    this.setInnerLabelOn((Boolean)value);
                    continue block4;
                }
            }
        }
        return super.applyPropertyChanges();
    }

    @Override
    public double[] getBoundingBox() {
        if (!this.dataChanged) {
            return this.chartBBox;
        }
        if (!this.prepareChartData()) {
            return null;
        }
        if (this.barModel.isZeroObservation()) {
            this.yMin = 0.0;
            this.xMin = 0.0;
            this.yMax = 1.0;
            this.xMax = 1.0;
            this.chartBBox[0] = this.xMin;
            this.chartBBox[1] = this.yMin;
            this.chartBBox[2] = 0.0;
            this.chartBBox[3] = this.xMax;
            this.chartBBox[4] = this.yMax;
            this.chartBBox[5] = 0.0;
            return this.chartBBox;
        }
        if (this.chartType == 0) {
            double[] ends;
            this.xMin = 0.0;
            this.xMax = this.barModel.getXValueCount();
            this.numberBars = (int)this.xMax;
            if (this.isWidth() && this.widthAxis) {
                ends = this.adjustXMinXMax();
                this.xMin = ends[0];
                this.xMax = ends[1];
            }
            if ((ends = this.yAxis.getMinMaxTickMarkValues())[0] == ends[1]) {
                if (ends[1] >= 0.0) {
                    ends[1] = ends[1] + 1.0;
                } else {
                    ends[0] = ends[0] - 1.0;
                }
            }
            this.yMin = ends[0];
            double d = this.yMax = ends[1] <= 0.0 ? ends[1] : ends[1] + 0.02 * (ends[1] - ends[0]);
            if (this.barLabel && this.subgroupVariable == null) {
                this.yMax += (double)this.getBarLabelFontSize() * (ends[1] - ends[0]) / (double)this.chartAreaDimension.height;
            }
            this.respTickmarkOffset = this.yMax - ends[1];
        } else {
            double[] ends;
            if (this.barModel.isMultiResponses()) {
                this.yMin = 0.0;
                this.yMax = this.barModel.getNumberResponses() * this.barModel.getNumberCategories() + (this.barModel.getNumberCategories() - 1);
            } else if (this.groupVariable == null) {
                this.yMin = 0.0;
                this.yMax = this.barModel.getNumberCategories();
            } else {
                int groups = this.barModel.getNumberGroups();
                this.yMin = 0.0;
                this.yMax = this.barModel.getNumberCategories() * groups + (groups - 1);
            }
            this.numberBars = (int)this.yMax;
            if (this.isWidth() && this.widthAxis) {
                double[] ends2 = this.adjustYMinYMax();
                this.yMin = ends2[0];
                this.yMax = ends2[1];
            }
            if ((ends = this.xAxis.getMinMaxTickMarkValues())[0] == ends[1]) {
                if (ends[1] >= 0.0) {
                    ends[1] = ends[1] + 1.0;
                } else {
                    ends[0] = ends[0] - 1.0;
                }
            }
            this.xMin = ends[0];
            this.xMax = ends[1] <= 0.0 ? ends[1] : ends[1] + 0.02 * (ends[1] - ends[0]);
            this.respTickmarkOffset = this.xMax - ends[1];
        }
        this.chartBBox[0] = this.xMin;
        this.chartBBox[1] = this.yMin;
        this.chartBBox[2] = 0.0;
        this.chartBBox[3] = this.xMax;
        this.chartBBox[4] = this.yMax;
        this.chartBBox[5] = 0.0;
        return this.chartBBox;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        double labelWidth;
        TextLayout textString;
        String label;
        Object format;
        BarChart.BarElement e;
        if (p == null || !(p instanceof Graphics2D) || this.transObj == null || !this.visible) {
            return;
        }
        if (this.displayList == null) {
            return;
        }
        Graphics2D g = this.graphics2D = (Graphics2D)p;
        Composite comp = g.getComposite();
        if (this.opacity < 1.0) {
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)this.opacity);
            g.setComposite(alphaComp);
        }
        FontRenderContext frc = g.getFontRenderContext();
        boolean hideBarLabel = false;
        int size = this.displayList.size();
        boolean[] hideWidth = new boolean[((AreaBarModel)this.barModel).getNumberCategories()];
        if (this.barLabel && this.subgroupVariable == null) {
            for (int i = 0; i < size && !hideBarLabel; ++i) {
                e = (BarChart.BarElement)this.displayList.elementAt(i);
                if (!(e.element instanceof Rectangle2D.Double)) continue;
                Rectangle2D.Double rect2D = (Rectangle2D.Double)e.element;
                if (this.chartType == 0 && (rect2D.x + 1.0 < Math.floor(this.xMin) || rect2D.x > Math.ceil(this.xMax)) || this.chartType != 0) continue;
                format = this.dataOut.getFormat(this.yVariable, SASFormat.class);
                label = this.dataOut.getFormattedValue(this.yVariable, (Object)new Double(rect2D.y), format);
                label = label.trim();
                textString = new TextLayout(label, this.barLabelFont, frc);
                labelWidth = textString.getVisibleAdvance();
                this.transObj.project(0.0, rect2D.y, 0.0, this.scr1);
                this.transObj.project(1.0, rect2D.y, 0.0, this.scr2);
                if (!(labelWidth > this.scr2[0] - this.scr1[0])) continue;
                hideBarLabel = true;
            }
        }
        int catIter = 0;
        LinkedHashMap<Integer, TextLayout> catStr = new LinkedHashMap<Integer, TextLayout>();
        LinkedHashMap<Integer, Integer> catXPos = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> catYPos = new LinkedHashMap<Integer, Integer>();
        Color clr = g.getColor();
        for (int i = 0; i < size; ++i) {
            e = (BarChart.BarElement)this.displayList.elementAt(i);
            if (e.element instanceof Color) {
                clr = !this.colorByChart || this.subgroupVariable != null || this.barModel.isMultiResponses() || this.colorIndexVariable != null ? (Color)e.element : this.barColor;
                g.setColor(clr);
                continue;
            }
            if (e.element instanceof Rectangle2D.Double) {
                Rectangle2D.Double rect2D = (Rectangle2D.Double)e.element;
                e.projectedRect = null;
                double xVal1 = rect2D.x;
                double xVal2 = rect2D.x + rect2D.width;
                double yVal1 = rect2D.y;
                double yVal2 = rect2D.y - rect2D.height;
                if (this.transObj.isReverse(0)) {
                    xVal1 = rect2D.x + rect2D.width;
                    xVal2 = rect2D.x;
                }
                if (this.transObj.isReverse(1)) {
                    yVal1 = rect2D.y - rect2D.height;
                    yVal2 = rect2D.y;
                }
                this.transObj.project(xVal1, yVal1, 0.0, this.scr1);
                this.transObj.project(xVal2, yVal2, 0.0, this.scr2);
                e.projectedRect = new Rectangle2D.Double(this.scr1[0], this.scr1[1], this.scr2[0] - this.scr1[0], this.scr2[1] - this.scr1[1]);
                if (this.chartType == 0 && e.projectedRect.getWidth() < 1.5) {
                    g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr1[0], (int)this.scr2[1]);
                } else if (this.chartType == 1 && e.projectedRect.getHeight() < 1.5) {
                    g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr1[1]);
                } else {
                    int num;
                    if (!this.gradientDisable && this.gradient) {
                        GradientPaint gp;
                        Color bclr = ColorUtilities.brighter(clr, 0.2);
                        Color clr1 = clr;
                        Color clr2 = bclr;
                        if (this.chartType == 0) {
                            if (rect2D.y != 0.0 && !this.transObj.isReverse(1) || rect2D.y == 0.0 && this.transObj.isReverse(1)) {
                                clr1 = bclr;
                                clr2 = clr;
                            }
                            gp = new GradientPaint((float)((this.scr2[0] - this.scr1[0]) / 2.0), (float)this.scr1[1], clr1, (float)((this.scr2[0] - this.scr1[0]) / 2.0), (float)this.scr2[1], clr2);
                        } else {
                            if (rect2D.x < 0.0 && !this.transObj.isReverse(0) || rect2D.x >= 0.0 && this.transObj.isReverse(0)) {
                                clr1 = bclr;
                                clr2 = clr;
                            }
                            gp = new GradientPaint((float)this.scr1[0], (float)((this.scr2[1] - this.scr1[1]) / 2.0), clr1, (float)this.scr2[0], (float)((this.scr2[1] - this.scr1[1]) / 2.0), clr2);
                        }
                        g.setPaint(gp);
                    }
                    g.fill(e.projectedRect);
                    if (!hideBarLabel && this.barLabel && this.subgroupVariable == null) {
                        format = this.dataOut.getFormat(this.yVariable, SASFormat.class);
                        label = this.dataOut.getFormattedValue(this.yVariable, (Object)new Double(rect2D.y), format);
                        label = label.trim();
                        textString = new TextLayout(label, this.barLabelFont, frc);
                        labelWidth = textString.getVisibleAdvance();
                        g.setColor(this.barLabelColor);
                        if (this.chartType == 0) {
                            textString.draw(g, (int)(this.scr1[0] + (this.scr2[0] - this.scr1[0]) / 2.0) - (int)(labelWidth / 2.0), (float)((int)this.scr1[1]) - textString.getDescent());
                        }
                    }
                    if (this.isWidth() && this.showInnerLabelsOn && !hideWidth[num = (int)(e.obsNo % (long)((AreaBarModel)this.barModel).getNumberCategories())]) {
                        double[] scrW = new double[3];
                        this.transObj.project(0.0, 0.0, 0.0, scrW);
                        hideWidth[num] = true;
                        if (this.widthAxis) {
                            Object xObj = this.dataOut.getValue(this.xVariable, e.obsNo);
                            format = this.dataOut.getFormat(this.xVariable, SASFormat.class);
                            label = this.getValueLabel(this.xVariable, xObj);
                        } else {
                            Object wObj = this.dataOut.getValue((Object)"BarWidth", e.obsNo);
                            format = this.dataOut.getFormat(this.barModel.getVariableInModel("Width"), SASFormat.class);
                            label = this.dataOut.getFormattedValue((Object)"BarWidth", wObj, format);
                        }
                        label = label.trim();
                        if (label.length() > 0) {
                            int labelFontSize = 0;
                            labelFontSize = (int)(0.5 * Math.sqrt(this.chartAreaDimension.height) * this.axisDefaults.fontSizeAdjust);
                            if (labelFontSize >= this.axisDefaults.adjustedValueSuppressionSize) {
                                labelFontSize = Math.max(this.axisDefaults.minAdjustedValueFontSize, Math.min(this.axisDefaults.maxAdjustedValueFontSize, labelFontSize));
                                Font font = FontManager.getFont((String)this.axisDefaults.valueFontName, (int)this.axisDefaults.valueFontType, (int)labelFontSize);
                                textString = new TextLayout(label, font, frc);
                                labelWidth = textString.getVisibleAdvance();
                                if (this.chartType == 0) {
                                    if (labelWidth < e.projectedRect.getWidth()) {
                                        int pos = this.transObj.isReverse(1) ? (rect2D.y == 0.0 ? (int)scrW[1] - 5 : (int)(scrW[1] + (double)textString.getAscent()) + 5) : (rect2D.y == 0.0 ? (int)(scrW[1] + (double)textString.getAscent()) + 5 : (int)scrW[1] - 5);
                                        catStr.put(new Integer(catIter), textString);
                                        catXPos.put(new Integer(catIter), new Integer((int)(this.scr1[0] + (this.scr2[0] - this.scr1[0]) / 2.0) - (int)(labelWidth / 2.0)));
                                        catYPos.put(new Integer(catIter), new Integer(pos));
                                        ++catIter;
                                    }
                                } else if ((double)(textString.getAscent() + textString.getDescent()) < e.projectedRect.getHeight()) {
                                    int pos = this.transObj.isReverse(0) ? (rect2D.x < 0.0 ? (int)scrW[0] + 5 : (int)(scrW[0] - (double)textString.getVisibleAdvance() - 4.0)) : (rect2D.x < 0.0 ? (int)(scrW[0] - (double)textString.getVisibleAdvance() - 4.0) : (int)scrW[0] + 5);
                                    catStr.put(new Integer(catIter), textString);
                                    catXPos.put(new Integer(catIter), new Integer(pos));
                                    catYPos.put(new Integer(catIter), new Integer((int)(this.scr1[1] + (this.scr2[1] - this.scr1[1]) / 2.0 + (double)(textString.getAscent() / 2.0f))));
                                    ++catIter;
                                }
                            }
                        }
                    }
                }
                if (!this.outlineOn || !(this.chartType == 0 && e.projectedRect.getWidth() >= 3.0) && (this.chartType != 1 || !(e.projectedRect.getHeight() >= 3.0))) continue;
                g.setColor(this.outlineColor);
                g.draw(e.projectedRect);
                continue;
            }
            if (!(e.element instanceof Line2D.Double)) continue;
            Line2D.Double line2D = (Line2D.Double)e.element;
            if (this.chartType == 0 ? line2D.x1 + 0.5 < Math.floor(this.xMin) || line2D.x1 - 0.5 > Math.ceil(this.xMax) : line2D.y1 + 0.5 < Math.floor(this.yMin) || line2D.y1 - 0.5 > Math.ceil(this.yMax)) continue;
            this.transObj.project(line2D.x1, line2D.y1, 0.0, this.scr1);
            this.transObj.project(line2D.x2, line2D.y2, 0.0, this.scr2);
            e.projectedLineH = new Line2D.Double(this.scr1[0], this.scr1[1], this.scr2[0], this.scr2[1]);
            g.setColor(this.outlineColor);
            g.draw(e.projectedLineH);
            if (this.chartType == 0) {
                e.projectedLineH.setLine(this.scr1[0] - 3.0, this.scr2[1], this.scr1[0] + 3.0, this.scr2[1]);
            } else {
                e.projectedLineH.setLine(this.scr2[0], this.scr2[1] - 3.0, this.scr2[0], this.scr2[1] + 3.0);
            }
            g.draw(e.projectedLineH);
        }
        if (this.isWidth() && this.showInnerLabelsOn) {
            int num = catStr.size();
            for (int i = 0; i < num; ++i) {
                TextLayout txtStr = (TextLayout)catStr.get(new Integer(i));
                int xPos = ((Number)catXPos.get(new Integer(i))).intValue();
                int yPos = ((Number)catYPos.get(new Integer(i))).intValue();
                g.setColor(this.outlineColor);
                txtStr.draw(g, xPos, yPos);
                g.setColor(this.chartWallColor);
                txtStr.draw(g, xPos + 1, yPos + 1);
            }
        }
        if (this.chartBorderOn) {
            g.setColor(this.chartBorderColor);
            this.transObj.project(this.xMin, this.yMin, 0.0, this.scr1);
            this.transObj.project(this.xMax, this.yMax, 0.0, this.scr2);
            g.drawRect((int)this.scr1[0], (int)this.scr2[1], (int)(this.scr2[0] - this.scr1[0]), (int)(this.scr1[1] - this.scr2[1]));
        }
        if (!Double.isNaN(this.baseValue)) {
            Object obj = null;
            if (this.chartType == 0) {
                this.transObj.project(this.xMin, this.baseValue, 0.0, this.scr1);
                this.transObj.project(this.xMax, this.baseValue, 0.0, this.scr2);
                obj = this.xAxis.getPropertyValue(201);
            } else {
                this.transObj.project(this.baseValue, this.yMin, 0.0, this.scr1);
                this.transObj.project(this.baseValue, this.yMax, 0.0, this.scr2);
                obj = this.yAxis.getPropertyValue(201);
            }
            Line2D.Double line = new Line2D.Double(this.scr1[0], this.scr1[1], this.scr2[0], this.scr2[1]);
            g.setColor(obj instanceof Color ? (Color)obj : Color.black);
            g.draw(line);
        }
        if (callHighlightDraw) {
            this.drawHighlight(p);
        }
        g.setComposite(comp);
        this.redraw = false;
    }

    @Override
    public String getToolTipText(int mouseX, int mouseY) {
        if (!this.visible || this.dataOut == null) {
            return null;
        }
        String desc = null;
        int index = this.getIndexOfDisplayList(mouseX, mouseY);
        if (index >= 0) {
            BarChart.BarElement e = (BarChart.BarElement)this.displayList.elementAt(index);
            desc = e.description;
            if (desc == null) {
                Object xObj = this.dataOut.getValue(this.xVariable, e.obsNo);
                Object yObj = this.dataOut.getValue(this.yVariable, e.obsNo);
                Object fObj = this.dataOut.getValue((Object)"Frequency", e.obsNo);
                if (this.statistic2 == 4 && fObj != null) {
                    yObj = new Double((Double)fObj * 100.0 / this.getValidFrequency());
                }
                if (this.statistic2 == 3 && fObj != null) {
                    yObj = new Double((Double)fObj);
                }
                if (yObj != null && fObj != null && this.statistic2 == 2) {
                    double f = (Double)fObj;
                    double y = (Double)yObj;
                    y = f != 0.0 ? y / f : 0.0;
                    yObj = new Double(y);
                }
                Object sObj = this.dataOut.getValue(this.subgroupVariable, e.obsNo);
                Object gObj = this.dataOut.getValue(this.groupVariable, e.obsNo);
                Object tObj = this.dataOut.getValue(this.tipVariable, e.obsNo);
                Object wObj = this.dataOut.getValue(this.barModel.getVariableInModel("Width"), e.obsNo);
                desc = this.getDescription(xObj, yObj, sObj, gObj, tObj, wObj);
            }
        }
        return desc;
    }

    protected String getDescription(Object x, Object y, Object s, Object g, Object t, Object w) {
        String ystr;
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Probe.fmt.txt", (String)"{0} : {1}"));
        String xstr = probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Category")), (Object)this.getValueLabel(this.xVariable, x));
        if (((String)this.barModel.getVariableDescription("Response")).trim().equals("Percent")) {
            SASFormat formatPercent = SASFormat.getInstance((String)"Percent8.2");
            double value = ((Number)y).doubleValue();
            String obj = this.dataOut.getFormattedValue(this.yVariable, (Object)new Double(value /= 100.0), (Object)formatPercent);
            ystr = "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Response")), (Object)obj);
        } else {
            ystr = "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Response")), (Object)this.getValueLabel(this.yVariable, y));
        }
        String sstr = s == null ? "" : "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Subgroup")), (Object)this.getValueLabel(this.subgroupVariable, s));
        String gstr = g == null ? "" : "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Group")), (Object)this.getValueLabel(this.groupVariable, g));
        String tstr = t == null ? "" : "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Tip")), (Object)this.getValueLabel(this.tipVariable, t));
        String wstr = w == null ? "" : "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Width")), (Object)this.getValueLabel(this.barModel.getVariableInModel("Width"), w));
        String str = xstr + ystr + sstr + gstr + tstr + wstr;
        str = str.replaceAll("=", "\t=\t");
        str = str.replaceAll("\\[", "\t \t\\[");
        return str;
    }

    public boolean isWidthRolePresent() {
        return this.barModel.getVariable(RoleInterface.ROLE_WIDTH) != null;
    }

    @Override
    protected boolean prepareChartData() {
        Object[] val;
        int i;
        if (this.dataPrepared) {
            return true;
        }
        if (this.barModel == null) {
            return false;
        }
        if (this.dataOut != null) {
            this.dataOut.removeDataFilterListener((Object)this);
        }
        this.dataOut = (DataFilterReadInterface)this.barModel.getDataSource();
        if (this.dataOut == null) {
            return false;
        }
        boolean negativeWidth = this.isWidthNegative();
        this.dataOut.addDataFilterListener((Object)this);
        if (!this.isWidthRolePresent()) {
            return false;
        }
        this.xVariable = this.barModel.getVariableInModel("Category");
        if (this.xVariable == null) {
            return false;
        }
        this.yVariable = this.barModel.getVariableInModel("Response");
        if (this.yVariable != null && !this.isDiscrete("Y") && this.statistic != 3) {
            this.statistic2 = this.statistic;
        } else {
            this.yVariable = "Frequency";
            this.statistic2 = 3;
        }
        if (this.statistic == 3 || this.statistic == 4) {
            this.yVariable = "Frequency";
            this.statistic2 = this.statistic == 4 ? 4 : 3;
        }
        this.barModel.setStatistic(this.statistic2);
        this.subgroupVariable = this.barModel.getVariableInModel("Subgroup");
        this.groupVariable = this.barModel.getVariableInModel("Group");
        this.errorHighVariable = null;
        this.errorLowVariable = null;
        if (this.subgroupVariable == null) {
            this.errorHighVariable = this.barModel.getVariableInModel("ErrorHigh");
            this.errorLowVariable = this.barModel.getVariableInModel("ErrorLow");
        }
        this.colorIndexVariable = this.barModel.getVariableInModel("ColorIndex");
        Object object = this.tipVariable = this.barModel.isMultiResponses() ? null : this.barModel.getVariableInModel("Tip");
        if (this.subgroupVariable != null) {
            this.baseValue = 0.0;
        } else {
            double max;
            double min;
            if (this.barModel.isMultiResponses() && this.statistic != 3) {
                min = this.barModel.getMinimumValue(null);
                max = this.barModel.getMaximumValue(null);
            } else {
                min = this.barModel.getMinimumValue(this.yVariable);
                max = this.barModel.getMaximumValue(this.yVariable);
            }
            if (min <= 0.0 && max > 0.0) {
                this.baseValue = 0.0;
            }
        }
        this.xAxis.setDataSource((DataFilterReadInterface)this.barModel.getDataSource());
        this.yAxis.setDataSource((DataFilterReadInterface)this.barModel.getDataSource());
        if (this.chartType == 0) {
            double max;
            double min;
            this.yAxis.setRole(this.yVariable, "YAxis");
            this.yAxis.setBaseValue(this.baseValue);
            if (this.statistic == 3) {
                SASFormat sf = SASFormat.getInstance((String)"NLNUM8.0");
                this.yAxis.setFormat(sf);
            } else {
                this.yAxis.setFormat((SASFormat)this.dataOut.getFormat(this.yVariable, SASFormat.class));
            }
            if (this.isWidth()) {
                if (this.widthAxis) {
                    this.xAxis.setRole(this.barModel.getVariableInModel("Width"), "XAxis");
                    this.xAxis.setAxis(new Double(0.0), new Double(((AreaBarModel)this.barModel).getTotalBarWidthScale()), -1, -1, null, null, null);
                    this.xAxis.setLabel(this.buildAxisLabel(true, "BarWidth"));
                } else {
                    this.xAxis.setRole(this.xVariable, "XAxis");
                    Object[] widthArray = null;
                    Object[] namesArray = null;
                    Vector<Object[]> mappedNames = new Vector<Object[]>();
                    widthArray = this.getBarWidths().toArray();
                    Vector names = this.barModel.getSortedCategoryNames();
                    namesArray = names.toArray();
                    for (i = 0; i < widthArray.length; ++i) {
                        if (Double.isNaN(((Number)widthArray[i]).doubleValue())) continue;
                        val = new Object[]{widthArray[i], namesArray[i] instanceof Number ? this.getValueLabel(this.xVariable, namesArray[i]) : namesArray[i]};
                        mappedNames.addElement(val);
                    }
                    this.xAxis.setAxis(new Double(0.0), new Double(names.size()), -1, -1, mappedNames.toArray(), null, Boolean.FALSE);
                    this.xAxis.setLabel(this.buildAxisLabel(true, "XAxis"));
                }
            } else {
                this.xAxis.setRole(this.xVariable, "XAxis");
                Vector names = this.barModel.getSortedCategoryNames();
                if (this.getVariable("Group") != null && this.groupAxis != null) {
                    this.xAxis.setNumberOfGroups(this.barModel.getNumberGroups());
                } else {
                    this.xAxis.setNumberOfGroups(0);
                }
                this.xAxis.setNumberOfResponses(this.barModel.isMultiResponses() ? this.barModel.getNumberResponses() : 0);
                this.xAxis.setTickInCenter(true, 0.0);
                this.yAxis.setTickInCenter(false, 0.0);
                this.xAxis.setAxis(new Double(0.0), new Double(names.size() - 1), -1, -1, names.toArray(), null, null);
                this.xAxis.setLabel(this.buildAxisLabel(true, "XAxis"));
            }
            if (this.barModel.isMultiResponses()) {
                min = Math.min(0.0, this.barModel.getMinimumValue(null, 0L, this.dataOut.getNumberObservations(-1)));
                max = Math.max(0.0, this.barModel.getMaximumValue(null, 0L, this.dataOut.getNumberObservations(-1)));
            } else {
                min = Math.min(0.0, this.barModel.getMinimumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
                if (negativeWidth) {
                    max = this.getMaxFrequency();
                    max = Math.max(0.0, this.barModel.getMaximumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
                } else {
                    max = Math.max(0.0, this.barModel.getMaximumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
                }
            }
            if (this.statistic == 4) {
                if (negativeWidth) {
                    min = min * 100.0 / this.getValidFrequency();
                    max = max * 100.0 / this.getValidFrequency();
                } else {
                    min = min * 100.0 / this.barModel.getTotalFreqVal();
                    max = max * 100.0 / this.barModel.getTotalFreqVal();
                }
            }
            if (this.errorHighVariable != null) {
                max += this.barModel.getMaximumValue(this.errorHighVariable);
            }
            if (this.errorLowVariable != null) {
                min -= this.barModel.getMaximumValue(this.errorLowVariable);
            }
            this.yAxis.setAxis(new Double(min), new Double(max), -1, -1, null, new Boolean(true), null);
            this.yAxis.setLabel(this.buildAxisLabel(false, "YAxis"));
        } else {
            double max;
            double min;
            this.xAxis.setRole(this.yVariable, "XAxis");
            this.xAxis.setBaseValue(this.baseValue);
            if (this.statistic == 3) {
                SASFormat sf = SASFormat.getInstance((String)"NLNUM8.0");
                this.xAxis.setFormat(sf);
            } else {
                this.xAxis.setFormat((SASFormat)this.dataOut.getFormat(this.yVariable, SASFormat.class));
            }
            Vector names = this.barModel.getSortedCategoryNames();
            if (this.getVariable("Group") != null && this.groupAxis != null) {
                this.yAxis.setNumberOfGroups(this.barModel.getNumberGroups());
            } else {
                this.yAxis.setNumberOfGroups(0);
            }
            if (this.isWidth()) {
                if (this.widthAxis) {
                    this.yAxis.setRole(this.barModel.getVariableInModel("Width"), "YAxis");
                    this.yAxis.setAxis(new Double(0.0), new Double(((AreaBarModel)this.barModel).getTotalBarWidthScale()), -1, -1, null, null, null);
                    this.yAxis.setLabel(this.buildAxisLabel(true, "BarWidth"));
                } else {
                    this.yAxis.setRole(this.xVariable, "YAxis");
                    Object[] widthArray = null;
                    Object[] namesArray = null;
                    Vector<Object[]> mappedNames = new Vector<Object[]>();
                    widthArray = this.getBarWidths().toArray();
                    names = this.barModel.getSortedCategoryNames();
                    namesArray = names.toArray();
                    for (i = 0; i < widthArray.length; ++i) {
                        if (Double.isNaN(((Number)widthArray[i]).doubleValue())) continue;
                        val = new Object[]{widthArray[i], namesArray[i] instanceof Number ? this.getValueLabel(this.xVariable, namesArray[i]) : namesArray[i]};
                        mappedNames.addElement(val);
                    }
                    this.yAxis.setAxis(new Double(0.0), new Double(names.size()), -1, -1, mappedNames.toArray(), null, Boolean.FALSE);
                    this.yAxis.setLabel(this.buildAxisLabel(true, "XAxis"));
                }
            } else {
                this.yAxis.setRole(this.xVariable, "YAxis");
                this.yAxis.setNumberOfResponses(this.barModel.isMultiResponses() ? this.barModel.getNumberResponses() : 0);
                this.yAxis.setTickInCenter(true, 0.0);
                this.xAxis.setTickInCenter(false, 0.0);
                this.yAxis.setAxis(new Double(0.0), new Double(names.size() - 1), -1, -1, names.toArray(), null, null);
                this.yAxis.setLabel(this.buildAxisLabel(true, "XAxis"));
            }
            if (this.barModel.isMultiResponses()) {
                min = Math.min(0.0, this.barModel.getMinimumValue(null, 0L, this.dataOut.getNumberObservations(-1)));
                max = Math.max(0.0, this.barModel.getMaximumValue(null, 0L, this.dataOut.getNumberObservations(-1)));
            } else {
                min = Math.min(0.0, this.barModel.getMinimumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
                if (negativeWidth) {
                    max = this.getMaxFrequency();
                    max = Math.max(0.0, this.barModel.getMaximumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
                } else {
                    max = Math.max(0.0, this.barModel.getMaximumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
                }
            }
            if (this.statistic == 4) {
                if (negativeWidth) {
                    min = min * 100.0 / this.getValidFrequency();
                    max = max * 100.0 / this.getValidFrequency();
                } else {
                    min = min * 100.0 / this.barModel.getTotalFreqVal();
                    max = max * 100.0 / this.barModel.getTotalFreqVal();
                }
            }
            if (this.errorHighVariable != null) {
                max += this.barModel.getMaximumValue(this.errorHighVariable);
            }
            if (this.errorLowVariable != null) {
                min -= this.barModel.getMaximumValue(this.errorLowVariable);
            }
            this.xAxis.setAxis(new Double(min), new Double(max), -1, -1, null, new Boolean(true), null);
            this.xAxis.setLabel(this.buildAxisLabel(false, "YAxis"));
        }
        this.xAxis.setDefaultLabelPosition(true);
        this.setMargins();
        if (this.getVariable("Group") != null && this.groupAxis != null) {
            this.groupAxis.setDataSource((DataFilterReadInterface)this.barModel.getDataSource());
            this.groupAxis.setRole(this.groupVariable, "GroupAxis");
            this.groupAxis.setDirection(this.chartType == 0);
            this.groupAxis.setDefaultLabelPosition(false);
            Vector names = this.barModel.getGroupNames();
            this.groupAxis.setGroupAxis(true);
            this.groupAxis.setNumberOfCategories(this.barModel.getNumberCategories());
            this.groupAxis.setGridLines(new Boolean(false));
            this.groupAxis.setAxis(new Double(0.0), new Double(names.size() - 1), -1, -1, names.toArray(), null, null);
            this.groupAxis.setLabel(this.buildAxisLabel(true, "GroupAxis"));
            this.groupAxis.getLine().setVisible(false);
            this.groupAxis.getMajorTicks().setVisible(false);
            if (this.chartType == 0) {
                this.groupAxis.setCollisionResolution(2);
            } else {
                this.groupAxis.setCollisionResolution(5);
            }
            if (this.chartType == 0) {
                this.xAxis.setDefaultLabelPosition(false);
            }
        }
        if (this.subgroupVariable != null || this.barModel.isMultiResponses() || !this.colorByChart || this.colorIndexVariable != null) {
            Object varId = null;
            String variable = null;
            Vector items = null;
            String title = null;
            if (this.subgroupVariable != null) {
                varId = this.subgroupVariable;
                items = this.barModel.getSubgroupNames();
                title = (String)this.barModel.getVariableDescription("Subgroup");
                variable = (String)this.getVariable("Subgroup");
                ((LegendObjectJ2D)this.legend).setData(this.dataIn, variable);
            } else if (this.barModel.isMultiResponses()) {
                varId = null;
                items = this.barModel.getResponseDescriptions();
                title = null;
                variable = null;
                ((LegendObjectJ2D)this.legend).setData(this.dataIn, variable);
            } else {
                varId = this.xVariable;
                items = this.barModel.getSortedCategoryNames();
                title = (String)this.barModel.getVariableDescription("Category");
                variable = (String)this.getVariable("Category");
                ((LegendObjectJ2D)this.legend).setData(this.dataIn, variable);
            }
            Color[] colors = null;
            Object clrVector = null;
            if (this.colorIndexVariable != null) {
                colors = new Color[items.size()];
                this.legendValues = new String[items.size()];
                HashMap map = this.barModel.getColorIndexNamesByVariable(varId, this.colorIndexVariable);
                for (int i2 = 0; i2 < items.size(); ++i2) {
                    this.legendValues[i2] = (String)items.get(i2);
                    Integer colorValue = (Integer)map.get(this.legendValues[i2]);
                    colors[i2] = this.dataColors[colorValue % this.dataColors.length];
                }
            } else {
                int size = items.size();
                this.legendValues = new Object[size];
                colors = new Color[size];
                boolean itemsAreNumber = false;
                if (size > 0) {
                    boolean bl = itemsAreNumber = items.elementAt(0) instanceof Number;
                }
                if (this.barModel.isMultiResponses()) {
                    for (int i3 = 0; i3 < size; ++i3) {
                        this.legendValues[i3] = itemsAreNumber ? new Double(((Number)items.elementAt(i3)).doubleValue()) : items.elementAt(i3);
                        String attrValueStr = this.legendValues[i3].toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i3, 2, this.style, this.styleElement, null).getAsDataStyle();
                        colors[i3] = dse.getFillColor();
                    }
                } else {
                    Object o = this.barModel.getLimit(new Integer(55));
                    int maxObs = o != null && o instanceof Number ? ((Number)o).intValue() : 0;
                    Object[] uniqueValuesArray = ((DataFilterInfoInterface)this.dataIn).getUniqueValues((Object)variable, false, maxObs);
                    LinkedHashMap<Object, Integer> uniqueValueList = null;
                    if (uniqueValuesArray != null) {
                        uniqueValueList = new LinkedHashMap<Object, Integer>();
                        for (int j = 0; j < uniqueValuesArray.length; ++j) {
                            uniqueValueList.put(uniqueValuesArray[j], new Integer(j));
                        }
                    } else {
                        uniqueValueList = null;
                    }
                    for (int i4 = 0; i4 < size; ++i4) {
                        this.legendValues[i4] = itemsAreNumber ? new Double(((Number)items.elementAt(i4)).doubleValue()) : items.elementAt(i4);
                        int index = -1;
                        if (uniqueValueList != null) {
                            Object val2 = uniqueValueList.get(items.elementAt(i4));
                            index = val2 != null && val2 instanceof Number ? ((Number)val2).intValue() : -1;
                            String attrValueStr = this.legendValues[i4].toString();
                            if (index > -1) {
                                DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                                colors[i4] = dse.getFillColor();
                                continue;
                            }
                            colors[i4] = this.style.getFillStyleElement("Missing").getFillColor();
                            continue;
                        }
                        colors[i4] = this.style.getFillStyleElement("Missing").getFillColor();
                    }
                }
            }
            boolean isLegVis = this.legend.isVisible();
            this.legend.setLabel((SASFormat)this.dataOut.getFormat(varId, SASFormat.class));
            this.legend.setValues(colors, null, this.legendValues, null, false);
            this.legend.setTitle(title);
            this.legend.setVisible(true);
            if (this.subgroupVariable == null && !this.barModel.isMultiResponses() && !this.colorByChart && this.colorIndexVariable == null) {
                this.legend.setVisible(false);
            }
            if (this.colorBy != null && isLegVis) {
                this.legend.setVisible(true);
            }
        } else {
            this.legend.setValues(null, null, null, (boolean[])null, false);
            this.legend.setVisible(false);
        }
        this.dataPrepared = true;
        return true;
    }

    @Override
    public void setDataColors(Color[] c) {
        if (c == null) {
            return;
        }
        this.dataColors = c;
        this.rebuildRequired = true;
        if (!this.userSetSignColors) {
            this.colorNegative = this.dataColors[1];
            this.colorPositive = this.dataColors[0];
        }
        if (this.legend != null) {
            int size = this.legendValues == null ? 0 : this.legendValues.length;
            Color[] colors = new Color[size];
            Object clrVector = null;
            if (this.colorIndexVariable != null && size > 0) {
                HashMap colorMapByVar = null;
                colorMapByVar = this.subgroupVariable != null ? this.barModel.getColorIndexNamesByVariable(this.subgroupVariable, this.colorIndexVariable) : this.barModel.getColorIndexNamesByVariable(this.xVariable, this.colorIndexVariable);
                for (int i = 0; i < size; ++i) {
                    Integer colorVal = (Integer)colorMapByVar.get(this.legendValues[i]);
                    colors[i] = this.dataColors[colorVal % this.dataColors.length];
                }
            } else if (this.barModel.isMultiResponses()) {
                Vector items = null;
                items = this.barModel.getResponseDescriptions();
                if (size > 0 && items.elementAt(0) instanceof Number) {
                    for (int i = 0; i < size; ++i) {
                        this.legendValues[i] = new Double(((Number)items.elementAt(i)).doubleValue());
                        String attrValueStr = this.legendValues[i].toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i, 2, this.style, this.styleElement, null).getAsDataStyle();
                        colors[i] = dse.getFillColor();
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        this.legendValues[i] = items.elementAt(i);
                        String attrValueStr = this.legendValues[i].toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i, 1, this.style, this.styleElement, null).getAsDataStyle();
                        colors[i] = dse.getFillColor();
                    }
                }
            } else if (this.colorBy != null && this.colorBy.equals(this.responseSign)) {
                colors[0] = this.colorNegative;
                colors[1] = this.colorPositive;
            } else {
                String variable = null;
                Vector items = null;
                if (this.subgroupVariable != null) {
                    items = this.barModel.getSubgroupNames();
                    variable = (String)this.getVariable("Subgroup");
                } else if (!this.colorByChart) {
                    items = this.barModel.getSortedCategoryNames();
                    variable = (String)this.getVariable("Category");
                }
                Object o = this.barModel.getLimit(new Integer(55));
                int maxObs = o != null && o instanceof Number ? ((Number)o).intValue() : 0;
                Object[] uniqueValuesArray = ((DataFilterInfoInterface)this.dataIn).getUniqueValues((Object)variable, false, maxObs);
                LinkedHashMap<Object, Integer> uniqueValueList = null;
                if (uniqueValuesArray != null) {
                    uniqueValueList = new LinkedHashMap<Object, Integer>();
                    for (int j = 0; j < uniqueValuesArray.length; ++j) {
                        uniqueValueList.put(uniqueValuesArray[j], new Integer(j));
                    }
                } else {
                    uniqueValueList = null;
                }
                for (int i = 0; i < size && items != null; ++i) {
                    int index = -1;
                    if (uniqueValueList != null) {
                        Object val = uniqueValueList.get(items.elementAt(i));
                        index = val != null && val instanceof Number ? ((Number)val).intValue() : -1;
                        String attrValueStr = this.legendValues[i].toString();
                        if (index > -1) {
                            DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                            colors[i] = dse.getFillColor();
                            continue;
                        }
                        colors[i] = this.style.getFillStyleElement("Missing").getFillColor();
                        continue;
                    }
                    colors[i] = this.style.getFillStyleElement("Missing").getFillColor();
                }
            }
            this.legend.setValues(colors, null, this.legendValues, null, false);
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    private double getMaxFrequency() {
        long obs = this.dataOut.getNumberObservations(-1);
        int wIdx = this.dataOut.getVariableIndex(this.barModel.getVariableInModel("Width"));
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        double maxFreq = 0.0;
        double freq = 0.0;
        if (obs != 0L) {
            int i = 0;
            while ((long)i < obs) {
                Object wObj = this.dataOut.getValue(wIdx, (long)i);
                Object fObj = this.dataOut.getValue(fIdx, (long)i);
                if (wObj != null && !((Double)wObj < 0.0) && (freq = ((Double)fObj).doubleValue()) > maxFreq) {
                    maxFreq = freq;
                }
                ++i;
            }
            return maxFreq;
        }
        return 0.0;
    }

    private boolean isWidthNegative() {
        long obs = this.dataOut.getNumberObservations(-1);
        int wIdx = this.dataOut.getVariableIndex(this.barModel.getVariableInModel("Width"));
        if (obs != 0L) {
            boolean negativeWidth = false;
            int i = 0;
            while ((long)i < obs) {
                Object wObj1 = this.dataOut.getValue(wIdx, (long)i);
                if (wObj1 != null && (Double)wObj1 < 0.0) {
                    negativeWidth = true;
                    break;
                }
                ++i;
            }
            return negativeWidth;
        }
        return false;
    }

    @Override
    protected boolean buildVerticalBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int xIdx = this.dataOut.getVariableIndex(this.xVariable);
        int yIdx = this.dataOut.getVariableIndex(this.yVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        int eHIdx = this.dataOut.getVariableIndex(this.errorHighVariable);
        int eLIdx = this.dataOut.getVariableIndex(this.errorLowVariable);
        int wIdx = this.dataOut.getVariableIndex(this.barModel.getVariableInModel("Width"));
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        int wdIdx = this.dataOut.getVariableIndex((Object)"BarWidth");
        double x = 0.0;
        double y = 0.0;
        double f = 0.0;
        double s = 0.0;
        double eH = 0.0;
        double eL = 0.0;
        BarChart.BarElement e = null;
        for (long i = 0L; i < obs; ++i) {
            Line2D.Double line2D;
            double ht;
            double yo;
            double widthFac;
            Object wdObj;
            double xo;
            Color color;
            DataStyleElement dse;
            Object xObj = this.dataOut.getValue(xIdx, i);
            Object yObj = this.dataOut.getValue(yIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            Object eHObj = this.dataOut.getValue(eHIdx, i);
            Object eLObj = this.dataOut.getValue(eLIdx, i);
            Object wObj = this.dataOut.getValue(wIdx, i);
            Object cObj = this.dataOut.getValue(cIdx, i);
            if (this.dataOut.isMissing(yIdx, yObj)) continue;
            x = this.barModel.getSortedIndex((int)i);
            y = (Double)yObj;
            f = (Double)fObj;
            s = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = y = f != 0.0 ? y / f : 0.0;
            }
            if (this.statistic2 == 4) {
                y = f * 100.0 / this.getValidFrequency();
            }
            if (y == 0.0) continue;
            if (cObj != null) {
                int clrIndex = (Integer)cObj;
                String cValueStr = cObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, clrIndex, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            } else {
                int index = this.barModel.getUniqueValueListIndex(xObj);
                String xValueStr = xObj.toString();
                dse = SILKUtilities.getStyleElement(xValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            }
            e = new BarChart.BarElement(this, color);
            this.displayList.addElement(e);
            double fullBarWidth = 1.0;
            if (wObj != null) {
                if (this.widthAxis) {
                    xo = this.getBarStartPosition(obs, (int)x);
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue();
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    xo += fullBarWidth * ((1.0 - this.scaleFactor) / 2.0);
                } else {
                    widthFac = (double)obs / ((AreaBarModel)this.barModel).getTotalBarWidthScale();
                    xo = this.getBarStartPosition(obs, (int)x) * widthFac;
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue() * widthFac;
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    xo += fullBarWidth * ((1.0 - this.scaleFactor) / 2.0);
                }
            } else {
                xo = x + fullBarWidth * ((1.0 - this.scaleFactor) / 2.0);
            }
            double wt = fullBarWidth * this.scaleFactor;
            if (!Double.isNaN(this.baseValue)) {
                yo = Math.max(y, this.baseValue);
                ht = Math.abs(y - this.baseValue);
            } else {
                yo = y >= 0.0 ? y : this.yMax;
                ht = y >= 0.0 ? y - this.yMin : this.yMax - y;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarChart.BarElement(this, rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            Point pt = new Point((int)xo, (int)(yo + ht));
            e = new BarChart.BarElement(this, pt, "foo");
            this.displayList.addElement(e);
            if (eHObj != null && (eH = ((Double)eHObj).doubleValue()) > 0.0) {
                fullBarWidth = 1.0;
                if (wObj != null) {
                    xo = this.getBarStartPosition(obs, (int)x);
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue();
                    if (!this.widthAxis) {
                        widthFac = (double)obs / ((AreaBarModel)this.barModel).getTotalBarWidthScale();
                        xo *= widthFac;
                        fullBarWidth *= widthFac;
                    }
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    xo += fullBarWidth / 2.0;
                } else {
                    xo = x + fullBarWidth / 2.0;
                }
                yo = y;
                line2D = new Line2D.Double(xo, yo, xo, yo + eH);
                e = new BarChart.BarElement(this, line2D);
                this.displayList.addElement(e);
            }
            if (eLObj != null && (eL = ((Double)eLObj).doubleValue()) > 0.0) {
                fullBarWidth = 1.0;
                if (wObj != null) {
                    xo = this.getBarStartPosition(obs, (int)x);
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue();
                    if (!this.widthAxis) {
                        widthFac = (double)obs / ((AreaBarModel)this.barModel).getTotalBarWidthScale();
                        xo *= widthFac;
                        fullBarWidth *= widthFac;
                    }
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    xo += fullBarWidth / 2.0;
                } else {
                    xo = x + fullBarWidth / 2.0;
                }
                yo = y;
                line2D = new Line2D.Double(xo, yo, xo, yo - eL);
                e = new BarChart.BarElement(this, line2D);
                this.displayList.addElement(e);
            }
            if (s == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 2), new Double(s / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    private double getValidFrequency() {
        long obs = this.dataOut.getNumberObservations(-1);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        int wIdx = this.dataOut.getVariableIndex(this.barModel.getVariableInModel("Width"));
        if (obs != 0L) {
            double freq = 0.0;
            int i = 0;
            while ((long)i < obs) {
                Object fObj1 = this.dataOut.getValue(fIdx, (long)i);
                Object wObj1 = this.dataOut.getValue(wIdx, (long)i);
                if (wObj1 != null && (Double)wObj1 > 0.0) {
                    freq += ((Double)fObj1).doubleValue();
                }
                ++i;
            }
            return freq;
        }
        return 0.0;
    }

    @Override
    protected boolean buildVerticalSegmentedBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int yIdx = this.dataOut.getVariableIndex(this.yVariable);
        int gIdx = this.dataOut.getVariableIndex(this.subgroupVariable);
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        double y = 0.0;
        double f = 0.0;
        double s = 0.0;
        int x = 0;
        BarChart.BarElement e = null;
        int nCat = this.barModel.getNumberCategories();
        double[] lastNY = new double[nCat];
        double[] lastPY = new double[nCat];
        int[] countNY = new int[nCat];
        int[] countPY = new int[nCat];
        int wIdx = this.dataOut.getVariableIndex(this.barModel.getVariableInModel("Width"));
        int wdIdx = this.dataOut.getVariableIndex((Object)"BarWidth");
        for (int i = 0; i < nCat; ++i) {
            lastPY[i] = Double.isNaN(this.baseValue) ? this.yMin : this.baseValue;
            lastNY[i] = lastPY[i];
        }
        for (long i = 0L; i < obs; ++i) {
            double ht;
            double yo;
            double xo;
            Color color;
            DataStyleElement dse;
            String cValueStr;
            Object yObj = this.dataOut.getValue(yIdx, i);
            Object gObj = this.dataOut.getValue(gIdx, i);
            Object cObj = this.dataOut.getValue(cIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            Object wObj = this.dataOut.getValue(wIdx, i);
            if (this.dataOut.isMissing(yIdx, yObj)) continue;
            x = (int)(i % (long)nCat);
            x = this.barModel.getSortedIndex(x);
            y = (Double)yObj;
            f = (Double)fObj;
            s = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = y = f != 0.0 ? y / f : 0.0;
            }
            if (this.statistic2 == 4) {
                y = f * 100.0 / this.getValidFrequency();
            }
            if (y == 0.0) continue;
            if (cObj != null) {
                int clrIndex = (Integer)cObj;
                cValueStr = cObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, clrIndex, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            } else {
                int index = this.barModel.getUniqueValueListIndex(gObj);
                cValueStr = gObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            }
            e = new BarChart.BarElement(this, color);
            this.displayList.addElement(e);
            double fullBarWidth = 1.0;
            if (wObj != null) {
                Object wdObj;
                if (this.widthAxis) {
                    xo = this.getBarStartPosition(obs, x);
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue();
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    xo += fullBarWidth * ((1.0 - this.scaleFactor) / 2.0);
                } else {
                    double widthFac = (double)nCat / ((AreaBarModel)this.barModel).getTotalBarWidthScale();
                    xo = this.getBarStartPosition(obs, x) * widthFac;
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue() * widthFac;
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    xo += fullBarWidth * ((1.0 - this.scaleFactor) / 2.0);
                }
            } else {
                xo = (double)x + fullBarWidth * ((1.0 - this.scaleFactor) / 2.0);
            }
            double wt = fullBarWidth * this.scaleFactor;
            if (y > 0.0) {
                int n = x;
                countPY[n] = countPY[n] + 1;
                if (countPY[x] > 1) {
                    this.gradientDisable = true;
                }
                lastPY[x] = yo = y + lastPY[x];
                ht = y;
            } else {
                int n = x;
                countNY[n] = countNY[n] + 1;
                if (countNY[x] > 1) {
                    this.gradientDisable = true;
                }
                yo = lastNY[x];
                lastNY[x] = yo + y;
                ht = -y;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarChart.BarElement(this, rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (s == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    @Override
    protected boolean buildHorizontalBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int yIdx = this.dataOut.getVariableIndex(this.xVariable);
        int xIdx = this.dataOut.getVariableIndex(this.yVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        int eHIdx = this.dataOut.getVariableIndex(this.errorHighVariable);
        int eLIdx = this.dataOut.getVariableIndex(this.errorLowVariable);
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        int wIdx = this.dataOut.getVariableIndex(this.barModel.getVariableInModel("Width"));
        int wdIdx = this.dataOut.getVariableIndex((Object)"BarWidth");
        double x = 0.0;
        double y = 0.0;
        double f = 0.0;
        double s = 0.0;
        double eH = 0.0;
        double eL = 0.0;
        BarChart.BarElement e = null;
        for (long i = 0L; i < obs; ++i) {
            Line2D.Double line2D;
            double wt;
            double xo;
            double widthFac;
            Object wdObj;
            double yo;
            Color color;
            DataStyleElement dse;
            Object xObj = this.dataOut.getValue(xIdx, i);
            Object yObj = this.dataOut.getValue(yIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            Object eHObj = this.dataOut.getValue(eHIdx, i);
            Object eLObj = this.dataOut.getValue(eLIdx, i);
            Object wObj = this.dataOut.getValue(wIdx, i);
            Object cObj = this.dataOut.getValue(cIdx, i);
            if (this.dataOut.isMissing(xIdx, xObj)) continue;
            x = (Double)xObj;
            y = this.barModel.getSortedIndex((int)i);
            f = (Double)fObj;
            s = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = x = f != 0.0 ? x / f : 0.0;
            }
            if (this.statistic2 == 4) {
                x = f * 100.0 / this.getValidFrequency();
            }
            if (x == 0.0) continue;
            if (cObj != null) {
                int clrIndex = (Integer)cObj;
                String cValueStr = cObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, clrIndex, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            } else {
                int index = this.barModel.getUniqueValueListIndex(yObj);
                String xValueStr = xObj.toString();
                dse = SILKUtilities.getStyleElement(xValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            }
            e = new BarChart.BarElement(this, color);
            this.displayList.addElement(e);
            double fullBarWidth = 1.0;
            if (wObj != null) {
                if (this.widthAxis) {
                    yo = this.getBarStartPosition(obs, (int)y);
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue();
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    yo += fullBarWidth * ((1.0 + this.scaleFactor) / 2.0);
                } else {
                    widthFac = (double)obs / ((AreaBarModel)this.barModel).getTotalBarWidthScale();
                    yo = this.getBarStartPosition(obs, (int)y) * widthFac;
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue() * widthFac;
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    yo += fullBarWidth * ((1.0 + this.scaleFactor) / 2.0);
                }
            } else {
                yo = y + fullBarWidth * ((1.0 + this.scaleFactor) / 2.0);
            }
            double ht = fullBarWidth * this.scaleFactor;
            if (!Double.isNaN(this.baseValue)) {
                xo = Math.min(x, this.baseValue);
                wt = Math.abs(x - this.baseValue);
            } else {
                xo = x >= 0.0 ? this.xMin : x;
                wt = x >= 0.0 ? x - this.xMin : this.xMax - x;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarChart.BarElement(this, rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (eHObj != null && (eH = ((Double)eHObj).doubleValue()) > 0.0) {
                if (wObj != null) {
                    yo = this.getBarStartPosition(obs, (int)y);
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue();
                    if (!this.widthAxis) {
                        widthFac = (double)obs / ((AreaBarModel)this.barModel).getTotalBarWidthScale();
                        yo *= widthFac;
                        fullBarWidth *= widthFac;
                    }
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    yo += fullBarWidth / 2.0;
                } else {
                    yo = y + fullBarWidth / 2.0;
                }
                xo = x;
                line2D = new Line2D.Double(xo, yo, xo + eH, yo);
                e = new BarChart.BarElement(this, line2D);
                this.displayList.addElement(e);
            }
            if (eLObj != null && (eL = ((Double)eLObj).doubleValue()) > 0.0) {
                if (wObj != null) {
                    yo = this.getBarStartPosition(obs, (int)y);
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue();
                    if (!this.widthAxis) {
                        widthFac = (double)obs / ((AreaBarModel)this.barModel).getTotalBarWidthScale();
                        yo *= widthFac;
                        fullBarWidth *= widthFac;
                    }
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    yo += fullBarWidth / 2.0;
                } else {
                    yo = y + fullBarWidth / 2.0;
                }
                xo = x;
                line2D = new Line2D.Double(xo, yo, xo - eL, yo);
                e = new BarChart.BarElement(this, line2D);
                this.displayList.addElement(e);
            }
            if (s == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    @Override
    protected boolean buildHorizontalSegmentedBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int xIdx = this.dataOut.getVariableIndex(this.yVariable);
        int gIdx = this.dataOut.getVariableIndex(this.subgroupVariable);
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        double x = 0.0;
        double f = 0.0;
        double s = 0.0;
        int y = 0;
        BarChart.BarElement e = null;
        int nCat = this.barModel.getNumberCategories();
        double[] lastNX = new double[nCat];
        double[] lastPX = new double[nCat];
        int[] countNX = new int[nCat];
        int[] countPX = new int[nCat];
        int wIdx = this.dataOut.getVariableIndex(this.barModel.getVariableInModel("Width"));
        int wdIdx = this.dataOut.getVariableIndex((Object)"BarWidth");
        for (int i = 0; i < nCat; ++i) {
            lastPX[i] = Double.isNaN(this.baseValue) ? this.xMin : this.baseValue;
            lastNX[i] = lastPX[i];
        }
        for (long i = 0L; i < obs; ++i) {
            double wt;
            double xo;
            double yo;
            Color color;
            DataStyleElement dse;
            String cValueStr;
            Object xObj = this.dataOut.getValue(xIdx, i);
            Object gObj = this.dataOut.getValue(gIdx, i);
            Object cObj = this.dataOut.getValue(cIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            Object wObj = this.dataOut.getValue(wIdx, i);
            if (this.dataOut.isMissing(xIdx, xObj)) continue;
            y = (int)(i % (long)nCat);
            y = this.barModel.getSortedIndex(y);
            x = (Double)xObj;
            f = (Double)fObj;
            s = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = x = f != 0.0 ? x / f : 0.0;
            }
            if (this.statistic2 == 4) {
                x = f * 100.0 / this.getValidFrequency();
            }
            if (x == 0.0) continue;
            if (cObj != null) {
                int clrIndex = (Integer)cObj;
                cValueStr = cObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, clrIndex, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            } else {
                int index = this.barModel.getUniqueValueListIndex(gObj);
                cValueStr = gObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            }
            e = new BarChart.BarElement(this, color);
            this.displayList.addElement(e);
            double fullBarWidth = 1.0;
            if (wObj != null) {
                Object wdObj;
                if (this.widthAxis) {
                    yo = this.getBarStartPosition(obs, y);
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue();
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    yo += fullBarWidth * ((1.0 + this.scaleFactor) / 2.0);
                } else {
                    double widthFac = (double)nCat / ((AreaBarModel)this.barModel).getTotalBarWidthScale();
                    yo = this.getBarStartPosition(obs, y) * widthFac;
                    wdObj = this.dataOut.getValue(wdIdx, i);
                    fullBarWidth = ((Number)wdObj).doubleValue() * widthFac;
                    if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) continue;
                    yo += fullBarWidth * ((1.0 + this.scaleFactor) / 2.0);
                }
            } else {
                yo = (double)y + fullBarWidth * ((1.0 + this.scaleFactor) / 2.0);
            }
            double ht = fullBarWidth * this.scaleFactor;
            if (x > 0.0) {
                int n = y;
                countPX[n] = countPX[n] + 1;
                if (countPX[y] > 1) {
                    this.gradientDisable = true;
                }
                xo = lastPX[y];
                lastPX[y] = xo + x;
                wt = x;
            } else {
                int n = y;
                countNX[n] = countNX[n] + 1;
                if (countNX[y] > 1) {
                    this.gradientDisable = true;
                }
                lastNX[y] = xo = lastNX[y] + x;
                wt = -x;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarChart.BarElement(this, rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (s == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    @Override
    protected String buildAxisLabel(boolean xAxis, String str) {
        if (str.equalsIgnoreCase("BarWidth")) {
            return (String)this.barModel.getVariableDescription("Width");
        }
        return super.buildAxisLabel(xAxis, str);
    }

    protected double getBarStartPosition(long size, int index) {
        double prev = 0.0;
        int wdIdx = this.dataOut.getVariableIndex((Object)"BarWidth");
        int i = 0;
        while ((long)i < size) {
            double fullBarWidth;
            Object wdObj;
            int tmpIndex = this.barModel.getSortedIndex(i);
            if (index > tmpIndex && (wdObj = this.dataOut.getValue(wdIdx, (long)i)) != null && !Double.isNaN(fullBarWidth = ((Double)wdObj).doubleValue())) {
                prev += fullBarWidth;
            }
            ++i;
        }
        return prev;
    }

    public boolean isWidth() {
        if (this.dataOut == null) {
            return false;
        }
        int wdIdx = this.dataOut.getVariableIndex((Object)"BarWidth");
        return wdIdx > -1 && this.getVariable("Group") == null && !this.barModel.isMultiResponses();
    }

    @Override
    public void setNumberDisplayBars(int n) {
    }

    @Override
    public void setDisplayBarRange(int start, int end) {
    }

    private Vector getBarWidths() {
        int wdIdx = this.dataOut.getVariableIndex((Object)"BarWidth");
        int nCat = this.barModel.getNumberCategories();
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < nCat; ++i) {
            double widthFac = (double)nCat / ((AreaBarModel)this.barModel).getTotalBarWidthScale();
            double xo = this.getBarStartPosition(nCat, i) * widthFac;
            Object wdObj = this.dataOut.getValue(wdIdx, (long)i);
            double fullBarWidth = wdObj == null ? Double.NaN : ((Number)wdObj).doubleValue() * widthFac;
            if (Double.isNaN(fullBarWidth) || fullBarWidth == 0.0) {
                v.add(new Double(Double.NaN));
                continue;
            }
            v.add(new Double(xo += fullBarWidth / 2.0));
        }
        return v;
    }

    public void setAxisRole(Number role) {
        boolean flag = role == RoleInterface.ROLE_WIDTH;
        if (flag != this.widthAxis) {
            this.widthAxis = flag;
            this.rebuildRequired = true;
            this.dataChanged = true;
            this.dataPrepared = false;
        }
    }

    public Number getAxisRole() {
        if (this.widthAxis) {
            return RoleInterface.ROLE_WIDTH;
        }
        return RoleInterface.ROLE_CATEGORY;
    }

    @Override
    protected void setMargins() {
        super.setMargins();
        if (this.isWidth() && this.widthAxis) {
            if (this.chartType == 0) {
                int right = (int)((double)this.xAxis.getValueWidth(this.graphics2D, -1) * 0.5);
                this.outerMargin.right += right;
            } else {
                int top = (int)((double)this.yAxis.getValueHeight(this.graphics2D, -1) * 0.25);
                this.outerMargin.top += top;
            }
        }
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (this.barModel == null || role == null) {
            return false;
        }
        return this.setRole(variableId, role);
    }

    @Override
    public String getStatistic() {
        this.dataPrepared = false;
        return super.getStatistic();
    }

    @Override
    public SILKNumber getStatisticObject() {
        this.dataPrepared = false;
        return super.getStatisticObject();
    }

    public void displayBarInnerLabels(boolean flag) {
        this.setInnerLabelOn(flag);
    }

    public boolean isInnerLabelsOn() {
        return this.showInnerLabelsOn;
    }

    public void setInnerLabelOn(boolean onOff) {
        if (this.showInnerLabelsOn == onOff) {
            return;
        }
        this.showInnerLabelsOn = onOff;
        this.userSetProperties.set(819);
        this.fireRedrawEvent(new RedrawEvent(this));
    }
}

