/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.band;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;

public class Band {
    public static void draw(Graphics2D g, int[] xPoints, int[] yPoints, int nPoints, int turn, double bandOpacity, Color color) {
        int i;
        if (xPoints == null || yPoints == null) {
            return;
        }
        Composite save = g.getComposite();
        if (color != null) {
            g.setColor(color);
        }
        g.setComposite(AlphaComposite.getInstance(3, (float)bandOpacity));
        if (turn > 0) {
            int n = turn - 1;
            xPoints[n] = xPoints[n] + 1;
            int n2 = turn;
            xPoints[n2] = xPoints[n2] + 1;
        }
        g.fillPolygon(xPoints, yPoints, nPoints);
        if (turn > 0) {
            int n = turn - 1;
            xPoints[n] = xPoints[n] - 1;
            int n3 = turn;
            xPoints[n3] = xPoints[n3] - 1;
        }
        if (save != null) {
            g.setComposite(save);
        }
        for (i = 1; i < turn; ++i) {
            g.drawLine(xPoints[i - 1], yPoints[i - 1], xPoints[i], yPoints[i]);
        }
        for (i = turn; i < nPoints - 1; ++i) {
            g.drawLine(xPoints[i], yPoints[i], xPoints[i + 1], yPoints[i + 1]);
        }
    }

    public static void draw(Graphics2D g, int ix, int iy, int width, int height, double bandOpacity, Color color) {
        if (width <= 0 || height <= 0) {
            return;
        }
        Composite save = g.getComposite();
        if (color != null) {
            g.setColor(color);
        }
        g.setComposite(AlphaComposite.getInstance(3, (float)bandOpacity));
        g.fillRect(ix, iy, width + 1, height + 1);
        if (save != null) {
            g.setComposite(save);
        }
        g.drawLine(ix, iy, ix + width, iy);
        g.drawLine(ix, iy + height, ix + width, iy + height);
    }
}

