/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.ReferenceLineInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.LegendPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisComponent;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.RangeMerger;
import com.sas.graphics.silk.util.RangeModel;
import com.sas.graphics.silk.util.ReferenceRange;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.RubberbandRectangle;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.util.ToolPallet;
import com.sas.graphics.silk.util.TransformObject;
import com.sas.graphics.silk.util.UniqueValueMapper;
import com.sas.graphics.silk.util.ViewportWarningIcon;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.RangeSlider;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.KeyStroke;

public abstract class SILKXYComponent
extends SILKComponent
implements MarginListener,
CellItemInterface,
DataRangeInterface,
ViewportInterface,
ViewportListenerInterface,
RedrawListener,
RangeChangeListener {
    private AxisComponent xAxis = null;
    private AxisComponent yAxis = null;
    private AxisComponent x2Axis = null;
    private AxisComponent y2Axis = null;
    private AxisZoomPanHandler zoomingAxisHandler = null;
    private AxisZoomPanHandler mouseOverHandler = null;
    protected AxisZoomPanHandler xAxisZoomHandler = null;
    protected AxisZoomPanHandler yAxisZoomHandler = null;
    protected AxisZoomPanHandler x2AxisZoomHandler = null;
    protected AxisZoomPanHandler y2AxisZoomHandler = null;
    private AxisInterface externalXAxis = null;
    private AxisInterface externalYAxis = null;
    private AxisInterface externalX2Axis = null;
    private AxisInterface externalY2Axis = null;
    private boolean allAxesVisible = true;
    protected boolean shouldAutocalculateXAxis = true;
    protected boolean shouldAutocalculateYAxis = true;
    private boolean zoomPanHandlersEnabled = true;
    protected Rectangle dataRegion = new Rectangle();
    protected Rectangle clipRect = null;
    protected GraphBackground wall = new GraphBackground();
    protected boolean xAxisLayout = false;
    protected boolean yAxisLayout = false;
    protected boolean x2AxisLayout = false;
    protected boolean y2AxisLayout = false;
    protected boolean hasXAxis = false;
    protected boolean hasYAxis = false;
    protected boolean hasX2Axis = false;
    protected boolean hasY2Axis = false;
    RubberbandRectangle rubberbandRect = null;
    Rectangle brush = null;
    protected static Cursor normalCursor = Cursor.getPredefinedCursor(0);
    protected static Cursor moveCursorOpen = null;
    protected static Cursor moveCursorClose = null;
    protected static Cursor zoomCursor = null;
    protected static Cursor viewportCursor = null;
    protected Cursor cursor = normalCursor;
    protected boolean mouseDown = false;
    protected boolean mouseDownInChart = false;
    protected boolean mouseDownOverWarningIcon = false;
    protected boolean mouseDownOverSelectIcon = false;
    protected boolean mouseDownOverZoomIcon = false;
    protected boolean mouseDownOverPanIcon = false;
    protected boolean mouseDownOverBrushIcon = false;
    private Point lastMouseLoc = null;
    private boolean isCreatingBrush = false;
    private boolean isDraggingBrush = false;
    protected Insets prefOuterMargin = null;
    protected Insets prefInnerMargin = null;
    protected Insets innerMargin = null;
    protected Insets outerMargin = null;
    private Vector marginChangeListeners = new Vector();
    private PrimaryDataRange primaryDataRange = new PrimaryDataRange();
    private SecondaryDataRange secondaryDataRange = new SecondaryDataRange();
    public String X_AXIS_DISPLAY_NAME = null;
    public String Y_AXIS_DISPLAY_NAME = null;
    public String X2_AXIS_DISPLAY_NAME = null;
    public String Y2_AXIS_DISPLAY_NAME = null;
    private Hashtable transforms = new Hashtable();
    protected boolean computeMargins = true;
    protected boolean hasViewport = false;
    protected Hashtable deferredViewports = null;
    protected DataRange xDataRange = null;
    protected DataRange yDataRange = null;
    protected DataRange x2DataRange = null;
    protected DataRange y2DataRange = null;
    protected boolean propogateMarginEvents = true;
    private boolean ignoreMarginEvents = false;
    protected boolean inMarginChanged = false;
    protected boolean blockMarginEvents = false;
    protected boolean inViewport = false;
    protected boolean isPanning = false;
    private boolean outerMarginSet = false;
    private boolean innerMarginSet = false;
    private int rangeSliderThumbSize = 12;
    protected Vector rangeChangeListeners = null;
    protected ViewportWarningIcon warningIcon = null;
    protected boolean blockPropertyEvent = false;
    protected int currentAxis = 0;
    static Stroke zoomHandlerReflineStroke = null;
    protected int equated = 0;
    protected boolean inLayoutChart = false;
    protected boolean blockLayoutEquated = false;
    protected int equatedPrimaryAxis = 0;
    protected ToolPallet pallet;
    private DataRange xMergedRange = null;
    private DataRange yMergedRange = null;
    private DataRange x2MergedRange = null;
    private DataRange y2MergedRange = null;
    private boolean withinSetRange = false;
    private boolean inResetViewport = false;

    public SILKXYComponent() {
        this.userSetProperties.appendProperties(new int[]{27});
        this.rubberbandRect = new RubberbandRectangle(this);
        this.rubberbandRect.setDrawRect(false);
        if (!GraphicsEnvironment.isHeadless()) {
            if (moveCursorOpen == null) {
                moveCursorOpen = this.getCustomCursor(6, 2, "icons/MoveOpen.gif");
            }
            if (moveCursorClose == null) {
                moveCursorClose = this.getCustomCursor(6, 2, "icons/MoveClosed.gif");
            }
            if (zoomCursor == null) {
                zoomCursor = this.getCustomCursor(6, 2, "icons/Zoom.gif");
            }
            if (viewportCursor == null) {
                viewportCursor = this.getCustomCursor(14, 14, "icons/Viewport.gif");
            }
        }
        this.X_AXIS_DISPLAY_NAME = ResourceLoader.getResourceString((Object)this.rb, (String)"SILKXYComponent.X.DisplayName.txt", (String)"Horizonal");
        this.Y_AXIS_DISPLAY_NAME = ResourceLoader.getResourceString((Object)this.rb, (String)"SILKXYComponent.Y.DisplayName.txt", (String)"Vertical");
        this.X2_AXIS_DISPLAY_NAME = ResourceLoader.getResourceString((Object)this.rb, (String)"SILKXYComponent.X2.DisplayName.txt", (String)"Horizonal 2");
        this.Y2_AXIS_DISPLAY_NAME = ResourceLoader.getResourceString((Object)this.rb, (String)"SILKXYComponent.Y2.DisplayName.txt", (String)"Vertical 2");
        this.innerMargin = new Insets(0, 0, 0, 0);
        this.outerMargin = new Insets(0, 0, 0, 0);
        this.prefInnerMargin = new Insets(0, 0, 0, 0);
        this.prefOuterMargin = new Insets(0, 0, 0, 0);
        this.warningIcon = new ViewportWarningIcon(this);
        this.pallet = new ToolPallet(true, true, true, true, -1000089, -1000086);
        this.pallet.setVisible(false);
        this.pallet.addListener(this);
        this.add(this.pallet);
        this.registerKeyboardAction(this, "RIGHTARROW", KeyStroke.getKeyStroke(39, 0, false), 0);
        this.registerKeyboardAction(this, "LEFTARROW", KeyStroke.getKeyStroke(37, 0, false), 0);
        this.registerKeyboardAction(this, "UPARROW", KeyStroke.getKeyStroke(38, 0, false), 0);
        this.registerKeyboardAction(this, "DOWNARROW", KeyStroke.getKeyStroke(40, 0, false), 0);
        this.registerKeyboardAction(this, "MINUS", KeyStroke.getKeyStroke(109, 0, false), 0);
        this.registerKeyboardAction(this, "MINUS", KeyStroke.getKeyStroke(45, 0, false), 0);
        this.registerKeyboardAction(this, "PLUS", KeyStroke.getKeyStroke(107, 0, false), 0);
        this.registerKeyboardAction(this, "PLUS", KeyStroke.getKeyStroke(61, 1, false), 0);
        this.registerKeyboardAction(this, "ESCAPE", KeyStroke.getKeyStroke(27, 0, false), 0);
        this.registerKeyboardAction(this, "W_KEY", KeyStroke.getKeyStroke(87, 0, false), 0);
        this.registerKeyboardAction(this, "A_KEY", KeyStroke.getKeyStroke(65, 0, false), 0);
        this.registerKeyboardAction(this, "S_KEY", KeyStroke.getKeyStroke(83, 0, false), 0);
        this.registerKeyboardAction(this, "D_KEY", KeyStroke.getKeyStroke(68, 0, false), 0);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 16 && (SILKXYComponent.this.actionMode == 1 || SILKXYComponent.this.actionMode == 6)) {
                    if (SILKXYComponent.this.mouseDownInChart) {
                        SILKXYComponent.this.cursor = moveCursorClose;
                        SILKXYComponent.this.setCursor(SILKXYComponent.this.cursor);
                    } else {
                        SILKXYComponent.this.cursor = moveCursorOpen;
                        SILKXYComponent.this.setCursor(SILKXYComponent.this.cursor);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 16 && (SILKXYComponent.this.actionMode == 1 || SILKXYComponent.this.actionMode == 6)) {
                    SILKXYComponent.this.cursor = normalCursor;
                    SILKXYComponent.this.setCursor(SILKXYComponent.this.cursor);
                }
            }
        });
    }

    protected void removeAxis(int which) {
        switch (which) {
            case 0: {
                GraphPropertiesDialog.PropertiesTreeNode node;
                if (this.xAxis != null && ((Axes)this.xAxis.getInternalAxis()).getRangeSlider() != null) {
                    this.remove((Component)((Axes)this.xAxis.getInternalAxis()).getRangeSlider());
                }
                this.xAxis = null;
                this.hasXAxis = false;
                this.xAxisLayout = false;
                if (this.propertiesDialog == null || (node = this.propertiesDialog.getRootNode("Axis", false)) == null) break;
                node.removeChild("X");
                break;
            }
            case 1: {
                GraphPropertiesDialog.PropertiesTreeNode node;
                this.yAxis = null;
                this.hasYAxis = false;
                this.yAxisLayout = false;
                if (this.propertiesDialog == null || (node = this.propertiesDialog.getRootNode("Axis", false)) == null) break;
                node.removeChild("Y");
                break;
            }
            case 3: {
                GraphPropertiesDialog.PropertiesTreeNode node;
                this.x2Axis = null;
                this.hasX2Axis = false;
                this.x2AxisLayout = false;
                if (this.propertiesDialog == null || (node = this.propertiesDialog.getRootNode("Axis", false)) == null) break;
                node.removeChild("X2");
                break;
            }
            case 4: {
                GraphPropertiesDialog.PropertiesTreeNode node;
                this.y2Axis = null;
                this.hasY2Axis = false;
                this.y2AxisLayout = false;
                if (this.propertiesDialog == null || (node = this.propertiesDialog.getRootNode("Axis", false)) == null) break;
                node.removeChild("Y2");
            }
        }
    }

    protected AxisComponent getAxisComponent(Object which) {
        if (which == null) {
            return null;
        }
        if (which.toString().equalsIgnoreCase("X") || which.equals(RoleInterface.ROLE_X) || which.equals("X")) {
            if (this.xAxis == null) {
                this.xAxis = new AxisComponent(1, null);
                ((Axes)this.xAxis.getInternalAxis()).addRedrawListener(this);
                ((Axes)this.xAxis.getInternalAxis()).addPropertyChangeListener(this);
                this.xAxisZoomHandler = new AxisZoomPanHandler((Axes)this.xAxis.getInternalAxis());
                this.xAxisZoomHandler.setMinimumViewportRange(0.001);
                this.xAxis.setZoomPanHandler(this.xAxisZoomHandler);
                this.warningIcon.addZoomPanHandler(this.xAxisZoomHandler);
                this.xAxisZoomHandler.addViewportListener(this);
                this.xAxis.setStyle(this.style);
                this.xAxisZoomHandler.setStyle(this.style);
                this.xAxis.setSolidBackground(null);
                this.xAxis.enableMarginPrefCalc();
                this.xAxis.addMarginListener(this);
                if (!this.allAxesVisible) {
                    this.xAxis.setVisible(false);
                }
            }
            return this.xAxis;
        }
        if (which.toString().equalsIgnoreCase("Y") || which.equals(RoleInterface.ROLE_Y) || which.equals("Y")) {
            if (this.yAxis == null) {
                this.yAxis = new AxisComponent(2, null);
                ((Axes)this.yAxis.getInternalAxis()).addRedrawListener(this);
                ((Axes)this.yAxis.getInternalAxis()).addPropertyChangeListener(this);
                this.yAxisZoomHandler = new AxisZoomPanHandler((Axes)this.yAxis.getInternalAxis());
                this.yAxis.setZoomPanHandler(this.yAxisZoomHandler);
                this.warningIcon.addZoomPanHandler(this.yAxisZoomHandler);
                this.yAxisZoomHandler.addViewportListener(this);
                this.yAxis.setStyle(this.style);
                this.yAxisZoomHandler.setStyle(this.style);
                this.yAxis.setSolidBackground(null);
                this.yAxis.enableMarginPrefCalc();
                this.yAxis.addMarginListener(this);
                if (!this.allAxesVisible) {
                    this.yAxis.setVisible(false);
                }
            }
            return this.yAxis;
        }
        if (which.toString().equalsIgnoreCase("X2") || which.equals("X2")) {
            if (this.x2Axis == null) {
                this.x2Axis = new AxisComponent(1, null);
                ((Axes)this.x2Axis.getInternalAxis()).addRedrawListener(this);
                ((Axes)this.x2Axis.getInternalAxis()).addPropertyChangeListener(this);
                this.x2AxisZoomHandler = new AxisZoomPanHandler((Axes)this.x2Axis.getInternalAxis());
                this.x2Axis.setZoomPanHandler(this.x2AxisZoomHandler);
                this.warningIcon.addZoomPanHandler(this.x2AxisZoomHandler);
                this.x2AxisZoomHandler.addViewportListener(this);
                this.x2Axis.setStyle(this.style);
                this.x2AxisZoomHandler.setStyle(this.style);
                this.x2Axis.setSolidBackground(null);
                this.x2Axis.addMarginListener(this);
                this.x2Axis.enableMarginPrefCalc();
                this.x2Axis.getGridLines().setVisible(false);
                this.x2Axis.setPrimary(false);
                if (!this.allAxesVisible) {
                    this.x2Axis.setVisible(false);
                }
            }
            return this.x2Axis;
        }
        if (which.toString().equalsIgnoreCase("Y2") || which.equals("Y2")) {
            if (this.y2Axis == null) {
                this.y2Axis = new AxisComponent(2, null);
                ((Axes)this.y2Axis.getInternalAxis()).addRedrawListener(this);
                ((Axes)this.y2Axis.getInternalAxis()).addPropertyChangeListener(this);
                this.y2AxisZoomHandler = new AxisZoomPanHandler((Axes)this.y2Axis.getInternalAxis());
                this.y2Axis.setZoomPanHandler(this.y2AxisZoomHandler);
                this.warningIcon.addZoomPanHandler(this.y2AxisZoomHandler);
                this.y2AxisZoomHandler.addViewportListener(this);
                this.y2Axis.setStyle(this.style);
                this.y2AxisZoomHandler.setStyle(this.style);
                this.y2Axis.setSolidBackground(null);
                this.y2Axis.addMarginListener(this);
                this.y2Axis.enableMarginPrefCalc();
                this.y2Axis.getGridLines().setVisible(false);
                this.y2Axis.setPrimary(false);
                if (!this.allAxesVisible) {
                    this.y2Axis.setVisible(false);
                }
            }
            return this.y2Axis;
        }
        return null;
    }

    @Override
    protected void doResize(int compWidthIn, int compHeightIn) {
        if (compHeightIn == this.compHeight && compWidthIn == this.compWidth) {
            return;
        }
        Insets im = new Insets(this.innerMargin.top, this.innerMargin.left, this.innerMargin.bottom, this.innerMargin.top);
        Insets om = new Insets(this.outerMargin.top, this.outerMargin.left, this.outerMargin.bottom, this.outerMargin.top);
        this.computeMargins = true;
        this.innerMarginSet = false;
        this.outerMarginSet = false;
        super.doResize(compWidthIn, compHeightIn);
        double primaryViewportMin = Double.NaN;
        double primaryViewportMax = Double.NaN;
        AxisZoomPanHandler primaryHandler = null;
        if (this.equated != 0) {
            if (this.equatedPrimaryAxis == 0 && this.xAxisZoomHandler != null && this.xAxisZoomHandler.hasViewport()) {
                primaryHandler = this.xAxisZoomHandler;
            } else if (this.equatedPrimaryAxis == 1 && this.yAxisZoomHandler != null && this.yAxisZoomHandler.hasViewport()) {
                primaryHandler = this.yAxisZoomHandler;
            }
            if (primaryHandler != null) {
                primaryViewportMin = primaryHandler.getViewportMin();
                primaryViewportMax = primaryHandler.getViewportMax();
            }
            this.blockMarginEvents = true;
            this.resetViewport();
            this.setInternalRange((byte)1, 0, this.getAxisRange(0));
            this.setInternalRange((byte)2, 0, this.getAxisRange(1));
            this.setInternalRange((byte)1, 1, this.getAxisRange(3));
            this.setInternalRange((byte)2, 1, this.getAxisRange(4));
            this.blockMarginEvents = false;
        }
        this.layoutChart();
        if (!Double.isNaN(primaryViewportMin) && !Double.isNaN(primaryViewportMax)) {
            this.zoomingAxisHandler = primaryHandler;
            primaryHandler.setViewport(primaryViewportMin, primaryViewportMax);
            this.zoomingAxisHandler = null;
        }
        if (im.bottom != this.innerMargin.bottom || im.top != this.innerMargin.top || im.right != this.innerMargin.right || im.left != this.innerMargin.left || om.bottom != this.outerMargin.bottom || om.top != this.outerMargin.top || om.right != this.outerMargin.right || om.left != this.outerMargin.left) {
            boolean innerChanged = !im.equals(this.innerMargin);
            boolean outerChanged = !om.equals(this.outerMargin);
            MarginChangeEvent e2 = new MarginChangeEvent((Object)this);
            e2.setInnerChanged(innerChanged);
            e2.setOuterChanged(outerChanged);
            this.fireMarginChanged(e2);
        }
        if (this.pallet.isVisible()) {
            this.pallet.updateXYPosition(this);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        boolean currentPalletVisibility = this.pallet.isVisible();
        if (currentPalletVisibility) {
            this.pallet.setVisible(false);
            int returnCode = super.print(graphics, pageFormat, pageIndex);
            this.pallet.setVisible(currentPalletVisibility);
            this.build(null);
            return returnCode;
        }
        return super.print(graphics, pageFormat, pageIndex);
    }

    protected void applyDeferredViewports() {
        if (this.deferredViewports != null) {
            this.setupTransforms();
            double[] minmax = null;
            minmax = (double[])this.deferredViewports.get(new Integer(1));
            if (minmax != null) {
                this.setViewport(1, 1, minmax[0], minmax[1]);
                this.deferredViewports.remove(new Integer(1));
            }
            if ((minmax = (double[])this.deferredViewports.get(new Integer(5))) != null) {
                this.setViewport(1, 5, minmax[0], minmax[1]);
                this.deferredViewports.remove(new Integer(5));
            }
            if ((minmax = (double[])this.deferredViewports.get(new Integer(2))) != null) {
                this.setViewport(1, 2, minmax[0], minmax[1]);
                this.deferredViewports.remove(new Integer(2));
            }
            if ((minmax = (double[])this.deferredViewports.get(new Integer(6))) != null) {
                this.setViewport(1, 6, minmax[0], minmax[1]);
                this.deferredViewports.remove(new Integer(6));
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawBrush(g);
    }

    protected void drawAxisZoomPanIndicators(Graphics g) {
        if (this.mouseOverHandler != null) {
            this.mouseOverHandler.drawZoomPanIndicator(g);
            if (zoomHandlerReflineStroke == null) {
                zoomHandlerReflineStroke = SASLinePatterns.getStroke((int)2, (int)1);
            }
            g.setColor(this.style.getLineStyleElement("Outlines").getLineColor());
            Stroke oldStroke = null;
            if (g instanceof Graphics2D) {
                oldStroke = ((Graphics2D)g).getStroke();
                ((Graphics2D)g).setStroke(zoomHandlerReflineStroke);
            }
            if (this.lastMouseLoc != null && !this.mouseOverHandler.getPanArea().contains(this.lastMouseLoc)) {
                if (this.mouseOverHandler.getAxis().getDimension() == 1) {
                    g.drawLine(this.lastMouseLoc.x, this.dataRegion.y, this.lastMouseLoc.x, this.dataRegion.y + this.dataRegion.height);
                } else {
                    g.drawLine(this.dataRegion.x, this.lastMouseLoc.y, this.dataRegion.x + this.dataRegion.width, this.lastMouseLoc.y);
                }
            }
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setStroke(oldStroke);
            }
        }
        if (this.xAxisZoomHandler != null && this.hasXAxis) {
            this.xAxisZoomHandler.drawViewportIndicator(g);
        }
        if (this.yAxisZoomHandler != null && this.hasYAxis) {
            this.yAxisZoomHandler.drawViewportIndicator(g);
        }
        if (this.x2AxisZoomHandler != null && this.hasX2Axis) {
            this.x2AxisZoomHandler.drawViewportIndicator(g);
        }
        if (this.y2AxisZoomHandler != null && this.hasY2Axis) {
            this.y2AxisZoomHandler.drawViewportIndicator(g);
        }
    }

    protected void layoutChart() {
        int height;
        if (this.compHeight <= 0 || this.compWidth <= 0) {
            return;
        }
        this.increaseBuildDepth();
        this.propogateMarginEvents = false;
        this.xAxisLayout = false;
        this.yAxisLayout = false;
        this.x2AxisLayout = false;
        this.y2AxisLayout = false;
        this.ignoreMarginEvents = true;
        this.inLayoutChart = true;
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        Rectangle chartArea = this.graphLayout.getChartArea();
        int yAxisHeight = chartArea.height;
        int yAxisOffset = 0;
        int xAxisWidth = chartArea.width;
        int xAxisOffset = 0;
        int maxWidth = (int)((double)chartArea.width * 0.15);
        int maxHeight = (int)((double)chartArea.height * 0.15);
        if (this.xAxis != null) {
            yAxisHeight -= maxHeight;
        }
        if (this.x2Axis != null) {
            yAxisHeight -= maxHeight;
            yAxisOffset += maxHeight;
        }
        if (this.yAxis != null) {
            xAxisWidth -= maxWidth;
            xAxisOffset += maxWidth;
        }
        if (this.y2Axis != null) {
            xAxisWidth -= maxWidth;
        }
        if (this.yAxis != null) {
            this.yAxis.setDefaultFont(this.compHeight);
            this.yAxis.setInnerMargin(new Insets(0, 0, 0, 0));
            this.yAxis.setOuterMargin(new Insets(0, 0, 0, 0));
        }
        if (this.y2Axis != null) {
            this.y2Axis.setDefaultFont(this.compHeight);
            this.y2Axis.setInnerMargin(new Insets(0, 0, 0, 0));
            this.y2Axis.setOuterMargin(new Insets(0, 0, 0, 0));
        }
        if (this.xAxis != null) {
            this.xAxis.setDefaultFont(this.compHeight);
            this.xAxis.setInnerMargin(new Insets(0, 0, 0, 0));
            this.xAxis.setOuterMargin(new Insets(0, 0, 0, 0));
        }
        if (this.x2Axis != null) {
            this.x2Axis.setDefaultFont(this.compHeight);
            this.x2Axis.setInnerMargin(new Insets(0, 0, 0, 0));
            this.x2Axis.setOuterMargin(new Insets(0, 0, 0, 0));
        }
        this.ignoreMarginEvents = false;
        int yAxisWidth = 0;
        if (this.yAxis != null) {
            this.yAxis.setBounds(chartArea.x, chartArea.y + yAxisOffset, 1, 1);
            this.yAxisLayout = true;
            this.yAxis.setAxisSize();
            this.yAxis.layoutValueLabels(this.getGraphics());
            this.yAxis.recompute();
            yAxisWidth = this.yAxis.getPreferredOuterMargin().left + this.yAxis.getPreferredOuterMargin().right;
            this.hasYAxis = yAxisWidth != 0;
        }
        int y2AxisWidth = 0;
        if (this.y2Axis != null) {
            this.y2Axis.setBounds(chartArea.x + chartArea.width - maxWidth, chartArea.y + yAxisOffset, 1, 1);
            this.y2AxisLayout = true;
            this.y2Axis.setAxisSize();
            this.y2Axis.layoutValueLabels(this.getGraphics());
            this.y2Axis.recompute();
            y2AxisWidth = this.y2Axis.getPreferredOuterMargin().left + this.y2Axis.getPreferredOuterMargin().right;
            this.hasY2Axis = y2AxisWidth != 0;
        }
        if (this.xAxis != null) {
            this.xAxis.setBounds(chartArea.x + yAxisWidth, chartArea.y + chartArea.height - maxHeight, xAxisWidth, maxHeight);
            this.xAxisLayout = true;
            this.xAxis.setAxisSize();
            this.xAxis.layoutValueLabels(this.getGraphics());
            this.xAxis.recompute();
            height = this.xAxis.getPreferredOuterMargin().top + this.xAxis.getPreferredOuterMargin().bottom;
            this.hasXAxis = height != 0;
        }
        if (this.x2Axis != null) {
            this.x2Axis.setBounds(chartArea.x + yAxisWidth, chartArea.y, xAxisWidth, maxHeight);
            this.x2AxisLayout = true;
            this.x2Axis.setAxisSize();
            this.x2Axis.layoutValueLabels(this.getGraphics());
            this.x2Axis.recompute();
            height = this.x2Axis.getPreferredOuterMargin().top + this.x2Axis.getPreferredOuterMargin().bottom;
            this.hasX2Axis = height != 0;
        }
        this.inLayoutChart = false;
        Insets im = new Insets(this.innerMargin.top, this.innerMargin.left, this.innerMargin.bottom, this.innerMargin.top);
        Insets om = new Insets(this.outerMargin.top, this.outerMargin.left, this.outerMargin.bottom, this.outerMargin.top);
        this.marginChanged(new MarginChangeEvent((Object)this));
        this.computeInnerOuterMargin();
        this.propogateMarginEvents = true;
        if (im.bottom != this.innerMargin.bottom || im.top != this.innerMargin.top || im.right != this.innerMargin.right || im.left != this.innerMargin.left || om.bottom != this.outerMargin.bottom || om.top != this.outerMargin.top || om.right != this.outerMargin.right || om.left != this.outerMargin.left) {
            this.marginChanged(new MarginChangeEvent((Object)this));
        }
        this.decreaseBuildDepth();
    }

    private Insets computeOutsideReferenceLineMargins() {
        TextLayout tl;
        ReferenceLineInterface rli;
        int i;
        Insets rc = new Insets(0, 0, 0, 0);
        FontRenderContext frc = new FontRenderContext(null, false, false);
        AxisInterface axis = null;
        if (this.yAxis != null && this.externalYAxis == null) {
            axis = this.yAxis.getInternalAxis();
        } else if (this.externalYAxis != null) {
            axis = this.externalYAxis;
        }
        if (axis != null) {
            for (i = 0; i < axis.getNumberReferenceLines(); ++i) {
                rli = axis.getReferenceLine(i);
                if (!rli.isOutsideLabel() || rli.getLabelString() == null || rli.getLabelString().length() == 0 || !rli.getLabel().isVisible()) continue;
                tl = new TextLayout(rli.getLabelString(), SILKUtilities.adjustFontSize(rli.getLabel().getFont()), frc);
                if (rli.getSameLabelSide()) {
                    rc.left = Math.max(rc.left, (int)tl.getBounds().getWidth() + 2 * this.graphLayout.INNER_MARGIN);
                    continue;
                }
                rc.right = Math.max(rc.right, (int)tl.getBounds().getWidth() + 2 * this.graphLayout.INNER_MARGIN);
            }
        }
        axis = null;
        if (this.y2Axis != null && this.externalY2Axis == null) {
            axis = this.y2Axis.getInternalAxis();
        } else if (this.externalY2Axis != null) {
            axis = this.externalY2Axis;
        }
        if (axis != null) {
            for (i = 0; i < axis.getNumberReferenceLines(); ++i) {
                rli = axis.getReferenceLine(i);
                if (!rli.isOutsideLabel() || rli.getLabelString() == null || rli.getLabelString().length() == 0 || !rli.getLabel().isVisible()) continue;
                tl = new TextLayout(rli.getLabelString(), SILKUtilities.adjustFontSize(rli.getLabel().getFont()), frc);
                if (rli.getSameLabelSide()) {
                    rc.left = Math.max(rc.left, (int)tl.getBounds().getWidth() + 2 * this.graphLayout.INNER_MARGIN);
                    continue;
                }
                rc.right = Math.max(rc.right, (int)tl.getBounds().getWidth() + 2 * this.graphLayout.INNER_MARGIN);
            }
        }
        axis = null;
        if (this.xAxis != null && this.externalXAxis == null) {
            axis = this.xAxis.getInternalAxis();
        } else if (this.externalXAxis != null) {
            axis = this.externalXAxis;
        }
        if (axis != null) {
            for (i = 0; i < axis.getNumberReferenceLines(); ++i) {
                rli = axis.getReferenceLine(i);
                if (!rli.isOutsideLabel() || rli.getLabelString() == null || rli.getLabelString().length() == 0 || !rli.getLabel().isVisible()) continue;
                tl = new TextLayout(rli.getLabelString(), SILKUtilities.adjustFontSize(rli.getLabel().getFont()), frc);
                if (rli.getSameLabelSide()) {
                    rc.bottom = Math.max(rc.bottom, (int)tl.getBounds().getHeight() + 2 * this.graphLayout.INNER_MARGIN);
                    continue;
                }
                rc.top = Math.max(rc.top, (int)tl.getBounds().getHeight() + 2 * this.graphLayout.INNER_MARGIN);
            }
        }
        axis = null;
        if (this.x2Axis != null && this.externalX2Axis == null) {
            axis = this.x2Axis.getInternalAxis();
        } else if (this.externalX2Axis != null) {
            axis = this.externalX2Axis;
        }
        if (axis != null) {
            for (i = 0; i < axis.getNumberReferenceLines(); ++i) {
                rli = axis.getReferenceLine(i);
                if (!rli.isOutsideLabel() || rli.getLabelString() == null || rli.getLabelString().length() == 0 || !rli.getLabel().isVisible()) continue;
                tl = new TextLayout(rli.getLabelString(), SILKUtilities.adjustFontSize(rli.getLabel().getFont()), frc);
                if (rli.getSameLabelSide()) {
                    rc.bottom = Math.max(rc.bottom, (int)tl.getBounds().getHeight() + 2 * this.graphLayout.INNER_MARGIN);
                    continue;
                }
                rc.top = Math.max(rc.top, (int)tl.getBounds().getHeight() + 2 * this.graphLayout.INNER_MARGIN);
            }
        }
        return rc;
    }

    protected void computeInnerOuterMargin() {
        Rectangle r = this.graphLayout.getChartArea();
        if (r == null || !this.computeMargins) {
            return;
        }
        AxisComponent ac = null;
        int yAxisWidth = 0;
        int y2AxisWidth = 0;
        if (this.hasYAxis && (ac = this.getAxisComponent("Y")) != null && ac.getBounds() != null) {
            yAxisWidth = ac.getBounds().width;
        } else if (this.yAxis != null && this.zoomPanHandlersEnabled) {
            yAxisWidth = 9;
        }
        if (this.hasY2Axis && (ac = this.getAxisComponent("Y2")) != null && ac.getBounds() != null) {
            y2AxisWidth = ac.getBounds().width;
        } else if (this.y2Axis != null && this.zoomPanHandlersEnabled) {
            y2AxisWidth = 9;
        }
        if (this.outerMargin == null) {
            this.outerMargin = new Insets(0, 0, 0, 0);
        }
        if (this.innerMargin == null) {
            this.innerMargin = new Insets(0, 0, 0, 0);
        }
        if (this.prefOuterMargin == null) {
            this.prefOuterMargin = new Insets(0, 0, 0, 0);
        }
        if (this.prefInnerMargin == null) {
            this.prefInnerMargin = new Insets(0, 0, 0, 0);
        }
        if (this.yAxis != null && this.yAxis.getRangeModel(false) != null && this.isRangeSliderSupported(1)) {
            y2AxisWidth += this.rangeSliderThumbSize;
        }
        int xAxisHeight = 0;
        int x2AxisHeight = 0;
        if (this.hasXAxis && (ac = this.getAxisComponent("X")) != null && ac.getBounds() != null) {
            xAxisHeight = ac.getBounds().height;
        } else if (this.xAxis != null && this.zoomPanHandlersEnabled) {
            xAxisHeight = 9;
        }
        if (this.hasX2Axis && (ac = this.getAxisComponent("X2")) != null && ac.getBounds() != null) {
            x2AxisHeight = ac.getBounds().height;
        } else if (this.x2Axis != null && this.zoomPanHandlersEnabled) {
            x2AxisHeight = 9;
        }
        if (this.xAxis != null && this.xAxis.getRangeModel(false) != null && this.isRangeSliderSupported(0)) {
            x2AxisHeight += this.rangeSliderThumbSize;
        }
        Insets reflineInsets = this.computeOutsideReferenceLineMargins();
        xAxisHeight = Math.max(xAxisHeight, reflineInsets.bottom);
        x2AxisHeight = Math.max(x2AxisHeight, reflineInsets.top);
        yAxisWidth = Math.max(yAxisWidth, reflineInsets.left);
        y2AxisWidth = Math.max(y2AxisWidth, reflineInsets.right);
        this.prefOuterMargin.top = r.y + x2AxisHeight;
        this.prefOuterMargin.bottom = this.compHeight - (r.height + r.y) + xAxisHeight;
        this.prefOuterMargin.left = r.x + yAxisWidth;
        this.prefOuterMargin.right = this.compWidth - (r.x + r.width) + y2AxisWidth;
        this.pallet.makeSpaceForYourself(this.prefOuterMargin);
        if (!this.outerMarginSet) {
            this.outerMargin.top = this.prefOuterMargin.top;
            this.outerMargin.left = this.prefOuterMargin.left;
            this.outerMargin.bottom = this.prefOuterMargin.bottom;
            this.outerMargin.right = this.prefOuterMargin.right;
        }
        if (this.hasXAxis && (ac = this.getAxisComponent("X")) != null) {
            this.prefInnerMargin.left = ac.getInnerMargin().left;
            this.prefInnerMargin.right = ac.getInnerMargin().right;
        } else {
            this.prefInnerMargin.left = this.getPreferredChartInnerMargin() == null ? 0 : this.getPreferredChartInnerMargin().left;
            int n = this.prefInnerMargin.right = this.getPreferredChartInnerMargin() == null ? 0 : this.getPreferredChartInnerMargin().right;
        }
        if (this.hasX2Axis && (ac = this.getAxisComponent("X2")) != null) {
            this.prefInnerMargin.left = Math.max(this.prefInnerMargin.left, ac.getInnerMargin().left);
            this.prefInnerMargin.right = Math.max(this.prefInnerMargin.right, ac.getInnerMargin().right);
        } else {
            this.prefInnerMargin.left = Math.max(this.prefInnerMargin.left, this.getPreferredChartInnerMargin() == null ? 0 : this.getPreferredChartInnerMargin().left);
            this.prefInnerMargin.right = Math.max(this.prefInnerMargin.right, this.getPreferredChartInnerMargin() == null ? 0 : this.getPreferredChartInnerMargin().right);
        }
        if (this.hasYAxis && (ac = this.getAxisComponent("Y")) != null) {
            this.prefInnerMargin.top = ac.getInnerMargin().top;
            this.prefInnerMargin.bottom = ac.getInnerMargin().bottom;
        } else {
            this.prefInnerMargin.top = this.getPreferredChartInnerMargin() == null ? 0 : this.getPreferredChartInnerMargin().top;
            int n = this.prefInnerMargin.bottom = this.getPreferredChartInnerMargin() == null ? 0 : this.getPreferredChartInnerMargin().bottom;
        }
        if (this.hasY2Axis && (ac = this.getAxisComponent("Y2")) != null) {
            this.prefInnerMargin.top = Math.max(this.prefInnerMargin.top, ac.getInnerMargin().top);
            this.prefInnerMargin.bottom = Math.max(this.prefInnerMargin.bottom, ac.getInnerMargin().bottom);
        } else {
            this.prefInnerMargin.top = Math.max(this.prefInnerMargin.top, this.getPreferredChartInnerMargin() == null ? 0 : this.getPreferredChartInnerMargin().top);
            this.prefInnerMargin.bottom = Math.max(this.prefInnerMargin.bottom, this.getPreferredChartInnerMargin() == null ? 0 : this.getPreferredChartInnerMargin().bottom);
        }
        if (!this.innerMarginSet) {
            this.innerMargin.top = this.prefInnerMargin.top;
            this.innerMargin.left = this.prefInnerMargin.left;
            this.innerMargin.bottom = this.prefInnerMargin.bottom;
            this.innerMargin.right = this.prefInnerMargin.right;
        }
        this.pallet.updateXYPosition(this);
    }

    protected int[] drawGridLines(AxisInterface axis, Graphics g, int whichAxis) {
        int[] rc;
        block10: {
            double[] pvals;
            Object[] vals;
            Color color2;
            Color color;
            boolean engraved;
            block9: {
                Object engr;
                Color wallColor = this.style.getFillStyleElement("WallFill").getFillColor();
                if (this.wall != null) {
                    wallColor = this.wall.getSolidBackground();
                }
                boolean bl = engraved = (engr = SILKGlobal.getInstance().getPropertyValue(58)) instanceof Boolean ? (Boolean)engr : true;
                if (axis == null || !axis.getGridLines().isVisible()) {
                    return null;
                }
                color = engraved ? ColorUtilities.darker(wallColor) : this.style.getLineStyleElement("GridLines").getLineColor();
                color2 = ColorUtilities.brighter(wallColor);
                vals = axis.getTickMarkValues(false);
                if (vals == null || vals.length > 50) {
                    return null;
                }
                pvals = new double[3];
                rc = new int[vals.length];
                if (whichAxis != 0 && whichAxis != 3) break block9;
                for (int i = 0; i < vals.length; ++i) {
                    TransformInterface ti = null;
                    ti = whichAxis == 0 ? this.getTransform("X", null) : this.getTransform("X2", null);
                    if (ti == null) continue;
                    if (vals[i] instanceof Number) {
                        ti.project(((Number)vals[i]).doubleValue(), 0.0, 0.0, pvals);
                    } else {
                        ti.project(i, 0.0, 0.0, pvals);
                    }
                    rc[i] = (int)pvals[0];
                    if (rc[i] < this.dataRegion.x || rc[i] > this.dataRegion.x + this.dataRegion.width) continue;
                    g.setColor(color);
                    g.drawLine((int)pvals[0], this.dataRegion.y, (int)pvals[0], this.dataRegion.y + this.dataRegion.height - 1);
                    if (!engraved) continue;
                    g.setColor(color2);
                    g.drawLine((int)pvals[0] + 1, this.dataRegion.y, (int)pvals[0] + 1, this.dataRegion.y + this.dataRegion.height - 1);
                }
                break block10;
            }
            if (whichAxis != 1 && whichAxis != 4) break block10;
            for (int i = 0; i < vals.length; ++i) {
                TransformInterface ti = null;
                ti = whichAxis == 1 ? this.getTransform(null, "Y") : this.getTransform(null, "Y2");
                if (ti == null) continue;
                if (vals[i] instanceof Number) {
                    ti.project(0.0, ((Number)vals[i]).doubleValue(), 0.0, pvals);
                } else {
                    ti.project(0.0, i, 0.0, pvals);
                }
                rc[i] = (int)pvals[1];
                if (rc[i] < this.dataRegion.y || rc[i] > this.dataRegion.y + this.dataRegion.height) continue;
                g.setColor(color);
                g.drawLine(this.dataRegion.x, (int)pvals[1], this.dataRegion.x + this.dataRegion.width - 1, (int)pvals[1]);
                if (!engraved) continue;
                g.setColor(color2);
                g.drawLine(this.dataRegion.x, (int)pvals[1] + 1, this.dataRegion.x + this.dataRegion.width - 1, (int)pvals[1] + 1);
            }
        }
        return rc;
    }

    protected void drawAxes(Graphics g) {
        Axes a;
        if (SILKGlobal.isFlagSet(5)) {
            Rectangle r;
            g.setColor(Color.GREEN);
            if (this.y2Axis != null) {
                r = this.y2Axis.getBounds();
                g.fillRect(r.x, r.y, r.width, r.height);
            }
            if (this.xAxis != null) {
                r = this.xAxis.getBounds();
                g.fillRect(r.x, r.y, r.width, r.height);
            }
            if (this.x2Axis != null) {
                r = this.x2Axis.getBounds();
                g.fillRect(r.x, r.y, r.width, r.height);
            }
            if (this.yAxis != null) {
                r = this.yAxis.getBounds();
                g.fillRect(r.x, r.y, r.width, r.height);
            }
        }
        if (this.y2Axis != null && this.hasY2Axis) {
            this.y2Axis.draw(g, false);
            a = (Axes)this.y2Axis.getInternalAxis();
            this.drawGridLines(a, g, 4);
        } else if (this.externalY2Axis != null) {
            this.drawGridLines(this.externalY2Axis, g, 4);
        }
        if (this.xAxis != null && this.hasXAxis) {
            a = (Axes)this.xAxis.getInternalAxis();
            this.xAxis.draw(g, false);
            this.drawGridLines(a, g, 0);
        } else if (this.externalXAxis != null) {
            this.drawGridLines(this.externalXAxis, g, 0);
        }
        if (this.x2Axis != null && this.hasX2Axis) {
            this.x2Axis.draw(g, false);
            a = (Axes)this.x2Axis.getInternalAxis();
            this.drawGridLines(a, g, 3);
        } else if (this.externalX2Axis != null) {
            this.drawGridLines(this.externalX2Axis, g, 3);
        }
        if (this.yAxis != null && this.hasYAxis) {
            this.yAxis.draw(g, false);
            a = (Axes)this.yAxis.getInternalAxis();
            this.drawGridLines(a, g, 1);
        } else if (this.externalYAxis != null) {
            this.drawGridLines(this.externalYAxis, g, 1);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.buildAndDraw(null, null, null);
    }

    protected Insets mergeInnerMargin(Insets m1, Insets m2) {
        if (m1 == null && m2 == null) {
            return null;
        }
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        return new Insets(Math.max(m1.top, m2.top), Math.max(m1.left, m2.left), Math.max(m1.bottom, m2.bottom), Math.max(m1.right, m2.right));
    }

    public void marginChanged(MarginChangeEvent e) {
        boolean outerChanged;
        Rectangle r;
        RangeSlider rangeSlider;
        Axes axis;
        boolean hasYAxisRangeSlider;
        Rectangle r2;
        if (this.ignoreMarginEvents || this.inMarginChanged || this.blockMarginEvents) {
            return;
        }
        this.inMarginChanged = true;
        boolean throwRecursiveEvent = false;
        Rectangle chartArea = this.graphLayout.getChartArea();
        int yAxisHeight = chartArea.height;
        int yAxisOffset = 0;
        int xAxisWidth = chartArea.width;
        int xAxisOffset = 0;
        int xAxisHeight = 0;
        int x2AxisHeight = 0;
        int yAxisWidth = 0;
        int y2AxisWidth = 0;
        int xRangeSliderHeight = 0;
        int yRangeSliderWidth = 0;
        if (this.xAxis != null && this.hasXAxis) {
            xAxisHeight = this.xAxis.getPreferredOuterMargin().bottom + this.xAxis.getPreferredOuterMargin().top;
        } else if (this.xAxis != null && this.zoomPanHandlersEnabled) {
            xAxisHeight = 9;
        }
        if (this.x2Axis != null && this.hasX2Axis) {
            x2AxisHeight = this.x2Axis.getPreferredOuterMargin().bottom + this.x2Axis.getPreferredOuterMargin().top;
        } else if (this.x2Axis != null && this.zoomPanHandlersEnabled) {
            x2AxisHeight = 9;
        }
        if (this.yAxis != null && this.hasYAxis) {
            yAxisWidth = this.yAxis.getPreferredOuterMargin().left + this.yAxis.getPreferredOuterMargin().right;
        } else if (this.yAxis != null && this.zoomPanHandlersEnabled) {
            yAxisWidth = 9;
        }
        if (this.y2Axis != null && this.hasY2Axis) {
            y2AxisWidth = this.y2Axis.getPreferredOuterMargin().left + this.y2Axis.getPreferredOuterMargin().right;
        } else if (this.y2Axis != null && this.zoomPanHandlersEnabled) {
            y2AxisWidth = 9;
        }
        if (this.xAxis != null && this.xAxis.getRangeModel(false) != null && this.isRangeSliderSupported(0)) {
            xRangeSliderHeight += this.rangeSliderThumbSize;
        }
        if (this.yAxis != null && this.yAxis.getRangeModel(false) != null && this.isRangeSliderSupported(1)) {
            yRangeSliderWidth += this.rangeSliderThumbSize;
        }
        int chartAreaBottom = this.compHeight - (chartArea.y + chartArea.height);
        int chartAreaRight = this.compWidth - (chartArea.x + chartArea.width);
        int adjustedXAxisHeight = Math.max(xAxisHeight, this.outerMargin.bottom - chartAreaBottom);
        int adjustedX2AxisHeight = Math.max(x2AxisHeight, this.outerMargin.top - chartArea.y);
        int adjustedYAxisWidth = Math.max(yAxisWidth, this.outerMargin.left - chartArea.x);
        int adjustedY2AxisWidth = Math.max(y2AxisWidth, this.outerMargin.right - chartAreaRight);
        yAxisHeight -= adjustedXAxisHeight;
        yAxisHeight -= adjustedX2AxisHeight;
        yAxisOffset += adjustedX2AxisHeight;
        xAxisWidth -= adjustedYAxisWidth;
        xAxisOffset += adjustedYAxisWidth;
        xAxisWidth -= adjustedY2AxisWidth;
        if (this.hasYAxis && this.yAxis != null && this.yAxisLayout) {
            Rectangle yAxisBounds = this.yAxis.getBounds();
            this.ignoreMarginEvents = true;
            this.yAxis.setInnerMargin(this.mergeInnerMargin(this.yAxis.getPreferredInnerMargin(), this.getPreferredChartInnerMargin()));
            this.yAxis.setOuterMargin(this.yAxis.getPreferredOuterMargin());
            this.ignoreMarginEvents = false;
            Rectangle newYAxisBounds = new Rectangle(chartArea.x + adjustedYAxisWidth - yAxisWidth, chartArea.y + yAxisOffset, yAxisWidth, yAxisHeight);
            if (yAxisBounds == null || !yAxisBounds.equals(newYAxisBounds)) {
                this.yAxis.setBounds(newYAxisBounds);
                this.yAxis.recompute();
                this.yAxisZoomHandler.setAxisArea(this.yAxis.getBounds());
                throwRecursiveEvent = true;
            }
        } else if (this.yAxis != null && this.zoomPanHandlersEnabled) {
            r2 = new Rectangle(chartArea.x + adjustedYAxisWidth - yAxisWidth, chartArea.y + yAxisOffset, 9, yAxisHeight);
            this.yAxisZoomHandler.setAxisArea(r2);
            this.yAxis.setBounds(r2);
        }
        if (this.hasXAxis && this.xAxis != null && this.xAxisLayout) {
            Rectangle xAxisBounds = this.xAxis.getBounds();
            this.ignoreMarginEvents = true;
            this.xAxis.setInnerMargin(this.mergeInnerMargin(this.xAxis.getPreferredInnerMargin(), this.getPreferredChartInnerMargin()));
            this.ignoreMarginEvents = false;
            Rectangle newXAxisBounds = new Rectangle(chartArea.x + xAxisOffset, chartArea.y + chartArea.height - adjustedXAxisHeight, xAxisWidth, xAxisHeight);
            if (xAxisBounds == null || !xAxisBounds.equals(newXAxisBounds)) {
                this.xAxis.setBounds(newXAxisBounds);
                this.xAxis.recompute();
                this.xAxisZoomHandler.setAxisArea(this.xAxis.getBounds());
                throwRecursiveEvent = true;
            }
        } else if (this.xAxis != null && this.zoomPanHandlersEnabled) {
            r2 = new Rectangle(chartArea.x + xAxisOffset, chartArea.y + chartArea.height - adjustedXAxisHeight, xAxisWidth, 9);
            this.xAxis.setBounds(r2);
            this.xAxisZoomHandler.setAxisArea(r2);
        }
        if (this.hasX2Axis && this.x2Axis != null && this.x2AxisLayout) {
            Rectangle x2AxisBounds = this.x2Axis.getBounds();
            this.ignoreMarginEvents = true;
            this.x2Axis.setInnerMargin(this.mergeInnerMargin(this.x2Axis.getPreferredInnerMargin(), this.getPreferredChartInnerMargin()));
            this.x2Axis.setOuterMargin(this.x2Axis.getPreferredOuterMargin());
            this.ignoreMarginEvents = false;
            Rectangle newX2AxisBounds = new Rectangle(chartArea.x + xAxisOffset, chartArea.y + adjustedX2AxisHeight - x2AxisHeight, xAxisWidth, x2AxisHeight);
            if (x2AxisBounds == null || !x2AxisBounds.equals(newX2AxisBounds)) {
                this.x2Axis.setBounds(newX2AxisBounds);
                this.x2Axis.recompute();
                this.x2AxisZoomHandler.setAxisArea(this.x2Axis.getBounds());
                throwRecursiveEvent = true;
            }
        } else if (this.x2Axis != null && this.zoomPanHandlersEnabled) {
            r2 = new Rectangle(chartArea.x + xAxisOffset, chartArea.y, xAxisWidth, 9);
            this.x2AxisZoomHandler.setAxisArea(r2);
            this.x2Axis.setBounds(r2);
        }
        if (this.hasY2Axis && this.y2Axis != null && this.y2AxisLayout) {
            Rectangle y2AxisBounds = this.y2Axis.getBounds();
            this.ignoreMarginEvents = true;
            this.y2Axis.setInnerMargin(this.mergeInnerMargin(this.y2Axis.getPreferredInnerMargin(), this.getPreferredChartInnerMargin()));
            this.y2Axis.setOuterMargin(this.y2Axis.getPreferredOuterMargin());
            this.ignoreMarginEvents = false;
            Rectangle newY2AxisBounds = new Rectangle(chartArea.x + chartArea.width - adjustedY2AxisWidth, chartArea.y + yAxisOffset, y2AxisWidth, yAxisHeight);
            if (y2AxisBounds == null || !y2AxisBounds.equals(newY2AxisBounds)) {
                this.y2Axis.setBounds(newY2AxisBounds);
                this.y2Axis.recompute();
                this.y2AxisZoomHandler.setAxisArea(this.y2Axis.getBounds());
                throwRecursiveEvent = true;
            }
        } else if (this.y2Axis != null && this.zoomPanHandlersEnabled) {
            r2 = new Rectangle(chartArea.x + chartArea.width - adjustedY2AxisWidth, chartArea.y + yAxisOffset, y2AxisWidth, yAxisHeight);
            this.y2AxisZoomHandler.setAxisArea(r2);
            this.y2Axis.setBounds(r2);
        }
        if (throwRecursiveEvent) {
            this.marginChanged(new MarginChangeEvent((Object)this));
        }
        this.computeInnerOuterMargin();
        this.dataRegion.x = this.outerMargin.left;
        this.dataRegion.y = this.outerMargin.top;
        this.dataRegion.width = this.compWidth - this.outerMargin.right - this.outerMargin.left;
        this.dataRegion.height = this.compHeight - this.outerMargin.top - this.outerMargin.bottom;
        boolean hasXAxisRangeSlider = this.xAxis != null && ((Axes)this.xAxis.getInternalAxis()).getRangeModel(false) != null;
        boolean bl = hasYAxisRangeSlider = this.yAxis != null && ((Axes)this.yAxis.getInternalAxis()).getRangeModel(false) != null;
        if (hasXAxisRangeSlider) {
            axis = (Axes)this.xAxis.getInternalAxis();
            rangeSlider = axis.getRangeSlider();
            if (!this.isRangeSliderSupported(0)) {
                this.remove((Component)rangeSlider);
            } else {
                int left = rangeSlider.getInsets().left + rangeSlider.getFocusInsets().left;
                int right = rangeSlider.getInsets().right + rangeSlider.getFocusInsets().right;
                r = this.graphLayout.getChartArea();
                axis.getRangeSlider().setBounds(this.dataRegion.x + this.innerMargin.left - rangeSlider.getTrackBuffer() - left, r.y, this.dataRegion.width - this.innerMargin.left - this.innerMargin.right + rangeSlider.getTrackBuffer() * 2 + left + right + 1, this.rangeSliderThumbSize);
                if (axis.getRangeSlider().getParent() == null) {
                    this.add((Component)axis.getRangeSlider());
                }
                axis.getRangeSlider().removeMouseMotionListener((MouseMotionListener)this);
                axis.getRangeSlider().addMouseMotionListener((MouseMotionListener)this);
                axis.getRangeSlider().removeMouseListener((MouseListener)this);
                axis.getRangeSlider().addMouseListener((MouseListener)this);
            }
        }
        if (hasYAxisRangeSlider) {
            axis = (Axes)this.yAxis.getInternalAxis();
            rangeSlider = axis.getRangeSlider();
            if (!this.isRangeSliderSupported(1)) {
                this.remove((Component)rangeSlider);
            } else {
                rangeSlider.setOrientation(1);
                rangeSlider.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                int top = rangeSlider.getInsets().top + rangeSlider.getFocusInsets().top;
                int bottom = rangeSlider.getInsets().bottom + rangeSlider.getFocusInsets().bottom;
                r = this.graphLayout.getChartArea();
                axis.getRangeSlider().setBounds(r.x + r.width - this.rangeSliderThumbSize, this.dataRegion.y + this.innerMargin.top - rangeSlider.getTrackBuffer() - top, this.rangeSliderThumbSize, this.dataRegion.height - this.innerMargin.top - this.innerMargin.bottom + rangeSlider.getTrackBuffer() * 2 + top + bottom + 1);
                if (axis.getRangeSlider().getParent() == null) {
                    this.add((Component)axis.getRangeSlider());
                }
                axis.getRangeSlider().removeMouseMotionListener((MouseMotionListener)this);
                axis.getRangeSlider().addMouseMotionListener((MouseMotionListener)this);
                axis.getRangeSlider().removeMouseListener((MouseListener)this);
                axis.getRangeSlider().addMouseListener((MouseListener)this);
            }
        }
        this.clipRect = new Rectangle(this.dataRegion.x, this.dataRegion.y, this.dataRegion.width, this.dataRegion.height);
        this.graphLayout.setDataRegion(this.dataRegion);
        this.wall.setDrawingArea(this.dataRegion);
        this.inMarginChanged = false;
        if (this.equated != 0 && !this.inLayoutChart) {
            while (!this.layoutEquated()) {
            }
        }
        boolean innerChanged = !this.prefInnerMargin.equals(this.innerMargin);
        boolean bl2 = outerChanged = !this.prefOuterMargin.equals(this.outerMargin);
        if ((innerChanged || outerChanged) && this.propogateMarginEvents) {
            MarginChangeEvent e2 = new MarginChangeEvent((Object)this);
            e2.setInnerChanged(innerChanged);
            e2.setOuterChanged(outerChanged);
            this.fireMarginChanged(e2);
        }
        if (hasXAxisRangeSlider) {
            this.setRangeSliderCalculation(this.xAxis);
        }
        if (hasYAxisRangeSlider) {
            this.setRangeSliderCalculation(this.yAxis);
        }
    }

    private void setRangeSliderCalculation(AxisComponent axisComponent) {
        if (axisComponent.getRangeModel(false) != null) {
            DataRange range = axisComponent.getOutputRange();
            if (range == null) {
                return;
            }
            double min = range instanceof ContinuousRange ? ((ContinuousRange)range).getMin() : 0.0;
            double max = range instanceof ContinuousRange ? ((ContinuousRange)range).getMax() : (double)(((DiscreteRange)range).getValuesSize() - 1);
            Axes axis = (Axes)axisComponent.getInternalAxis();
            if (axis.getDimension() == 2 && !axis.isReverse(1) || axis.getDimension() == 1 && axis.isReverse(0)) {
                double temp = min;
                min = max;
                max = temp;
            }
            RangeModel rm = (RangeModel)axisComponent.getRangeModel(false);
            double d1 = min * rm.getMultiplier();
            double d2 = axis.getDimension() == 1 ? (double)(this.dataRegion.width - this.innerMargin.left - this.innerMargin.right) / ((max - min) * rm.getMultiplier()) : (double)(this.dataRegion.height - this.innerMargin.top - this.innerMargin.bottom) / ((max - min) * rm.getMultiplier());
            axis.getRangeSlider().setCalculation(axis.getRangeSlider().getTrackBuffer(), d1, d2);
        }
    }

    private boolean layoutEquated() {
        DataRange xdr = this.getOutputRange(this.xAxis, this.xAxisZoomHandler);
        DataRange ydr = this.getOutputRange(this.yAxis, this.yAxisZoomHandler);
        if (!(xdr instanceof ContinuousRange) || !(ydr instanceof ContinuousRange)) {
            return true;
        }
        ContinuousRange cxdr = (ContinuousRange)xdr;
        ContinuousRange cydr = (ContinuousRange)ydr;
        if (cxdr.getMin() == cxdr.getMax() && cydr.getMin() == cydr.getMax()) {
            return true;
        }
        if (this.xAxisZoomHandler != null && this.xAxisZoomHandler.hasViewport() || this.yAxisZoomHandler != null && this.yAxisZoomHandler.hasViewport()) {
            Axes axis = null;
            AxisZoomPanHandler handler = null;
            AxisComponent zoomingAxis = null;
            if (this.zoomingAxisHandler == this.xAxisZoomHandler) {
                axis = (Axes)this.yAxis.getInternalAxis();
                zoomingAxis = this.xAxis;
                handler = this.yAxisZoomHandler;
            } else if (this.zoomingAxisHandler == this.yAxisZoomHandler) {
                axis = (Axes)this.xAxis.getInternalAxis();
                zoomingAxis = this.yAxis;
                handler = this.xAxisZoomHandler;
            }
            if (zoomingAxis != null && zoomingAxis.isPanning()) {
                return true;
            }
            if (this.zoomingAxisHandler != null && this.zoomingAxisHandler.hasViewport()) {
                if (this.blockLayoutEquated) {
                    return true;
                }
                this.equateViewports(axis, handler, this.zoomingAxisHandler);
            } else if (this.zoomingAxisHandler != null) {
                handler.resetAxis();
            } else if (!this.blockLayoutEquated) {
                this.equateScales(cxdr, cydr, true);
            }
            return true;
        }
        boolean rc = this.equateScales(cxdr, cydr, false);
        this.blockLayoutEquated = false;
        return rc;
    }

    private boolean equateScales(ContinuousRange cxdr, ContinuousRange cydr, boolean synchViewport) {
        int xPix = this.dataRegion.width - this.innerMargin.left - this.innerMargin.right;
        int yPix = this.dataRegion.height - this.innerMargin.top - this.innerMargin.bottom;
        if (xPix <= 0 || yPix <= 0) {
            return true;
        }
        double xRge = cxdr.getMax() - cxdr.getMin();
        double yRge = cydr.getMax() - cydr.getMin();
        double xScale = xRge / (double)xPix;
        double yScale = yRge / (double)yPix;
        double d = 1.0E-4 * Math.min(xRge, yRge);
        if (Math.abs(xScale - yScale) < d) {
            return true;
        }
        double scaleMax = Math.max(xScale, yScale);
        double xRange = (double)xPix * scaleMax;
        double yRange = (double)yPix * scaleMax;
        double xMid = cxdr.getMin() + (cxdr.getMax() - cxdr.getMin()) / 2.0;
        double yMid = cydr.getMin() + (cydr.getMax() - cydr.getMin()) / 2.0;
        ContinuousRange newxrange = new ContinuousRange(xMid - xRange / 2.0, xMid + xRange / 2.0);
        ContinuousRange newyrange = new ContinuousRange(yMid - yRange / 2.0, yMid + yRange / 2.0);
        AxisZoomPanHandler zah = null;
        AxisZoomPanHandler handler = null;
        Axes axis = null;
        if (scaleMax != xScale) {
            this.setInternalRange((byte)1, 0, (DataRange)newxrange);
            this.equatedPrimaryAxis = 1;
            zah = this.yAxisZoomHandler;
            handler = this.xAxisZoomHandler;
            axis = this.xAxis != null ? (Axes)this.xAxis.getInternalAxis() : null;
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        } else if (scaleMax != yScale) {
            this.setInternalRange((byte)2, 0, (DataRange)newyrange);
            this.equatedPrimaryAxis = 0;
            zah = this.xAxisZoomHandler;
            handler = this.yAxisZoomHandler;
            axis = this.yAxis != null ? (Axes)this.yAxis.getInternalAxis() : null;
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        }
        if (synchViewport) {
            this.equateViewports(axis, handler, zah);
        }
        return false;
    }

    private void equateViewports(Axes axis, AxisZoomPanHandler handler, AxisZoomPanHandler zah) {
        double halfRange;
        if (this.blockLayoutEquated || axis == null || handler == null || zah == null) {
            return;
        }
        double startPercentage = (zah.getViewportMin() - zah.getDataMin()) / (zah.getDataMax() - zah.getDataMin());
        double endPercentage = (zah.getViewportMax() - zah.getDataMin()) / (zah.getDataMax() - zah.getDataMin());
        double startOffset = axis.getFullDataMin();
        double startValue = startOffset + startPercentage * (axis.getFullDataMax() - axis.getFullDataMin());
        double endValue = startOffset + endPercentage * (axis.getFullDataMax() - axis.getFullDataMin());
        double midpoint = handler.getViewportMin() + (handler.getViewportMax() - handler.getViewportMin()) / 2.0;
        if (midpoint - (halfRange = (endValue - startValue) / 2.0) < handler.getDataMin()) {
            midpoint = handler.getDataMin() + halfRange;
        } else if (midpoint + halfRange > handler.getDataMax()) {
            midpoint = handler.getDataMax() - halfRange;
        }
        this.blockLayoutEquated = true;
        handler.setViewport(midpoint - halfRange, midpoint + halfRange);
        this.blockLayoutEquated = false;
    }

    private boolean isRangeSliderSupported(int axis) {
        boolean rc = true;
        Axes a = null;
        if (axis == 0 && this.xAxis != null) {
            a = (Axes)this.xAxis.getInternalAxis();
        } else if (axis == 1 && this.yAxis != null) {
            a = (Axes)this.yAxis.getInternalAxis();
        }
        if (a != null) {
            if (a.getTransformType() != 1 || a.isDiscrete()) {
                rc = false;
            }
        } else {
            rc = false;
        }
        return rc;
    }

    @Override
    public AxisInterface getAxis(Object which) {
        if (which == null) {
            return null;
        }
        AxisComponent ac = null;
        int axis = -1;
        if (which instanceof Integer) {
            axis = (Integer)which;
        }
        if (which.toString().equalsIgnoreCase("X") || which.equals(RoleInterface.ROLE_X) || which.equals("X") || 0 == axis) {
            ac = this.xAxis;
        }
        if (which.toString().equalsIgnoreCase("Y") || which.equals(RoleInterface.ROLE_Y) || which.equals("Y") || 1 == axis) {
            ac = this.yAxis;
        }
        if (which.toString().equalsIgnoreCase("X2") || which.equals("X2") || 3 == axis) {
            ac = this.x2Axis;
        }
        if (which.toString().equalsIgnoreCase("Y2") || which.equals("Y2") || 4 == axis) {
            ac = this.y2Axis;
        }
        if (ac != null) {
            return ac.getInternalAxis();
        }
        return null;
    }

    @Override
    public boolean setExternalAxis(Object which, AxisInterface axis) {
        if (which == null) {
            return false;
        }
        if (which.toString().equalsIgnoreCase("X")) {
            this.externalXAxis = axis;
        } else if (which.toString().equalsIgnoreCase("X2")) {
            this.externalX2Axis = axis;
        } else if (which.toString().equalsIgnoreCase("Y")) {
            this.externalYAxis = axis;
        } else if (which.toString().equalsIgnoreCase("Y2")) {
            this.externalY2Axis = axis;
        } else {
            return false;
        }
        return true;
    }

    public TransformInterface getTransform(Object whichX, Object whichY) {
        int xIndex = -1;
        int yIndex = -1;
        String xStrg = whichX == null ? null : whichX.toString();
        String yStrg = whichY == null ? null : whichY.toString();
        TransformObject ti = null;
        DataRange xRange = null;
        DataRange yRange = null;
        if (xStrg == null) {
            xIndex = -1;
        } else if (xStrg.equalsIgnoreCase("X")) {
            xIndex = 0;
        } else if (xStrg.equalsIgnoreCase("X2")) {
            xIndex = 1;
        } else {
            return null;
        }
        if (yStrg == null) {
            yIndex = -1;
        } else if (yStrg.equalsIgnoreCase("Y")) {
            yIndex = 0;
        } else if (yStrg.equalsIgnoreCase("Y2")) {
            yIndex = 1;
        } else {
            return null;
        }
        if (xIndex == -1 && yIndex == -1) {
            return null;
        }
        String key = xIndex == -1 ? yStrg.toUpperCase() : (yIndex == -1 ? xStrg.toUpperCase() : xStrg.toUpperCase() + ":" + yStrg.toUpperCase());
        if (this.transforms != null && (ti = (TransformObject)this.transforms.get(key)) != null) {
            if (ti.isValid()) {
                return ti;
            }
            boolean yValidated = false;
            boolean xValidated = false;
            if (xStrg == null) {
                xValidated = true;
            }
            if (yStrg == null) {
                yValidated = true;
            }
            switch (xIndex) {
                case 0: {
                    xRange = this.xAxis == null ? null : this.getOutputRange(this.xAxis, this.xAxisZoomHandler);
                    break;
                }
                case 1: {
                    xRange = this.x2Axis == null ? null : this.getOutputRange(this.x2Axis, this.x2AxisZoomHandler);
                }
            }
            switch (yIndex) {
                case 0: {
                    yRange = this.yAxis == null ? null : this.getOutputRange(this.yAxis, this.yAxisZoomHandler);
                    break;
                }
                case 1: {
                    DataRange dataRange = yRange = this.y2Axis == null ? null : this.getOutputRange(this.y2Axis, this.y2AxisZoomHandler);
                }
            }
            if (xRange != null) {
                ti.setXRange(xRange);
                xValidated = true;
            }
            if (yRange != null) {
                ti.setYRange(yRange);
                yValidated = true;
            }
            ti.setValid(xValidated && yValidated);
            return ti;
        }
        xRange = this.getOutputRange((byte)1, xIndex);
        yRange = this.getOutputRange((byte)2, yIndex);
        ti = new TransformObject(xRange, yRange);
        if (this.transforms != null) {
            this.transforms.put(key, ti);
        }
        return ti;
    }

    protected void drawWall(Graphics2D g) {
        StyleElement se;
        if (this.wall != null) {
            this.wall.drawBackground(g, this, this.dataRegion);
        }
        if ((se = this.style.getStyleElement("WallFill")) != null && se.getBooleanAttribute("frameBorder", false)) {
            Color c = se.getAsLineStyle().getLineColor();
            if (c == null) {
                c = Color.BLACK;
            }
            g.setColor(c);
            g.drawRect(this.dataRegion.x - 1, this.dataRegion.y - 1, this.dataRegion.width + 1, this.dataRegion.height + 1);
        }
    }

    protected void drawBrush(Graphics g) {
        if (this.brush != null) {
            g.setColor(Color.black);
            g.drawRect(this.brush.x, this.brush.y, this.brush.width, this.brush.height);
        }
    }

    protected void drawReferenceLines(AxisInterface axis, Graphics g, int whichAxis) {
        block18: {
            double[] pvals;
            FontRenderContext frc;
            int numReflines;
            block17: {
                if (axis == null) {
                    return;
                }
                numReflines = axis.getNumberReferenceLines();
                frc = null;
                frc = g instanceof Graphics2D ? ((Graphics2D)g).getFontRenderContext() : new FontRenderContext(null, false, false);
                pvals = new double[3];
                if (whichAxis != 0 && whichAxis != 3) break block17;
                for (int i = 0; i < numReflines; ++i) {
                    ReferenceLineInterface line;
                    Object value;
                    TransformInterface ti = null;
                    ti = whichAxis == 0 ? this.getTransform("X", null) : this.getTransform("X2", null);
                    if (ti == null || !((value = (line = axis.getReferenceLine(i)).getValue()) instanceof Number) || Double.isNaN(((Number)value).doubleValue())) continue;
                    ti.project(((Number)value).doubleValue(), 0.0, 0.0, pvals);
                    if (pvals[0] < (double)this.dataRegion.x || pvals[0] > (double)(this.dataRegion.x + this.dataRegion.width)) continue;
                    g.setColor(line.getLine().getColor());
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)line.getLine().getPattern(), (int)line.getLine().getWidth()));
                    }
                    g.drawLine((int)pvals[0], this.dataRegion.y, (int)pvals[0], this.dataRegion.y + this.dataRegion.height - 1);
                    if (line.getLabelString() == null || line.getLabelString().length() <= 0 || !line.getLabel().isVisible()) continue;
                    Font f = SILKUtilities.adjustFontSize(line.getLabel().getFont());
                    TextLayout tl = new TextLayout(line.getLabelString(), f, frc);
                    int x = -1;
                    int y = -1;
                    if (!line.isOutsideLabel()) {
                        y = line.getSameLabelSide() ? this.dataRegion.y + this.dataRegion.height - (int)tl.getBounds().getHeight() - this.graphLayout.INNER_MARGIN : this.dataRegion.y + this.graphLayout.INNER_MARGIN;
                        x = (int)pvals[0] - (int)tl.getBounds().getWidth() - this.graphLayout.INNER_MARGIN;
                        if ((double)x + tl.getBounds().getWidth() > (double)(this.dataRegion.x + this.dataRegion.width)) {
                            x = (int)((double)(this.dataRegion.x + this.dataRegion.width) - tl.getBounds().getWidth());
                        }
                        if (x < this.dataRegion.x) {
                            x = this.dataRegion.x;
                        }
                    } else {
                        y = line.getSameLabelSide() ? this.dataRegion.y + this.dataRegion.height + (int)tl.getBounds().getHeight() + this.graphLayout.INNER_MARGIN : this.dataRegion.y - (int)tl.getBounds().getHeight() - this.graphLayout.INNER_MARGIN;
                        x = (int)pvals[0] - (int)(tl.getBounds().getWidth() / 2.0);
                        if ((double)x + tl.getBounds().getWidth() > (double)(this.dataRegion.x + this.dataRegion.width)) {
                            x = (int)((double)(this.dataRegion.x + this.dataRegion.width) - tl.getBounds().getWidth());
                        }
                        if (x < this.dataRegion.x) {
                            x = this.dataRegion.x;
                        }
                    }
                    if (!(line.getLabel() instanceof Text) || !(g instanceof Graphics2D)) continue;
                    Text t = (Text)line.getLabel();
                    Color c = t.getColor();
                    if (c == null) {
                        c = this.style.getTextStyleElement("ValueText").getTextColor();
                    }
                    g.setColor(c);
                    t.drawText((Graphics2D)g, line.getLabelString(), new Point(x, y));
                }
                break block18;
            }
            if (whichAxis != 1 && whichAxis != 4) break block18;
            for (int i = 0; i < numReflines; ++i) {
                ReferenceLineInterface line;
                Object value;
                TransformInterface ti = null;
                ti = whichAxis == 1 ? this.getTransform(null, "Y") : this.getTransform(null, "Y2");
                if (ti == null || !((value = (line = axis.getReferenceLine(i)).getValue()) instanceof Number) || Double.isNaN(((Number)value).doubleValue())) continue;
                ti.project(0.0, ((Number)value).doubleValue(), 0.0, pvals);
                if (pvals[1] < (double)this.dataRegion.y || pvals[1] > (double)(this.dataRegion.y + this.dataRegion.height)) continue;
                g.setColor(line.getLine().getColor());
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)line.getLine().getPattern(), (int)line.getLine().getWidth()));
                }
                g.drawLine(this.dataRegion.x + 1, (int)pvals[1], this.dataRegion.x + this.dataRegion.width - 1, (int)pvals[1]);
                if (line.getLabelString() == null || line.getLabelString().length() <= 0 || !line.getLabel().isVisible()) continue;
                Font f = SILKUtilities.adjustFontSize(line.getLabel().getFont());
                TextLayout tl = new TextLayout(line.getLabelString(), f, frc);
                int x = -1;
                int y = -1;
                Rectangle2D bounds = tl.getBounds();
                if (!line.isOutsideLabel()) {
                    x = line.getSameLabelSide() ? this.dataRegion.x + this.graphLayout.INNER_MARGIN : this.dataRegion.x + this.dataRegion.width - (int)bounds.getWidth() - this.graphLayout.INNER_MARGIN;
                    y = (int)pvals[1] - (int)bounds.getHeight();
                    if (y < this.dataRegion.y) {
                        y = this.dataRegion.y;
                    }
                } else {
                    x = line.getSameLabelSide() ? this.dataRegion.x - (int)bounds.getWidth() - this.graphLayout.INNER_MARGIN : this.dataRegion.x + this.dataRegion.width + this.graphLayout.INNER_MARGIN;
                    y = (int)pvals[1] - (int)(tl.getBounds().getHeight() / 2.0);
                    if (y < this.dataRegion.y) {
                        y = this.dataRegion.y;
                    }
                }
                if (!(line.getLabel() instanceof Text) || !(g instanceof Graphics2D)) continue;
                Text t = (Text)line.getLabel();
                Color c = t.getColor();
                if (c == null) {
                    c = this.style.getTextStyleElement("ValueText").getTextColor();
                }
                g.setColor(c);
                ((Text)line.getLabel()).drawText((Graphics2D)g, line.getLabelString(), new Point(x, y));
            }
        }
    }

    protected void drawReferenceRanges(Graphics g) {
        int temp1;
        int max;
        int min;
        boolean referenceValue;
        double h;
        double l;
        TransformInterface ti;
        Color c;
        Object high;
        Object low;
        ReferenceRange range;
        int i;
        AxisInterface x = null;
        AxisInterface y = null;
        if (this.xAxis != null && this.externalXAxis == null) {
            x = this.xAxis.getInternalAxis();
        } else if (this.externalXAxis != null) {
            x = this.externalXAxis;
        }
        if (this.yAxis != null && this.externalYAxis == null) {
            y = this.yAxis.getInternalAxis();
        } else if (this.externalYAxis != null) {
            y = this.externalYAxis;
        }
        if (x == null && y == null) {
            return;
        }
        RangeModel xRangeModel = null;
        RangeModel yRangeModel = null;
        if (x != null) {
            xRangeModel = (RangeModel)x.getRangeModel(false);
        }
        if (y != null) {
            yRangeModel = (RangeModel)y.getRangeModel(false);
        }
        if (xRangeModel == null && yRangeModel == null) {
            return;
        }
        Color defaultColor = new Color(255, 255, 0, 128);
        FillStyleElement fse = this.style.getFillStyleElement("RangeFill");
        LineStyleElement reference = this.style.getLineStyleElement("Reference");
        if (fse != null) {
            defaultColor = fse.getFillColor();
        }
        double[] pvals = new double[3];
        double[] pvals1 = new double[3];
        Rectangle oldClip = g.getClipBounds();
        Rectangle customClipRect = new Rectangle(this.clipRect);
        if (this.xAxisZoomHandler != null && !this.xAxisZoomHandler.hasViewport()) {
            customClipRect.x += this.innerMargin.left;
            customClipRect.width -= this.innerMargin.left + this.innerMargin.right;
        }
        g.setClip(customClipRect);
        if (xRangeModel != null) {
            for (i = 0; i < xRangeModel.ranges(); ++i) {
                range = xRangeModel.getRangeAt(i);
                low = range.getLowValue();
                high = range.getHighValue();
                if (!(low instanceof Number) || !(high instanceof Number)) continue;
                c = range.getFillColor();
                if (c == null) {
                    c = defaultColor;
                }
                g.setColor(c);
                ti = this.getTransform("X", null);
                if (ti == null) continue;
                l = ((Number)low).doubleValue();
                referenceValue = l >= (h = ((Number)high).doubleValue());
                ti.project(l, 0.0, 0.0, pvals);
                ti.project(h, 0.0, 0.0, pvals1);
                min = (int)pvals[0];
                max = (int)pvals1[0];
                temp1 = Math.min(min, max);
                max = Math.max(min, max);
                min = temp1;
                int maxValue = (int)Math.pow(2.0, 15.0) - 100;
                int minValue = -maxValue;
                min = Math.max(minValue, Math.min(maxValue, min));
                max = Math.max(minValue, Math.min(maxValue, max));
                if (!referenceValue) {
                    g.fillRect(min, this.dataRegion.y, max - min, this.dataRegion.height);
                }
                int[] yPoints = new int[2];
                yPoints[0] = this.dataRegion.y + this.dataRegion.height;
                yPoints[yPoints.length - 1] = this.dataRegion.y;
                for (int j = 0; j < yPoints.length; j += 2) {
                    LineStyleInterface lsi;
                    if (range.getLowInclusive()) {
                        lsi = range.getLowLine();
                        if (g instanceof Graphics2D) {
                            ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lsi.getWidth(), (int)lsi.getPattern()));
                        }
                        g.setColor(reference.getLineColor());
                        g.drawLine((int)pvals[0], yPoints[j], (int)pvals[0], yPoints[j + 1]);
                    }
                    if (referenceValue || !range.getHighInclusive()) continue;
                    lsi = range.getHighLine();
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lsi.getWidth(), (int)lsi.getPattern()));
                    }
                    g.setColor(reference.getLineColor());
                    g.drawLine((int)pvals1[0], yPoints[j], (int)pvals1[0], yPoints[j + 1]);
                }
            }
        }
        customClipRect.x = this.clipRect.x;
        customClipRect.width = this.clipRect.width;
        if (this.yAxisZoomHandler != null && !this.yAxisZoomHandler.hasViewport()) {
            customClipRect.y += this.innerMargin.top;
            customClipRect.height -= this.innerMargin.top + this.innerMargin.bottom;
        }
        g.setClip(customClipRect);
        if (yRangeModel != null) {
            for (i = 0; i < yRangeModel.ranges(); ++i) {
                range = yRangeModel.getRangeAt(i);
                low = range.getLowValue();
                high = range.getHighValue();
                if (!(low instanceof Number) || !(high instanceof Number)) continue;
                c = range.getFillColor();
                if (c == null) {
                    c = defaultColor;
                }
                if ((ti = this.getTransform(null, "Y")) == null) continue;
                l = ((Number)low).doubleValue();
                referenceValue = l >= (h = ((Number)high).doubleValue());
                ti.project(0.0, l, 0.0, pvals);
                ti.project(0.0, h, 0.0, pvals1);
                min = (int)pvals[1];
                max = (int)pvals1[1];
                temp1 = Math.min(min, max);
                max = Math.max(min, max);
                min = temp1;
                int[] xPoints = new int[2];
                xPoints[0] = this.dataRegion.x;
                xPoints[xPoints.length - 1] = this.dataRegion.x + this.dataRegion.width;
                g.setColor(c);
                if (!referenceValue) {
                    g.fillRect(this.dataRegion.x, min, this.dataRegion.width, max - min);
                }
                for (int j = 0; j < xPoints.length; j += 2) {
                    LineStyleInterface lsi;
                    if (range.getLowInclusive()) {
                        lsi = range.getLowLine();
                        if (g instanceof Graphics2D) {
                            ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lsi.getWidth(), (int)lsi.getPattern()));
                        }
                        g.setColor(reference.getLineColor());
                        g.drawLine(xPoints[j], (int)pvals[1], xPoints[j + 1], (int)pvals[1]);
                    }
                    if (referenceValue || !range.getHighInclusive()) continue;
                    lsi = range.getHighLine();
                    if (g instanceof Graphics2D) {
                        ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lsi.getWidth(), (int)lsi.getPattern()));
                    }
                    g.setColor(reference.getLineColor());
                    g.drawLine(xPoints[j], (int)pvals1[1], xPoints[j + 1], (int)pvals1[1]);
                }
            }
        }
        g.setClip(oldClip);
    }

    protected String getReferenceLineTipText(int screenX, int screenY) {
        Rectangle pickArea = new Rectangle(screenX - 1, screenY - 1, 3, 3);
        String rc = null;
        if (rc == null) {
            if (this.xAxis != null && this.externalXAxis == null) {
                rc = this.getReferenceLineTipText(0, this.xAxis.getInternalAxis(), pickArea);
            } else if (this.externalXAxis != null) {
                rc = this.getReferenceLineTipText(0, this.externalXAxis, pickArea);
            }
        }
        if (rc == null) {
            if (this.x2Axis != null && this.externalX2Axis == null) {
                rc = this.getReferenceLineTipText(3, this.x2Axis.getInternalAxis(), pickArea);
            } else if (this.externalX2Axis != null) {
                rc = this.getReferenceLineTipText(3, this.externalX2Axis, pickArea);
            }
        }
        if (rc == null) {
            if (this.yAxis != null && this.externalYAxis == null) {
                rc = this.getReferenceLineTipText(1, this.yAxis.getInternalAxis(), pickArea);
            } else if (this.externalYAxis != null) {
                rc = this.getReferenceLineTipText(1, this.externalYAxis, pickArea);
            }
        }
        if (rc == null) {
            if (this.y2Axis != null && this.externalY2Axis == null) {
                rc = this.getReferenceLineTipText(4, this.y2Axis.getInternalAxis(), pickArea);
            } else if (this.externalY2Axis != null) {
                rc = this.getReferenceLineTipText(4, this.externalY2Axis, pickArea);
            }
        }
        return rc;
    }

    private String getReferenceLineTipText(int whichAxis, AxisInterface axis, Rectangle pickArea) {
        block3: {
            double[] pvals;
            int numReflines;
            block2: {
                numReflines = axis.getNumberReferenceLines();
                pvals = new double[3];
                if (whichAxis != 0 && whichAxis != 3) break block2;
                for (int i = 0; i < numReflines; ++i) {
                    ReferenceLineInterface line;
                    Object value;
                    TransformInterface ti = null;
                    ti = whichAxis == 0 ? this.getTransform("X", null) : this.getTransform("X2", null);
                    if (ti == null || !((value = (line = axis.getReferenceLine(i)).getValue()) instanceof Number)) continue;
                    ti.project(((Number)value).doubleValue(), 0.0, 0.0, pvals);
                    if (pvals[0] < (double)this.dataRegion.x || pvals[0] > (double)(this.dataRegion.x + this.dataRegion.width) || !pickArea.intersectsLine((int)pvals[0], this.dataRegion.y, (int)pvals[0], this.dataRegion.y + this.dataRegion.height - 1)) continue;
                    return line.getLabelString();
                }
                break block3;
            }
            if (whichAxis != 1 && whichAxis != 4) break block3;
            for (int i = 0; i < numReflines; ++i) {
                ReferenceLineInterface line;
                Object value;
                TransformInterface ti = null;
                ti = whichAxis == 1 ? this.getTransform(null, "Y") : this.getTransform(null, "Y2");
                if (ti == null || !((value = (line = axis.getReferenceLine(i)).getValue()) instanceof Number)) continue;
                ti.project(0.0, ((Number)value).doubleValue(), 0.0, pvals);
                if (pvals[1] < (double)this.dataRegion.y || pvals[1] > (double)(this.dataRegion.y + this.dataRegion.height) || !pickArea.intersectsLine(this.dataRegion.x + 1, (int)pvals[1], this.dataRegion.x + this.dataRegion.width - 1, (int)pvals[1])) continue;
                return line.getLabelString();
            }
        }
        return null;
    }

    protected void drawReferenceLines(Graphics g) {
        if (this.y2Axis != null && this.externalY2Axis == null) {
            this.drawReferenceLines(this.y2Axis.getInternalAxis(), g, 4);
        } else if (this.externalY2Axis != null) {
            this.drawReferenceLines(this.externalY2Axis, g, 4);
        }
        if (this.xAxis != null && this.externalXAxis == null) {
            this.drawReferenceLines(this.xAxis.getInternalAxis(), g, 0);
        } else if (this.externalXAxis != null) {
            this.drawReferenceLines(this.externalXAxis, g, 0);
        }
        if (this.x2Axis != null && this.externalX2Axis == null) {
            this.drawReferenceLines(this.x2Axis.getInternalAxis(), g, 3);
        } else if (this.externalX2Axis != null) {
            this.drawReferenceLines(this.externalX2Axis, g, 3);
        }
        if (this.yAxis != null && this.externalYAxis == null) {
            this.drawReferenceLines(this.yAxis.getInternalAxis(), g, 1);
        } else if (this.externalYAxis != null) {
            this.drawReferenceLines(this.externalYAxis, g, 1);
        }
    }

    protected static DataRange mergeRange(DataRange range1, DataRange range2) {
        return RangeMerger.mergeRange(range1, range2);
    }

    protected boolean isNumericVariable(Object variable) {
        int type = Extract.getSourceType((Object)variable);
        int n = Extract.getNumberItems((Object)variable, (int)type);
        if (this.dataFilter == null) {
            return false;
        }
        if (n == 1 && this.dataFilter.isNumericVariable(variable)) {
            return true;
        }
        if (n > 1) {
            boolean numeric = true;
            for (int i = 0; i < n; ++i) {
                Object o = Extract.getObject((Object)variable, (int)i, (int)type);
                numeric = numeric && this.dataFilter.isNumericVariable(o);
            }
            return numeric;
        }
        return false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return this.addTabs(id, dialogIn, category, this);
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        if (id == null || dialogIn == null) {
            return false;
        }
        if (id.equals("Properties")) {
            if (dialogIn instanceof TabbedPropertiesDialog) {
                Object cht;
                boolean graph = false;
                boolean chart = false;
                boolean legend = false;
                boolean axes = false;
                boolean titles = false;
                switch (category) {
                    case 0: {
                        graph = true;
                        break;
                    }
                    case 1: {
                        chart = true;
                        break;
                    }
                    case 3: {
                        legend = true;
                        break;
                    }
                    case 2: {
                        axes = true;
                        break;
                    }
                    case 4: {
                        titles = true;
                        break;
                    }
                    case 999: {
                        titles = true;
                        axes = true;
                        legend = true;
                        chart = true;
                        graph = true;
                    }
                }
                TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)dialogIn;
                TabPanelInterface tpi = null;
                if (graph) {
                    super.addTabs(id, dialogIn, 0, listener);
                }
                if (chart && (cht = this.getChart(null)) instanceof BaseComponentInterface) {
                    ((BaseComponentInterface)cht).addTabs(id, dialogIn, 1, listener == this ? null : listener);
                }
                SILKXYComponent pi = this;
                if (listener instanceof PropertyInterface) {
                    pi = (PropertyInterface)listener;
                }
                if (axes) {
                    tpi = tpd.getTab(AxisPanel.class);
                    if (tpi != null) {
                        tpi.addPropertyListener(pi);
                    } else {
                        AxisPanel p = new AxisPanel();
                        p.addPropertyListener(pi);
                        tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKXYComponent.Axes.txt", (String)"Axes"), p);
                    }
                }
                if (legend && this.getPropertyValue(24) != null) {
                    tpi = tpd.getTab(LegendPanel.class);
                    if (tpi != null) {
                        tpi.addPropertyListener(pi);
                    } else {
                        tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKXYComponent.Legend.txt", (String)"Legend"), new LegendPanel(pi));
                    }
                }
                if (titles) {
                    super.addTabs(id, dialogIn, 4, listener);
                }
            } else if (dialogIn instanceof GraphPropertiesDialog) {
                Object cht;
                boolean graph = false;
                boolean chart = false;
                boolean legend = false;
                boolean axes = false;
                boolean titles = false;
                switch (category) {
                    case 0: {
                        graph = true;
                        break;
                    }
                    case 1: {
                        chart = true;
                        break;
                    }
                    case 3: {
                        legend = true;
                        break;
                    }
                    case 2: {
                        axes = true;
                        break;
                    }
                    case 4: {
                        titles = true;
                        break;
                    }
                    case 999: {
                        titles = true;
                        axes = true;
                        legend = true;
                        chart = true;
                        graph = true;
                    }
                }
                GraphPropertiesDialog gpd = (GraphPropertiesDialog)dialogIn;
                if (graph) {
                    super.addTabs(id, dialogIn, 0, listener);
                }
                if (chart && (cht = this.getChart(null)) instanceof BaseComponentInterface) {
                    ((BaseComponentInterface)cht).addTabs(id, dialogIn, 1, listener == this ? null : listener);
                }
                if (axes) {
                    gpd.updateAxesPanels(this, listener);
                }
                if (legend && this.getPropertyValue(24) != null) {
                    this.propertiesDialog.updateLegendPanels(this, listener);
                }
                if (titles) {
                    super.addTabs(id, dialogIn, 4, listener);
                }
            }
        }
        return false;
    }

    @Override
    public boolean resetComponent() {
        this.resetViewport();
        return super.resetComponent();
    }

    @Override
    public boolean setActionMode(int mode) {
        this.brush = null;
        boolean rc = super.setActionMode(mode);
        this.pallet.updateState(this);
        return rc;
    }

    protected void resetTransformTypes(RoleEvent r) {
        this.blockPropertyEvent = true;
        if (this.isAxisRole(new Integer(r.role), "X")) {
            TransformInterface t;
            if (this.xAxis != null) {
                this.xAxis.setTransformType(1, null);
            }
            if ((t = this.getTransform("X", null)) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(0, 1, null);
            }
            if ((t = this.getTransform("X", "Y")) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(0, 1, null);
            }
            if ((t = this.getTransform("X", "Y2")) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(0, 1, null);
            }
        } else if (this.isAxisRole(new Integer(r.role), "X2")) {
            TransformInterface t;
            if (this.x2Axis != null) {
                this.x2Axis.setTransformType(1, null);
            }
            if ((t = this.getTransform("X2", null)) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(3, 1, null);
            }
            if ((t = this.getTransform("X2", "Y")) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(3, 1, null);
            }
            if ((t = this.getTransform("X2", "Y2")) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(3, 1, null);
            }
        } else if (this.isAxisRole(new Integer(r.role), "Y")) {
            TransformInterface t;
            if (this.yAxis != null) {
                this.yAxis.setTransformType(1, null);
            }
            if ((t = this.getTransform(null, "Y")) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(1, 1, null);
            }
            if ((t = this.getTransform("X", "Y")) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(1, 1, null);
            }
            if ((t = this.getTransform("X2", "Y")) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(1, 1, null);
            }
        } else if (this.isAxisRole(new Integer(r.role), "Y2")) {
            TransformInterface t;
            if (this.y2Axis != null) {
                this.y2Axis.setTransformType(1, null);
            }
            if ((t = this.getTransform(null, "Y2")) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(4, 1, null);
            }
            if ((t = this.getTransform("X", "Y2")) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(4, 1, null);
            }
            if ((t = this.getTransform("X2", "Y2")) instanceof TransformObject) {
                ((TransformObject)t).setTransformType(4, 1, null);
            }
        }
        this.blockPropertyEvent = false;
    }

    private double[] getAdjustedRange(byte dim, int index, int screenStart, int screenSize, int startOffset, int endOffset, double[] vals) {
        if (vals == null || vals.length < 4) {
            vals = new double[4];
        }
        AxisZoomPanHandler handler = this.getZoomPanHandler(dim, index);
        DataRange r = this.getOutputRange(dim, index);
        AxisComponent axis = this.getAxis(dim, index);
        if (axis != null && ((Axes)axis.getInternalAxis()).isDiscrete()) {
            vals[2] = screenStart;
            vals[3] = screenSize;
        } else {
            vals[2] = screenStart + startOffset;
            vals[3] = screenSize - endOffset - startOffset;
        }
        if (handler == null) {
            vals[3] = Double.NaN;
            vals[2] = Double.NaN;
            vals[1] = Double.NaN;
            vals[0] = Double.NaN;
        } else if (handler.hasViewport()) {
            vals[0] = handler.getViewportMin();
            vals[1] = handler.getViewportMax();
        } else if (r instanceof ContinuousRange) {
            vals[0] = ((ContinuousRange)r).getMin();
            vals[1] = ((ContinuousRange)r).getMax();
            handler.setDataRange(vals[0], vals[1]);
            handler.setMinimumViewportRange(0.001);
        } else if (r != null) {
            double min = 0.0;
            double max = ((DiscreteRange)r).getValuesSize() - 1;
            double d1 = max - min;
            double s1 = screenSize - startOffset - endOffset;
            double s2 = screenSize;
            double d2 = d1 == 0.0 ? 0.0 : s2 / s1 * d1;
            double d3 = d2 - d1;
            vals[0] = min - d3 / 2.0;
            vals[1] = max + d3 / 2.0;
            handler.setDataRange(vals[0], vals[1]);
            handler.setMinimumViewportRange(1.0);
        }
        return vals;
    }

    private void adjustTransform(TransformObject to, int xindex, int yindex) {
        double[] vals = new double[4];
        vals = this.getAdjustedRange((byte)1, xindex, this.dataRegion.x, this.dataRegion.width, this.innerMargin.left, this.innerMargin.right, vals);
        int xscreen = (int)vals[2];
        int width = (int)vals[3];
        double xmin = vals[0];
        double xmax = vals[1];
        int top = this.innerMargin.top;
        vals = this.getAdjustedRange((byte)2, yindex, this.dataRegion.y, this.dataRegion.height, top, this.innerMargin.bottom, vals);
        int yscreen = (int)vals[2];
        int height = (int)vals[3];
        double ymin = vals[0];
        double ymax = vals[1];
        to.setScreenBounds(xscreen, yscreen, width, height);
        to.setXRange(xmin, xmax);
        to.setYRange(ymin, ymax);
    }

    public void setupTransforms() {
        if (this.dataRegion.width < 0 || this.dataRegion.height < 0) {
            return;
        }
        TransformInterface t = this.getTransform("X", null);
        if (t instanceof TransformObject) {
            this.adjustTransform((TransformObject)t, 0, -1);
        }
        if ((t = this.getTransform("X2", null)) instanceof TransformObject) {
            this.adjustTransform((TransformObject)t, 1, -1);
        }
        if ((t = this.getTransform(null, "Y")) instanceof TransformObject) {
            this.adjustTransform((TransformObject)t, -1, 0);
        }
        if ((t = this.getTransform(null, "Y2")) instanceof TransformObject) {
            this.adjustTransform((TransformObject)t, -1, 1);
        }
        if ((t = this.getTransform("X", "Y")) instanceof TransformObject) {
            this.adjustTransform((TransformObject)t, 0, 0);
        }
        if ((t = this.getTransform("X", "Y2")) instanceof TransformObject) {
            this.adjustTransform((TransformObject)t, 0, 1);
        }
        if ((t = this.getTransform("X2", "Y")) instanceof TransformObject) {
            this.adjustTransform((TransformObject)t, 1, 0);
        }
        if ((t = this.getTransform("X2", "Y2")) instanceof TransformObject) {
            this.adjustTransform((TransformObject)t, 1, 1);
        }
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        if (selectRegion instanceof Rectangle) {
            this.doPicking((Rectangle)selectRegion, event);
        }
        return true;
    }

    public void drawSelections(Graphics g) {
    }

    public boolean getAxesVisible() {
        boolean xOn = false;
        boolean yOn = false;
        boolean x2On = false;
        boolean y2On = false;
        if (this.xAxis != null) {
            xOn = ((Axes)this.xAxis.getInternalAxis()).isVisible();
        }
        if (this.yAxis != null) {
            yOn = ((Axes)this.yAxis.getInternalAxis()).isVisible();
        }
        if (this.x2Axis != null) {
            x2On = ((Axes)this.x2Axis.getInternalAxis()).isVisible();
        }
        if (this.y2Axis != null) {
            y2On = ((Axes)this.y2Axis.getInternalAxis()).isVisible();
        }
        return xOn || yOn || x2On || y2On;
    }

    public int getNumRanges(byte dim) {
        return 1;
    }

    public DataRangeInterface getRangeSource(byte dim, int index) {
        Object rc = this;
        switch (index) {
            case 0: {
                rc = this.primaryDataRange;
                break;
            }
            case 1: {
                rc = this.secondaryDataRange;
            }
        }
        return rc;
    }

    public void setAxesVisible(boolean axesVisible) {
        if (this.xAxis != null) {
            this.xAxis.setVisible(axesVisible);
        }
        if (this.yAxis != null) {
            this.yAxis.setVisible(axesVisible);
        }
        if (this.x2Axis != null) {
            this.x2Axis.setVisible(axesVisible);
        }
        if (this.y2Axis != null) {
            this.y2Axis.setVisible(axesVisible);
        }
        this.allAxesVisible = axesVisible;
    }

    private ContinuousRange computeUserRange(AxisComponent axis, ContinuousRange range) {
        if (range == null || axis == null) {
            return null;
        }
        double min = range.getMin();
        double max = range.getMax();
        if (axis.hasUserSetMin()) {
            min = axis.getUserSetMin();
        }
        if (axis.hasUserSetMax()) {
            max = axis.getUserSetMax();
        }
        return new ContinuousRange(min, max);
    }

    protected AxisComponent getAxis(byte dim, int index) {
        AxisComponent ac = null;
        switch (dim) {
            case 1: {
                ac = index == 0 ? this.xAxis : this.x2Axis;
                break;
            }
            case 2: {
                ac = index == 0 ? this.yAxis : this.y2Axis;
            }
        }
        return ac;
    }

    protected AxisZoomPanHandler getZoomPanHandler(byte dim, int index) {
        AxisZoomPanHandler rc = null;
        switch (dim) {
            case 1: {
                rc = index == 0 ? this.xAxisZoomHandler : this.x2AxisZoomHandler;
                break;
            }
            case 2: {
                rc = index == 0 ? this.yAxisZoomHandler : this.y2AxisZoomHandler;
            }
        }
        return rc;
    }

    protected DataRange computeAxisRange(DataRange range, byte dim, int index) {
        if (!(range instanceof ContinuousRange)) {
            return range;
        }
        AxisComponent axis = this.getAxis(dim, index);
        AxisZoomPanHandler handler = this.getZoomPanHandler(dim, index);
        if (handler != null && handler.hasViewport()) {
            return range;
        }
        if (axis == null) {
            return range;
        }
        if (!axis.hasUserSetMin() || !axis.hasUserSetMax()) {
            return range;
        }
        return new ContinuousRange(axis.getUserSetMin(), axis.getUserSetMax());
    }

    protected DataRange getMergedRange(byte dim, int index) {
        DataRange rc = null;
        if (dim == 1) {
            rc = index == 0 ? this.xMergedRange : this.x2MergedRange;
        } else if (dim == 2) {
            rc = index == 0 ? this.yMergedRange : this.y2MergedRange;
        }
        return rc;
    }

    public void setRange(byte dim, int index, DataRange range) {
        DataRange dataRange = this.getRangeSource(dim, index).getDataRange(dim);
        DataRange mergedRange = this.getMergedRange(dim, index);
        if (dataRange == null || range == null || mergedRange != null && mergedRange.equals((Object)range)) {
            return;
        }
        this.withinSetRange = true;
        if (dim == 1) {
            if (index == 0) {
                this.xMergedRange = range;
            } else if (index == 1) {
                this.x2MergedRange = range;
            }
        } else if (dim == 2) {
            if (index == 0) {
                this.yMergedRange = range;
            } else if (index == 1) {
                this.y2MergedRange = range;
            }
        }
        if (range == null) {
            if (dim == 1) {
                if (index == 0) {
                    range = this.getAxisRange(0);
                } else if (index == 1) {
                    range = this.getAxisRange(3);
                }
            } else if (dim == 2) {
                if (index == 0) {
                    range = this.getAxisRange(1);
                } else if (index == 1) {
                    range = this.getAxisRange(4);
                }
            }
        }
        this.setInternalRange(dim, index, range);
        this.withinSetRange = false;
        this.buildAndDraw(Boolean.TRUE, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setInternalRange(byte dim, int index, DataRange range) {
        range = this.computeAxisRange(range, dim, index);
        String whichAxis = "";
        AxisComponent ac = null;
        AxisZoomPanHandler handler = null;
        switch (index) {
            case 0: {
                switch (dim) {
                    case 1: {
                        if (this.xAxis == null && range != null) {
                            this.getAxisComponent("X");
                        }
                        if (this.xAxis == null) break;
                        ac = this.xAxis;
                        handler = this.xAxisZoomHandler;
                        this.hasXAxis = true;
                        whichAxis = "X";
                        break;
                    }
                    case 2: {
                        if (this.yAxis == null && range != null) {
                            this.getAxisComponent("Y");
                        }
                        if (this.yAxis == null) break;
                        ac = this.yAxis;
                        handler = this.yAxisZoomHandler;
                        this.hasYAxis = true;
                        whichAxis = "Y";
                        break;
                    }
                }
                break;
            }
            case 1: {
                switch (dim) {
                    case 1: {
                        if (this.x2Axis == null && range != null) {
                            this.getAxisComponent("X2");
                        }
                        if (this.x2Axis == null) break;
                        ac = this.x2Axis;
                        handler = this.x2AxisZoomHandler;
                        this.hasX2Axis = true;
                        whichAxis = "X2";
                        break;
                    }
                    case 2: {
                        if (this.y2Axis != null && range != null) {
                            this.getAxisComponent("Y2");
                        }
                        if (this.y2Axis == null) break;
                        ac = this.y2Axis;
                        handler = this.y2AxisZoomHandler;
                        this.hasY2Axis = true;
                        whichAxis = "Y2";
                    }
                }
                break;
            }
        }
        if (ac != null && handler != null) {
            if (!handler.hasViewport() && (ac.hasUserSetMin() || ac.hasUserSetMax()) && range instanceof ContinuousRange) {
                range = this.computeUserRange(ac, (ContinuousRange)range);
            }
            int zoomStatus = -1;
            if (this.zoomingAxisHandler != null) {
                zoomStatus = this.zoomingAxisHandler.getCurrentZoomPanStatus();
            }
            ac.setZooming(!this.inResetViewport && (this.inViewport || this.zoomingAxisHandler != null && (zoomStatus == 1 || zoomStatus == 2)));
            ac.setPanning(!this.inResetViewport && (this.isPanning || this.zoomingAxisHandler != null && zoomStatus == 0));
            switch (dim) {
                case 1: {
                    ac.setAutoCalculate(!ac.isPanning() && this.shouldAutocalculateXAxis);
                    break;
                }
                case 2: {
                    ac.setAutoCalculate(!ac.isPanning() && this.shouldAutocalculateYAxis);
                    break;
                }
            }
            ac.setRange(range);
            if (!handler.hasViewport()) {
                ac.setFullDataRange(range);
                handler.setDataRange(range);
            }
            this.setRangeSliderCalculation(ac);
            this.invalidateTransforms(whichAxis);
        }
    }

    protected void invalidateTransforms(String axis) {
        TransformObject ti = null;
        if ("X".equalsIgnoreCase(axis) || "ALL".equalsIgnoreCase(axis)) {
            ti = (TransformObject)this.transforms.get("X:Y");
            if (ti != null) {
                ti.setValid(false);
            }
            if ((ti = (TransformObject)this.transforms.get("X:Y2")) != null) {
                ti.setValid(false);
            }
            if ((ti = (TransformObject)this.transforms.get("X")) != null) {
                ti.setValid(false);
            }
        }
        if ("Y".equalsIgnoreCase(axis) || "ALL".equalsIgnoreCase(axis)) {
            ti = (TransformObject)this.transforms.get("X:Y");
            if (ti != null) {
                ti.setValid(false);
            }
            if ((ti = (TransformObject)this.transforms.get("X2:Y")) != null) {
                ti.setValid(false);
            }
            if ((ti = (TransformObject)this.transforms.get("Y")) != null) {
                ti.setValid(false);
            }
        }
        if ("X2".equalsIgnoreCase(axis) || "ALL".equalsIgnoreCase(axis)) {
            ti = (TransformObject)this.transforms.get("X2:Y");
            if (ti != null) {
                ti.setValid(false);
            }
            if ((ti = (TransformObject)this.transforms.get("X2:Y2")) != null) {
                ti.setValid(false);
            }
            if ((ti = (TransformObject)this.transforms.get("X2")) != null) {
                ti.setValid(false);
            }
        }
        if ("Y2".equalsIgnoreCase(axis) || "ALL".equalsIgnoreCase(axis)) {
            ti = (TransformObject)this.transforms.get("X:Y2");
            if (ti != null) {
                ti.setValid(false);
            }
            if ((ti = (TransformObject)this.transforms.get("X2:Y2")) != null) {
                ti.setValid(false);
            }
            if ((ti = (TransformObject)this.transforms.get("Y2")) != null) {
                ti.setValid(false);
            }
        }
    }

    public boolean getMarginsAligned() {
        return true;
    }

    protected Insets getPreferredChartInnerMargin() {
        return this.getInnerMargin();
    }

    public void disableMarginPrefCalc() {
    }

    public void enableMarginPrefCalc() {
    }

    public Insets getInnerMargin() {
        return this.innerMargin;
    }

    public Insets getOuterMargin() {
        return this.outerMargin;
    }

    public Insets getPreferredInnerMargin() {
        return this.prefInnerMargin;
    }

    public Insets getPreferredOuterMargin() {
        return this.prefOuterMargin;
    }

    public void setInnerMargin(Insets margin) {
        boolean buildReq = false;
        if (this.innerMargin == null && margin != null || this.innerMargin != null && !this.innerMargin.equals(margin)) {
            buildReq = true;
        }
        this.innerMarginSet = true;
        this.innerMargin = margin;
        if (buildReq) {
            this.buildAndDraw(null, null, null);
        }
    }

    public void setOuterMargin(Insets margin) {
        boolean buildReq = false;
        if (this.outerMargin == null && margin != null || this.outerMargin != null && !this.outerMargin.equals(margin)) {
            buildReq = true;
        }
        this.outerMargin = margin != null ? new Insets(margin.top, margin.left, margin.bottom, margin.right) : margin;
        this.outerMarginSet = true;
        if (buildReq) {
            this.buildAndDraw(null, null, null);
        }
    }

    public void addMarginListener(MarginListener listener) {
        if (listener != null) {
            this.marginChangeListeners.addElement(listener);
        }
    }

    public void removeMarginListener(MarginListener listener) {
        if (listener != null) {
            this.marginChangeListeners.remove(listener);
        }
    }

    protected void fireMarginChanged(MarginChangeEvent event) {
        if (this.marginChangeListeners == null) {
            return;
        }
        Enumeration e = this.marginChangeListeners.elements();
        while (e.hasMoreElements()) {
            ((MarginListener)e.nextElement()).marginChanged(event);
        }
    }

    public DataRange getDataRange(byte dimension) {
        DataRange rc = null;
        switch (dimension) {
            case 1: {
                rc = this.getAxisRange(0);
                break;
            }
            case 2: {
                rc = this.getAxisRange(1);
            }
        }
        return rc;
    }

    public void addRangeChangeListener(RangeChangeListener l) {
        if (this.rangeChangeListeners == null) {
            this.rangeChangeListeners = new Vector();
        }
        if (l != null) {
            this.rangeChangeListeners.addElement(l);
        }
    }

    public void removeRangeChangeListener(RangeChangeListener l) {
        if (this.rangeChangeListeners != null) {
            this.rangeChangeListeners.removeElement(l);
        }
    }

    protected void fireRangeChangeEvent(RangeChangedEvent evt) {
        if (this.withinSetRange) {
            return;
        }
        byte index = evt.getType();
        switch (evt.getDimension()) {
            case 1: {
                if (index == 0) {
                    this.xMergedRange = null;
                    break;
                }
                this.x2MergedRange = null;
                break;
            }
            case 2: {
                if (index == 0) {
                    this.yMergedRange = null;
                    break;
                }
                this.y2MergedRange = null;
            }
        }
        if (this.rangeChangeListeners == null) {
            return;
        }
        Enumeration e = this.rangeChangeListeners.elements();
        while (e.hasMoreElements()) {
            ((RangeChangeListener)e.nextElement()).rangeChanged(evt);
        }
    }

    protected boolean isAxisRole(Object role, String type) {
        Object[] y2AxisRoles;
        Object[] x2AxisRoles;
        Object[] yAxisRoles;
        int i;
        Object[] xAxisRoles;
        ArrayList<Object> arrays = new ArrayList<Object>();
        if ((type.equalsIgnoreCase("ANY") || type.equalsIgnoreCase("X")) && (xAxisRoles = this.getXAxisRoles()) != null) {
            for (i = 0; i < xAxisRoles.length; ++i) {
                arrays.add(xAxisRoles[i]);
            }
        }
        if ((type.equalsIgnoreCase("ANY") || type.equalsIgnoreCase("Y")) && (yAxisRoles = this.getYAxisRoles()) != null) {
            for (i = 0; i < yAxisRoles.length; ++i) {
                arrays.add(yAxisRoles[i]);
            }
        }
        if ((type.equalsIgnoreCase("ANY") || type.equalsIgnoreCase("X2")) && (x2AxisRoles = this.getX2AxisRoles()) != null) {
            for (i = 0; i < x2AxisRoles.length; ++i) {
                arrays.add(x2AxisRoles[i]);
            }
        }
        if ((type.equalsIgnoreCase("ANY") || type.equalsIgnoreCase("Y2")) && (y2AxisRoles = this.getY2AxisRoles()) != null) {
            for (i = 0; i < y2AxisRoles.length; ++i) {
                arrays.add(y2AxisRoles[i]);
            }
        }
        for (int i2 = 0; i2 < arrays.size(); ++i2) {
            Object r = arrays.get(i2);
            if (r == null || !r.equals(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void roleChanged(RoleEvent event) {
        super.roleChanged(event);
        if (event.type != 5 && event.type != 4) {
            boolean outerChanged;
            this.resetTransformTypes(event);
            if (this.isAxisRole(new Integer(event.role), "ANY")) {
                this.resetViewport();
            }
            this.buildAndDraw(Boolean.TRUE, null, null);
            this.layoutChart();
            boolean innerChanged = !this.prefInnerMargin.equals(this.innerMargin);
            boolean bl = outerChanged = !this.prefOuterMargin.equals(this.outerMargin);
            if ((innerChanged || outerChanged) && this.propogateMarginEvents) {
                MarginChangeEvent e2 = new MarginChangeEvent((Object)this);
                e2.setInnerChanged(innerChanged);
                e2.setOuterChanged(outerChanged);
                this.fireMarginChanged(e2);
            }
        }
    }

    protected Object[] getXAxisRoles() {
        return new Object[]{RoleInterface.ROLE_X};
    }

    protected Object[] getYAxisRoles() {
        return new Object[]{RoleInterface.ROLE_Y};
    }

    protected Object[] getX2AxisRoles() {
        return null;
    }

    protected Object[] getY2AxisRoles() {
        return null;
    }

    protected DataRange getAxisRange(int axis) {
        DataRange rc = null;
        switch (axis) {
            case 0: {
                rc = this.getRange(this.getXAxisRoles());
                break;
            }
            case 3: {
                rc = this.getRange(this.getX2AxisRoles());
                break;
            }
            case 1: {
                rc = this.getRange(this.getYAxisRoles());
                break;
            }
            case 4: {
                rc = this.getRange(this.getY2AxisRoles());
            }
        }
        return rc;
    }

    protected DataRange getRange(Object which) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        if (which == null || this.dataFilter == null) {
            return null;
        }
        DiscreteRange rc = null;
        Object variables = null;
        variables = which.equals("X") || which.equals(RoleInterface.ROLE_X) ? this.getAllVariables(RoleInterface.ROLE_X) : (which.equals("Y") || which.equals(RoleInterface.ROLE_Y) ? this.getAllVariables(RoleInterface.ROLE_Y) : (which.toString().equalsIgnoreCase("Color") || which.equals(RoleInterface.ROLE_COLOR) ? this.getAllVariables(RoleInterface.ROLE_COLOR) : this.getAllVariables(which)));
        if (variables == null) {
            Object o = this.getRoleValue(which, 0);
            if (o != null && o instanceof Number) {
                min = ((Number)o).doubleValue();
            }
            if ((o = this.getRoleValue(which, 1)) != null && o instanceof Number) {
                max = ((Number)o).doubleValue();
            }
            if (Double.isNaN(min) || Double.isNaN(max) || min == Double.MAX_VALUE || max == Double.MIN_VALUE) {
                return null;
            }
            return new ContinuousRange(min, max);
        }
        Enumeration e = Extract.elements((Object)variables);
        DataFilterReadInterface filter = this.dataFilter;
        while (e.hasMoreElements()) {
            Object chart;
            Object variable = e.nextElement();
            min = Double.MAX_VALUE;
            max = Double.MIN_VALUE;
            if (variable == null) continue;
            if (RoleManager.isTwoLevelName(variable.toString()) && (chart = this.getChart(RoleManager.getDataIdFromTwoLevelName(variable.toString()))) instanceof ComponentInterface) {
                filter = ((ComponentInterface)chart).getFilter();
            }
            if (this.isNumericVariable(RoleManager.getVariableIdFromTwoLevelName(variable.toString()))) {
                Object o = this.getRoleValue(which, 0);
                if (o != null && o instanceof Number) {
                    min = ((Number)o).doubleValue();
                }
                if ((o = this.getRoleValue(which, 1)) != null && o instanceof Number) {
                    max = ((Number)o).doubleValue();
                }
                if (min > max && filter instanceof DataFilterInfoInterface) {
                    Object obj = ((DataFilterInfoInterface)filter).getMinimumValue((Object)RoleManager.getVariableIdFromTwoLevelName(variable.toString()));
                    if (obj instanceof Number) {
                        min = ((Number)obj).doubleValue();
                    }
                    if ((obj = ((DataFilterInfoInterface)filter).getMaximumValue((Object)RoleManager.getVariableIdFromTwoLevelName(variable.toString()))) instanceof Number) {
                        max = ((Number)obj).doubleValue();
                    }
                    if (max < min) {
                        for (int i = 0; i < filter.getNumberObservations((Object)RoleManager.getVariableIdFromTwoLevelName(variable.toString())); ++i) {
                            double d = filter.getNumericValue((Object)RoleManager.getVariableIdFromTwoLevelName(variable.toString()), (long)i);
                            if (d < min) {
                                min = d;
                            }
                            if (!(d > max)) continue;
                            max = d;
                        }
                    }
                }
                if (rc == null) {
                    rc = new ContinuousRange(min, max);
                    continue;
                }
                if (!(rc instanceof ContinuousRange)) continue;
                ((ContinuousRange)rc).setMax(Math.max(max, ((ContinuousRange)rc).getMax()));
                ((ContinuousRange)rc).setMin(Math.min(min, ((ContinuousRange)rc).getMin()));
                continue;
            }
            Object[] vals = null;
            if (filter instanceof DataFilterInfoInterface) {
                vals = ((DataFilterInfoInterface)filter).getUniqueValues((Object)RoleManager.getVariableIdFromTwoLevelName(variable.toString()), true);
            } else {
                UniqueValueMapper mapper = new UniqueValueMapper();
                for (int i = 0; i < filter.getNumberObservations((Object)RoleManager.getVariableIdFromTwoLevelName(variable.toString())); ++i) {
                    mapper.addValue(filter.getValue((Object)RoleManager.getVariableIdFromTwoLevelName(variable.toString()), (long)i));
                }
                vals = mapper.getValues(0);
            }
            if (rc == null) {
                rc = new DiscreteRange(vals);
                continue;
            }
            if (!(rc instanceof DiscreteRange)) continue;
            rc.union((DataRange)new DiscreteRange(vals));
        }
        return rc;
    }

    @Override
    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (this.style == null) {
            return rc;
        }
        if (!this.userSetProperties.get(27)) {
            this.wall.setSolidBackground(this.style.getFillStyleElement("WallFill").getFillColor());
        }
        if (this.xAxis != null) {
            this.xAxis.setStyle(this.style);
            this.xAxis.setSolidBackground(null);
        }
        if (this.yAxis != null) {
            this.yAxis.setStyle(this.style);
            this.yAxis.setSolidBackground(null);
        }
        if (this.x2Axis != null) {
            this.x2Axis.setStyle(this.style);
            this.x2Axis.setSolidBackground(null);
        }
        if (this.y2Axis != null) {
            this.y2Axis.setStyle(this.style);
            this.y2Axis.setSolidBackground(null);
        }
        if (this.xAxisZoomHandler != null) {
            this.xAxisZoomHandler.setStyle(this.style);
        }
        if (this.yAxisZoomHandler != null) {
            this.yAxisZoomHandler.setStyle(this.style);
        }
        if (this.x2AxisZoomHandler != null) {
            this.x2AxisZoomHandler.setStyle(this.style);
        }
        if (this.y2AxisZoomHandler != null) {
            this.y2AxisZoomHandler.setStyle(this.style);
        }
        return rc;
    }

    protected void doZoom(double xZoom, double yZoom) {
        double xlen = 0.0;
        double ylen = 0.0;
        double x2len = 0.0;
        double y2len = 0.0;
        double limit = 1.0E-4;
        double zoom = xZoom;
        if (Double.isNaN(zoom)) {
            return;
        }
        if (this.silkDefaults != null) {
            limit = this.silkDefaults.zoomLimitParm;
        }
        this.inViewport = true;
        double minX = this.getXMin(false);
        double minY = this.getYMin(false);
        double maxX = this.getXMax(false);
        double maxY = this.getYMax(false);
        double minX2 = this.getX2Min(false);
        double minY2 = this.getY2Min(false);
        double maxX2 = this.getX2Max(false);
        double maxY2 = this.getY2Max(false);
        double fullMinX = this.getXMin(true);
        double fullMinY = this.getYMin(true);
        double fullMaxX = this.getXMax(true);
        double fullMaxY = this.getYMax(true);
        double fullMinX2 = this.getX2Min(true);
        double fullMinY2 = this.getY2Min(true);
        double fullMaxX2 = this.getX2Max(true);
        double fullMaxY2 = this.getY2Max(true);
        double fullLenX = fullMaxX - fullMinX;
        double fullLenY = fullMaxY - fullMinY;
        double fullLenX2 = fullMaxX2 - fullMinX2;
        double fullLenY2 = fullMaxY2 - fullMinY2;
        if (!Double.isNaN(zoom)) {
            xlen = (fullMaxX - fullMinX) * zoom;
            x2len = (fullMaxX2 - fullMinX2) * zoom;
            ylen = (fullMaxY - fullMinY) * zoom;
            y2len = (fullMaxY2 - fullMinY2) * zoom;
        }
        double newMinX = Math.max(minX + xlen / 2.0, fullMinX);
        double newMinY = Math.max(minY + ylen / 2.0, fullMinY);
        double newMaxX = Math.min(maxX - xlen / 2.0, fullMaxX);
        double newMaxY = Math.min(maxY - ylen / 2.0, fullMaxY);
        double newMinX2 = Math.max(minX2 + x2len / 2.0, fullMinX2);
        double newMinY2 = Math.max(minY2 + y2len / 2.0, fullMinY2);
        double newMaxX2 = Math.min(maxX2 - x2len / 2.0, fullMaxX2);
        double newMaxY2 = Math.min(maxY2 - y2len / 2.0, fullMaxY2);
        newMinX = Math.min(newMinX, fullMinX + fullLenX / 2.0 - fullLenX * limit);
        newMinY = Math.min(newMinY, fullMinY + fullLenY / 2.0 - fullLenY * limit);
        newMaxX = Math.max(newMaxX, fullMaxX - fullLenX / 2.0 + fullLenX * limit);
        newMaxY = Math.max(newMaxY, fullMaxY - fullLenY / 2.0 + fullLenY * limit);
        newMinX2 = Math.min(newMinX2, fullMinX2 + fullLenX2 / 2.0 - fullLenX2 * limit);
        newMinY2 = Math.min(newMinY2, fullMinY2 + fullLenY2 / 2.0 - fullLenY2 * limit);
        newMaxX2 = Math.max(newMaxX2, fullMaxX2 - fullLenX2 / 2.0 + fullLenX2 * limit);
        newMaxY2 = Math.max(newMaxY2, fullMaxY2 - fullLenY2 / 2.0 + fullLenY2 * limit);
        if (this.xAxisZoomHandler != null) {
            this.xAxisZoomHandler.setViewport(newMinX, newMaxX);
        }
        if (this.yAxisZoomHandler != null) {
            this.yAxisZoomHandler.setViewport(newMinY, newMaxY);
        }
        if (this.x2AxisZoomHandler != null) {
            this.x2AxisZoomHandler.setViewport(newMinX2, newMaxX2);
        }
        if (this.y2AxisZoomHandler != null) {
            this.y2AxisZoomHandler.setViewport(newMinY2, newMaxY2);
        }
        this.inViewport = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (e.getSource() instanceof RangeSlider) {
            this.handleRangeSliderMouseEvent(e);
            return;
        }
        if (this.zoomingAxisHandler != null && this.zoomPanHandlersEnabled) {
            this.zoomingAxisHandler.mouseDragged(e);
            return;
        }
        int am = this.actionMode;
        if (am == 2) {
            if (e.isShiftDown()) {
                am = 3;
            } else if (e.isControlDown()) {
                am = 4;
            }
        }
        if ((am == 1 || am == 6) && e.isShiftDown()) {
            am = 4;
        }
        switch (am) {
            case 3: {
                double x = e.getX();
                double y = e.getY();
                double xdiff = (x - this.lastMouseLoc.getX()) / (double)this.compWidth;
                double ydiff = (this.lastMouseLoc.getY() - y) / (double)this.compHeight;
                this.doZoom(xdiff, ydiff);
                this.buildAndDraw(new Boolean(true), null, null);
                break;
            }
            case 2: {
                if (!this.mouseDownInChart) break;
                this.rubberbandRect.stretch(e.getPoint());
                this.brush = this.rubberbandRect.bounds();
                break;
            }
            case 6: {
                this.rubberbandRect.stretch(e.getPoint());
                this.brush = this.rubberbandRect.bounds();
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                double xdiff;
                double screenRange;
                double dataMax;
                double dataMin;
                double screenMax;
                double screenMin;
                TransformInterface ti;
                if (this.lastMouseLoc == null) break;
                this.isPanning = true;
                double[] temp = new double[3];
                if (this.xAxis != null && this.xAxisZoomHandler.hasViewport()) {
                    ti = this.getTransform("X", null);
                    ti.unProject(this.lastMouseLoc.x, 0.0, 0.0, temp);
                    double oldX = temp[0];
                    ti.unProject(e.getX(), 0.0, 0.0, temp);
                    double newX = temp[0];
                    screenMin = this.xAxisZoomHandler.getViewportMin();
                    screenMax = this.xAxisZoomHandler.getViewportMax();
                    dataMin = this.xAxisZoomHandler.getDataMin();
                    dataMax = this.xAxisZoomHandler.getDataMax();
                    screenRange = screenMax - screenMin;
                    xdiff = newX - oldX;
                    screenMax = (screenMin -= xdiff) + screenRange;
                    if (screenMin < dataMin) {
                        screenMax = dataMin + screenRange;
                    } else if (screenMax > dataMax) {
                        screenMin = dataMax - screenRange;
                    }
                    this.xAxisZoomHandler.setViewport(screenMin, screenMax);
                }
                if (this.yAxis != null && this.yAxisZoomHandler.hasViewport()) {
                    ti = this.getTransform(null, "Y");
                    ti.unProject(0.0, this.lastMouseLoc.y, 0.0, temp);
                    double oldY = temp[1];
                    ti.unProject(0.0, e.getY(), 0.0, temp);
                    double newY = temp[1];
                    screenMin = this.yAxisZoomHandler.getViewportMin();
                    screenMax = this.yAxisZoomHandler.getViewportMax();
                    dataMin = this.yAxisZoomHandler.getDataMin();
                    dataMax = this.yAxisZoomHandler.getDataMax();
                    screenRange = screenMax - screenMin;
                    double ydiff = newY - oldY;
                    screenMax = (screenMin -= ydiff) + screenRange;
                    if (screenMin < dataMin) {
                        screenMax = dataMin + screenRange;
                    } else if (screenMax > dataMax) {
                        screenMin = dataMax - screenRange;
                    }
                    this.yAxisZoomHandler.setViewport(screenMin, screenMax);
                }
                if (this.x2Axis != null && this.x2AxisZoomHandler.hasViewport()) {
                    screenMin = this.getX2Min(false);
                    screenMax = this.getX2Max(false);
                    dataMin = this.getX2Min(true);
                    dataMax = this.getX2Max(true);
                    screenRange = screenMax - screenMin;
                    ti = this.getTransform("X2", null);
                    ti.unProject(this.lastMouseLoc.x, this.lastMouseLoc.y, 0.0, temp);
                    double oldX2 = temp[0];
                    ti.unProject(e.getX(), e.getY(), 0.0, temp);
                    double newX2 = temp[0];
                    xdiff = newX2 - oldX2;
                    screenMax = (screenMin -= xdiff) + screenRange;
                    if (screenMin < dataMin) {
                        screenMin = dataMin;
                        screenMax = screenMin + screenRange;
                    } else if (screenMax > dataMax) {
                        screenMax = dataMax;
                        screenMin = screenMax - screenRange;
                    }
                    this.x2AxisZoomHandler.setViewport(screenMin, screenMax);
                }
                if (this.y2Axis != null && this.y2AxisZoomHandler.hasViewport()) {
                    screenMin = this.getY2Min(false);
                    screenMax = this.getY2Max(false);
                    dataMin = this.getY2Min(true);
                    dataMax = this.getY2Max(true);
                    screenRange = screenMax - screenMin;
                    ti = this.getTransform(null, "Y2");
                    ti.unProject(this.lastMouseLoc.x, this.lastMouseLoc.y, 0.0, temp);
                    double oldY2 = temp[1];
                    ti.unProject(e.getX(), e.getY(), 0.0, temp);
                    double newY2 = temp[1];
                    xdiff = newY2 - oldY2;
                    screenMax = (screenMin -= xdiff) + screenRange;
                    if (screenMin < dataMin) {
                        screenMin = dataMin;
                        screenMax = screenMin + screenRange;
                    } else if (screenMax > dataMax) {
                        screenMax = dataMax;
                        screenMin = screenMax - screenRange;
                    }
                    this.y2AxisZoomHandler.setViewport(screenMin, screenMax);
                }
                this.isPanning = false;
                this.buildAndDraw(new Boolean(true), null, null);
                break;
            }
            case 0: {
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                if (this.lastMouseLoc == null) break;
                if (!this.isCreatingBrush && this.brush != null && (this.isDraggingBrush || this.brush.contains(e.getX(), e.getY()))) {
                    this.brush.setLocation(this.brush.x + (e.getX() - this.lastMouseLoc.x), this.brush.y + (e.getY() - this.lastMouseLoc.y));
                    this.boundBrushToChartArea();
                    this.isCreatingBrush = false;
                    this.isDraggingBrush = true;
                    this.doPicking(this.brush, e);
                    break;
                }
                if (!this.isCreatingBrush) break;
                this.rubberbandRect.stretch(e.getPoint());
                this.brush = this.rubberbandRect.bounds();
                break;
            }
            case 9: {
                this.doPicking(null, e);
                break;
            }
        }
        this.lastMouseLoc = e.getPoint();
        this.repaint();
    }

    private void boundBrushToChartArea() {
        if (this.brush == null || this.dataRegion == null) {
            return;
        }
        if (this.brush.x < this.dataRegion.x) {
            this.brush.x = this.dataRegion.x;
        }
        if (this.brush.y < this.dataRegion.y) {
            this.brush.y = this.dataRegion.y;
        }
        if (this.brush.x + this.brush.width > this.dataRegion.x + this.dataRegion.width) {
            this.brush.x = this.dataRegion.x + this.dataRegion.width - this.brush.width;
        }
        if (this.brush.y + this.brush.height > this.dataRegion.y + this.dataRegion.height) {
            this.brush.y = this.dataRegion.y + this.dataRegion.height - this.brush.height;
        }
    }

    protected AxisComponent getAxisForPoint(Point p) {
        if (p == null) {
            return null;
        }
        if (this.xAxis != null && this.xAxis.getBounds() != null && this.xAxis.getBounds().contains(p)) {
            return this.xAxis;
        }
        if (this.yAxis != null && this.yAxis.getBounds() != null && this.yAxis.getBounds().contains(p)) {
            return this.yAxis;
        }
        if (this.x2Axis != null && this.x2Axis.getBounds() != null && this.x2Axis.getBounds().contains(p)) {
            return this.x2Axis;
        }
        if (this.y2Axis != null && this.y2Axis.getBounds() != null && this.y2Axis.getBounds().contains(p)) {
            return this.y2Axis;
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        super.mousePressed(me);
        this.mouseDown = true;
        this.mouseDownInChart = this.dataRegion.contains(me.getPoint());
        this.mouseDownOverWarningIcon = this.warningIcon.isMouseOverIcon(me.getX(), me.getY());
        if (me.getSource() instanceof RangeSlider) {
            this.handleRangeSliderMouseEvent(me);
            return;
        }
        this.checkCursor(me);
        if (!me.isControlDown()) {
            this.doPicking(null, me);
        }
        AxisComponent ac = null;
        this.zoomingAxisHandler = null;
        ac = this.getAxisForPoint(me.getPoint());
        if (ac != null) {
            if (this.zoomPanHandlersEnabled) {
                if (ac == this.xAxis) {
                    this.xAxisZoomHandler.mousePressed(me);
                    this.zoomingAxisHandler = this.xAxisZoomHandler;
                } else if (ac == this.yAxis) {
                    this.yAxisZoomHandler.mousePressed(me);
                    this.zoomingAxisHandler = this.yAxisZoomHandler;
                } else if (ac == this.x2Axis) {
                    this.x2AxisZoomHandler.mousePressed(me);
                    this.zoomingAxisHandler = this.x2AxisZoomHandler;
                } else if (ac == this.y2Axis) {
                    this.y2AxisZoomHandler.mousePressed(me);
                    this.zoomingAxisHandler = this.y2AxisZoomHandler;
                }
            }
            this.mouseDownInChart = false;
            return;
        }
        switch (this.actionMode) {
            case 3: {
                break;
            }
            case 2: {
                if (!this.mouseDownInChart) break;
                this.rubberbandRect.anchor(me.getPoint());
                break;
            }
            case 6: {
                this.rubberbandRect.anchor(me.getPoint());
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                this.rubberbandRect.anchor(me.getPoint());
                break;
            }
            case 0: {
                break;
            }
            case 8: {
                Hashtable info;
                if (this.drilldownListeners == null || this.drilldownListeners.isEmpty() || (info = this.getDrilldownInfo(me.getX(), me.getY())) == null || info.size() <= 0) break;
                String url = null;
                if (info != null && info.containsKey(DrilldownEvent.DRILLDOWN_KEY_URL)) {
                    url = info.get(DrilldownEvent.DRILLDOWN_KEY_URL).toString();
                }
                DrilldownEvent event = new DrilldownEvent(url, info);
                Enumeration e = this.drilldownListeners.elements();
                while (e.hasMoreElements()) {
                    ((DrilldownListenerInterface)e.nextElement()).drilldown(event);
                }
                break;
            }
            case 1: {
                if (this.brush != null && this.brush.contains(me.getPoint())) break;
                this.brush = null;
                this.isCreatingBrush = true;
                this.rubberbandRect.anchor(me.getPoint());
                break;
            }
            case 9: {
                this.doPicking(null, me);
            }
        }
        this.lastMouseLoc = me.getPoint();
    }

    protected abstract Hashtable getDrilldownInfo(int var1, int var2);

    private void handleRangeSliderMouseEvent(MouseEvent me) {
        Axes a;
        if (this.xAxis != null && (a = (Axes)this.xAxis.getInternalAxis()).getRangeSlider() == me.getSource()) {
            this.tipText = a.getRangeSliderTooltipText();
            this.tipLocation.x = a.getRangeSlider().getX() + me.getX();
            this.tipLocation.y = this.dataRegion.y + this.tooltip.getSize((Object)this.tipText, (Graphics2D)((Graphics2D)this.getGraphics()), (Component)this).height + 5;
        }
        if (this.yAxis != null && (a = (Axes)this.yAxis.getInternalAxis()).getRangeSlider() == me.getSource()) {
            this.tipText = a.getRangeSliderTooltipText();
            this.tipLocation.x = this.dataRegion.x + this.dataRegion.width;
            this.tipLocation.y = me.getY();
        }
        if (this.tipText != null && this.tipText.trim().length() == 0) {
            this.tipText = null;
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.checkCursor(me);
        super.mouseExited(me);
        if (!this.mouseDown) {
            this.deactivateZoomPanHandlers();
        }
        this.mouseOverHandler = null;
    }

    private void deactivateZoomPanHandlers() {
        if (this.xAxisZoomHandler != null) {
            this.xAxisZoomHandler.setActive(false);
        }
        if (this.yAxisZoomHandler != null) {
            this.yAxisZoomHandler.setActive(false);
        }
        if (this.x2AxisZoomHandler != null) {
            this.x2AxisZoomHandler.setActive(false);
        }
        if (this.y2AxisZoomHandler != null) {
            this.y2AxisZoomHandler.setActive(false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        AxisComponent ac = null;
        this.zoomingAxisHandler = null;
        if (!this.getBounds().contains(me.getPoint())) {
            this.deactivateZoomPanHandlers();
            this.repaint();
        }
        if (this.mouseDownOverWarningIcon && this.warningIcon.isMouseOverIcon(me.getX(), me.getY())) {
            this.resetComponent();
            return;
        }
        if (!this.mouseDownInChart && (ac = this.getAxisForPoint(me.getPoint())) != null && this.zoomPanHandlersEnabled) {
            if (ac == this.xAxis) {
                this.xAxisZoomHandler.mouseReleased(me);
                this.zoomingAxisHandler = this.xAxisZoomHandler;
            } else if (ac == this.yAxis) {
                this.yAxisZoomHandler.mouseReleased(me);
                this.zoomingAxisHandler = this.yAxisZoomHandler;
            } else if (ac == this.x2Axis) {
                this.x2AxisZoomHandler.mouseReleased(me);
                this.zoomingAxisHandler = this.x2AxisZoomHandler;
            } else if (ac == this.y2Axis) {
                this.y2AxisZoomHandler.mouseReleased(me);
                this.zoomingAxisHandler = this.y2AxisZoomHandler;
            }
            this.buildAndDraw(null, null, null);
            return;
        }
        if (me.isPopupTrigger()) {
            return;
        }
        super.mouseReleased(me);
        this.mouseDown = false;
        if (this.xAxis != null) {
            this.xAxis.setAutoCalculate(true);
        }
        if (this.yAxis != null) {
            this.yAxis.setAutoCalculate(true);
        }
        if (this.x2Axis != null) {
            this.x2Axis.setAutoCalculate(true);
        }
        if (this.y2Axis != null) {
            this.y2Axis.setAutoCalculate(true);
        }
        this.lastMouseLoc = null;
        if (this.zoomingAxisHandler != null && this.getAxisForPoint(me.getPoint()) != null) {
            this.zoomingAxisHandler.mouseReleased(me);
            this.buildAndDraw(new Boolean(true), null, null);
            return;
        }
        this.zoomingAxisHandler = null;
        this.checkCursor(me);
        if (!this.mouseDownInChart) {
            this.mouseDownInChart = false;
            return;
        }
        switch (this.actionMode) {
            case 3: {
                break;
            }
            case 2: {
                if (!this.mouseDownInChart) {
                    return;
                }
                this.inViewport = true;
                this.rubberbandRect.end(me.getPoint());
                this.brush = null;
                Rectangle r = this.rubberbandRect.bounds();
                if (r != null) {
                    int x = r.x;
                    int y = r.y;
                    int w = r.width;
                    int h = r.height;
                    if (w > 5 && h > 5) {
                        TransformInterface ti;
                        double min = 0.0;
                        double max = 0.0;
                        double[] temp = new double[3];
                        this.blockMarginEvents = true;
                        int x0 = x;
                        int y0 = y;
                        int x1 = x + w;
                        int y1 = y + h;
                        if (this.xAxis != null) {
                            ti = this.getTransform("X", null);
                            ti.unProject(x0, y0, 0.0, temp);
                            min = temp[0];
                            ti.unProject(x1, y1, 0.0, temp);
                            max = temp[0];
                            this.xAxisZoomHandler.setViewport(min, max);
                        }
                        if (this.yAxis != null) {
                            ti = this.getTransform(null, "Y");
                            ti.unProject(x0, y0, 0.0, temp);
                            min = temp[1];
                            ti.unProject(x1, y1, 0.0, temp);
                            max = temp[1];
                            this.yAxisZoomHandler.setViewport(min, max);
                        }
                        if (this.x2Axis != null) {
                            ti = this.getTransform("X2", null);
                            ti.unProject(x0, y0, 0.0, temp);
                            min = temp[0];
                            ti.unProject(x1, y1, 0.0, temp);
                            max = temp[0];
                            this.x2AxisZoomHandler.setViewport(min, max);
                        }
                        if (this.y2Axis != null) {
                            ti = this.getTransform(null, "Y2");
                            ti.unProject(x0, y0, 0.0, temp);
                            min = temp[1];
                            ti.unProject(x1, y1, 0.0, temp);
                            max = temp[1];
                            this.y2AxisZoomHandler.setViewport(min, max);
                        }
                        this.blockMarginEvents = false;
                        this.buildAndDraw(new Boolean(true), null, null);
                    }
                }
                this.inViewport = false;
                break;
            }
            case 6: {
                this.rubberbandRect.end(me.getPoint());
                this.doPicking(this.rubberbandRect.bounds(), me);
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                this.rubberbandRect.end(me.getPoint());
                this.brush = this.rubberbandRect.bounds();
                break;
            }
            case 0: {
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                this.isDraggingBrush = false;
                if (this.isCreatingBrush) {
                    this.rubberbandRect.end(me.getPoint());
                    this.brush = this.rubberbandRect.bounds();
                    this.isCreatingBrush = false;
                }
                this.doPicking(this.brush, me);
                break;
            }
            case 9: {
                this.doPicking(null, me);
                break;
            }
        }
        this.mouseDownInChart = false;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        super.mouseMoved(me);
        this.deactivateZoomPanHandlers();
        if (me.getSource() instanceof RangeSlider) {
            this.handleRangeSliderMouseEvent(me);
            this.suspendTooltipTimer();
            return;
        }
        this.mouseOverHandler = null;
        AxisComponent ac = null;
        if (!this.warningIcon.isMouseOverIcon(me.getX(), me.getY()) && (ac = this.getAxisForPoint(me.getPoint())) != null && this.zoomPanHandlersEnabled) {
            if (ac == this.xAxis) {
                this.xAxisZoomHandler.mouseMoved(me);
                this.mouseOverHandler = this.xAxisZoomHandler;
            } else if (ac == this.yAxis) {
                this.yAxisZoomHandler.mouseMoved(me);
                this.mouseOverHandler = this.yAxisZoomHandler;
            } else if (ac == this.x2Axis) {
                this.x2AxisZoomHandler.mouseMoved(me);
                this.mouseOverHandler = this.x2AxisZoomHandler;
            } else if (ac == this.y2Axis) {
                this.y2AxisZoomHandler.mouseMoved(me);
                this.mouseOverHandler = this.y2AxisZoomHandler;
            }
        } else {
            this.cursor = null;
        }
        this.checkCursor(me);
        this.lastMouseLoc = me.getPoint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        super.mouseWheelMoved(e);
        if (e.getScrollType() == 0) {
            double zoomFactor = 1.0 + (double)e.getUnitsToScroll() / 100.0;
            this.zoomToPoint(zoomFactor, this.tipLocation.x, this.tipLocation.y);
        }
    }

    protected void zoomToPoint(double zoomFactor, int mouseXscreen, int mouseYscreen) {
        double lowside;
        double highside;
        double screenMax;
        double screenMin;
        double tipDataLocation;
        if (zoomFactor <= 0.0 || (double)mouseXscreen < this.dataRegion.getMinX() || (double)mouseXscreen > this.dataRegion.getMaxX() || (double)mouseYscreen < this.dataRegion.getMinY() || (double)mouseYscreen > this.dataRegion.getMaxY()) {
            return;
        }
        this.blockLayoutEquated = true;
        this.rubberbandRect.setDrawRect(false);
        double[] t = new double[3];
        TransformObject transformObject = null;
        this.inViewport = true;
        this.brush = null;
        if (this.xAxis != null && (this.xAxisZoomHandler.hasViewport() || !(zoomFactor > 1.0))) {
            transformObject = (TransformObject)this.getTransform("X", null);
            transformObject.unProject(mouseXscreen, 0.0, 0.0, t);
            tipDataLocation = t[0];
            screenMin = this.xAxisZoomHandler.getViewportMin();
            screenMax = this.xAxisZoomHandler.getViewportMax();
            highside = screenMax - tipDataLocation;
            lowside = tipDataLocation - screenMin;
            screenMin = tipDataLocation - zoomFactor * lowside;
            screenMax = tipDataLocation + zoomFactor * highside;
            if (screenMin == screenMax) {
                screenMin -= 1.0E-6;
                screenMax += 1.0E-6;
            }
            if (screenMax > this.xAxisZoomHandler.getDataMax()) {
                screenMin -= screenMax - this.xAxisZoomHandler.getDataMax();
            }
            if (screenMin < this.xAxisZoomHandler.getDataMin()) {
                screenMax += this.xAxisZoomHandler.getDataMin() - screenMin;
            }
            this.xAxisZoomHandler.setViewport(screenMin, screenMax);
        }
        if (this.yAxis != null && (this.yAxisZoomHandler.hasViewport() || !(zoomFactor > 1.0))) {
            transformObject = (TransformObject)this.getTransform(null, "Y");
            transformObject.unProject(0.0, mouseYscreen, 0.0, t);
            tipDataLocation = t[1];
            screenMin = this.yAxisZoomHandler.getViewportMin();
            screenMax = this.yAxisZoomHandler.getViewportMax();
            highside = screenMax - tipDataLocation;
            lowside = tipDataLocation - screenMin;
            screenMin = tipDataLocation - zoomFactor * lowside;
            screenMax = tipDataLocation + zoomFactor * highside;
            if (screenMin == screenMax) {
                screenMin -= 1.0E-6;
                screenMax += 1.0E-6;
            }
            if (screenMax > this.yAxisZoomHandler.getDataMax()) {
                screenMin -= screenMax - this.yAxisZoomHandler.getDataMax();
            }
            if (screenMin < this.yAxisZoomHandler.getDataMin()) {
                screenMax += this.yAxisZoomHandler.getDataMin() - screenMin;
            }
            this.yAxisZoomHandler.setViewport(screenMin, screenMax);
        }
        if (this.x2Axis != null && (this.x2AxisZoomHandler.hasViewport() || !(zoomFactor > 1.0))) {
            transformObject = (TransformObject)this.getTransform("X2", null);
            transformObject.unProject(mouseXscreen, 0.0, 0.0, t);
            tipDataLocation = t[0];
            screenMin = this.x2AxisZoomHandler.getViewportMin();
            screenMax = this.x2AxisZoomHandler.getViewportMax();
            highside = screenMax - tipDataLocation;
            lowside = tipDataLocation - screenMin;
            screenMin = tipDataLocation - zoomFactor * lowside;
            screenMax = tipDataLocation + zoomFactor * highside;
            if (screenMin == screenMax) {
                screenMin -= 1.0E-6;
                screenMax += 1.0E-6;
            }
            if (screenMax > this.x2AxisZoomHandler.getDataMax()) {
                screenMin -= screenMax - this.x2AxisZoomHandler.getDataMax();
            }
            if (screenMin < this.x2AxisZoomHandler.getDataMin()) {
                screenMax += this.x2AxisZoomHandler.getDataMin() - screenMin;
            }
            this.x2AxisZoomHandler.setViewport(screenMin, screenMax);
        }
        if (this.y2Axis != null && (this.y2AxisZoomHandler.hasViewport() || !(zoomFactor > 1.0))) {
            transformObject = (TransformObject)this.getTransform(null, "Y2");
            transformObject.unProject(0.0, mouseYscreen, 0.0, t);
            tipDataLocation = t[1];
            screenMin = this.y2AxisZoomHandler.getViewportMin();
            screenMax = this.y2AxisZoomHandler.getViewportMax();
            highside = screenMax - tipDataLocation;
            lowside = tipDataLocation - screenMin;
            screenMin = tipDataLocation - zoomFactor * lowside;
            screenMax = tipDataLocation + zoomFactor * highside;
            if (screenMin == screenMax) {
                screenMin -= 1.0E-6;
                screenMax += 1.0E-6;
            }
            if (screenMax > this.y2AxisZoomHandler.getDataMax()) {
                screenMin -= screenMax - this.y2AxisZoomHandler.getDataMax();
            }
            if (screenMin < this.y2AxisZoomHandler.getDataMin()) {
                screenMax += this.y2AxisZoomHandler.getDataMin() - screenMin;
            }
            this.y2AxisZoomHandler.setViewport(screenMin, screenMax);
        }
        this.blockLayoutEquated = false;
        this.inViewport = false;
    }

    protected void panBy(AxisZoomPanHandler zph, double percentage) {
        double screenMin = zph.getViewportMin();
        double screenMax = zph.getViewportMax();
        double dataMin = zph.getDataMin();
        double dataMax = zph.getDataMax();
        double screenRange = screenMax - screenMin;
        screenMax = (screenMin += percentage * screenRange) + screenRange;
        if (screenMin < dataMin) {
            screenMax = dataMin + screenRange;
        } else if (screenMax > dataMax) {
            screenMin = dataMax - screenRange;
        }
        zph.setViewport(screenMin, screenMax);
    }

    protected void panBy(double percentX, double percentY) {
        this.isPanning = true;
        this.brush = null;
        if (percentX != 0.0) {
            if (this.xAxis != null && this.xAxisZoomHandler.hasViewport()) {
                this.panBy(this.xAxisZoomHandler, percentX);
            }
            if (this.x2Axis != null && this.x2AxisZoomHandler.hasViewport()) {
                this.panBy(this.x2AxisZoomHandler, percentX);
            }
        } else if (percentY != 0.0) {
            if (this.yAxis != null && this.yAxisZoomHandler.hasViewport()) {
                this.panBy(this.yAxisZoomHandler, percentY);
            }
            if (this.y2Axis != null && this.y2AxisZoomHandler.hasViewport()) {
                this.panBy(this.y2AxisZoomHandler, percentY);
            }
        }
        this.isPanning = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String command = e.getActionCommand();
        if (!this.isPanning) {
            if (command.equalsIgnoreCase("UPARROW") || command.equalsIgnoreCase("W_KEY")) {
                this.panBy(0.0, 0.1);
            } else if (command.equalsIgnoreCase("DOWNARROW") || command.equalsIgnoreCase("S_KEY")) {
                this.panBy(0.0, -0.1);
            } else if (command.equalsIgnoreCase("LEFTARROW") || command.equalsIgnoreCase("A_KEY")) {
                this.panBy(-0.1, 0.0);
            } else if (command.equalsIgnoreCase("RIGHTARROW") || command.equalsIgnoreCase("D_KEY")) {
                this.panBy(0.1, 0.0);
            }
        }
        if (command.equalsIgnoreCase("PLUS")) {
            this.zoomToPoint(0.9, this.tipLocation.x, this.tipLocation.y);
        } else if (command.equalsIgnoreCase("MINUS")) {
            this.zoomToPoint(1.1, this.tipLocation.x, this.tipLocation.y);
        } else if (command.equalsIgnoreCase("ESCAPE")) {
            this.resetViewport();
        }
    }

    protected void checkCursor(MouseEvent me) {
        boolean insideBrush;
        int x = me.getX();
        int y = me.getY();
        boolean bl = insideBrush = this.brush == null || this.actionMode != 1 ? false : this.brush.contains(x, y);
        if ((this.actionMode == 1 || this.actionMode == 6) && me.isShiftDown()) {
            if (this.mouseDownInChart) {
                this.cursor = moveCursorClose;
                this.setCursor(this.cursor);
            } else {
                this.cursor = moveCursorOpen;
                this.setCursor(this.cursor);
            }
        } else if (insideBrush || this.actionMode == 4 && this.dataRegion.contains(x, y)) {
            if (this.mouseDownInChart) {
                this.cursor = moveCursorClose;
                this.setCursor(this.cursor);
            } else {
                this.cursor = moveCursorOpen;
                this.setCursor(this.cursor);
            }
        } else if (this.actionMode == 3 && this.dataRegion.contains(x, y)) {
            this.cursor = zoomCursor;
            this.setCursor(this.cursor);
        } else if (this.actionMode == 2 && this.dataRegion.contains(x, y)) {
            if (me.isShiftDown()) {
                this.cursor = zoomCursor;
                this.setCursor(this.cursor);
            } else if (me.isControlDown() && this.mouseDown) {
                this.cursor = moveCursorClose;
                this.setCursor(this.cursor);
            } else if (me.isControlDown()) {
                this.cursor = moveCursorOpen;
                this.setCursor(this.cursor);
            } else {
                this.cursor = viewportCursor;
                this.setCursor(this.cursor);
            }
        } else if (this.mouseOverHandler == null && this.cursor != normalCursor) {
            this.cursor = normalCursor;
            this.setCursor(this.cursor);
        }
    }

    protected void doPicking(Rectangle r, MouseEvent event) {
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        super.dataFilterChanged(evt);
        switch (evt.type) {
            case 1: 
            case 3: {
                this.setInternalRange((byte)1, 0, this.getAxisRange(0));
                this.setInternalRange((byte)2, 0, this.getAxisRange(1));
                this.setInternalRange((byte)1, 1, this.getAxisRange(3));
                this.setInternalRange((byte)2, 1, this.getAxisRange(4));
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            }
        }
        this.repaint();
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        AxisComponent ac;
        if (id == 238) {
            Object v = value;
            if (value != null && value instanceof PropertyEvent) {
                v = ((PropertyEvent)value).value;
            }
            if (v != null && v instanceof Number) {
                int curAxis = ((Number)v).intValue();
                switch (curAxis) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: {
                        this.currentAxis = curAxis;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else if (v instanceof String) {
                if ("X".equalsIgnoreCase(v.toString())) {
                    this.currentAxis = 0;
                } else if ("Y".equalsIgnoreCase(v.toString())) {
                    this.currentAxis = 1;
                } else if ("X2".equalsIgnoreCase(v.toString())) {
                    this.currentAxis = 3;
                } else if ("Y2".equalsIgnoreCase(v.toString())) {
                    this.currentAxis = 4;
                }
            }
        }
        if (id >= 200 && id <= 300 && (ac = this.getCurrentAxisComponent()) != null) {
            return ac.setPropertyValue(id, value);
        }
        return super.setPropertyValue(id, value);
    }

    protected AxisComponent getCurrentAxisComponent() {
        String axisId = null;
        switch (this.currentAxis) {
            case 0: {
                if (this.xAxis == null) break;
                axisId = "X";
                break;
            }
            case 3: {
                if (this.x2Axis == null) break;
                axisId = "X2";
                break;
            }
            case 1: {
                if (this.yAxis == null) break;
                axisId = "Y";
                break;
            }
            case 4: {
                if (this.y2Axis == null) break;
                axisId = "Y2";
            }
        }
        if (axisId == null) {
            return null;
        }
        return this.getAxisComponent(axisId);
    }

    @Override
    public boolean applyPropertyChanges(Object source) {
        int[] pendingChanges = this.getPendingChanges();
        if (pendingChanges != null) {
            this.buildAfterApplyProperties |= pendingChanges.length > 0;
        }
        AxisComponent ac = null;
        if (this.xAxis != null && (ac = this.getAxisComponent("X")) != null) {
            ac.applyPropertyChanges(source);
        }
        if (this.x2Axis != null && (ac = this.getAxisComponent("X2")) != null) {
            ac.applyPropertyChanges(source);
        }
        if (this.yAxis != null && (ac = this.getAxisComponent("Y")) != null) {
            ac.applyPropertyChanges(source);
        }
        if (this.y2Axis != null && (ac = this.getAxisComponent("Y2")) != null) {
            ac.applyPropertyChanges(source);
        }
        return super.applyPropertyChanges(source);
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 34: {
                if (!(value instanceof Boolean)) break;
                this.zoomPanHandlersEnabled = (Boolean)value;
                if (this.pallet == null) break;
                this.pallet.setVisible(false);
                break;
            }
            case 27: {
                this.wall.setSolidBackground(value);
                this.userSetProperties.set(27);
                break;
            }
            case 68: {
                if (value instanceof Integer) {
                    this.pallet.setPosition((Integer)value);
                } else if (value instanceof String) {
                    this.pallet.setStringPosition(value.toString());
                }
                this.userSetProperties.set(68);
                break;
            }
            case 69: {
                if (!(value instanceof Boolean)) break;
                this.pallet.setVisible((Boolean)value);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public int[] getPendingChanges(Object source) {
        int[] pendingList = super.getPendingChanges(source);
        Vector<Integer> v = new Vector<Integer>();
        if (pendingList != null && pendingList.length > 0) {
            for (int i = 0; i < pendingList.length; ++i) {
                v.add(new Integer(pendingList[i]));
            }
        }
        if (this.xAxis != null) {
            this.addPendingChanges(this.xAxis, source, v);
        }
        if (this.x2Axis != null) {
            this.addPendingChanges(this.x2Axis, source, v);
        }
        if (this.yAxis != null) {
            this.addPendingChanges(this.yAxis, source, v);
        }
        if (this.y2Axis != null) {
            this.addPendingChanges(this.y2Axis, source, v);
        }
        int[] pending = null;
        if (v.size() > 0) {
            pending = new int[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                pending[i] = ((Number)v.elementAt(i)).intValue();
            }
        }
        return pending;
    }

    @Override
    public Object getPropertyValue(int id) {
        Vector<String> rc = null;
        switch (id) {
            case 34: {
                rc = new Boolean(this.zoomPanHandlersEnabled);
                break;
            }
            case 238: {
                rc = this.getCurrentAxisComponent();
                break;
            }
            case 44: 
            case 45: {
                Vector<String> v = new Vector<String>();
                if (this.xAxis != null) {
                    v.addElement(id == 44 ? "X" : this.X_AXIS_DISPLAY_NAME);
                }
                if (this.yAxis != null) {
                    v.addElement(id == 44 ? "Y" : this.Y_AXIS_DISPLAY_NAME);
                }
                if (this.x2Axis != null) {
                    v.addElement(id == 44 ? "X2" : this.X2_AXIS_DISPLAY_NAME);
                }
                if (this.y2Axis != null) {
                    v.addElement(id == 44 ? "Y2" : this.Y2_AXIS_DISPLAY_NAME);
                }
                rc = v;
                break;
            }
            case 61: {
                rc = new Integer(this.equated);
                break;
            }
            case 27: {
                rc = this.wall != null ? this.wall.getBackgroundColor() : null;
                break;
            }
            case 68: {
                rc = ToolPallet.getStringPosition(this.pallet.getPosition());
                break;
            }
            case 69: {
                rc = this.pallet.isVisible();
                break;
            }
            case 71: {
                rc = Boolean.TRUE;
                break;
            }
            default: {
                AxisComponent ac;
                if (id >= 200 && id <= 300 && (ac = this.getCurrentAxisComponent()) != null) {
                    return ac.getPropertyValue(id);
                }
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    public boolean isPropertySupported(int id) {
        switch (id) {
            case 27: 
            case 34: 
            case 44: 
            case 45: 
            case 46: 
            case 68: 
            case 69: 
            case 71: 
            case 238: 
            case 244: 
            case 245: 
            case 246: {
                return true;
            }
        }
        return super.isPropertySupported(id);
    }

    protected double getXMin(boolean returnFullRange) {
        double d = Double.NaN;
        if (returnFullRange && this.xDataRange == null) {
            this.xDataRange = this.getAxisRange(0);
        }
        if (returnFullRange && this.xDataRange instanceof ContinuousRange) {
            d = ((ContinuousRange)this.xDataRange).getMin();
        } else if (returnFullRange && this.xDataRange instanceof DiscreteRange) {
            d = 0.0;
        } else if (this.xAxis != null) {
            DataRange r = this.getOutputRange(this.xAxis, this.xAxisZoomHandler);
            if (r instanceof ContinuousRange) {
                d = ((ContinuousRange)r).getMin();
            } else if (r instanceof DiscreteRange) {
                d = 0.0;
            }
        }
        return d;
    }

    protected double getXMax(boolean fullRange) {
        double d = Double.NaN;
        if (fullRange && this.xDataRange == null) {
            this.xDataRange = this.getAxisRange(0);
        }
        if (fullRange && this.xDataRange instanceof ContinuousRange) {
            d = ((ContinuousRange)this.xDataRange).getMax();
        } else if (fullRange && this.xDataRange instanceof DiscreteRange) {
            d = ((DiscreteRange)this.xDataRange).getValuesSize() - 1;
        } else if (this.xAxis != null) {
            DataRange r = this.getOutputRange(this.xAxis, this.xAxisZoomHandler);
            if (r instanceof ContinuousRange) {
                d = ((ContinuousRange)r).getMax();
            } else if (r instanceof DiscreteRange) {
                d = ((DiscreteRange)r).getValuesSize() - 1;
            }
        }
        return d;
    }

    protected double getYMin(boolean fullRange) {
        double d = Double.NaN;
        if (fullRange && this.yDataRange == null) {
            this.yDataRange = this.getAxisRange(1);
        }
        if (fullRange && this.yDataRange instanceof ContinuousRange) {
            d = ((ContinuousRange)this.yDataRange).getMin();
        } else if (fullRange && this.yDataRange instanceof DiscreteRange) {
            d = 0.0;
        } else if (this.yAxis != null) {
            DataRange r = this.getOutputRange(this.yAxis, this.yAxisZoomHandler);
            if (r instanceof ContinuousRange) {
                d = ((ContinuousRange)r).getMin();
            } else if (r instanceof DiscreteRange) {
                d = 0.0;
            }
        }
        return d;
    }

    protected double getYMax(boolean fullRange) {
        double d = Double.NaN;
        if (fullRange && this.yDataRange == null) {
            this.yDataRange = this.getAxisRange(1);
        }
        if (fullRange && this.yDataRange instanceof ContinuousRange) {
            d = ((ContinuousRange)this.yDataRange).getMax();
        } else if (fullRange && this.yDataRange instanceof DiscreteRange) {
            d = ((DiscreteRange)this.yDataRange).getValuesSize() - 1;
        } else if (this.yAxis != null) {
            DataRange r = this.getOutputRange(this.yAxis, this.yAxisZoomHandler);
            if (r instanceof ContinuousRange) {
                d = ((ContinuousRange)r).getMax();
            } else if (r instanceof DiscreteRange) {
                d = ((DiscreteRange)r).getValuesSize() - 1;
            }
        }
        return d;
    }

    protected double getX2Min(boolean fullRange) {
        double d = Double.NaN;
        if (fullRange && this.x2DataRange == null) {
            this.x2DataRange = this.getAxisRange(3);
        }
        if (fullRange && this.x2DataRange instanceof ContinuousRange) {
            d = ((ContinuousRange)this.x2DataRange).getMin();
        } else if (fullRange && this.x2DataRange instanceof DiscreteRange) {
            d = 0.0;
        } else if (this.x2Axis != null) {
            DataRange r = this.getOutputRange(this.x2Axis, this.x2AxisZoomHandler);
            if (r instanceof ContinuousRange) {
                d = ((ContinuousRange)r).getMin();
            } else if (r instanceof DiscreteRange) {
                d = 0.0;
            }
        }
        return d;
    }

    protected double getX2Max(boolean fullRange) {
        double d = Double.NaN;
        if (fullRange && this.x2DataRange == null) {
            this.x2DataRange = this.getAxisRange(3);
        }
        if (fullRange && this.x2DataRange instanceof ContinuousRange) {
            d = ((ContinuousRange)this.x2DataRange).getMin();
        } else if (fullRange && this.x2DataRange instanceof DiscreteRange) {
            d = ((DiscreteRange)this.x2DataRange).getValuesSize() - 1;
        } else if (this.x2Axis != null) {
            DataRange r = this.getOutputRange(this.x2Axis, this.x2AxisZoomHandler);
            if (r instanceof ContinuousRange) {
                d = ((ContinuousRange)r).getMax();
            } else if (r instanceof DiscreteRange) {
                d = ((DiscreteRange)r).getValuesSize() - 1;
            }
        }
        return d;
    }

    protected double getY2Min(boolean fullRange) {
        double d = Double.NaN;
        if (fullRange && this.y2DataRange == null) {
            this.y2DataRange = this.getAxisRange(4);
        }
        if (fullRange && this.y2DataRange instanceof ContinuousRange) {
            d = ((ContinuousRange)this.y2DataRange).getMin();
        } else if (fullRange && this.y2DataRange instanceof DiscreteRange) {
            d = 0.0;
        } else if (this.y2Axis != null) {
            DataRange r = this.getOutputRange(this.y2Axis, this.y2AxisZoomHandler);
            if (r instanceof ContinuousRange) {
                d = ((ContinuousRange)r).getMin();
            } else if (r instanceof DiscreteRange) {
                d = 0.0;
            }
        }
        return d;
    }

    protected double getY2Max(boolean fullRange) {
        double d = Double.NaN;
        if (fullRange && this.y2DataRange == null) {
            this.y2DataRange = this.getAxisRange(4);
        }
        if (fullRange && this.y2DataRange instanceof ContinuousRange) {
            d = ((ContinuousRange)this.y2DataRange).getMax();
        } else if (fullRange && this.y2DataRange instanceof DiscreteRange) {
            d = ((DiscreteRange)this.y2DataRange).getValuesSize() - 1;
        } else if (this.y2Axis != null) {
            DataRange r = this.getOutputRange(this.y2Axis, this.y2AxisZoomHandler);
            if (r instanceof ContinuousRange) {
                d = ((ContinuousRange)r).getMax();
            } else if (r instanceof DiscreteRange) {
                d = ((DiscreteRange)r).getValuesSize() - 1;
            }
        }
        return d;
    }

    @Override
    public double[] getViewport(int type, int level, int dimension) {
        double[] rc = null;
        if (type == 1) {
            switch (dimension) {
                case 1: {
                    if (this.xAxisZoomHandler == null) break;
                    rc = new double[]{level == 1 ? this.xAxisZoomHandler.getDataMin() : this.xAxisZoomHandler.getViewportMin(), level == 1 ? this.xAxisZoomHandler.getDataMax() : this.xAxisZoomHandler.getViewportMax()};
                    break;
                }
                case 2: {
                    if (this.yAxisZoomHandler == null) break;
                    rc = new double[]{level == 1 ? this.yAxisZoomHandler.getDataMin() : this.yAxisZoomHandler.getViewportMin(), level == 1 ? this.yAxisZoomHandler.getDataMax() : this.yAxisZoomHandler.getViewportMax()};
                    break;
                }
                case 5: {
                    if (this.x2AxisZoomHandler == null) break;
                    rc = new double[]{level == 1 ? this.x2AxisZoomHandler.getDataMin() : this.x2AxisZoomHandler.getViewportMin(), level == 1 ? this.x2AxisZoomHandler.getDataMax() : this.x2AxisZoomHandler.getViewportMax()};
                    break;
                }
                case 6: {
                    if (this.y2AxisZoomHandler == null) break;
                    rc = new double[]{level == 1 ? this.y2AxisZoomHandler.getDataMin() : this.y2AxisZoomHandler.getViewportMin(), level == 1 ? this.y2AxisZoomHandler.getDataMax() : this.y2AxisZoomHandler.getViewportMax()};
                    break;
                }
                case 4: {
                    rc = new double[6];
                    if (this.xAxisZoomHandler == null) {
                        rc[1] = Double.NaN;
                        rc[0] = Double.NaN;
                    } else {
                        rc[0] = level == 1 ? this.xAxisZoomHandler.getDataMin() : this.xAxisZoomHandler.getViewportMin();
                        double d = rc[1] = level == 1 ? this.xAxisZoomHandler.getDataMax() : this.xAxisZoomHandler.getViewportMax();
                    }
                    if (this.yAxisZoomHandler == null) {
                        rc[3] = Double.NaN;
                        rc[2] = Double.NaN;
                    } else {
                        rc[2] = level == 1 ? this.yAxisZoomHandler.getDataMin() : this.yAxisZoomHandler.getViewportMin();
                        rc[3] = level == 1 ? this.yAxisZoomHandler.getDataMax() : this.yAxisZoomHandler.getViewportMax();
                    }
                    rc[4] = Double.NaN;
                    rc[5] = Double.NaN;
                    break;
                }
                case 7: {
                    rc = new double[6];
                    if (this.x2AxisZoomHandler == null) {
                        rc[1] = Double.NaN;
                        rc[0] = Double.NaN;
                    } else {
                        rc[0] = level == 1 ? this.x2AxisZoomHandler.getDataMin() : this.x2AxisZoomHandler.getViewportMin();
                        double d = rc[1] = level == 1 ? this.x2AxisZoomHandler.getDataMax() : this.x2AxisZoomHandler.getViewportMax();
                    }
                    if (this.y2AxisZoomHandler == null) {
                        rc[3] = Double.NaN;
                        rc[2] = Double.NaN;
                    } else {
                        rc[2] = level == 1 ? this.y2AxisZoomHandler.getDataMin() : this.y2AxisZoomHandler.getViewportMin();
                        rc[3] = level == 1 ? this.y2AxisZoomHandler.getDataMax() : this.y2AxisZoomHandler.getViewportMax();
                    }
                    rc[4] = Double.NaN;
                    rc[5] = Double.NaN;
                }
            }
        } else if (type == 3) {
            switch (dimension) {
                case 1: 
                case 5: {
                    rc = new double[]{this.dataRegion.getMinX(), this.dataRegion.getMaxX()};
                    break;
                }
                case 2: 
                case 6: {
                    rc = new double[]{this.dataRegion.getMinY(), this.dataRegion.getMinY()};
                    break;
                }
                case 4: 
                case 7: {
                    rc = new double[]{this.dataRegion.getMinX(), this.dataRegion.getMaxX(), this.dataRegion.getMinY(), this.dataRegion.getMaxY(), Double.NaN, Double.NaN};
                }
            }
        }
        return rc;
    }

    @Override
    public boolean resetViewport() {
        return this.resetViewport(true, true, true, true);
    }

    public boolean resetViewport(boolean x, boolean y, boolean x2, boolean y2) {
        this.inResetViewport = true;
        this.increaseHoldBuild();
        this.hasViewport = false;
        this.zoomingAxisHandler = null;
        if (x && this.xAxisZoomHandler != null) {
            this.xAxisZoomHandler.resetAxis();
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        }
        if (x2 && this.x2AxisZoomHandler != null) {
            this.x2AxisZoomHandler.resetAxis();
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        }
        if (y && this.yAxisZoomHandler != null) {
            this.yAxisZoomHandler.resetAxis();
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        }
        if (y2 && this.y2AxisZoomHandler != null) {
            this.y2AxisZoomHandler.resetAxis();
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        }
        if (this.deferredViewports != null) {
            this.deferredViewports.clear();
        }
        this.hasViewport = false;
        this.decreaseHoldBuild();
        this.inResetViewport = false;
        return true;
    }

    protected DiscreteRange getRangeForIndicies(double minVal, double maxVal, DiscreteRange fullRange) {
        int min = (int)Math.ceil(minVal);
        int max = (int)Math.floor(maxVal);
        Vector selectVector = new Vector();
        if (min < 0 || max < 0 || min >= fullRange.getValuesSize() || max >= fullRange.getValuesSize()) {
            min = 0;
            max = fullRange.getValuesSize() - 1;
        }
        for (int i = min; i <= max; ++i) {
            selectVector.addElement(fullRange.getValues().elementAt(i));
        }
        return new DiscreteRange(selectVector.toArray());
    }

    protected int getMinDiscreteTickCount(int axis) {
        return -1;
    }

    @Override
    public boolean setViewport(int type, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        boolean rc = this.setViewport(type, 1, xmin, xmax);
        return rc |= this.setViewport(type, 2, ymin, ymax);
    }

    @Override
    public boolean setViewport(int type, int dimension, double min, double max) {
        if (type != 1) {
            return false;
        }
        if (this.getParent() == null) {
            if (this.deferredViewports == null) {
                this.deferredViewports = new Hashtable();
            }
            this.deferredViewports.put(new Integer(dimension), new double[]{min, max});
            return true;
        }
        if (this.zoomingAxisHandler == null) {
            if (dimension == 1) {
                this.zoomingAxisHandler = this.xAxisZoomHandler;
            } else if (dimension == 2) {
                this.zoomingAxisHandler = this.yAxisZoomHandler;
            } else if (dimension == 5) {
                this.zoomingAxisHandler = this.x2AxisZoomHandler;
            } else if (dimension == 6) {
                this.zoomingAxisHandler = this.y2AxisZoomHandler;
            }
            if (this.zoomingAxisHandler != null) {
                this.zoomingAxisHandler.setViewport(min, max);
            }
            this.zoomingAxisHandler = null;
            return true;
        }
        this.hasViewport = true;
        ContinuousRange range = null;
        DataRange fullRange = null;
        int minDiscreteTickCount = -1;
        switch (dimension) {
            case 1: {
                fullRange = this.xDataRange = this.xMergedRange != null ? this.xMergedRange : this.getAxisRange(0);
                minDiscreteTickCount = this.getMinDiscreteTickCount(0);
                break;
            }
            case 2: {
                fullRange = this.yDataRange = this.yMergedRange != null ? this.yMergedRange : this.getAxisRange(1);
                minDiscreteTickCount = this.getMinDiscreteTickCount(1);
                break;
            }
            case 5: {
                fullRange = this.x2DataRange = this.x2MergedRange != null ? this.x2MergedRange : this.getAxisRange(3);
                minDiscreteTickCount = this.getMinDiscreteTickCount(3);
                break;
            }
            case 6: {
                fullRange = this.y2DataRange = this.y2MergedRange != null ? this.y2MergedRange : this.getAxisRange(4);
                minDiscreteTickCount = this.getMinDiscreteTickCount(4);
            }
        }
        if (fullRange instanceof ContinuousRange) {
            range = new ContinuousRange(min, max);
        } else if (fullRange instanceof DiscreteRange) {
            range = this.getRangeForIndicies(min, max, SILKUtilities.createPaddedRange((DiscreteRange)fullRange, minDiscreteTickCount));
        }
        switch (dimension) {
            case 1: {
                if (this.xAxis != null) {
                    this.xAxis.setHasViewport(this.xAxisZoomHandler.hasViewport());
                }
                if (this.xAxisZoomHandler.hasViewport()) {
                    this.setInternalRange((byte)1, 0, (DataRange)range);
                    break;
                }
                this.setInternalRange((byte)1, 0, fullRange);
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                break;
            }
            case 2: {
                if (this.yAxis != null) {
                    this.yAxis.setHasViewport(this.yAxisZoomHandler.hasViewport());
                }
                if (this.yAxisZoomHandler.hasViewport()) {
                    this.setInternalRange((byte)2, 0, (DataRange)range);
                    break;
                }
                this.setInternalRange((byte)2, 0, fullRange);
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
                break;
            }
            case 5: {
                if (this.x2Axis != null) {
                    this.x2Axis.setHasViewport(this.x2AxisZoomHandler.hasViewport());
                }
                if (this.x2AxisZoomHandler.hasViewport()) {
                    this.setInternalRange((byte)1, 1, (DataRange)range);
                    break;
                }
                this.setInternalRange((byte)1, 1, fullRange);
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                break;
            }
            case 6: {
                if (this.y2Axis != null) {
                    this.y2Axis.setHasViewport(this.y2AxisZoomHandler.hasViewport());
                }
                if (this.y2AxisZoomHandler.hasViewport()) {
                    this.setInternalRange((byte)2, 1, (DataRange)range);
                    break;
                }
                this.setInternalRange((byte)2, 1, fullRange);
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected DataRange getOutputRange(AxisComponent axis, AxisZoomPanHandler axisHandler) {
        if (axis == null) {
            return null;
        }
        if (axis != null && axis.isHasViewport()) {
            return axis.getDataRange();
        }
        return axis.getOutputRange();
    }

    protected DataRange getOutputRange(byte dimension, int index) {
        DataRange rc = null;
        switch (dimension) {
            case 1: {
                if (index == 0) {
                    rc = this.getOutputRange(this.xAxis, this.xAxisZoomHandler);
                    break;
                }
                if (index != 1) break;
                rc = this.getOutputRange(this.x2Axis, this.x2AxisZoomHandler);
                break;
            }
            case 2: {
                if (index == 0) {
                    rc = this.getOutputRange(this.yAxis, this.yAxisZoomHandler);
                    break;
                }
                if (index != 1) break;
                rc = this.getOutputRange(this.y2Axis, this.y2AxisZoomHandler);
            }
        }
        return rc;
    }

    @Override
    public void viewportChanged(ViewportEvent evt) {
        Object source = evt.source;
        if (source != this.xAxisZoomHandler && source != this.yAxisZoomHandler && source != this.x2AxisZoomHandler && source != this.y2AxisZoomHandler) {
            return;
        }
        if (source == this.xAxisZoomHandler) {
            if (this.xAxis != null) {
                this.xAxis.setAutoCalculate(false);
            }
            this.setViewport(1, 1, evt.xMin, evt.xMax);
        }
        if (source == this.yAxisZoomHandler) {
            if (this.yAxis != null) {
                this.yAxis.setAutoCalculate(false);
            }
            this.setViewport(1, 2, evt.yMin, evt.yMax);
        }
        if (source == this.x2AxisZoomHandler) {
            if (this.x2Axis != null) {
                this.x2Axis.setAutoCalculate(false);
            }
            this.setViewport(1, 5, evt.xMin, evt.xMax);
        }
        if (source == this.y2AxisZoomHandler) {
            if (this.y2Axis != null) {
                this.y2Axis.setAutoCalculate(false);
            }
            this.setViewport(1, 6, evt.yMin, evt.yMax);
        }
        this.buildAndDraw(Boolean.TRUE, null, null);
    }

    @Override
    public void textUpdated(DvrTextEvent evt) {
        super.textUpdated(evt);
        this.layoutChart();
        this.buildAndDraw(new Boolean(true), null, null);
    }

    @Override
    public void boundingBoxChanged(RedrawEvent e) {
    }

    @Override
    public void outerMarginChanged(RedrawEvent e) {
        this.layoutChart();
    }

    @Override
    public void redraw(RedrawEvent e) {
        if (this.getBuildDepth() > 0) {
            return;
        }
        if (e.type == 6) {
            byte dim = 1;
            int type = 0;
            if (this.yAxis != null && e.getSource() == this.yAxis.getInternalAxis() || this.y2Axis != null && e.getSource() == this.y2Axis.getInternalAxis()) {
                dim = 2;
            }
            if (this.y2Axis != null && e.getSource() == this.y2Axis.getInternalAxis() || this.x2Axis != null && e.getSource() == this.x2Axis.getInternalAxis()) {
                type = 1;
            }
            if (dim == 1 && type == 0) {
                this.setInternalRange(dim, type, this.xMergedRange != null ? this.xMergedRange : this.getAxisRange(0));
            } else if (dim == 1 && type == 1) {
                this.setInternalRange(dim, type, this.x2MergedRange != null ? this.x2MergedRange : this.getAxisRange(3));
            } else if (dim == 2 && type == 0) {
                this.setInternalRange(dim, type, this.yMergedRange != null ? this.yMergedRange : this.getAxisRange(1));
            } else if (dim == 2 && type == 1) {
                this.setInternalRange(dim, type, this.y2MergedRange != null ? this.y2MergedRange : this.getAxisRange(4));
            }
            this.setupTransforms();
        }
        this.invalidateBackBuffer();
        if (e.type == 4 || e.type == 6 || e.type == 3) {
            this.revalidate();
            this.repaint();
        }
        if (e.type == 7) {
            this.build(Boolean.TRUE);
        }
    }

    public void rangeChanged(RangeChangedEvent e) {
        if (e == null || e.getSource() == this) {
            return;
        }
        byte index = e.getType();
        switch (e.getDimension()) {
            case 1: {
                if (index == 0) {
                    this.setInternalRange((byte)1, 0, this.getAxisRange(0));
                } else {
                    this.setInternalRange((byte)1, 1, this.getAxisRange(3));
                }
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                break;
            }
            case 2: {
                if (index == 0) {
                    this.setInternalRange((byte)2, 0, this.getAxisRange(1));
                } else {
                    this.setInternalRange((byte)2, 1, this.getAxisRange(4));
                }
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (this.blockPropertyEvent) {
            return;
        }
        Object source = evt.getSource();
        boolean rc = false;
        if (this.xAxis != null && this.xAxis.getInternalAxis() == source) {
            rc |= this.processAxisPropertyChange(evt, this.xAxis, 0, "X", null);
            rc |= this.processAxisPropertyChange(evt, this.xAxis, 0, "X", "Y");
            rc |= this.processAxisPropertyChange(evt, this.xAxis, 0, "X", "Y2");
        } else if (this.x2Axis != null && this.x2Axis.getInternalAxis() == source) {
            rc |= this.processAxisPropertyChange(evt, this.x2Axis, 0, "X2", null);
            rc |= this.processAxisPropertyChange(evt, this.x2Axis, 0, "X2", "Y");
            rc |= this.processAxisPropertyChange(evt, this.x2Axis, 0, "X2", "Y2");
        } else if (this.yAxis != null && this.yAxis.getInternalAxis() == source) {
            rc |= this.processAxisPropertyChange(evt, this.yAxis, 1, null, "Y");
            rc |= this.processAxisPropertyChange(evt, this.yAxis, 1, "X", "Y");
            rc |= this.processAxisPropertyChange(evt, this.yAxis, 1, "X2", "Y");
        } else if (this.y2Axis != null && this.y2Axis.getInternalAxis() == source) {
            rc |= this.processAxisPropertyChange(evt, this.y2Axis, 4, null, "Y2");
            rc |= this.processAxisPropertyChange(evt, this.y2Axis, 4, "X", "Y2");
            rc |= this.processAxisPropertyChange(evt, this.y2Axis, 4, "X2", "Y2");
        }
        if (rc) {
            this.resetViewport();
        }
    }

    protected boolean processAxisPropertyChange(PropertyChangeEvent evt, AxisComponent axis, int whichAxis, Object whichX, Object whichY) {
        block12: {
            TransformInterface t;
            block11: {
                if (evt == null || axis == null || whichX == null && whichY == null) {
                    return false;
                }
                t = null;
                if (!"AXIS_TRANSFORM_TYPE".equalsIgnoreCase(evt.getPropertyName())) break block11;
                int axisType = ((Number)evt.getNewValue()).intValue();
                switch (axisType) {
                    case 1: {
                        t = this.getTransform(whichX, whichY);
                        if (t instanceof TransformObject) {
                            ((TransformObject)t).setTransformType(whichAxis, 1, null);
                            break;
                        }
                        break block12;
                    }
                    case 2: {
                        t = this.getTransform(whichX, whichY);
                        if (t instanceof TransformObject) {
                            Object transInfo = axis.getInternalAxis().getTransformInfo(2);
                            ((TransformObject)t).setTransformType(whichAxis, 2, transInfo);
                            break;
                        }
                        break block12;
                    }
                    default: {
                        return false;
                    }
                }
                break block12;
            }
            if ("AXIS_LOG_BASE".equalsIgnoreCase(evt.getPropertyName())) {
                t = this.getTransform(whichX, whichY);
                if (t instanceof TransformObject) {
                    ((TransformObject)t).setTransformType(whichAxis, 2, evt.getNewValue());
                }
            } else if ("AXIS_REVERSE".equalsIgnoreCase(evt.getPropertyName()) && evt.getNewValue() instanceof Boolean && (t = this.getTransform(whichX, whichY)) instanceof TransformObject) {
                ((TransformObject)t).setReverse(whichAxis, (Boolean)evt.getNewValue());
            }
        }
        return true;
    }

    @Override
    public boolean setActionEnabled(String action, boolean enable) {
        boolean rc = super.setActionEnabled(action, enable);
        if ("AXIS_PAN".equalsIgnoreCase(action)) {
            this.actions.put("AXIS_PAN", new Boolean(enable));
            if (this.xAxisZoomHandler != null) {
                this.xAxisZoomHandler.setPanEnabled(enable);
            }
            if (this.yAxisZoomHandler != null) {
                this.yAxisZoomHandler.setPanEnabled(enable);
            }
            if (this.x2AxisZoomHandler != null) {
                this.x2AxisZoomHandler.setPanEnabled(enable);
            }
            if (this.y2AxisZoomHandler != null) {
                this.y2AxisZoomHandler.setPanEnabled(enable);
            }
        }
        if ("AXIS_ZOOM".equalsIgnoreCase(action)) {
            this.actions.put("AXIS_ZOOM", new Boolean(enable));
            if (this.xAxisZoomHandler != null) {
                this.xAxisZoomHandler.setZoomMinEnabled(enable);
                this.xAxisZoomHandler.setZoomMaxEnabled(enable);
            }
            if (this.yAxisZoomHandler != null) {
                this.yAxisZoomHandler.setZoomMinEnabled(enable);
                this.yAxisZoomHandler.setZoomMaxEnabled(enable);
            }
            if (this.x2AxisZoomHandler != null) {
                this.x2AxisZoomHandler.setZoomMinEnabled(enable);
                this.x2AxisZoomHandler.setZoomMaxEnabled(enable);
            }
            if (this.y2AxisZoomHandler != null) {
                this.y2AxisZoomHandler.setZoomMinEnabled(enable);
                this.y2AxisZoomHandler.setZoomMaxEnabled(enable);
            }
        }
        return rc;
    }

    public boolean hasViewport() {
        return this.hasViewport;
    }

    class PrimaryDataRange
    implements DataRangeInterface {
        PrimaryDataRange() {
        }

        public void addRangeChangeListener(RangeChangeListener l) {
        }

        public void removeRangeChangeListener(RangeChangeListener l) {
        }

        public DataRange getDataRange(byte dimension) {
            DataRange rc = null;
            switch (dimension) {
                case 1: {
                    if (SILKXYComponent.this.xAxis == null) break;
                    rc = SILKXYComponent.this.getAxisRange(0);
                    break;
                }
                case 2: {
                    if (SILKXYComponent.this.yAxis == null) break;
                    rc = SILKXYComponent.this.getAxisRange(1);
                }
            }
            return rc;
        }
    }

    class SecondaryDataRange
    implements DataRangeInterface {
        SecondaryDataRange() {
        }

        public void addRangeChangeListener(RangeChangeListener l) {
        }

        public void removeRangeChangeListener(RangeChangeListener l) {
        }

        public DataRange getDataRange(byte dimension) {
            DataRange rc = null;
            switch (dimension) {
                case 1: {
                    if (SILKXYComponent.this.x2Axis == null) break;
                    rc = SILKXYComponent.this.getAxisRange(3);
                    break;
                }
                case 2: {
                    if (SILKXYComponent.this.y2Axis == null) break;
                    rc = SILKXYComponent.this.getAxisRange(4);
                }
            }
            return rc;
        }
    }
}

