/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DiagnosticsEvent;
import com.sas.graphics.silk.event.DiagnosticsInterface;
import com.sas.graphics.silk.event.DiagnosticsListener;
import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.ControlInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.ImageListInterface;
import com.sas.graphics.silk.interfaces.LayerInterface;
import com.sas.graphics.silk.interfaces.LayerListenerInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.Footnote;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.Layout;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.Title;
import com.sas.graphics.silk.util.ToolTip;
import com.sas.graphics.silk.util.ToolTipDefaults;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.styles.AttributesTable;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public abstract class SILKComponent
extends JComponent
implements DataFilterListenerInterface,
GraphBackgroundInterface,
GraphInterface,
MouseListener,
MouseMotionListener,
MouseWheelListener,
Pageable,
Printable,
PropertyChangeListener,
RoleInterface,
RoleListenerInterface,
TextListenerInterface,
UpdateInterface,
LayerInterface,
PropertyInterface,
DiagnosticsInterface,
ActionListener,
ControlInterface {
    private static final long serialVersionUID = -2898552706713458356L;
    final String UPARROW = "UPARROW";
    final String DOWNARROW = "DOWNARROW";
    final String LEFTARROW = "LEFTARROW";
    final String RIGHTARROW = "RIGHTARROW";
    final String WKEY = "W_KEY";
    final String SKEY = "S_KEY";
    final String AKEY = "A_KEY";
    final String DKEY = "D_KEY";
    final String PLUS = "PLUS";
    final String MINUS = "MINUS";
    final String ESCAPE = "ESCAPE";
    final String SHIFT = "SHIFT";
    protected boolean allowPopup = true;
    protected boolean dataListen = true;
    protected boolean noToolBar = false;
    protected boolean tipsOn = true;
    protected int compWidth = 0;
    protected int compHeight = 0;
    protected int xMargin = 5;
    protected int yMargin = 5;
    protected int actionMode = 1;
    protected Component toolBar = null;
    protected DataFilterReadInterface dataFilter = null;
    protected DataOptionsDialog dataDlg = null;
    protected GraphBackground background;
    protected ToolTip tooltip;
    protected String tipText = null;
    protected Point tipLocation = null;
    protected ImageListInterface imageList = null;
    protected Style style = null;
    protected RoleManager roles = null;
    protected GraphPropertiesDialog propertiesDialog = null;
    protected Layout graphLayout = null;
    protected SILKNumber currentLegend;
    protected Hashtable legends = null;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
    protected Roles roleIndex = Roles.getInstance(null);
    protected GlobalDefaults silkDefaults = new GlobalDefaults();
    protected boolean useBackBuffer = true;
    protected Vector drilldownListeners = null;
    protected Toolkit tk;
    protected int selectionBehavior = 0;
    protected Color selectColor = Color.black;
    protected boolean selectCrop = true;
    protected boolean isLayerSelectable = true;
    private MouseEvent tempME = null;
    protected PropertyList pending = null;
    protected Object id = null;
    protected int xAxisMapping = 0;
    protected int yAxisMapping = 1;
    protected boolean isControl = false;
    protected boolean canEdit = false;
    protected EventListenerList viewportListeners = null;
    protected ViewportEvent viewportEvent = null;
    private int buildDepth = 0;
    protected boolean buildAfterApplyProperties = false;
    protected int holdBuild = 0;
    private Object lock = new Object();
    public static int[] supportedSILKComponentProperties = new int[]{62, 0, 29, 30, 28, 2, 64, 601, 602, 603};
    protected Hashtable actions = new Hashtable();
    protected UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(supportedSILKComponentProperties);
    private TooltipHandler tooltipHandler = null;
    private Timer tooltipTimer = null;
    protected ToolTipDefaults tipDefaults = null;
    protected EventListenerList diagnosticsListeners = null;
    private DiagnosticsEvent diagnosticsEvent = null;
    protected AnnotateInterface silkAnno = null;
    protected JPopupMenu menu = null;
    public Object mouseEventSource = null;
    protected boolean createLegends = true;
    private PropertyChangeListener attributesTableListener = null;
    protected boolean selectOnDrilldown = true;

    public SILKComponent() {
        this.drilldownListeners = new Vector();
        this.background = new GraphBackground(this);
        this.tooltip = new ToolTip();
        this.tipDefaults = new ToolTipDefaults();
        this.tooltipHandler = new TooltipHandler();
        this.tooltipTimer = new Timer(this.tipDefaults.delay, this.tooltipHandler);
        this.tooltipTimer.start();
        this.silkAnno = this.createAnnotationObject();
        this.graphLayout = new Layout();
        this.graphLayout.setTitle(new Title());
        this.graphLayout.setFootnote(new Footnote());
        this.graphLayout.getTitle().addTextListener(this);
        this.graphLayout.getFootnote().addTextListener(this);
        this.setLayout(null);
        this.roles = new RoleManager();
        this.roles.addRoleListener(this);
        this.tk = this.getToolkit();
        this.tempME = new MouseEvent(this, -1, 0L, 0, 0, 0, 0, false);
        this.pending = new PropertyList();
        this.setPreferredSize(new Dimension(400, 400));
        SILKGlobal.register(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        AttributesTable table = (AttributesTable)SILKGlobal.getInstance().getPropertyValue(50);
        this.attributesTableListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SILKComponent.this.invalidateBackBuffer();
                SILKComponent.this.repaint();
            }
        };
        table.addPropertyChangeListener(this.attributesTableListener);
    }

    private AnnotateInterface createAnnotationObject() {
        Class<?> cls = null;
        try {
            Class.forName("com.sas.graphics.sganno.Annotate");
            cls = Class.forName("com.sas.graphics.silk.util.SILKAnnotate");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (cls == null) {
            return null;
        }
        AnnotateInterface rc = null;
        try {
            rc = (AnnotateInterface)cls.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (rc != null) {
            rc.setComponent(this);
        }
        return rc;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.compWidth = this.getBounds().width;
        this.compHeight = this.getBounds().height;
        this.graphLayout.doLayout(this);
    }

    protected void setupListeners(DataFilterReadInterface oldFilter, DataFilterReadInterface newFilter) {
        if (oldFilter != null) {
            oldFilter.removeDataFilterListener((Object)this);
        }
        if (newFilter != null) {
            newFilter.addDataFilterListener((Object)this);
        }
    }

    public boolean isUsingBackBuffer() {
        return this.useBackBuffer;
    }

    public void setUseBackBuffer(boolean b) {
        this.useBackBuffer = b;
    }

    protected void handleMenuCommand(String command) {
        if (command == null) {
            return;
        }
        if (command.equals("GRAPH_PROPERTIES")) {
            this.buildPropertiesDialog(this);
            this.propertiesDialog.setVisible(true);
        } else if (command.equalsIgnoreCase("DATA_OPTIONS")) {
            this.buildDataDialog();
            this.dataDlg.setVisible(true);
        } else if (command.equals("COPY")) {
            CopyToClipboard.toClipboard(this);
        } else if (command.equals("TOOLBAR")) {
            if (this.getToolBar() != null) {
                this.toolBar.setVisible(true);
            }
        } else if (command.equalsIgnoreCase("ACTION_MODE_BRUSH")) {
            this.setActionMode(1);
        } else if (command.equalsIgnoreCase("ACTION_MODE_DRILLDOWN")) {
            this.setActionMode(8);
        } else if (command.equalsIgnoreCase("ACTION_MODE_EDIT")) {
            this.setActionMode(9);
        } else if (command.equalsIgnoreCase("ACTION_MODE_NONE")) {
            this.setActionMode(0);
        } else if (command.equalsIgnoreCase("ACTION_MODE_PAN")) {
            this.setActionMode(4);
        } else if (command.equalsIgnoreCase("ACTION_MODE_RESET")) {
            this.setActionMode(5);
        } else if (command.equalsIgnoreCase("ACTION_MODE_SELECT")) {
            this.setActionMode(6);
        } else if (command.equalsIgnoreCase("ACTION_MODE_SELECT_REGION")) {
            this.setActionMode(14);
        } else if (command.equalsIgnoreCase("ACTION_MODE_VIEWPORT")) {
            this.setActionMode(2);
        } else if (command.equalsIgnoreCase("ACTION_MODE_ZOOM")) {
            this.setActionMode(3);
        } else if (command.equalsIgnoreCase("ACTION_MODE_GEOMETRIC_ZOOM")) {
            this.setActionMode(10);
        } else if (command.equalsIgnoreCase("ACTION_MODE_GEOMETRIC_PAN")) {
            this.setActionMode(11);
        } else if (command.equalsIgnoreCase("ACTION_MODE_GEOMETRIC_ROTATE")) {
            this.setActionMode(12);
        } else if (command.equalsIgnoreCase("ACTION_MODE_ANNOTATE")) {
            this.setActionMode(13);
        } else if (command.equalsIgnoreCase("DEBUG__SAVE_AS_XML")) {
            SILKParser.saveAsXML(this, null, true);
        }
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
    }

    @Override
    public AxisInterface getAxis(Object which) {
        return null;
    }

    @Override
    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    @Override
    public LegendInterface getLegend(Object which) {
        if (this.legends == null) {
            return null;
        }
        if (which == null) {
            return this.getCurrentLegendObject();
        }
        LegendInterface li = (LegendInterface)this.legends.get(which);
        if (li != null) {
            return li;
        }
        Enumeration e = this.legends.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (!(key instanceof SILKNumber) || !((SILKNumber)((Object)key)).equals(which)) continue;
            return (LegendInterface)this.legends.get(key);
        }
        return null;
    }

    protected LegendInterface getCurrentLegendObject() {
        if (this.legends == null || this.currentLegend == null || !this.legends.containsKey((Object)this.currentLegend)) {
            return null;
        }
        return (LegendInterface)this.legends.get((Object)this.currentLegend);
    }

    protected boolean legendUpdateRequired() {
        if (this.legends == null || this.legends.isEmpty()) {
            return false;
        }
        Enumeration e = this.legends.elements();
        while (e.hasMoreElements()) {
            if (!((LegendObjectJ2D)e.nextElement()).isUpdateRequired()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Component getToolBar() {
        Frame parentFrame;
        Window parent = SwingUtilities.getWindowAncestor(this);
        Frame frame = parentFrame = parent instanceof Frame ? (Frame)parent : null;
        if (!this.noToolBar && this.toolBar == null && (this.toolBar = new SILKToolbar(parentFrame)) != null) {
            ((SILKToolbar)this.toolBar).setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKComponent.Toolbar.txt", (String)"Toolbar"));
            ((SILKToolbar)this.toolBar).addListener(this);
        }
        return this.toolBar;
    }

    @Override
    public boolean setToolBar(Component toolBarIn) {
        this.toolBar = toolBarIn;
        boolean bl = this.noToolBar = this.toolBar == null;
        if (this.toolBar != null && this.toolBar instanceof GraphToolbarInterface) {
            ((GraphToolbarInterface)((Object)this.toolBar)).addListener(this);
        }
        return true;
    }

    protected void buildPropertiesDialog(Object listner) {
        if (this.propertiesDialog != null) {
            return;
        }
        if (listner != null) {
            this.createPropertyDialog(listner);
        } else {
            this.createPropertyDialog(this);
        }
    }

    protected void buildDataDialog() {
        if (this.dataDlg != null) {
            return;
        }
        this.createDataDialog(this);
    }

    public boolean createPropertyDialog(Object listener) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        if (this.propertiesDialog != null) {
            return true;
        }
        Window parent = null;
        if (listener != null && listener instanceof Component) {
            parent = SwingUtilities.getWindowAncestor(this);
        }
        String title = ResourceLoader.getResourceString((Object)this.rb, (String)"SILKComponent.Properties.txt", (String)"Properties");
        if (parent == null || parent instanceof Frame) {
            this.propertiesDialog = new GraphPropertiesDialog((Frame)parent, title);
        } else if (parent instanceof Dialog) {
            this.propertiesDialog = new GraphPropertiesDialog((Dialog)parent, title);
        }
        if (listener == null) {
            this.propertiesDialog.addPropertyListener(this);
        }
        return true;
    }

    public boolean createDataDialog(Object listener) {
        if (this.dataDlg != null) {
            return true;
        }
        Window parent = null;
        if (listener != null && listener instanceof Component) {
            parent = SwingUtilities.getWindowAncestor(this);
        }
        if (parent == null || parent instanceof Frame) {
            this.dataDlg = new DataOptionsDialog((Frame)parent);
        } else if (parent instanceof Dialog) {
            this.dataDlg = new DataOptionsDialog((Dialog)parent);
        }
        this.dataDlg.addChart(this);
        UIUtilities.center(this.dataDlg, UIUtilities.getParentFrame(this));
        return true;
    }

    @Override
    public Dialog getDialog(Object id, Object listner) {
        if (id.toString().equalsIgnoreCase("Properties")) {
            if (this.propertiesDialog == null) {
                this.createPropertyDialog(listner);
                this.buildPropertiesDialog(listner);
            }
            return this.propertiesDialog;
        }
        if (id.toString().equalsIgnoreCase("Data")) {
            this.createDataDialog(listner);
            return this.dataDlg;
        }
        return null;
    }

    @Override
    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        return false;
    }

    @Override
    public int getActionMode() {
        return this.actionMode;
    }

    @Override
    public boolean setActionMode(int mode) {
        switch (mode) {
            case 5: {
                return this.resetComponent();
            }
            case 1: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_BRUSH", true);
                break;
            }
            case 2: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_VIEWPORT", true);
                break;
            }
            case 3: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_ZOOM", true);
                break;
            }
            case 4: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_PAN", true);
                break;
            }
            case 0: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_NONE", true);
                break;
            }
            case 6: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_SELECT", true);
                break;
            }
            case 14: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_SELECT_REGION", true);
                break;
            }
            case 8: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_DRILLDOWN", true);
                break;
            }
            case 10: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_GEOMETRIC_ZOOM", true);
                break;
            }
            case 11: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_GEOMETRIC_PAN", true);
                break;
            }
            case 12: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_GEOMETRIC_ROTATE", true);
                break;
            }
            case 13: {
                if (this.silkAnno == null) {
                    return false;
                }
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_ANNOTATE", true);
                break;
            }
            case 9: {
                if (this.canEdit) break;
                return false;
            }
            default: {
                return false;
            }
        }
        this.actionMode = mode;
        return true;
    }

    public boolean resetComponent() {
        return true;
    }

    @Override
    public boolean areChartTipsOn() {
        return this.tipsOn;
    }

    @Override
    public void setChartTipsOn(boolean on) {
        if (this.tipsOn == on) {
            return;
        }
        this.tipsOn = on;
        this.userSetProperties.set(2);
    }

    @Override
    public TipInterface getChartTip() {
        return this.tooltip;
    }

    @Override
    public String getStyle() {
        return this.style.getSchemeName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setStyle(Object o) {
        if (this.isControl) {
            o = SILKGlobal.getInstance().getPropertyValue(49);
        }
        if (o == null) {
            this.style = null;
        } else {
            if (o.equals(this.style)) {
                return true;
            }
            if (o instanceof Style) {
                this.style = (Style)o;
                this.style.setFallbackEnabled(true);
            } else if (o instanceof String) {
                StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
                if (sc.getStyle((String)o) == null) return false;
                this.style = sc.getStyle((String)o);
            } else {
                if (!(o instanceof ColorScheme)) return false;
                this.style = ((ColorScheme)o).getStyle();
            }
        }
        if (this.style == null) {
            return false;
        }
        Color bc = this.style.getFillStyleElement("Backfill").getFillColor();
        this.background.setSolidBackground(bc);
        this.background.setCurrentValueAsDefault(21);
        this.tooltip.applyStyle(this.style);
        this.graphLayout.applyStyle(this.style);
        this.userSetProperties.set(0);
        if (this.style.getSchemeName().equalsIgnoreCase("SILKDefault")) {
            this.userSetProperties.clear(0);
        }
        this.repaint();
        return true;
    }

    public ImageListInterface getImageList() {
        return this.imageList;
    }

    public boolean setImageList(ImageListInterface ili) {
        this.imageList = ili;
        return true;
    }

    @Override
    public ColorSchemeInterface getColorScheme() {
        return new ColorScheme(this.style);
    }

    @Override
    public String getColorSchemeName() {
        return this.style.getSchemeName();
    }

    @Override
    public boolean setColorScheme(Object newScheme) {
        return this.setStyle(newScheme);
    }

    @Override
    public DataFilterReadInterface getFilter() {
        return this.dataFilter;
    }

    @Override
    public DataFilterReadInterface getFilter(Object id) {
        return this.getFilter();
    }

    @Override
    public synchronized boolean setDataListening(boolean listen) {
        if (this.dataFilter != null) {
            if (listen) {
                this.dataFilter.addDataFilterListener((Object)this);
            } else {
                this.dataFilter.removeDataFilterListener((Object)this);
            }
        }
        this.dataListen = listen;
        return true;
    }

    @Override
    public boolean isDataListening() {
        return this.dataListen;
    }

    @Override
    public String getWhereClause() {
        if (this.dataFilter == null) {
            return null;
        }
        return this.dataFilter.getWhereClause();
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.dataFilter == null) {
            return false;
        }
        return this.dataFilter.applyWhereClause(clause, clearPrevious);
    }

    @Override
    public boolean setTitle(int index, String textString) {
        Title titles = this.graphLayout.getTitle();
        if (titles == null || !titles.setTitle(index, textString)) {
            return false;
        }
        titles.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        return true;
    }

    @Override
    public boolean setTitle(int index, TextStyleInterface textObject) {
        Title titles = this.graphLayout.getTitle();
        if (titles == null || !titles.setTitle(index, textObject)) {
            return false;
        }
        titles.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        return true;
    }

    @Override
    public TextStyleInterface getTitle(int index) {
        Title titles = this.graphLayout.getTitle();
        if (titles == null) {
            return null;
        }
        return titles.getTitle(index);
    }

    @Override
    public boolean setFootnote(int index, String textString) {
        Footnote footnotes = this.graphLayout.getFootnote();
        if (footnotes == null || !footnotes.setFootnote(index, textString)) {
            return false;
        }
        footnotes.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        return true;
    }

    @Override
    public boolean setFootnote(int index, TextStyleInterface textObject) {
        Footnote footnotes = this.graphLayout.getFootnote();
        if (footnotes == null || !footnotes.setFootnote(index, textObject)) {
            return false;
        }
        footnotes.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        return true;
    }

    @Override
    public TextStyleInterface getFootnote(int index) {
        Footnote footnotes = this.graphLayout.getFootnote();
        if (footnotes == null) {
            return null;
        }
        return footnotes.getFootnote(index);
    }

    @Override
    public Object getLegendPosition(Object which) {
        LegendInterface leg = this.getLegend(which);
        if (leg == null) {
            return null;
        }
        return new Integer(leg.getPosition());
    }

    @Override
    public boolean setLegendPosition(Object which, Object positionIn) {
        if (positionIn == null) {
            return false;
        }
        LegendInterface leg = this.getLegend(which);
        if (leg == null) {
            return false;
        }
        int position = 2;
        if (positionIn instanceof Number) {
            position = ((Number)positionIn).intValue();
        } else {
            String s = positionIn.toString();
            if (s.equalsIgnoreCase("East")) {
                position = 3;
            } else if (s.equalsIgnoreCase("West")) {
                position = 4;
            } else if (s.equalsIgnoreCase("North")) {
                position = 1;
            } else if (s.equalsIgnoreCase("Northeast")) {
                position = 6;
            } else if (s.equalsIgnoreCase("Northwest")) {
                position = 7;
            } else if (s.equalsIgnoreCase("South")) {
                position = 2;
            } else if (s.equalsIgnoreCase("Southeast")) {
                position = 8;
            } else if (s.equalsIgnoreCase("Southwest")) {
                position = 9;
            }
        }
        leg.setPosition(position);
        return true;
    }

    @Override
    public Rectangle getLegendBounds() {
        return null;
    }

    @Override
    public boolean setLegendBounds(Rectangle rect) {
        return false;
    }

    @Override
    public synchronized void enablePopup(boolean on) {
        this.allowPopup = on;
    }

    @Override
    public void dispose() {
        if (this.dataFilter != null) {
            this.setupListeners(this.dataFilter, null);
            this.dataFilter = null;
        }
        if (this.background != null) {
            this.background.dispose();
        }
        this.tooltip = null;
        this.tipLocation = null;
        this.tooltip = null;
        this.tipDefaults = null;
        if (this.tooltipTimer != null) {
            this.tooltipTimer.stop();
        }
        if (this.tooltipHandler != null) {
            this.tooltipTimer.removeActionListener(this.tooltipHandler);
        }
        this.tooltipTimer = null;
        this.tooltipHandler = null;
        this.imageList = null;
        this.style = null;
        this.roles = null;
        if (this.propertiesDialog != null) {
            this.propertiesDialog.setVisible(false);
            this.propertiesDialog.dispose();
        }
        this.propertiesDialog = null;
        if (this.dataDlg != null) {
            this.dataDlg.setVisible(false);
            this.dataDlg.dispose();
        }
        this.dataDlg = null;
        if (this.silkAnno != null) {
            this.silkAnno.dispose();
        }
        this.silkAnno = null;
        AttributesTable table = (AttributesTable)SILKGlobal.getInstance().getPropertyValue(50);
        if (table != null && this.attributesTableListener != null) {
            table.removePropertyChangeListener(this.attributesTableListener);
        }
        this.attributesTableListener = null;
        SILKGlobal.unregister(this);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.menu;
    }

    @Override
    public boolean isBackBufferDrawEnabled() {
        return this.useBackBuffer;
    }

    @Override
    public boolean isModelAttributeHonored(Object attribute) {
        return false;
    }

    @Override
    public void setBackBufferDrawEnabled(boolean drawback) {
        this.useBackBuffer = drawback;
    }

    @Override
    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        return false;
    }

    @Override
    public int getSelectionBehavior() {
        return this.selectionBehavior;
    }

    @Override
    public Object getSelectionBehaviorValue() {
        Serializable rc = null;
        switch (this.selectionBehavior) {
            case 0: {
                break;
            }
            case 1: {
                rc = this.selectColor;
                break;
            }
            case 2: {
                rc = new Boolean(this.selectCrop);
            }
        }
        return rc;
    }

    @Override
    public boolean setSelectionBehavior(int behavior, Object value) {
        boolean rc = false;
        switch (behavior) {
            case 0: {
                this.selectionBehavior = behavior;
                rc = this.setHonorModelAttribute(GraphInterface.MODEL_COLOR, true);
                break;
            }
            case 1: {
                this.selectionBehavior = behavior;
                if (value instanceof Color) {
                    this.selectColor = (Color)value;
                }
                rc = this.setHonorModelAttribute(GraphInterface.MODEL_COLOR, true);
                break;
            }
            case 2: {
                this.selectionBehavior = behavior;
                if (value instanceof Boolean) {
                    this.selectCrop = (Boolean)value;
                }
                rc = this.setHonorModelAttribute(GraphInterface.MODEL_GRAPHED, true);
            }
        }
        return rc;
    }

    @Override
    public boolean getUsageMode(int mode) {
        return false;
    }

    @Override
    public void setUsageMode(int mode, boolean on) {
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return this.addTabs(id, dialogIn, category, this);
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        if (id == null || dialogIn == null) {
            return false;
        }
        SILKComponent pi = this;
        if (listener != null && listener instanceof PropertyInterface) {
            pi = (PropertyInterface)listener;
        }
        ToolTip tt = this.tooltip;
        if (listener != null && listener instanceof PropertyInterface) {
            tt = (PropertyInterface)listener;
        }
        JComponent jc = this;
        if (listener != null && listener instanceof JComponent) {
            jc = (JComponent)listener;
        }
        if (id.equals("Properties")) {
            if (dialogIn instanceof TabbedPropertiesDialog) {
                boolean graph = false;
                boolean titles = false;
                switch (category) {
                    case 0: {
                        graph = true;
                        break;
                    }
                    case 4: {
                        titles = true;
                        break;
                    }
                    case 999: {
                        titles = true;
                        graph = true;
                    }
                }
                TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)dialogIn;
                TabPanelInterface tpi = null;
                if (graph) {
                    tpi = tpd.getTab(GraphPanel.class);
                    if (tpi != null) {
                        tpi.addPropertyListener(pi);
                    } else {
                        tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKComponent.Graph.txt", (String)"Graph"), new GraphPanel(pi, tt));
                    }
                }
                if (titles) {
                    tpi = tpd.getTab(TitlePanel.class);
                    if (tpi != null) {
                        tpi.addPropertyListener(pi);
                    } else {
                        tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKComponent.Title_Footnote.txt", (String)"Title_Footnote"), new TitlePanel(pi, jc));
                    }
                }
            } else if (dialogIn instanceof GraphPropertiesDialog) {
                Component panel;
                GraphPropertiesDialog.PropertiesTreeNode node;
                boolean graph = false;
                boolean titles = false;
                switch (category) {
                    case 0: {
                        graph = true;
                        break;
                    }
                    case 4: {
                        titles = true;
                        break;
                    }
                    case 999: {
                        titles = true;
                        graph = true;
                    }
                }
                GraphPropertiesDialog gpd = (GraphPropertiesDialog)dialogIn;
                if (graph) {
                    node = gpd.getRootNode("Graph", true);
                    node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKComponent.Graph.txt", (String)"Graph"));
                    panel = node.getPanel();
                    if (panel instanceof GraphPanel) {
                        ((GraphPanel)panel).addPropertyListener(pi);
                    } else if (panel == null) {
                        node.setPanel(new GraphPanel(pi, tt));
                    }
                }
                if (titles) {
                    node = gpd.getRootNode("Title", true);
                    node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"SILKComponent.Title_Footnote.txt", (String)"Title/Footnote"));
                    panel = node.getPanel();
                    if (panel instanceof TitlePanel) {
                        ((TitlePanel)panel).addPropertyListener(pi);
                    } else if (panel == null) {
                        node.setPanel(new TitlePanel(pi, jc));
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void addViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (this.viewportListeners == null) {
            this.viewportListeners = new EventListenerList();
        }
        this.viewportListeners.add(ViewportListenerInterface.class, (ViewportListenerInterface)listener);
    }

    @Override
    public void removeViewportListener(Object listener) {
        if (this.viewportListeners != null && listener instanceof ViewportListenerInterface) {
            this.viewportListeners.remove(ViewportListenerInterface.class, (ViewportListenerInterface)listener);
        }
    }

    protected void fireViewportChangeEvent(Object source, int type, double xMin, double xMax, double yMin, double yMax, double zMin, double zMax) {
        if (this.viewportListeners == null) {
            return;
        }
        if (this.viewportEvent == null) {
            this.viewportEvent = new ViewportEvent(source, type, xMin, xMax, yMin, yMax, zMin, zMax);
        } else {
            this.viewportEvent.source = source;
            this.viewportEvent.type = type;
            this.viewportEvent.xMin = xMin;
            this.viewportEvent.xMax = xMax;
            this.viewportEvent.yMin = yMin;
            this.viewportEvent.yMax = yMax;
            this.viewportEvent.zMin = zMin;
            this.viewportEvent.zMax = zMax;
        }
        EventListener[] vl = this.viewportListeners.getListeners(ViewportListenerInterface.class);
        for (int i = 0; i < vl.length; ++i) {
            ((ViewportListenerInterface)vl[i]).viewportChanged(this.viewportEvent);
        }
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object newId) {
        this.id = newId;
    }

    @Override
    public boolean isEditable() {
        return this.canEdit;
    }

    @Override
    public boolean setEditable(boolean editable) {
        this.canEdit = editable;
        return true;
    }

    @Override
    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public Object getChart(Object id) {
        return null;
    }

    @Override
    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    @Override
    public boolean isActionEnabled(String action) {
        return true;
    }

    @Override
    public AnnotateInterface getAnnotate() {
        return this.silkAnno;
    }

    @Override
    public abstract String getToolTipText(MouseEvent var1);

    @Override
    public void mouseEntered(MouseEvent me) {
        if (this.tooltipTimer != null) {
            this.tooltipTimer.removeActionListener(this.tooltipHandler);
            this.tooltipTimer.addActionListener(this.tooltipHandler);
            this.tooltipTimer.restart();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.tipLocation = me.getPoint();
        this.tipText = null;
        this.tooltipTimer.restart();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.tooltipTimer.restart();
        this.tipLocation = me.getPoint();
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.tipText = null;
        this.tooltipTimer.removeActionListener(this.tooltipHandler);
        this.tooltipTimer.stop();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.tooltipTimer.restart();
        this.tipText = null;
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        this.tipLocation.x = me.getX();
        this.tipLocation.y = me.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.tooltipTimer.restart();
        this.tipText = null;
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        this.tipLocation.x = e.getX();
        this.tipLocation.y = e.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        this.tipLocation.x = e.getX();
        this.tipLocation.y = e.getY();
        this.tipText = null;
        this.tooltipTimer.restart();
        this.mouseEventSource = e.getSource();
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.tooltipTimer.restart();
        this.tipText = null;
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        this.tipLocation.x = e.getX();
        this.tipLocation.y = e.getY();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Point p;
        this.tooltipTimer.restart();
        this.tipText = null;
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        if ((p = this.getMousePosition()) != null) {
            this.tipLocation.x = p.x;
            this.tipLocation.y = p.y;
        } else {
            this.tipLocation.x = -1;
            this.tipLocation.y = -1;
        }
    }

    @Override
    public Object[] getGraphBackground() {
        return this.background.getGraphBackground();
    }

    @Override
    public boolean supportsGradientBackground() {
        return this.background.supportsGradientBackground();
    }

    @Override
    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        return this.background.setGradientBackground(startColor, endColor, orientation);
    }

    @Override
    public boolean supportsImageBackground() {
        return this.background.supportsImageBackground();
    }

    @Override
    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        return this.background.setImageBackground(img, fitStyle, x, y, blend);
    }

    @Override
    public Color getSolidBackground() {
        return this.background.getSolidBackground();
    }

    @Override
    public boolean setSolidBackground(Object c) {
        return this.background.setSolidBackground(c);
    }

    @Override
    public void redrawGraphBackground(Component c) {
        this.background.redrawGraphBackground(this);
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource(Object id) {
        if (this.dataFilter == null) {
            return null;
        }
        return this.dataFilter.getSource();
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public boolean setDataSource(Object source, Object id) {
        DataFilterReadInterface filter = null;
        if (source == null) {
            return false;
        }
        filter = FilterFactory.getDataSourceFilter((Object)source);
        if (filter == null) {
            return false;
        }
        if (this.dataListen) {
            this.setupListeners(this.dataFilter, filter);
        }
        this.dataDlg = null;
        this.dataFilter = filter;
        return true;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    @Override
    public Object getAllVariables(Object role) {
        if (this.roles == null) {
            return null;
        }
        return this.roles.getVariable(role);
    }

    @Override
    public Object getVariable(Object role) {
        if (this.roles == null) {
            return null;
        }
        return this.roles.getVariable(role, 0);
    }

    @Override
    public Object getRole(Object variableId) {
        if (this.roles == null) {
            return null;
        }
        return this.roles.getRole(variableId);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (this.roles == null) {
            return false;
        }
        return this.roles.setRole(variableId, role);
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (this.roles == null) {
            return false;
        }
        return this.roles.addRole(variableId, role);
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        if (this.roles == null) {
            return false;
        }
        return this.roles.removeRole(variableId, role);
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        return null;
    }

    @Override
    public boolean isDiscrete(Object role) {
        if (this.roles == null) {
            return false;
        }
        return this.roles.isDiscrete(role);
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.roles == null) {
            return false;
        }
        return this.roles.setDiscrete(role, discrete);
    }

    @Override
    public abstract Object[] getSupportedRoles(Object var1, boolean var2);

    @Override
    public int getMaxAllowed(Object role) {
        if (this.roles == null) {
            return -1;
        }
        return this.roles.getMaxAllowed(role);
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        if (this.roles == null) {
            return false;
        }
        return this.roles.supportsMultipleAssignments(role);
    }

    @Override
    public Object getSortOrder(Object variableId) {
        if (this.roles == null) {
            return null;
        }
        return this.roles.getSortOrder(variableId);
    }

    @Override
    public boolean setSortOrder(Object variableId, Object order) {
        if (this.roles == null) {
            return false;
        }
        return this.roles.setSortOrder(variableId, order);
    }

    @Override
    public void addRoleListener(RoleListenerInterface rli) {
        if (this.roles != null) {
            this.roles.addRoleListener(rli);
        }
    }

    @Override
    public void removeRoleListener(RoleListenerInterface rli) {
        if (this.roles != null) {
            this.roles.removeRoleListener(rli);
        }
    }

    @Override
    public Object getLimit(Object role) {
        if (this.roles == null) {
            return null;
        }
        return this.roles.getLimit(role);
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        if (this.roles == null) {
            return false;
        }
        return this.roles.setLimit(role, value);
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        if (this.roles == null) {
            return null;
        }
        return this.roles.getSupportedSortableRoles();
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (this.roles == null) {
            return null;
        }
        return this.roles.getSupportedSortDirections(role);
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    @Override
    public void textUpdated(DvrTextEvent evt) {
        this.graphLayout.doLayout(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.toolBar != null) {
            this.toolBar.setVisible(false);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        Graphics2D g = (Graphics2D)graphics;
        int maxWidth = (int)pageFormat.getImageableWidth();
        if (this.silkDefaults != null && this.silkDefaults.maxPrintableResolutionX > 0) {
            maxWidth = Math.min(maxWidth, this.silkDefaults.maxPrintableResolutionX);
        }
        int maxHeight = (int)pageFormat.getImageableHeight();
        if (this.silkDefaults != null && this.silkDefaults.maxPrintableResolutionY > 0) {
            maxHeight = Math.min(maxHeight, this.silkDefaults.maxPrintableResolutionY);
        }
        switch (pageIndex) {
            case 0: {
                int newHeight;
                int newWidth;
                boolean wasUsingBackBuffer = this.isUsingBackBuffer();
                this.setUseBackBuffer(false);
                int oldWidth = this.compWidth;
                int oldHeight = this.compHeight;
                double compAspect = (double)this.compWidth / (double)this.compHeight;
                double maxAspect = (double)maxWidth / (double)maxHeight;
                if (compAspect == maxAspect) {
                    newWidth = maxWidth;
                    newHeight = maxHeight;
                } else if (compAspect > maxAspect) {
                    newWidth = maxWidth;
                    newHeight = (int)((double)newWidth / compAspect);
                } else {
                    newHeight = maxHeight;
                    newWidth = (int)((double)newHeight * compAspect);
                }
                int xTrans = (int)Math.max((pageFormat.getImageableWidth() - (double)newWidth) / 2.0, 0.0);
                int yTrans = (int)Math.max((pageFormat.getImageableHeight() - (double)newHeight) / 2.0, 0.0);
                AffineTransform defaultXfm = g.getTransform();
                AffineTransform xfm = new AffineTransform(defaultXfm);
                xfm.translate(pageFormat.getImageableX() + (double)xTrans, pageFormat.getImageableY() + (double)yTrans);
                g.setTransform(xfm);
                this.compWidth = newWidth;
                this.compHeight = newHeight;
                this.build(Boolean.TRUE);
                this.paint(graphics);
                this.compWidth = oldWidth;
                this.compHeight = oldHeight;
                this.build(Boolean.TRUE);
                this.setUseBackBuffer(wasUsingBackBuffer);
                return 0;
            }
        }
        return 1;
    }

    @Override
    public int getNumberOfPages() {
        return 1;
    }

    @Override
    public PageFormat getPageFormat(int arg0) throws IndexOutOfBoundsException {
        if (arg0 < 0 || arg0 >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException();
        }
        return (PageFormat)SILKGlobal.getInstance().getPropertyValue(57);
    }

    @Override
    public Printable getPrintable(int arg0) throws IndexOutOfBoundsException {
        if (arg0 < 0 || arg0 >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public boolean create(Object createData) {
        return true;
    }

    @Override
    public boolean isRebuildRequired() {
        return false;
    }

    @Override
    public boolean build(Object buildData) {
        return true;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        this.increaseBuildDepth();
        this.build(buildData);
        this.decreaseBuildDepth();
        this.invalidateBackBuffer();
        return true;
    }

    @Override
    public void roleChanged(RoleEvent arg0) {
    }

    @Override
    public void addDrilldownListener(DrilldownListenerInterface dli) {
        if (dli != null) {
            this.drilldownListeners.addElement(dli);
        }
    }

    @Override
    public void removeDrilldownListener(DrilldownListenerInterface dli) {
        if (dli != null && this.drilldownListeners.contains(dli)) {
            this.drilldownListeners.removeElement(dli);
        }
    }

    protected void fireDrilldownEvent(String s) {
        DrilldownEvent de = new DrilldownEvent(s);
        for (int i = 0; i < this.drilldownListeners.size(); ++i) {
            ((DrilldownListenerInterface)this.drilldownListeners.elementAt(i)).drilldown(de);
        }
    }

    protected void fireDrillDownEvent(Hashtable drillData) {
        DrilldownEvent de = new DrilldownEvent();
        de.setDrilldownContext(drillData);
        for (int i = 0; i < this.drilldownListeners.size(); ++i) {
            ((DrilldownListenerInterface)this.drilldownListeners.elementAt(i)).drilldown(de);
        }
    }

    protected void doResize(int compWidthIn, int compHeightIn) {
        if (compWidthIn == this.compWidth && compHeightIn == this.compHeight) {
            return;
        }
        this.compWidth = compWidthIn;
        this.compHeight = compHeightIn;
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.doResize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.doResize(width, height);
    }

    protected Cursor getCustomCursor(int x, int y, String imgName) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        Image img = null;
        if (imgName == null || this.tk == null) {
            return null;
        }
        img = ResourceLoader.getImage((Component)this, (String)imgName);
        if (img == null) {
            return null;
        }
        return this.tk.createCustomCursor(img, new Point(x, y), imgName);
    }

    @Override
    public void drawLayer(Graphics g) {
    }

    @Override
    public void drawLayerSelections(Graphics g) {
    }

    @Override
    public boolean isSelectable() {
        return this.isLayerSelectable;
    }

    @Override
    public boolean setSelectable(boolean selectable) {
        this.isLayerSelectable = selectable;
        return true;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        return false;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        this.tempME.translatePoint(-this.tempME.getX(), -this.tempME.getY());
        this.tempME.translatePoint(screenX, screenY);
        return this.getToolTipText(this.tempME);
    }

    @Override
    public TabPanelInterface getChartTab() {
        return this.getChartTab(this);
    }

    @Override
    public TabPanelInterface getChartTab(Object listener) {
        return null;
    }

    @Override
    public int getDataRangeType(byte dimension) {
        return 1;
    }

    @Override
    public int getXAxisMapping() {
        return this.xAxisMapping;
    }

    @Override
    public boolean setXAxisMapping(int mapping) {
        if (mapping == 0 || mapping == 3) {
            this.xAxisMapping = mapping;
            return true;
        }
        return false;
    }

    @Override
    public int getYAxisMapping() {
        return this.yAxisMapping;
    }

    @Override
    public boolean setYAxisMapping(int mapping) {
        if (mapping == 1 || mapping == 4) {
            this.yAxisMapping = mapping;
            return true;
        }
        return false;
    }

    @Override
    public void addLayerListener(LayerListenerInterface lli) {
    }

    @Override
    public void removeLayerListener(LayerListenerInterface lli) {
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 0: {
                this.setColorScheme(value);
                break;
            }
            case 29: {
                if (this.isControl) break;
                this.setStyle(value);
                break;
            }
            case 30: {
                if (!(value instanceof ImageListInterface)) break;
                this.setImageList((ImageListInterface)value);
                break;
            }
            case 2: {
                if (!(value instanceof Boolean)) break;
                this.setChartTipsOn((Boolean)value);
                break;
            }
            case 32: {
                if (!(value instanceof Number)) break;
                this.xMargin = ((Number)value).intValue();
                this.graphLayout.setComponentXMargin(this.xMargin);
                break;
            }
            case 33: {
                if (!(value instanceof Number)) break;
                this.yMargin = ((Number)value).intValue();
                this.graphLayout.setComponentYMargin(this.yMargin);
                break;
            }
            case 62: {
                this.setId(value);
                break;
            }
            case 63: {
                if (!(value instanceof Boolean) || this.graphLayout == null) break;
                this.graphLayout.setDrawBorder((Boolean)value);
                break;
            }
            case 64: {
                if (!(value instanceof Boolean)) break;
                this.createLegends = (Boolean)value;
                this.userSetProperties.set(64);
            }
        }
    }

    public boolean applyPropertyChanges(Object source) {
        Vector changes;
        boolean rc = true;
        int[] pendingChanges = this.getPendingChanges(source);
        if (pendingChanges != null) {
            this.buildAfterApplyProperties |= pendingChanges.length > 0;
        }
        if (this.background != null) {
            boolean bl = rc = this.background.applyPropertyChanges(source) && rc;
        }
        if (this.tooltip != null) {
            boolean bl = rc = this.tooltip.applyPropertyChanges(source) && rc;
        }
        if ((changes = this.pending.getChangesBySource(source)).size() > 0) {
            rc = true;
            for (int i = 0; i < changes.size(); ++i) {
                PropertyEvent event = (PropertyEvent)changes.elementAt(i);
                int key = event.id;
                Object value = event.value;
                this.applyChange(key, value);
            }
        }
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        if (this.buildAfterApplyProperties) {
            this.buildAndDraw(Boolean.TRUE, null, null);
        }
        this.buildAfterApplyProperties = false;
        this.pending.removeChangesBySource(source);
        return rc;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.tooltip.cancelPropertyChanges(source);
        this.pending.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    protected void addPendingChanges(PropertyInterface p, Object source, Vector v) {
        if (v == null || p == null) {
            return;
        }
        int[] list = p.getPendingChanges(source);
        if (list != null && list.length > 0) {
            for (int i = 0; i < list.length; ++i) {
                v.add(new Integer(list[i]));
            }
        }
    }

    public int[] getPendingChanges(Object source) {
        Vector<Integer> v = new Vector<Integer>();
        if (this.tooltip != null) {
            this.addPendingChanges(this.tooltip, source, v);
        }
        if (this.background != null) {
            this.addPendingChanges(this.background, source, v);
        }
        this.addPendingChanges(this.graphLayout.getTitle(), source, v);
        this.addPendingChanges(this.graphLayout.getFootnote(), source, v);
        int[] list = this.pending.getPending(source);
        if (list != null && list.length > 0) {
            for (int i = 0; i < list.length; ++i) {
                v.add(new Integer(list[i]));
            }
        }
        int[] pending = null;
        if (v.size() > 0) {
            pending = new int[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                pending[i] = ((Number)v.elementAt(i)).intValue();
            }
        }
        return pending;
    }

    public Object getPropertyValue(int id) {
        if (this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        Object rc = null;
        if (this.tooltip != null && this.tooltip.isPropertySupported(id)) {
            return this.tooltip.getPropertyValue(id);
        }
        switch (id) {
            case 65: {
                rc = this.userSetProperties.getSupportedProperties();
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                rc = this.background.getPropertyValue(id);
                break;
            }
            case 0: {
                rc = this.getColorScheme();
                break;
            }
            case 29: {
                rc = this.style;
                break;
            }
            case 62: {
                rc = this.getId();
                break;
            }
            case 30: {
                rc = this.imageList;
                break;
            }
            case 28: {
                rc = new Boolean(this.imageList != null);
                break;
            }
            case 2: {
                rc = new Boolean(this.tipsOn);
                break;
            }
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 59: {
                rc = this.getCurrentLegendObject();
                break;
            }
            case 601: {
                rc = this.graphLayout.getTitle().getTitle(0);
                break;
            }
            case 602: {
                rc = this.graphLayout.getTitle().getTitle(1);
                break;
            }
            case 603: {
                rc = this.graphLayout.getFootnote().getFootnote(0);
                break;
            }
            case 64: {
                rc = this.createLegends ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return rc;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        if (this.background.isPropertySupported(id)) {
            return true;
        }
        if (this.tooltip.isPropertySupported(id)) {
            return true;
        }
        return id == 0 || id == 29 || id == 30 || id == 28 || id == 2 || id == 32 || id == 33 || id == 62 || id == 601 || id == 602 || id == 603 || id == 63 || id == 64;
    }

    public boolean setPropertyValue(int id, Object value) {
        boolean rc = false;
        if (id == 23 && value instanceof SILKNumber) {
            this.currentLegend = (SILKNumber)((Object)value);
            return true;
        }
        if (this.background != null && this.background.isPropertySupported(id)) {
            rc = this.background.setPropertyValue(id, value);
        }
        if (this.tooltip != null && this.tooltip.isPropertySupported(id)) {
            rc = this.tooltip.setPropertyValue(id, value);
        }
        if (this.isPropertySupported(id)) {
            rc |= this.pending.store(id, value);
        }
        return rc;
    }

    public boolean hasUserSetValue(int id) {
        if (this.userSetProperties.hasProperty(id)) {
            return this.userSetProperties.get(id);
        }
        if (this.background != null && this.background.isPropertySupported(id)) {
            return this.background.hasUserSetValue(id);
        }
        return false;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.tipsOn) {
            return;
        }
        if (this.tooltip != null && this.tipText != null && g instanceof Graphics2D) {
            this.tooltip.paint(this, (Graphics2D)g, this.tipLocation, this.tipText);
        }
    }

    protected void invalidateBackBuffer() {
    }

    @Override
    public void addDiagnosticsListener(DiagnosticsListener dl) {
        if (this.diagnosticsListeners == null) {
            this.diagnosticsListeners = new EventListenerList();
        }
        this.diagnosticsListeners.add(DiagnosticsListener.class, dl);
    }

    @Override
    public void removeDiagnosticsListener(DiagnosticsListener dl) {
        if (this.diagnosticsListeners == null) {
            return;
        }
        this.diagnosticsListeners.remove(DiagnosticsListener.class, dl);
    }

    protected DiagnosticsEvent getDiagnosticsEvent() {
        if (this.diagnosticsEvent == null) {
            this.diagnosticsEvent = new DiagnosticsEvent(this);
        }
        return this.diagnosticsEvent;
    }

    protected void fireDiagnosticsEvent(int type) {
        if (this.diagnosticsListeners == null || this.diagnosticsListeners.getListenerCount() == 0) {
            return;
        }
        this.getDiagnosticsEvent().setType(type);
        EventListener[] list = this.diagnosticsListeners.getListeners(DiagnosticsListener.class);
        for (int i = 0; i < list.length; ++i) {
            ((DiagnosticsListener)list[i]).diagnosticsEvent(this.getDiagnosticsEvent());
        }
        this.getDiagnosticsEvent().getTable().clear();
    }

    protected boolean isTakingDiagnostics(int flag) {
        if (this.diagnosticsListeners == null || this.diagnosticsListeners.getListenerCount() == 0) {
            return false;
        }
        return SILKGlobal.isFlagSet(flag);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public boolean isControlMode() {
        return this.isControl;
    }

    @Override
    public void setControlMode(boolean isControl) {
        this.isControl = isControl;
        if (isControl) {
            this.setStyle(SILKGlobal.getInstance().getPropertyValue(49));
        }
    }

    protected void suspendTooltipTimer() {
        if (this.tooltipTimer != null) {
            this.tooltipTimer.stop();
        }
    }

    @Override
    public String toString() {
        if (this.id == null) {
            if (SILKChartInfo.getInstance(this) != null) {
                return SILKChartInfo.getInstance(this).getDisplayName();
            }
            return super.toString();
        }
        return this.id.toString();
    }

    protected String getMenuXMLPath() {
        return "/com/sas/graphics/silk/util/menus/StandardMenu.xml";
    }

    protected void initializeMenu(ActionListener listener) {
        this.initializeMenu(listener, false);
    }

    protected void initializeMenu(ActionListener listener, boolean rebuildPopup) {
        if (listener == null) {
            listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String actionCommand = e.getActionCommand();
                    SILKComponent.this.handleMenuCommand(actionCommand);
                }
            };
        }
        if (this.menu == null || rebuildPopup) {
            this.menu = MenuUtilities.getPopupMenu(this.getClass().getResourceAsStream(this.getMenuXMLPath()), listener);
        }
        if (this.silkAnno == null) {
            MenuUtilities.removeMenuItem(this.getPopupMenu(), "ACTION_MODE_ANNOTATE");
        }
        switch (this.getActionMode()) {
            case 1: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_BRUSH", true);
                break;
            }
            case 2: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_VIEWPORT", true);
                break;
            }
            case 3: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_ZOOM", true);
                break;
            }
            case 4: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_PAN", true);
                break;
            }
            case 0: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_NONE", true);
                break;
            }
            case 6: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_SELECT", true);
                break;
            }
            case 14: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_SELECT_REGION", true);
                break;
            }
            case 8: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_DRILLDOWN", true);
                break;
            }
            case 10: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_GEOMETRIC_ZOOM", true);
                break;
            }
            case 11: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_GEOMETRIC_PAN", true);
                break;
            }
            case 12: {
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_GEOMETRIC_ROTATE", true);
                break;
            }
            case 13: {
                if (this.silkAnno == null) {
                    return;
                }
                MenuUtilities.setMenuItemSelected(this.getPopupMenu(), "ACTION_MODE_ANNOTATE", true);
                break;
            }
        }
        this.add(this.menu);
    }

    protected int getBuildDepth() {
        return this.buildDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseBuildDepth() {
        Object object = this.lock;
        synchronized (object) {
            ++this.buildDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseBuildDepth() {
        boolean repaint = false;
        Object object = this.lock;
        synchronized (object) {
            --this.buildDepth;
            if (this.buildDepth == 0) {
                repaint = true;
            }
        }
        if (repaint) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseHoldBuild() {
        Object object = this.lock;
        synchronized (object) {
            ++this.holdBuild;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseHoldBuild() {
        boolean build = false;
        Object object = this.lock;
        synchronized (object) {
            --this.holdBuild;
            if (this.holdBuild == 0) {
                build = true;
            }
        }
        if (build) {
            this.buildAndDraw(Boolean.TRUE, null, null);
        }
    }

    public void setSelectOnDrilldown(boolean selectOnDrilldown) {
        this.selectOnDrilldown = selectOnDrilldown;
    }

    private class TooltipHandler
    implements ActionListener {
        private TooltipHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SILKComponent.this.tipLocation == null) {
                return;
            }
            String prevTipText = SILKComponent.this.tipText;
            SILKComponent.this.tipText = SILKComponent.this.getTipText(SILKComponent.this.tipLocation.x, SILKComponent.this.tipLocation.y);
            SILKComponent.this.tooltipTimer.stop();
            if (prevTipText != SILKComponent.this.tipText) {
                SILKComponent.this.repaint();
            }
        }
    }
}

