/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.SILKXYComponent;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.LinePlotElement;
import com.sas.graphics.silk.event.LayerChangedEvent;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.LayerListenerInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisComponent;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.StyleElementAttrs;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.HTMLColors;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MultipleSeriesPlotContainer
extends SILKXYComponent
implements LayerListenerInterface {
    private LinePlotElement line = null;
    private int lineType = 1;
    private static final int LINE_PLOT = 1;
    private static final int SIMPLE_LINE = 2;
    private ArrayList yVars = new ArrayList(10000);
    private Object xVar = null;
    private Image backBuffer = null;
    private Image buffer2 = null;
    private boolean backBufferValid = false;
    private boolean buffer2Valid = false;
    private Object dataSource = null;
    private DataFilterReadInterface dataFilter = null;
    private DataFilterInfoInterface infoFilter = null;
    private SILKNumber xRole = null;
    private SILKNumber yRole = null;
    private Roles role = Roles.getInstance(null);
    private static final int MAX_Y = 1000000;
    private Color lineColor = Color.gray;
    private Color selectedLineColor = Color.blue;
    private Color probeColor = Color.red;
    private StyleElementAttrs lineAttrs = null;
    private String tooltipYVar = null;
    private Vector selectedLines = null;
    private static final int INVALID = -1;
    private static final int BELOW = 1;
    private static final int INSIDE = 2;
    private static final int ABOVE = 3;

    public MultipleSeriesPlotContainer() {
        switch (this.lineType) {
            case 1: {
                LinePlotElement lpe = new LinePlotElement();
                this.lineAttrs = (StyleElementAttrs)lpe.getPropertyValue(19009);
                if (this.lineAttrs != null) {
                    this.lineAttrs.getOverrides(true).setAttribute("lineColor", HTMLColors.getColorString((Color)this.lineColor));
                }
                lpe.setConnectOrder(1);
                lpe.setAntiAliasOn(false);
                this.line = lpe;
            }
        }
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 0);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1000000);
        this.roles.setRoleType((Object)this.yRole, 0);
        this.setStyle(SILKGlobal.getInstance().getPropertyValue(29));
    }

    @Override
    protected Hashtable getDrilldownInfo(int screenX, int screenY) {
        return null;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent me) {
        int y;
        int size;
        this.tooltipYVar = null;
        int x = me.getX();
        Rectangle r = new Rectangle(x - (size = 3) / 2, (y = me.getY()) - size / 2, size, size);
        Vector selectedLines = this.selectLines(r, true);
        if (selectedLines != null && selectedLines.size() == 1) {
            double[] p = new double[3];
            TransformInterface ti = this.getTransform("X", "Y");
            p = ti.unProject(x, y, 0.0, p);
            StringBuffer sb = new StringBuffer();
            sb.append(this.dataFilter.getVariableDescription(this.xVar));
            sb.append(" \t=\t ");
            sb.append(this.dataFilter.getFormattedValue(this.xVar, (Object)p[0], null));
            sb.append("\n");
            this.tooltipYVar = selectedLines.get(0).toString();
            sb.append(this.dataFilter.getVariableDescription((Object)this.tooltipYVar));
            sb.append(" \t=\t ");
            sb.append(this.dataFilter.getFormattedValue((Object)this.tooltipYVar, (Object)p[1], null));
            return sb.toString();
        }
        return null;
    }

    private Vector selectLines(Rectangle r, boolean firstOnly) {
        double x;
        if (this.yVars == null || this.yVars.size() == 0) {
            return null;
        }
        TransformInterface ti = this.getTransform("X", "Y");
        double[] p = new double[3];
        p = ti.unProject(r.x, r.y, 0.0, p);
        double xMin = p[0];
        double yMin = p[1];
        p = ti.unProject(r.x + r.width, r.y + r.height, 0.0, p);
        double xMax = p[0];
        double yMax = p[1];
        double t = Math.max(xMin, xMax);
        xMin = Math.min(xMin, xMax);
        xMax = t;
        t = Math.max(yMin, yMax);
        yMin = Math.min(yMin, yMax);
        yMax = t;
        boolean breakLine = true;
        Object o = this.line.getPropertyValue(18506);
        if (o instanceof Boolean) {
            breakLine = (Boolean)o;
        }
        int xVarIndex = this.dataFilter.getVariableIndex(this.xVar);
        double xf = Double.NEGATIVE_INFINITY;
        int firstIndex = 0;
        int obs = 0;
        while (obs < this.dataFilter.getNumberObservations(-1) && (x = this.dataFilter.getNumericValue(xVarIndex, (long)obs)) < xMin) {
            xf = x;
            firstIndex = obs++;
        }
        Rectangle r2 = new Rectangle(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        Vector selectedLines = new Vector();
        block1: for (int yCnt = 0; yCnt < this.yVars.size(); ++yCnt) {
            int yVarIndex = this.dataFilter.getVariableIndex(this.yVars.get(yCnt));
            double yInit = Double.NaN;
            double xInit = xf;
            int startIndex = firstIndex;
            for (int obs2 = firstIndex; obs2 >= 0; --obs2) {
                xInit = this.dataFilter.getNumericValue(xVarIndex, (long)obs2);
                yInit = this.dataFilter.getNumericValue(yVarIndex, (long)obs2);
                if (Double.isNaN(xInit) || Double.isNaN(yInit)) continue;
                startIndex = obs2;
                break;
            }
            boolean nextWasMissing = false;
            double xPrev = xInit;
            double yPrev = yInit;
            double xNext = Double.NaN;
            double yNext = Double.NaN;
            int prevState = this.computeState(yPrev, yMin, yMax);
            int nextState = -1;
            for (int obs3 = startIndex + 1; obs3 < this.dataFilter.getNumberObservations(-1); ++obs3) {
                prevState = this.computeState(yPrev, yMin, yMax);
                xNext = this.dataFilter.getNumericValue(xVarIndex, (long)obs3);
                if (Double.isNaN(xNext)) continue;
                yNext = this.dataFilter.getNumericValue(yVarIndex, (long)obs3);
                if (Double.isNaN(yNext)) {
                    if (!breakLine) continue;
                    nextWasMissing = true;
                    continue;
                }
                if (nextWasMissing || Double.isNaN(yPrev)) {
                    xPrev = xNext;
                    yPrev = yNext;
                    nextWasMissing = false;
                    continue;
                }
                if (xNext >= xMin && xNext <= xMax && yNext >= yMin && yNext <= yMax) {
                    selectedLines.add(this.yVars.get(yCnt));
                    continue block1;
                }
                nextState = this.computeState(yNext, yMin, yMax);
                if (prevState != nextState) {
                    double y2;
                    if (xPrev >= xMin && xPrev <= xMax && xNext >= xMin && xNext <= xMax) {
                        selectedLines.add(this.yVars.get(yCnt));
                        if (!firstOnly) continue block1;
                        return selectedLines;
                    }
                    p = ti.project(xPrev, yPrev, 0.0, p);
                    double x1 = p[0];
                    double y1 = p[1];
                    double x2 = (p = ti.project(xNext, yNext, 0.0, p))[0];
                    if (r2.intersectsLine(x1, y1, x2, y2 = p[1])) {
                        selectedLines.add(this.yVars.get(yCnt));
                        if (!firstOnly) continue block1;
                        return selectedLines;
                    }
                }
                if (prevState == 2 && nextState == 2 && xPrev < xMin && xNext > xMax) {
                    selectedLines.add(this.yVars.get(yCnt));
                    if (!firstOnly) continue block1;
                    return selectedLines;
                }
                xPrev = xNext;
                yPrev = yNext;
                if (xPrev >= xMax) continue block1;
            }
        }
        if (selectedLines.size() == 0) {
            return null;
        }
        return selectedLines;
    }

    private int computeState(double y, double yMin, double yMax) {
        if (Double.isNaN(y)) {
            System.out.println("Invalid y");
            return -1;
        }
        if (y < yMin) {
            return 1;
        }
        if (y >= yMin && y <= yMax) {
            return 2;
        }
        return 3;
    }

    @Override
    protected DataRange getRange(Object which) {
        if (which == null) {
            return null;
        }
        if (this.yVars == null || this.yVars.size() == 0) {
            return null;
        }
        double min = Double.NaN;
        double max = Double.NaN;
        double tempMin = Double.NaN;
        double tempMax = Double.NaN;
        Enumeration rolesEnum = Extract.elements((Object)which);
        while (rolesEnum.hasMoreElements()) {
            Object role = rolesEnum.nextElement();
            if (which.equals("X") || this.xRole.equals(role)) {
                if (this.infoFilter == null) continue;
                min = ((Number)this.infoFilter.getMinimumValue(this.xVar)).doubleValue();
                max = ((Number)this.infoFilter.getMaximumValue(this.xVar)).doubleValue();
                continue;
            }
            if (!which.equals("Y") && !this.yRole.equals(role)) continue;
            min = Double.POSITIVE_INFINITY;
            max = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.yVars.size(); ++i) {
                if (this.infoFilter == null) continue;
                tempMin = ((Number)this.infoFilter.getMinimumValue(this.yVars.get(i))).doubleValue();
                tempMax = ((Number)this.infoFilter.getMaximumValue(this.yVars.get(i))).doubleValue();
                if (Double.isNaN(tempMin) && Double.isNaN(tempMax)) continue;
                min = Math.min(min, tempMin);
                max = Math.max(max, tempMax);
            }
        }
        ContinuousRange r = new ContinuousRange(min, max);
        return r;
    }

    protected void buildBackBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer() || this.getBuildDepth() > 0) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = SILKUtilities.createCompatibleImage((int)this.compWidth, (int)this.compHeight, (int)3);
        } else {
            SILKUtilities.clearImage((Image)this.backBuffer);
        }
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        this.drawChart(g);
    }

    protected void buildSelectionBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer()) {
            return;
        }
        if (this.buffer2 == null) {
            this.buffer2 = SILKUtilities.createCompatibleImage((int)this.compWidth, (int)this.compHeight, (int)3);
        } else {
            SILKUtilities.clearImage((Image)this.buffer2);
        }
        Graphics2D g = (Graphics2D)this.buffer2.getGraphics();
        if (this.backBuffer != null) {
            g.drawImage(this.backBuffer, 0, 0, null);
        } else {
            this.drawChart(g);
        }
        this.drawSelections(g);
        this.buffer2Valid = true;
    }

    @Override
    public void drawSelections(Graphics g) {
        if (this.line == null || this.selectedLines == null || this.selectedLines.size() == 0) {
            return;
        }
        Shape clipShape = g.getClip();
        g.setClip(this.clipRect);
        if (this.lineAttrs != null) {
            this.lineAttrs.getOverrides(true).setAttribute("lineColor", HTMLColors.getColorString((Color)this.selectedLineColor));
        }
        for (int i = 0; i < this.selectedLines.size(); ++i) {
            this.line.setRole(this.selectedLines.get(i), (Object)this.yRole);
            this.line.draw(g, false);
        }
        g.setClip(clipShape);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.line != null) {
            this.line.setBounds(this.dataRegion);
        }
        this.layoutChart();
        this.initAxesFromSource(this.line);
        this.buildAndDraw(Boolean.TRUE, null, null);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        long t1 = System.currentTimeMillis();
        super.paintComponent(g);
        if (this.getBuildDepth() == 0) {
            this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
            this.graphLayout.setDataRegion(this.dataRegion);
        }
        Graphics2D g2 = (Graphics2D)g;
        boolean chartUsingSelectionBuffer = false;
        if (this.isUsingBackBuffer()) {
            if (this.backBuffer == null || !this.backBufferValid) {
                this.buildBackBuffer();
            }
            if (!chartUsingSelectionBuffer) {
                g.drawImage(this.backBuffer, 0, 0, null);
            }
        } else {
            this.drawChart(g2);
        }
        if (this.isUsingBackBuffer() && chartUsingSelectionBuffer) {
            if (this.buffer2 == null || !this.buffer2Valid) {
                this.buildSelectionBuffer();
            }
            g.drawImage(this.buffer2, 0, 0, null);
        } else {
            this.drawSelections(g);
        }
        this.drawAxisZoomPanIndicators(g);
        this.drawReferenceRanges(g);
        this.graphLayout.drawHighlight(g);
        this.warningIcon.draw(g);
        if (this.silkAnno != null) {
            this.silkAnno.draw(g2);
        }
        long t2 = System.currentTimeMillis();
    }

    public void drawChart(Graphics g) {
        boolean errorsOnAllCharts;
        long start = System.currentTimeMillis();
        if (this.background != null && g instanceof Graphics2D) {
            this.background.drawBackground((Graphics2D)g, this, new Rectangle(0, 0, this.compWidth, this.compHeight));
        }
        if (g instanceof Graphics2D) {
            this.drawWall((Graphics2D)g);
        }
        this.drawAxes(g);
        this.drawReferenceLines(g);
        this.graphLayout.draw(g);
        boolean bl = errorsOnAllCharts = this.yVars.size() > 0;
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Shape clipShape = g.getClip();
        g.setClip(this.clipRect);
        long t1 = System.currentTimeMillis();
        long trole = 0L;
        long tdraw = 0L;
        if (this.lineAttrs != null) {
            this.lineAttrs.getOverrides(true).setAttribute("lineColor", HTMLColors.getColorString((Color)this.lineColor));
        }
        for (int i = 0; i < this.yVars.size(); ++i) {
            long ta = System.currentTimeMillis();
            this.line.setRole(this.yVars.get(i), (Object)this.yRole);
            long tb = System.currentTimeMillis();
            this.line.draw(g, false);
            long tc = System.currentTimeMillis();
            trole += tb - ta;
            tdraw += tc - tb;
        }
        long t2 = System.currentTimeMillis();
        g.setClip(clipShape);
        this.backBufferValid = true;
        long end = System.currentTimeMillis();
    }

    @Override
    protected void doResize(int compWidthIn, int compHeightIn) {
        if (compHeightIn == this.compHeight && compWidthIn == this.compWidth) {
            return;
        }
        super.doResize(compWidthIn, compHeightIn);
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.buffer2 != null) {
            this.buffer2.flush();
        }
        this.buffer2 = null;
        if (this.yVars == null || this.yVars.size() == 0) {
            return;
        }
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        if (this.line != null) {
            this.line.setInnerMargin(this.innerMargin);
        }
        this.dataRegion.x = this.outerMargin.left;
        this.dataRegion.y = this.outerMargin.top;
        this.dataRegion.width = this.compWidth - this.outerMargin.right - this.outerMargin.left;
        this.dataRegion.height = this.compHeight - this.outerMargin.top - this.outerMargin.bottom;
        this.graphLayout.setDataRegion(this.dataRegion);
        this.clipRect = new Rectangle(this.dataRegion.x, this.dataRegion.y, this.dataRegion.width, this.dataRegion.height);
        if (this.line != null) {
            this.line.setBounds(this.dataRegion);
            this.line.setComponentSize(this.compWidth, this.compHeight);
        }
        this.setupTransforms();
        this.applyDeferredViewports();
    }

    @Override
    public void marginChanged(MarginChangeEvent e) {
        this.increaseBuildDepth();
        if (!this.inMarginChanged || e.getSource() != this) {
            super.marginChanged(e);
        }
        if (this.line != null) {
            this.line.setInnerMargin(this.innerMargin);
            if (this.propogateMarginEvents) {
                this.line.setBounds(this.dataRegion);
            }
        }
        this.decreaseBuildDepth();
    }

    @Override
    public void invalidateBackBuffer() {
        if (this.holdBuild > 0) {
            return;
        }
        this.backBufferValid = false;
        this.buffer2Valid = false;
    }

    @Override
    public void layerChanged(LayerChangedEvent lce) {
        if (lce == null) {
            return;
        }
        if (lce.getAction() == 3) {
            this.buildAndDraw(Boolean.TRUE, null, null);
        } else if (lce.getAction() == 5) {
            this.resetViewport();
        } else if (lce.getAction() == 9) {
            this.buildAndDraw(Boolean.TRUE, null, null);
        } else if (lce.getAction() == 2) {
            this.buffer2Valid = false;
            this.repaint();
        } else if (lce.getAction() == 1) {
            this.invalidateBackBuffer();
            this.repaint();
        } else if (lce.getAction() == 7) {
            this.initAxesFromSource((BaseElement)lce.getSource());
            this.checkAxes();
            this.layoutChart();
            this.invalidateBackBuffer();
            this.repaint();
        } else if (lce.getAction() == 10) {
            this.initAxesFromSource((BaseElement)lce.getSource());
            this.checkAxes();
            this.buildAndDraw(Boolean.TRUE, null, null);
        }
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        this.increaseBuildDepth();
        boolean rc = true;
        this.dataSource = source;
        this.dataFilter = FilterFactory.getDataSourceFilter((Object)this.dataSource);
        if (this.dataFilter instanceof DataFilterInfoInterface) {
            this.infoFilter = (DataFilterInfoInterface)this.dataFilter;
        }
        if (this.line != null) {
            rc &= this.line.setDataSource(source, id);
        }
        this.decreaseBuildDepth();
        return rc;
    }

    @Override
    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    @Override
    public DataFilterReadInterface getFilter() {
        return this.dataFilter;
    }

    @Override
    public Object getDataSource(Object id) {
        return this.dataSource;
    }

    @Override
    protected void setInternalRange(byte dim, int index, DataRange range) {
        super.setInternalRange(dim, index, range);
        DataRange r = this.getOutputRange(dim, index);
        AxisZoomPanHandler zph = null;
        switch (dim) {
            case 1: {
                if (index == 0) {
                    zph = this.xAxisZoomHandler;
                    break;
                }
                zph = this.x2AxisZoomHandler;
                break;
            }
            case 2: {
                zph = index == 0 ? this.yAxisZoomHandler : this.y2AxisZoomHandler;
            }
        }
        if (this.line != null) {
            if (this.axisMappingsMatch(dim, index, this.line) && (zph == null || !zph.hasViewport())) {
                this.line.setDataRange(dim, index, this.computeAxisRange(range, dim, index));
            }
            this.line.setRange(dim, index, r);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean axisMappingsMatch(byte dim, int index, BaseElement chart) {
        boolean rc;
        block14: {
            rc = false;
            switch (dim) {
                case 1: {
                    switch (index) {
                        case 0: {
                            if (chart.getXAxisMapping() != 0) break;
                            rc = true;
                            return rc;
                        }
                        case 1: {
                            if (chart.getXAxisMapping() != 3) break;
                            rc = true;
                        }
                    }
                    return rc;
                }
                case 2: {
                    switch (index) {
                        case 0: {
                            if (chart.getYAxisMapping() != 1) return rc;
                            rc = true;
                            break block14;
                        }
                        case 1: {
                            if (chart.getYAxisMapping() != 4) return rc;
                            rc = true;
                        }
                    }
                }
            }
        }
        return rc;
    }

    @Override
    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (this.legends != null) {
            Enumeration legs = this.legends.elements();
            while (legs.hasMoreElements()) {
                LegendObjectJ2D l = (LegendObjectJ2D)legs.nextElement();
                l.applyStyle(this.style);
            }
        }
        if (this.line != null) {
            rc &= this.line.setStyle(this.style);
        }
        if (this.silkAnno != null) {
            this.silkAnno.setStyle(this.style);
        }
        this.buildAndDraw(new Boolean(true), null, null);
        return rc;
    }

    @Override
    public boolean build(Object buildData) {
        if (this.holdBuild > 0) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        if (buildData instanceof Boolean && ((Boolean)buildData).booleanValue()) {
            this.invalidateBackBuffer();
        }
        boolean rc = super.build(buildData);
        if (this.propertiesDialog != null) {
            this.propertiesDialog.updateLegendPanels(this, this);
        }
        this.layoutChart();
        this.buffer2Valid = false;
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        this.computeInnerOuterMargin();
        if (this.line == null) {
            return true;
        }
        if (this.line != null) {
            this.setTransformOnChart(this.line);
            this.line.setInnerMargin(this.innerMargin);
            this.dataRegion.x = this.outerMargin.left;
            this.dataRegion.y = this.outerMargin.top;
            this.dataRegion.width = this.compWidth - this.outerMargin.right - this.outerMargin.left;
            this.dataRegion.height = this.compHeight - this.outerMargin.top - this.outerMargin.bottom;
            this.line.setBounds(this.dataRegion);
            this.graphLayout.setDataRegion(this.dataRegion);
            if (this.silkAnno != null) {
                this.silkAnno.setDataBoundingBox(this.dataRegion, "");
                this.silkAnno.setTransform(this.line.getTransformObject(), "");
            }
        }
        this.setupTransforms();
        long endTime = System.currentTimeMillis();
        if (this.isTakingDiagnostics(0)) {
            this.getDiagnosticsEvent().getTable().put(new Integer(0), new Long(endTime - startTime));
            this.fireDiagnosticsEvent(0);
        }
        return rc;
    }

    protected void setTransformOnChart(BaseElement chart) {
        if (chart == null) {
            return;
        }
        int xAxisMapping = chart.getXAxisMapping();
        int yAxisMapping = chart.getYAxisMapping();
        String whichX = null;
        String whichY = null;
        if (xAxisMapping == 0) {
            whichX = "X";
        } else if (xAxisMapping == 3) {
            whichX = "X2";
        }
        if (yAxisMapping == 1) {
            whichY = "Y";
        } else if (yAxisMapping == 4) {
            whichY = "Y2";
        }
        chart.setTransformObject(this.getTransform(whichX, whichY));
    }

    @Override
    public void dispose() {
        if (this.line != null) {
            this.line.removeMarginListener(this);
            this.line.removeRangeChangeListener(this);
            this.line.removeViewportListener(this);
            this.dataFilter = this.line.getFilter();
            this.line.removeLayerListener(this);
            this.line.dispose();
        }
        if (this.legends != null) {
            this.legends.clear();
        }
        this.legends = null;
        if (this.dataDlg != null) {
            this.dataDlg.removeAllCharts();
        }
        this.menu = null;
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.buffer2 != null) {
            this.buffer2.flush();
        }
        this.buffer2 = null;
        super.dispose();
    }

    @Override
    public Insets getPreferredChartInnerMargin() {
        Insets sets;
        if (this.line == null || this.yVars == null || this.yVars.size() == 0) {
            return null;
        }
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.line != null && (sets = this.line.getPreferredInnerMargin()) != null) {
            if (sets.left > insets.left) {
                insets.left = sets.left;
            }
            if (sets.right > insets.right) {
                insets.right = sets.right;
            }
            if (sets.top > insets.top) {
                insets.top = sets.top;
            }
            if (sets.bottom > insets.bottom) {
                insets.bottom = sets.bottom;
            }
        }
        return insets;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        return super.getTipText(screenX, screenY);
    }

    private void initAxesFromSource(BaseElement source) {
        this.initAxesFromSource(source, true);
    }

    private void initAxesFromSource(BaseElement source, boolean updateRange) {
        TextAttrib text;
        boolean changeGridlines;
        if (source == null) {
            return;
        }
        AxisInterface axis = null;
        byte dimension = 0;
        int primaryAxis = 0;
        String axisLabel = null;
        Object axisFormat = null;
        Object[] axisFixedTicks = null;
        boolean panEnabled = true;
        boolean zoomMinEnabled = true;
        boolean zoomMaxEnabled = true;
        boolean gridlinesVisible = !SILKGlobal.isFlagSet(4);
        int minDiscreteTickCount = -1;
        AxisComponent axisComponent = null;
        BaseElement axisPrimary = source;
        boolean logEnabled = true;
        this.increaseBuildDepth();
        Object obj = null;
        if (source.getXAxisMapping() == 3) {
            axisComponent = this.getAxisComponent("X2");
            axis = this.getAxis("X2");
            primaryAxis = 1;
        } else if (source.getXAxisMapping() == 0) {
            axisComponent = this.getAxisComponent("X");
            axis = this.getAxis("X");
            primaryAxis = 0;
        }
        if (axis != null && axisComponent != null) {
            Boolean b;
            dimension = 1;
            obj = axisPrimary.getPropertyValue(19053);
            axisLabel = obj != null ? obj.toString() : "";
            ((Axes)axis).setLogTransformEnabled(logEnabled);
            axisFormat = axisPrimary.getPropertyValue(19055);
            obj = axisPrimary.getPropertyValue(19058);
            if (obj != null && obj instanceof Boolean) {
                panEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19062)) != null && obj instanceof Boolean) {
                zoomMaxEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19060)) != null && obj instanceof Boolean) {
                zoomMinEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19064)) != null && obj instanceof Boolean) {
                gridlinesVisible = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19067)) != null && obj instanceof Number) {
                minDiscreteTickCount = ((Number)obj).intValue();
            }
            if ((obj = axisPrimary.getPropertyValue(19070)) != null && obj instanceof Object[]) {
                axisFixedTicks = (Object[])obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19069)) != null && obj instanceof Boolean) {
                if (axisPrimary.getXAxisMapping() == 0) {
                    ((Axes)this.getAxis("X")).setVisible(false);
                } else if (axisPrimary.getXAxisMapping() == 3) {
                    ((Axes)this.getAxis("X2")).setVisible(false);
                }
            }
            if (axisComponent != null) {
                axisComponent.setMinDiscreteTickCount(minDiscreteTickCount);
            }
            if (axis != null) {
                LineStyleInterface li = axis.getGridLines();
                changeGridlines = true;
                if (li instanceof PropertyInterface && ((PropertyInterface)li).hasUserSetValue(9501)) {
                    changeGridlines = false;
                }
                if (changeGridlines) {
                    axis.setGridLines(new Boolean(gridlinesVisible));
                    if (li instanceof LineAttrib) {
                        ((LineAttrib)li).setCurrentValueAsDefault(9501);
                    }
                }
                if (axisLabel != null && !(text = (TextAttrib)axis.getLabel()).hasUserSetValue(9015)) {
                    axis.setLabel(axisLabel);
                    text.setCurrentValueAsDefault(9015);
                }
                if (axisFormat != null) {
                    text = (TextAttrib)axis.getValues();
                    if (!text.hasUserSetValue(9008)) {
                        axis.setValues(axisFormat);
                        text.setCurrentValueAsDefault(9008);
                    }
                } else {
                    text = (TextAttrib)axis.getValues();
                    if (!text.hasUserSetValue(9008)) {
                        ((Axes)axis).setFormat((SASFormat)axisFormat, true);
                        text.setCurrentValueAsDefault(9008);
                    }
                }
                if (axisComponent != null) {
                    axisComponent.setFixedTickValues(axisFixedTicks, false);
                }
                DataRange range = this.getAxisRange(primaryAxis == 0 ? 0 : 3);
                if (updateRange) {
                    this.setInternalRange(dimension, primaryAxis, range);
                    this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, dimension));
                }
            }
            if (this.actions.containsKey("AXIS_PAN") && !(b = (Boolean)this.actions.get("AXIS_PAN")).booleanValue()) {
                panEnabled = false;
            }
            if (this.actions.containsKey("AXIS_ZOOM") && !(b = (Boolean)this.actions.get("AXIS_ZOOM")).booleanValue()) {
                zoomMaxEnabled = false;
                zoomMinEnabled = false;
            }
            boolean isDiscreteAxis = ((Axes)axisComponent.getInternalAxis()).isDiscrete();
            if (primaryAxis == 0) {
                this.xAxisZoomHandler.setZoomPanEnabled(panEnabled, zoomMinEnabled, zoomMaxEnabled);
                if (isDiscreteAxis) {
                    this.xAxisZoomHandler.setMinimumViewportRange(1.1);
                } else {
                    this.xAxisZoomHandler.setMinimumViewportRange(0.001);
                }
            } else {
                this.x2AxisZoomHandler.setZoomPanEnabled(panEnabled, zoomMinEnabled, zoomMaxEnabled);
                if (isDiscreteAxis) {
                    this.x2AxisZoomHandler.setMinimumViewportRange(1.1);
                } else {
                    this.x2AxisZoomHandler.setMinimumViewportRange(0.001);
                }
            }
        }
        gridlinesVisible = !SILKGlobal.isFlagSet(4);
        minDiscreteTickCount = -1;
        axisFixedTicks = null;
        axisComponent = null;
        axis = null;
        logEnabled = true;
        if (source.getYAxisMapping() == 4) {
            axisComponent = this.getAxisComponent("Y2");
            axis = this.getAxis("Y2");
            primaryAxis = 1;
        } else if (source.getYAxisMapping() == 1) {
            axisComponent = this.getAxisComponent("Y");
            axis = this.getAxis("Y");
            primaryAxis = 0;
        }
        if (axis != null && axisComponent != null) {
            dimension = 2;
            obj = axisPrimary.getPropertyValue(19052);
            axisLabel = obj != null ? obj.toString() : "";
            ((Axes)axis).setLogTransformEnabled(logEnabled);
            axisFormat = axisPrimary.getPropertyValue(19054);
            obj = axisPrimary.getPropertyValue(19059);
            if (obj != null && obj instanceof Boolean) {
                panEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19063)) != null && obj instanceof Boolean) {
                zoomMaxEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19061)) != null && obj instanceof Boolean) {
                zoomMinEnabled = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19065)) != null && obj instanceof Boolean) {
                gridlinesVisible = (Boolean)obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19066)) != null && obj instanceof Number) {
                minDiscreteTickCount = ((Number)obj).intValue();
            }
            if ((obj = axisPrimary.getPropertyValue(19071)) != null && obj instanceof Object[]) {
                axisFixedTicks = (Object[])obj;
            }
            if ((obj = axisPrimary.getPropertyValue(19068)) != null && obj instanceof Boolean) {
                if (axisPrimary.getYAxisMapping() == 1) {
                    ((Axes)this.getAxis("Y")).setVisible(false);
                } else if (axisPrimary.getYAxisMapping() == 4) {
                    ((Axes)this.getAxis("Y2")).setVisible(false);
                }
            }
            if (axisComponent != null) {
                axisComponent.setMinDiscreteTickCount(minDiscreteTickCount);
            }
            if (axis != null) {
                LineStyleInterface li = axis.getGridLines();
                changeGridlines = true;
                if (li instanceof PropertyInterface && ((PropertyInterface)li).hasUserSetValue(9501)) {
                    changeGridlines = false;
                }
                if (changeGridlines) {
                    axis.setGridLines(new Boolean(gridlinesVisible));
                    if (li instanceof LineAttrib) {
                        ((LineAttrib)li).setCurrentValueAsDefault(9501);
                    }
                }
                if (axisLabel != null && !(text = (TextAttrib)axis.getLabel()).hasUserSetValue(9015)) {
                    axis.setLabel(axisLabel);
                    text.setCurrentValueAsDefault(9015);
                }
                if (axisFormat != null) {
                    text = (TextAttrib)axis.getValues();
                    if (!text.hasUserSetValue(9008)) {
                        axis.setValues(axisFormat);
                        text.setCurrentValueAsDefault(9008);
                    }
                } else {
                    text = (TextAttrib)axis.getValues();
                    if (!text.hasUserSetValue(9008)) {
                        ((Axes)axis).setFormat((SASFormat)axisFormat, true);
                        text.setCurrentValueAsDefault(9008);
                    }
                }
                if (axisComponent != null) {
                    axisComponent.setFixedTickValues(axisFixedTicks, false);
                }
                if (updateRange) {
                    this.setInternalRange(dimension, primaryAxis, this.getAxisRange(primaryAxis == 0 ? 1 : 4));
                    this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, dimension));
                }
            }
            boolean isDiscreteAxis = ((Axes)axisComponent.getInternalAxis()).isDiscrete();
            if (primaryAxis == 0) {
                this.yAxisZoomHandler.setZoomPanEnabled(panEnabled, zoomMinEnabled, zoomMaxEnabled);
                if (isDiscreteAxis) {
                    this.yAxisZoomHandler.setMinimumViewportRange(1.1);
                } else {
                    this.yAxisZoomHandler.setMinimumViewportRange(0.001);
                }
            } else {
                this.y2AxisZoomHandler.setZoomPanEnabled(panEnabled, zoomMinEnabled, zoomMaxEnabled);
                if (isDiscreteAxis) {
                    this.y2AxisZoomHandler.setMinimumViewportRange(1.1);
                } else {
                    this.y2AxisZoomHandler.setMinimumViewportRange(0.001);
                }
            }
        }
        this.decreaseBuildDepth();
    }

    protected void checkAxes() {
        boolean hasX = false;
        boolean hasY = false;
        boolean hasX2 = false;
        boolean hasY2 = false;
        if (this.line != null) {
            if (this.line.getXAxisMapping() == 0) {
                hasX = true;
            } else if (this.line.getXAxisMapping() == 3) {
                hasX2 = true;
            }
            if (this.line.getYAxisMapping() == 1) {
                hasY = true;
            } else if (this.line.getYAxisMapping() == 4) {
                hasY2 = true;
            }
        }
        if (!hasX) {
            this.removeAxis(0);
        }
        if (!hasY) {
            this.removeAxis(1);
        }
        if (!hasX2) {
            this.removeAxis(3);
        }
        if (!hasY2) {
            this.removeAxis(4);
        }
    }

    private void updateTransform(Object role) {
        this.increaseBuildDepth();
        int roleInt = this.xRole.equals(role) ? 24 : 25;
        RoleEvent re = new RoleEvent();
        re.role = roleInt;
        this.resetTransformTypes(re);
        boolean x = false;
        boolean x2 = false;
        boolean y = false;
        boolean y2 = false;
        switch (roleInt) {
            case 24: {
                x = true;
                break;
            }
            case 25: {
                y = true;
            }
        }
        this.resetViewport(x, y, x2, y2);
        this.initAxesFromSource(this.line);
        this.checkAxes();
        super.roleChanged(re);
        this.decreaseBuildDepth();
        this.invalidateBackBuffer();
        this.buildAndDraw(Boolean.TRUE, null, null);
    }

    @Override
    protected int[] drawGridLines(AxisInterface axis, Graphics g, int whichAxis) {
        int[] rc = super.drawGridLines(axis, g, whichAxis);
        int id = -1;
        switch (whichAxis) {
            case 0: {
                id = 19074;
                break;
            }
            case 3: {
                id = 19076;
                break;
            }
            case 1: {
                id = 19075;
                break;
            }
            case 4: {
                id = 19077;
            }
        }
        if (this.line != null) {
            this.line.setPropertyValue(id, rc);
        }
        return rc;
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        boolean rc = false;
        if (this.xRole.equals(role)) {
            this.xVar = variableId;
            this.line.setRole(this.xVar, (Object)this.xRole);
            this.updateTransform(role);
            rc = true;
        } else if (this.yRole.equals(role)) {
            this.yVars.clear();
            int type = Extract.getSourceType((Object)variableId);
            int num = Extract.getNumberItems((Object)variableId, (int)type);
            for (int i = 0; i < num; ++i) {
                this.yVars.add(Extract.getObject((Object)variableId, (int)i, (int)type));
            }
            this.updateTransform(role);
            rc = true;
        }
        return rc;
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        boolean rc = false;
        if (this.xRole.equals(role)) {
            this.xVar = variableId;
            this.line.setRole(this.xVar, (Object)this.xRole);
            this.updateTransform(role);
            rc = true;
        } else if (this.yRole.equals(role)) {
            int type = Extract.getSourceType((Object)variableId);
            int num = Extract.getNumberItems((Object)variableId, (int)type);
            for (int i = 0; i < num; ++i) {
                this.yVars.add(Extract.getObject((Object)variableId, (int)i, (int)type));
            }
            this.updateTransform(role);
            rc = true;
        }
        return rc;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        super.mouseMoved(me);
        this.tooltipYVar = null;
    }

    @Override
    public void paint(Graphics g) {
        boolean tooltipsOn = this.tipsOn;
        this.tipsOn = false;
        super.paint(g);
        this.tipsOn = tooltipsOn;
        if (this.tooltipYVar != null) {
            Shape clipShape = g.getClip();
            g.setClip(this.clipRect);
            this.line.setRole(this.tooltipYVar, (Object)this.yRole);
            if (this.lineAttrs != null) {
                this.lineAttrs.getOverrides(true).setAttribute("lineColor", HTMLColors.getColorString((Color)this.probeColor));
            }
            this.line.draw(g, false);
            if (this.lineAttrs != null) {
                this.lineAttrs.getOverrides(true).setAttribute("lineColor", HTMLColors.getColorString((Color)this.lineColor));
            }
            g.setClip(clipShape);
        }
        if (this.tooltip != null && this.tipText != null && g instanceof Graphics2D) {
            this.tooltip.paint(this, (Graphics2D)g, this.tipLocation, this.tipText);
        }
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        if (selectRegion instanceof Rectangle) {
            long t1 = System.currentTimeMillis();
            this.selectedLines = this.selectLines((Rectangle)selectRegion, false);
            long l = System.currentTimeMillis();
        }
        this.repaint();
        return true;
    }

    @Override
    public boolean setViewport(int type, int dimension, double min, double max) {
        return super.setViewport(type, dimension, min, max);
    }

    public Rectangle2D getDataSpaceRectangle(Rectangle screenRectangle) {
        if (screenRectangle == null) {
            return null;
        }
        double[] p = new double[3];
        TransformInterface ti = this.getTransform("X", "Y");
        p = ti.unProject(screenRectangle.x, screenRectangle.y, 0.0, p);
        double[] p2 = new double[3];
        p2 = ti.unProject(screenRectangle.x + screenRectangle.width, screenRectangle.y + screenRectangle.height, 0.0, p2);
        Rectangle2D.Double dRect = new Rectangle2D.Double();
        ((Rectangle2D)dRect).setRect(p[0], p[1], p2[0] - p[0], p2[1] - p[1]);
        return dRect;
    }

    public void setSelectedLines(Vector selectedLines) {
        if (selectedLines == null) {
            return;
        }
        this.selectedLines = selectedLines;
        this.repaint();
    }
}

