/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.util.SILKUtilities;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class LayoutRegion
extends SILKComponent {
    private JComponent chart = null;
    private Image backBuffer = null;

    public LayoutRegion() {
        this.setLayout(null);
    }

    @Override
    protected void doResize(int compWidthIn, int compHeightIn) {
        super.doResize(compWidthIn, compHeightIn);
        if (this.chart != null && this.graphLayout != null && this.graphLayout.getChartArea() != null) {
            this.chart.setBounds(this.graphLayout.getChartArea());
        }
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
    }

    public void setChart(JComponent chart) {
        this.chart = chart;
        this.add(chart);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.isUsingBackBuffer()) {
            if (this.backBuffer == null) {
                this.buildBackBuffer();
            }
            g.drawImage(this.backBuffer, 0, 0, null);
        } else {
            this.drawChart(g2);
        }
    }

    protected void buildBackBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer()) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = SILKUtilities.createCompatibleImage((int)this.compWidth, (int)this.compHeight, (int)3);
        } else {
            SILKUtilities.clearImage((Image)this.backBuffer);
        }
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        this.drawChart(g);
    }

    public void drawChart(Graphics g) {
        if (this.chart == null) {
            return;
        }
        if (this.background != null && g instanceof Graphics2D) {
            this.background.drawBackground((Graphics2D)g, this, new Rectangle(0, 0, this.compWidth, this.compHeight));
        }
        this.graphLayout.draw(g);
        this.graphLayout.drawHighlight(g);
        Rectangle chartArea = this.graphLayout.getChartArea();
        g.translate(chartArea.x, chartArea.y);
        this.chart.paint(g);
        g.translate(-chartArea.x, -chartArea.y);
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent me) {
        return null;
    }
}

