/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.silk.base.AbstractBaseElementCellProvider;
import com.sas.graphics.silk.base.BaseElementGridCellProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class GridComponent
extends JComponent {
    private static final long serialVersionUID = 8216498377981970784L;
    protected BaseElementGridCellProvider becp = null;
    protected boolean rebuildRequired;
    protected TrellisPlot grid = null;
    protected TrellisLayout layout = null;

    public GridComponent() {
        this(null);
    }

    public GridComponent(BaseElementGridCellProvider becp) {
        if (becp == null) {
            becp = new DefaultCellProvider();
        }
        this.setCellProvider(becp);
        this.setLayout(new BorderLayout());
    }

    public boolean setCellProvider(BaseElementGridCellProvider becp) {
        if (becp == null) {
            return false;
        }
        this.becp = becp;
        this.rebuildRequired = true;
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.rebuildRequired) {
            this.rebuildGrid();
            this.rebuildRequired = false;
        }
        super.paintComponent(g);
    }

    private void rebuildGrid() {
        this.disposeGrid();
        this.createGrid();
        this.buildGrid();
    }

    protected void disposeGrid() {
        if (this.grid != null) {
            this.grid.removeAll();
            this.remove((Component)this.grid);
        }
        this.grid = null;
        this.layout = null;
        this.removeAll();
    }

    protected void createGrid() {
        this.layout = new TrellisLayout();
        this.grid = new TrellisPlot();
        this.grid.setLayout((LayoutManager)this.layout);
        this.grid.setSize(400, 400);
        this.add((Component)this.grid);
    }

    protected void buildGrid() {
        int i;
        int j;
        if (this.grid == null || this.layout == null || this.becp == null) {
            return;
        }
        for (j = 1; j < this.becp.getNumberColumns(); ++j) {
            this.grid.addColumn();
        }
        for (i = 0; i < this.becp.getNumberRows(); ++i) {
            if (i >= 1) {
                this.grid.addRow();
            }
            for (int j2 = 0; j2 < this.becp.getNumberColumns(); ++j2) {
                Object o = this.becp.getCellElement(j2, i);
                if (!(o instanceof JComponent)) continue;
                this.grid.addCellItem(i, j2, (Component)((JComponent)o));
            }
        }
        for (i = 0; i < this.becp.getNumberRows(); ++i) {
            Object axis = this.becp.getRowAxis(i, true);
            if (axis instanceof Component) {
                this.grid.addRowAxis(i, (Component)axis, true);
            }
            if (!((axis = this.becp.getRowAxis(i, false)) instanceof Component)) continue;
            this.grid.addRowAxis(i, (Component)axis, false);
        }
        for (j = 0; j < this.becp.getNumberColumns(); ++j) {
            Object axis = this.becp.getColumnAxis(j, true);
            if (axis instanceof Component) {
                this.grid.addColumnAxis(j, (Component)axis, true);
            }
            if (!((axis = this.becp.getColumnAxis(j, false)) instanceof Component)) continue;
            this.grid.addColumnAxis(j, (Component)axis, false);
        }
        this.grid.installColumnRangeListeners();
        this.grid.installRowRangeListeners();
        this.grid.enableLayout();
    }

    private class DefaultCellProvider
    extends AbstractBaseElementCellProvider {
        @Override
        public Object getCellElement(int row, int column) {
            JLabel l = new JLabel("row = " + row + " column = " + column);
            l.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    System.out.println("mouse pressed");
                }
            });
            return l;
        }

        @Override
        public int getNumberColumns() {
            return 2;
        }

        @Override
        public int getNumberRows() {
            return 2;
        }

        @Override
        public Object[] getSupportedRoles(Object o, boolean b) {
            return null;
        }
    }
}

