/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.bar.BarChart;
import com.sas.graphics.silk.bar.BarModel;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.histogram.AbstractComponent;
import com.sas.graphics.silk.histogram.ChartInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.BarComponentInterface;
import com.sas.graphics.silk.interfaces.BarInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.BarPanel;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.LegendPanel;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.xml.SILKParser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class BarComponent
extends AbstractComponent
implements BarComponentInterface {
    private static final long serialVersionUID = 7323698400196739836L;
    protected Axes groupAxis = null;
    protected BarPanel barPanel;
    protected LegendPanel legendPanel;
    protected int startBar = 0;
    protected int endBar = Integer.MAX_VALUE;
    protected ResourceBundle barRB = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
    protected BarComponent instance = this;

    @Override
    public BarInterface getChart() {
        return (BarInterface)this.chart;
    }

    @Override
    public AxisInterface getAxis(Object which) {
        if (which == null) {
            return null;
        }
        if (which instanceof Number && (((Number)which).intValue() == 24 || ((Number)which).intValue() == 1) || which instanceof String && (((String)which).equalsIgnoreCase("X") || ((String)which).equalsIgnoreCase("XAxis"))) {
            return ((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical") ? (AxisInterface)this.xAxis : (AxisInterface)this.yAxis;
        }
        if (which instanceof Number && (((Number)which).intValue() == 25 || ((Number)which).intValue() == 17) || which instanceof String && (((String)which).equalsIgnoreCase("Y") || ((String)which).equalsIgnoreCase("YAxis"))) {
            return ((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical") ? (AxisInterface)this.yAxis : (AxisInterface)this.xAxis;
        }
        if (which instanceof Number && ((Number)which).intValue() == 6 || which instanceof String && (((String)which).equalsIgnoreCase("Group") || ((String)which).equalsIgnoreCase("groupAxis"))) {
            return this.groupAxis;
        }
        return null;
    }

    @Override
    public Object getWall() {
        return this.wall;
    }

    @Override
    public void setZoomFactor(double fac) {
        if (fac <= this.globalDefaults.zoomLimitParm || fac > 1.0) {
            return;
        }
        this.zoomFactor = fac;
        this.doDataZoom();
        this.brushMode = false;
    }

    @Override
    protected void doDataZoom() {
        double rangeX = this.dataXMax - this.dataXMin;
        double rangeY = this.dataYMax - this.dataYMin;
        if (((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
            this.min[0] = 0.0;
            this.max[0] = rangeX * this.zoomFactor;
        } else {
            this.min[1] = 0.0;
            this.max[1] = rangeY * this.zoomFactor;
        }
        ((BarChart)this.chart).setBoundingBox(this.min[0], this.min[1], 0.0, this.max[0], this.max[1], 0.0);
        this.viewportXMin = this.min[0];
        this.viewportXMax = this.max[0];
        this.viewportYMin = this.min[1];
        this.viewportYMax = this.max[1];
    }

    protected void setColorToGroupAxis() {
        this.groupAxis.applyStyle(this.colorScheme.getStyle());
    }

    @Override
    public boolean isRebuildRequired() {
        if (this.getVariable("Group") == null || this.groupAxis == null) {
            return super.isRebuildRequired();
        }
        return super.isRebuildRequired() || this.groupAxis.isRebuildRequired();
    }

    @Override
    protected void createActionComponents() {
        JMenuItem mi = null;
        AbstractAction graph = new AbstractAction(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Popup_Graph_Properties___.txt", (String)"Graph Properties...")){
            private static final long serialVersionUID = 8412554632343030519L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BarComponent.this.getPropertyDialog(BarComponent.this);
                BarComponent.this.propertyDialog.setVisible(true);
            }
        };
        mi = this.popup.add(graph);
        mi.setMnemonic(71);
        JMenu actionMenu = MenuUtilities.getMenu(this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/StandardActionMenu.xml"), (ActionListener)this);
        mi = this.popup.add(actionMenu);
        mi.setMnemonic(89);
        this.popup.addSeparator();
        JMenu ctype = new JMenu(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Popup_Chart_Type.txt", (String)"Chart_Type"));
        mi = this.popup.add(ctype);
        mi.setMnemonic(89);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem hori = new JRadioButtonMenuItem(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Popup_Horizontal_Bar.txt", (String)"Horizontal Bar"));
        hori.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarComponent.this.getChart().setChartType("Horizontal");
            }
        });
        hori.setMnemonic(72);
        ctype.add(hori);
        group.add(hori);
        JRadioButtonMenuItem vert = new JRadioButtonMenuItem(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Popup_Vertical_Bar.txt", (String)"Vertical Bar"));
        vert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarComponent.this.getChart().setChartType("Vertical");
            }
        });
        vert.setMnemonic(86);
        ctype.add(vert);
        group.add(vert);
        if (this.getChart().getChartType().equals("Horizontal")) {
            hori.setSelected(true);
        } else {
            vert.setSelected(true);
        }
        AbstractAction data = new AbstractAction(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Popup_Data_Options___.txt", (String)"Data Options...")){
            private static final long serialVersionUID = -7812381052890174528L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BarComponent.this.getDataDialog();
                BarComponent.this.dataDialog.setVisible(true);
            }
        };
        mi = this.popup.add(data);
        mi.setMnemonic(68);
        this.popup.addSeparator();
        AbstractAction copy = new AbstractAction(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Popup_Copy.txt", (String)"Copy")){
            private static final long serialVersionUID = -3586794078086585541L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyToClipboard.toClipboard(BarComponent.this.instance);
            }
        };
        mi = this.popup.add(copy);
        mi.setMnemonic(67);
        if (SILKGlobal.isTestMode()) {
            this.popup.addSeparator();
            AbstractAction saveXML = new AbstractAction(ResourceLoader.getResourceString((Object)ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.menus.silk_menus_NLS"), (String)"Popup.Save_As_XML.txt", (String)"Save_As_XML...")){
                private static final long serialVersionUID = 3753469321055272779L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SILKParser.saveAsXML(BarComponent.this, null, true);
                }
            };
            mi = this.popup.add(saveXML);
        }
    }

    @Override
    protected int getRubberbandingDirection() {
        if (((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
            if (this.dataYMin < 0.0 && this.dataYMax > 0.0) {
                return 3;
            }
            return 1;
        }
        if (this.dataXMin < 0.0 && this.dataXMax > 0.0) {
            return 3;
        }
        return 2;
    }

    @Override
    protected int getZoomPoint() {
        int direction = this.getRubberbandingDirection();
        if (direction == 1) {
            if (this.dataYMax > 0.0) {
                return 2;
            }
            return 1;
        }
        if (direction == 2) {
            if (this.dataXMax > 0.0) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    @Override
    protected int[] get2XZoomBehaviour() {
        if (((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
            return new int[]{1, 2};
        }
        return new int[]{2, 2};
    }

    @Override
    protected double[] getMinimumViewportRange() {
        double[] range = new double[2];
        if (((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
            range[0] = 1.0;
            range[1] = 0.05 * (this.dataYMax - this.dataYMin);
        } else {
            range[0] = 0.05 * (this.dataXMax - this.dataXMin);
            range[1] = 1.0;
        }
        return range;
    }

    @Override
    protected void setColorsToChart() {
        if (this.chart == null) {
            return;
        }
        BarChart bChart = (BarChart)this.chart;
        bChart.setOutlineColor(this.colorScheme.getColorSchemeItemColor(6));
        bChart.setSelectionColor(this.colorScheme.getColorSchemeItemColor(8));
        bChart.setChartBorderColor(this.colorScheme.getColorSchemeItemColor(2));
        bChart.setBarColor(this.colorScheme.getStyle().getFillStyleElement("GraphDataStyleDefault").getFillColor());
        bChart.setStyle(this.colorScheme.getStyle());
        bChart.setDataColors(this.colorScheme.getDataColors(false, false));
        bChart.setChartWallColor(this.colorScheme.getColorSchemeItemColor(15));
        if (this.groupAxis != null) {
            this.setColorToGroupAxis();
        }
    }

    @Override
    protected void resetAxisEndPoints() {
        super.resetAxisEndPoints();
        if (this.getVariable("Group") != null && this.groupAxis != null) {
            this.setGroupAxisEndPoints();
        }
    }

    @Override
    protected void updateChartBoundingBox() {
        BarChart bChart = (BarChart)this.chart;
        if (this.chart == null) {
            return;
        }
        if (this.getVariable("Group") != null && this.groupAxis == null) {
            this.groupAxis = new Axes();
            if (this.groupAxis != null) {
                this.groupAxis.setTransformObject(this);
                this.groupAxis.addRedrawListener(this);
                bChart.setGroupAxis(this.groupAxis);
                this.setColorToGroupAxis();
            }
        }
        if (!this.userSetOuterMargin) {
            this.chartMargin = bChart.getOuterMargin((Graphics2D)this.getGraphics());
            this.chartInnerMargin = bChart.getInnerMargin();
            this.chartOuterMargin.top = this.compMargin.top + this.chartMargin.top;
            this.chartOuterMargin.bottom = this.compMargin.bottom + this.chartMargin.bottom;
            this.chartOuterMargin.left = this.compMargin.left + this.chartMargin.left;
            this.chartOuterMargin.right = this.compMargin.right + this.chartMargin.right;
        }
        this.updateChartClipArea();
        bChart.setChartClipArea(this.chartClipRect);
        this.chartBBox = bChart.getBoundingBox();
        if (this.chartBBox == null) {
            return;
        }
        if (this.xAxis != null) {
            ((Axes)this.xAxis).setOffset(0, 0);
            ((Axes)this.xAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        if (this.yAxis != null) {
            ((Axes)this.yAxis).setOffset(0, 0);
            ((Axes)this.yAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        if (this.getVariable("Group") != null && this.groupAxis != null) {
            this.setGroupAxisEndPoints();
        }
    }

    @Override
    protected void adjustBoundingBox() {
        this.updateChartBoundingBox();
        if (this.chart != null && ((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
            if (this.chartBBox != null && this.yAxis != null) {
                ((BarChart)this.chart).adjustYMinYMax();
                this.min[1] = this.dataYMin;
                this.max[1] = this.dataYMax;
            }
        } else if (this.chartBBox != null && this.xAxis != null) {
            ((BarChart)this.chart).adjustXMinXMax();
            this.min[0] = this.dataXMin;
            this.max[0] = this.dataXMax;
        }
        if (this.chartBBox != null && this.xAxis != null && this.yAxis != null) {
            ((Axes)this.xAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
            ((Axes)this.yAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        if (this.chartBBox != null && this.getVariable("Group") != null && this.groupAxis != null) {
            this.setGroupAxisEndPoints();
        }
    }

    @Override
    protected String getToolTipText(int x, int y) {
        String toolTipText = null;
        if (this.warningIcon.isMouseOverIcon(x, y)) {
            return this.warningIcon.getTooltipText();
        }
        if (toolTipText == null && this.xAxis != null) {
            toolTipText = ((Axes)this.xAxis).getToolTipText(x, y);
        }
        if (toolTipText == null && this.yAxis != null) {
            toolTipText = ((Axes)this.yAxis).getToolTipText(x, y);
        }
        if (toolTipText == null && this.chartClipRect.contains(x, y) && this.chart != null) {
            toolTipText = ((BarChart)this.chart).getToolTipText(x, y);
        }
        return toolTipText;
    }

    @Override
    protected boolean createChartElements(Object source, Object id) {
        if (this.chart == null) {
            this.chart = new BarChart();
        }
        if (this.chart != null) {
            ((BarChart)this.chart).setGraphicContent((Graphics2D)this.getGraphics());
            ((BarChart)this.chart).setDataSource(this.dataFilter);
            ((BarChart)this.chart).setTransformObject(this);
            ((BarChart)this.chart).addRedrawListener(this);
            this.setColorsToChart();
        }
        DataFilterReadInterface dataOut = null;
        if (source instanceof BarModel) {
            BarModel barModel = (BarModel)source;
            dataOut = (DataFilterReadInterface)barModel.getDataSource();
        }
        if (this.xAxis == null) {
            this.xAxis = new Axes(dataOut);
        }
        if (this.xAxis != null) {
            ((Axes)this.xAxis).setTransformObject(this);
            ((Axes)this.xAxis).addRedrawListener(this);
            this.setColorsToAxis(true);
            ((Axes)this.xAxis).setChartTip(this.toolTip);
        }
        if (this.yAxis == null) {
            this.yAxis = new Axes(dataOut);
        }
        if (this.yAxis != null) {
            ((Axes)this.yAxis).setTransformObject(this);
            ((Axes)this.yAxis).addRedrawListener(this);
            this.setColorsToAxis(false);
            ((Axes)this.yAxis).setChartTip(this.toolTip);
        }
        if (this.legend == null) {
            this.legend = new LegendObjectJ2D();
            this.addMouseListener((LegendObjectJ2D)this.legend);
            this.addMouseMotionListener((LegendObjectJ2D)this.legend);
            this.setColorsToLegend();
        }
        if (this.chart != null) {
            if (((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
                ((Axes)this.xAxis).setGridLines(new Boolean(false));
                ((Axes)this.yAxis).setGridLines(new Boolean(true));
            } else {
                ((Axes)this.xAxis).setGridLines(new Boolean(true));
                ((Axes)this.yAxis).setGridLines(new Boolean(false));
            }
            ((BarChart)this.chart).setXAxis((Axes)this.xAxis);
            ((BarChart)this.chart).setYAxis((Axes)this.yAxis);
            ((BarChart)this.chart).setLegend(this.legend);
        }
        this.warningIcon.removeAllZoomPanHandlers();
        this.xHandler = new AxisZoomPanHandler((Axes)this.xAxis);
        this.warningIcon.addZoomPanHandler(this.xHandler);
        this.yHandler = new AxisZoomPanHandler((Axes)this.yAxis);
        this.warningIcon.addZoomPanHandler(this.yHandler);
        this.xHandler.addViewportListener(this);
        this.yHandler.addViewportListener(this);
        this.addViewportListener(this.xHandler);
        this.addViewportListener(this.yHandler);
        return true;
    }

    @Override
    protected void initOtherData() {
        this.startBar = 0;
        this.endBar = Integer.MAX_VALUE;
    }

    @Override
    protected void buildOtherElements(Object buildData) {
        if (this.getVariable("Group") != null && this.groupAxis != null && this.groupAxis.isRebuildRequired()) {
            this.groupAxis.build(buildData);
        }
        if (this.updatePanels) {
            if (this.propertyDialog != null && this.propertyDialog.getActivePanel() instanceof BarPanel) {
                this.barPanel.setInitialValues();
            }
            this.updatePanels = false;
        }
        if (((BarChart)this.chart).isUserSetDisplayBarRange()) {
            int[] range = ((BarChart)this.chart).getDisplayBarRange();
            if (this.startBar == range[0] && this.endBar == range[1]) {
                return;
            }
            this.startBar = range[0];
            this.endBar = range[1];
            if (((ChartInterface)this.chart).isDataChanged()) {
                this.redrawBKBuffer = false;
            } else if (((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
                double vmin = this.startBar - 1;
                double vmax = this.endBar;
                this.setViewport(1, 1, vmin, vmax);
                this.setViewport(1, 2, this.viewportYMin, this.viewportYMax);
            } else {
                double vmin = this.startBar - 1;
                double vmax = this.endBar;
                this.setViewport(1, 2, vmin, vmax);
                this.setViewport(1, 1, this.viewportXMin, this.viewportXMax);
            }
        }
    }

    @Override
    protected boolean isTooManyBars() {
        if (this.chart == null) {
            return false;
        }
        if (((BarChart)this.chart).getBarModel() == null) {
            return false;
        }
        return ((BarChart)this.chart).getBarModel().isOutOfMemory();
    }

    @Override
    protected boolean isUpdateScrollBars() {
        return !((BarChart)this.chart).isUserSetDisplayBarRange() || !((ChartInterface)this.chart).isDataChanged();
    }

    @Override
    protected int getScrollBarTransform(int which) {
        if (((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
            if (which == 2) {
                return 1;
            }
            if (this.dataXMax - this.dataXMin > (double)(3 * this.chartClipRect.width)) {
                return 2;
            }
            return 1;
        }
        if (which == 1) {
            return 1;
        }
        if (this.dataYMax - this.dataYMin > (double)(3 * this.chartClipRect.height)) {
            return 2;
        }
        return 1;
    }

    @Override
    protected void drawOtherElements(Graphics g, boolean highlight) {
        if (this.getVariable("Group") != null && this.getVariable("subgroup") != null && this.groupAxis != null) {
            this.groupAxis.draw(g, highlight);
        }
    }

    @Override
    public void redraw(RedrawEvent e) {
        int[] range;
        if (((BarChart)this.chart).isUserSetDisplayBarRange() && !((ChartInterface)this.chart).isDataChanged() && (this.startBar != (range = ((BarChart)this.chart).getDisplayBarRange())[0] || this.endBar != range[1])) {
            this.startBar = range[0];
            this.endBar = range[1];
            if (((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
                double vmin = this.startBar - 1;
                double vmax = Math.min((double)this.endBar, this.dataXMax);
                this.setViewport(1, 1, vmin, vmax);
            } else {
                double vmin = this.startBar - 1;
                double vmax = Math.min((double)this.endBar, this.dataYMax);
                this.setViewport(1, 2, vmin, vmax);
            }
        }
        super.redraw(e);
    }

    @Override
    public void boundingBoxChanged(RedrawEvent e) {
        this.fireMarginChangeEvent(false, true);
        if (e.newBoundingBox != null) {
            double offset;
            if (e.getSource() == this.chart) {
                this.chartBBox = e.newBoundingBox;
            } else if (e.getSource() == this.yAxis) {
                this.chartBBox[1] = e.newBoundingBox[1];
                this.chartBBox[4] = e.newBoundingBox[4];
                this.dataYMin = this.chartBBox[1];
                this.dataYMax = this.chartBBox[4];
                this.min[1] = this.dataYMin;
                this.max[1] = this.dataYMax;
            } else if (e.getSource() == this.xAxis) {
                this.chartBBox[0] = e.newBoundingBox[0];
                this.chartBBox[3] = e.newBoundingBox[3];
                this.dataXMin = this.chartBBox[0];
                this.dataXMax = this.chartBBox[3];
                this.min[0] = Math.max(this.min[0], this.dataXMin);
                this.max[0] = Math.min(this.max[0], this.dataXMax);
            }
            if (this.xAxis != null) {
                ((Axes)this.xAxis).setFireEvent(false);
                if (!((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
                    double xDiff = this.dataXMax - this.chartBBox[3];
                    offset = ((BarChart)this.chart).getResponseAxisTickmarkOffset();
                    double xOffset = xDiff < offset ? offset - xDiff : 0.0;
                    ((Axes)this.xAxis).setAxis(new Double(this.chartBBox[0]), new Double(this.chartBBox[3] - xOffset), -1, 0, null, new Boolean(true), null);
                } else {
                    ((Axes)this.xAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
                }
                ((Axes)this.xAxis).setFireEvent(true);
            }
            if (this.yAxis != null) {
                ((Axes)this.yAxis).setFireEvent(false);
                if (((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
                    double yDiff = this.dataYMax - this.chartBBox[4];
                    offset = ((BarChart)this.chart).getResponseAxisTickmarkOffset();
                    double yOffset = yDiff < offset ? offset - yDiff : 0.0;
                    ((Axes)this.yAxis).setAxis(new Double(this.chartBBox[1]), new Double(this.chartBBox[4] - yOffset), -1, 0, null, new Boolean(true), null);
                } else {
                    ((Axes)this.yAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
                }
                ((Axes)this.yAxis).setFireEvent(true);
            }
            if (this.getVariable("Group") != null && this.groupAxis != null) {
                this.setGroupAxisEndPoints();
            }
            this.redrawBKBuffer = true;
            this.repaint();
        }
    }

    protected void setGroupAxisEndPoints() {
        BarChart bChart = (BarChart)this.chart;
        if (bChart.getChartType().equalsIgnoreCase("Vertical")) {
            int ht = ((BarChart)this.chart).getCategoryAxisLabelOffset((Graphics2D)this.getGraphics());
            if (this.chartInnerMargin != null) {
                ht += this.chartInnerMargin.bottom;
            }
            double[] v1 = new double[3];
            double[] v2 = new double[3];
            this.unProject(0.0, 0.0, 0.0, v1);
            this.unProject(0.0, ht, 0.0, v2);
            double axisOffset = v1[1] - v2[1];
            this.groupAxis.setFireEvent(false);
            double x1 = this.chartBBox[0];
            double x2 = this.chartBBox[3];
            double y1 = this.chartBBox[1] - axisOffset;
            double y2 = this.chartBBox[1] - axisOffset;
            if (this.xReverse) {
                x1 = this.chartBBox[3];
                x2 = this.chartBBox[0];
            }
            if (this.yReverse) {
                y1 = y2 = this.chartBBox[4] - axisOffset;
            }
            this.groupAxis.setAxisEndPoints(x1, y1, 0.0, x2, y2, 0.0);
            this.groupAxis.setFireEvent(true);
        } else {
            int ht = ((BarChart)this.chart).getCategoryAxisLabelOffset((Graphics2D)this.getGraphics());
            if (this.chartInnerMargin != null) {
                ht += this.chartInnerMargin.left;
            }
            double[] v1 = new double[3];
            double[] v2 = new double[3];
            this.unProject(0.0, 0.0, 0.0, v1);
            this.unProject(ht, 0.0, 0.0, v2);
            double axisOffset = v2[0] - v1[0];
            this.groupAxis.setFireEvent(false);
            double x1 = this.chartBBox[0] - axisOffset;
            double x2 = this.chartBBox[0] - axisOffset;
            double y1 = this.chartBBox[1];
            double y2 = this.chartBBox[4];
            if (this.xReverse) {
                x1 = x2 = this.chartBBox[3] - axisOffset;
            }
            if (this.yReverse) {
                y1 = this.chartBBox[4];
                y2 = this.chartBBox[1];
            }
            this.groupAxis.setAxisEndPoints(x1, y1, 0.0, x2, y2, 0.0);
            this.groupAxis.setFireEvent(true);
        }
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return true;
    }

    protected Frame getParentFrame(Container con) {
        Container parentFrame;
        for (parentFrame = con; parentFrame != null && !(parentFrame instanceof Frame); parentFrame = parentFrame.getParent()) {
        }
        return (Frame)parentFrame;
    }

    @Override
    protected TabbedPropertiesDialog getPropertyDialog(PropertyInterface p) {
        PropertyInterface p1 = null;
        JComponent comp = null;
        if (p != null) {
            p1 = p;
            if (p instanceof JComponent) {
                comp = (JComponent)p;
            }
        } else {
            p1 = this;
            comp = this;
        }
        if (this.propertyDialog == null) {
            this.propertyDialog = new TabbedPropertiesDialog(this.getParentFrame(this.getParent()), comp, ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Graph_Properties_Title.txt", (String)"Bar Properties"));
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Graph_Panel_Title.txt", (String)"Graph"), new GraphPanel(p1, this.toolTip));
            this.barPanel = new BarPanel(p1);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Bar_Panel_Title.txt", (String)"Bar"), this.barPanel);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Axis_Panel_Title.txt", (String)"Axis"), new AxisPanel(p1, p1));
            this.legendPanel = new LegendPanel(p1);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Legend_Panel_Title.txt", (String)"Legend"), this.legendPanel);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.TitleAndFootnote_Panel_Title.txt", (String)"Title/Footnote"), new TitlePanel(p1, comp));
            this.propertyDialog.setActiveTab(1);
        }
        return this.propertyDialog;
    }

    @Override
    protected DataOptionsDialog getDataDialog() {
        if (this.dataDialog == null) {
            this.dataDialog = new DataOptionsDialog(this, this, this.getParentFrame(this.getParent()));
        }
        return this.dataDialog;
    }

    @Override
    public Component getToolBar() {
        if (this.toolbar == null && !this.userSetToolbar) {
            this.toolbar = new SILKToolbar(this.getParentFrame(this.getParent()));
            ((SILKToolbar)this.toolbar).addListener(this);
            ((SILKToolbar)this.toolbar).setTitle(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.BarToolbar.txt", (String)"Bar Toolbar"));
        }
        return this.toolbar;
    }

    @Override
    public DataRangeInterface getRangeSource(byte dim, int index) {
        return this;
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        if (range == null) {
            return;
        }
        BarChart ch = (BarChart)this.chart;
        BarModel barModel = ch.getBarModel();
        if (dim == 1) {
            if (ch.getChartType().equalsIgnoreCase("Vertical")) {
                DiscreteRange cr = new DiscreteRange(range);
                Object[] obj = new Object[cr.getValuesSize()];
                Enumeration enum1 = cr.getEnumeration();
                int i = 0;
                while (enum1.hasMoreElements()) {
                    obj[i] = enum1.nextElement();
                    ++i;
                }
                Vector catNames = barModel.getCategoryNames();
                boolean areCatNamesEqual = true;
                if (catNames != null && catNames.size() == obj.length) {
                    for (int i2 = 0; i2 < obj.length; ++i2) {
                        if (catNames.get(i2).equals(obj[i2])) continue;
                        areCatNamesEqual = false;
                        break;
                    }
                } else {
                    areCatNamesEqual = false;
                }
                if (areCatNamesEqual) {
                    return;
                }
                barModel.setCategoryNames(obj);
                ch.setDataChange();
                ch.setDataPrepare();
                this.build(null);
            } else if (range instanceof ContinuousRange) {
                ContinuousRange cr = new ContinuousRange(range);
                ((Axes)this.xAxis).setAxis(new Double(cr.getMin()), new Double(cr.getMax()), -1, -1, null, new Boolean(true), null);
                ch.setDataChange();
                this.build(null);
            }
        } else if (dim == 2) {
            if (ch.getChartType().equalsIgnoreCase("Vertical")) {
                if (range instanceof ContinuousRange) {
                    ContinuousRange cr = new ContinuousRange(range);
                    ((Axes)this.yAxis).setAxis(new Double(cr.getMin()), new Double(cr.getMax()), -1, -1, null, new Boolean(true), null);
                    ch.setDataChange();
                    this.build(null);
                }
            } else {
                DiscreteRange cr = new DiscreteRange(range);
                Object[] obj = new Object[cr.getValuesSize()];
                Enumeration enum1 = cr.getEnumeration();
                int i = 0;
                while (enum1.hasMoreElements()) {
                    obj[i] = enum1.nextElement();
                    ++i;
                }
                Vector catNames = barModel.getCategoryNames();
                boolean areCatNamesEqual = true;
                if (catNames != null && catNames.size() == obj.length) {
                    for (int i3 = 0; i3 < obj.length; ++i3) {
                        if (catNames.get(i3).equals(obj[i3])) continue;
                        areCatNamesEqual = false;
                        break;
                    }
                } else {
                    areCatNamesEqual = false;
                }
                if (areCatNamesEqual) {
                    return;
                }
                barModel.setCategoryNames(obj);
                ch.setDataChange();
                ch.setDataPrepare();
                this.build(null);
            }
        }
    }

    public DataRange getDataRange(byte dim) {
        if (this.error == 1) {
            return null;
        }
        BarChart ch = (BarChart)this.chart;
        BarModel barModel = ch.getBarModel();
        if (dim == 1) {
            if (ch.getChartType().equalsIgnoreCase("Vertical")) {
                Map m = barModel.getUniqueNames(this.getVariable(RoleInterface.ROLE_CATEGORY));
                return new DiscreteRange(m.keySet().toArray());
            }
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            Object vRole = ch.getRole(new Integer(-3));
            Object val = barModel.getRoleValue(vRole, 0);
            if (val != null) {
                min = Math.min(0.0, ((Number)val).doubleValue());
            }
            if ((val = barModel.getRoleValue(vRole, 1)) != null) {
                max = ((Number)val).doubleValue();
            }
            Object errorHighVariable = null;
            Object errorLowVariable = null;
            Object subgroupVariable = ch.getVariableInModel("Subgroup");
            if (subgroupVariable == null && !barModel.isMultiResponses()) {
                errorHighVariable = ch.getVariableInModel("ErrorHigh");
                errorLowVariable = ch.getVariableInModel("ErrorLow");
            }
            if (errorHighVariable != null) {
                max += barModel.getMaximumValue(errorHighVariable);
            }
            if (errorLowVariable != null) {
                min -= barModel.getMaximumValue(errorLowVariable);
            }
            if (min != Double.MAX_VALUE && max != Double.MIN_VALUE) {
                return new ContinuousRange(min, max);
            }
        } else if (dim == 2) {
            if (ch.getChartType().equalsIgnoreCase("Vertical")) {
                double min = Double.MAX_VALUE;
                double max = Double.MIN_VALUE;
                Object vRole = ch.getRole(new Integer(-4));
                Object val = barModel.getRoleValue(vRole, 0);
                if (val != null) {
                    min = Math.min(0.0, ((Number)val).doubleValue());
                }
                if ((val = barModel.getRoleValue(vRole, 1)) != null) {
                    max = ((Number)val).doubleValue();
                }
                Object errorHighVariable = null;
                Object errorLowVariable = null;
                Object subgroupVariable = ch.getVariableInModel("Subgroup");
                if (subgroupVariable == null && !barModel.isMultiResponses()) {
                    errorHighVariable = ch.getVariableInModel("ErrorHigh");
                    errorLowVariable = ch.getVariableInModel("ErrorLow");
                }
                if (errorHighVariable != null) {
                    max += barModel.getMaximumValue(errorHighVariable);
                }
                if (errorLowVariable != null) {
                    min -= barModel.getMaximumValue(errorLowVariable);
                }
                if (min != Double.MAX_VALUE && max != Double.MIN_VALUE) {
                    return new ContinuousRange(min, max);
                }
            } else if (ch.getChartType().equalsIgnoreCase("Horizontal")) {
                Map m = barModel.getUniqueNames(this.getVariable(RoleInterface.ROLE_CATEGORY));
                return new DiscreteRange(m.keySet().toArray());
            }
        }
        return null;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        if (this.error == 1) {
            return new Insets(0, 0, 0, 0);
        }
        BarChart ch = (BarChart)this.chart;
        return ch.getInnerMargin();
    }

    @Override
    public void setInnerMargin(Insets margin) {
        super.setInnerMargin(margin);
        if (this.getVariable("Group") != null && this.groupAxis != null) {
            ((Axes)this.xAxis).setLabelOffset(margin.right);
            this.setGroupAxisScreenArea();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getChart() != null) {
            ((BarChart)this.getChart()).setGraphicContent((Graphics2D)this.getGraphics());
        }
    }

    @Override
    protected boolean isDiscreteAxis(String which) {
        Axes axis = which.equalsIgnoreCase("XAXIS") ? (Axes)this.xAxis : (Axes)this.yAxis;
        return (Boolean)axis.getPropertyValue(241);
    }

    protected void setGroupAxisScreenArea() {
        if (((BarChart)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
            int ht = ((Axes)this.xAxis).getBottomHeight((Graphics2D)this.getGraphics());
            this.groupAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height + ht);
        } else {
            int wt = ((Axes)this.yAxis).getLeftWidth((Graphics2D)this.getGraphics());
            this.groupAxis.setScreenArea(this.chartClipRect.x - wt, this.chartClipRect.y, this.chartClipRect.width + wt, this.chartClipRect.height);
        }
    }

    @Override
    public Object getDataSource(Object id) {
        if (this.dataFilter == null) {
            return null;
        }
        return this.dataFilter.getSource();
    }

    @Override
    public Object getDataSource() {
        return this.getDataSource(null);
    }
}

