/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.BarComponent;
import com.sas.graphics.silk.bar.AreaBar;
import com.sas.graphics.silk.bar.BarChart;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.BarPanel;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.LegendPanel;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.ResourceLoader;
import javax.swing.JComponent;

public class AreaBarComponent
extends BarComponent {
    private static final long serialVersionUID = 4993598156764589111L;

    @Override
    protected boolean createChartElements(Object source, Object id) {
        if (this.chart == null) {
            this.chart = new AreaBar();
        }
        if (this.chart != null) {
            return super.createChartElements(source, id);
        }
        return false;
    }

    @Override
    protected int getScrollBarTransform(int which) {
        int rc = 1;
        if (((AreaBar)this.chart).getChartType().equalsIgnoreCase("Vertical")) {
            if (which == 1 && !((AreaBar)this.chart).isWidth() && this.dataXMax - this.dataXMin > (double)(3 * this.chartClipRect.width)) {
                rc = 2;
            }
        } else if (which == 2 && !((AreaBar)this.chart).isWidth() && this.dataXMax - this.dataXMin > (double)(3 * this.chartClipRect.width)) {
            rc = 2;
        }
        return rc;
    }

    @Override
    protected TabbedPropertiesDialog getPropertyDialog(PropertyInterface p) {
        PropertyInterface p1 = null;
        JComponent comp = null;
        if (p != null) {
            p1 = p;
            if (p instanceof JComponent) {
                comp = (JComponent)p;
            }
        } else {
            p1 = this;
            comp = this;
        }
        if (this.propertyDialog == null) {
            this.propertyDialog = new TabbedPropertiesDialog(this.getParentFrame(this.getParent()), comp, ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Graph_Properties_Title.txt", (String)"Bar Properties"));
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Graph_Panel_Title.txt", (String)"Graph"), new GraphPanel(p1, this.toolTip));
            this.barPanel = new BarPanel(p1);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.barRB, (String)"AreaBarComponent.AreaBar_Panel_Title.txt", (String)"AreaBar"), this.barPanel);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Axis_Panel_Title.txt", (String)"Axis"), new AxisPanel(p1, p1));
            this.legendPanel = new LegendPanel(p1);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.Legend_Panel_Title.txt", (String)"Legend"), this.legendPanel);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.barRB, (String)"BarComponent.TitleAndFootnote_Panel_Title.txt", (String)"Title/Footnote"), new TitlePanel(p1, comp));
            this.propertyDialog.setActiveTab(1);
        }
        return this.propertyDialog;
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    @Override
    public synchronized boolean build(Object buildData) {
        if (this.chart == null) {
            return false;
        }
        if (!((AreaBar)this.chart).isWidthRolePresent()) {
            this.error |= 1;
            return false;
        }
        this.error &= 0xFFFFFFFE;
        return super.build(buildData);
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (role.equals(RoleInterface.ROLE_RESPONSE) && this.chart != null && this.chart instanceof BarChart) {
            ((BarChart)this.chart).setStatistic("Sum");
        }
        boolean rc = super.addRole(variableId, role);
        if (role.equals(RoleInterface.ROLE_SUBGROUP)) {
            this.updateSizes();
        }
        return rc;
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        boolean rc = super.removeRole(variableId, role);
        if (role.equals(RoleInterface.ROLE_SUBGROUP)) {
            this.updateSizes();
        }
        return rc;
    }
}

