/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.client.report;

import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentObjectDescriptor;
import com.sas.svcs.content.relationship.client.report.RelationshipDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ResourceDescriptor
extends ContentObjectDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<RelationshipDescriptor> relationships;
    private Map<String, String> attributes;

    public void addRelationship(RelationshipDescriptor relationship) {
        if (this.relationships == null) {
            this.relationships = new ArrayList<RelationshipDescriptor>();
        }
        if (!this.containsRelationship(relationship)) {
            this.relationships.add(relationship);
        }
    }

    public void removeRelationship(RelationshipDescriptor relationship) {
        if (this.relationships != null) {
            this.relationships.remove(relationship);
        }
    }

    public boolean containsRelationship(RelationshipDescriptor relationship) {
        if (this.relationships != null && relationship != null) {
            String relationshipType = relationship.getRelationshipType();
            ResourceDescriptor relatedResource = relationship.getRelatedResource();
            for (RelationshipDescriptor existingRelationship : this.relationships) {
                if (relatedResource != existingRelationship.getRelatedResource() || relationshipType == null || !relationshipType.equalsIgnoreCase(existingRelationship.getRelationshipType())) continue;
                return true;
            }
        }
        return false;
    }

    public List<RelationshipDescriptor> getRelationships() {
        if (this.relationships == null) {
            return Collections.emptyList();
        }
        return new ArrayList<RelationshipDescriptor>(this.relationships);
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        ContentComponent comp = this.getContentObject();
        return comp == null ? super.toString() : comp.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.relationships == null ? 0 : this.relationships.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceDescriptor other = (ResourceDescriptor)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.relationships == null ? other.relationships != null : !this.relationships.equals(other.relationships));
    }
}

