/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.client.report;

import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIDescriptor;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIService;
import com.sas.svcs.content.relationship.client.report.ResourceDescriptor;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RelationshipReportUtil {
    private Logger log = LogManager.getLogger(RelationshipReportUtil.class);
    private ObjectTypeUIService objectTypeUIService;

    public void setObjectTypeUIService(ObjectTypeUIService objectTypeUIService) {
        this.objectTypeUIService = objectTypeUIService;
    }

    public final String getDisplayType(String objectTypeName, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String displayName = null;
        if (this.objectTypeUIService != null) {
            try {
                Properties localizedNames;
                ObjectTypeUIDescriptor descriptor = this.objectTypeUIService.getObjectTypeDescriptorByName(objectTypeName);
                if (descriptor != null && (localizedNames = descriptor.getLocalizedNames()) != null) {
                    displayName = localizedNames.getProperty(locale.toString());
                }
            }
            catch (Exception e) {
                this.log.debug("Unable to retrieve localized type value for " + objectTypeName, (Throwable)e);
            }
        }
        return displayName == null ? objectTypeName : displayName;
    }

    public final String getDisplayType(ContentComponent comp, Locale locale) {
        String typeName = comp.getObjectTypeName();
        return this.getDisplayType(typeName, locale);
    }

    public final String getResourceName(ResourceDescriptor resource) {
        ContentComponent comp = resource.getContentObject();
        return comp == null ? "" : comp.getName();
    }

    public final String getResourcePath(ResourceDescriptor resource) {
        ContentComponent comp = resource.getContentObject();
        return comp instanceof ContentNode ? ((ContentNode)comp).getPath() : comp.getName();
    }
}

