/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.client.report;

import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.relationship.client.report.ResourceDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RelationshipReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, ResourceDescriptor> subjectCache = new LinkedHashMap<String, ResourceDescriptor>();
    private Map<String, ResourceDescriptor> relatedResourceCache = new LinkedHashMap<String, ResourceDescriptor>();

    public void addSubject(ResourceDescriptor descriptor) {
        ContentComponent comp = descriptor.getContentObject();
        if (comp == null) {
            return;
        }
        this.subjectCache.put(comp.getId(), descriptor);
    }

    public void addSubjects(List<ResourceDescriptor> descriptors) {
        for (ResourceDescriptor descriptor : descriptors) {
            this.addSubject(descriptor);
        }
    }

    public ResourceDescriptor getSubject(String id) {
        return this.subjectCache.get(id);
    }

    public boolean containsSubject(String id) {
        return this.subjectCache.containsKey(id);
    }

    public List<ResourceDescriptor> getSubjects() {
        return new ArrayList<ResourceDescriptor>(this.subjectCache.values());
    }

    public void addRelatedResource(ResourceDescriptor descriptor) {
        ContentComponent comp = descriptor.getContentObject();
        if (comp == null) {
            return;
        }
        this.relatedResourceCache.put(comp.getId(), descriptor);
    }

    public ResourceDescriptor getRelatedResource(String id) {
        return this.relatedResourceCache.get(id);
    }

    public boolean containsRelatedResource(String id) {
        return this.relatedResourceCache.containsKey(id);
    }

    public List<ResourceDescriptor> getRelatedResources() {
        return new ArrayList<ResourceDescriptor>(this.relatedResourceCache.values());
    }

    public List<ResourceDescriptor> getAllResources() {
        LinkedHashMap<String, ResourceDescriptor> tempCache = new LinkedHashMap<String, ResourceDescriptor>();
        tempCache.putAll(this.subjectCache);
        tempCache.putAll(this.relatedResourceCache);
        return new ArrayList<ResourceDescriptor>(tempCache.values());
    }
}

