/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.client;

import com.sas.codepolicy.SASScope;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.content.relationship.client.ResourceAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Resource
implements Identifiable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int resourceId;
    private String label;
    private String id;
    private long objectType;
    private Date analysisDate;
    @SASScope
    private ArrayList<ResourceAttribute> attributeMap = null;
    private Map<String, String> attributes = new HashMap<String, String>();

    public Resource(String label, long objectType, String id) {
        this.label = label;
        this.id = id;
        this.objectType = objectType;
    }

    public Resource() {
    }

    public int getResourceId() {
        return this.resourceId;
    }

    @SASScope
    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getObjectType() {
        return this.objectType;
    }

    public void setObjectType(long objectType) {
        this.objectType = objectType;
    }

    public Date getAnalysisDate() {
        return this.analysisDate;
    }

    public void setAnalysisDate(Date analysisDate) {
        this.analysisDate = analysisDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        if (null == name) {
            return;
        }
        if (this.attributeMap == null) {
            this.attributeMap = new ArrayList();
        }
        Resource resource = this;
        synchronized (resource) {
            String a = this.attributes.remove(name);
            if (a != null) {
                int deleteIndex = -1;
                for (int i = 0; i < this.attributeMap.size(); ++i) {
                    ResourceAttribute ra = this.attributeMap.get(i);
                    if (!ra.getName().equals(name)) continue;
                    deleteIndex = i;
                }
                if (deleteIndex > -1) {
                    this.attributeMap.remove(deleteIndex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, String value) {
        if (this.attributeMap == null) {
            this.attributeMap = new ArrayList();
        }
        boolean updated = false;
        Resource resource = this;
        synchronized (resource) {
            for (ResourceAttribute a : this.attributeMap) {
                if (!name.equals(a.getName())) continue;
                a.setValue(value);
                updated = true;
            }
            this.attributes.put(name, value);
        }
        if (!updated) {
            ResourceAttribute a = new ResourceAttribute(name, value);
            a.setResourceId(this.resourceId);
            Resource resource2 = this;
            synchronized (resource2) {
                this.attributeMap.add(a);
                this.attributes.put(name, value);
            }
        }
    }

    public Map<String, String> getAttributes() {
        if (null != this.attributeMap && this.attributes.size() == 0 && !this.attributeMap.isEmpty()) {
            for (ResourceAttribute type : this.attributeMap) {
                this.attributes.put(type.getName(), type.getValue());
            }
        }
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, String> attributes) {
        if (null == attributes) {
            return;
        }
        if (this.attributeMap == null) {
            this.attributeMap = new ArrayList();
        }
        Resource resource = this;
        synchronized (resource) {
            this.attributeMap.clear();
            this.attributes.clear();
            for (String key : attributes.keySet()) {
                ResourceAttribute attr = new ResourceAttribute(key, attributes.get(key));
                attr.setResourceId(this.resourceId);
                this.attributeMap.add(attr);
                this.attributes.put(key, attributes.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public boolean setAttributeMap(List<ResourceAttribute> attributes) {
        if (null == attributes) {
            return false;
        }
        if (this.attributeMap == null) {
            this.attributeMap = new ArrayList();
        }
        Resource resource = this;
        synchronized (resource) {
            this.attributeMap.clear();
            this.attributeMap.addAll(attributes);
            this.attributes.clear();
            for (ResourceAttribute ra : attributes) {
                this.attributes.put(ra.getName(), ra.getValue());
            }
        }
        return true;
    }

    @SASScope
    public List<ResourceAttribute> getAttributeMap() {
        if (this.attributeMap == null) {
            this.attributeMap = new ArrayList();
        }
        return this.attributeMap;
    }

    public boolean equals(Object obj) {
        Resource other;
        if (super.equals(obj)) {
            return true;
        }
        return obj instanceof Resource && (other = (Resource)obj).getObjectType() == this.getObjectType() && other.getId().equals(this.getId());
    }

    public String toString() {
        return this.label == null ? super.toString() : this.label;
    }
}

