/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.client;

import com.sas.codepolicy.SASScope;
import com.sas.svcs.content.relationship.client.Relationship;
import com.sas.svcs.content.relationship.client.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

public class RelationshipModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Resource resource;
    private ArrayList<Relationship> relationships = null;
    private boolean primaryResource = true;
    @SASScope
    private int resourceId;

    @SASScope
    public int getResourceId() {
        return this.resourceId;
    }

    @SASScope
    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    public RelationshipModel(Resource resource) {
        this.resource = resource;
    }

    public RelationshipModel() {
    }

    public boolean containsPrimaryResource() {
        return this.primaryResource;
    }

    public void setContainsPrimaryResource(boolean primaryResource) {
        this.primaryResource = primaryResource;
    }

    public void addRelationship(Relationship relationship) {
        if (this.relationships == null) {
            this.relationships = new ArrayList();
        }
        this.relationships.add(relationship);
    }

    public void replaceRelationships(List<Relationship> relationships) {
        if (this.relationships == null) {
            this.relationships = new ArrayList();
        }
        if (relationships != null) {
            this.relationships.clear();
            for (Relationship relNode : relationships) {
                this.relationships.add(relNode);
            }
        }
    }

    public void addRelationships(List<Relationship> relationships) {
        if (this.relationships == null) {
            this.relationships = new ArrayList();
        }
        if (relationships != null) {
            for (Relationship relNode : relationships) {
                this.relationships.add(relNode);
            }
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        Assert.notNull((Object)resource, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.resource = resource;
    }

    public List<Relationship> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new ArrayList();
        }
        return this.relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public boolean setRelationships(List<Relationship> relationships) {
        if (null == relationships) {
            return false;
        }
        if (null == this.relationships) {
            this.relationships = new ArrayList();
        }
        RelationshipModel relationshipModel = this;
        synchronized (relationshipModel) {
            this.relationships.clear();
            this.relationships.addAll(relationships);
        }
        return true;
    }
}

