/*
 * Decompiled with CFR 0.152.
 */
package com.sas.midtier.components.container.decorators;

import com.sas.common.util.PrintfFormat;
import com.sas.midtier.components.container.util.DiagnosticEnvironment;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.picocontainer.ComponentAdapter;

public class TimingProxy
implements InvocationHandler {
    private Object _instance;
    private Pattern _classPattern;
    private Pattern _methodPattern;
    private PrintfFormat _timingFormat = new PrintfFormat("%5s: %10s%2s %-60s (%-20s) (%-40s) (%-20s) (%s)");
    private PrintfFormat _paramFormat = new PrintfFormat("\r\n%48sParam[%d]=%s");
    private PrintfFormat _retvalFormat = new PrintfFormat("\r\n%48sRetval=%s");
    private String _loggingContext = "com.sas.portal.diag";
    private boolean _showParams = false;
    private boolean _showRetval = false;

    public TimingProxy(Object target, Map config) {
        if (config != null) {
            String loggingContext = (String)config.get("loggingContext");
            String classRegex = (String)config.get("classExpr");
            String methodRegex = (String)config.get("methodExpr");
            String showParams = (String)config.get("showParams");
            String showRetval = (String)config.get("showRetval");
            try {
                if (loggingContext != null) {
                    this._loggingContext = loggingContext;
                }
                if (classRegex != null && classRegex.trim().length() > 0) {
                    this._classPattern = Pattern.compile(classRegex);
                }
                if (methodRegex != null && methodRegex.trim().length() > 0) {
                    this._methodPattern = Pattern.compile(methodRegex);
                }
                if (showParams != null) {
                    this._showParams = Boolean.valueOf(showParams);
                }
                if (showRetval != null) {
                    this._showRetval = Boolean.valueOf(showRetval);
                }
            }
            catch (Exception e) {
                this._classPattern = null;
                this._methodPattern = null;
            }
        }
        this._instance = target;
        if (target instanceof ComponentAdapter) {
            String methodName = "Ctor";
            long start = System.currentTimeMillis();
            this.logStart(methodName, null);
            this._instance = ((ComponentAdapter)target).getComponentInstance();
            long end = System.currentTimeMillis();
            this.logEnd(methodName, end - start, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        proxy.getClass();
        long start = -1L;
        long end = -1L;
        boolean doTiming = false;
        Object retval = null;
        doTiming = this._classPattern == null ? true : this.evaluateExpressions(method.getDeclaringClass().getName(), method.getName());
        try {
            if (doTiming) {
                start = System.currentTimeMillis();
                this.logStart(method.getName(), args);
            }
            retval = method.invoke(this._instance, args);
            if (!doTiming) return retval;
        }
        catch (Throwable throwable) {
            if (!doTiming) throw throwable;
            end = System.currentTimeMillis();
            String retType = method.getReturnType().getName();
            boolean hasRetval = !retType.equals("void");
            this.logEnd(method.getName(), end - start, hasRetval, retval);
            throw throwable;
        }
        end = System.currentTimeMillis();
        String retType = method.getReturnType().getName();
        boolean hasRetval = !retType.equals("void");
        this.logEnd(method.getName(), end - start, hasRetval, retval);
        return retval;
    }

    private boolean evaluateExpressions(String className, String methodName) {
        boolean result = false;
        if (this._classPattern.matcher(className).matches()) {
            result = true;
            if (this._methodPattern != null) {
                result = this._methodPattern.matcher(methodName).matches();
            }
        }
        return result;
    }

    private void logStart(String methodName, Object[] args) {
        String msg = this.formatMessage(methodName, -1L);
        if (this._showParams && args != null) {
            for (int i = 0; i < args.length; ++i) {
                msg = msg + this._paramFormat.sprintf(new Object[]{"", i, this.prepareArg(args[i])});
            }
        }
        this.logMessage(msg);
    }

    private void logEnd(String methodName, long time, boolean hasRetval, Object retval) {
        String msg = this.formatMessage(methodName, time);
        if (this._showRetval && hasRetval) {
            msg = msg + this._retvalFormat.sprintf(new Object[]{"", this.prepareArg(retval)});
        }
        this.logMessage(msg);
    }

    private String prepareArg(Object arg) {
        String retval = "null";
        if (arg != null) {
            retval = arg.toString();
        }
        return retval;
    }

    private void logMessage(String msg) {
        LogManager.getLogger((String)this._loggingContext).debug(msg);
    }

    private String formatMessage(String methodName, long time) {
        String className = "";
        className = this._instance instanceof ComponentAdapter ? ((ComponentAdapter)this._instance).getComponentKey().toString() : this._instance.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        Object[] params = new Object[]{"End", NumberFormat.getInstance().format(time), "ms", className + "." + methodName + "()", DiagnosticEnvironment.getCurrentUserId(), DiagnosticEnvironment.getCurrentUrl(), DiagnosticEnvironment.getCurrentClientId(), Thread.currentThread().getName()};
        if (time < 0L) {
            params[0] = "Start";
            params[1] = "";
            params[2] = "";
        }
        String retval = this._timingFormat.sprintf(params);
        return retval;
    }
}

