/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.visuals;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TransformationStep;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SchedulingDetailsPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(SchedulingDetailsPanel.class);
    private JLabel m_lblsascommand;
    private JTextField m_txtsascommand;
    private JLabel m_lblsasbatchserver;
    private JTextField m_txtsasbatchserver;
    private JLabel m_lbldirectory;
    private JTextField m_txtdirectory;
    private JLabel m_lblsasfilename;
    private JTextField m_txtsasfilename;
    private JLabel m_lbljclfilename;
    private JTextField m_txtjclfilename;
    private JButton m_btnEditJCL;
    private DeployedFlow m_flow;
    private DeployedJob m_job;
    private String m_sascommand;
    private String m_sascommand_multiline;
    private String m_batchservername;
    private TransformationStep m_step;
    private Frame m_frame;
    private IWorkspaceServer m_WorkspaceServer;
    private ServerComponent m_sc;
    private IWorkspace m_iworkspace = null;

    public SchedulingDetailsPanel(Frame frame, DeployedJob job, DeployedFlow flow, boolean enableButtons) {
        this.m_frame = frame;
        this.m_job = job;
        this.m_flow = flow;
        this.m_sascommand = "";
        try {
            if (this.m_flow != null) {
                try {
                    this.m_step = this.m_job.getLogicalJob(this.m_flow.getTA());
                }
                catch (InvalidParameterException ex) {
                    this.m_step = null;
                }
            }
        }
        catch (MdException ex) {
            return;
        }
        catch (RemoteException ex) {
            return;
        }
        this.__initialize(enableButtons);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_frame = null;
        this.m_WorkspaceServer = null;
        this.m_iworkspace = null;
        this.m_lblsascommand = null;
        this.m_txtsascommand = null;
        this.m_lblsasbatchserver = null;
        this.m_txtsasbatchserver = null;
        this.m_lbldirectory = null;
        this.m_txtdirectory = null;
        this.m_lblsasfilename = null;
        this.m_txtsasfilename = null;
        this.m_lbljclfilename = null;
        this.m_txtjclfilename = null;
        this.m_btnEditJCL = null;
        this.m_flow = null;
        this.m_job = null;
        this.m_sascommand = null;
        this.m_sascommand_multiline = null;
        this.m_batchservername = null;
        this.m_step = null;
    }

    public boolean moveViewToData() {
        try {
            if (this.m_step != null && this.m_step.getObjectStore() != null) {
                this.m_step.updateMetadataAll();
            }
            return this.m_job.commitChanges();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (MdException ex) {
            return false;
        }
    }

    public boolean moveDataToView() {
        String jclfilename;
        String sasfilename;
        Directory directory;
        block17: {
            this.setListeningForChanges(false);
            directory = null;
            sasfilename = null;
            jclfilename = null;
            try {
                File jcl;
                File file;
                if (this.m_job == null) break block17;
                this.m_sascommand = this.m_step != null ? DeployedJob.getCmdLineProperty((Root)this.m_step) : DeployedJob.getCmdLineProperty((Root)this.m_job.getDeployedJobObject());
                if (this.m_sascommand == null) {
                    this.m_sascommand_multiline = CommandUtilities.getCommandLine((JFJob)this.m_job.getDeployedJobObject(), (String)(this.m_flow != null ? this.m_flow.getName() : null), (String)"\n");
                    if (this.m_sascommand_multiline != null) {
                        this.m_sascommand = MetaUtilities.replaceString((String)this.m_sascommand_multiline, (String)"\n", (String)" ");
                    }
                }
                if ((file = this.m_job.getSourceCode()) != null) {
                    sasfilename = file.getFileName();
                    if (file.getDirectories().size() != 0) {
                        try {
                            directory = (Directory)file.getDirectories().get(0);
                        }
                        catch (ArrayIndexOutOfBoundsException aioofe) {
                            directory = null;
                        }
                    }
                }
                ServerComponent batchserver = this.m_job.getBatchServer();
                try {
                    this.m_batchservername = batchserver.getName();
                }
                catch (NullPointerException npe) {
                    this.m_batchservername = null;
                }
                if (CommandUtilities.getTargetOSForBatchServer((ServerComponent)batchserver) == 2 && (jcl = this.m_job.getJCL()) != null) {
                    jclfilename = jcl.getFileName();
                    String ext = jcl.getFileExtension();
                    if (ext != null && ext.length() > 0) {
                        jclfilename = ext.startsWith(".") ? jclfilename + ext : jclfilename + "." + ext;
                    }
                }
            }
            catch (MdException ex) {
                this.setListeningForChanges(true);
                return false;
            }
            catch (RemoteException ex) {
                this.setListeningForChanges(true);
                return false;
            }
        }
        try {
            this.m_txtsascommand.setText(this.m_sascommand);
            this.m_txtsascommand.setToolTipText(this.m_sascommand_multiline);
            this.m_txtsasbatchserver.setText(this.m_batchservername);
            this.m_txtdirectory.setText(directory != null ? directory.getName() : null);
            this.m_txtdirectory.setToolTipText(directory != null ? directory.getDirectoryName() : null);
            this.m_txtsasfilename.setText(sasfilename);
            if (jclfilename != null) {
                this.m_txtjclfilename.setText(jclfilename);
                this.m_lbljclfilename.setVisible(true);
                this.m_txtjclfilename.setVisible(true);
                this.m_btnEditJCL.setVisible(true);
            } else {
                this.m_lbljclfilename.setVisible(false);
                this.m_txtjclfilename.setVisible(false);
                this.m_btnEditJCL.setVisible(false);
            }
        }
        catch (RemoteException ex) {
            this.setListeningForChanges(true);
            return false;
        }
        this.setListeningForChanges(true);
        return true;
    }

    public boolean validateData() {
        if (this.m_txtsascommand.getText().length() == 0) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.SASCommandError.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
            return false;
        }
        if (this.m_batchservername == null) {
            try {
                if (this.m_step == null || DeployedJob.getCmdLineProperty((Root)this.m_step) == null) {
                    MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.InvalidBatchServerError.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
                }
            }
            catch (RemoteException re) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.InvalidBatchServerError.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
                return false;
            }
            catch (MdException re) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.InvalidBatchServerError.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
                return false;
            }
        }
        if (!this.isValidFileName()) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.InvalidFilenameError.fmt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
            return false;
        }
        int filenamelength = this.m_txtsasfilename.getText().length();
        int dirnamelength = this.m_txtdirectory.getText().length();
        if (filenamelength > 0 && dirnamelength == 0) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.SASFileAndNoDirectoryError.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
            return false;
        }
        if (filenamelength == 0 && dirnamelength > 0) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.NoSASFileAndDirectoryError.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.ErrorDialog.Title.txt"), (int)0);
            return false;
        }
        return true;
    }

    private boolean isValidFileName() {
        String fileName = this.m_txtsasfilename.getText();
        if (fileName.length() == 0) {
            return true;
        }
        return MetaUtilities.isValidFilename((String)fileName);
    }

    public void __initialize(boolean enableButtons) {
        this.m_txtsascommand = new JTextField();
        this.m_txtsascommand.setEditable(false);
        String sascmdText = m_bundle.getString("SchedulingDetailsPanel.sascommand.txt");
        this.m_lblsascommand = new JLabel(Util.getLabelWithoutMnemonic((String)sascmdText));
        this.m_lblsascommand.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)sascmdText));
        this.m_lblsascommand.setLabelFor(this.m_txtsascommand);
        this.m_txtsasbatchserver = new JTextField();
        this.m_txtsasbatchserver.setEditable(false);
        String item = m_bundle.getString("SchedulingDetailsPanel.sasbatchserver.txt");
        this.m_lblsasbatchserver = new JLabel(Util.getLabelWithoutMnemonic((String)item));
        this.m_lblsasbatchserver.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)item));
        this.m_lblsasbatchserver.setLabelFor(this.m_txtsasbatchserver);
        this.m_txtdirectory = new JTextField();
        this.m_txtdirectory.setEditable(false);
        String dirText = m_bundle.getString("SchedulingDetailsPanel.directory.txt");
        this.m_lbldirectory = new JLabel(Util.getLabelWithoutMnemonic((String)dirText));
        this.m_lbldirectory.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)dirText));
        this.m_lbldirectory.setLabelFor(this.m_txtdirectory);
        this.m_txtsasfilename = new JTextField();
        this.m_txtsasfilename.setEditable(false);
        String filenameText = m_bundle.getString("SchedulingDetailsPanel.sasfilename.txt");
        this.m_lblsasfilename = new JLabel(Util.getLabelWithoutMnemonic((String)filenameText));
        this.m_lblsasfilename.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)filenameText));
        this.m_lblsasfilename.setLabelFor(this.m_txtsasfilename);
        this.m_txtjclfilename = new JTextField();
        this.m_txtjclfilename.setEditable(false);
        String jclfileText = m_bundle.getString("SchedulingDetailsPanel.jclfilename.txt");
        this.m_lbljclfilename = new JLabel(Util.getLabelWithoutMnemonic((String)jclfileText));
        this.m_lbljclfilename.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)jclfileText));
        this.m_lbljclfilename.setLabelFor(this.m_txtjclfilename);
        String btnText = m_bundle.getString("SchedulingDetailsPanel.EditJCLButton.txt");
        this.m_btnEditJCL = new JButton(Util.getLabelWithoutMnemonic((String)btnText));
        this.m_btnEditJCL.setMnemonic(Util.getDisplayedMnemonic((String)btnText));
        this.m_btnEditJCL.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)btnText));
        this.m_btnEditJCL.setToolTipText(m_bundle.getString("SchedulingDetailsPanel.EditJCLButton.ToolTip.txt"));
        this.m_btnEditJCL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SchedulingDetailsPanel.this.m_btnEditJCLOnclicked();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblsascommand, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_txtsascommand, new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 0, 0), 0, 0));
        this.add(this.m_lblsasbatchserver, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(30, 0, 0, 0), 0, 0));
        this.add(this.m_txtsasbatchserver, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 18, 2, new Insets(30, 20, 0, 0), 0, 0));
        this.add(this.m_lbldirectory, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_txtdirectory, new GridBagConstraints(1, 2, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 0, 0), 0, 0));
        this.add(this.m_lblsasfilename, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_txtsasfilename, new GridBagConstraints(1, 3, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 0, 0), 0, 0));
        this.add(this.m_lbljclfilename, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_txtjclfilename, new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 20, 0, 0), 0, 0));
        this.add(this.m_btnEditJCL, new GridBagConstraints(3, 4, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 12, 0, 0), 0, 0));
    }

    public void enableButtons(boolean enableButtons) {
        if (enableButtons) {
            this.m_btnEditJCL.setEnabled(true);
        } else {
            this.m_btnEditJCL.setEnabled(false);
        }
    }

    private void m_btnEditJCLOnclicked() {
        int PANE_WIDTH = 550;
        int PANE_HEIGHT = 300;
        int PANE_ROWS = 10;
        try {
            StandardPanel zOSPanel = new StandardPanel();
            JTextArea editpanel = new JTextArea();
            editpanel.setLineWrap(false);
            editpanel.setRows(PANE_ROWS);
            JScrollPane scrollpane = new JScrollPane(editpanel);
            scrollpane.setPreferredSize(new Dimension(PANE_WIDTH, PANE_HEIGHT));
            GridBagConstraints gbc_editpanel = new GridBagConstraints(0, 0, 1, 10, 1.0, 1.0, 14, 1, new Insets(0, 5, 0, 0), 0, 0);
            zOSPanel.setLayout((LayoutManager)new GridBagLayout());
            zOSPanel.add((Component)scrollpane, (Object)gbc_editpanel);
            ServerComponent bs = this.m_job.getBatchServer();
            if (this.checkConnectionToServer(bs) != 1) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("SchedulingDetailsPanel.ErrorMsg.UnableToConnectToAppServer.txt"), (String)m_bundle.getString("SchedulingDetailsPanel.EditJCLDlgTitle.txt"), (int)0, (int)-1);
                return;
            }
            IFileService rio = this.m_iworkspace.FileService();
            File jclFile = this.m_job.getJCL();
            String jclName = jclFile.getFileName();
            String jclExt = jclFile.getFileExtension();
            if (jclExt != null && jclExt.length() > 0) {
                jclName = jclExt.startsWith(".") ? jclName + jclExt : jclName + "." + jclExt;
            }
            String directory = null;
            if (jclFile.getDirectories().size() != 0) {
                try {
                    directory = ((Directory)jclFile.getDirectories().get(0)).getDirectoryName();
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    directory = null;
                }
            }
            String jclfile = CommandUtilities.createFullPath(directory, (String)jclName, (int)2);
            StringBuffer jcl = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)jclfile, (int)2);
            editpanel.setText(jcl.toString());
            StandardDialog dia = new StandardDialog(this.m_frame, m_bundle.getString("SchedulingDetailsPanel.EditJCLDlgTitle.txt"), true);
            dia.setMainPanel(zOSPanel);
            dia.setHelpProduct("scheduler");
            dia.setHelpTopic("jcl");
            dia.makeVisible();
            String jclText = editpanel.getText();
            CommandUtilities.saveToRemoteFile((IFileService)rio, (String)jclfile, (int)2, (String)jclText);
        }
        catch (GenericError ex) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)ex.getLocalizedMessage(), (String)m_bundle.getString("SchedulingDetailsPanel.EditJCLDlgTitle.txt"), (int)0, (int)-1);
            return;
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((Exception)((Object)mde), (String)m_bundle.getString("SchedulingDetailsPanel.EditJCLDlgTitle.txt"), (int)2);
            return;
        }
        catch (RemoteException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = ex.toString();
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)m_bundle.getString("SchedulingDetailsPanel.EditJCLDlgTitle.txt"), (int)0, (int)-1);
            return;
        }
    }

    private int checkConnectionToServer(ServerComponent mdSC) throws RemoteException, MdException {
        if (this.m_WorkspaceServer == null) {
            try {
                LogicalServer lc = (LogicalServer)mdSC.getUsedByComponents().get(0);
                ServerContext appServer = (ServerContext)lc.getUsedByComponents().get(0);
                TCPIPConnection tcpip = IWorkspaceServer.getTCPIPConnection((ServerComponent)mdSC, (String)"440196D4-90F0-11D0-9F41-00A024BB830C");
                if (tcpip == null) {
                    throw new InvalidParameterException(MetaUtilities.messageString((String)m_bundle.getString("SchedulingDetailsPanel.ErrorMsg.NoWorkspaceServer.fmt"), (Object)appServer.getName()));
                }
                String host = tcpip.getHostName();
                int port = tcpip.getPort();
                this.m_WorkspaceServer = new IWorkspaceServer(appServer, "440196D4-90F0-11D0-9F41-00A024BB830C", host, port);
                this.m_sc = IWorkspaceServer.getWorkspace((ServerContext)appServer, (String)"440196D4-90F0-11D0-9F41-00A024BB830C");
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return 3;
            }
        }
        try {
            int rc = this.m_WorkspaceServer.checkConnectionToServer(this.m_frame, this.m_sc != null ? this.m_sc : this.m_WorkspaceServer.getServerComponent(), "440196D4-90F0-11D0-9F41-00A024BB830C");
            if (rc == 1) {
                this.m_iworkspace = this.m_WorkspaceServer.getWorkspace();
            }
            return rc;
        }
        catch (InvalidParameterException ipe) {
            return 4;
        }
    }
}

