/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.visuals;

import com.sas.metadata.logical.scheduler.common.Utilities;
import com.sas.metadata.promotion.Log;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.TriggerEventDialog;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class ScheduleFlowAction
extends AbstractAction {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(ScheduleFlowAction.class);
    private static final long serialVersionUID = 1L;
    private ServerFlowInfo[] m_flows;
    private ServerUtilities m_serverUtil;
    private PromptCallbackInterface m_prompt;
    private boolean m_batch = false;

    public ScheduleFlowAction(ServerFlowInfo flow, ServerUtilities serverUtil, PromptCallbackInterface callback, boolean batchmode) {
        this.m_flows = new ServerFlowInfo[1];
        this.m_flows[0] = flow;
        this.m_serverUtil = serverUtil;
        this.m_prompt = callback;
        this.m_batch = batchmode;
        String nameText = m_bundle.getString("ScheduleFlowAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_ScheduleFlow));
        this.putValue("ShortDescription", m_bundle.getString("ScheduleFlowAction.ShortDescription.txt"));
    }

    public ScheduleFlowAction(ServerFlowInfo[] flows, ServerUtilities serverUtil, PromptCallbackInterface callback, boolean batchmode) {
        this.m_flows = flows;
        this.m_serverUtil = serverUtil;
        this.m_prompt = callback;
        this.m_batch = batchmode;
        String name = m_bundle.getString("ScheduleFlowAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)name));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)name));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_ScheduleFlow));
        this.putValue("ShortDescription", m_bundle.getString("ScheduleFlowAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Log log = Log.getInstance((String)ScheduleFlowAction.class.getName());
        String title = m_bundle.getString("ScheduleFlowAction.Title.txt");
        try {
            for (ServerFlowInfo flow : this.m_flows) {
                FlowInfo info = flow.getInfo();
                SchedulerServerInfo scheduler = info.getScheduler();
                if (scheduler == null) {
                    return;
                }
                if (info.getJobs().size() <= 0) {
                    return;
                }
                String errMessage = MetaUtilities.messageString((String)m_bundle.getString("ScheduleFlowAction.CannotSchedule.Msg.fmt"), (Object)flow.getName());
                if (Utilities.connectToSchedlingServer(flow, this.m_serverUtil, this.m_batch) != 1) {
                    this.m_prompt.warningMessageOKCancel(errMessage, title);
                    return;
                }
                if (!this.m_batch) {
                    Workspace frame = Workspace.getWorkspace();
                    TriggerEventDialog dlg = new TriggerEventDialog((Frame)frame, info, title, this.m_prompt);
                    dlg.makeVisible();
                    if (2 == dlg.getReturnValue()) {
                        return;
                    }
                }
                SchedulerResultSet rc = this.m_serverUtil.submitFlow(flow, true);
                flow.commitChangesToOMR();
                this.m_prompt.showResults(title, rc);
            }
        }
        catch (SchedulerException ex) {
            String message = MetaUtilities.messageString((String)m_bundle.getString("ScheduleFlowAction.CannotSchedule.Msg.fmt"), (Object)ex.getMessage());
            if (this.m_batch) {
                log.error((Object)message, (Throwable)ex);
            } else {
                this.m_prompt.warningMessageOKCancel(message, title);
                Workspace.getDefaultLogger().debug((Object)ex.getMessage());
            }
        }
        catch (RuntimeException ex) {
            String message = MetaUtilities.messageString((String)m_bundle.getString("ScheduleFlowAction.CannotSchedule.Msg.fmt"), (Object)ex.toString());
            if (this.m_batch) {
                log.error((Object)message, (Throwable)ex);
            }
            this.m_prompt.warningMessageOKCancel(message, title);
            Workspace.getDefaultLogger().debug((Object)ex.toString());
        }
    }
}

