/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.visuals.WAGeneralPanel;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public class JobGeneralPropertyTab
extends WAGeneralPropertyTab {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(JobGeneralPropertyTab.class);
    private static final long serialVersionUID = 1L;
    protected Frame m_frame;
    protected DeployedJob m_djob;
    protected WAGeneralPanel m_generalPanel;
    protected WATextField m_txtName;
    protected WATextArea m_description;
    private Root m_localObject;

    public JobGeneralPropertyTab(Frame frame, DeployedJob job, Root localObject) throws RemoteException {
        super((CMetadata)localObject, null, false, false, true, true);
        this.m_frame = frame;
        this.m_djob = job;
        if (this.m_djob.hasErrors()) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)this.m_djob.errorConditions(), (String)m_bundle.getString("JobGeneralPropertiesTab.Title.txt"), (int)0);
        }
        this.m_localObject = localObject;
        if (this.getComponentCount() > 0 && this.getComponent(0) instanceof WAGeneralPanel) {
            this.m_generalPanel = (WAGeneralPanel)this.getComponent(0);
            this.m_generalPanel.setSelectFolderEnabled(true);
            this.m_txtName = (WATextField)this.m_generalPanel.getNameComponent();
            this.m_description = (WATextArea)this.m_generalPanel.getDescriptionComponent();
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_generalPanel.saveSettingsAndCleanUp();
        this.m_generalPanel = null;
        this.m_txtName = null;
        this.m_description = null;
    }

    public boolean validateData() {
        String jobName = "";
        if (this.m_txtName != null) {
            jobName = this.m_txtName.getText();
        }
        if (super.validateData()) {
            if (!DeployedJob.isValidName((String)jobName)) {
                this.displayInvalidJobNameMessage();
                if (this.m_txtName != null) {
                    this.m_txtName.grabFocus();
                }
                return false;
            }
            try {
                boolean writechanges = false;
                if (this.m_djob.getName().compareTo(jobName) != 0) {
                    this.m_localObject.setName(jobName);
                    writechanges = true;
                }
                if (this.m_djob.getDescription().compareTo(this.m_description.getText()) != 0) {
                    this.m_djob.setDescription(this.m_description.getText());
                }
                if (writechanges) {
                    this.m_djob.updateChanges();
                }
            }
            catch (MdException ex) {
                String errorMessage = MetaUtilities.messageString((String)m_bundle.getString("JobGeneralPropertiesTab.UnexpectedError.Message.fmt"), (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("JobGeneralPropertiesTab.Title.txt"), (int)0);
                return false;
            }
            catch (RemoteException ex) {
                String errorMessage = MetaUtilities.messageString((String)m_bundle.getString("JobGeneralPropertiesTab.UnexpectedError.Message.fmt"), (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("JobGeneralPropertiesTab.Title.txt"), (int)0);
                return false;
            }
            catch (RuntimeException ex) {
                String errorMessage = MetaUtilities.messageString((String)m_bundle.getString("JobGeneralPropertiesTab.UnexpectedError.Message.fmt"), (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("JobGeneralPropertiesTab.Title.txt"), (int)0);
                return false;
            }
            return true;
        }
        String errorMessage = m_bundle.getString("JobGeneralPropertiesTab.ValidationFailure.Message.txt");
        MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("JobGeneralPropertiesTab.Title.txt"), (int)0);
        return false;
    }

    public void displayInvalidJobNameMessage() {
        String errorMessage = MetaUtilities.messageString((String)m_bundle.getString("JobGeneralPropertiesTab.InvalidChars.Message.fmt"), (Object)DeployedFlow.getInvalidChars());
        MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("JobGeneralPropertiesTab.Title.txt"), (int)0);
    }
}

