/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.visuals;

import com.sas.metadata.logical.scheduler.common.Utilities;
import com.sas.metadata.logical.scheduler.job.DeployedJobConnectionType;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.visuals.connections.AbstractConnectionPanel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.scheduler.api.oma.MetaUtilities;
import java.rmi.RemoteException;
import java.util.Comparator;
import java.util.Map;
import java.util.ResourceBundle;

public class DeployedJobConnectionPanel
extends AbstractConnectionPanel {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedJobConnectionPanel.class);
    private static final long serialVersionUID = 1L;

    public DeployedJobConnectionPanel(ImportOperationInterface operation, ConnectionTypeInterface type) {
        super(operation, type);
    }

    public String getDefaultSelectionValue() {
        return m_bundle.getString("DeployedJobConnectionPanel.DefaultSelection.txt");
    }

    public String getHelpTopicSuffix() {
        return "deployedjobwin";
    }

    public String getPanelBorderLabel() {
        return m_bundle.getString("DeployedJobConnectionPanel.BorderTitle.txt");
    }

    public String getPanelDescription() {
        return m_bundle.getString("DeployedJobConnectionPanel.Title.txt");
    }

    public String getPanelTitle() {
        return m_bundle.getString("DeployedJobConnectionPanel.Title.txt");
    }

    public int getSelectionType() {
        return 1;
    }

    public Comparator<?> getSourceTargetComparator() {
        return new JobComparator();
    }

    class JobComparator
    implements Comparator<Object> {
        JobComparator() {
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            if (obj1 instanceof SourceConnectionInterface && obj2 instanceof TargetConnectionInterface) {
                SourceConnectionInterface source = (SourceConnectionInterface)obj1;
                TargetConnectionInterface target = (TargetConnectionInterface)obj2;
                try {
                    CMetadata meta = target.getMetadataObject();
                    if (meta == null || !(meta instanceof JFJob)) {
                        return -1;
                    }
                    if (source.getDisplayName().equals(target.getDisplayName())) {
                        Map serverMapping;
                        ServerContext s;
                        ConnectionTypeInterface serverType;
                        String sourceServerName = null;
                        ConnectionPointInterface connection = source.getConnectionPoint();
                        if (connection != null && (serverType = DeployedJobConnectionPanel.this._importOperation.getConnectionType(AppServerConnectionType.getTypeClassName())) != null && (s = Utilities.getAppServer(serverMapping = serverType.getConnectionMapping(), connection)) != null && (sourceServerName = s.getName()) == null) {
                            sourceServerName = DeployedJobConnectionType.getAssociatedServerName(connection);
                        }
                        String targetServerName = null;
                        JFJob job = (JFJob)meta;
                        AssociationList assoc = job.getDeployedComponents(false);
                        if (assoc != null && assoc.size() > 0) {
                            targetServerName = ((CMetadata)assoc.get(0)).getName();
                        }
                        if (sourceServerName != null && sourceServerName.equals(targetServerName)) {
                            return 0;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (MdException mdException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return -1;
        }
    }
}

