/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.schedulingservers;

import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.SchedulerServerInfo;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class SchedulingServerConnectionType
extends OtherServerConnectionType
implements ConnectionTypeInterface {
    private static final String TYPE_NAME = "Scheduling Server";
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(SchedulingServerConnectionType.class);
    private List<SourceConnectionInterface> m_schedulerConnections;

    public SchedulingServerConnectionType(PromotionInterface promotionOperation) {
        super(promotionOperation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public String getLocalizedTypeName() {
        return m_bundle.getString("SchedulingServerConnectionType.ConnectionType.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.scheduler.visuals.SchedulingServerConnectionPanel";
    }

    public List<SourceConnectionInterface> getSourceConnections() {
        if (this.m_schedulerConnections == null) {
            List schedulerConnectionPoints = this._connectionManager.getConnections(ConnectionObjectType.MetadataType, "ServerComponent");
            this.m_schedulerConnections = new ArrayList<SourceConnectionInterface>(schedulerConnectionPoints.size());
            for (ConnectionPointInterface pt : schedulerConnectionPoints) {
                if (!SchedulingServerConnectionType.isScheduler(pt)) continue;
                SourceConnectionInterface sourceConnection = this.createSourceConnection(pt, pt.getName());
                this.m_schedulerConnections.add(sourceConnection);
            }
        }
        return this.m_schedulerConnections;
    }

    public List<TargetConnectionInterface> getTargetConnections() throws MdException, RemoteException {
        MdObjectStore store = this._operation.getStore();
        List targetSchedulers = MetaUtilities.getSchedulerServers((int)100, (MdStore)store, (String)this._operation.getRepositoryID());
        ArrayList<TargetConnectionInterface> tables = new ArrayList<TargetConnectionInterface>(targetSchedulers.size());
        for (CMetadata scheduler : targetSchedulers) {
            tables.add(this.createTargetConnection(scheduler, scheduler.getName()));
        }
        return tables;
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return false;
    }

    public static boolean isScheduler(ConnectionPointInterface pt) {
        String searchAttribute = pt.getSourceSearchString();
        int startIndex = searchAttribute.indexOf("ClassIdentifier");
        if (startIndex > -1) {
            int len = startIndex + "ClassIdentifier".length() + 2;
            String classid = searchAttribute.substring(len, searchAttribute.indexOf("'", len));
            SchedulerServerInfo ssi = new SchedulerServerInfo(classid);
            return ssi.getType() != null;
        }
        return false;
    }
}

