/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.job;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.scheduler.common.Utilities;
import com.sas.metadata.logical.scheduler.job.DeployedJobExportItem;
import com.sas.metadata.logical.scheduler.job.DeployedJobImportListener;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class DeployedJobExportListener
extends AbstractExportListener {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedJobExportListener.class);

    public DeployedJobExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new DeployedJobExportItem(name, id, type);
    }

    public Class[] getConnectionTypes() {
        return DeployedJobImportListener.CONNECTION_TYPES;
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException {
        Iterator i = objects.iterator();
        try {
            MdObjectStore store = operation.getStore();
            String repos = operation.getRepositoryID();
            while (i.hasNext()) {
                ExportItemInterface exportItem = (ExportItemInterface)i.next();
                String fqid = exportItem.getID();
                JFJob jfjob = MetaUtilities.getJFJob((String)fqid, (MdStore)store, (String)repos);
                ServerComponent sc = CommandUtilities.getServerComponentForJob((JFJob)jfjob);
                if (sc != null) {
                    int subtype = MetaUtilities.getBatchServerSubType((ServerComponent)sc);
                    char c = (char)subtype;
                    String batchServer = c + sc.getClassIdentifier() + ":::" + sc.getName();
                    StringReader reader = new StringReader(batchServer);
                    operation.getContentHandler().addTextContent(fqid, "###SCHJOB###", (Reader)reader);
                }
                DeployedJob djob = new DeployedJob(jfjob);
                File srcFile = djob.getSourceCode();
                File jclFile = djob.getJCL();
                if (Utilities.EXCLUDE_SOURCE_CODE_PROPERTY == null || Utilities.EXCLUDE_SOURCE_CODE_PROPERTY.length() == 0) {
                    if (srcFile == null && jclFile == null) continue;
                    IFileService rio = Utilities.getFileServer(operation.getSessionContext(), jfjob, operation.isBatchProcess() || operation.getPromotionType() == 2);
                    if (rio != null) {
                        Log log;
                        String directory;
                        if (srcFile != null) {
                            String srcName = srcFile.getFileName();
                            String srcExt = srcFile.getFileExtension();
                            if (srcExt != null && srcExt.length() > 0) {
                                srcName = srcExt.startsWith(".") ? srcName + srcExt : srcName + "." + srcExt;
                            }
                            directory = null;
                            if (srcFile.getDirectories().size() != 0) {
                                try {
                                    directory = ((Directory)srcFile.getDirectories().get(0)).getDirectoryName();
                                }
                                catch (ArrayIndexOutOfBoundsException ex) {
                                    log = Log.getInstance((String)DeployedJobExportListener.class.getName());
                                    log.error((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobExportListener.NoSourceFileExported.fmt"), (Object)djob.getName()));
                                    log.debug((Object)ex.getMessage());
                                    return 8;
                                }
                            }
                            try {
                                int os = CommandUtilities.getTargetOSForBatchServer((ServerComponent)sc);
                                String srcfile = CommandUtilities.createFullPath((String)directory, (String)srcName, (int)os);
                                StringBuffer src = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)srcfile, (int)os);
                                StringReader reader2 = new StringReader(src.toString());
                                operation.getContentHandler().addTextContent(fqid, "###SCHJOBSRC###", (Reader)reader2);
                                operation.getPropertiesFile().addProperty(exportItem.getID() + "_ExcludeContent", "false");
                            }
                            catch (GenericError ge) {
                                log = Log.getInstance((String)DeployedJobExportListener.class.getName());
                                log.error((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobExportListener.NoSourceFileExported.fmt"), (Object)djob.getName()));
                                log.debug((Object)ge);
                                operation.getPropertiesFile().addProperty(exportItem.getID() + "_ExcludeContent", "false");
                                return 8;
                            }
                        }
                        operation.getPropertiesFile().addProperty(exportItem.getID() + "_ExcludeContent", "true");
                        if (jclFile == null) continue;
                        String jclName = jclFile.getFileName();
                        String jclExt = jclFile.getFileExtension();
                        if (jclExt != null && jclExt.length() > 0) {
                            jclName = jclExt.startsWith(".") ? jclName + jclExt : jclName + "." + jclExt;
                        }
                        directory = null;
                        if (jclFile.getDirectories().size() != 0) {
                            try {
                                directory = ((Directory)jclFile.getDirectories().get(0)).getDirectoryName();
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {
                                log = Log.getInstance((String)DeployedJobExportListener.class.getName());
                                log.error((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobExportListener.NoSourceFileExported.fmt"), (Object)djob.getName()));
                                log.debug((Object)ex.getMessage());
                                return 8;
                            }
                        }
                        try {
                            String jclfile = CommandUtilities.createFullPath((String)directory, (String)jclName, (int)2);
                            StringBuffer jcl = CommandUtilities.readFromRemoteFile((IFileService)rio, (String)jclfile, (int)2);
                            StringReader reader3 = new StringReader(jcl.toString());
                            operation.getContentHandler().addTextContent(fqid, "###SCHJOBJCL###", (Reader)reader3);
                            continue;
                        }
                        catch (GenericError ge) {
                            log = Log.getInstance((String)DeployedJobExportListener.class.getName());
                            log.error((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobExportListener.NoSourceFileExported.fmt"), (Object)djob.getName()));
                            log.debug((Object)ge);
                            return 8;
                        }
                    }
                    Log log = Log.getInstance((String)DeployedJobExportListener.class.getName());
                    log.warn((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobExportListener.NoSourceFileExported.fmt"), (Object)djob.getName()));
                    log.debug((Object)"No IFileService connection established to export source file content.");
                    return 4;
                }
                operation.getPropertiesFile().addProperty(exportItem.getID() + "_ExcludeContent", "true");
                Log log = Log.getInstance((String)DeployedJobExportListener.class.getName());
                log.info((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedJobExportListener.DoNotExportSourceFile.fmt"), (Object)djob.getName()));
            }
        }
        catch (InvalidParameterException e) {
            Log log = Log.getInstance((String)DeployedJobExportListener.class.getName());
            log.debug((Object)e.getMessage());
            return 8;
        }
        catch (SchedulerException se) {
            Log log = Log.getInstance((String)DeployedJobExportListener.class.getName());
            log.debug((Object)se.getMessage());
            return 8;
        }
        catch (MdException mde) {
            Log log = Log.getInstance((String)DeployedJobExportListener.class.getName());
            log.debug((Object)mde.getMessage());
            return 8;
        }
        catch (ServiceException e) {
            Log log = Log.getInstance((String)DeployedJobExportListener.class.getName());
            log.debug((Object)e.getMessage());
            return 8;
        }
        return 0;
    }
}

