/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.flow;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.scheduler.common.Utilities;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowConnectionType;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowImportItem;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowImportNameValidator;
import com.sas.metadata.logical.scheduler.flow.DeployedFlowNameChecker;
import com.sas.metadata.logical.scheduler.job.DeployedJobConnectionType;
import com.sas.metadata.logical.scheduler.schedulingservers.SchedulingServerConnectionType;
import com.sas.metadata.logical.scheduler.visuals.PromptUtilities;
import com.sas.metadata.logical.scheduler.visuals.ScheduleFlowAction;
import com.sas.metadata.logical.server.FilePathSubstitutionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.services.TransportException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

public class DeployedFlowImportListener
extends AbstractImportListener
implements NotificationListener {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedFlowImportListener.class);
    protected static final Class[] CONNECTION_TYPES = new Class[]{SchedulingServerConnectionType.class, DeployedFlowConnectionType.class, DeployedJobConnectionType.class};
    private ContentHelper m_contentHelper;
    private HashMap<String, AssociationList> m_propertyMap;
    private MdObjectStore m_store;
    private String m_repos;

    public DeployedFlowImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new DeployedFlowImportItem(name, id, type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public void initialize(ImportOperationInterface operation) {
        operation.addNotificationListener((NotificationListener)this);
        this.m_contentHelper = new ContentHelper();
        this.m_propertyMap = new HashMap();
        this.m_repos = operation.getRepositoryID();
        try {
            this.m_store = operation.getStore().getFactory().createObjectStore(null, "DeployedFlowImportListener");
        }
        catch (RemoteException e) {
            this.m_store = operation.getStore();
        }
    }

    public Class[] getSubstitutionTypes() {
        return new Class[]{FilePathSubstitutionType.class};
    }

    public int analyzeObjectsToImport(ImportOperationInterface importHandler, List objects) throws MetadataPromotionException {
        if (importHandler.isProjectRepository()) {
            throw new MetadataPromotionException(m_bundle.getString("DeployedFlowImportListener.ProjectRepos.txt"));
        }
        int rc = 0;
        if (importHandler.getPackageFileVersion() < 9200) {
            ConnectionManagerInterface manager = importHandler.getConnectionManager();
            List schedulerConnectionPoints = manager.getConnections(ConnectionObjectType.MetadataType, "ServerComponent");
            for (ConnectionPointInterface pt : schedulerConnectionPoints) {
                if (!SchedulingServerConnectionType.isScheduler(pt)) continue;
                pt.addUserDefinedProperty("ServerType", "Scheduler");
            }
        }
        int type = importHandler.getPromotionType();
        for (DeployedFlowImportItem importItem : objects) {
            if (importItem.getImportState() == 2) {
                String targetId = importItem.getTargetID();
                try {
                    JFJob jfjob = MetaUtilities.getJFJob((String)targetId, (MdStore)this.m_store, (String)this.m_repos);
                    this.m_propertyMap.put(targetId, jfjob.getProperties());
                }
                catch (SchedulerException se) {
                    importHandler.getLogger().error((Object)se.toString(), (Throwable)se);
                    rc = 8;
                }
                catch (Exception e) {
                    importHandler.getLogger().error((Object)e.toString(), (Throwable)e);
                    rc = 8;
                }
            }
            if (type != 2 && type != 3) continue;
            importItem.setSchedule(false);
        }
        return rc;
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        int iRC = 0;
        if (objects.size() > 0) {
            DeployedFlowNameChecker nameChecker = new DeployedFlowNameChecker(operation);
            try {
                iRC = nameChecker.checkForDuplicates((TypeInterface)this.getTypeInterface());
                if (iRC == 0) {
                    iRC = this.updateTransformationsAssociations(operation);
                }
            }
            catch (RemoteException ex) {
                operation.getLogger().error((Object)ex.toString());
                operation.getLogger().debug((Object)ex);
                iRC = 8;
            }
            catch (MdException e) {
                operation.getLogger().error((Object)e.toString());
                operation.getLogger().debug((Object)e);
                iRC = 8;
            }
        } else {
            iRC = 0;
        }
        return iRC;
    }

    int updateTransformationsAssociations(ImportOperationInterface operation) throws RemoteException, MdException {
        int iRC = 0;
        List deployedFlowConnections = operation.getConnectionManager().getConnections(ConnectionObjectType.PublicType, "DeployedFlow");
        for (ConnectionPoint jfjobConnection : deployedFlowConnections) {
            String tId = jfjobConnection.getTargetID();
            if (tId != null && tId.length() != 0) continue;
            List flows = MetaUtilities.getJFJobList((String)jfjobConnection.getName(), (boolean)true, (MdStore)this.m_store, (String)this.m_repos);
            if (flows.size() == 1) {
                jfjobConnection.setTargetID(((JFJob)flows.get(0)).getId());
                continue;
            }
            iRC = 8;
        }
        return iRC;
    }

    public int updateObjects(List objects) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        int rc = 0;
        MdObjectStore store = null;
        try {
            for (DeployedFlowImportItem importItem : objects) {
                String targetId = importItem.getTargetID();
                store = this.m_store.getFactory().createObjectStore(null, "FlowImportListener_" + importItem.getName());
                JFJob jfjob = MetaUtilities.getJFJob((String)targetId, (String)"<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)store, (String)this.m_repos);
                DeployedFlow flow = null;
                ServerComponent sc = DeployedFlow.getSchedulerComponent((JFJob)jfjob);
                flow = operation.isBatchProcess() && sc.getClassIdentifier().compareTo("c8b4baf0-5f9f-488e-ba76-1201e1e81aef") == 0 ? new DeployedFlow(jfjob) : new DeployedFlow(jfjob, store);
                flow.cleanupJobProperties((List)operation.getObjectFromCache((Object)"###SCHDJOBS###"));
                int state = importItem.getImportState();
                int type = operation.getPromotionType();
                if (state == 1) {
                    flow.setFlowSubmitted(false);
                    importItem.setSchedule(false);
                } else if (type == 2 || type == 3) {
                    flow.setFlowSubmitted(false);
                    importItem.setSchedule(false);
                } else if (state == 2) {
                    List properties = (List)this.m_propertyMap.get(targetId);
                    int numprops = properties.size();
                    for (int propertyCounter = 0; propertyCounter < numprops; ++propertyCounter) {
                        Property property = (Property)properties.get(propertyCounter);
                        if (!property.getPropertyName().equalsIgnoreCase("SUBMITTED")) continue;
                        String username = property.getDefaultValue();
                        if (username.equalsIgnoreCase("0")) {
                            flow.setFlowSubmitted(false);
                            break;
                        }
                        flow.setFlowSubmitted(true);
                        break;
                    }
                }
                if (importItem.getQueue() != null) {
                    flow.setQueue(importItem.getQueue());
                }
                flow.setPFD(null);
                flow.commitChanges();
                PromptUtilities prompts = new PromptUtilities();
                ServerUtilities serverUtil = new ServerUtilities(MetaUtilities.getSessionContext(), MetaUtilities.getUserContext());
                serverUtil.setPromptCallbackInterface((PromptCallbackInterface)prompts);
                serverUtil.setDefaultMdStore(store);
                serverUtil.setDefaultMdRepository(this.m_repos);
                ServerFlowInfo info = new ServerFlowInfo(flow.getInfo(), serverUtil, (PromptCallbackInterface)prompts);
                if (flow.hasCustomCalendars()) {
                    if (Utilities.connectToSchedulingServer(info, serverUtil, operation.isBatchProcess()) == 1) {
                        if (!flow.createCustomCalendars()) {
                            operation.getLogger().warn((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedFlowImportListener.UnableToRecreateAllCustomCalendars.fmt"), (Object)flow.getName()));
                            rc = 4;
                        }
                    } else {
                        operation.getLogger().warn((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedFlowImportListener.UnableToRecreateAllCustomCalendars.fmt"), (Object)flow.getName()));
                        rc = 4;
                    }
                }
                if (!importItem.getSchedule()) continue;
                operation.getLogger().info((Object)MetaUtilities.messageString((String)m_bundle.getString("DeployedFlowImportListener.SchedulingFlow.fmt"), (Object)flow.getName()));
                ScheduleFlowAction sfa = new ScheduleFlowAction(info, serverUtil, (PromptCallbackInterface)prompts, operation.isBatchProcess());
                sfa.actionPerformed(new ActionEvent(flow, 1001, null));
            }
        }
        catch (SchedulerException se) {
            operation.getLogger().error((Object)se.toString(), (Throwable)se);
            rc = 8;
        }
        catch (Exception e) {
            TransportException ex = new TransportException((Throwable)e, e.toString());
            Log log = Log.getInstance((String)DeployedFlowImportListener.class.getName());
            log.error((Object)ex.getMessage());
            log.debug((Object)e);
            rc = 8;
        }
        finally {
            this.m_contentHelper.deleteTemporaryFiles();
            if (store != null) {
                store.dispose();
            }
        }
        return rc;
    }

    public ImportNameValidatorInterface getNameValidatorInterface() {
        return new DeployedFlowImportNameValidator();
    }

    public void notify(NotificationEvent event) {
        switch (event.getEventType()) {
            case 200: {
                if (this.m_store == null) break;
                try {
                    this.m_store.updatedMetadataAll();
                    this.m_store.dispose();
                    this.m_store = null;
                }
                catch (RemoteException e) {
                    Log log = Log.getInstance((String)DeployedFlowImportListener.class.getName());
                    log.error((Object)e.toString(), (Throwable)e);
                }
                catch (MdException e) {
                    Log log = Log.getInstance((String)DeployedFlowImportListener.class.getName());
                    log.error((Object)e.toString(), (Throwable)e);
                }
                break;
            }
        }
    }
}

