/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.common;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.metadata.logical.scheduler.job.DeployedJobConnectionType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.services.ServiceException;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;

public class Utilities {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(Utilities.class);
    private static HashMap<String, IFileService> openFileSystems = new HashMap();
    public static final String PROMOTION_TYPE_FLOW = "DeployedFlow";
    public static final String FLOW_KEY = "###SCHFLOW###";
    public static final String PROMOTION_TYPE_DJOB = "DeployedJob";
    public static final String DJOB_KEY = "###SCHJOB###";
    public static final String DJOBSRC_KEY = "###SCHJOBSRC###";
    public static final String DJOBJCL_KEY = "###SCHJOBJCL###";
    public static final String DJOBSLINKED = "###SCHDJOBS###";
    public static final String EXCLUDE_SOURCE_CODE_PROPERTY = System.getProperty("sas.internal.promotion.deployedjob.excludesourcecode");
    public static final String INCLUDE_SOURCE_CODE_PROPERTY = System.getProperty("sas.promotion.deployedjob.includesourcecode");
    public static final String EXCLUDE_CONTENT_KEY = "_ExcludeContent";
    public static final String EXCLUDE_CONTENT_VALUE = "true";
    public static final String INCLUDE_CONTENT_VALUE = "false";

    private Utilities() {
    }

    public static ServerContext getAppServer(Map<?, ?> serverMapping, ConnectionPointInterface connection) {
        if (serverMapping == null) {
            return null;
        }
        ServerContext s = null;
        String server = DeployedJobConnectionType.getAssociatedServerName(connection);
        if (server == null) {
            server = DeployedJobConnectionType.getAssociatedServerName(connection);
        }
        if (server != null) {
            TargetConnectionInterface t;
            SourceConnectionInterface sc;
            Iterator<?> iter = serverMapping.keySet().iterator();
            while (iter.hasNext() && (!(sc = (SourceConnectionInterface)iter.next()).getDisplayName().equals(server) || (s = (ServerContext)(t = (TargetConnectionInterface)serverMapping.get(sc)).getMetadataObject()) == null)) {
            }
        } else if (serverMapping != null) {
            SourceConnectionInterface sc;
            TargetConnectionInterface t;
            Iterator<?> iter = serverMapping.keySet().iterator();
            while (iter.hasNext() && (s = (ServerContext)(t = (TargetConnectionInterface)serverMapping.get(sc = (SourceConnectionInterface)iter.next())).getMetadataObject()) == null) {
            }
        } else {
            s = null;
        }
        return s;
    }

    public static void clearFileServerCache() {
        openFileSystems = new HashMap();
    }

    public static IFileService getFileServer(JFJob jfjob, boolean batchmode) throws MdException, RemoteException {
        SessionContextInterface sessionContext = MetaUtilities.getSessionContext();
        if (sessionContext != null) {
            try {
                sessionContext.getUserContext();
            }
            catch (Exception e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                sessionContext = null;
            }
        }
        if (sessionContext == null && (sessionContext = Workspace.getWorkspace().getSessionContext()) != null) {
            MetaUtilities.setSessionContext((SessionContextInterface)sessionContext);
        }
        return Utilities.getTheFileServer(sessionContext, jfjob, batchmode);
    }

    public static IFileService getFileServer(SessionContextInterface sessionContext, JFJob jfjob, boolean batchmode) throws MdException, RemoteException {
        if (!batchmode) {
            return Utilities.getFileServer(jfjob, batchmode);
        }
        return Utilities.getTheFileServer(sessionContext, jfjob, batchmode);
    }

    private static IFileService getTheFileServer(SessionContextInterface sessionContext, JFJob jfjob, boolean batchmode) throws MdException, RemoteException {
        ServerComponent sc = CommandUtilities.getServerComponentForJob((JFJob)jfjob);
        TCPIPConnection tcpip = IWorkspaceServer.getTCPIPConnection((ServerComponent)sc, (String)"440196D4-90F0-11D0-9F41-00A024BB830C");
        if (tcpip == null) {
            String message = m_bundle.getString("Utilities.getFileServer.missing.workspace.txt");
            throw new InvalidParameterException(message);
        }
        String host = tcpip.getHostName();
        int port = tcpip.getPort();
        ServerContext appServer = null;
        try {
            LogicalServer lc = (LogicalServer)sc.getUsedByComponents().get(0);
            appServer = (ServerContext)lc.getUsedByComponents().get(0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
        IFileService rio = null;
        IFileService obj = openFileSystems.get(appServer.getFQID());
        if (obj instanceof IFileService) {
            rio = obj;
        } else {
            IWorkspaceServer workspaceServer = new IWorkspaceServer(appServer, "440196D4-90F0-11D0-9F41-00A024BB830C", host, port);
            IWorkspace iworkspace = null;
            if (batchmode) {
                if (sessionContext != null) {
                    UserContextInterface userContext = sessionContext.getUserContext();
                    try {
                        if (workspaceServer.makeConnection(userContext)) {
                            iworkspace = workspaceServer.getWorkspace();
                        }
                    }
                    catch (InvalidCredentialsException e) {
                        iworkspace = null;
                    }
                    catch (FatalConnectionFactoryException e) {
                        iworkspace = null;
                    }
                    catch (ServiceException e) {
                        iworkspace = null;
                    }
                }
            } else {
                int rc = workspaceServer.checkConnectionToServer((Frame)Workspace.getWorkspace(), sc, "440196D4-90F0-11D0-9F41-00A024BB830C");
                if (rc == 1) {
                    iworkspace = workspaceServer.getWorkspace();
                }
            }
            if (iworkspace != null) {
                rio = iworkspace.FileService();
                openFileSystems.put(appServer.getFQID(), rio);
            }
        }
        return rio;
    }

    public static int connectToSchedlingServer(ServerFlowInfo flow, ServerUtilities serverUtil, boolean batch) throws SchedulerException {
        return Utilities.connectToSchedulingServer(flow, serverUtil, batch);
    }

    public static int connectToSchedulingServer(ServerFlowInfo flow, ServerUtilities serverUtil, boolean batch) throws SchedulerException {
        int rc = 0;
        String timeZone = null;
        String stdout = null;
        String stderr = null;
        String flowDefDir = null;
        int maxHistory = 0;
        int maxHistoryPerFlow = 0;
        SchedulerServerInfo scheduler = flow.getInfo().getScheduler();
        if (batch) {
            PasswordAuthentication l;
            SealedString pass;
            String user = scheduler.getUsername();
            SealedString sealedString = pass = scheduler.getPassword() != null ? new SealedString(scheduler.getPassword()) : null;
            if ((user == null || pass != null) && (l = MetaUtilities.getLoginIdentity((SchedulerServerInfo)scheduler)) != null) {
                user = l.getUserName();
                pass = new SealedString(l.getPassword());
            }
            rc = serverUtil.makeSchedulerConnection(scheduler, user, pass, timeZone, stdout, stderr, flowDefDir, maxHistory, maxHistoryPerFlow);
        } else {
            boolean connected;
            SealedString password;
            String username = scheduler.getUsername();
            SealedString sealedString = password = scheduler.getPasswordDataBinding() != null ? new SealedString(scheduler.getPasswordDataBinding()) : null;
            if (username != null && username.length() > 0 && password != null && (password != null ? password.getCharacters().length : 0) > 0) {
                rc = serverUtil.makeSchedulerConnection(scheduler, username, password, timeZone, stdout, stderr, flowDefDir, maxHistory, maxHistoryPerFlow);
            }
            if (rc != 1 && (connected = serverUtil.connectToSchedulingServer(flow, timeZone, stdout, stderr, flowDefDir, maxHistory, maxHistoryPerFlow))) {
                rc = 1;
            }
        }
        return rc;
    }

    public static MdFactory getMdFactory(boolean debug) throws RemoteException, MdException {
        MdFactory factory = MetaUtilities.getMdFactory((boolean)debug);
        if (factory == null) {
            factory = Workspace.getMdFactory();
        }
        return factory;
    }
}

