/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.scheduler.batchservers;

import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.services.TransportException;
import java.io.IOException;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class BatchServerContextValidator
implements ConnectionValidatorInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(BatchServerContextValidator.class);

    public String getConnectionTypeName() {
        return AppServerConnectionType.class.getName();
    }

    public void validate(ValidationResponse response, ImportOperationInterface importOperation, ConnectionPointInterface connection) {
        String targetID = connection.getTargetID();
        String type = connection.getMetadataType();
        String classid = "e20e54b3-e5f4-47ed-b21d-03109bf9a4b8";
        int subtype = 0;
        try {
            Map contentMap = importOperation.getContentHandler().getTextContent(connection.getSourceID());
            for (Map.Entry element : contentMap.entrySet()) {
                String key = (String)element.getKey();
                if (!"###SCHJOB###".equals(key)) continue;
                Reader in = (Reader)element.getValue();
                StringBuffer buffer = new StringBuffer();
                char[] dataBuffer = new char[1024];
                int charsRead = in.read(dataBuffer);
                while (charsRead > 0) {
                    buffer.append(dataBuffer, 0, charsRead);
                    charsRead = in.read(dataBuffer);
                }
                subtype = buffer.charAt(0);
                classid = buffer.toString().substring(1);
            }
            String options = "<Templates><ServerContext Name=\"\"><UsingComponents/></ServerContext><LogicalServer Name=\"\" ClassIdentifier=\"\"><UsingComponents/></LogicalServer><ServerComponent><Properties/></ServerComponent><Property Name=\"\" DeFaultValue=\"\"/></Templates>";
            int flags = 260;
            MdFactory factory = importOperation.getMetadataFactory();
            Map serverMap = factory.getOMIUtil().getMetadataNoCache(type, targetID, options, flags);
            if (serverMap.size() > 0) {
                List logicalServers = (List)serverMap.get("UsingComponents");
                if (logicalServers.size() > 0) {
                    Iterator iter = logicalServers.iterator();
                    while (iter.hasNext()) {
                        String classID;
                        Map logicalMap = (Map)iter.next();
                        String metadataType = (String)logicalMap.get("MetadataObjectType");
                        if (!metadataType.equals("LogicalServer") || !classid.equals(classID = (String)logicalMap.get("ClassIdentifier"))) continue;
                        List sclist = (List)logicalMap.get("UsingComponents");
                        for (Map map : sclist) {
                            List properties;
                            String metadataType2 = (String)map.get("MetadataObjectType");
                            if (!metadataType2.equals("ServerComponent") || (properties = (List)map.get("Properties")) == null || properties.size() <= 0) continue;
                            Iterator it2 = properties.iterator();
                            while (iter.hasNext()) {
                                Map map2 = (Map)it2.next();
                                String propName = (String)map2.get("Name");
                                if (!propName.equalsIgnoreCase("SubType")) continue;
                                int subType = 0;
                                String subTypeString = (String)map2.get("DefaultValue");
                                if (subTypeString.equalsIgnoreCase("MarketingAutomation")) {
                                    subType = 10;
                                } else if (subTypeString.equalsIgnoreCase("BusinessReportManager")) {
                                    subType = 11;
                                } else if (subTypeString.equalsIgnoreCase("BusinessPlanning")) {
                                    subType = 14;
                                } else if (subTypeString.equalsIgnoreCase("MarketingOptimization")) {
                                    subType = 12;
                                } else if (subTypeString.equalsIgnoreCase("OpRisk")) {
                                    subType = 21;
                                } else if (subTypeString.equalsIgnoreCase("BILineage")) {
                                    subType = 16;
                                } else if (subTypeString.equalsIgnoreCase("MetadataInvestigator")) {
                                    subType = 17;
                                } else if (subTypeString.equalsIgnoreCase("JobExecutionService")) {
                                    subType = 18;
                                } else if (subTypeString.equalsIgnoreCase("WorkflowService")) {
                                    subType = 19;
                                } else if (subTypeString.equalsIgnoreCase("WarrantyAnalysis")) {
                                    subType = 23;
                                } else if (subTypeString.equalsIgnoreCase("DigitalMarketing")) {
                                    subType = 25;
                                } else if (subTypeString.equalsIgnoreCase("RelationshipLoader")) {
                                    subType = 24;
                                } else if (subTypeString.equalsIgnoreCase("VADesigner")) {
                                    subType = 26;
                                } else if (subTypeString.equalsIgnoreCase("StoredProcess")) {
                                    subType = 15;
                                }
                                if (subType != subtype) continue;
                                return;
                            }
                        }
                    }
                }
                response.setReturnCode(2);
                response.setMessage(m_bundle.getString("BatchServerContextValidator.NoBatchServerFound.txt"));
            }
        }
        catch (RemoteException e) {
            response.setReturnCode(2);
            response.setMessage(e.getLocalizedMessage());
        }
        catch (MdException e) {
            response.setReturnCode(2);
            response.setMessage(e.getLocalizedMessage());
        }
        catch (TransportException e) {
            response.setReturnCode(2);
            response.setMessage(e.getLocalizedMessage());
        }
        catch (IOException e) {
            response.setReturnCode(2);
            response.setMessage(e.getLocalizedMessage());
        }
    }
}

