/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.authz;

import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.taglibs.TagLibConfig;
import org.springframework.security.web.context.support.SecurityWebApplicationContextUtils;

public class AccessControlListTag
extends TagSupport {
    protected static final Log logger = LogFactory.getLog(AccessControlListTag.class);
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private ApplicationContext applicationContext;
    private Object domainObject;
    private PermissionEvaluator permissionEvaluator;
    private String hasPermission = "";
    private String var;

    public int doStartTag() throws JspException {
        if (null == this.hasPermission || "".equals(this.hasPermission)) {
            return this.skipBody();
        }
        this.initializeIfRequired();
        if (this.domainObject == null) {
            logger.debug((Object)"domainObject resolved to null, so including tag body");
            return this.evalBody();
        }
        Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
        if (authentication == null) {
            logger.debug((Object)"SecurityContextHolder did not return a non-null Authentication object, so skipping tag body");
            return this.skipBody();
        }
        List<Object> requiredPermissions = this.parseHasPermission(this.hasPermission);
        for (Object requiredPermission : requiredPermissions) {
            if (this.permissionEvaluator.hasPermission(authentication, this.domainObject, requiredPermission)) continue;
            return this.skipBody();
        }
        return this.evalBody();
    }

    private List<Object> parseHasPermission(String hasPermission) {
        String[] requiredPermissions = hasPermission.split(",");
        ArrayList<Object> parsedPermissions = new ArrayList<Object>(requiredPermissions.length);
        for (String permissionToParse : requiredPermissions) {
            Object parsedPermission = permissionToParse;
            try {
                parsedPermission = Integer.parseInt(permissionToParse);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            parsedPermissions.add(parsedPermission);
        }
        return parsedPermissions;
    }

    private int skipBody() {
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)Boolean.FALSE, 1);
        }
        return TagLibConfig.evalOrSkip(false);
    }

    private int evalBody() {
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)Boolean.TRUE, 1);
        }
        return TagLibConfig.evalOrSkip(true);
    }

    protected ApplicationContext getContext(PageContext pageContext) {
        ServletContext servletContext = pageContext.getServletContext();
        return SecurityWebApplicationContextUtils.findRequiredWebApplicationContext((ServletContext)servletContext);
    }

    public Object getDomainObject() {
        return this.domainObject;
    }

    public String getHasPermission() {
        return this.hasPermission;
    }

    private void initializeIfRequired() throws JspException {
        if (this.applicationContext != null) {
            return;
        }
        this.applicationContext = this.getContext(this.pageContext);
        this.permissionEvaluator = this.getBeanOfType(PermissionEvaluator.class);
        String[] names = this.applicationContext.getBeanNamesForType(SecurityContextHolderStrategy.class);
        if (names.length == 1) {
            SecurityContextHolderStrategy strategy;
            this.securityContextHolderStrategy = strategy = (SecurityContextHolderStrategy)this.applicationContext.getBean(SecurityContextHolderStrategy.class);
        }
    }

    private <T> T getBeanOfType(Class<T> type) throws JspException {
        Map map = this.applicationContext.getBeansOfType(type);
        for (ApplicationContext context = this.applicationContext.getParent(); context != null; context = context.getParent()) {
            map.putAll(context.getBeansOfType(type));
        }
        if (map.size() == 0) {
            return null;
        }
        if (map.size() == 1) {
            return (T)map.values().iterator().next();
        }
        throw new JspException("Found incorrect number of " + type.getSimpleName() + " instances in application context - you must have only have one!");
    }

    public void setDomainObject(Object domainObject) {
        this.domainObject = domainObject;
    }

    public void setHasPermission(String hasPermission) {
        this.hasPermission = hasPermission;
    }

    public void setVar(String var) {
        this.var = var;
    }
}

