/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.authz;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.springframework.core.GenericTypeResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.WebAttributes;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.security.web.context.support.SecurityWebApplicationContextUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractAuthorizeTag {
    private String access;
    private String url;
    private String method = "GET";

    protected abstract ServletRequest getRequest();

    protected abstract ServletResponse getResponse();

    protected abstract ServletContext getServletContext();

    public boolean authorize() throws IOException {
        if (StringUtils.hasText((String)this.getAccess())) {
            return this.authorizeUsingAccessExpression();
        }
        if (StringUtils.hasText((String)this.getUrl())) {
            return this.authorizeUsingUrlCheck();
        }
        return false;
    }

    public boolean authorizeUsingAccessExpression() throws IOException {
        Expression accessExpression;
        if (this.getContext().getAuthentication() == null) {
            return false;
        }
        SecurityExpressionHandler<FilterInvocation> handler = this.getExpressionHandler();
        try {
            accessExpression = handler.getExpressionParser().parseExpression(this.getAccess());
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
        return ExpressionUtils.evaluateAsBoolean((Expression)accessExpression, (EvaluationContext)this.createExpressionEvaluationContext(handler));
    }

    protected EvaluationContext createExpressionEvaluationContext(SecurityExpressionHandler<FilterInvocation> handler) {
        FilterInvocation f = new FilterInvocation(this.getRequest(), this.getResponse(), (request, response) -> {
            throw new UnsupportedOperationException();
        });
        return handler.createEvaluationContext(this.getContext().getAuthentication(), (Object)f);
    }

    public boolean authorizeUsingUrlCheck() throws IOException {
        String contextPath = ((HttpServletRequest)this.getRequest()).getContextPath();
        Authentication currentUser = this.getContext().getAuthentication();
        return this.getPrivilegeEvaluator().isAllowed(contextPath, this.getUrl(), this.getMethod(), currentUser);
    }

    public String getAccess() {
        return this.access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method != null ? method.toUpperCase(Locale.ENGLISH) : null;
    }

    private SecurityContext getContext() {
        WebApplicationContext appContext = SecurityWebApplicationContextUtils.findRequiredWebApplicationContext((ServletContext)this.getServletContext());
        String[] names = appContext.getBeanNamesForType(SecurityContextHolderStrategy.class);
        if (names.length == 1) {
            SecurityContextHolderStrategy strategy = (SecurityContextHolderStrategy)appContext.getBean(SecurityContextHolderStrategy.class);
            return strategy.getContext();
        }
        return SecurityContextHolder.getContext();
    }

    private SecurityExpressionHandler<FilterInvocation> getExpressionHandler() throws IOException {
        WebApplicationContext appContext = SecurityWebApplicationContextUtils.findRequiredWebApplicationContext((ServletContext)this.getServletContext());
        Map handlers = appContext.getBeansOfType(SecurityExpressionHandler.class);
        for (SecurityExpressionHandler handler : handlers.values()) {
            if (!FilterInvocation.class.equals((Object)GenericTypeResolver.resolveTypeArgument(handler.getClass(), SecurityExpressionHandler.class))) continue;
            return handler;
        }
        throw new IOException("No visible WebSecurityExpressionHandler instance could be found in the application context. There must be at least one in order to support expressions in JSP 'authorize' tags.");
    }

    private WebInvocationPrivilegeEvaluator getPrivilegeEvaluator() throws IOException {
        WebInvocationPrivilegeEvaluator privEvaluatorFromRequest = (WebInvocationPrivilegeEvaluator)this.getRequest().getAttribute(WebAttributes.WEB_INVOCATION_PRIVILEGE_EVALUATOR_ATTRIBUTE);
        if (privEvaluatorFromRequest != null) {
            return privEvaluatorFromRequest;
        }
        WebApplicationContext ctx = SecurityWebApplicationContextUtils.findRequiredWebApplicationContext((ServletContext)this.getServletContext());
        Map wipes = ctx.getBeansOfType(WebInvocationPrivilegeEvaluator.class);
        if (wipes.size() == 0) {
            throw new IOException("No visible WebInvocationPrivilegeEvaluator instance could be found in the application context. There must be at least one in order to support the use of URL access checks in 'authorize' tags.");
        }
        return (WebInvocationPrivilegeEvaluator)wipes.values().toArray()[0];
    }
}

