/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc;

import java.sql.SQLException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.cache.CacheRuntimeException;

public class JdbcConnectorException
extends CacheRuntimeException {
    private static final long serialVersionUID = 1L;

    public static JdbcConnectorException createException(Exception e) {
        if (JdbcConnectorException.containsNonSerializableException(e)) {
            String message = e.getMessage() + System.lineSeparator() + ExceptionUtils.getStackTrace((Throwable)e);
            return new JdbcConnectorException(message);
        }
        return new JdbcConnectorException(e);
    }

    public static JdbcConnectorException createException(String message, Exception e) {
        if (JdbcConnectorException.containsNonSerializableException(e)) {
            message = (String)message + e.getMessage() + System.lineSeparator() + ExceptionUtils.getStackTrace((Throwable)e);
            return new JdbcConnectorException((String)message);
        }
        return new JdbcConnectorException((String)message, e);
    }

    public JdbcConnectorException(String message) {
        super(message);
    }

    private static boolean containsNonSerializableException(Exception e) {
        if (e == null) {
            return false;
        }
        if (e instanceof SQLException) {
            return true;
        }
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof SQLException)) continue;
            return true;
        }
        return false;
    }

    private JdbcConnectorException(Exception e) {
        super((Throwable)e);
    }

    private JdbcConnectorException(String message, Exception e) {
        super(message, (Throwable)e);
    }
}

