/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.labeledentity.client.helper;

import com.sas.svcs.labeledentity.client.LabeledEntityEvaluationService;
import com.sas.svcs.labeledentity.client.LabeledEntityNotFoundException;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class LabeledEntitySubstitutor {
    private static final Logger logger = LogManager.getLogger(LabeledEntitySubstitutor.class);
    private String delimiter = "$";
    private LabeledEntityEvaluationService labeledEntityEvaluator;

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Autowired
    public void setLabeledEntityEvaluationService(LabeledEntityEvaluationService service) {
        this.labeledEntityEvaluator = service;
    }

    public String getLocalizedValue(String id, Locale locale) {
        if (null == id || id.length() == 0 || null == this.labeledEntityEvaluator) {
            return id;
        }
        if (id.startsWith(this.delimiter) && id.endsWith(this.delimiter)) {
            String label = null;
            try {
                String str = id.substring(1, id.length() - 1);
                label = this.labeledEntityEvaluator.getLabel(str, locale);
            }
            catch (LabeledEntityNotFoundException ex) {
                logger.error("Labeled Entity not found " + ex);
            }
            return label;
        }
        return id;
    }

    public String getLocalizedHttpParameters(String param, Locale locale) {
        if (param != null && param.length() > 0) {
            StringBuffer http = new StringBuffer();
            int c1 = 0;
            int c2 = 0;
            StringTokenizer tok = new StringTokenizer(param, "&");
            int count = tok.countTokens();
            while (tok.hasMoreTokens()) {
                String val = tok.nextToken();
                StringTokenizer tok1 = new StringTokenizer(val, "=");
                while (tok1.hasMoreTokens()) {
                    String val1 = tok1.nextToken();
                    if (c1 > 0) {
                        http.append("=");
                    }
                    http.append(this.getLocalizedValue(val1, locale));
                    ++c1;
                }
                c1 = 0;
                if (++c2 == count) continue;
                http.append("&");
            }
            return http.toString();
        }
        return param;
    }
}

