/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.batch.core.AbstractBatchUtility2;
import com.sas.services.util.UncaughtRuntimeExceptionHandler;
import com.sas.svcs.content.relationship.batch.RB;
import com.sas.svcs.security.authentication.client.AuthenticationClient;
import com.sas.svcs.security.authentication.client.AuthenticationClientHolder;
import com.sas.text.Message;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.function.BiFunction;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public abstract class WIPServicesBatchUtility
extends AbstractBatchUtility2 {
    public static final String OPTION_HOST = "host";
    public static final String OPTION_PORT = "port";
    public static final String OPTION_USER = "user";
    public static final String OPTION_PASSWORD = "password";
    public static final String OPTION_PROTOCOL = "protocol";
    private static final String SPRING_CONFIG_RESOURCE_NAME = "/com/sas/svcs/content/relationship/batch/autowire-context.xml";
    private AuthenticationClient authClient;
    private String host;
    private String port;
    private String user;
    private String password;
    private String protocol;
    protected String springConfigResource = "/com/sas/svcs/content/relationship/batch/autowire-context.xml";
    protected ApplicationContext applicationContext;
    protected RestTemplate restTemplate;
    private String restBaseUrl;

    public void setConnection(String host, String port) {
        this.host = host;
        this.port = port;
    }

    public void setCredential(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public abstract int execute() throws Exception;

    public void executeBatch(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtRuntimeExceptionHandler(true, 8));
        try {
            if (!this.parse(args)) {
                return;
            }
            this.initializeBatchLogging();
            this.logStart();
            this.execute();
        }
        catch (Exception e) {
            this.logException(e);
        }
        this.logCompletion();
        this.terminateBatchLogging();
        System.exit(this.getReturnCode());
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_HOST, true, RB.getStringResource("WIPServicesBatchUtility.Option.Host.Desc.txt"));
        option.setArgName(RB.getStringResource("WIPServicesBatchUtility.Option.Host.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PORT, true, RB.getStringResource("WIPServicesBatchUtility.Option.Port.Desc.txt"));
        option.setArgName(RB.getStringResource("WIPServicesBatchUtility.Option.Port.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PROTOCOL, true, RB.getStringResource("WIPServicesBatchUtility.Option.Protocol.Desc.txt"));
        option.setArgName(RB.getStringResource("WIPServicesBatchUtility.Option.Protocol.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_USER, true, RB.getStringResource("WIPServicesBatchUtility.Option.User.Desc.txt"));
        option.setArgName(RB.getStringResource("WIPServicesBatchUtility.Option.User.ArgName.txt"));
        commandLineOptions.addOption(option);
        option = new Option(OPTION_PASSWORD, true, RB.getStringResource("WIPServicesBatchUtility.Option.Pass.Desc.txt"));
        option.setArgName(RB.getStringResource("WIPServicesBatchUtility.Option.Pass.ArgName.txt"));
        commandLineOptions.addOption(option);
        return commandLineOptions;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        if (!this.commandLine.hasOption(OPTION_HOST)) {
            throw new MissingOptionException(RB.getStringResource("WIPServicesBatchUtility.MissingHostOption.txt"));
        }
        if (!this.commandLine.hasOption(OPTION_PORT)) {
            throw new MissingOptionException(RB.getStringResource("WIPServicesBatchUtility.MissingPortOption.txt"));
        }
        if (!this.commandLine.hasOption(OPTION_USER) || !this.commandLine.hasOption(OPTION_PASSWORD)) {
            throw new MissingOptionException(RB.getStringResource("WIPServicesBatchUtility.MissingUserOption.txt"));
        }
        this.setConnection(this.commandLine.getOptionValue(OPTION_HOST), this.commandLine.getOptionValue(OPTION_PORT));
        this.setCredential(this.commandLine.getOptionValue(OPTION_USER), this.commandLine.getOptionValue(OPTION_PASSWORD));
        String protocol = this.commandLine.getOptionValue(OPTION_PROTOCOL);
        if (protocol != null) {
            this.setProtocol(protocol);
        }
        return true;
    }

    protected void initialize() throws Exception {
        System.getProperties().setProperty(OPTION_HOST, this.host);
        System.getProperties().setProperty(OPTION_PORT, this.port);
        if (this.protocol == null) {
            this.protocol = "http";
        }
        System.getProperties().setProperty(OPTION_PROTOCOL, this.protocol);
        this.applicationContext = new ClassPathXmlApplicationContext(this.springConfigResource);
        try {
            String CAS_URL = this.protocol + "://" + this.host + ":" + this.port + "/SASLogon";
            this.authClient = new AuthenticationClient(CAS_URL);
            this.authClient.logon(this.user, this.password);
            AuthenticationClientHolder.set((AuthenticationClient)this.authClient);
        }
        catch (Exception e) {
            throw new AuthenticationException(RB.getStringResource("WIPServicesBatchUtility.LogConnectionError.txt"), (Throwable)e);
        }
        if (this.isLogDecorations() && this.user != null) {
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"WIPServicesBatchUtility.LogConnectionInfo.fmt.txt", (Object)this.host, (Object)this.port, (Object)this.user));
        }
    }

    protected void initializeRESTServices() throws Exception {
        this.restBaseUrl = this.protocol + "://" + this.host + ":" + this.port;
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.user, this.password);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(this.host, Integer.parseInt(this.port), AuthScope.ANY_REALM), (Credentials)credentials);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
        PreAuthHttpComponentsClientHttpRequestFactory httpRequestFactory = new PreAuthHttpComponentsClientHttpRequestFactory((HttpClient)httpClient, this.host, this.user, this.password);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("REST services initialized.");
        }
    }

    protected final String generateRESTUrl(String serviceEndpoint) {
        if (serviceEndpoint == null || serviceEndpoint.isEmpty()) {
            throw new IllegalArgumentException("Invalid service endpoint");
        }
        if (this.restBaseUrl == null) {
            throw new IllegalStateException("The REST services have not been initialized");
        }
        return this.restBaseUrl + (serviceEndpoint.charAt(0) == '/' ? serviceEndpoint : "/" + serviceEndpoint);
    }

    protected void terminate() throws Exception {
        DisposableBean factory;
        if (this.authClient != null) {
            this.authClient.logout();
        }
        if (this.applicationContext != null) {
            ((ClassPathXmlApplicationContext)this.applicationContext).close();
        }
        if (this.restTemplate != null && (factory = (DisposableBean)this.restTemplate.getRequestFactory()) != null) {
            factory.destroy();
        }
    }

    protected void logWarning(String msg) {
        this.logger.warn(msg);
        if (this.returnCode < 4) {
            this.returnCode = 4;
        }
    }

    protected void logError(String msg) {
        this.logError(msg, null);
    }

    protected void logError(String msg, Throwable t) {
        if (t == null) {
            this.logger.error(msg);
        } else {
            this.logger.error(msg, t);
        }
        if (this.returnCode < 8) {
            this.returnCode = 8;
        }
    }

    private class PreAuthHttpComponentsClientHttpRequestFactory
    implements ClientHttpRequestFactory,
    DisposableBean {
        private HttpClient httpClient;
        @Nullable
        private RequestConfig requestConfig;
        private boolean bufferRequestBody = true;
        @Nullable
        private BiFunction<HttpMethod, URI, HttpContext> httpContextFactory;
        private String hostName;
        private Credentials credentials;

        private PreAuthHttpComponentsClientHttpRequestFactory(HttpClient httpClient, String hostName, String userName, String password) {
            this.httpClient = httpClient;
            this.hostName = hostName;
            this.credentials = new UsernamePasswordCredentials(userName, password);
        }

        public void setHttpClient(HttpClient httpClient) {
            Assert.notNull((Object)httpClient, (String)"HttpClient must not be null");
            this.httpClient = httpClient;
        }

        public HttpClient getHttpClient() {
            return this.httpClient;
        }

        public void setConnectTimeout(int timeout) {
            Assert.isTrue((timeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
            this.requestConfig = this.requestConfigBuilder().setConnectTimeout(timeout).build();
        }

        public void setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.requestConfig = this.requestConfigBuilder().setConnectionRequestTimeout(connectionRequestTimeout).build();
        }

        public void setReadTimeout(int timeout) {
            Assert.isTrue((timeout >= 0 ? 1 : 0) != 0, (String)"Timeout must be a non-negative value");
            this.requestConfig = this.requestConfigBuilder().setSocketTimeout(timeout).build();
        }

        public void setBufferRequestBody(boolean bufferRequestBody) {
            this.bufferRequestBody = bufferRequestBody;
        }

        public void setHttpContextFactory(BiFunction<HttpMethod, URI, HttpContext> httpContextFactory) {
            this.httpContextFactory = httpContextFactory;
        }

        public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
            HttpClient client = this.getHttpClient();
            HttpUriRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
            this.postProcessHttpRequest(httpRequest);
            HttpContext context = this.createHttpContext(httpMethod, uri);
            if (context == null) {
                context = HttpClientContext.create();
            }
            if (context.getAttribute("http.request-config") == null) {
                RequestConfig config = null;
                if (httpRequest instanceof Configurable) {
                    config = ((Configurable)httpRequest).getConfig();
                }
                if (config == null) {
                    config = this.createRequestConfig(client);
                }
                if (config != null) {
                    context.setAttribute("http.request-config", (Object)config);
                }
            }
            if (this.bufferRequestBody) {
                return new HttpComponentsClientHttpRequest(client, httpRequest, context);
            }
            return new HttpComponentsStreamingClientHttpRequest(client, httpRequest, context);
        }

        private RequestConfig.Builder requestConfigBuilder() {
            return this.requestConfig != null ? RequestConfig.copy((RequestConfig)this.requestConfig) : RequestConfig.custom();
        }

        @Nullable
        protected RequestConfig createRequestConfig(Object client) {
            if (client instanceof Configurable) {
                RequestConfig clientRequestConfig = ((Configurable)client).getConfig();
                return this.mergeRequestConfig(clientRequestConfig);
            }
            return this.requestConfig;
        }

        protected RequestConfig mergeRequestConfig(RequestConfig clientConfig) {
            int socketTimeout;
            int connectionRequestTimeout;
            if (this.requestConfig == null) {
                return clientConfig;
            }
            RequestConfig.Builder builder = RequestConfig.copy((RequestConfig)clientConfig);
            int connectTimeout = this.requestConfig.getConnectTimeout();
            if (connectTimeout >= 0) {
                builder.setConnectTimeout(connectTimeout);
            }
            if ((connectionRequestTimeout = this.requestConfig.getConnectionRequestTimeout()) >= 0) {
                builder.setConnectionRequestTimeout(connectionRequestTimeout);
            }
            if ((socketTimeout = this.requestConfig.getSocketTimeout()) >= 0) {
                builder.setSocketTimeout(socketTimeout);
            }
            return builder.build();
        }

        protected HttpUriRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
            switch (httpMethod.name()) {
                case "GET": {
                    return new HttpGet(uri);
                }
                case "HEAD": {
                    return new HttpHead(uri);
                }
                case "POST": {
                    return new HttpPost(uri);
                }
                case "PUT": {
                    return new HttpPut(uri);
                }
                case "PATCH": {
                    return new HttpPatch(uri);
                }
                case "DELETE": {
                    return new HttpDelete(uri);
                }
                case "OPTIONS": {
                    return new HttpOptions(uri);
                }
                case "TRACE": {
                    return new HttpTrace(uri);
                }
            }
            throw new IllegalArgumentException("Invalid HTTP method: " + httpMethod);
        }

        protected void postProcessHttpRequest(HttpUriRequest request) {
        }

        public void destroy() throws Exception {
            HttpClient httpClient = this.getHttpClient();
            if (httpClient instanceof Closeable) {
                ((Closeable)httpClient).close();
            }
        }

        protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
            HttpClientContext context = HttpClientContext.create();
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(new AuthScope(WIPServicesBatchUtility.this.host, Integer.parseInt(WIPServicesBatchUtility.this.port), AuthScope.ANY_REALM), this.credentials);
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(new HttpHost(this.hostName), (AuthScheme)new BasicScheme());
            context.setCredentialsProvider((CredentialsProvider)provider);
            context.setAuthCache((AuthCache)authCache);
            return context;
        }

        private class HttpComponentsClientHttpRequest
        extends AbstractClientHttpRequest {
            private final HttpClient httpClient;
            private final HttpUriRequest httpRequest;
            private final HttpContext httpContext;
            private ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream(1024);

            HttpComponentsClientHttpRequest(HttpClient client, HttpUriRequest request, HttpContext context) {
                this.httpClient = client;
                this.httpRequest = request;
                this.httpContext = context;
            }

            protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
                return this.bufferedOutput;
            }

            protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
                byte[] bytes = this.bufferedOutput.toByteArray();
                if (headers.getContentLength() < 0L) {
                    headers.setContentLength((long)bytes.length);
                }
                ClientHttpResponse result = this.executeInternal(headers, bytes);
                this.bufferedOutput = new ByteArrayOutputStream(0);
                return result;
            }

            public String getMethodValue() {
                return this.httpRequest.getMethod();
            }

            public URI getURI() {
                return this.httpRequest.getURI();
            }

            HttpContext getHttpContext() {
                return this.httpContext;
            }

            protected ClientHttpResponse executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException {
                this.addHeaders(this.httpRequest, headers);
                if (this.httpRequest instanceof HttpEntityEnclosingRequest) {
                    HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)this.httpRequest;
                    ByteArrayEntity requestEntity = new ByteArrayEntity(bufferedOutput);
                    entityEnclosingRequest.setEntity((HttpEntity)requestEntity);
                }
                HttpResponse httpResponse = this.httpClient.execute(this.httpRequest, this.httpContext);
                return new HttpComponentsClientHttpResponse(httpResponse);
            }

            void addHeaders(HttpUriRequest httpRequest, HttpHeaders headers) {
                headers.forEach((headerName, headerValues) -> {
                    if ("Cookie".equalsIgnoreCase((String)headerName)) {
                        String headerValue = StringUtils.collectionToDelimitedString((Collection)headerValues, (String)"; ");
                        httpRequest.addHeader(headerName, headerValue);
                    } else if (!"Content-Length".equalsIgnoreCase((String)headerName) && !"Transfer-Encoding".equalsIgnoreCase((String)headerName)) {
                        for (String headerValue : headerValues) {
                            httpRequest.addHeader(headerName, headerValue);
                        }
                    }
                });
            }

            public HttpMethod getMethod() {
                return this.httpRequest.getMethod() != null ? HttpMethod.valueOf((String)this.httpRequest.getMethod()) : null;
            }
        }

        private class HttpComponentsStreamingClientHttpRequest
        extends AbstractClientHttpRequest
        implements StreamingHttpOutputMessage {
            private final HttpClient httpClient;
            private final HttpUriRequest httpRequest;
            private final HttpContext httpContext;
            @Nullable
            private StreamingHttpOutputMessage.Body body;

            HttpComponentsStreamingClientHttpRequest(HttpClient client, HttpUriRequest request, HttpContext context) {
                this.httpClient = client;
                this.httpRequest = request;
                this.httpContext = context;
            }

            public String getMethodValue() {
                return this.httpRequest.getMethod();
            }

            public URI getURI() {
                return this.httpRequest.getURI();
            }

            public void setBody(StreamingHttpOutputMessage.Body body) {
                this.assertNotExecuted();
                this.body = body;
            }

            protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
                throw new UnsupportedOperationException("getBody not supported");
            }

            protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
                this.addHeaders(this.httpRequest, headers);
                if (this.httpRequest instanceof HttpEntityEnclosingRequest && this.body != null) {
                    HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)this.httpRequest;
                    StreamingHttpEntity requestEntity = new StreamingHttpEntity(this.getHeaders(), this.body);
                    entityEnclosingRequest.setEntity((HttpEntity)requestEntity);
                }
                HttpResponse httpResponse = this.httpClient.execute(this.httpRequest, this.httpContext);
                return new HttpComponentsClientHttpResponse(httpResponse);
            }

            void addHeaders(HttpUriRequest httpRequest, HttpHeaders headers) {
                headers.forEach((headerName, headerValues) -> {
                    if ("Cookie".equalsIgnoreCase((String)headerName)) {
                        String headerValue = StringUtils.collectionToDelimitedString((Collection)headerValues, (String)"; ");
                        httpRequest.addHeader(headerName, headerValue);
                    } else if (!"Content-Length".equalsIgnoreCase((String)headerName) && !"Transfer-Encoding".equalsIgnoreCase((String)headerName)) {
                        for (String headerValue : headerValues) {
                            httpRequest.addHeader(headerName, headerValue);
                        }
                    }
                });
            }

            public HttpMethod getMethod() {
                return this.httpRequest.getMethod() != null ? HttpMethod.valueOf((String)this.httpRequest.getMethod()) : null;
            }
        }

        private class HttpDelete
        extends HttpEntityEnclosingRequestBase {
            public HttpDelete(URI uri) {
                this.setURI(uri);
            }

            public String getMethod() {
                return "DELETE";
            }
        }

        private class HttpComponentsClientHttpResponse
        implements ClientHttpResponse {
            private HttpResponse httpResponse;
            @Nullable
            private HttpHeaders headers;

            HttpComponentsClientHttpResponse(HttpResponse httpResponse) {
                this.httpResponse = httpResponse;
            }

            public int getRawStatusCode() throws IOException {
                return this.httpResponse.getStatusLine().getStatusCode();
            }

            public String getStatusText() throws IOException {
                return this.httpResponse.getStatusLine().getReasonPhrase();
            }

            public HttpHeaders getHeaders() {
                if (this.headers == null) {
                    this.headers = new HttpHeaders();
                    for (Header header : this.httpResponse.getAllHeaders()) {
                        this.headers.add(header.getName(), header.getValue());
                    }
                }
                return this.headers;
            }

            public InputStream getBody() throws IOException {
                HttpEntity entity = this.httpResponse.getEntity();
                return entity != null ? entity.getContent() : StreamUtils.emptyInput();
            }

            public void close() {
                try {
                    try {
                        EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                    }
                    finally {
                        if (this.httpResponse instanceof Closeable) {
                            ((Closeable)this.httpResponse).close();
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public HttpStatusCode getStatusCode() throws IOException {
                return HttpStatusCode.valueOf((int)this.getRawStatusCode());
            }
        }

        private class StreamingHttpEntity
        implements HttpEntity {
            private final HttpHeaders headers;
            private final StreamingHttpOutputMessage.Body body;

            public StreamingHttpEntity(HttpHeaders headers, StreamingHttpOutputMessage.Body body) {
                this.headers = headers;
                this.body = body;
            }

            public boolean isRepeatable() {
                return false;
            }

            public boolean isChunked() {
                return false;
            }

            public long getContentLength() {
                return this.headers.getContentLength();
            }

            @Nullable
            public Header getContentType() {
                MediaType contentType = this.headers.getContentType();
                return contentType != null ? new BasicHeader("Content-Type", contentType.toString()) : null;
            }

            @Nullable
            public Header getContentEncoding() {
                String contentEncoding = this.headers.getFirst("Content-Encoding");
                return contentEncoding != null ? new BasicHeader("Content-Encoding", contentEncoding) : null;
            }

            public InputStream getContent() throws IOException, IllegalStateException {
                throw new IllegalStateException("No content available");
            }

            public void writeTo(OutputStream outputStream) throws IOException {
                this.body.writeTo(outputStream);
            }

            public boolean isStreaming() {
                return true;
            }

            @Deprecated
            public void consumeContent() throws IOException {
                throw new UnsupportedOperationException();
            }
        }
    }
}

