/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.svcs.common.client.ContentFilterCriteria;
import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.common.client.PathIdentifier;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.FolderTypeUtil;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.navigation.client.ContainerNode;
import com.sas.svcs.content.navigation.client.NavigationNode;
import com.sas.svcs.content.navigation.client.NavigationService;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIService;
import com.sas.svcs.content.relationship.batch.ContentBatchUtil;
import com.sas.svcs.content.relationship.batch.ContentFilterOptions;
import com.sas.svcs.content.relationship.batch.RB;
import com.sas.svcs.content.relationship.batch.WIPServicesBatchUtility;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class RelationshipBatchUtility
extends WIPServicesBatchUtility {
    protected ObjectTypeService objectTypeService;
    protected ObjectTypeUIService objectTypeUIService;
    protected NavigationService navigationService;
    protected ContentBatchUtil contentBatchUtil;
    protected ContentFilterOptions filterOptions;
    protected ContentFilterCriteria filterCriteria;
    protected List<PathIdentifier> objectList;

    public RelationshipBatchUtility(String utilityName) {
        this.utilityName = utilityName;
        this.initializeFilterOptions();
    }

    protected void initializeFilterOptions() {
        this.filterOptions = new ContentFilterOptions();
    }

    public void setObjects(List<PathIdentifier> objectList) {
        this.objectList = objectList;
    }

    public ContentFilterCriteria getFilterCriteria() {
        return this.filterCriteria;
    }

    public void setFilterCriteria(ContentFilterCriteria filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        this.objectTypeService = (ObjectTypeService)this.applicationContext.getBean(ObjectTypeService.class);
        this.objectTypeUIService = (ObjectTypeUIService)this.applicationContext.getBean(ObjectTypeUIService.class);
        this.navigationService = (NavigationService)this.applicationContext.getBean(NavigationService.class);
        this.contentBatchUtil = new ContentBatchUtil();
        this.contentBatchUtil.setObjectTypeService(this.objectTypeService);
        this.contentBatchUtil.setObjectTypeUIService(this.objectTypeUIService);
    }

    protected final void includeSubtypes(ContentFilterCriteria filter, ContentFilterOptions filterOptions) {
        List<String> types = filter.getTypes();
        if (types == null || types.isEmpty()) {
            filter.setIncludeUnknownTypes(false);
        } else if (types != null && !types.isEmpty() && filterOptions.isIncludingSubtypes()) {
            types = this.contentBatchUtil.includeSubtypes(types);
            filter.setTypes(types);
        }
    }

    protected final List<ContentComponent> getObjectsByPath(List<PathIdentifier> objectList) throws ContentException {
        LinkedHashMap<ObjectIdentity, ContentComponent> objectCache = new LinkedHashMap<ObjectIdentity, ContentComponent>();
        for (PathIdentifier identifier : objectList) {
            ObjectType type = this.contentBatchUtil.getObjectTypeFromPathIdentifier(identifier);
            if (type == null || type.getId() == -1L) {
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipBatchUtility.InvalidTypeString.fmt.txt", (Object)identifier.getTypeName(), (Object)identifier.getPath()));
                continue;
            }
            NavigationNode node = this.navigationService.getObjectByPath(identifier.getPath(), type.getId());
            if (node == null) {
                String displayType = this.contentBatchUtil.getDisplayType(identifier.getTypeName());
                this.logWarning(Message.format((ResourceBundle)RB.getResources(), (String)"RelationshipBatchUtility.ObjectNotFound.fmt.txt", (Object)displayType, (Object)identifier.getPath()));
                continue;
            }
            ObjectIdentity identity = ObjectIdentityUtils.createObjectIdentity((Identifiable)node);
            objectCache.put(identity, node.getContentObject());
            if (!type.isContainer() || !(node instanceof ContainerNode) || !FolderTypeUtil.isFolderType((long)identity.getObjectType())) continue;
            this.expandContainer((ContainerNode)node, objectCache, true);
        }
        return new ArrayList<ContentComponent>(objectCache.values());
    }

    private void expandContainer(ContainerNode container, Map<ObjectIdentity, ContentComponent> objectCache, boolean recursive) throws ObjectNotFoundException {
        List children = this.navigationService.getChildren(container);
        if (children != null && !children.isEmpty()) {
            for (NavigationNode child : children) {
                ContentComponent comp = child.getContentObject();
                ObjectIdentity identity = ObjectIdentityUtils.createObjectIdentity((Identifiable)child);
                if (objectCache.containsKey(identity) || comp == null) continue;
                objectCache.put(identity, comp);
                ObjectType childType = this.objectTypeService.getTypeById(identity.getObjectType());
                if (!recursive || !(child instanceof ContainerNode) || !FolderTypeUtil.isFolderType((long)childType.getId())) continue;
                this.expandContainer((ContainerNode)child, objectCache, recursive);
            }
        }
    }

    @Override
    protected Options getCommandLineOptions(boolean forHelpText) {
        Options commandLineOptions = super.getCommandLineOptions(forHelpText);
        this.filterOptions.addToOptions(commandLineOptions);
        return commandLineOptions;
    }

    @Override
    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        this.filterOptions.parse(this.commandLine);
        this.setFilterCriteria(this.filterOptions.getFilter());
        return true;
    }
}

