/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObjectDescriptor;
import com.sas.svcs.content.lookup.client.LookupService;
import com.sas.svcs.content.relationship.batch.ContentBatchUtil;
import com.sas.svcs.content.relationship.batch.RB;
import com.sas.svcs.content.relationship.client.RelationshipException;
import com.sas.svcs.content.relationship.client.RelationshipType;
import com.sas.svcs.content.relationship.client.RelationshipTypeService;
import com.sas.svcs.content.relationship.client.report.RelationshipReport;
import com.sas.svcs.content.relationship.client.report.ResourceDescriptor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OutputWriter {
    private static final String DEFAULT_FILE_NAME = "RelationshipReport_";
    static final String NEW_LINE = System.getProperty("line.separator");
    protected ContentBatchUtil contentBatchUtil;
    private LookupService lookupService;
    private Writer writer;
    private RelationshipTypeService relationshipTypeService;
    private Map<String, RelationshipType> relationshipTypeCache;

    protected abstract String getFileExtension();

    protected abstract void printOutput(RelationshipReport var1, Writer var2) throws IOException;

    protected void setRelationshipTypeService(RelationshipTypeService relationshipTypeService) {
        this.relationshipTypeService = relationshipTypeService;
    }

    protected void setContentBatchUtil(ContentBatchUtil contentBatchUtil) {
        this.contentBatchUtil = contentBatchUtil;
    }

    protected void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printOutput(RelationshipReport report, File outputFile) throws IOException, RelationshipException {
        this.initializeWriter(outputFile);
        this.relationshipTypeCache = new HashMap<String, RelationshipType>(10);
        List types = this.relationshipTypeService.getRelationshipTypes();
        for (RelationshipType type : types) {
            this.relationshipTypeCache.put(type.getRelationshipType(), type);
        }
        try {
            this.printOutput(report, this.writer);
        }
        finally {
            this.closeWriter(outputFile);
        }
    }

    private void closeWriter(File outputFile) throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            if (this.writer instanceof FileWriter) {
                this.writer.close();
            }
        }
    }

    private void initializeWriter(File outputFile) throws IOException {
        if (outputFile == null) {
            this.writer = new PrintWriter(System.out, true);
        } else {
            File file = null;
            if (outputFile.isDirectory()) {
                String fileName = DEFAULT_FILE_NAME + System.currentTimeMillis() + "." + this.getFileExtension();
                file = new File(outputFile, fileName);
            } else {
                file = outputFile;
            }
            this.writer = new FileWriter(file);
        }
    }

    protected String getRelationshipTypeLabel(String type) {
        RelationshipType relationshipType = this.relationshipTypeCache.get(type);
        return relationshipType == null ? RB.getStringResource("OutputWriter.UnknownRelType.txt") : relationshipType.getName();
    }

    protected final String getRelationshipTypePartnerLabel(String type) {
        RelationshipType relationshipType = this.relationshipTypeCache.get(type);
        if (relationshipType == null) {
            return RB.getStringResource("OutputWriter.UnknownRelType.txt");
        }
        return relationshipType.getPartnerName() == null ? relationshipType.getName() : relationshipType.getPartnerName();
    }

    protected final boolean isRelationshipDirectional(String type) {
        RelationshipType relationshipType = this.relationshipTypeCache.get(type);
        return relationshipType == null ? false : relationshipType.isDirectional();
    }

    protected final String getResourceName(ResourceDescriptor resource) {
        ContentComponent comp = resource.getContentObject();
        return comp == null ? "" : comp.getName();
    }

    protected final String getResourcePath(ResourceDescriptor resource) {
        ContentComponent comp = resource.getContentObject();
        return comp instanceof ContentNode ? ((ContentNode)comp).getPath() : comp.getName();
    }

    protected final ContentObjectDescriptor fetchObject(ObjectIdentity identity) {
        return this.lookupService.getContentObjectById(identity);
    }
}

