/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.batch.core.BaseFilterOptions;
import com.sas.batch.core.DateParser;
import com.sas.svcs.common.client.ContentFilterCriteria;
import com.sas.svcs.common.client.ContentMatchType;
import com.sas.svcs.common.client.FolderContentFilterCriteria;

public class ContentFilterOptions
extends BaseFilterOptions {
    protected ContentFilterCriteria filter = null;

    public ContentFilterCriteria getFilter() {
        this.setFolderFilter();
        this.setNameFilter();
        this.setTypeFilter();
        this.setDateFilter();
        this.setKeywordFilter();
        this.setResponsibilitiesFilter();
        return this.filter;
    }

    protected void initializeFilter() {
        if (this.filter == null) {
            this.filter = new FolderContentFilterCriteria();
        }
    }

    private void setFolderFilter() {
        if (this.filterFolderTree != null) {
            this.initializeFilter();
            ((FolderContentFilterCriteria)this.filter).setFolder(this.filterFolderTree);
            ((FolderContentFilterCriteria)this.filter).setSearchingSubfolders(true);
        } else if (this.filterFolder != null) {
            this.initializeFilter();
            ((FolderContentFilterCriteria)this.filter).setFolder(this.filterFolder);
            ((FolderContentFilterCriteria)this.filter).setSearchingSubfolders(false);
        }
    }

    private void setTypeFilter() {
        if (this.types != null) {
            this.initializeFilter();
            this.filter.setTypes(this.types);
        }
    }

    private void setNameFilter() {
        if (this.name != null && this.name.length() > 0) {
            this.initializeFilter();
            ContentMatchType matchType = null;
            matchType = this.nameMatchType != null && this.nameMatchType.length() > 0 ? ContentMatchType.fromString((String)this.nameMatchType) : ContentMatchType.MATCH_CONTAINS;
            this.filter.setName(this.name);
            this.filter.setIncludeDescription(this.includeDescription);
            this.filter.setNameTypeMatch(matchType);
        }
    }

    private void setDateFilter() {
        if (this.sinceDate != null || this.beforeDate != null) {
            this.validateDateOptions(this.sinceDate, this.beforeDate);
            DateParser dateParser = DateParser.getInstance();
            this.initializeFilter();
            this.filter.setSince(dateParser.parseDate(this.sinceDate));
            this.filter.setBefore(dateParser.parseDate(this.beforeDate));
            if (this.modified || !this.modified && !this.created) {
                this.filter.setUseModifiedDate(true);
            } else if (this.created) {
                this.filter.setUseModifiedDate(false);
            }
        }
    }

    private void setKeywordFilter() {
        if (this.keywords != null) {
            this.initializeFilter();
            this.filter.setKeywords(this.keywords);
        }
    }

    private void setResponsibilitiesFilter() {
        if (this.respUserName != null && this.respUserName.length() > 0) {
            this.initializeFilter();
            this.filter.setResponsibilityUser(this.respUserName);
            if (this.respRole != null && this.respRole.length() > 0) {
                this.filter.setResponsibilityRole(this.respRole);
            }
        }
    }

    public boolean isIncludingSubtypes() {
        return !this.excludeSubtypes;
    }
}

