/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.relationship.batch;

import com.sas.svcs.content.relationship.batch.OutputWriter;
import com.sas.svcs.content.relationship.client.report.RelationshipDescriptor;
import com.sas.svcs.content.relationship.client.report.RelationshipReport;
import com.sas.svcs.content.relationship.client.report.ResourceDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CSVOutputWriter
extends OutputWriter {
    @Override
    protected String getFileExtension() {
        return "csv";
    }

    @Override
    protected void printOutput(RelationshipReport report, Writer writer) throws IOException {
        writer.write("SubjectIndex,Depth,LeftName,LeftPath,LeftType,LeftTypeLabel,RelationshipType,Direction,RightName,RightPath,RightType,RightTypeLabel");
        writer.write(NEW_LINE);
        int index = 1;
        List subjects = report.getSubjects();
        for (ResourceDescriptor subject : subjects) {
            HashSet<ResourceDescriptor> resourceCache = new HashSet<ResourceDescriptor>();
            this.printRelationships(subject, writer, index++, 0, resourceCache);
            writer.flush();
        }
    }

    private void printRelationships(ResourceDescriptor resource, Writer writer, int subjectIndex, int level, Set<ResourceDescriptor> resourceCache) throws IOException {
        if (resourceCache.contains(resource)) {
            return;
        }
        resourceCache.add(resource);
        List relationships = resource.getRelationships();
        if (level == 0 && relationships.isEmpty()) {
            StringBuilder line = new StringBuilder(200);
            this.addCSVElement(line, String.valueOf(subjectIndex));
            this.addCSVElement(line, String.valueOf(level));
            this.addCSVElement(line, this.getResourceName(resource));
            this.addCSVElement(line, this.getResourcePath(resource));
            this.addCSVElement(line, resource.getContentObject().getObjectTypeName());
            this.addCSVElement(line, this.contentBatchUtil.getDisplayType(resource.getContentObject()));
            writer.write(line.toString());
            writer.write(NEW_LINE);
        } else if (!relationships.isEmpty()) {
            for (RelationshipDescriptor relationship : relationships) {
                ResourceDescriptor relatedResource = relationship.getRelatedResource();
                if (relatedResource == null) continue;
                StringBuilder line = new StringBuilder(200);
                this.addCSVElement(line, String.valueOf(subjectIndex));
                this.addCSVElement(line, String.valueOf(level));
                this.addCSVElement(line, this.getResourceName(resource));
                this.addCSVElement(line, this.getResourcePath(resource));
                this.addCSVElement(line, resource.getContentObject().getObjectTypeName());
                this.addCSVElement(line, this.contentBatchUtil.getDisplayType(resource.getContentObject()));
                this.addCSVElement(line, this.getRelationshipTypeLabel(relationship.getRelationshipType()));
                this.addCSVElement(line, relationship.getDirection().getStringValue());
                this.addCSVElement(line, this.getResourceName(relatedResource));
                this.addCSVElement(line, this.getResourcePath(relatedResource));
                this.addCSVElement(line, relatedResource.getContentObject().getObjectTypeName());
                this.addCSVElement(line, this.contentBatchUtil.getDisplayType(relatedResource.getContentObject()));
                writer.write(line.toString());
                writer.write(NEW_LINE);
                this.printRelationships(relatedResource, writer, subjectIndex, level + 1, resourceCache);
            }
        }
    }

    private void addCSVElement(StringBuilder line, String element) {
        if (line.length() > 0) {
            line.append(",");
        }
        if (element == null) {
            return;
        }
        if (element.contains("\"")) {
            line.append("\"" + element.replaceAll("\"", "\"\"") + "\"");
        } else if (element.contains(",")) {
            line.append("\"" + element + "\"");
        } else {
            line.append(element);
        }
    }
}

