/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.sessions;

import com.sas.iom.SASIOMCommon.IServerSessions;
import com.sas.iom.SASIOMCommon.IServerSessionsHelper;
import com.sas.iom.SASIOMCommonEvents.IServerSessionEventsHelper;
import com.sas.iom.SASIOMCommonEvents._IServerSessionEventsImplBase;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.management.impl.ModelImpl;
import com.sas.management.servers.ServerConnectionEvent;
import com.sas.management.servers.ServerConnectionListener;
import com.sas.management.servers.ServerConnectionModelInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.monitor.ServerMonitorInterface;
import com.sas.management.servers.sessions.ServerSessionEvent;
import com.sas.management.servers.sessions.ServerSessionInterface;
import com.sas.management.servers.sessions.ServerSessionListener;
import com.sas.management.servers.sessions.ServerSessionModelInterface;
import com.sas.services.connection.ConnectionInterface;
import java.util.Calendar;
import java.util.Vector;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class ServerSessionModel
extends ModelImpl
implements ServerSessionModelInterface,
ServerConnectionListener {
    protected ServerMonitorInterface m_server = null;
    private ServerConnectionModelInterface m_mdlConnState = null;
    private ConnectionInterface m_cx = null;
    private ConnectionPoint m_connectionPoint = null;
    private int m_sessionEventsHandle = -1;
    private boolean m_bListenerInitialized = false;

    public ServerSessionModel(ServerMonitorInterface server) {
        this.m_server = server;
        this.m_mdlConnState = ServerFactory.getServerConnectionModel((ServerInterface)((java.lang.Object)server));
        this.m_mdlConnState.addServerConnectionListener(this);
        if (((ServerInterface)((java.lang.Object)server)).getObjectState() == 1) {
            this.initializeServerSessionEventsListener();
        }
    }

    @Override
    public synchronized void addServerSessionListener(ServerSessionListener listener) {
        this.getListenerList().add(listener);
    }

    @Override
    public synchronized void removeServerSessionListener(ServerSessionListener listener) {
        this.getListenerList().remove(listener);
    }

    @Override
    public synchronized void fireServerSessionEvent(ServerSessionEvent event) {
        Vector listenerList = new Vector();
        listenerList.addAll(this.getListenerList());
        block4: for (int listenerIndex = 0; listenerIndex < listenerList.size(); ++listenerIndex) {
            ServerSessionListener listener = (ServerSessionListener)listenerList.get(listenerIndex);
            switch (event.getType()) {
                case 0: {
                    listener.serverSessionStarted(event);
                    continue block4;
                }
                case 1: {
                    listener.serverSessionEnded(event);
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
    }

    @Override
    public void stateChanged(ServerConnectionEvent event) {
        if (event.getState() == 1) {
            this.initializeServerSessionEventsListener();
        }
        if (event.getState() == 0) {
            this.disposeServerSessionEventsListener();
        }
    }

    private synchronized void initializeServerSessionEventsListener() {
        if (this.m_bListenerInitialized) {
            return;
        }
        if (((ServerInterface)((java.lang.Object)this.m_server)).getServerConnection() == null) {
            return;
        }
        if (ServerUtil.isIOMServer((ServerInterface)((java.lang.Object)this.m_server))) {
            this.m_cx = (ConnectionInterface)((ServerInterface)((java.lang.Object)this.m_server)).getServerConnection();
            Object obj = this.m_cx.getObject();
            try {
                int i;
                IServerSessions serverSession = IServerSessionsHelper.narrow((Object)obj);
                if (serverSession == null) {
                    return;
                }
                ServerSessionEventsListener sessionEventsListener = new ServerSessionEventsListener();
                String cpidString = IServerSessionEventsHelper.id();
                int d1 = (int)Long.parseLong(cpidString.substring(4, 12), 16);
                short d2 = (short)Integer.parseInt(cpidString.substring(13, 17), 16);
                short d3 = (short)Integer.parseInt(cpidString.substring(18, 22), 16);
                byte[] d4 = new byte[8];
                for (i = 0; i < 2; ++i) {
                    d4[i] = (byte)Short.parseShort(cpidString.substring(23 + i * 2, 25 + i * 2), 16);
                }
                for (i = 0; i < 6; ++i) {
                    d4[i + 2] = (byte)Short.parseShort(cpidString.substring(28 + i * 2, 30 + i * 2), 16);
                }
                CP_ID cpid = new CP_ID(d1, d2, d3, d4);
                ConnectionPointContainer cpContainer = ConnectionPointContainerHelper.narrow((Object)serverSession);
                ConnectionPointHolder cpHolder = new ConnectionPointHolder();
                cpContainer.FindConnectionPoint(cpid, cpHolder);
                this.m_connectionPoint = cpHolder.value;
                IntHolder handleHolder = new IntHolder();
                this.m_connectionPoint.Advise((Object)sessionEventsListener, handleHolder);
                this.m_sessionEventsHandle = handleHolder.value;
            }
            catch (SystemException exc) {
                this.getLogger().severe(exc.getLocalizedMessage());
            }
        }
        this.m_bListenerInitialized = true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeServerSessionEventsListener();
        if (this.m_mdlConnState != null) {
            this.m_mdlConnState.removeServerConnectionListener(this);
            this.m_mdlConnState = null;
        }
    }

    private synchronized void disposeServerSessionEventsListener() {
        this.m_bListenerInitialized = false;
        if (((ServerInterface)((java.lang.Object)this.m_server)).getServerConnection() == null) {
            return;
        }
        if (ServerUtil.isIOMServer((ServerInterface)((java.lang.Object)this.m_server))) {
            if (this.m_connectionPoint != null) {
                this.m_connectionPoint.Unadvise(this.m_sessionEventsHandle);
            }
            this.m_connectionPoint = null;
        }
    }

    class ServerSessionEventsListener
    extends _IServerSessionEventsImplBase {
        ServerSessionEventsListener() {
        }

        public void SessionStart(UUID sessionID, String owner) {
            Calendar cdrStartTime = Calendar.getInstance();
            ServerSessionInterface session = ServerFactory.newServerSession(ServerSessionModel.this.m_server, ServerUtil.convertUUIDToString(sessionID), owner);
            session.setStartTime(cdrStartTime);
            session.setState(0);
            ServerSessionModel.this.m_server.addServerSession(session);
            ServerSessionEvent event = new ServerSessionEvent((java.lang.Object)this, 0, ServerUtil.convertUUIDToString(sessionID), owner);
            ServerSessionModel.this.fireServerSessionEvent(event);
        }

        public void SessionEnd(UUID sessionID) {
            Calendar cdrEndTime = Calendar.getInstance();
            ServerSessionInterface session = ServerFactory.getServerSessions().get(ServerUtil.convertUUIDToString(sessionID));
            if (session == null) {
                try {
                    ServerSessionInterface[] sessionArray = ServerSessionModel.this.m_server.getServerSessions();
                    for (int sessionIndex = 0; sessionIndex < sessionArray.length; ++sessionIndex) {
                        ServerSessionInterface s = sessionArray[sessionIndex];
                        if (!s.getID().equalsIgnoreCase(ServerUtil.convertUUIDToString(sessionID))) continue;
                        session = s;
                        break;
                    }
                }
                catch (ServerException sessionArray) {
                    // empty catch block
                }
            }
            session.setEndTime(cdrEndTime);
            session.setState(2);
            ServerSessionModel.this.m_server.removeServerSession(session);
            ServerSessionEvent event = new ServerSessionEvent((java.lang.Object)this, 1, ServerUtil.convertUUIDToString(sessionID), session.getOwner());
            ServerSessionModel.this.fireServerSessionEvent(event);
        }
    }
}

