/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.iom.SASIOMDefs.UUID;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.SpawnedServerInterface;
import com.sas.management.servers.impl.InstanceServerImpl;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.user.UserContextInterface;
import java.util.Properties;

public class WorkspaceInstanceServerImpl
extends InstanceServerImpl {
    private Object m_cx = null;

    public WorkspaceInstanceServerImpl(SpawnedServerInterface server, UUID uuid, MetaServerConnection metaConn, String ID, String hostID, Properties serverParms, UserContextInterface user) {
        super(server, uuid, metaConn, ID, hostID, serverParms, user);
    }

    @Override
    public void connect() throws ServerException {
        this.fireServerConnectedChanged();
        this.fireServerStateChanged();
    }

    @Override
    public void disconnect() {
        this.setServerConnection(null);
        this.cleanupUponLostConnection();
    }

    @Override
    public void stop() throws ServerException {
        this.fireServerStateChanged("StopPending");
        super.stop();
        Thread thrPoll = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WorkspaceInstanceServerImpl.this.poll(10000, 60000);
                }
                catch (ServerException exc) {
                    WorkspaceInstanceServerImpl.this.fireServerStateChanged("Stopped");
                }
            }
        });
        thrPoll.start();
    }

    @Override
    public void pause() throws ServerException {
        this.fireServerStateChanged("PausePending");
        super.pause();
        this.fireServerStateChanged("Paused");
    }

    @Override
    public void resume() throws ServerException {
        this.fireServerStateChanged("ContinuePending");
        super.resume();
        this.fireServerStateChanged("Running");
    }

    @Override
    public void quiesce() throws ServerException {
        this.fireServerStateChanged("DeferredStop");
        super.quiesce();
        Thread thrPoll = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    WorkspaceInstanceServerImpl.this.poll(10000, 60000);
                }
                catch (ServerException exc) {
                    WorkspaceInstanceServerImpl.this.fireServerStateChanged("Stopped");
                }
            }
        });
        thrPoll.start();
    }

    @Override
    public Object getServerConnection() {
        return this.m_cx;
    }

    @Override
    public void setServerConnection(Object connection) {
        this.m_cx = connection;
    }
}

