/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.WorkspaceServerInterface;
import com.sas.management.servers.impl.SpawnedServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.Properties;

public class ProcessOrchestrationServerImpl
extends SpawnedServerImpl
implements WorkspaceServerInterface {
    private String m_strHost = "localhost";
    private int m_port = 8591;
    private String m_strServerType = "Workspace";
    protected static WAdminResource bundle = new WAdminResource(ProcessOrchestrationServerImpl.class);

    public ProcessOrchestrationServerImpl(MetaServerConnection metaConn, String ID, Properties properties, UserContextInterface user) {
        super(metaConn, ID, properties, user);
        this.initialize(properties);
    }

    public ProcessOrchestrationServerImpl(MetaServerConnection metaConn, String ID, String hostID, Properties properties, UserContextInterface user) {
        super(metaConn, ID, hostID, properties, user);
        this.initialize(properties);
    }

    private void initialize(Properties properties) {
        this.initialize();
        this.setServerParms(properties);
    }

    private void initialize() {
        this.m_port = 8641;
        this.m_strServerType = "Pooled Process Orchestration";
        this.m_strHost = this.getHost();
        com.sas.management.servers.connections.ConnectionInterface[] connectionArray = this.getConnections();
        for (int connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            this.m_port = connectionArray[connIndex].getPort();
            if (this.m_port > 0) break;
        }
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
        this.initialize();
        ServerValidatorUtil.validateServerPing(this.m_strServerType, this.getLogger(), this.m_strHost, this.m_port, 1);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validateExtended() throws ServerValidatorException {
        ConnectionFactoryAdminInterface admin;
        this.initialize();
        PlatformConnectionFactoryConfiguration cxfConfig = null;
        ConnectionInterface cx = null;
        try {
            LogicalServerInterface logicalServer = this.getInfoLogicalServer();
            cxfConfig = new PlatformConnectionFactoryConfiguration(logicalServer, ServerUtil.getServerURI(this), this.m_strHost, this.m_port, false);
            cx = ServerValidatorUtil.validateIOMServerMakeConnection((ConnectionFactoryConfiguration)cxfConfig, this.m_strServerType, this.getUserContext(), this.getLogger(), 1);
            admin = null;
        }
        catch (ServiceException exc) {
            try {
                throw this.logServerValidatorException(exc, "Extended", 1);
                catch (RemoteException exc2) {
                    throw this.logServerValidatorException(exc2, "Extended", 1);
                }
            }
            catch (Throwable throwable) {
                ConnectionFactoryAdminInterface admin2 = null;
                try {
                    PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory(cxfConfig);
                    admin2 = cxf.getAdminInterface();
                    throw throwable;
                }
                catch (ConnectionFactoryException exc3) {
                    throw this.logServerValidatorException(exc3, "Extended", 1);
                }
                finally {
                    if (cx != null) {
                        cx.close();
                    }
                    if (admin2 != null) {
                        admin2.shutdown();
                    }
                }
            }
        }
        try {
            PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            admin = cxf.getAdminInterface();
            return;
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerValidatorException(exc, "Extended", 1);
        }
        finally {
            if (cx != null) {
                cx.close();
            }
            if (admin != null) {
                admin.shutdown();
            }
        }
    }

    @Override
    public void setServerParms(Properties serverParms) {
        super.setServerParms(serverParms);
        if (this.getServerParms() == null) {
            return;
        }
        if (this.getMetaConnection() == null) {
            String strPort;
            String strHost = (String)this.getServerParms().get("host");
            if (strHost != null) {
                this.m_strHost = strHost;
            }
            if ((strPort = (String)this.getServerParms().get("port")) != null) {
                this.m_port = Integer.valueOf(strPort);
            }
        }
    }
}

