/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.servers.impl.IOMLogicalServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.Properties;

public class MetadataLogicalServerImpl
extends IOMLogicalServerImpl {
    protected static WAdminResource bundle = new WAdminResource(MetadataLogicalServerImpl.class);

    public MetadataLogicalServerImpl(MetaServerConnection metaConn, String ID, Properties properties, UserContextInterface user) {
        super(metaConn, ID, properties, user);
        this.setServerParms(properties);
    }

    @Override
    public void validateSimple() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validateExtended() throws ServerValidatorException {
        ConnectionFactoryAdminInterface admin;
        PlatformConnectionFactoryConfiguration cxfConfig = null;
        ConnectionInterface cx = null;
        try {
            LogicalServerInterface logicalServer = this.getInfoLogicalServer();
            cxfConfig = new PlatformConnectionFactoryConfiguration(logicalServer);
            cx = ServerValidatorUtil.validateIOMServerMakeConnection((ConnectionFactoryConfiguration)cxfConfig, "Metadata", this.getUserContext(), this.getLogger(), 1);
            ServerValidatorUtil.validateMetadataServerGetRepositories(cx, this.getLogger(), 2);
            admin = null;
        }
        catch (ServiceException exc) {
            try {
                throw this.logServerValidatorException(exc, "Extended", 1);
                catch (RemoteException exc2) {
                    throw this.logServerValidatorException(exc2, "Extended", 1);
                }
            }
            catch (Throwable throwable) {
                ConnectionFactoryAdminInterface admin2 = null;
                try {
                    PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory(cxfConfig);
                    admin2 = cxf.getAdminInterface();
                    throw throwable;
                }
                catch (ConnectionFactoryException exc3) {
                    throw this.logServerValidatorException(exc3, "Extended", 1);
                }
                finally {
                    if (cx != null) {
                        cx.close();
                    }
                    if (admin2 != null) {
                        admin2.shutdown();
                    }
                }
            }
        }
        try {
            PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            admin = cxf.getAdminInterface();
            return;
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerValidatorException(exc, "Extended", 1);
        }
        finally {
            if (cx != null) {
                cx.close();
            }
            if (admin != null) {
                admin.shutdown();
            }
        }
    }
}

